/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ServerOnNetwork is the corresponding interface of ServerOnNetwork
type ServerOnNetwork interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRecordId returns RecordId (property field)
	GetRecordId() uint32
	// GetServerName returns ServerName (property field)
	GetServerName() PascalString
	// GetDiscoveryUrl returns DiscoveryUrl (property field)
	GetDiscoveryUrl() PascalString
	// GetServerCapabilities returns ServerCapabilities (property field)
	GetServerCapabilities() []PascalString
	// IsServerOnNetwork is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsServerOnNetwork()
	// CreateBuilder creates a ServerOnNetworkBuilder
	CreateServerOnNetworkBuilder() ServerOnNetworkBuilder
}

// _ServerOnNetwork is the data-structure of this message
type _ServerOnNetwork struct {
	ExtensionObjectDefinitionContract
	RecordId           uint32
	ServerName         PascalString
	DiscoveryUrl       PascalString
	ServerCapabilities []PascalString
}

var _ ServerOnNetwork = (*_ServerOnNetwork)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ServerOnNetwork)(nil)

// NewServerOnNetwork factory function for _ServerOnNetwork
func NewServerOnNetwork(recordId uint32, serverName PascalString, discoveryUrl PascalString, serverCapabilities []PascalString) *_ServerOnNetwork {
	if serverName == nil {
		panic("serverName of type PascalString for ServerOnNetwork must not be nil")
	}
	if discoveryUrl == nil {
		panic("discoveryUrl of type PascalString for ServerOnNetwork must not be nil")
	}
	_result := &_ServerOnNetwork{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RecordId:                          recordId,
		ServerName:                        serverName,
		DiscoveryUrl:                      discoveryUrl,
		ServerCapabilities:                serverCapabilities,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ServerOnNetworkBuilder is a builder for ServerOnNetwork
type ServerOnNetworkBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(recordId uint32, serverName PascalString, discoveryUrl PascalString, serverCapabilities []PascalString) ServerOnNetworkBuilder
	// WithRecordId adds RecordId (property field)
	WithRecordId(uint32) ServerOnNetworkBuilder
	// WithServerName adds ServerName (property field)
	WithServerName(PascalString) ServerOnNetworkBuilder
	// WithServerNameBuilder adds ServerName (property field) which is build by the builder
	WithServerNameBuilder(func(PascalStringBuilder) PascalStringBuilder) ServerOnNetworkBuilder
	// WithDiscoveryUrl adds DiscoveryUrl (property field)
	WithDiscoveryUrl(PascalString) ServerOnNetworkBuilder
	// WithDiscoveryUrlBuilder adds DiscoveryUrl (property field) which is build by the builder
	WithDiscoveryUrlBuilder(func(PascalStringBuilder) PascalStringBuilder) ServerOnNetworkBuilder
	// WithServerCapabilities adds ServerCapabilities (property field)
	WithServerCapabilities(...PascalString) ServerOnNetworkBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ServerOnNetwork or returns an error if something is wrong
	Build() (ServerOnNetwork, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ServerOnNetwork
}

// NewServerOnNetworkBuilder() creates a ServerOnNetworkBuilder
func NewServerOnNetworkBuilder() ServerOnNetworkBuilder {
	return &_ServerOnNetworkBuilder{_ServerOnNetwork: new(_ServerOnNetwork)}
}

type _ServerOnNetworkBuilder struct {
	*_ServerOnNetwork

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ServerOnNetworkBuilder) = (*_ServerOnNetworkBuilder)(nil)

func (b *_ServerOnNetworkBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ServerOnNetwork
}

func (b *_ServerOnNetworkBuilder) WithMandatoryFields(recordId uint32, serverName PascalString, discoveryUrl PascalString, serverCapabilities []PascalString) ServerOnNetworkBuilder {
	return b.WithRecordId(recordId).WithServerName(serverName).WithDiscoveryUrl(discoveryUrl).WithServerCapabilities(serverCapabilities...)
}

func (b *_ServerOnNetworkBuilder) WithRecordId(recordId uint32) ServerOnNetworkBuilder {
	b.RecordId = recordId
	return b
}

func (b *_ServerOnNetworkBuilder) WithServerName(serverName PascalString) ServerOnNetworkBuilder {
	b.ServerName = serverName
	return b
}

func (b *_ServerOnNetworkBuilder) WithServerNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ServerOnNetworkBuilder {
	builder := builderSupplier(b.ServerName.CreatePascalStringBuilder())
	var err error
	b.ServerName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ServerOnNetworkBuilder) WithDiscoveryUrl(discoveryUrl PascalString) ServerOnNetworkBuilder {
	b.DiscoveryUrl = discoveryUrl
	return b
}

func (b *_ServerOnNetworkBuilder) WithDiscoveryUrlBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ServerOnNetworkBuilder {
	builder := builderSupplier(b.DiscoveryUrl.CreatePascalStringBuilder())
	var err error
	b.DiscoveryUrl, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ServerOnNetworkBuilder) WithServerCapabilities(serverCapabilities ...PascalString) ServerOnNetworkBuilder {
	b.ServerCapabilities = serverCapabilities
	return b
}

func (b *_ServerOnNetworkBuilder) Build() (ServerOnNetwork, error) {
	if b.ServerName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'serverName' not set"))
	}
	if b.DiscoveryUrl == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'discoveryUrl' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ServerOnNetwork.deepCopy(), nil
}

func (b *_ServerOnNetworkBuilder) MustBuild() ServerOnNetwork {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ServerOnNetworkBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ServerOnNetworkBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ServerOnNetworkBuilder) DeepCopy() any {
	_copy := b.CreateServerOnNetworkBuilder().(*_ServerOnNetworkBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateServerOnNetworkBuilder creates a ServerOnNetworkBuilder
func (b *_ServerOnNetwork) CreateServerOnNetworkBuilder() ServerOnNetworkBuilder {
	if b == nil {
		return NewServerOnNetworkBuilder()
	}
	return &_ServerOnNetworkBuilder{_ServerOnNetwork: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ServerOnNetwork) GetExtensionId() int32 {
	return int32(12191)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ServerOnNetwork) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ServerOnNetwork) GetRecordId() uint32 {
	return m.RecordId
}

func (m *_ServerOnNetwork) GetServerName() PascalString {
	return m.ServerName
}

func (m *_ServerOnNetwork) GetDiscoveryUrl() PascalString {
	return m.DiscoveryUrl
}

func (m *_ServerOnNetwork) GetServerCapabilities() []PascalString {
	return m.ServerCapabilities
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastServerOnNetwork(structType any) ServerOnNetwork {
	if casted, ok := structType.(ServerOnNetwork); ok {
		return casted
	}
	if casted, ok := structType.(*ServerOnNetwork); ok {
		return *casted
	}
	return nil
}

func (m *_ServerOnNetwork) GetTypeName() string {
	return "ServerOnNetwork"
}

func (m *_ServerOnNetwork) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (recordId)
	lengthInBits += 32

	// Simple field (serverName)
	lengthInBits += m.ServerName.GetLengthInBits(ctx)

	// Simple field (discoveryUrl)
	lengthInBits += m.DiscoveryUrl.GetLengthInBits(ctx)

	// Implicit Field (noOfServerCapabilities)
	lengthInBits += 32

	// Array field
	if len(m.ServerCapabilities) > 0 {
		for _curItem, element := range m.ServerCapabilities {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerCapabilities), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ServerOnNetwork) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ServerOnNetwork) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__serverOnNetwork ServerOnNetwork, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ServerOnNetwork"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ServerOnNetwork")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	recordId, err := ReadSimpleField(ctx, "recordId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recordId' field"))
	}
	m.RecordId = recordId

	serverName, err := ReadSimpleField[PascalString](ctx, "serverName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverName' field"))
	}
	m.ServerName = serverName

	discoveryUrl, err := ReadSimpleField[PascalString](ctx, "discoveryUrl", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discoveryUrl' field"))
	}
	m.DiscoveryUrl = discoveryUrl

	noOfServerCapabilities, err := ReadImplicitField[int32](ctx, "noOfServerCapabilities", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfServerCapabilities' field"))
	}
	_ = noOfServerCapabilities

	serverCapabilities, err := ReadCountArrayField[PascalString](ctx, "serverCapabilities", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfServerCapabilities))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverCapabilities' field"))
	}
	m.ServerCapabilities = serverCapabilities

	if closeErr := readBuffer.CloseContext("ServerOnNetwork"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ServerOnNetwork")
	}

	return m, nil
}

func (m *_ServerOnNetwork) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ServerOnNetwork) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ServerOnNetwork"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ServerOnNetwork")
		}

		if err := WriteSimpleField[uint32](ctx, "recordId", m.GetRecordId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'recordId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "serverName", m.GetServerName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'serverName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "discoveryUrl", m.GetDiscoveryUrl(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'discoveryUrl' field")
		}
		noOfServerCapabilities := int32(utils.InlineIf(bool((m.GetServerCapabilities()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetServerCapabilities()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfServerCapabilities", noOfServerCapabilities, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfServerCapabilities' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "serverCapabilities", m.GetServerCapabilities(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'serverCapabilities' field")
		}

		if popErr := writeBuffer.PopContext("ServerOnNetwork"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ServerOnNetwork")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ServerOnNetwork) IsServerOnNetwork() {}

func (m *_ServerOnNetwork) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ServerOnNetwork) deepCopy() *_ServerOnNetwork {
	if m == nil {
		return nil
	}
	_ServerOnNetworkCopy := &_ServerOnNetwork{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.RecordId,
		utils.DeepCopy[PascalString](m.ServerName),
		utils.DeepCopy[PascalString](m.DiscoveryUrl),
		utils.DeepCopySlice[PascalString, PascalString](m.ServerCapabilities),
	}
	_ServerOnNetworkCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ServerOnNetworkCopy
}

func (m *_ServerOnNetwork) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
