/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SequenceHeader is the corresponding interface of SequenceHeader
type SequenceHeader interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetSequenceNumber returns SequenceNumber (property field)
	GetSequenceNumber() int32
	// GetRequestId returns RequestId (property field)
	GetRequestId() int32
	// IsSequenceHeader is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSequenceHeader()
	// CreateBuilder creates a SequenceHeaderBuilder
	CreateSequenceHeaderBuilder() SequenceHeaderBuilder
}

// _SequenceHeader is the data-structure of this message
type _SequenceHeader struct {
	SequenceNumber int32
	RequestId      int32
}

var _ SequenceHeader = (*_SequenceHeader)(nil)

// NewSequenceHeader factory function for _SequenceHeader
func NewSequenceHeader(sequenceNumber int32, requestId int32) *_SequenceHeader {
	return &_SequenceHeader{SequenceNumber: sequenceNumber, RequestId: requestId}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SequenceHeaderBuilder is a builder for SequenceHeader
type SequenceHeaderBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(sequenceNumber int32, requestId int32) SequenceHeaderBuilder
	// WithSequenceNumber adds SequenceNumber (property field)
	WithSequenceNumber(int32) SequenceHeaderBuilder
	// WithRequestId adds RequestId (property field)
	WithRequestId(int32) SequenceHeaderBuilder
	// Build builds the SequenceHeader or returns an error if something is wrong
	Build() (SequenceHeader, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SequenceHeader
}

// NewSequenceHeaderBuilder() creates a SequenceHeaderBuilder
func NewSequenceHeaderBuilder() SequenceHeaderBuilder {
	return &_SequenceHeaderBuilder{_SequenceHeader: new(_SequenceHeader)}
}

type _SequenceHeaderBuilder struct {
	*_SequenceHeader

	err *utils.MultiError
}

var _ (SequenceHeaderBuilder) = (*_SequenceHeaderBuilder)(nil)

func (b *_SequenceHeaderBuilder) WithMandatoryFields(sequenceNumber int32, requestId int32) SequenceHeaderBuilder {
	return b.WithSequenceNumber(sequenceNumber).WithRequestId(requestId)
}

func (b *_SequenceHeaderBuilder) WithSequenceNumber(sequenceNumber int32) SequenceHeaderBuilder {
	b.SequenceNumber = sequenceNumber
	return b
}

func (b *_SequenceHeaderBuilder) WithRequestId(requestId int32) SequenceHeaderBuilder {
	b.RequestId = requestId
	return b
}

func (b *_SequenceHeaderBuilder) Build() (SequenceHeader, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SequenceHeader.deepCopy(), nil
}

func (b *_SequenceHeaderBuilder) MustBuild() SequenceHeader {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SequenceHeaderBuilder) DeepCopy() any {
	_copy := b.CreateSequenceHeaderBuilder().(*_SequenceHeaderBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSequenceHeaderBuilder creates a SequenceHeaderBuilder
func (b *_SequenceHeader) CreateSequenceHeaderBuilder() SequenceHeaderBuilder {
	if b == nil {
		return NewSequenceHeaderBuilder()
	}
	return &_SequenceHeaderBuilder{_SequenceHeader: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SequenceHeader) GetSequenceNumber() int32 {
	return m.SequenceNumber
}

func (m *_SequenceHeader) GetRequestId() int32 {
	return m.RequestId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSequenceHeader(structType any) SequenceHeader {
	if casted, ok := structType.(SequenceHeader); ok {
		return casted
	}
	if casted, ok := structType.(*SequenceHeader); ok {
		return *casted
	}
	return nil
}

func (m *_SequenceHeader) GetTypeName() string {
	return "SequenceHeader"
}

func (m *_SequenceHeader) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (sequenceNumber)
	lengthInBits += 32

	// Simple field (requestId)
	lengthInBits += 32

	return lengthInBits
}

func (m *_SequenceHeader) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func SequenceHeaderParse(ctx context.Context, theBytes []byte) (SequenceHeader, error) {
	return SequenceHeaderParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func SequenceHeaderParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (SequenceHeader, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (SequenceHeader, error) {
		return SequenceHeaderParseWithBuffer(ctx, readBuffer)
	}
}

func SequenceHeaderParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (SequenceHeader, error) {
	v, err := (&_SequenceHeader{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_SequenceHeader) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__sequenceHeader SequenceHeader, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SequenceHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SequenceHeader")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	sequenceNumber, err := ReadSimpleField(ctx, "sequenceNumber", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sequenceNumber' field"))
	}
	m.SequenceNumber = sequenceNumber

	requestId, err := ReadSimpleField(ctx, "requestId", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestId' field"))
	}
	m.RequestId = requestId

	if closeErr := readBuffer.CloseContext("SequenceHeader"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SequenceHeader")
	}

	return m, nil
}

func (m *_SequenceHeader) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SequenceHeader) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("SequenceHeader"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for SequenceHeader")
	}

	if err := WriteSimpleField[int32](ctx, "sequenceNumber", m.GetSequenceNumber(), WriteSignedInt(writeBuffer, 32)); err != nil {
		return errors.Wrap(err, "Error serializing 'sequenceNumber' field")
	}

	if err := WriteSimpleField[int32](ctx, "requestId", m.GetRequestId(), WriteSignedInt(writeBuffer, 32)); err != nil {
		return errors.Wrap(err, "Error serializing 'requestId' field")
	}

	if popErr := writeBuffer.PopContext("SequenceHeader"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for SequenceHeader")
	}
	return nil
}

func (m *_SequenceHeader) IsSequenceHeader() {}

func (m *_SequenceHeader) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SequenceHeader) deepCopy() *_SequenceHeader {
	if m == nil {
		return nil
	}
	_SequenceHeaderCopy := &_SequenceHeader{
		m.SequenceNumber,
		m.RequestId,
	}
	return _SequenceHeaderCopy
}

func (m *_SequenceHeader) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
