/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SamplingIntervalDiagnosticsDataType is the corresponding interface of SamplingIntervalDiagnosticsDataType
type SamplingIntervalDiagnosticsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSamplingInterval returns SamplingInterval (property field)
	GetSamplingInterval() float64
	// GetMonitoredItemCount returns MonitoredItemCount (property field)
	GetMonitoredItemCount() uint32
	// GetMaxMonitoredItemCount returns MaxMonitoredItemCount (property field)
	GetMaxMonitoredItemCount() uint32
	// GetDisabledMonitoredItemCount returns DisabledMonitoredItemCount (property field)
	GetDisabledMonitoredItemCount() uint32
	// IsSamplingIntervalDiagnosticsDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSamplingIntervalDiagnosticsDataType()
	// CreateBuilder creates a SamplingIntervalDiagnosticsDataTypeBuilder
	CreateSamplingIntervalDiagnosticsDataTypeBuilder() SamplingIntervalDiagnosticsDataTypeBuilder
}

// _SamplingIntervalDiagnosticsDataType is the data-structure of this message
type _SamplingIntervalDiagnosticsDataType struct {
	ExtensionObjectDefinitionContract
	SamplingInterval           float64
	MonitoredItemCount         uint32
	MaxMonitoredItemCount      uint32
	DisabledMonitoredItemCount uint32
}

var _ SamplingIntervalDiagnosticsDataType = (*_SamplingIntervalDiagnosticsDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_SamplingIntervalDiagnosticsDataType)(nil)

// NewSamplingIntervalDiagnosticsDataType factory function for _SamplingIntervalDiagnosticsDataType
func NewSamplingIntervalDiagnosticsDataType(samplingInterval float64, monitoredItemCount uint32, maxMonitoredItemCount uint32, disabledMonitoredItemCount uint32) *_SamplingIntervalDiagnosticsDataType {
	_result := &_SamplingIntervalDiagnosticsDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		SamplingInterval:                  samplingInterval,
		MonitoredItemCount:                monitoredItemCount,
		MaxMonitoredItemCount:             maxMonitoredItemCount,
		DisabledMonitoredItemCount:        disabledMonitoredItemCount,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SamplingIntervalDiagnosticsDataTypeBuilder is a builder for SamplingIntervalDiagnosticsDataType
type SamplingIntervalDiagnosticsDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(samplingInterval float64, monitoredItemCount uint32, maxMonitoredItemCount uint32, disabledMonitoredItemCount uint32) SamplingIntervalDiagnosticsDataTypeBuilder
	// WithSamplingInterval adds SamplingInterval (property field)
	WithSamplingInterval(float64) SamplingIntervalDiagnosticsDataTypeBuilder
	// WithMonitoredItemCount adds MonitoredItemCount (property field)
	WithMonitoredItemCount(uint32) SamplingIntervalDiagnosticsDataTypeBuilder
	// WithMaxMonitoredItemCount adds MaxMonitoredItemCount (property field)
	WithMaxMonitoredItemCount(uint32) SamplingIntervalDiagnosticsDataTypeBuilder
	// WithDisabledMonitoredItemCount adds DisabledMonitoredItemCount (property field)
	WithDisabledMonitoredItemCount(uint32) SamplingIntervalDiagnosticsDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the SamplingIntervalDiagnosticsDataType or returns an error if something is wrong
	Build() (SamplingIntervalDiagnosticsDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SamplingIntervalDiagnosticsDataType
}

// NewSamplingIntervalDiagnosticsDataTypeBuilder() creates a SamplingIntervalDiagnosticsDataTypeBuilder
func NewSamplingIntervalDiagnosticsDataTypeBuilder() SamplingIntervalDiagnosticsDataTypeBuilder {
	return &_SamplingIntervalDiagnosticsDataTypeBuilder{_SamplingIntervalDiagnosticsDataType: new(_SamplingIntervalDiagnosticsDataType)}
}

type _SamplingIntervalDiagnosticsDataTypeBuilder struct {
	*_SamplingIntervalDiagnosticsDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (SamplingIntervalDiagnosticsDataTypeBuilder) = (*_SamplingIntervalDiagnosticsDataTypeBuilder)(nil)

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._SamplingIntervalDiagnosticsDataType
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) WithMandatoryFields(samplingInterval float64, monitoredItemCount uint32, maxMonitoredItemCount uint32, disabledMonitoredItemCount uint32) SamplingIntervalDiagnosticsDataTypeBuilder {
	return b.WithSamplingInterval(samplingInterval).WithMonitoredItemCount(monitoredItemCount).WithMaxMonitoredItemCount(maxMonitoredItemCount).WithDisabledMonitoredItemCount(disabledMonitoredItemCount)
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) WithSamplingInterval(samplingInterval float64) SamplingIntervalDiagnosticsDataTypeBuilder {
	b.SamplingInterval = samplingInterval
	return b
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) WithMonitoredItemCount(monitoredItemCount uint32) SamplingIntervalDiagnosticsDataTypeBuilder {
	b.MonitoredItemCount = monitoredItemCount
	return b
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) WithMaxMonitoredItemCount(maxMonitoredItemCount uint32) SamplingIntervalDiagnosticsDataTypeBuilder {
	b.MaxMonitoredItemCount = maxMonitoredItemCount
	return b
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) WithDisabledMonitoredItemCount(disabledMonitoredItemCount uint32) SamplingIntervalDiagnosticsDataTypeBuilder {
	b.DisabledMonitoredItemCount = disabledMonitoredItemCount
	return b
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) Build() (SamplingIntervalDiagnosticsDataType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SamplingIntervalDiagnosticsDataType.deepCopy(), nil
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) MustBuild() SamplingIntervalDiagnosticsDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_SamplingIntervalDiagnosticsDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateSamplingIntervalDiagnosticsDataTypeBuilder().(*_SamplingIntervalDiagnosticsDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSamplingIntervalDiagnosticsDataTypeBuilder creates a SamplingIntervalDiagnosticsDataTypeBuilder
func (b *_SamplingIntervalDiagnosticsDataType) CreateSamplingIntervalDiagnosticsDataTypeBuilder() SamplingIntervalDiagnosticsDataTypeBuilder {
	if b == nil {
		return NewSamplingIntervalDiagnosticsDataTypeBuilder()
	}
	return &_SamplingIntervalDiagnosticsDataTypeBuilder{_SamplingIntervalDiagnosticsDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SamplingIntervalDiagnosticsDataType) GetExtensionId() int32 {
	return int32(858)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SamplingIntervalDiagnosticsDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SamplingIntervalDiagnosticsDataType) GetSamplingInterval() float64 {
	return m.SamplingInterval
}

func (m *_SamplingIntervalDiagnosticsDataType) GetMonitoredItemCount() uint32 {
	return m.MonitoredItemCount
}

func (m *_SamplingIntervalDiagnosticsDataType) GetMaxMonitoredItemCount() uint32 {
	return m.MaxMonitoredItemCount
}

func (m *_SamplingIntervalDiagnosticsDataType) GetDisabledMonitoredItemCount() uint32 {
	return m.DisabledMonitoredItemCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSamplingIntervalDiagnosticsDataType(structType any) SamplingIntervalDiagnosticsDataType {
	if casted, ok := structType.(SamplingIntervalDiagnosticsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*SamplingIntervalDiagnosticsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_SamplingIntervalDiagnosticsDataType) GetTypeName() string {
	return "SamplingIntervalDiagnosticsDataType"
}

func (m *_SamplingIntervalDiagnosticsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (samplingInterval)
	lengthInBits += 64

	// Simple field (monitoredItemCount)
	lengthInBits += 32

	// Simple field (maxMonitoredItemCount)
	lengthInBits += 32

	// Simple field (disabledMonitoredItemCount)
	lengthInBits += 32

	return lengthInBits
}

func (m *_SamplingIntervalDiagnosticsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SamplingIntervalDiagnosticsDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__samplingIntervalDiagnosticsDataType SamplingIntervalDiagnosticsDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SamplingIntervalDiagnosticsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SamplingIntervalDiagnosticsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	samplingInterval, err := ReadSimpleField(ctx, "samplingInterval", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'samplingInterval' field"))
	}
	m.SamplingInterval = samplingInterval

	monitoredItemCount, err := ReadSimpleField(ctx, "monitoredItemCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'monitoredItemCount' field"))
	}
	m.MonitoredItemCount = monitoredItemCount

	maxMonitoredItemCount, err := ReadSimpleField(ctx, "maxMonitoredItemCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maxMonitoredItemCount' field"))
	}
	m.MaxMonitoredItemCount = maxMonitoredItemCount

	disabledMonitoredItemCount, err := ReadSimpleField(ctx, "disabledMonitoredItemCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'disabledMonitoredItemCount' field"))
	}
	m.DisabledMonitoredItemCount = disabledMonitoredItemCount

	if closeErr := readBuffer.CloseContext("SamplingIntervalDiagnosticsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SamplingIntervalDiagnosticsDataType")
	}

	return m, nil
}

func (m *_SamplingIntervalDiagnosticsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SamplingIntervalDiagnosticsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SamplingIntervalDiagnosticsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SamplingIntervalDiagnosticsDataType")
		}

		if err := WriteSimpleField[float64](ctx, "samplingInterval", m.GetSamplingInterval(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'samplingInterval' field")
		}

		if err := WriteSimpleField[uint32](ctx, "monitoredItemCount", m.GetMonitoredItemCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'monitoredItemCount' field")
		}

		if err := WriteSimpleField[uint32](ctx, "maxMonitoredItemCount", m.GetMaxMonitoredItemCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'maxMonitoredItemCount' field")
		}

		if err := WriteSimpleField[uint32](ctx, "disabledMonitoredItemCount", m.GetDisabledMonitoredItemCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'disabledMonitoredItemCount' field")
		}

		if popErr := writeBuffer.PopContext("SamplingIntervalDiagnosticsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SamplingIntervalDiagnosticsDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SamplingIntervalDiagnosticsDataType) IsSamplingIntervalDiagnosticsDataType() {}

func (m *_SamplingIntervalDiagnosticsDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SamplingIntervalDiagnosticsDataType) deepCopy() *_SamplingIntervalDiagnosticsDataType {
	if m == nil {
		return nil
	}
	_SamplingIntervalDiagnosticsDataTypeCopy := &_SamplingIntervalDiagnosticsDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.SamplingInterval,
		m.MonitoredItemCount,
		m.MaxMonitoredItemCount,
		m.DisabledMonitoredItemCount,
	}
	_SamplingIntervalDiagnosticsDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _SamplingIntervalDiagnosticsDataTypeCopy
}

func (m *_SamplingIntervalDiagnosticsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
