/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// RegisterServerResponse is the corresponding interface of RegisterServerResponse
type RegisterServerResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetResponseHeader returns ResponseHeader (property field)
	GetResponseHeader() ResponseHeader
	// IsRegisterServerResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsRegisterServerResponse()
	// CreateBuilder creates a RegisterServerResponseBuilder
	CreateRegisterServerResponseBuilder() RegisterServerResponseBuilder
}

// _RegisterServerResponse is the data-structure of this message
type _RegisterServerResponse struct {
	ExtensionObjectDefinitionContract
	ResponseHeader ResponseHeader
}

var _ RegisterServerResponse = (*_RegisterServerResponse)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_RegisterServerResponse)(nil)

// NewRegisterServerResponse factory function for _RegisterServerResponse
func NewRegisterServerResponse(responseHeader ResponseHeader) *_RegisterServerResponse {
	if responseHeader == nil {
		panic("responseHeader of type ResponseHeader for RegisterServerResponse must not be nil")
	}
	_result := &_RegisterServerResponse{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ResponseHeader:                    responseHeader,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// RegisterServerResponseBuilder is a builder for RegisterServerResponse
type RegisterServerResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(responseHeader ResponseHeader) RegisterServerResponseBuilder
	// WithResponseHeader adds ResponseHeader (property field)
	WithResponseHeader(ResponseHeader) RegisterServerResponseBuilder
	// WithResponseHeaderBuilder adds ResponseHeader (property field) which is build by the builder
	WithResponseHeaderBuilder(func(ResponseHeaderBuilder) ResponseHeaderBuilder) RegisterServerResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the RegisterServerResponse or returns an error if something is wrong
	Build() (RegisterServerResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() RegisterServerResponse
}

// NewRegisterServerResponseBuilder() creates a RegisterServerResponseBuilder
func NewRegisterServerResponseBuilder() RegisterServerResponseBuilder {
	return &_RegisterServerResponseBuilder{_RegisterServerResponse: new(_RegisterServerResponse)}
}

type _RegisterServerResponseBuilder struct {
	*_RegisterServerResponse

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (RegisterServerResponseBuilder) = (*_RegisterServerResponseBuilder)(nil)

func (b *_RegisterServerResponseBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._RegisterServerResponse
}

func (b *_RegisterServerResponseBuilder) WithMandatoryFields(responseHeader ResponseHeader) RegisterServerResponseBuilder {
	return b.WithResponseHeader(responseHeader)
}

func (b *_RegisterServerResponseBuilder) WithResponseHeader(responseHeader ResponseHeader) RegisterServerResponseBuilder {
	b.ResponseHeader = responseHeader
	return b
}

func (b *_RegisterServerResponseBuilder) WithResponseHeaderBuilder(builderSupplier func(ResponseHeaderBuilder) ResponseHeaderBuilder) RegisterServerResponseBuilder {
	builder := builderSupplier(b.ResponseHeader.CreateResponseHeaderBuilder())
	var err error
	b.ResponseHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ResponseHeaderBuilder failed"))
	}
	return b
}

func (b *_RegisterServerResponseBuilder) Build() (RegisterServerResponse, error) {
	if b.ResponseHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'responseHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._RegisterServerResponse.deepCopy(), nil
}

func (b *_RegisterServerResponseBuilder) MustBuild() RegisterServerResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_RegisterServerResponseBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_RegisterServerResponseBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_RegisterServerResponseBuilder) DeepCopy() any {
	_copy := b.CreateRegisterServerResponseBuilder().(*_RegisterServerResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateRegisterServerResponseBuilder creates a RegisterServerResponseBuilder
func (b *_RegisterServerResponse) CreateRegisterServerResponseBuilder() RegisterServerResponseBuilder {
	if b == nil {
		return NewRegisterServerResponseBuilder()
	}
	return &_RegisterServerResponseBuilder{_RegisterServerResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_RegisterServerResponse) GetExtensionId() int32 {
	return int32(440)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RegisterServerResponse) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_RegisterServerResponse) GetResponseHeader() ResponseHeader {
	return m.ResponseHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastRegisterServerResponse(structType any) RegisterServerResponse {
	if casted, ok := structType.(RegisterServerResponse); ok {
		return casted
	}
	if casted, ok := structType.(*RegisterServerResponse); ok {
		return *casted
	}
	return nil
}

func (m *_RegisterServerResponse) GetTypeName() string {
	return "RegisterServerResponse"
}

func (m *_RegisterServerResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (responseHeader)
	lengthInBits += m.ResponseHeader.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_RegisterServerResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_RegisterServerResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__registerServerResponse RegisterServerResponse, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("RegisterServerResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RegisterServerResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	responseHeader, err := ReadSimpleField[ResponseHeader](ctx, "responseHeader", ReadComplex[ResponseHeader](ExtensionObjectDefinitionParseWithBufferProducer[ResponseHeader]((int32)(int32(394))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'responseHeader' field"))
	}
	m.ResponseHeader = responseHeader

	if closeErr := readBuffer.CloseContext("RegisterServerResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RegisterServerResponse")
	}

	return m, nil
}

func (m *_RegisterServerResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RegisterServerResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RegisterServerResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RegisterServerResponse")
		}

		if err := WriteSimpleField[ResponseHeader](ctx, "responseHeader", m.GetResponseHeader(), WriteComplex[ResponseHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'responseHeader' field")
		}

		if popErr := writeBuffer.PopContext("RegisterServerResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RegisterServerResponse")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RegisterServerResponse) IsRegisterServerResponse() {}

func (m *_RegisterServerResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_RegisterServerResponse) deepCopy() *_RegisterServerResponse {
	if m == nil {
		return nil
	}
	_RegisterServerResponseCopy := &_RegisterServerResponse{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[ResponseHeader](m.ResponseHeader),
	}
	_RegisterServerResponseCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _RegisterServerResponseCopy
}

func (m *_RegisterServerResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
