/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReferenceListEntryDataType is the corresponding interface of ReferenceListEntryDataType
type ReferenceListEntryDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetReferenceType returns ReferenceType (property field)
	GetReferenceType() NodeId
	// GetIsForward returns IsForward (property field)
	GetIsForward() bool
	// GetTargetNode returns TargetNode (property field)
	GetTargetNode() ExpandedNodeId
	// IsReferenceListEntryDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReferenceListEntryDataType()
	// CreateBuilder creates a ReferenceListEntryDataTypeBuilder
	CreateReferenceListEntryDataTypeBuilder() ReferenceListEntryDataTypeBuilder
}

// _ReferenceListEntryDataType is the data-structure of this message
type _ReferenceListEntryDataType struct {
	ExtensionObjectDefinitionContract
	ReferenceType NodeId
	IsForward     bool
	TargetNode    ExpandedNodeId
	// Reserved Fields
	reservedField0 *uint8
}

var _ ReferenceListEntryDataType = (*_ReferenceListEntryDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReferenceListEntryDataType)(nil)

// NewReferenceListEntryDataType factory function for _ReferenceListEntryDataType
func NewReferenceListEntryDataType(referenceType NodeId, isForward bool, targetNode ExpandedNodeId) *_ReferenceListEntryDataType {
	if referenceType == nil {
		panic("referenceType of type NodeId for ReferenceListEntryDataType must not be nil")
	}
	if targetNode == nil {
		panic("targetNode of type ExpandedNodeId for ReferenceListEntryDataType must not be nil")
	}
	_result := &_ReferenceListEntryDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ReferenceType:                     referenceType,
		IsForward:                         isForward,
		TargetNode:                        targetNode,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReferenceListEntryDataTypeBuilder is a builder for ReferenceListEntryDataType
type ReferenceListEntryDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(referenceType NodeId, isForward bool, targetNode ExpandedNodeId) ReferenceListEntryDataTypeBuilder
	// WithReferenceType adds ReferenceType (property field)
	WithReferenceType(NodeId) ReferenceListEntryDataTypeBuilder
	// WithReferenceTypeBuilder adds ReferenceType (property field) which is build by the builder
	WithReferenceTypeBuilder(func(NodeIdBuilder) NodeIdBuilder) ReferenceListEntryDataTypeBuilder
	// WithIsForward adds IsForward (property field)
	WithIsForward(bool) ReferenceListEntryDataTypeBuilder
	// WithTargetNode adds TargetNode (property field)
	WithTargetNode(ExpandedNodeId) ReferenceListEntryDataTypeBuilder
	// WithTargetNodeBuilder adds TargetNode (property field) which is build by the builder
	WithTargetNodeBuilder(func(ExpandedNodeIdBuilder) ExpandedNodeIdBuilder) ReferenceListEntryDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReferenceListEntryDataType or returns an error if something is wrong
	Build() (ReferenceListEntryDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReferenceListEntryDataType
}

// NewReferenceListEntryDataTypeBuilder() creates a ReferenceListEntryDataTypeBuilder
func NewReferenceListEntryDataTypeBuilder() ReferenceListEntryDataTypeBuilder {
	return &_ReferenceListEntryDataTypeBuilder{_ReferenceListEntryDataType: new(_ReferenceListEntryDataType)}
}

type _ReferenceListEntryDataTypeBuilder struct {
	*_ReferenceListEntryDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ReferenceListEntryDataTypeBuilder) = (*_ReferenceListEntryDataTypeBuilder)(nil)

func (b *_ReferenceListEntryDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReferenceListEntryDataType
}

func (b *_ReferenceListEntryDataTypeBuilder) WithMandatoryFields(referenceType NodeId, isForward bool, targetNode ExpandedNodeId) ReferenceListEntryDataTypeBuilder {
	return b.WithReferenceType(referenceType).WithIsForward(isForward).WithTargetNode(targetNode)
}

func (b *_ReferenceListEntryDataTypeBuilder) WithReferenceType(referenceType NodeId) ReferenceListEntryDataTypeBuilder {
	b.ReferenceType = referenceType
	return b
}

func (b *_ReferenceListEntryDataTypeBuilder) WithReferenceTypeBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ReferenceListEntryDataTypeBuilder {
	builder := builderSupplier(b.ReferenceType.CreateNodeIdBuilder())
	var err error
	b.ReferenceType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ReferenceListEntryDataTypeBuilder) WithIsForward(isForward bool) ReferenceListEntryDataTypeBuilder {
	b.IsForward = isForward
	return b
}

func (b *_ReferenceListEntryDataTypeBuilder) WithTargetNode(targetNode ExpandedNodeId) ReferenceListEntryDataTypeBuilder {
	b.TargetNode = targetNode
	return b
}

func (b *_ReferenceListEntryDataTypeBuilder) WithTargetNodeBuilder(builderSupplier func(ExpandedNodeIdBuilder) ExpandedNodeIdBuilder) ReferenceListEntryDataTypeBuilder {
	builder := builderSupplier(b.TargetNode.CreateExpandedNodeIdBuilder())
	var err error
	b.TargetNode, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExpandedNodeIdBuilder failed"))
	}
	return b
}

func (b *_ReferenceListEntryDataTypeBuilder) Build() (ReferenceListEntryDataType, error) {
	if b.ReferenceType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'referenceType' not set"))
	}
	if b.TargetNode == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'targetNode' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReferenceListEntryDataType.deepCopy(), nil
}

func (b *_ReferenceListEntryDataTypeBuilder) MustBuild() ReferenceListEntryDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReferenceListEntryDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReferenceListEntryDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReferenceListEntryDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateReferenceListEntryDataTypeBuilder().(*_ReferenceListEntryDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReferenceListEntryDataTypeBuilder creates a ReferenceListEntryDataTypeBuilder
func (b *_ReferenceListEntryDataType) CreateReferenceListEntryDataTypeBuilder() ReferenceListEntryDataTypeBuilder {
	if b == nil {
		return NewReferenceListEntryDataTypeBuilder()
	}
	return &_ReferenceListEntryDataTypeBuilder{_ReferenceListEntryDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReferenceListEntryDataType) GetExtensionId() int32 {
	return int32(32662)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReferenceListEntryDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReferenceListEntryDataType) GetReferenceType() NodeId {
	return m.ReferenceType
}

func (m *_ReferenceListEntryDataType) GetIsForward() bool {
	return m.IsForward
}

func (m *_ReferenceListEntryDataType) GetTargetNode() ExpandedNodeId {
	return m.TargetNode
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReferenceListEntryDataType(structType any) ReferenceListEntryDataType {
	if casted, ok := structType.(ReferenceListEntryDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ReferenceListEntryDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ReferenceListEntryDataType) GetTypeName() string {
	return "ReferenceListEntryDataType"
}

func (m *_ReferenceListEntryDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (referenceType)
	lengthInBits += m.ReferenceType.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isForward)
	lengthInBits += 1

	// Simple field (targetNode)
	lengthInBits += m.TargetNode.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReferenceListEntryDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReferenceListEntryDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__referenceListEntryDataType ReferenceListEntryDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReferenceListEntryDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReferenceListEntryDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	referenceType, err := ReadSimpleField[NodeId](ctx, "referenceType", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'referenceType' field"))
	}
	m.ReferenceType = referenceType

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isForward, err := ReadSimpleField(ctx, "isForward", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isForward' field"))
	}
	m.IsForward = isForward

	targetNode, err := ReadSimpleField[ExpandedNodeId](ctx, "targetNode", ReadComplex[ExpandedNodeId](ExpandedNodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'targetNode' field"))
	}
	m.TargetNode = targetNode

	if closeErr := readBuffer.CloseContext("ReferenceListEntryDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReferenceListEntryDataType")
	}

	return m, nil
}

func (m *_ReferenceListEntryDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReferenceListEntryDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReferenceListEntryDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReferenceListEntryDataType")
		}

		if err := WriteSimpleField[NodeId](ctx, "referenceType", m.GetReferenceType(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'referenceType' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "isForward", m.GetIsForward(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isForward' field")
		}

		if err := WriteSimpleField[ExpandedNodeId](ctx, "targetNode", m.GetTargetNode(), WriteComplex[ExpandedNodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'targetNode' field")
		}

		if popErr := writeBuffer.PopContext("ReferenceListEntryDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReferenceListEntryDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReferenceListEntryDataType) IsReferenceListEntryDataType() {}

func (m *_ReferenceListEntryDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReferenceListEntryDataType) deepCopy() *_ReferenceListEntryDataType {
	if m == nil {
		return nil
	}
	_ReferenceListEntryDataTypeCopy := &_ReferenceListEntryDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.ReferenceType),
		m.IsForward,
		utils.DeepCopy[ExpandedNodeId](m.TargetNode),
		m.reservedField0,
	}
	_ReferenceListEntryDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReferenceListEntryDataTypeCopy
}

func (m *_ReferenceListEntryDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
