/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReadValueId is the corresponding interface of ReadValueId
type ReadValueId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNodeId returns NodeId (property field)
	GetNodeId() NodeId
	// GetAttributeId returns AttributeId (property field)
	GetAttributeId() uint32
	// GetIndexRange returns IndexRange (property field)
	GetIndexRange() PascalString
	// GetDataEncoding returns DataEncoding (property field)
	GetDataEncoding() QualifiedName
	// IsReadValueId is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReadValueId()
	// CreateBuilder creates a ReadValueIdBuilder
	CreateReadValueIdBuilder() ReadValueIdBuilder
}

// _ReadValueId is the data-structure of this message
type _ReadValueId struct {
	ExtensionObjectDefinitionContract
	NodeId       NodeId
	AttributeId  uint32
	IndexRange   PascalString
	DataEncoding QualifiedName
}

var _ ReadValueId = (*_ReadValueId)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReadValueId)(nil)

// NewReadValueId factory function for _ReadValueId
func NewReadValueId(nodeId NodeId, attributeId uint32, indexRange PascalString, dataEncoding QualifiedName) *_ReadValueId {
	if nodeId == nil {
		panic("nodeId of type NodeId for ReadValueId must not be nil")
	}
	if indexRange == nil {
		panic("indexRange of type PascalString for ReadValueId must not be nil")
	}
	if dataEncoding == nil {
		panic("dataEncoding of type QualifiedName for ReadValueId must not be nil")
	}
	_result := &_ReadValueId{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		NodeId:                            nodeId,
		AttributeId:                       attributeId,
		IndexRange:                        indexRange,
		DataEncoding:                      dataEncoding,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReadValueIdBuilder is a builder for ReadValueId
type ReadValueIdBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(nodeId NodeId, attributeId uint32, indexRange PascalString, dataEncoding QualifiedName) ReadValueIdBuilder
	// WithNodeId adds NodeId (property field)
	WithNodeId(NodeId) ReadValueIdBuilder
	// WithNodeIdBuilder adds NodeId (property field) which is build by the builder
	WithNodeIdBuilder(func(NodeIdBuilder) NodeIdBuilder) ReadValueIdBuilder
	// WithAttributeId adds AttributeId (property field)
	WithAttributeId(uint32) ReadValueIdBuilder
	// WithIndexRange adds IndexRange (property field)
	WithIndexRange(PascalString) ReadValueIdBuilder
	// WithIndexRangeBuilder adds IndexRange (property field) which is build by the builder
	WithIndexRangeBuilder(func(PascalStringBuilder) PascalStringBuilder) ReadValueIdBuilder
	// WithDataEncoding adds DataEncoding (property field)
	WithDataEncoding(QualifiedName) ReadValueIdBuilder
	// WithDataEncodingBuilder adds DataEncoding (property field) which is build by the builder
	WithDataEncodingBuilder(func(QualifiedNameBuilder) QualifiedNameBuilder) ReadValueIdBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReadValueId or returns an error if something is wrong
	Build() (ReadValueId, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReadValueId
}

// NewReadValueIdBuilder() creates a ReadValueIdBuilder
func NewReadValueIdBuilder() ReadValueIdBuilder {
	return &_ReadValueIdBuilder{_ReadValueId: new(_ReadValueId)}
}

type _ReadValueIdBuilder struct {
	*_ReadValueId

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ReadValueIdBuilder) = (*_ReadValueIdBuilder)(nil)

func (b *_ReadValueIdBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReadValueId
}

func (b *_ReadValueIdBuilder) WithMandatoryFields(nodeId NodeId, attributeId uint32, indexRange PascalString, dataEncoding QualifiedName) ReadValueIdBuilder {
	return b.WithNodeId(nodeId).WithAttributeId(attributeId).WithIndexRange(indexRange).WithDataEncoding(dataEncoding)
}

func (b *_ReadValueIdBuilder) WithNodeId(nodeId NodeId) ReadValueIdBuilder {
	b.NodeId = nodeId
	return b
}

func (b *_ReadValueIdBuilder) WithNodeIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ReadValueIdBuilder {
	builder := builderSupplier(b.NodeId.CreateNodeIdBuilder())
	var err error
	b.NodeId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ReadValueIdBuilder) WithAttributeId(attributeId uint32) ReadValueIdBuilder {
	b.AttributeId = attributeId
	return b
}

func (b *_ReadValueIdBuilder) WithIndexRange(indexRange PascalString) ReadValueIdBuilder {
	b.IndexRange = indexRange
	return b
}

func (b *_ReadValueIdBuilder) WithIndexRangeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ReadValueIdBuilder {
	builder := builderSupplier(b.IndexRange.CreatePascalStringBuilder())
	var err error
	b.IndexRange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ReadValueIdBuilder) WithDataEncoding(dataEncoding QualifiedName) ReadValueIdBuilder {
	b.DataEncoding = dataEncoding
	return b
}

func (b *_ReadValueIdBuilder) WithDataEncodingBuilder(builderSupplier func(QualifiedNameBuilder) QualifiedNameBuilder) ReadValueIdBuilder {
	builder := builderSupplier(b.DataEncoding.CreateQualifiedNameBuilder())
	var err error
	b.DataEncoding, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "QualifiedNameBuilder failed"))
	}
	return b
}

func (b *_ReadValueIdBuilder) Build() (ReadValueId, error) {
	if b.NodeId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'nodeId' not set"))
	}
	if b.IndexRange == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'indexRange' not set"))
	}
	if b.DataEncoding == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dataEncoding' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReadValueId.deepCopy(), nil
}

func (b *_ReadValueIdBuilder) MustBuild() ReadValueId {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReadValueIdBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReadValueIdBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReadValueIdBuilder) DeepCopy() any {
	_copy := b.CreateReadValueIdBuilder().(*_ReadValueIdBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReadValueIdBuilder creates a ReadValueIdBuilder
func (b *_ReadValueId) CreateReadValueIdBuilder() ReadValueIdBuilder {
	if b == nil {
		return NewReadValueIdBuilder()
	}
	return &_ReadValueIdBuilder{_ReadValueId: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReadValueId) GetExtensionId() int32 {
	return int32(628)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReadValueId) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReadValueId) GetNodeId() NodeId {
	return m.NodeId
}

func (m *_ReadValueId) GetAttributeId() uint32 {
	return m.AttributeId
}

func (m *_ReadValueId) GetIndexRange() PascalString {
	return m.IndexRange
}

func (m *_ReadValueId) GetDataEncoding() QualifiedName {
	return m.DataEncoding
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReadValueId(structType any) ReadValueId {
	if casted, ok := structType.(ReadValueId); ok {
		return casted
	}
	if casted, ok := structType.(*ReadValueId); ok {
		return *casted
	}
	return nil
}

func (m *_ReadValueId) GetTypeName() string {
	return "ReadValueId"
}

func (m *_ReadValueId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (nodeId)
	lengthInBits += m.NodeId.GetLengthInBits(ctx)

	// Simple field (attributeId)
	lengthInBits += 32

	// Simple field (indexRange)
	lengthInBits += m.IndexRange.GetLengthInBits(ctx)

	// Simple field (dataEncoding)
	lengthInBits += m.DataEncoding.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReadValueId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReadValueId) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__readValueId ReadValueId, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReadValueId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReadValueId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	nodeId, err := ReadSimpleField[NodeId](ctx, "nodeId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nodeId' field"))
	}
	m.NodeId = nodeId

	attributeId, err := ReadSimpleField(ctx, "attributeId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attributeId' field"))
	}
	m.AttributeId = attributeId

	indexRange, err := ReadSimpleField[PascalString](ctx, "indexRange", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'indexRange' field"))
	}
	m.IndexRange = indexRange

	dataEncoding, err := ReadSimpleField[QualifiedName](ctx, "dataEncoding", ReadComplex[QualifiedName](QualifiedNameParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataEncoding' field"))
	}
	m.DataEncoding = dataEncoding

	if closeErr := readBuffer.CloseContext("ReadValueId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReadValueId")
	}

	return m, nil
}

func (m *_ReadValueId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReadValueId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReadValueId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReadValueId")
		}

		if err := WriteSimpleField[NodeId](ctx, "nodeId", m.GetNodeId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'nodeId' field")
		}

		if err := WriteSimpleField[uint32](ctx, "attributeId", m.GetAttributeId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'attributeId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "indexRange", m.GetIndexRange(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'indexRange' field")
		}

		if err := WriteSimpleField[QualifiedName](ctx, "dataEncoding", m.GetDataEncoding(), WriteComplex[QualifiedName](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataEncoding' field")
		}

		if popErr := writeBuffer.PopContext("ReadValueId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReadValueId")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReadValueId) IsReadValueId() {}

func (m *_ReadValueId) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReadValueId) deepCopy() *_ReadValueId {
	if m == nil {
		return nil
	}
	_ReadValueIdCopy := &_ReadValueId{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.NodeId),
		m.AttributeId,
		utils.DeepCopy[PascalString](m.IndexRange),
		utils.DeepCopy[QualifiedName](m.DataEncoding),
	}
	_ReadValueIdCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReadValueIdCopy
}

func (m *_ReadValueId) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
