/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// QosDataType is the corresponding interface of QosDataType
type QosDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsQosDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsQosDataType()
	// CreateBuilder creates a QosDataTypeBuilder
	CreateQosDataTypeBuilder() QosDataTypeBuilder
}

// _QosDataType is the data-structure of this message
type _QosDataType struct {
	ExtensionObjectDefinitionContract
}

var _ QosDataType = (*_QosDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_QosDataType)(nil)

// NewQosDataType factory function for _QosDataType
func NewQosDataType() *_QosDataType {
	_result := &_QosDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// QosDataTypeBuilder is a builder for QosDataType
type QosDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() QosDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the QosDataType or returns an error if something is wrong
	Build() (QosDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() QosDataType
}

// NewQosDataTypeBuilder() creates a QosDataTypeBuilder
func NewQosDataTypeBuilder() QosDataTypeBuilder {
	return &_QosDataTypeBuilder{_QosDataType: new(_QosDataType)}
}

type _QosDataTypeBuilder struct {
	*_QosDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (QosDataTypeBuilder) = (*_QosDataTypeBuilder)(nil)

func (b *_QosDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._QosDataType
}

func (b *_QosDataTypeBuilder) WithMandatoryFields() QosDataTypeBuilder {
	return b
}

func (b *_QosDataTypeBuilder) Build() (QosDataType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._QosDataType.deepCopy(), nil
}

func (b *_QosDataTypeBuilder) MustBuild() QosDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_QosDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_QosDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_QosDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateQosDataTypeBuilder().(*_QosDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateQosDataTypeBuilder creates a QosDataTypeBuilder
func (b *_QosDataType) CreateQosDataTypeBuilder() QosDataTypeBuilder {
	if b == nil {
		return NewQosDataTypeBuilder()
	}
	return &_QosDataTypeBuilder{_QosDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_QosDataType) GetExtensionId() int32 {
	return int32(23605)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_QosDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastQosDataType(structType any) QosDataType {
	if casted, ok := structType.(QosDataType); ok {
		return casted
	}
	if casted, ok := structType.(*QosDataType); ok {
		return *casted
	}
	return nil
}

func (m *_QosDataType) GetTypeName() string {
	return "QosDataType"
}

func (m *_QosDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_QosDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_QosDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__qosDataType QosDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("QosDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for QosDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("QosDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for QosDataType")
	}

	return m, nil
}

func (m *_QosDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_QosDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("QosDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for QosDataType")
		}

		if popErr := writeBuffer.PopContext("QosDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for QosDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_QosDataType) IsQosDataType() {}

func (m *_QosDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_QosDataType) deepCopy() *_QosDataType {
	if m == nil {
		return nil
	}
	_QosDataTypeCopy := &_QosDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_QosDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _QosDataTypeCopy
}

func (m *_QosDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
