/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PublishedVariableDataType is the corresponding interface of PublishedVariableDataType
type PublishedVariableDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetPublishedVariable returns PublishedVariable (property field)
	GetPublishedVariable() NodeId
	// GetAttributeId returns AttributeId (property field)
	GetAttributeId() uint32
	// GetSamplingIntervalHint returns SamplingIntervalHint (property field)
	GetSamplingIntervalHint() float64
	// GetDeadbandType returns DeadbandType (property field)
	GetDeadbandType() uint32
	// GetDeadbandValue returns DeadbandValue (property field)
	GetDeadbandValue() float64
	// GetIndexRange returns IndexRange (property field)
	GetIndexRange() PascalString
	// GetSubstituteValue returns SubstituteValue (property field)
	GetSubstituteValue() Variant
	// GetMetaDataProperties returns MetaDataProperties (property field)
	GetMetaDataProperties() []QualifiedName
	// IsPublishedVariableDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPublishedVariableDataType()
	// CreateBuilder creates a PublishedVariableDataTypeBuilder
	CreatePublishedVariableDataTypeBuilder() PublishedVariableDataTypeBuilder
}

// _PublishedVariableDataType is the data-structure of this message
type _PublishedVariableDataType struct {
	ExtensionObjectDefinitionContract
	PublishedVariable    NodeId
	AttributeId          uint32
	SamplingIntervalHint float64
	DeadbandType         uint32
	DeadbandValue        float64
	IndexRange           PascalString
	SubstituteValue      Variant
	MetaDataProperties   []QualifiedName
}

var _ PublishedVariableDataType = (*_PublishedVariableDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PublishedVariableDataType)(nil)

// NewPublishedVariableDataType factory function for _PublishedVariableDataType
func NewPublishedVariableDataType(publishedVariable NodeId, attributeId uint32, samplingIntervalHint float64, deadbandType uint32, deadbandValue float64, indexRange PascalString, substituteValue Variant, metaDataProperties []QualifiedName) *_PublishedVariableDataType {
	if publishedVariable == nil {
		panic("publishedVariable of type NodeId for PublishedVariableDataType must not be nil")
	}
	if indexRange == nil {
		panic("indexRange of type PascalString for PublishedVariableDataType must not be nil")
	}
	if substituteValue == nil {
		panic("substituteValue of type Variant for PublishedVariableDataType must not be nil")
	}
	_result := &_PublishedVariableDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		PublishedVariable:                 publishedVariable,
		AttributeId:                       attributeId,
		SamplingIntervalHint:              samplingIntervalHint,
		DeadbandType:                      deadbandType,
		DeadbandValue:                     deadbandValue,
		IndexRange:                        indexRange,
		SubstituteValue:                   substituteValue,
		MetaDataProperties:                metaDataProperties,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PublishedVariableDataTypeBuilder is a builder for PublishedVariableDataType
type PublishedVariableDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(publishedVariable NodeId, attributeId uint32, samplingIntervalHint float64, deadbandType uint32, deadbandValue float64, indexRange PascalString, substituteValue Variant, metaDataProperties []QualifiedName) PublishedVariableDataTypeBuilder
	// WithPublishedVariable adds PublishedVariable (property field)
	WithPublishedVariable(NodeId) PublishedVariableDataTypeBuilder
	// WithPublishedVariableBuilder adds PublishedVariable (property field) which is build by the builder
	WithPublishedVariableBuilder(func(NodeIdBuilder) NodeIdBuilder) PublishedVariableDataTypeBuilder
	// WithAttributeId adds AttributeId (property field)
	WithAttributeId(uint32) PublishedVariableDataTypeBuilder
	// WithSamplingIntervalHint adds SamplingIntervalHint (property field)
	WithSamplingIntervalHint(float64) PublishedVariableDataTypeBuilder
	// WithDeadbandType adds DeadbandType (property field)
	WithDeadbandType(uint32) PublishedVariableDataTypeBuilder
	// WithDeadbandValue adds DeadbandValue (property field)
	WithDeadbandValue(float64) PublishedVariableDataTypeBuilder
	// WithIndexRange adds IndexRange (property field)
	WithIndexRange(PascalString) PublishedVariableDataTypeBuilder
	// WithIndexRangeBuilder adds IndexRange (property field) which is build by the builder
	WithIndexRangeBuilder(func(PascalStringBuilder) PascalStringBuilder) PublishedVariableDataTypeBuilder
	// WithSubstituteValue adds SubstituteValue (property field)
	WithSubstituteValue(Variant) PublishedVariableDataTypeBuilder
	// WithSubstituteValueBuilder adds SubstituteValue (property field) which is build by the builder
	WithSubstituteValueBuilder(func(VariantBuilder) VariantBuilder) PublishedVariableDataTypeBuilder
	// WithMetaDataProperties adds MetaDataProperties (property field)
	WithMetaDataProperties(...QualifiedName) PublishedVariableDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PublishedVariableDataType or returns an error if something is wrong
	Build() (PublishedVariableDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PublishedVariableDataType
}

// NewPublishedVariableDataTypeBuilder() creates a PublishedVariableDataTypeBuilder
func NewPublishedVariableDataTypeBuilder() PublishedVariableDataTypeBuilder {
	return &_PublishedVariableDataTypeBuilder{_PublishedVariableDataType: new(_PublishedVariableDataType)}
}

type _PublishedVariableDataTypeBuilder struct {
	*_PublishedVariableDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (PublishedVariableDataTypeBuilder) = (*_PublishedVariableDataTypeBuilder)(nil)

func (b *_PublishedVariableDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PublishedVariableDataType
}

func (b *_PublishedVariableDataTypeBuilder) WithMandatoryFields(publishedVariable NodeId, attributeId uint32, samplingIntervalHint float64, deadbandType uint32, deadbandValue float64, indexRange PascalString, substituteValue Variant, metaDataProperties []QualifiedName) PublishedVariableDataTypeBuilder {
	return b.WithPublishedVariable(publishedVariable).WithAttributeId(attributeId).WithSamplingIntervalHint(samplingIntervalHint).WithDeadbandType(deadbandType).WithDeadbandValue(deadbandValue).WithIndexRange(indexRange).WithSubstituteValue(substituteValue).WithMetaDataProperties(metaDataProperties...)
}

func (b *_PublishedVariableDataTypeBuilder) WithPublishedVariable(publishedVariable NodeId) PublishedVariableDataTypeBuilder {
	b.PublishedVariable = publishedVariable
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithPublishedVariableBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) PublishedVariableDataTypeBuilder {
	builder := builderSupplier(b.PublishedVariable.CreateNodeIdBuilder())
	var err error
	b.PublishedVariable, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithAttributeId(attributeId uint32) PublishedVariableDataTypeBuilder {
	b.AttributeId = attributeId
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithSamplingIntervalHint(samplingIntervalHint float64) PublishedVariableDataTypeBuilder {
	b.SamplingIntervalHint = samplingIntervalHint
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithDeadbandType(deadbandType uint32) PublishedVariableDataTypeBuilder {
	b.DeadbandType = deadbandType
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithDeadbandValue(deadbandValue float64) PublishedVariableDataTypeBuilder {
	b.DeadbandValue = deadbandValue
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithIndexRange(indexRange PascalString) PublishedVariableDataTypeBuilder {
	b.IndexRange = indexRange
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithIndexRangeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PublishedVariableDataTypeBuilder {
	builder := builderSupplier(b.IndexRange.CreatePascalStringBuilder())
	var err error
	b.IndexRange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithSubstituteValue(substituteValue Variant) PublishedVariableDataTypeBuilder {
	b.SubstituteValue = substituteValue
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithSubstituteValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) PublishedVariableDataTypeBuilder {
	builder := builderSupplier(b.SubstituteValue.CreateVariantBuilder())
	var err error
	b.SubstituteValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_PublishedVariableDataTypeBuilder) WithMetaDataProperties(metaDataProperties ...QualifiedName) PublishedVariableDataTypeBuilder {
	b.MetaDataProperties = metaDataProperties
	return b
}

func (b *_PublishedVariableDataTypeBuilder) Build() (PublishedVariableDataType, error) {
	if b.PublishedVariable == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publishedVariable' not set"))
	}
	if b.IndexRange == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'indexRange' not set"))
	}
	if b.SubstituteValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'substituteValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._PublishedVariableDataType.deepCopy(), nil
}

func (b *_PublishedVariableDataTypeBuilder) MustBuild() PublishedVariableDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PublishedVariableDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PublishedVariableDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PublishedVariableDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePublishedVariableDataTypeBuilder().(*_PublishedVariableDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreatePublishedVariableDataTypeBuilder creates a PublishedVariableDataTypeBuilder
func (b *_PublishedVariableDataType) CreatePublishedVariableDataTypeBuilder() PublishedVariableDataTypeBuilder {
	if b == nil {
		return NewPublishedVariableDataTypeBuilder()
	}
	return &_PublishedVariableDataTypeBuilder{_PublishedVariableDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PublishedVariableDataType) GetExtensionId() int32 {
	return int32(14275)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PublishedVariableDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PublishedVariableDataType) GetPublishedVariable() NodeId {
	return m.PublishedVariable
}

func (m *_PublishedVariableDataType) GetAttributeId() uint32 {
	return m.AttributeId
}

func (m *_PublishedVariableDataType) GetSamplingIntervalHint() float64 {
	return m.SamplingIntervalHint
}

func (m *_PublishedVariableDataType) GetDeadbandType() uint32 {
	return m.DeadbandType
}

func (m *_PublishedVariableDataType) GetDeadbandValue() float64 {
	return m.DeadbandValue
}

func (m *_PublishedVariableDataType) GetIndexRange() PascalString {
	return m.IndexRange
}

func (m *_PublishedVariableDataType) GetSubstituteValue() Variant {
	return m.SubstituteValue
}

func (m *_PublishedVariableDataType) GetMetaDataProperties() []QualifiedName {
	return m.MetaDataProperties
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPublishedVariableDataType(structType any) PublishedVariableDataType {
	if casted, ok := structType.(PublishedVariableDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PublishedVariableDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PublishedVariableDataType) GetTypeName() string {
	return "PublishedVariableDataType"
}

func (m *_PublishedVariableDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (publishedVariable)
	lengthInBits += m.PublishedVariable.GetLengthInBits(ctx)

	// Simple field (attributeId)
	lengthInBits += 32

	// Simple field (samplingIntervalHint)
	lengthInBits += 64

	// Simple field (deadbandType)
	lengthInBits += 32

	// Simple field (deadbandValue)
	lengthInBits += 64

	// Simple field (indexRange)
	lengthInBits += m.IndexRange.GetLengthInBits(ctx)

	// Simple field (substituteValue)
	lengthInBits += m.SubstituteValue.GetLengthInBits(ctx)

	// Implicit Field (noOfMetaDataProperties)
	lengthInBits += 32

	// Array field
	if len(m.MetaDataProperties) > 0 {
		for _curItem, element := range m.MetaDataProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.MetaDataProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PublishedVariableDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PublishedVariableDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__publishedVariableDataType PublishedVariableDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PublishedVariableDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PublishedVariableDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	publishedVariable, err := ReadSimpleField[NodeId](ctx, "publishedVariable", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publishedVariable' field"))
	}
	m.PublishedVariable = publishedVariable

	attributeId, err := ReadSimpleField(ctx, "attributeId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attributeId' field"))
	}
	m.AttributeId = attributeId

	samplingIntervalHint, err := ReadSimpleField(ctx, "samplingIntervalHint", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'samplingIntervalHint' field"))
	}
	m.SamplingIntervalHint = samplingIntervalHint

	deadbandType, err := ReadSimpleField(ctx, "deadbandType", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deadbandType' field"))
	}
	m.DeadbandType = deadbandType

	deadbandValue, err := ReadSimpleField(ctx, "deadbandValue", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deadbandValue' field"))
	}
	m.DeadbandValue = deadbandValue

	indexRange, err := ReadSimpleField[PascalString](ctx, "indexRange", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'indexRange' field"))
	}
	m.IndexRange = indexRange

	substituteValue, err := ReadSimpleField[Variant](ctx, "substituteValue", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'substituteValue' field"))
	}
	m.SubstituteValue = substituteValue

	noOfMetaDataProperties, err := ReadImplicitField[int32](ctx, "noOfMetaDataProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfMetaDataProperties' field"))
	}
	_ = noOfMetaDataProperties

	metaDataProperties, err := ReadCountArrayField[QualifiedName](ctx, "metaDataProperties", ReadComplex[QualifiedName](QualifiedNameParseWithBuffer, readBuffer), uint64(noOfMetaDataProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'metaDataProperties' field"))
	}
	m.MetaDataProperties = metaDataProperties

	if closeErr := readBuffer.CloseContext("PublishedVariableDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PublishedVariableDataType")
	}

	return m, nil
}

func (m *_PublishedVariableDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PublishedVariableDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PublishedVariableDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PublishedVariableDataType")
		}

		if err := WriteSimpleField[NodeId](ctx, "publishedVariable", m.GetPublishedVariable(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publishedVariable' field")
		}

		if err := WriteSimpleField[uint32](ctx, "attributeId", m.GetAttributeId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'attributeId' field")
		}

		if err := WriteSimpleField[float64](ctx, "samplingIntervalHint", m.GetSamplingIntervalHint(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'samplingIntervalHint' field")
		}

		if err := WriteSimpleField[uint32](ctx, "deadbandType", m.GetDeadbandType(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'deadbandType' field")
		}

		if err := WriteSimpleField[float64](ctx, "deadbandValue", m.GetDeadbandValue(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'deadbandValue' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "indexRange", m.GetIndexRange(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'indexRange' field")
		}

		if err := WriteSimpleField[Variant](ctx, "substituteValue", m.GetSubstituteValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'substituteValue' field")
		}
		noOfMetaDataProperties := int32(utils.InlineIf(bool((m.GetMetaDataProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetMetaDataProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfMetaDataProperties", noOfMetaDataProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfMetaDataProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "metaDataProperties", m.GetMetaDataProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'metaDataProperties' field")
		}

		if popErr := writeBuffer.PopContext("PublishedVariableDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PublishedVariableDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PublishedVariableDataType) IsPublishedVariableDataType() {}

func (m *_PublishedVariableDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PublishedVariableDataType) deepCopy() *_PublishedVariableDataType {
	if m == nil {
		return nil
	}
	_PublishedVariableDataTypeCopy := &_PublishedVariableDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.PublishedVariable),
		m.AttributeId,
		m.SamplingIntervalHint,
		m.DeadbandType,
		m.DeadbandValue,
		utils.DeepCopy[PascalString](m.IndexRange),
		utils.DeepCopy[Variant](m.SubstituteValue),
		utils.DeepCopySlice[QualifiedName, QualifiedName](m.MetaDataProperties),
	}
	_PublishedVariableDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PublishedVariableDataTypeCopy
}

func (m *_PublishedVariableDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
