/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PublishedActionMethodDataType is the corresponding interface of PublishedActionMethodDataType
type PublishedActionMethodDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRequestDataSetMetaData returns RequestDataSetMetaData (property field)
	GetRequestDataSetMetaData() DataSetMetaDataType
	// GetActionTargets returns ActionTargets (property field)
	GetActionTargets() []ActionTargetDataType
	// GetActionMethods returns ActionMethods (property field)
	GetActionMethods() []ActionMethodDataType
	// IsPublishedActionMethodDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPublishedActionMethodDataType()
	// CreateBuilder creates a PublishedActionMethodDataTypeBuilder
	CreatePublishedActionMethodDataTypeBuilder() PublishedActionMethodDataTypeBuilder
}

// _PublishedActionMethodDataType is the data-structure of this message
type _PublishedActionMethodDataType struct {
	ExtensionObjectDefinitionContract
	RequestDataSetMetaData DataSetMetaDataType
	ActionTargets          []ActionTargetDataType
	ActionMethods          []ActionMethodDataType
}

var _ PublishedActionMethodDataType = (*_PublishedActionMethodDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PublishedActionMethodDataType)(nil)

// NewPublishedActionMethodDataType factory function for _PublishedActionMethodDataType
func NewPublishedActionMethodDataType(requestDataSetMetaData DataSetMetaDataType, actionTargets []ActionTargetDataType, actionMethods []ActionMethodDataType) *_PublishedActionMethodDataType {
	if requestDataSetMetaData == nil {
		panic("requestDataSetMetaData of type DataSetMetaDataType for PublishedActionMethodDataType must not be nil")
	}
	_result := &_PublishedActionMethodDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RequestDataSetMetaData:            requestDataSetMetaData,
		ActionTargets:                     actionTargets,
		ActionMethods:                     actionMethods,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PublishedActionMethodDataTypeBuilder is a builder for PublishedActionMethodDataType
type PublishedActionMethodDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(requestDataSetMetaData DataSetMetaDataType, actionTargets []ActionTargetDataType, actionMethods []ActionMethodDataType) PublishedActionMethodDataTypeBuilder
	// WithRequestDataSetMetaData adds RequestDataSetMetaData (property field)
	WithRequestDataSetMetaData(DataSetMetaDataType) PublishedActionMethodDataTypeBuilder
	// WithRequestDataSetMetaDataBuilder adds RequestDataSetMetaData (property field) which is build by the builder
	WithRequestDataSetMetaDataBuilder(func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) PublishedActionMethodDataTypeBuilder
	// WithActionTargets adds ActionTargets (property field)
	WithActionTargets(...ActionTargetDataType) PublishedActionMethodDataTypeBuilder
	// WithActionMethods adds ActionMethods (property field)
	WithActionMethods(...ActionMethodDataType) PublishedActionMethodDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PublishedActionMethodDataType or returns an error if something is wrong
	Build() (PublishedActionMethodDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PublishedActionMethodDataType
}

// NewPublishedActionMethodDataTypeBuilder() creates a PublishedActionMethodDataTypeBuilder
func NewPublishedActionMethodDataTypeBuilder() PublishedActionMethodDataTypeBuilder {
	return &_PublishedActionMethodDataTypeBuilder{_PublishedActionMethodDataType: new(_PublishedActionMethodDataType)}
}

type _PublishedActionMethodDataTypeBuilder struct {
	*_PublishedActionMethodDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (PublishedActionMethodDataTypeBuilder) = (*_PublishedActionMethodDataTypeBuilder)(nil)

func (b *_PublishedActionMethodDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PublishedActionMethodDataType
}

func (b *_PublishedActionMethodDataTypeBuilder) WithMandatoryFields(requestDataSetMetaData DataSetMetaDataType, actionTargets []ActionTargetDataType, actionMethods []ActionMethodDataType) PublishedActionMethodDataTypeBuilder {
	return b.WithRequestDataSetMetaData(requestDataSetMetaData).WithActionTargets(actionTargets...).WithActionMethods(actionMethods...)
}

func (b *_PublishedActionMethodDataTypeBuilder) WithRequestDataSetMetaData(requestDataSetMetaData DataSetMetaDataType) PublishedActionMethodDataTypeBuilder {
	b.RequestDataSetMetaData = requestDataSetMetaData
	return b
}

func (b *_PublishedActionMethodDataTypeBuilder) WithRequestDataSetMetaDataBuilder(builderSupplier func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) PublishedActionMethodDataTypeBuilder {
	builder := builderSupplier(b.RequestDataSetMetaData.CreateDataSetMetaDataTypeBuilder())
	var err error
	b.RequestDataSetMetaData, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "DataSetMetaDataTypeBuilder failed"))
	}
	return b
}

func (b *_PublishedActionMethodDataTypeBuilder) WithActionTargets(actionTargets ...ActionTargetDataType) PublishedActionMethodDataTypeBuilder {
	b.ActionTargets = actionTargets
	return b
}

func (b *_PublishedActionMethodDataTypeBuilder) WithActionMethods(actionMethods ...ActionMethodDataType) PublishedActionMethodDataTypeBuilder {
	b.ActionMethods = actionMethods
	return b
}

func (b *_PublishedActionMethodDataTypeBuilder) Build() (PublishedActionMethodDataType, error) {
	if b.RequestDataSetMetaData == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'requestDataSetMetaData' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._PublishedActionMethodDataType.deepCopy(), nil
}

func (b *_PublishedActionMethodDataTypeBuilder) MustBuild() PublishedActionMethodDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PublishedActionMethodDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PublishedActionMethodDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PublishedActionMethodDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePublishedActionMethodDataTypeBuilder().(*_PublishedActionMethodDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreatePublishedActionMethodDataTypeBuilder creates a PublishedActionMethodDataTypeBuilder
func (b *_PublishedActionMethodDataType) CreatePublishedActionMethodDataTypeBuilder() PublishedActionMethodDataTypeBuilder {
	if b == nil {
		return NewPublishedActionMethodDataTypeBuilder()
	}
	return &_PublishedActionMethodDataTypeBuilder{_PublishedActionMethodDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PublishedActionMethodDataType) GetExtensionId() int32 {
	return int32(18795)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PublishedActionMethodDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PublishedActionMethodDataType) GetRequestDataSetMetaData() DataSetMetaDataType {
	return m.RequestDataSetMetaData
}

func (m *_PublishedActionMethodDataType) GetActionTargets() []ActionTargetDataType {
	return m.ActionTargets
}

func (m *_PublishedActionMethodDataType) GetActionMethods() []ActionMethodDataType {
	return m.ActionMethods
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPublishedActionMethodDataType(structType any) PublishedActionMethodDataType {
	if casted, ok := structType.(PublishedActionMethodDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PublishedActionMethodDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PublishedActionMethodDataType) GetTypeName() string {
	return "PublishedActionMethodDataType"
}

func (m *_PublishedActionMethodDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (requestDataSetMetaData)
	lengthInBits += m.RequestDataSetMetaData.GetLengthInBits(ctx)

	// Implicit Field (noOfActionTargets)
	lengthInBits += 32

	// Array field
	if len(m.ActionTargets) > 0 {
		for _curItem, element := range m.ActionTargets {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ActionTargets), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfActionMethods)
	lengthInBits += 32

	// Array field
	if len(m.ActionMethods) > 0 {
		for _curItem, element := range m.ActionMethods {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ActionMethods), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PublishedActionMethodDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PublishedActionMethodDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__publishedActionMethodDataType PublishedActionMethodDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PublishedActionMethodDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PublishedActionMethodDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	requestDataSetMetaData, err := ReadSimpleField[DataSetMetaDataType](ctx, "requestDataSetMetaData", ReadComplex[DataSetMetaDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetMetaDataType]((int32)(int32(14525))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestDataSetMetaData' field"))
	}
	m.RequestDataSetMetaData = requestDataSetMetaData

	noOfActionTargets, err := ReadImplicitField[int32](ctx, "noOfActionTargets", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfActionTargets' field"))
	}
	_ = noOfActionTargets

	actionTargets, err := ReadCountArrayField[ActionTargetDataType](ctx, "actionTargets", ReadComplex[ActionTargetDataType](ExtensionObjectDefinitionParseWithBufferProducer[ActionTargetDataType]((int32)(int32(18595))), readBuffer), uint64(noOfActionTargets))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionTargets' field"))
	}
	m.ActionTargets = actionTargets

	noOfActionMethods, err := ReadImplicitField[int32](ctx, "noOfActionMethods", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfActionMethods' field"))
	}
	_ = noOfActionMethods

	actionMethods, err := ReadCountArrayField[ActionMethodDataType](ctx, "actionMethods", ReadComplex[ActionMethodDataType](ExtensionObjectDefinitionParseWithBufferProducer[ActionMethodDataType]((int32)(int32(18599))), readBuffer), uint64(noOfActionMethods))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionMethods' field"))
	}
	m.ActionMethods = actionMethods

	if closeErr := readBuffer.CloseContext("PublishedActionMethodDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PublishedActionMethodDataType")
	}

	return m, nil
}

func (m *_PublishedActionMethodDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PublishedActionMethodDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PublishedActionMethodDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PublishedActionMethodDataType")
		}

		if err := WriteSimpleField[DataSetMetaDataType](ctx, "requestDataSetMetaData", m.GetRequestDataSetMetaData(), WriteComplex[DataSetMetaDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestDataSetMetaData' field")
		}
		noOfActionTargets := int32(utils.InlineIf(bool((m.GetActionTargets()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetActionTargets()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfActionTargets", noOfActionTargets, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfActionTargets' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "actionTargets", m.GetActionTargets(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'actionTargets' field")
		}
		noOfActionMethods := int32(utils.InlineIf(bool((m.GetActionMethods()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetActionMethods()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfActionMethods", noOfActionMethods, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfActionMethods' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "actionMethods", m.GetActionMethods(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'actionMethods' field")
		}

		if popErr := writeBuffer.PopContext("PublishedActionMethodDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PublishedActionMethodDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PublishedActionMethodDataType) IsPublishedActionMethodDataType() {}

func (m *_PublishedActionMethodDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PublishedActionMethodDataType) deepCopy() *_PublishedActionMethodDataType {
	if m == nil {
		return nil
	}
	_PublishedActionMethodDataTypeCopy := &_PublishedActionMethodDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[DataSetMetaDataType](m.RequestDataSetMetaData),
		utils.DeepCopySlice[ActionTargetDataType, ActionTargetDataType](m.ActionTargets),
		utils.DeepCopySlice[ActionMethodDataType, ActionMethodDataType](m.ActionMethods),
	}
	_PublishedActionMethodDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PublishedActionMethodDataTypeCopy
}

func (m *_PublishedActionMethodDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
