/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PublishedActionDataType is the corresponding interface of PublishedActionDataType
type PublishedActionDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRequestDataSetMetaData returns RequestDataSetMetaData (property field)
	GetRequestDataSetMetaData() DataSetMetaDataType
	// GetActionTargets returns ActionTargets (property field)
	GetActionTargets() []ActionTargetDataType
	// IsPublishedActionDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPublishedActionDataType()
	// CreateBuilder creates a PublishedActionDataTypeBuilder
	CreatePublishedActionDataTypeBuilder() PublishedActionDataTypeBuilder
}

// _PublishedActionDataType is the data-structure of this message
type _PublishedActionDataType struct {
	ExtensionObjectDefinitionContract
	RequestDataSetMetaData DataSetMetaDataType
	ActionTargets          []ActionTargetDataType
}

var _ PublishedActionDataType = (*_PublishedActionDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PublishedActionDataType)(nil)

// NewPublishedActionDataType factory function for _PublishedActionDataType
func NewPublishedActionDataType(requestDataSetMetaData DataSetMetaDataType, actionTargets []ActionTargetDataType) *_PublishedActionDataType {
	if requestDataSetMetaData == nil {
		panic("requestDataSetMetaData of type DataSetMetaDataType for PublishedActionDataType must not be nil")
	}
	_result := &_PublishedActionDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RequestDataSetMetaData:            requestDataSetMetaData,
		ActionTargets:                     actionTargets,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PublishedActionDataTypeBuilder is a builder for PublishedActionDataType
type PublishedActionDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(requestDataSetMetaData DataSetMetaDataType, actionTargets []ActionTargetDataType) PublishedActionDataTypeBuilder
	// WithRequestDataSetMetaData adds RequestDataSetMetaData (property field)
	WithRequestDataSetMetaData(DataSetMetaDataType) PublishedActionDataTypeBuilder
	// WithRequestDataSetMetaDataBuilder adds RequestDataSetMetaData (property field) which is build by the builder
	WithRequestDataSetMetaDataBuilder(func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) PublishedActionDataTypeBuilder
	// WithActionTargets adds ActionTargets (property field)
	WithActionTargets(...ActionTargetDataType) PublishedActionDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PublishedActionDataType or returns an error if something is wrong
	Build() (PublishedActionDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PublishedActionDataType
}

// NewPublishedActionDataTypeBuilder() creates a PublishedActionDataTypeBuilder
func NewPublishedActionDataTypeBuilder() PublishedActionDataTypeBuilder {
	return &_PublishedActionDataTypeBuilder{_PublishedActionDataType: new(_PublishedActionDataType)}
}

type _PublishedActionDataTypeBuilder struct {
	*_PublishedActionDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (PublishedActionDataTypeBuilder) = (*_PublishedActionDataTypeBuilder)(nil)

func (b *_PublishedActionDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PublishedActionDataType
}

func (b *_PublishedActionDataTypeBuilder) WithMandatoryFields(requestDataSetMetaData DataSetMetaDataType, actionTargets []ActionTargetDataType) PublishedActionDataTypeBuilder {
	return b.WithRequestDataSetMetaData(requestDataSetMetaData).WithActionTargets(actionTargets...)
}

func (b *_PublishedActionDataTypeBuilder) WithRequestDataSetMetaData(requestDataSetMetaData DataSetMetaDataType) PublishedActionDataTypeBuilder {
	b.RequestDataSetMetaData = requestDataSetMetaData
	return b
}

func (b *_PublishedActionDataTypeBuilder) WithRequestDataSetMetaDataBuilder(builderSupplier func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) PublishedActionDataTypeBuilder {
	builder := builderSupplier(b.RequestDataSetMetaData.CreateDataSetMetaDataTypeBuilder())
	var err error
	b.RequestDataSetMetaData, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "DataSetMetaDataTypeBuilder failed"))
	}
	return b
}

func (b *_PublishedActionDataTypeBuilder) WithActionTargets(actionTargets ...ActionTargetDataType) PublishedActionDataTypeBuilder {
	b.ActionTargets = actionTargets
	return b
}

func (b *_PublishedActionDataTypeBuilder) Build() (PublishedActionDataType, error) {
	if b.RequestDataSetMetaData == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'requestDataSetMetaData' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._PublishedActionDataType.deepCopy(), nil
}

func (b *_PublishedActionDataTypeBuilder) MustBuild() PublishedActionDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PublishedActionDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PublishedActionDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PublishedActionDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePublishedActionDataTypeBuilder().(*_PublishedActionDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreatePublishedActionDataTypeBuilder creates a PublishedActionDataTypeBuilder
func (b *_PublishedActionDataType) CreatePublishedActionDataTypeBuilder() PublishedActionDataTypeBuilder {
	if b == nil {
		return NewPublishedActionDataTypeBuilder()
	}
	return &_PublishedActionDataTypeBuilder{_PublishedActionDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PublishedActionDataType) GetExtensionId() int32 {
	return int32(18596)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PublishedActionDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PublishedActionDataType) GetRequestDataSetMetaData() DataSetMetaDataType {
	return m.RequestDataSetMetaData
}

func (m *_PublishedActionDataType) GetActionTargets() []ActionTargetDataType {
	return m.ActionTargets
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPublishedActionDataType(structType any) PublishedActionDataType {
	if casted, ok := structType.(PublishedActionDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PublishedActionDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PublishedActionDataType) GetTypeName() string {
	return "PublishedActionDataType"
}

func (m *_PublishedActionDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (requestDataSetMetaData)
	lengthInBits += m.RequestDataSetMetaData.GetLengthInBits(ctx)

	// Implicit Field (noOfActionTargets)
	lengthInBits += 32

	// Array field
	if len(m.ActionTargets) > 0 {
		for _curItem, element := range m.ActionTargets {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ActionTargets), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PublishedActionDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PublishedActionDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__publishedActionDataType PublishedActionDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PublishedActionDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PublishedActionDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	requestDataSetMetaData, err := ReadSimpleField[DataSetMetaDataType](ctx, "requestDataSetMetaData", ReadComplex[DataSetMetaDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetMetaDataType]((int32)(int32(14525))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestDataSetMetaData' field"))
	}
	m.RequestDataSetMetaData = requestDataSetMetaData

	noOfActionTargets, err := ReadImplicitField[int32](ctx, "noOfActionTargets", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfActionTargets' field"))
	}
	_ = noOfActionTargets

	actionTargets, err := ReadCountArrayField[ActionTargetDataType](ctx, "actionTargets", ReadComplex[ActionTargetDataType](ExtensionObjectDefinitionParseWithBufferProducer[ActionTargetDataType]((int32)(int32(18595))), readBuffer), uint64(noOfActionTargets))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionTargets' field"))
	}
	m.ActionTargets = actionTargets

	if closeErr := readBuffer.CloseContext("PublishedActionDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PublishedActionDataType")
	}

	return m, nil
}

func (m *_PublishedActionDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PublishedActionDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PublishedActionDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PublishedActionDataType")
		}

		if err := WriteSimpleField[DataSetMetaDataType](ctx, "requestDataSetMetaData", m.GetRequestDataSetMetaData(), WriteComplex[DataSetMetaDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestDataSetMetaData' field")
		}
		noOfActionTargets := int32(utils.InlineIf(bool((m.GetActionTargets()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetActionTargets()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfActionTargets", noOfActionTargets, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfActionTargets' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "actionTargets", m.GetActionTargets(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'actionTargets' field")
		}

		if popErr := writeBuffer.PopContext("PublishedActionDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PublishedActionDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PublishedActionDataType) IsPublishedActionDataType() {}

func (m *_PublishedActionDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PublishedActionDataType) deepCopy() *_PublishedActionDataType {
	if m == nil {
		return nil
	}
	_PublishedActionDataTypeCopy := &_PublishedActionDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[DataSetMetaDataType](m.RequestDataSetMetaData),
		utils.DeepCopySlice[ActionTargetDataType, ActionTargetDataType](m.ActionTargets),
	}
	_PublishedActionDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PublishedActionDataTypeCopy
}

func (m *_PublishedActionDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
