/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PubSubConnectionDataType is the corresponding interface of PubSubConnectionDataType
type PubSubConnectionDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetEnabled returns Enabled (property field)
	GetEnabled() bool
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() Variant
	// GetTransportProfileUri returns TransportProfileUri (property field)
	GetTransportProfileUri() PascalString
	// GetAddress returns Address (property field)
	GetAddress() ExtensionObject
	// GetConnectionProperties returns ConnectionProperties (property field)
	GetConnectionProperties() []KeyValuePair
	// GetTransportSettings returns TransportSettings (property field)
	GetTransportSettings() ExtensionObject
	// GetWriterGroups returns WriterGroups (property field)
	GetWriterGroups() []WriterGroupDataType
	// GetReaderGroups returns ReaderGroups (property field)
	GetReaderGroups() []ReaderGroupDataType
	// IsPubSubConnectionDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPubSubConnectionDataType()
	// CreateBuilder creates a PubSubConnectionDataTypeBuilder
	CreatePubSubConnectionDataTypeBuilder() PubSubConnectionDataTypeBuilder
}

// _PubSubConnectionDataType is the data-structure of this message
type _PubSubConnectionDataType struct {
	ExtensionObjectDefinitionContract
	Name                 PascalString
	Enabled              bool
	PublisherId          Variant
	TransportProfileUri  PascalString
	Address              ExtensionObject
	ConnectionProperties []KeyValuePair
	TransportSettings    ExtensionObject
	WriterGroups         []WriterGroupDataType
	ReaderGroups         []ReaderGroupDataType
	// Reserved Fields
	reservedField0 *uint8
}

var _ PubSubConnectionDataType = (*_PubSubConnectionDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PubSubConnectionDataType)(nil)

// NewPubSubConnectionDataType factory function for _PubSubConnectionDataType
func NewPubSubConnectionDataType(name PascalString, enabled bool, publisherId Variant, transportProfileUri PascalString, address ExtensionObject, connectionProperties []KeyValuePair, transportSettings ExtensionObject, writerGroups []WriterGroupDataType, readerGroups []ReaderGroupDataType) *_PubSubConnectionDataType {
	if name == nil {
		panic("name of type PascalString for PubSubConnectionDataType must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type Variant for PubSubConnectionDataType must not be nil")
	}
	if transportProfileUri == nil {
		panic("transportProfileUri of type PascalString for PubSubConnectionDataType must not be nil")
	}
	if address == nil {
		panic("address of type ExtensionObject for PubSubConnectionDataType must not be nil")
	}
	if transportSettings == nil {
		panic("transportSettings of type ExtensionObject for PubSubConnectionDataType must not be nil")
	}
	_result := &_PubSubConnectionDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		Enabled:                           enabled,
		PublisherId:                       publisherId,
		TransportProfileUri:               transportProfileUri,
		Address:                           address,
		ConnectionProperties:              connectionProperties,
		TransportSettings:                 transportSettings,
		WriterGroups:                      writerGroups,
		ReaderGroups:                      readerGroups,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PubSubConnectionDataTypeBuilder is a builder for PubSubConnectionDataType
type PubSubConnectionDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, enabled bool, publisherId Variant, transportProfileUri PascalString, address ExtensionObject, connectionProperties []KeyValuePair, transportSettings ExtensionObject, writerGroups []WriterGroupDataType, readerGroups []ReaderGroupDataType) PubSubConnectionDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) PubSubConnectionDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) PubSubConnectionDataTypeBuilder
	// WithEnabled adds Enabled (property field)
	WithEnabled(bool) PubSubConnectionDataTypeBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(Variant) PubSubConnectionDataTypeBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(VariantBuilder) VariantBuilder) PubSubConnectionDataTypeBuilder
	// WithTransportProfileUri adds TransportProfileUri (property field)
	WithTransportProfileUri(PascalString) PubSubConnectionDataTypeBuilder
	// WithTransportProfileUriBuilder adds TransportProfileUri (property field) which is build by the builder
	WithTransportProfileUriBuilder(func(PascalStringBuilder) PascalStringBuilder) PubSubConnectionDataTypeBuilder
	// WithAddress adds Address (property field)
	WithAddress(ExtensionObject) PubSubConnectionDataTypeBuilder
	// WithAddressBuilder adds Address (property field) which is build by the builder
	WithAddressBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) PubSubConnectionDataTypeBuilder
	// WithConnectionProperties adds ConnectionProperties (property field)
	WithConnectionProperties(...KeyValuePair) PubSubConnectionDataTypeBuilder
	// WithTransportSettings adds TransportSettings (property field)
	WithTransportSettings(ExtensionObject) PubSubConnectionDataTypeBuilder
	// WithTransportSettingsBuilder adds TransportSettings (property field) which is build by the builder
	WithTransportSettingsBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) PubSubConnectionDataTypeBuilder
	// WithWriterGroups adds WriterGroups (property field)
	WithWriterGroups(...WriterGroupDataType) PubSubConnectionDataTypeBuilder
	// WithReaderGroups adds ReaderGroups (property field)
	WithReaderGroups(...ReaderGroupDataType) PubSubConnectionDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PubSubConnectionDataType or returns an error if something is wrong
	Build() (PubSubConnectionDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PubSubConnectionDataType
}

// NewPubSubConnectionDataTypeBuilder() creates a PubSubConnectionDataTypeBuilder
func NewPubSubConnectionDataTypeBuilder() PubSubConnectionDataTypeBuilder {
	return &_PubSubConnectionDataTypeBuilder{_PubSubConnectionDataType: new(_PubSubConnectionDataType)}
}

type _PubSubConnectionDataTypeBuilder struct {
	*_PubSubConnectionDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (PubSubConnectionDataTypeBuilder) = (*_PubSubConnectionDataTypeBuilder)(nil)

func (b *_PubSubConnectionDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PubSubConnectionDataType
}

func (b *_PubSubConnectionDataTypeBuilder) WithMandatoryFields(name PascalString, enabled bool, publisherId Variant, transportProfileUri PascalString, address ExtensionObject, connectionProperties []KeyValuePair, transportSettings ExtensionObject, writerGroups []WriterGroupDataType, readerGroups []ReaderGroupDataType) PubSubConnectionDataTypeBuilder {
	return b.WithName(name).WithEnabled(enabled).WithPublisherId(publisherId).WithTransportProfileUri(transportProfileUri).WithAddress(address).WithConnectionProperties(connectionProperties...).WithTransportSettings(transportSettings).WithWriterGroups(writerGroups...).WithReaderGroups(readerGroups...)
}

func (b *_PubSubConnectionDataTypeBuilder) WithName(name PascalString) PubSubConnectionDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PubSubConnectionDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithEnabled(enabled bool) PubSubConnectionDataTypeBuilder {
	b.Enabled = enabled
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithPublisherId(publisherId Variant) PubSubConnectionDataTypeBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithPublisherIdBuilder(builderSupplier func(VariantBuilder) VariantBuilder) PubSubConnectionDataTypeBuilder {
	builder := builderSupplier(b.PublisherId.CreateVariantBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithTransportProfileUri(transportProfileUri PascalString) PubSubConnectionDataTypeBuilder {
	b.TransportProfileUri = transportProfileUri
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithTransportProfileUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PubSubConnectionDataTypeBuilder {
	builder := builderSupplier(b.TransportProfileUri.CreatePascalStringBuilder())
	var err error
	b.TransportProfileUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithAddress(address ExtensionObject) PubSubConnectionDataTypeBuilder {
	b.Address = address
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithAddressBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) PubSubConnectionDataTypeBuilder {
	builder := builderSupplier(b.Address.CreateExtensionObjectBuilder())
	var err error
	b.Address, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithConnectionProperties(connectionProperties ...KeyValuePair) PubSubConnectionDataTypeBuilder {
	b.ConnectionProperties = connectionProperties
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithTransportSettings(transportSettings ExtensionObject) PubSubConnectionDataTypeBuilder {
	b.TransportSettings = transportSettings
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithTransportSettingsBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) PubSubConnectionDataTypeBuilder {
	builder := builderSupplier(b.TransportSettings.CreateExtensionObjectBuilder())
	var err error
	b.TransportSettings, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithWriterGroups(writerGroups ...WriterGroupDataType) PubSubConnectionDataTypeBuilder {
	b.WriterGroups = writerGroups
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) WithReaderGroups(readerGroups ...ReaderGroupDataType) PubSubConnectionDataTypeBuilder {
	b.ReaderGroups = readerGroups
	return b
}

func (b *_PubSubConnectionDataTypeBuilder) Build() (PubSubConnectionDataType, error) {
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.PublisherId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publisherId' not set"))
	}
	if b.TransportProfileUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'transportProfileUri' not set"))
	}
	if b.Address == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'address' not set"))
	}
	if b.TransportSettings == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'transportSettings' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._PubSubConnectionDataType.deepCopy(), nil
}

func (b *_PubSubConnectionDataTypeBuilder) MustBuild() PubSubConnectionDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PubSubConnectionDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PubSubConnectionDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PubSubConnectionDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePubSubConnectionDataTypeBuilder().(*_PubSubConnectionDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreatePubSubConnectionDataTypeBuilder creates a PubSubConnectionDataTypeBuilder
func (b *_PubSubConnectionDataType) CreatePubSubConnectionDataTypeBuilder() PubSubConnectionDataTypeBuilder {
	if b == nil {
		return NewPubSubConnectionDataTypeBuilder()
	}
	return &_PubSubConnectionDataTypeBuilder{_PubSubConnectionDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PubSubConnectionDataType) GetExtensionId() int32 {
	return int32(15619)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PubSubConnectionDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PubSubConnectionDataType) GetName() PascalString {
	return m.Name
}

func (m *_PubSubConnectionDataType) GetEnabled() bool {
	return m.Enabled
}

func (m *_PubSubConnectionDataType) GetPublisherId() Variant {
	return m.PublisherId
}

func (m *_PubSubConnectionDataType) GetTransportProfileUri() PascalString {
	return m.TransportProfileUri
}

func (m *_PubSubConnectionDataType) GetAddress() ExtensionObject {
	return m.Address
}

func (m *_PubSubConnectionDataType) GetConnectionProperties() []KeyValuePair {
	return m.ConnectionProperties
}

func (m *_PubSubConnectionDataType) GetTransportSettings() ExtensionObject {
	return m.TransportSettings
}

func (m *_PubSubConnectionDataType) GetWriterGroups() []WriterGroupDataType {
	return m.WriterGroups
}

func (m *_PubSubConnectionDataType) GetReaderGroups() []ReaderGroupDataType {
	return m.ReaderGroups
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPubSubConnectionDataType(structType any) PubSubConnectionDataType {
	if casted, ok := structType.(PubSubConnectionDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PubSubConnectionDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PubSubConnectionDataType) GetTypeName() string {
	return "PubSubConnectionDataType"
}

func (m *_PubSubConnectionDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (enabled)
	lengthInBits += 1

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (transportProfileUri)
	lengthInBits += m.TransportProfileUri.GetLengthInBits(ctx)

	// Simple field (address)
	lengthInBits += m.Address.GetLengthInBits(ctx)

	// Implicit Field (noOfConnectionProperties)
	lengthInBits += 32

	// Array field
	if len(m.ConnectionProperties) > 0 {
		for _curItem, element := range m.ConnectionProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ConnectionProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (transportSettings)
	lengthInBits += m.TransportSettings.GetLengthInBits(ctx)

	// Implicit Field (noOfWriterGroups)
	lengthInBits += 32

	// Array field
	if len(m.WriterGroups) > 0 {
		for _curItem, element := range m.WriterGroups {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.WriterGroups), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfReaderGroups)
	lengthInBits += 32

	// Array field
	if len(m.ReaderGroups) > 0 {
		for _curItem, element := range m.ReaderGroups {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ReaderGroups), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PubSubConnectionDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PubSubConnectionDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__pubSubConnectionDataType PubSubConnectionDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PubSubConnectionDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PubSubConnectionDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	enabled, err := ReadSimpleField(ctx, "enabled", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enabled' field"))
	}
	m.Enabled = enabled

	publisherId, err := ReadSimpleField[Variant](ctx, "publisherId", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	transportProfileUri, err := ReadSimpleField[PascalString](ctx, "transportProfileUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportProfileUri' field"))
	}
	m.TransportProfileUri = transportProfileUri

	address, err := ReadSimpleField[ExtensionObject](ctx, "address", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	noOfConnectionProperties, err := ReadImplicitField[int32](ctx, "noOfConnectionProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfConnectionProperties' field"))
	}
	_ = noOfConnectionProperties

	connectionProperties, err := ReadCountArrayField[KeyValuePair](ctx, "connectionProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfConnectionProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'connectionProperties' field"))
	}
	m.ConnectionProperties = connectionProperties

	transportSettings, err := ReadSimpleField[ExtensionObject](ctx, "transportSettings", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportSettings' field"))
	}
	m.TransportSettings = transportSettings

	noOfWriterGroups, err := ReadImplicitField[int32](ctx, "noOfWriterGroups", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfWriterGroups' field"))
	}
	_ = noOfWriterGroups

	writerGroups, err := ReadCountArrayField[WriterGroupDataType](ctx, "writerGroups", ReadComplex[WriterGroupDataType](ExtensionObjectDefinitionParseWithBufferProducer[WriterGroupDataType]((int32)(int32(15482))), readBuffer), uint64(noOfWriterGroups))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroups' field"))
	}
	m.WriterGroups = writerGroups

	noOfReaderGroups, err := ReadImplicitField[int32](ctx, "noOfReaderGroups", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfReaderGroups' field"))
	}
	_ = noOfReaderGroups

	readerGroups, err := ReadCountArrayField[ReaderGroupDataType](ctx, "readerGroups", ReadComplex[ReaderGroupDataType](ExtensionObjectDefinitionParseWithBufferProducer[ReaderGroupDataType]((int32)(int32(15522))), readBuffer), uint64(noOfReaderGroups))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'readerGroups' field"))
	}
	m.ReaderGroups = readerGroups

	if closeErr := readBuffer.CloseContext("PubSubConnectionDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PubSubConnectionDataType")
	}

	return m, nil
}

func (m *_PubSubConnectionDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PubSubConnectionDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PubSubConnectionDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PubSubConnectionDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "enabled", m.GetEnabled(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'enabled' field")
		}

		if err := WriteSimpleField[Variant](ctx, "publisherId", m.GetPublisherId(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "transportProfileUri", m.GetTransportProfileUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'transportProfileUri' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "address", m.GetAddress(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}
		noOfConnectionProperties := int32(utils.InlineIf(bool((m.GetConnectionProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetConnectionProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfConnectionProperties", noOfConnectionProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfConnectionProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "connectionProperties", m.GetConnectionProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'connectionProperties' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "transportSettings", m.GetTransportSettings(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'transportSettings' field")
		}
		noOfWriterGroups := int32(utils.InlineIf(bool((m.GetWriterGroups()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetWriterGroups()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfWriterGroups", noOfWriterGroups, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfWriterGroups' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "writerGroups", m.GetWriterGroups(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroups' field")
		}
		noOfReaderGroups := int32(utils.InlineIf(bool((m.GetReaderGroups()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetReaderGroups()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfReaderGroups", noOfReaderGroups, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfReaderGroups' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "readerGroups", m.GetReaderGroups(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'readerGroups' field")
		}

		if popErr := writeBuffer.PopContext("PubSubConnectionDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PubSubConnectionDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PubSubConnectionDataType) IsPubSubConnectionDataType() {}

func (m *_PubSubConnectionDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PubSubConnectionDataType) deepCopy() *_PubSubConnectionDataType {
	if m == nil {
		return nil
	}
	_PubSubConnectionDataTypeCopy := &_PubSubConnectionDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		m.Enabled,
		utils.DeepCopy[Variant](m.PublisherId),
		utils.DeepCopy[PascalString](m.TransportProfileUri),
		utils.DeepCopy[ExtensionObject](m.Address),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.ConnectionProperties),
		utils.DeepCopy[ExtensionObject](m.TransportSettings),
		utils.DeepCopySlice[WriterGroupDataType, WriterGroupDataType](m.WriterGroups),
		utils.DeepCopySlice[ReaderGroupDataType, ReaderGroupDataType](m.ReaderGroups),
		m.reservedField0,
	}
	_PubSubConnectionDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PubSubConnectionDataTypeCopy
}

func (m *_PubSubConnectionDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
