/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ProgramDiagnosticDataType is the corresponding interface of ProgramDiagnosticDataType
type ProgramDiagnosticDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetCreateSessionId returns CreateSessionId (property field)
	GetCreateSessionId() NodeId
	// GetCreateClientName returns CreateClientName (property field)
	GetCreateClientName() PascalString
	// GetInvocationCreationTime returns InvocationCreationTime (property field)
	GetInvocationCreationTime() int64
	// GetLastTransitionTime returns LastTransitionTime (property field)
	GetLastTransitionTime() int64
	// GetLastMethodCall returns LastMethodCall (property field)
	GetLastMethodCall() PascalString
	// GetLastMethodSessionId returns LastMethodSessionId (property field)
	GetLastMethodSessionId() NodeId
	// GetLastMethodInputArguments returns LastMethodInputArguments (property field)
	GetLastMethodInputArguments() []Argument
	// GetLastMethodOutputArguments returns LastMethodOutputArguments (property field)
	GetLastMethodOutputArguments() []Argument
	// GetLastMethodCallTime returns LastMethodCallTime (property field)
	GetLastMethodCallTime() int64
	// GetLastMethodReturnStatus returns LastMethodReturnStatus (property field)
	GetLastMethodReturnStatus() StatusResult
	// IsProgramDiagnosticDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsProgramDiagnosticDataType()
	// CreateBuilder creates a ProgramDiagnosticDataTypeBuilder
	CreateProgramDiagnosticDataTypeBuilder() ProgramDiagnosticDataTypeBuilder
}

// _ProgramDiagnosticDataType is the data-structure of this message
type _ProgramDiagnosticDataType struct {
	ExtensionObjectDefinitionContract
	CreateSessionId           NodeId
	CreateClientName          PascalString
	InvocationCreationTime    int64
	LastTransitionTime        int64
	LastMethodCall            PascalString
	LastMethodSessionId       NodeId
	LastMethodInputArguments  []Argument
	LastMethodOutputArguments []Argument
	LastMethodCallTime        int64
	LastMethodReturnStatus    StatusResult
}

var _ ProgramDiagnosticDataType = (*_ProgramDiagnosticDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ProgramDiagnosticDataType)(nil)

// NewProgramDiagnosticDataType factory function for _ProgramDiagnosticDataType
func NewProgramDiagnosticDataType(createSessionId NodeId, createClientName PascalString, invocationCreationTime int64, lastTransitionTime int64, lastMethodCall PascalString, lastMethodSessionId NodeId, lastMethodInputArguments []Argument, lastMethodOutputArguments []Argument, lastMethodCallTime int64, lastMethodReturnStatus StatusResult) *_ProgramDiagnosticDataType {
	if createSessionId == nil {
		panic("createSessionId of type NodeId for ProgramDiagnosticDataType must not be nil")
	}
	if createClientName == nil {
		panic("createClientName of type PascalString for ProgramDiagnosticDataType must not be nil")
	}
	if lastMethodCall == nil {
		panic("lastMethodCall of type PascalString for ProgramDiagnosticDataType must not be nil")
	}
	if lastMethodSessionId == nil {
		panic("lastMethodSessionId of type NodeId for ProgramDiagnosticDataType must not be nil")
	}
	if lastMethodReturnStatus == nil {
		panic("lastMethodReturnStatus of type StatusResult for ProgramDiagnosticDataType must not be nil")
	}
	_result := &_ProgramDiagnosticDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		CreateSessionId:                   createSessionId,
		CreateClientName:                  createClientName,
		InvocationCreationTime:            invocationCreationTime,
		LastTransitionTime:                lastTransitionTime,
		LastMethodCall:                    lastMethodCall,
		LastMethodSessionId:               lastMethodSessionId,
		LastMethodInputArguments:          lastMethodInputArguments,
		LastMethodOutputArguments:         lastMethodOutputArguments,
		LastMethodCallTime:                lastMethodCallTime,
		LastMethodReturnStatus:            lastMethodReturnStatus,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ProgramDiagnosticDataTypeBuilder is a builder for ProgramDiagnosticDataType
type ProgramDiagnosticDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(createSessionId NodeId, createClientName PascalString, invocationCreationTime int64, lastTransitionTime int64, lastMethodCall PascalString, lastMethodSessionId NodeId, lastMethodInputArguments []Argument, lastMethodOutputArguments []Argument, lastMethodCallTime int64, lastMethodReturnStatus StatusResult) ProgramDiagnosticDataTypeBuilder
	// WithCreateSessionId adds CreateSessionId (property field)
	WithCreateSessionId(NodeId) ProgramDiagnosticDataTypeBuilder
	// WithCreateSessionIdBuilder adds CreateSessionId (property field) which is build by the builder
	WithCreateSessionIdBuilder(func(NodeIdBuilder) NodeIdBuilder) ProgramDiagnosticDataTypeBuilder
	// WithCreateClientName adds CreateClientName (property field)
	WithCreateClientName(PascalString) ProgramDiagnosticDataTypeBuilder
	// WithCreateClientNameBuilder adds CreateClientName (property field) which is build by the builder
	WithCreateClientNameBuilder(func(PascalStringBuilder) PascalStringBuilder) ProgramDiagnosticDataTypeBuilder
	// WithInvocationCreationTime adds InvocationCreationTime (property field)
	WithInvocationCreationTime(int64) ProgramDiagnosticDataTypeBuilder
	// WithLastTransitionTime adds LastTransitionTime (property field)
	WithLastTransitionTime(int64) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodCall adds LastMethodCall (property field)
	WithLastMethodCall(PascalString) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodCallBuilder adds LastMethodCall (property field) which is build by the builder
	WithLastMethodCallBuilder(func(PascalStringBuilder) PascalStringBuilder) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodSessionId adds LastMethodSessionId (property field)
	WithLastMethodSessionId(NodeId) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodSessionIdBuilder adds LastMethodSessionId (property field) which is build by the builder
	WithLastMethodSessionIdBuilder(func(NodeIdBuilder) NodeIdBuilder) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodInputArguments adds LastMethodInputArguments (property field)
	WithLastMethodInputArguments(...Argument) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodOutputArguments adds LastMethodOutputArguments (property field)
	WithLastMethodOutputArguments(...Argument) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodCallTime adds LastMethodCallTime (property field)
	WithLastMethodCallTime(int64) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodReturnStatus adds LastMethodReturnStatus (property field)
	WithLastMethodReturnStatus(StatusResult) ProgramDiagnosticDataTypeBuilder
	// WithLastMethodReturnStatusBuilder adds LastMethodReturnStatus (property field) which is build by the builder
	WithLastMethodReturnStatusBuilder(func(StatusResultBuilder) StatusResultBuilder) ProgramDiagnosticDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ProgramDiagnosticDataType or returns an error if something is wrong
	Build() (ProgramDiagnosticDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ProgramDiagnosticDataType
}

// NewProgramDiagnosticDataTypeBuilder() creates a ProgramDiagnosticDataTypeBuilder
func NewProgramDiagnosticDataTypeBuilder() ProgramDiagnosticDataTypeBuilder {
	return &_ProgramDiagnosticDataTypeBuilder{_ProgramDiagnosticDataType: new(_ProgramDiagnosticDataType)}
}

type _ProgramDiagnosticDataTypeBuilder struct {
	*_ProgramDiagnosticDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ProgramDiagnosticDataTypeBuilder) = (*_ProgramDiagnosticDataTypeBuilder)(nil)

func (b *_ProgramDiagnosticDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ProgramDiagnosticDataType
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithMandatoryFields(createSessionId NodeId, createClientName PascalString, invocationCreationTime int64, lastTransitionTime int64, lastMethodCall PascalString, lastMethodSessionId NodeId, lastMethodInputArguments []Argument, lastMethodOutputArguments []Argument, lastMethodCallTime int64, lastMethodReturnStatus StatusResult) ProgramDiagnosticDataTypeBuilder {
	return b.WithCreateSessionId(createSessionId).WithCreateClientName(createClientName).WithInvocationCreationTime(invocationCreationTime).WithLastTransitionTime(lastTransitionTime).WithLastMethodCall(lastMethodCall).WithLastMethodSessionId(lastMethodSessionId).WithLastMethodInputArguments(lastMethodInputArguments...).WithLastMethodOutputArguments(lastMethodOutputArguments...).WithLastMethodCallTime(lastMethodCallTime).WithLastMethodReturnStatus(lastMethodReturnStatus)
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithCreateSessionId(createSessionId NodeId) ProgramDiagnosticDataTypeBuilder {
	b.CreateSessionId = createSessionId
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithCreateSessionIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ProgramDiagnosticDataTypeBuilder {
	builder := builderSupplier(b.CreateSessionId.CreateNodeIdBuilder())
	var err error
	b.CreateSessionId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithCreateClientName(createClientName PascalString) ProgramDiagnosticDataTypeBuilder {
	b.CreateClientName = createClientName
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithCreateClientNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ProgramDiagnosticDataTypeBuilder {
	builder := builderSupplier(b.CreateClientName.CreatePascalStringBuilder())
	var err error
	b.CreateClientName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithInvocationCreationTime(invocationCreationTime int64) ProgramDiagnosticDataTypeBuilder {
	b.InvocationCreationTime = invocationCreationTime
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastTransitionTime(lastTransitionTime int64) ProgramDiagnosticDataTypeBuilder {
	b.LastTransitionTime = lastTransitionTime
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodCall(lastMethodCall PascalString) ProgramDiagnosticDataTypeBuilder {
	b.LastMethodCall = lastMethodCall
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodCallBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ProgramDiagnosticDataTypeBuilder {
	builder := builderSupplier(b.LastMethodCall.CreatePascalStringBuilder())
	var err error
	b.LastMethodCall, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodSessionId(lastMethodSessionId NodeId) ProgramDiagnosticDataTypeBuilder {
	b.LastMethodSessionId = lastMethodSessionId
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodSessionIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ProgramDiagnosticDataTypeBuilder {
	builder := builderSupplier(b.LastMethodSessionId.CreateNodeIdBuilder())
	var err error
	b.LastMethodSessionId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodInputArguments(lastMethodInputArguments ...Argument) ProgramDiagnosticDataTypeBuilder {
	b.LastMethodInputArguments = lastMethodInputArguments
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodOutputArguments(lastMethodOutputArguments ...Argument) ProgramDiagnosticDataTypeBuilder {
	b.LastMethodOutputArguments = lastMethodOutputArguments
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodCallTime(lastMethodCallTime int64) ProgramDiagnosticDataTypeBuilder {
	b.LastMethodCallTime = lastMethodCallTime
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodReturnStatus(lastMethodReturnStatus StatusResult) ProgramDiagnosticDataTypeBuilder {
	b.LastMethodReturnStatus = lastMethodReturnStatus
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) WithLastMethodReturnStatusBuilder(builderSupplier func(StatusResultBuilder) StatusResultBuilder) ProgramDiagnosticDataTypeBuilder {
	builder := builderSupplier(b.LastMethodReturnStatus.CreateStatusResultBuilder())
	var err error
	b.LastMethodReturnStatus, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "StatusResultBuilder failed"))
	}
	return b
}

func (b *_ProgramDiagnosticDataTypeBuilder) Build() (ProgramDiagnosticDataType, error) {
	if b.CreateSessionId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'createSessionId' not set"))
	}
	if b.CreateClientName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'createClientName' not set"))
	}
	if b.LastMethodCall == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'lastMethodCall' not set"))
	}
	if b.LastMethodSessionId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'lastMethodSessionId' not set"))
	}
	if b.LastMethodReturnStatus == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'lastMethodReturnStatus' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ProgramDiagnosticDataType.deepCopy(), nil
}

func (b *_ProgramDiagnosticDataTypeBuilder) MustBuild() ProgramDiagnosticDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ProgramDiagnosticDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ProgramDiagnosticDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ProgramDiagnosticDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateProgramDiagnosticDataTypeBuilder().(*_ProgramDiagnosticDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateProgramDiagnosticDataTypeBuilder creates a ProgramDiagnosticDataTypeBuilder
func (b *_ProgramDiagnosticDataType) CreateProgramDiagnosticDataTypeBuilder() ProgramDiagnosticDataTypeBuilder {
	if b == nil {
		return NewProgramDiagnosticDataTypeBuilder()
	}
	return &_ProgramDiagnosticDataTypeBuilder{_ProgramDiagnosticDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ProgramDiagnosticDataType) GetExtensionId() int32 {
	return int32(896)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ProgramDiagnosticDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ProgramDiagnosticDataType) GetCreateSessionId() NodeId {
	return m.CreateSessionId
}

func (m *_ProgramDiagnosticDataType) GetCreateClientName() PascalString {
	return m.CreateClientName
}

func (m *_ProgramDiagnosticDataType) GetInvocationCreationTime() int64 {
	return m.InvocationCreationTime
}

func (m *_ProgramDiagnosticDataType) GetLastTransitionTime() int64 {
	return m.LastTransitionTime
}

func (m *_ProgramDiagnosticDataType) GetLastMethodCall() PascalString {
	return m.LastMethodCall
}

func (m *_ProgramDiagnosticDataType) GetLastMethodSessionId() NodeId {
	return m.LastMethodSessionId
}

func (m *_ProgramDiagnosticDataType) GetLastMethodInputArguments() []Argument {
	return m.LastMethodInputArguments
}

func (m *_ProgramDiagnosticDataType) GetLastMethodOutputArguments() []Argument {
	return m.LastMethodOutputArguments
}

func (m *_ProgramDiagnosticDataType) GetLastMethodCallTime() int64 {
	return m.LastMethodCallTime
}

func (m *_ProgramDiagnosticDataType) GetLastMethodReturnStatus() StatusResult {
	return m.LastMethodReturnStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastProgramDiagnosticDataType(structType any) ProgramDiagnosticDataType {
	if casted, ok := structType.(ProgramDiagnosticDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ProgramDiagnosticDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ProgramDiagnosticDataType) GetTypeName() string {
	return "ProgramDiagnosticDataType"
}

func (m *_ProgramDiagnosticDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (createSessionId)
	lengthInBits += m.CreateSessionId.GetLengthInBits(ctx)

	// Simple field (createClientName)
	lengthInBits += m.CreateClientName.GetLengthInBits(ctx)

	// Simple field (invocationCreationTime)
	lengthInBits += 64

	// Simple field (lastTransitionTime)
	lengthInBits += 64

	// Simple field (lastMethodCall)
	lengthInBits += m.LastMethodCall.GetLengthInBits(ctx)

	// Simple field (lastMethodSessionId)
	lengthInBits += m.LastMethodSessionId.GetLengthInBits(ctx)

	// Implicit Field (noOfLastMethodInputArguments)
	lengthInBits += 32

	// Array field
	if len(m.LastMethodInputArguments) > 0 {
		for _curItem, element := range m.LastMethodInputArguments {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.LastMethodInputArguments), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfLastMethodOutputArguments)
	lengthInBits += 32

	// Array field
	if len(m.LastMethodOutputArguments) > 0 {
		for _curItem, element := range m.LastMethodOutputArguments {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.LastMethodOutputArguments), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (lastMethodCallTime)
	lengthInBits += 64

	// Simple field (lastMethodReturnStatus)
	lengthInBits += m.LastMethodReturnStatus.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ProgramDiagnosticDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ProgramDiagnosticDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__programDiagnosticDataType ProgramDiagnosticDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ProgramDiagnosticDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ProgramDiagnosticDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	createSessionId, err := ReadSimpleField[NodeId](ctx, "createSessionId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'createSessionId' field"))
	}
	m.CreateSessionId = createSessionId

	createClientName, err := ReadSimpleField[PascalString](ctx, "createClientName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'createClientName' field"))
	}
	m.CreateClientName = createClientName

	invocationCreationTime, err := ReadSimpleField(ctx, "invocationCreationTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'invocationCreationTime' field"))
	}
	m.InvocationCreationTime = invocationCreationTime

	lastTransitionTime, err := ReadSimpleField(ctx, "lastTransitionTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastTransitionTime' field"))
	}
	m.LastTransitionTime = lastTransitionTime

	lastMethodCall, err := ReadSimpleField[PascalString](ctx, "lastMethodCall", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastMethodCall' field"))
	}
	m.LastMethodCall = lastMethodCall

	lastMethodSessionId, err := ReadSimpleField[NodeId](ctx, "lastMethodSessionId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastMethodSessionId' field"))
	}
	m.LastMethodSessionId = lastMethodSessionId

	noOfLastMethodInputArguments, err := ReadImplicitField[int32](ctx, "noOfLastMethodInputArguments", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfLastMethodInputArguments' field"))
	}
	_ = noOfLastMethodInputArguments

	lastMethodInputArguments, err := ReadCountArrayField[Argument](ctx, "lastMethodInputArguments", ReadComplex[Argument](ExtensionObjectDefinitionParseWithBufferProducer[Argument]((int32)(int32(298))), readBuffer), uint64(noOfLastMethodInputArguments))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastMethodInputArguments' field"))
	}
	m.LastMethodInputArguments = lastMethodInputArguments

	noOfLastMethodOutputArguments, err := ReadImplicitField[int32](ctx, "noOfLastMethodOutputArguments", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfLastMethodOutputArguments' field"))
	}
	_ = noOfLastMethodOutputArguments

	lastMethodOutputArguments, err := ReadCountArrayField[Argument](ctx, "lastMethodOutputArguments", ReadComplex[Argument](ExtensionObjectDefinitionParseWithBufferProducer[Argument]((int32)(int32(298))), readBuffer), uint64(noOfLastMethodOutputArguments))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastMethodOutputArguments' field"))
	}
	m.LastMethodOutputArguments = lastMethodOutputArguments

	lastMethodCallTime, err := ReadSimpleField(ctx, "lastMethodCallTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastMethodCallTime' field"))
	}
	m.LastMethodCallTime = lastMethodCallTime

	lastMethodReturnStatus, err := ReadSimpleField[StatusResult](ctx, "lastMethodReturnStatus", ReadComplex[StatusResult](ExtensionObjectDefinitionParseWithBufferProducer[StatusResult]((int32)(int32(301))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastMethodReturnStatus' field"))
	}
	m.LastMethodReturnStatus = lastMethodReturnStatus

	if closeErr := readBuffer.CloseContext("ProgramDiagnosticDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ProgramDiagnosticDataType")
	}

	return m, nil
}

func (m *_ProgramDiagnosticDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ProgramDiagnosticDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ProgramDiagnosticDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ProgramDiagnosticDataType")
		}

		if err := WriteSimpleField[NodeId](ctx, "createSessionId", m.GetCreateSessionId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'createSessionId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "createClientName", m.GetCreateClientName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'createClientName' field")
		}

		if err := WriteSimpleField[int64](ctx, "invocationCreationTime", m.GetInvocationCreationTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'invocationCreationTime' field")
		}

		if err := WriteSimpleField[int64](ctx, "lastTransitionTime", m.GetLastTransitionTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastTransitionTime' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "lastMethodCall", m.GetLastMethodCall(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastMethodCall' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "lastMethodSessionId", m.GetLastMethodSessionId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastMethodSessionId' field")
		}
		noOfLastMethodInputArguments := int32(utils.InlineIf(bool((m.GetLastMethodInputArguments()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetLastMethodInputArguments()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfLastMethodInputArguments", noOfLastMethodInputArguments, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfLastMethodInputArguments' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "lastMethodInputArguments", m.GetLastMethodInputArguments(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'lastMethodInputArguments' field")
		}
		noOfLastMethodOutputArguments := int32(utils.InlineIf(bool((m.GetLastMethodOutputArguments()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetLastMethodOutputArguments()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfLastMethodOutputArguments", noOfLastMethodOutputArguments, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfLastMethodOutputArguments' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "lastMethodOutputArguments", m.GetLastMethodOutputArguments(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'lastMethodOutputArguments' field")
		}

		if err := WriteSimpleField[int64](ctx, "lastMethodCallTime", m.GetLastMethodCallTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastMethodCallTime' field")
		}

		if err := WriteSimpleField[StatusResult](ctx, "lastMethodReturnStatus", m.GetLastMethodReturnStatus(), WriteComplex[StatusResult](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastMethodReturnStatus' field")
		}

		if popErr := writeBuffer.PopContext("ProgramDiagnosticDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ProgramDiagnosticDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ProgramDiagnosticDataType) IsProgramDiagnosticDataType() {}

func (m *_ProgramDiagnosticDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ProgramDiagnosticDataType) deepCopy() *_ProgramDiagnosticDataType {
	if m == nil {
		return nil
	}
	_ProgramDiagnosticDataTypeCopy := &_ProgramDiagnosticDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.CreateSessionId),
		utils.DeepCopy[PascalString](m.CreateClientName),
		m.InvocationCreationTime,
		m.LastTransitionTime,
		utils.DeepCopy[PascalString](m.LastMethodCall),
		utils.DeepCopy[NodeId](m.LastMethodSessionId),
		utils.DeepCopySlice[Argument, Argument](m.LastMethodInputArguments),
		utils.DeepCopySlice[Argument, Argument](m.LastMethodOutputArguments),
		m.LastMethodCallTime,
		utils.DeepCopy[StatusResult](m.LastMethodReturnStatus),
	}
	_ProgramDiagnosticDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ProgramDiagnosticDataTypeCopy
}

func (m *_ProgramDiagnosticDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
