/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PortableQualifiedName is the corresponding interface of PortableQualifiedName
type PortableQualifiedName interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNamespaceUri returns NamespaceUri (property field)
	GetNamespaceUri() PascalString
	// GetName returns Name (property field)
	GetName() PascalString
	// IsPortableQualifiedName is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPortableQualifiedName()
	// CreateBuilder creates a PortableQualifiedNameBuilder
	CreatePortableQualifiedNameBuilder() PortableQualifiedNameBuilder
}

// _PortableQualifiedName is the data-structure of this message
type _PortableQualifiedName struct {
	ExtensionObjectDefinitionContract
	NamespaceUri PascalString
	Name         PascalString
}

var _ PortableQualifiedName = (*_PortableQualifiedName)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PortableQualifiedName)(nil)

// NewPortableQualifiedName factory function for _PortableQualifiedName
func NewPortableQualifiedName(namespaceUri PascalString, name PascalString) *_PortableQualifiedName {
	if namespaceUri == nil {
		panic("namespaceUri of type PascalString for PortableQualifiedName must not be nil")
	}
	if name == nil {
		panic("name of type PascalString for PortableQualifiedName must not be nil")
	}
	_result := &_PortableQualifiedName{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		NamespaceUri:                      namespaceUri,
		Name:                              name,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PortableQualifiedNameBuilder is a builder for PortableQualifiedName
type PortableQualifiedNameBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(namespaceUri PascalString, name PascalString) PortableQualifiedNameBuilder
	// WithNamespaceUri adds NamespaceUri (property field)
	WithNamespaceUri(PascalString) PortableQualifiedNameBuilder
	// WithNamespaceUriBuilder adds NamespaceUri (property field) which is build by the builder
	WithNamespaceUriBuilder(func(PascalStringBuilder) PascalStringBuilder) PortableQualifiedNameBuilder
	// WithName adds Name (property field)
	WithName(PascalString) PortableQualifiedNameBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) PortableQualifiedNameBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PortableQualifiedName or returns an error if something is wrong
	Build() (PortableQualifiedName, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PortableQualifiedName
}

// NewPortableQualifiedNameBuilder() creates a PortableQualifiedNameBuilder
func NewPortableQualifiedNameBuilder() PortableQualifiedNameBuilder {
	return &_PortableQualifiedNameBuilder{_PortableQualifiedName: new(_PortableQualifiedName)}
}

type _PortableQualifiedNameBuilder struct {
	*_PortableQualifiedName

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (PortableQualifiedNameBuilder) = (*_PortableQualifiedNameBuilder)(nil)

func (b *_PortableQualifiedNameBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PortableQualifiedName
}

func (b *_PortableQualifiedNameBuilder) WithMandatoryFields(namespaceUri PascalString, name PascalString) PortableQualifiedNameBuilder {
	return b.WithNamespaceUri(namespaceUri).WithName(name)
}

func (b *_PortableQualifiedNameBuilder) WithNamespaceUri(namespaceUri PascalString) PortableQualifiedNameBuilder {
	b.NamespaceUri = namespaceUri
	return b
}

func (b *_PortableQualifiedNameBuilder) WithNamespaceUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PortableQualifiedNameBuilder {
	builder := builderSupplier(b.NamespaceUri.CreatePascalStringBuilder())
	var err error
	b.NamespaceUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PortableQualifiedNameBuilder) WithName(name PascalString) PortableQualifiedNameBuilder {
	b.Name = name
	return b
}

func (b *_PortableQualifiedNameBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) PortableQualifiedNameBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_PortableQualifiedNameBuilder) Build() (PortableQualifiedName, error) {
	if b.NamespaceUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'namespaceUri' not set"))
	}
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._PortableQualifiedName.deepCopy(), nil
}

func (b *_PortableQualifiedNameBuilder) MustBuild() PortableQualifiedName {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PortableQualifiedNameBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PortableQualifiedNameBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PortableQualifiedNameBuilder) DeepCopy() any {
	_copy := b.CreatePortableQualifiedNameBuilder().(*_PortableQualifiedNameBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreatePortableQualifiedNameBuilder creates a PortableQualifiedNameBuilder
func (b *_PortableQualifiedName) CreatePortableQualifiedNameBuilder() PortableQualifiedNameBuilder {
	if b == nil {
		return NewPortableQualifiedNameBuilder()
	}
	return &_PortableQualifiedNameBuilder{_PortableQualifiedName: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PortableQualifiedName) GetExtensionId() int32 {
	return int32(24107)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PortableQualifiedName) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PortableQualifiedName) GetNamespaceUri() PascalString {
	return m.NamespaceUri
}

func (m *_PortableQualifiedName) GetName() PascalString {
	return m.Name
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPortableQualifiedName(structType any) PortableQualifiedName {
	if casted, ok := structType.(PortableQualifiedName); ok {
		return casted
	}
	if casted, ok := structType.(*PortableQualifiedName); ok {
		return *casted
	}
	return nil
}

func (m *_PortableQualifiedName) GetTypeName() string {
	return "PortableQualifiedName"
}

func (m *_PortableQualifiedName) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (namespaceUri)
	lengthInBits += m.NamespaceUri.GetLengthInBits(ctx)

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_PortableQualifiedName) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PortableQualifiedName) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__portableQualifiedName PortableQualifiedName, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PortableQualifiedName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PortableQualifiedName")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	namespaceUri, err := ReadSimpleField[PascalString](ctx, "namespaceUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'namespaceUri' field"))
	}
	m.NamespaceUri = namespaceUri

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	if closeErr := readBuffer.CloseContext("PortableQualifiedName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PortableQualifiedName")
	}

	return m, nil
}

func (m *_PortableQualifiedName) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PortableQualifiedName) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PortableQualifiedName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PortableQualifiedName")
		}

		if err := WriteSimpleField[PascalString](ctx, "namespaceUri", m.GetNamespaceUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'namespaceUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if popErr := writeBuffer.PopContext("PortableQualifiedName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PortableQualifiedName")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PortableQualifiedName) IsPortableQualifiedName() {}

func (m *_PortableQualifiedName) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PortableQualifiedName) deepCopy() *_PortableQualifiedName {
	if m == nil {
		return nil
	}
	_PortableQualifiedNameCopy := &_PortableQualifiedName{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.NamespaceUri),
		utils.DeepCopy[PascalString](m.Name),
	}
	_PortableQualifiedNameCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PortableQualifiedNameCopy
}

func (m *_PortableQualifiedName) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
