/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpenChannelMessageResponse is the corresponding interface of OpenChannelMessageResponse
type OpenChannelMessageResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	OpenChannelMessage
	// GetSecureChannelId returns SecureChannelId (property field)
	GetSecureChannelId() int32
	// GetSecurityPolicyUri returns SecurityPolicyUri (property field)
	GetSecurityPolicyUri() PascalString
	// GetSenderCertificate returns SenderCertificate (property field)
	GetSenderCertificate() PascalByteString
	// GetReceiverCertificateThumbprint returns ReceiverCertificateThumbprint (property field)
	GetReceiverCertificateThumbprint() PascalByteString
	// IsOpenChannelMessageResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsOpenChannelMessageResponse()
	// CreateBuilder creates a OpenChannelMessageResponseBuilder
	CreateOpenChannelMessageResponseBuilder() OpenChannelMessageResponseBuilder
}

// _OpenChannelMessageResponse is the data-structure of this message
type _OpenChannelMessageResponse struct {
	OpenChannelMessageContract
	SecureChannelId               int32
	SecurityPolicyUri             PascalString
	SenderCertificate             PascalByteString
	ReceiverCertificateThumbprint PascalByteString
}

var _ OpenChannelMessageResponse = (*_OpenChannelMessageResponse)(nil)
var _ OpenChannelMessageRequirements = (*_OpenChannelMessageResponse)(nil)

// NewOpenChannelMessageResponse factory function for _OpenChannelMessageResponse
func NewOpenChannelMessageResponse(secureChannelId int32, securityPolicyUri PascalString, senderCertificate PascalByteString, receiverCertificateThumbprint PascalByteString) *_OpenChannelMessageResponse {
	if securityPolicyUri == nil {
		panic("securityPolicyUri of type PascalString for OpenChannelMessageResponse must not be nil")
	}
	if senderCertificate == nil {
		panic("senderCertificate of type PascalByteString for OpenChannelMessageResponse must not be nil")
	}
	if receiverCertificateThumbprint == nil {
		panic("receiverCertificateThumbprint of type PascalByteString for OpenChannelMessageResponse must not be nil")
	}
	_result := &_OpenChannelMessageResponse{
		OpenChannelMessageContract:    NewOpenChannelMessage(),
		SecureChannelId:               secureChannelId,
		SecurityPolicyUri:             securityPolicyUri,
		SenderCertificate:             senderCertificate,
		ReceiverCertificateThumbprint: receiverCertificateThumbprint,
	}
	_result.OpenChannelMessageContract.(*_OpenChannelMessage)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// OpenChannelMessageResponseBuilder is a builder for OpenChannelMessageResponse
type OpenChannelMessageResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(secureChannelId int32, securityPolicyUri PascalString, senderCertificate PascalByteString, receiverCertificateThumbprint PascalByteString) OpenChannelMessageResponseBuilder
	// WithSecureChannelId adds SecureChannelId (property field)
	WithSecureChannelId(int32) OpenChannelMessageResponseBuilder
	// WithSecurityPolicyUri adds SecurityPolicyUri (property field)
	WithSecurityPolicyUri(PascalString) OpenChannelMessageResponseBuilder
	// WithSecurityPolicyUriBuilder adds SecurityPolicyUri (property field) which is build by the builder
	WithSecurityPolicyUriBuilder(func(PascalStringBuilder) PascalStringBuilder) OpenChannelMessageResponseBuilder
	// WithSenderCertificate adds SenderCertificate (property field)
	WithSenderCertificate(PascalByteString) OpenChannelMessageResponseBuilder
	// WithSenderCertificateBuilder adds SenderCertificate (property field) which is build by the builder
	WithSenderCertificateBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) OpenChannelMessageResponseBuilder
	// WithReceiverCertificateThumbprint adds ReceiverCertificateThumbprint (property field)
	WithReceiverCertificateThumbprint(PascalByteString) OpenChannelMessageResponseBuilder
	// WithReceiverCertificateThumbprintBuilder adds ReceiverCertificateThumbprint (property field) which is build by the builder
	WithReceiverCertificateThumbprintBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) OpenChannelMessageResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() OpenChannelMessageBuilder
	// Build builds the OpenChannelMessageResponse or returns an error if something is wrong
	Build() (OpenChannelMessageResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() OpenChannelMessageResponse
}

// NewOpenChannelMessageResponseBuilder() creates a OpenChannelMessageResponseBuilder
func NewOpenChannelMessageResponseBuilder() OpenChannelMessageResponseBuilder {
	return &_OpenChannelMessageResponseBuilder{_OpenChannelMessageResponse: new(_OpenChannelMessageResponse)}
}

type _OpenChannelMessageResponseBuilder struct {
	*_OpenChannelMessageResponse

	parentBuilder *_OpenChannelMessageBuilder

	err *utils.MultiError
}

var _ (OpenChannelMessageResponseBuilder) = (*_OpenChannelMessageResponseBuilder)(nil)

func (b *_OpenChannelMessageResponseBuilder) setParent(contract OpenChannelMessageContract) {
	b.OpenChannelMessageContract = contract
	contract.(*_OpenChannelMessage)._SubType = b._OpenChannelMessageResponse
}

func (b *_OpenChannelMessageResponseBuilder) WithMandatoryFields(secureChannelId int32, securityPolicyUri PascalString, senderCertificate PascalByteString, receiverCertificateThumbprint PascalByteString) OpenChannelMessageResponseBuilder {
	return b.WithSecureChannelId(secureChannelId).WithSecurityPolicyUri(securityPolicyUri).WithSenderCertificate(senderCertificate).WithReceiverCertificateThumbprint(receiverCertificateThumbprint)
}

func (b *_OpenChannelMessageResponseBuilder) WithSecureChannelId(secureChannelId int32) OpenChannelMessageResponseBuilder {
	b.SecureChannelId = secureChannelId
	return b
}

func (b *_OpenChannelMessageResponseBuilder) WithSecurityPolicyUri(securityPolicyUri PascalString) OpenChannelMessageResponseBuilder {
	b.SecurityPolicyUri = securityPolicyUri
	return b
}

func (b *_OpenChannelMessageResponseBuilder) WithSecurityPolicyUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) OpenChannelMessageResponseBuilder {
	builder := builderSupplier(b.SecurityPolicyUri.CreatePascalStringBuilder())
	var err error
	b.SecurityPolicyUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_OpenChannelMessageResponseBuilder) WithSenderCertificate(senderCertificate PascalByteString) OpenChannelMessageResponseBuilder {
	b.SenderCertificate = senderCertificate
	return b
}

func (b *_OpenChannelMessageResponseBuilder) WithSenderCertificateBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) OpenChannelMessageResponseBuilder {
	builder := builderSupplier(b.SenderCertificate.CreatePascalByteStringBuilder())
	var err error
	b.SenderCertificate, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_OpenChannelMessageResponseBuilder) WithReceiverCertificateThumbprint(receiverCertificateThumbprint PascalByteString) OpenChannelMessageResponseBuilder {
	b.ReceiverCertificateThumbprint = receiverCertificateThumbprint
	return b
}

func (b *_OpenChannelMessageResponseBuilder) WithReceiverCertificateThumbprintBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) OpenChannelMessageResponseBuilder {
	builder := builderSupplier(b.ReceiverCertificateThumbprint.CreatePascalByteStringBuilder())
	var err error
	b.ReceiverCertificateThumbprint, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_OpenChannelMessageResponseBuilder) Build() (OpenChannelMessageResponse, error) {
	if b.SecurityPolicyUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'securityPolicyUri' not set"))
	}
	if b.SenderCertificate == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'senderCertificate' not set"))
	}
	if b.ReceiverCertificateThumbprint == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'receiverCertificateThumbprint' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._OpenChannelMessageResponse.deepCopy(), nil
}

func (b *_OpenChannelMessageResponseBuilder) MustBuild() OpenChannelMessageResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_OpenChannelMessageResponseBuilder) Done() OpenChannelMessageBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewOpenChannelMessageBuilder().(*_OpenChannelMessageBuilder)
	}
	return b.parentBuilder
}

func (b *_OpenChannelMessageResponseBuilder) buildForOpenChannelMessage() (OpenChannelMessage, error) {
	return b.Build()
}

func (b *_OpenChannelMessageResponseBuilder) DeepCopy() any {
	_copy := b.CreateOpenChannelMessageResponseBuilder().(*_OpenChannelMessageResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateOpenChannelMessageResponseBuilder creates a OpenChannelMessageResponseBuilder
func (b *_OpenChannelMessageResponse) CreateOpenChannelMessageResponseBuilder() OpenChannelMessageResponseBuilder {
	if b == nil {
		return NewOpenChannelMessageResponseBuilder()
	}
	return &_OpenChannelMessageResponseBuilder{_OpenChannelMessageResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpenChannelMessageResponse) GetResponse() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpenChannelMessageResponse) GetParent() OpenChannelMessageContract {
	return m.OpenChannelMessageContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpenChannelMessageResponse) GetSecureChannelId() int32 {
	return m.SecureChannelId
}

func (m *_OpenChannelMessageResponse) GetSecurityPolicyUri() PascalString {
	return m.SecurityPolicyUri
}

func (m *_OpenChannelMessageResponse) GetSenderCertificate() PascalByteString {
	return m.SenderCertificate
}

func (m *_OpenChannelMessageResponse) GetReceiverCertificateThumbprint() PascalByteString {
	return m.ReceiverCertificateThumbprint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastOpenChannelMessageResponse(structType any) OpenChannelMessageResponse {
	if casted, ok := structType.(OpenChannelMessageResponse); ok {
		return casted
	}
	if casted, ok := structType.(*OpenChannelMessageResponse); ok {
		return *casted
	}
	return nil
}

func (m *_OpenChannelMessageResponse) GetTypeName() string {
	return "OpenChannelMessageResponse"
}

func (m *_OpenChannelMessageResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.OpenChannelMessageContract.(*_OpenChannelMessage).getLengthInBits(ctx))

	// Simple field (secureChannelId)
	lengthInBits += 32

	// Simple field (securityPolicyUri)
	lengthInBits += m.SecurityPolicyUri.GetLengthInBits(ctx)

	// Simple field (senderCertificate)
	lengthInBits += m.SenderCertificate.GetLengthInBits(ctx)

	// Simple field (receiverCertificateThumbprint)
	lengthInBits += m.ReceiverCertificateThumbprint.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OpenChannelMessageResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_OpenChannelMessageResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_OpenChannelMessage, response bool) (__openChannelMessageResponse OpenChannelMessageResponse, err error) {
	m.OpenChannelMessageContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("OpenChannelMessageResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpenChannelMessageResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	secureChannelId, err := ReadSimpleField(ctx, "secureChannelId", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'secureChannelId' field"))
	}
	m.SecureChannelId = secureChannelId

	securityPolicyUri, err := ReadSimpleField[PascalString](ctx, "securityPolicyUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityPolicyUri' field"))
	}
	m.SecurityPolicyUri = securityPolicyUri

	senderCertificate, err := ReadSimpleField[PascalByteString](ctx, "senderCertificate", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'senderCertificate' field"))
	}
	m.SenderCertificate = senderCertificate

	receiverCertificateThumbprint, err := ReadSimpleField[PascalByteString](ctx, "receiverCertificateThumbprint", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'receiverCertificateThumbprint' field"))
	}
	m.ReceiverCertificateThumbprint = receiverCertificateThumbprint

	if closeErr := readBuffer.CloseContext("OpenChannelMessageResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpenChannelMessageResponse")
	}

	return m, nil
}

func (m *_OpenChannelMessageResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpenChannelMessageResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpenChannelMessageResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpenChannelMessageResponse")
		}

		if err := WriteSimpleField[int32](ctx, "secureChannelId", m.GetSecureChannelId(), WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'secureChannelId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "securityPolicyUri", m.GetSecurityPolicyUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityPolicyUri' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "senderCertificate", m.GetSenderCertificate(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'senderCertificate' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "receiverCertificateThumbprint", m.GetReceiverCertificateThumbprint(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'receiverCertificateThumbprint' field")
		}

		if popErr := writeBuffer.PopContext("OpenChannelMessageResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpenChannelMessageResponse")
		}
		return nil
	}
	return m.OpenChannelMessageContract.(*_OpenChannelMessage).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_OpenChannelMessageResponse) IsOpenChannelMessageResponse() {}

func (m *_OpenChannelMessageResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_OpenChannelMessageResponse) deepCopy() *_OpenChannelMessageResponse {
	if m == nil {
		return nil
	}
	_OpenChannelMessageResponseCopy := &_OpenChannelMessageResponse{
		m.OpenChannelMessageContract.(*_OpenChannelMessage).deepCopy(),
		m.SecureChannelId,
		utils.DeepCopy[PascalString](m.SecurityPolicyUri),
		utils.DeepCopy[PascalByteString](m.SenderCertificate),
		utils.DeepCopy[PascalByteString](m.ReceiverCertificateThumbprint),
	}
	_OpenChannelMessageResponseCopy.OpenChannelMessageContract.(*_OpenChannelMessage)._SubType = m
	return _OpenChannelMessageResponseCopy
}

func (m *_OpenChannelMessageResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
