/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaCloseRequest is the corresponding interface of OpcuaCloseRequest
type OpcuaCloseRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	MessagePDU
	// GetSecurityHeader returns SecurityHeader (property field)
	GetSecurityHeader() SecurityHeader
	// GetMessage returns Message (property field)
	GetMessage() Payload
	// IsOpcuaCloseRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsOpcuaCloseRequest()
	// CreateBuilder creates a OpcuaCloseRequestBuilder
	CreateOpcuaCloseRequestBuilder() OpcuaCloseRequestBuilder
}

// _OpcuaCloseRequest is the data-structure of this message
type _OpcuaCloseRequest struct {
	MessagePDUContract
	SecurityHeader SecurityHeader
	Message        Payload
}

var _ OpcuaCloseRequest = (*_OpcuaCloseRequest)(nil)
var _ MessagePDURequirements = (*_OpcuaCloseRequest)(nil)

// NewOpcuaCloseRequest factory function for _OpcuaCloseRequest
func NewOpcuaCloseRequest(chunk ChunkType, securityHeader SecurityHeader, message Payload, binary bool) *_OpcuaCloseRequest {
	if securityHeader == nil {
		panic("securityHeader of type SecurityHeader for OpcuaCloseRequest must not be nil")
	}
	if message == nil {
		panic("message of type Payload for OpcuaCloseRequest must not be nil")
	}
	_result := &_OpcuaCloseRequest{
		MessagePDUContract: NewMessagePDU(chunk, binary),
		SecurityHeader:     securityHeader,
		Message:            message,
	}
	_result.MessagePDUContract.(*_MessagePDU)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// OpcuaCloseRequestBuilder is a builder for OpcuaCloseRequest
type OpcuaCloseRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(securityHeader SecurityHeader, message Payload) OpcuaCloseRequestBuilder
	// WithSecurityHeader adds SecurityHeader (property field)
	WithSecurityHeader(SecurityHeader) OpcuaCloseRequestBuilder
	// WithSecurityHeaderBuilder adds SecurityHeader (property field) which is build by the builder
	WithSecurityHeaderBuilder(func(SecurityHeaderBuilder) SecurityHeaderBuilder) OpcuaCloseRequestBuilder
	// WithMessage adds Message (property field)
	WithMessage(Payload) OpcuaCloseRequestBuilder
	// WithMessageBuilder adds Message (property field) which is build by the builder
	WithMessageBuilder(func(PayloadBuilder) PayloadBuilder) OpcuaCloseRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() MessagePDUBuilder
	// Build builds the OpcuaCloseRequest or returns an error if something is wrong
	Build() (OpcuaCloseRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() OpcuaCloseRequest
}

// NewOpcuaCloseRequestBuilder() creates a OpcuaCloseRequestBuilder
func NewOpcuaCloseRequestBuilder() OpcuaCloseRequestBuilder {
	return &_OpcuaCloseRequestBuilder{_OpcuaCloseRequest: new(_OpcuaCloseRequest)}
}

type _OpcuaCloseRequestBuilder struct {
	*_OpcuaCloseRequest

	parentBuilder *_MessagePDUBuilder

	err *utils.MultiError
}

var _ (OpcuaCloseRequestBuilder) = (*_OpcuaCloseRequestBuilder)(nil)

func (b *_OpcuaCloseRequestBuilder) setParent(contract MessagePDUContract) {
	b.MessagePDUContract = contract
	contract.(*_MessagePDU)._SubType = b._OpcuaCloseRequest
}

func (b *_OpcuaCloseRequestBuilder) WithMandatoryFields(securityHeader SecurityHeader, message Payload) OpcuaCloseRequestBuilder {
	return b.WithSecurityHeader(securityHeader).WithMessage(message)
}

func (b *_OpcuaCloseRequestBuilder) WithSecurityHeader(securityHeader SecurityHeader) OpcuaCloseRequestBuilder {
	b.SecurityHeader = securityHeader
	return b
}

func (b *_OpcuaCloseRequestBuilder) WithSecurityHeaderBuilder(builderSupplier func(SecurityHeaderBuilder) SecurityHeaderBuilder) OpcuaCloseRequestBuilder {
	builder := builderSupplier(b.SecurityHeader.CreateSecurityHeaderBuilder())
	var err error
	b.SecurityHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "SecurityHeaderBuilder failed"))
	}
	return b
}

func (b *_OpcuaCloseRequestBuilder) WithMessage(message Payload) OpcuaCloseRequestBuilder {
	b.Message = message
	return b
}

func (b *_OpcuaCloseRequestBuilder) WithMessageBuilder(builderSupplier func(PayloadBuilder) PayloadBuilder) OpcuaCloseRequestBuilder {
	builder := builderSupplier(b.Message.CreatePayloadBuilder())
	var err error
	b.Message, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PayloadBuilder failed"))
	}
	return b
}

func (b *_OpcuaCloseRequestBuilder) Build() (OpcuaCloseRequest, error) {
	if b.SecurityHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'securityHeader' not set"))
	}
	if b.Message == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'message' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._OpcuaCloseRequest.deepCopy(), nil
}

func (b *_OpcuaCloseRequestBuilder) MustBuild() OpcuaCloseRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_OpcuaCloseRequestBuilder) Done() MessagePDUBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewMessagePDUBuilder().(*_MessagePDUBuilder)
	}
	return b.parentBuilder
}

func (b *_OpcuaCloseRequestBuilder) buildForMessagePDU() (MessagePDU, error) {
	return b.Build()
}

func (b *_OpcuaCloseRequestBuilder) DeepCopy() any {
	_copy := b.CreateOpcuaCloseRequestBuilder().(*_OpcuaCloseRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateOpcuaCloseRequestBuilder creates a OpcuaCloseRequestBuilder
func (b *_OpcuaCloseRequest) CreateOpcuaCloseRequestBuilder() OpcuaCloseRequestBuilder {
	if b == nil {
		return NewOpcuaCloseRequestBuilder()
	}
	return &_OpcuaCloseRequestBuilder{_OpcuaCloseRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_OpcuaCloseRequest) GetMessageType() string {
	return "CLO"
}

func (m *_OpcuaCloseRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_OpcuaCloseRequest) GetParent() MessagePDUContract {
	return m.MessagePDUContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_OpcuaCloseRequest) GetSecurityHeader() SecurityHeader {
	return m.SecurityHeader
}

func (m *_OpcuaCloseRequest) GetMessage() Payload {
	return m.Message
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastOpcuaCloseRequest(structType any) OpcuaCloseRequest {
	if casted, ok := structType.(OpcuaCloseRequest); ok {
		return casted
	}
	if casted, ok := structType.(*OpcuaCloseRequest); ok {
		return *casted
	}
	return nil
}

func (m *_OpcuaCloseRequest) GetTypeName() string {
	return "OpcuaCloseRequest"
}

func (m *_OpcuaCloseRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.MessagePDUContract.(*_MessagePDU).getLengthInBits(ctx))

	// Simple field (securityHeader)
	lengthInBits += m.SecurityHeader.GetLengthInBits(ctx)

	// Simple field (message)
	lengthInBits += m.Message.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_OpcuaCloseRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_OpcuaCloseRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_MessagePDU, response bool, binary bool) (__opcuaCloseRequest OpcuaCloseRequest, err error) {
	m.MessagePDUContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("OpcuaCloseRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for OpcuaCloseRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	securityHeader, err := ReadSimpleField[SecurityHeader](ctx, "securityHeader", ReadComplex[SecurityHeader](SecurityHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityHeader' field"))
	}
	m.SecurityHeader = securityHeader

	message, err := ReadSimpleField[Payload](ctx, "message", ReadComplex[Payload](PayloadParseWithBufferProducer[Payload]((bool)(binary), (uint32)(uint32(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'message' field"))
	}
	m.Message = message

	if closeErr := readBuffer.CloseContext("OpcuaCloseRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for OpcuaCloseRequest")
	}

	return m, nil
}

func (m *_OpcuaCloseRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_OpcuaCloseRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("OpcuaCloseRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for OpcuaCloseRequest")
		}

		if err := WriteSimpleField[SecurityHeader](ctx, "securityHeader", m.GetSecurityHeader(), WriteComplex[SecurityHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityHeader' field")
		}

		if err := WriteSimpleField[Payload](ctx, "message", m.GetMessage(), WriteComplex[Payload](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'message' field")
		}

		if popErr := writeBuffer.PopContext("OpcuaCloseRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for OpcuaCloseRequest")
		}
		return nil
	}
	return m.MessagePDUContract.(*_MessagePDU).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_OpcuaCloseRequest) IsOpcuaCloseRequest() {}

func (m *_OpcuaCloseRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_OpcuaCloseRequest) deepCopy() *_OpcuaCloseRequest {
	if m == nil {
		return nil
	}
	_OpcuaCloseRequestCopy := &_OpcuaCloseRequest{
		m.MessagePDUContract.(*_MessagePDU).deepCopy(),
		utils.DeepCopy[SecurityHeader](m.SecurityHeader),
		utils.DeepCopy[Payload](m.Message),
	}
	_OpcuaCloseRequestCopy.MessagePDUContract.(*_MessagePDU)._SubType = m
	return _OpcuaCloseRequestCopy
}

func (m *_OpcuaCloseRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
