/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NameValuePair is the corresponding interface of NameValuePair
type NameValuePair interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetValue returns Value (property field)
	GetValue() Variant
	// IsNameValuePair is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNameValuePair()
	// CreateBuilder creates a NameValuePairBuilder
	CreateNameValuePairBuilder() NameValuePairBuilder
}

// _NameValuePair is the data-structure of this message
type _NameValuePair struct {
	ExtensionObjectDefinitionContract
	Name  PascalString
	Value Variant
}

var _ NameValuePair = (*_NameValuePair)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_NameValuePair)(nil)

// NewNameValuePair factory function for _NameValuePair
func NewNameValuePair(name PascalString, value Variant) *_NameValuePair {
	if name == nil {
		panic("name of type PascalString for NameValuePair must not be nil")
	}
	if value == nil {
		panic("value of type Variant for NameValuePair must not be nil")
	}
	_result := &_NameValuePair{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		Value:                             value,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NameValuePairBuilder is a builder for NameValuePair
type NameValuePairBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, value Variant) NameValuePairBuilder
	// WithName adds Name (property field)
	WithName(PascalString) NameValuePairBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) NameValuePairBuilder
	// WithValue adds Value (property field)
	WithValue(Variant) NameValuePairBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(VariantBuilder) VariantBuilder) NameValuePairBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the NameValuePair or returns an error if something is wrong
	Build() (NameValuePair, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NameValuePair
}

// NewNameValuePairBuilder() creates a NameValuePairBuilder
func NewNameValuePairBuilder() NameValuePairBuilder {
	return &_NameValuePairBuilder{_NameValuePair: new(_NameValuePair)}
}

type _NameValuePairBuilder struct {
	*_NameValuePair

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (NameValuePairBuilder) = (*_NameValuePairBuilder)(nil)

func (b *_NameValuePairBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._NameValuePair
}

func (b *_NameValuePairBuilder) WithMandatoryFields(name PascalString, value Variant) NameValuePairBuilder {
	return b.WithName(name).WithValue(value)
}

func (b *_NameValuePairBuilder) WithName(name PascalString) NameValuePairBuilder {
	b.Name = name
	return b
}

func (b *_NameValuePairBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) NameValuePairBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_NameValuePairBuilder) WithValue(value Variant) NameValuePairBuilder {
	b.Value = value
	return b
}

func (b *_NameValuePairBuilder) WithValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) NameValuePairBuilder {
	builder := builderSupplier(b.Value.CreateVariantBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_NameValuePairBuilder) Build() (NameValuePair, error) {
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.Value == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'value' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NameValuePair.deepCopy(), nil
}

func (b *_NameValuePairBuilder) MustBuild() NameValuePair {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NameValuePairBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_NameValuePairBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_NameValuePairBuilder) DeepCopy() any {
	_copy := b.CreateNameValuePairBuilder().(*_NameValuePairBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNameValuePairBuilder creates a NameValuePairBuilder
func (b *_NameValuePair) CreateNameValuePairBuilder() NameValuePairBuilder {
	if b == nil {
		return NewNameValuePairBuilder()
	}
	return &_NameValuePairBuilder{_NameValuePair: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NameValuePair) GetExtensionId() int32 {
	return int32(19750)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NameValuePair) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NameValuePair) GetName() PascalString {
	return m.Name
}

func (m *_NameValuePair) GetValue() Variant {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNameValuePair(structType any) NameValuePair {
	if casted, ok := structType.(NameValuePair); ok {
		return casted
	}
	if casted, ok := structType.(*NameValuePair); ok {
		return *casted
	}
	return nil
}

func (m *_NameValuePair) GetTypeName() string {
	return "NameValuePair"
}

func (m *_NameValuePair) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_NameValuePair) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NameValuePair) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__nameValuePair NameValuePair, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NameValuePair"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NameValuePair")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	value, err := ReadSimpleField[Variant](ctx, "value", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("NameValuePair"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NameValuePair")
	}

	return m, nil
}

func (m *_NameValuePair) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NameValuePair) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NameValuePair"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NameValuePair")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if err := WriteSimpleField[Variant](ctx, "value", m.GetValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("NameValuePair"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NameValuePair")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NameValuePair) IsNameValuePair() {}

func (m *_NameValuePair) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NameValuePair) deepCopy() *_NameValuePair {
	if m == nil {
		return nil
	}
	_NameValuePairCopy := &_NameValuePair{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopy[Variant](m.Value),
	}
	_NameValuePairCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _NameValuePairCopy
}

func (m *_NameValuePair) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
