/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LocalizedText is the corresponding interface of LocalizedText
type LocalizedText interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetTextSpecified returns TextSpecified (property field)
	GetTextSpecified() bool
	// GetLocaleSpecified returns LocaleSpecified (property field)
	GetLocaleSpecified() bool
	// GetLocale returns Locale (property field)
	GetLocale() PascalString
	// GetText returns Text (property field)
	GetText() PascalString
	// IsLocalizedText is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLocalizedText()
	// CreateBuilder creates a LocalizedTextBuilder
	CreateLocalizedTextBuilder() LocalizedTextBuilder
}

// _LocalizedText is the data-structure of this message
type _LocalizedText struct {
	TextSpecified   bool
	LocaleSpecified bool
	Locale          PascalString
	Text            PascalString
	// Reserved Fields
	reservedField0 *uint8
}

var _ LocalizedText = (*_LocalizedText)(nil)

// NewLocalizedText factory function for _LocalizedText
func NewLocalizedText(textSpecified bool, localeSpecified bool, locale PascalString, text PascalString) *_LocalizedText {
	return &_LocalizedText{TextSpecified: textSpecified, LocaleSpecified: localeSpecified, Locale: locale, Text: text}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LocalizedTextBuilder is a builder for LocalizedText
type LocalizedTextBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(textSpecified bool, localeSpecified bool) LocalizedTextBuilder
	// WithTextSpecified adds TextSpecified (property field)
	WithTextSpecified(bool) LocalizedTextBuilder
	// WithLocaleSpecified adds LocaleSpecified (property field)
	WithLocaleSpecified(bool) LocalizedTextBuilder
	// WithLocale adds Locale (property field)
	WithOptionalLocale(PascalString) LocalizedTextBuilder
	// WithOptionalLocaleBuilder adds Locale (property field) which is build by the builder
	WithOptionalLocaleBuilder(func(PascalStringBuilder) PascalStringBuilder) LocalizedTextBuilder
	// WithText adds Text (property field)
	WithOptionalText(PascalString) LocalizedTextBuilder
	// WithOptionalTextBuilder adds Text (property field) which is build by the builder
	WithOptionalTextBuilder(func(PascalStringBuilder) PascalStringBuilder) LocalizedTextBuilder
	// Build builds the LocalizedText or returns an error if something is wrong
	Build() (LocalizedText, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LocalizedText
}

// NewLocalizedTextBuilder() creates a LocalizedTextBuilder
func NewLocalizedTextBuilder() LocalizedTextBuilder {
	return &_LocalizedTextBuilder{_LocalizedText: new(_LocalizedText)}
}

type _LocalizedTextBuilder struct {
	*_LocalizedText

	err *utils.MultiError
}

var _ (LocalizedTextBuilder) = (*_LocalizedTextBuilder)(nil)

func (b *_LocalizedTextBuilder) WithMandatoryFields(textSpecified bool, localeSpecified bool) LocalizedTextBuilder {
	return b.WithTextSpecified(textSpecified).WithLocaleSpecified(localeSpecified)
}

func (b *_LocalizedTextBuilder) WithTextSpecified(textSpecified bool) LocalizedTextBuilder {
	b.TextSpecified = textSpecified
	return b
}

func (b *_LocalizedTextBuilder) WithLocaleSpecified(localeSpecified bool) LocalizedTextBuilder {
	b.LocaleSpecified = localeSpecified
	return b
}

func (b *_LocalizedTextBuilder) WithOptionalLocale(locale PascalString) LocalizedTextBuilder {
	b.Locale = locale
	return b
}

func (b *_LocalizedTextBuilder) WithOptionalLocaleBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) LocalizedTextBuilder {
	builder := builderSupplier(b.Locale.CreatePascalStringBuilder())
	var err error
	b.Locale, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_LocalizedTextBuilder) WithOptionalText(text PascalString) LocalizedTextBuilder {
	b.Text = text
	return b
}

func (b *_LocalizedTextBuilder) WithOptionalTextBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) LocalizedTextBuilder {
	builder := builderSupplier(b.Text.CreatePascalStringBuilder())
	var err error
	b.Text, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_LocalizedTextBuilder) Build() (LocalizedText, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._LocalizedText.deepCopy(), nil
}

func (b *_LocalizedTextBuilder) MustBuild() LocalizedText {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LocalizedTextBuilder) DeepCopy() any {
	_copy := b.CreateLocalizedTextBuilder().(*_LocalizedTextBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateLocalizedTextBuilder creates a LocalizedTextBuilder
func (b *_LocalizedText) CreateLocalizedTextBuilder() LocalizedTextBuilder {
	if b == nil {
		return NewLocalizedTextBuilder()
	}
	return &_LocalizedTextBuilder{_LocalizedText: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LocalizedText) GetTextSpecified() bool {
	return m.TextSpecified
}

func (m *_LocalizedText) GetLocaleSpecified() bool {
	return m.LocaleSpecified
}

func (m *_LocalizedText) GetLocale() PascalString {
	return m.Locale
}

func (m *_LocalizedText) GetText() PascalString {
	return m.Text
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLocalizedText(structType any) LocalizedText {
	if casted, ok := structType.(LocalizedText); ok {
		return casted
	}
	if casted, ok := structType.(*LocalizedText); ok {
		return *casted
	}
	return nil
}

func (m *_LocalizedText) GetTypeName() string {
	return "LocalizedText"
}

func (m *_LocalizedText) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 6

	// Simple field (textSpecified)
	lengthInBits += 1

	// Simple field (localeSpecified)
	lengthInBits += 1

	// Optional Field (locale)
	if m.Locale != nil {
		lengthInBits += m.Locale.GetLengthInBits(ctx)
	}

	// Optional Field (text)
	if m.Text != nil {
		lengthInBits += m.Text.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_LocalizedText) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func LocalizedTextParse(ctx context.Context, theBytes []byte) (LocalizedText, error) {
	return LocalizedTextParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func LocalizedTextParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (LocalizedText, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (LocalizedText, error) {
		return LocalizedTextParseWithBuffer(ctx, readBuffer)
	}
}

func LocalizedTextParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (LocalizedText, error) {
	v, err := (&_LocalizedText{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_LocalizedText) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__localizedText LocalizedText, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LocalizedText"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LocalizedText")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(6)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	textSpecified, err := ReadSimpleField(ctx, "textSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'textSpecified' field"))
	}
	m.TextSpecified = textSpecified

	localeSpecified, err := ReadSimpleField(ctx, "localeSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'localeSpecified' field"))
	}
	m.LocaleSpecified = localeSpecified

	var locale PascalString
	_locale, err := ReadOptionalField[PascalString](ctx, "locale", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), localeSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'locale' field"))
	}
	if _locale != nil {
		locale = *_locale
		m.Locale = locale
	}

	var text PascalString
	_text, err := ReadOptionalField[PascalString](ctx, "text", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), textSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'text' field"))
	}
	if _text != nil {
		text = *_text
		m.Text = text
	}

	if closeErr := readBuffer.CloseContext("LocalizedText"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LocalizedText")
	}

	return m, nil
}

func (m *_LocalizedText) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LocalizedText) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("LocalizedText"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for LocalizedText")
	}

	if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 6)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "textSpecified", m.GetTextSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'textSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "localeSpecified", m.GetLocaleSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'localeSpecified' field")
	}

	if err := WriteOptionalField[PascalString](ctx, "locale", GetRef(m.GetLocale()), WriteComplex[PascalString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'locale' field")
	}

	if err := WriteOptionalField[PascalString](ctx, "text", GetRef(m.GetText()), WriteComplex[PascalString](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'text' field")
	}

	if popErr := writeBuffer.PopContext("LocalizedText"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for LocalizedText")
	}
	return nil
}

func (m *_LocalizedText) IsLocalizedText() {}

func (m *_LocalizedText) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LocalizedText) deepCopy() *_LocalizedText {
	if m == nil {
		return nil
	}
	_LocalizedTextCopy := &_LocalizedText{
		m.TextSpecified,
		m.LocaleSpecified,
		utils.DeepCopy[PascalString](m.Locale),
		utils.DeepCopy[PascalString](m.Text),
		m.reservedField0,
	}
	return _LocalizedTextCopy
}

func (m *_LocalizedText) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
