/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LldpManagementAddressTxPortType is the corresponding interface of LldpManagementAddressTxPortType
type LldpManagementAddressTxPortType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetAddressSubtype returns AddressSubtype (property field)
	GetAddressSubtype() uint32
	// GetManAddress returns ManAddress (property field)
	GetManAddress() PascalString
	// GetTxEnable returns TxEnable (property field)
	GetTxEnable() bool
	// GetAddrLen returns AddrLen (property field)
	GetAddrLen() uint32
	// GetIfSubtype returns IfSubtype (property field)
	GetIfSubtype() ManAddrIfSubtype
	// GetIfId returns IfId (property field)
	GetIfId() uint32
	// IsLldpManagementAddressTxPortType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLldpManagementAddressTxPortType()
	// CreateBuilder creates a LldpManagementAddressTxPortTypeBuilder
	CreateLldpManagementAddressTxPortTypeBuilder() LldpManagementAddressTxPortTypeBuilder
}

// _LldpManagementAddressTxPortType is the data-structure of this message
type _LldpManagementAddressTxPortType struct {
	ExtensionObjectDefinitionContract
	AddressSubtype uint32
	ManAddress     PascalString
	TxEnable       bool
	AddrLen        uint32
	IfSubtype      ManAddrIfSubtype
	IfId           uint32
	// Reserved Fields
	reservedField0 *uint8
}

var _ LldpManagementAddressTxPortType = (*_LldpManagementAddressTxPortType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_LldpManagementAddressTxPortType)(nil)

// NewLldpManagementAddressTxPortType factory function for _LldpManagementAddressTxPortType
func NewLldpManagementAddressTxPortType(addressSubtype uint32, manAddress PascalString, txEnable bool, addrLen uint32, ifSubtype ManAddrIfSubtype, ifId uint32) *_LldpManagementAddressTxPortType {
	if manAddress == nil {
		panic("manAddress of type PascalString for LldpManagementAddressTxPortType must not be nil")
	}
	_result := &_LldpManagementAddressTxPortType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		AddressSubtype:                    addressSubtype,
		ManAddress:                        manAddress,
		TxEnable:                          txEnable,
		AddrLen:                           addrLen,
		IfSubtype:                         ifSubtype,
		IfId:                              ifId,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LldpManagementAddressTxPortTypeBuilder is a builder for LldpManagementAddressTxPortType
type LldpManagementAddressTxPortTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(addressSubtype uint32, manAddress PascalString, txEnable bool, addrLen uint32, ifSubtype ManAddrIfSubtype, ifId uint32) LldpManagementAddressTxPortTypeBuilder
	// WithAddressSubtype adds AddressSubtype (property field)
	WithAddressSubtype(uint32) LldpManagementAddressTxPortTypeBuilder
	// WithManAddress adds ManAddress (property field)
	WithManAddress(PascalString) LldpManagementAddressTxPortTypeBuilder
	// WithManAddressBuilder adds ManAddress (property field) which is build by the builder
	WithManAddressBuilder(func(PascalStringBuilder) PascalStringBuilder) LldpManagementAddressTxPortTypeBuilder
	// WithTxEnable adds TxEnable (property field)
	WithTxEnable(bool) LldpManagementAddressTxPortTypeBuilder
	// WithAddrLen adds AddrLen (property field)
	WithAddrLen(uint32) LldpManagementAddressTxPortTypeBuilder
	// WithIfSubtype adds IfSubtype (property field)
	WithIfSubtype(ManAddrIfSubtype) LldpManagementAddressTxPortTypeBuilder
	// WithIfId adds IfId (property field)
	WithIfId(uint32) LldpManagementAddressTxPortTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the LldpManagementAddressTxPortType or returns an error if something is wrong
	Build() (LldpManagementAddressTxPortType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LldpManagementAddressTxPortType
}

// NewLldpManagementAddressTxPortTypeBuilder() creates a LldpManagementAddressTxPortTypeBuilder
func NewLldpManagementAddressTxPortTypeBuilder() LldpManagementAddressTxPortTypeBuilder {
	return &_LldpManagementAddressTxPortTypeBuilder{_LldpManagementAddressTxPortType: new(_LldpManagementAddressTxPortType)}
}

type _LldpManagementAddressTxPortTypeBuilder struct {
	*_LldpManagementAddressTxPortType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (LldpManagementAddressTxPortTypeBuilder) = (*_LldpManagementAddressTxPortTypeBuilder)(nil)

func (b *_LldpManagementAddressTxPortTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._LldpManagementAddressTxPortType
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithMandatoryFields(addressSubtype uint32, manAddress PascalString, txEnable bool, addrLen uint32, ifSubtype ManAddrIfSubtype, ifId uint32) LldpManagementAddressTxPortTypeBuilder {
	return b.WithAddressSubtype(addressSubtype).WithManAddress(manAddress).WithTxEnable(txEnable).WithAddrLen(addrLen).WithIfSubtype(ifSubtype).WithIfId(ifId)
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithAddressSubtype(addressSubtype uint32) LldpManagementAddressTxPortTypeBuilder {
	b.AddressSubtype = addressSubtype
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithManAddress(manAddress PascalString) LldpManagementAddressTxPortTypeBuilder {
	b.ManAddress = manAddress
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithManAddressBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) LldpManagementAddressTxPortTypeBuilder {
	builder := builderSupplier(b.ManAddress.CreatePascalStringBuilder())
	var err error
	b.ManAddress, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithTxEnable(txEnable bool) LldpManagementAddressTxPortTypeBuilder {
	b.TxEnable = txEnable
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithAddrLen(addrLen uint32) LldpManagementAddressTxPortTypeBuilder {
	b.AddrLen = addrLen
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithIfSubtype(ifSubtype ManAddrIfSubtype) LldpManagementAddressTxPortTypeBuilder {
	b.IfSubtype = ifSubtype
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) WithIfId(ifId uint32) LldpManagementAddressTxPortTypeBuilder {
	b.IfId = ifId
	return b
}

func (b *_LldpManagementAddressTxPortTypeBuilder) Build() (LldpManagementAddressTxPortType, error) {
	if b.ManAddress == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'manAddress' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._LldpManagementAddressTxPortType.deepCopy(), nil
}

func (b *_LldpManagementAddressTxPortTypeBuilder) MustBuild() LldpManagementAddressTxPortType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LldpManagementAddressTxPortTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_LldpManagementAddressTxPortTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_LldpManagementAddressTxPortTypeBuilder) DeepCopy() any {
	_copy := b.CreateLldpManagementAddressTxPortTypeBuilder().(*_LldpManagementAddressTxPortTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateLldpManagementAddressTxPortTypeBuilder creates a LldpManagementAddressTxPortTypeBuilder
func (b *_LldpManagementAddressTxPortType) CreateLldpManagementAddressTxPortTypeBuilder() LldpManagementAddressTxPortTypeBuilder {
	if b == nil {
		return NewLldpManagementAddressTxPortTypeBuilder()
	}
	return &_LldpManagementAddressTxPortTypeBuilder{_LldpManagementAddressTxPortType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LldpManagementAddressTxPortType) GetExtensionId() int32 {
	return int32(18955)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LldpManagementAddressTxPortType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LldpManagementAddressTxPortType) GetAddressSubtype() uint32 {
	return m.AddressSubtype
}

func (m *_LldpManagementAddressTxPortType) GetManAddress() PascalString {
	return m.ManAddress
}

func (m *_LldpManagementAddressTxPortType) GetTxEnable() bool {
	return m.TxEnable
}

func (m *_LldpManagementAddressTxPortType) GetAddrLen() uint32 {
	return m.AddrLen
}

func (m *_LldpManagementAddressTxPortType) GetIfSubtype() ManAddrIfSubtype {
	return m.IfSubtype
}

func (m *_LldpManagementAddressTxPortType) GetIfId() uint32 {
	return m.IfId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLldpManagementAddressTxPortType(structType any) LldpManagementAddressTxPortType {
	if casted, ok := structType.(LldpManagementAddressTxPortType); ok {
		return casted
	}
	if casted, ok := structType.(*LldpManagementAddressTxPortType); ok {
		return *casted
	}
	return nil
}

func (m *_LldpManagementAddressTxPortType) GetTypeName() string {
	return "LldpManagementAddressTxPortType"
}

func (m *_LldpManagementAddressTxPortType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (addressSubtype)
	lengthInBits += 32

	// Simple field (manAddress)
	lengthInBits += m.ManAddress.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (txEnable)
	lengthInBits += 1

	// Simple field (addrLen)
	lengthInBits += 32

	// Simple field (ifSubtype)
	lengthInBits += 32

	// Simple field (ifId)
	lengthInBits += 32

	return lengthInBits
}

func (m *_LldpManagementAddressTxPortType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LldpManagementAddressTxPortType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__lldpManagementAddressTxPortType LldpManagementAddressTxPortType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LldpManagementAddressTxPortType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LldpManagementAddressTxPortType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	addressSubtype, err := ReadSimpleField(ctx, "addressSubtype", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'addressSubtype' field"))
	}
	m.AddressSubtype = addressSubtype

	manAddress, err := ReadSimpleField[PascalString](ctx, "manAddress", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'manAddress' field"))
	}
	m.ManAddress = manAddress

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	txEnable, err := ReadSimpleField(ctx, "txEnable", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'txEnable' field"))
	}
	m.TxEnable = txEnable

	addrLen, err := ReadSimpleField(ctx, "addrLen", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'addrLen' field"))
	}
	m.AddrLen = addrLen

	ifSubtype, err := ReadEnumField[ManAddrIfSubtype](ctx, "ifSubtype", "ManAddrIfSubtype", ReadEnum(ManAddrIfSubtypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ifSubtype' field"))
	}
	m.IfSubtype = ifSubtype

	ifId, err := ReadSimpleField(ctx, "ifId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ifId' field"))
	}
	m.IfId = ifId

	if closeErr := readBuffer.CloseContext("LldpManagementAddressTxPortType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LldpManagementAddressTxPortType")
	}

	return m, nil
}

func (m *_LldpManagementAddressTxPortType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LldpManagementAddressTxPortType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LldpManagementAddressTxPortType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LldpManagementAddressTxPortType")
		}

		if err := WriteSimpleField[uint32](ctx, "addressSubtype", m.GetAddressSubtype(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'addressSubtype' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "manAddress", m.GetManAddress(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'manAddress' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "txEnable", m.GetTxEnable(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'txEnable' field")
		}

		if err := WriteSimpleField[uint32](ctx, "addrLen", m.GetAddrLen(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'addrLen' field")
		}

		if err := WriteSimpleEnumField[ManAddrIfSubtype](ctx, "ifSubtype", "ManAddrIfSubtype", m.GetIfSubtype(), WriteEnum[ManAddrIfSubtype, uint32](ManAddrIfSubtype.GetValue, ManAddrIfSubtype.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'ifSubtype' field")
		}

		if err := WriteSimpleField[uint32](ctx, "ifId", m.GetIfId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'ifId' field")
		}

		if popErr := writeBuffer.PopContext("LldpManagementAddressTxPortType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LldpManagementAddressTxPortType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LldpManagementAddressTxPortType) IsLldpManagementAddressTxPortType() {}

func (m *_LldpManagementAddressTxPortType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LldpManagementAddressTxPortType) deepCopy() *_LldpManagementAddressTxPortType {
	if m == nil {
		return nil
	}
	_LldpManagementAddressTxPortTypeCopy := &_LldpManagementAddressTxPortType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.AddressSubtype,
		utils.DeepCopy[PascalString](m.ManAddress),
		m.TxEnable,
		m.AddrLen,
		m.IfSubtype,
		m.IfId,
		m.reservedField0,
	}
	_LldpManagementAddressTxPortTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _LldpManagementAddressTxPortTypeCopy
}

func (m *_LldpManagementAddressTxPortType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
