/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonApplicationDescriptionMessage is the corresponding interface of JsonApplicationDescriptionMessage
type JsonApplicationDescriptionMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageId returns MessageId (property field)
	GetMessageId() PascalString
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetDescription returns Description (property field)
	GetDescription() ApplicationDescription
	// GetServerCapabilities returns ServerCapabilities (property field)
	GetServerCapabilities() []PascalString
	// IsJsonApplicationDescriptionMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonApplicationDescriptionMessage()
	// CreateBuilder creates a JsonApplicationDescriptionMessageBuilder
	CreateJsonApplicationDescriptionMessageBuilder() JsonApplicationDescriptionMessageBuilder
}

// _JsonApplicationDescriptionMessage is the data-structure of this message
type _JsonApplicationDescriptionMessage struct {
	ExtensionObjectDefinitionContract
	MessageId          PascalString
	MessageType        PascalString
	PublisherId        PascalString
	Timestamp          int64
	Description        ApplicationDescription
	ServerCapabilities []PascalString
}

var _ JsonApplicationDescriptionMessage = (*_JsonApplicationDescriptionMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonApplicationDescriptionMessage)(nil)

// NewJsonApplicationDescriptionMessage factory function for _JsonApplicationDescriptionMessage
func NewJsonApplicationDescriptionMessage(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, description ApplicationDescription, serverCapabilities []PascalString) *_JsonApplicationDescriptionMessage {
	if messageId == nil {
		panic("messageId of type PascalString for JsonApplicationDescriptionMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonApplicationDescriptionMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonApplicationDescriptionMessage must not be nil")
	}
	if description == nil {
		panic("description of type ApplicationDescription for JsonApplicationDescriptionMessage must not be nil")
	}
	_result := &_JsonApplicationDescriptionMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageId:                         messageId,
		MessageType:                       messageType,
		PublisherId:                       publisherId,
		Timestamp:                         timestamp,
		Description:                       description,
		ServerCapabilities:                serverCapabilities,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonApplicationDescriptionMessageBuilder is a builder for JsonApplicationDescriptionMessage
type JsonApplicationDescriptionMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, description ApplicationDescription, serverCapabilities []PascalString) JsonApplicationDescriptionMessageBuilder
	// WithMessageId adds MessageId (property field)
	WithMessageId(PascalString) JsonApplicationDescriptionMessageBuilder
	// WithMessageIdBuilder adds MessageId (property field) which is build by the builder
	WithMessageIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonApplicationDescriptionMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonApplicationDescriptionMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonApplicationDescriptionMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonApplicationDescriptionMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonApplicationDescriptionMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonApplicationDescriptionMessageBuilder
	// WithDescription adds Description (property field)
	WithDescription(ApplicationDescription) JsonApplicationDescriptionMessageBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(ApplicationDescriptionBuilder) ApplicationDescriptionBuilder) JsonApplicationDescriptionMessageBuilder
	// WithServerCapabilities adds ServerCapabilities (property field)
	WithServerCapabilities(...PascalString) JsonApplicationDescriptionMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonApplicationDescriptionMessage or returns an error if something is wrong
	Build() (JsonApplicationDescriptionMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonApplicationDescriptionMessage
}

// NewJsonApplicationDescriptionMessageBuilder() creates a JsonApplicationDescriptionMessageBuilder
func NewJsonApplicationDescriptionMessageBuilder() JsonApplicationDescriptionMessageBuilder {
	return &_JsonApplicationDescriptionMessageBuilder{_JsonApplicationDescriptionMessage: new(_JsonApplicationDescriptionMessage)}
}

type _JsonApplicationDescriptionMessageBuilder struct {
	*_JsonApplicationDescriptionMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (JsonApplicationDescriptionMessageBuilder) = (*_JsonApplicationDescriptionMessageBuilder)(nil)

func (b *_JsonApplicationDescriptionMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonApplicationDescriptionMessage
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, description ApplicationDescription, serverCapabilities []PascalString) JsonApplicationDescriptionMessageBuilder {
	return b.WithMessageId(messageId).WithMessageType(messageType).WithPublisherId(publisherId).WithTimestamp(timestamp).WithDescription(description).WithServerCapabilities(serverCapabilities...)
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithMessageId(messageId PascalString) JsonApplicationDescriptionMessageBuilder {
	b.MessageId = messageId
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithMessageIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonApplicationDescriptionMessageBuilder {
	builder := builderSupplier(b.MessageId.CreatePascalStringBuilder())
	var err error
	b.MessageId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithMessageType(messageType PascalString) JsonApplicationDescriptionMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonApplicationDescriptionMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithPublisherId(publisherId PascalString) JsonApplicationDescriptionMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonApplicationDescriptionMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithTimestamp(timestamp int64) JsonApplicationDescriptionMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithDescription(description ApplicationDescription) JsonApplicationDescriptionMessageBuilder {
	b.Description = description
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithDescriptionBuilder(builderSupplier func(ApplicationDescriptionBuilder) ApplicationDescriptionBuilder) JsonApplicationDescriptionMessageBuilder {
	builder := builderSupplier(b.Description.CreateApplicationDescriptionBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ApplicationDescriptionBuilder failed"))
	}
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) WithServerCapabilities(serverCapabilities ...PascalString) JsonApplicationDescriptionMessageBuilder {
	b.ServerCapabilities = serverCapabilities
	return b
}

func (b *_JsonApplicationDescriptionMessageBuilder) Build() (JsonApplicationDescriptionMessage, error) {
	if b.MessageId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageId' not set"))
	}
	if b.MessageType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageType' not set"))
	}
	if b.PublisherId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publisherId' not set"))
	}
	if b.Description == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'description' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._JsonApplicationDescriptionMessage.deepCopy(), nil
}

func (b *_JsonApplicationDescriptionMessageBuilder) MustBuild() JsonApplicationDescriptionMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonApplicationDescriptionMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonApplicationDescriptionMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonApplicationDescriptionMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonApplicationDescriptionMessageBuilder().(*_JsonApplicationDescriptionMessageBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateJsonApplicationDescriptionMessageBuilder creates a JsonApplicationDescriptionMessageBuilder
func (b *_JsonApplicationDescriptionMessage) CreateJsonApplicationDescriptionMessageBuilder() JsonApplicationDescriptionMessageBuilder {
	if b == nil {
		return NewJsonApplicationDescriptionMessageBuilder()
	}
	return &_JsonApplicationDescriptionMessageBuilder{_JsonApplicationDescriptionMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonApplicationDescriptionMessage) GetExtensionId() int32 {
	return int32(19316)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonApplicationDescriptionMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonApplicationDescriptionMessage) GetMessageId() PascalString {
	return m.MessageId
}

func (m *_JsonApplicationDescriptionMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonApplicationDescriptionMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonApplicationDescriptionMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonApplicationDescriptionMessage) GetDescription() ApplicationDescription {
	return m.Description
}

func (m *_JsonApplicationDescriptionMessage) GetServerCapabilities() []PascalString {
	return m.ServerCapabilities
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonApplicationDescriptionMessage(structType any) JsonApplicationDescriptionMessage {
	if casted, ok := structType.(JsonApplicationDescriptionMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonApplicationDescriptionMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonApplicationDescriptionMessage) GetTypeName() string {
	return "JsonApplicationDescriptionMessage"
}

func (m *_JsonApplicationDescriptionMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageId)
	lengthInBits += m.MessageId.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	// Implicit Field (noOfServerCapabilities)
	lengthInBits += 32

	// Array field
	if len(m.ServerCapabilities) > 0 {
		for _curItem, element := range m.ServerCapabilities {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerCapabilities), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_JsonApplicationDescriptionMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonApplicationDescriptionMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonApplicationDescriptionMessage JsonApplicationDescriptionMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonApplicationDescriptionMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonApplicationDescriptionMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageId, err := ReadSimpleField[PascalString](ctx, "messageId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageId' field"))
	}
	m.MessageId = messageId

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	description, err := ReadSimpleField[ApplicationDescription](ctx, "description", ReadComplex[ApplicationDescription](ExtensionObjectDefinitionParseWithBufferProducer[ApplicationDescription]((int32)(int32(310))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	noOfServerCapabilities, err := ReadImplicitField[int32](ctx, "noOfServerCapabilities", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfServerCapabilities' field"))
	}
	_ = noOfServerCapabilities

	serverCapabilities, err := ReadCountArrayField[PascalString](ctx, "serverCapabilities", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfServerCapabilities))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverCapabilities' field"))
	}
	m.ServerCapabilities = serverCapabilities

	if closeErr := readBuffer.CloseContext("JsonApplicationDescriptionMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonApplicationDescriptionMessage")
	}

	return m, nil
}

func (m *_JsonApplicationDescriptionMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonApplicationDescriptionMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonApplicationDescriptionMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonApplicationDescriptionMessage")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageId", m.GetMessageId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[ApplicationDescription](ctx, "description", m.GetDescription(), WriteComplex[ApplicationDescription](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}
		noOfServerCapabilities := int32(utils.InlineIf(bool((m.GetServerCapabilities()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetServerCapabilities()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfServerCapabilities", noOfServerCapabilities, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfServerCapabilities' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "serverCapabilities", m.GetServerCapabilities(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'serverCapabilities' field")
		}

		if popErr := writeBuffer.PopContext("JsonApplicationDescriptionMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonApplicationDescriptionMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonApplicationDescriptionMessage) IsJsonApplicationDescriptionMessage() {}

func (m *_JsonApplicationDescriptionMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonApplicationDescriptionMessage) deepCopy() *_JsonApplicationDescriptionMessage {
	if m == nil {
		return nil
	}
	_JsonApplicationDescriptionMessageCopy := &_JsonApplicationDescriptionMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.MessageId),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[PascalString](m.PublisherId),
		m.Timestamp,
		utils.DeepCopy[ApplicationDescription](m.Description),
		utils.DeepCopySlice[PascalString, PascalString](m.ServerCapabilities),
	}
	_JsonApplicationDescriptionMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonApplicationDescriptionMessageCopy
}

func (m *_JsonApplicationDescriptionMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
