/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Handle is the corresponding interface of Handle
type Handle interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsHandle is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsHandle()
	// CreateBuilder creates a HandleBuilder
	CreateHandleBuilder() HandleBuilder
}

// _Handle is the data-structure of this message
type _Handle struct {
}

var _ Handle = (*_Handle)(nil)

// NewHandle factory function for _Handle
func NewHandle() *_Handle {
	return &_Handle{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// HandleBuilder is a builder for Handle
type HandleBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() HandleBuilder
	// Build builds the Handle or returns an error if something is wrong
	Build() (Handle, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Handle
}

// NewHandleBuilder() creates a HandleBuilder
func NewHandleBuilder() HandleBuilder {
	return &_HandleBuilder{_Handle: new(_Handle)}
}

type _HandleBuilder struct {
	*_Handle

	err *utils.MultiError
}

var _ (HandleBuilder) = (*_HandleBuilder)(nil)

func (b *_HandleBuilder) WithMandatoryFields() HandleBuilder {
	return b
}

func (b *_HandleBuilder) Build() (Handle, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._Handle.deepCopy(), nil
}

func (b *_HandleBuilder) MustBuild() Handle {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_HandleBuilder) DeepCopy() any {
	_copy := b.CreateHandleBuilder().(*_HandleBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateHandleBuilder creates a HandleBuilder
func (b *_Handle) CreateHandleBuilder() HandleBuilder {
	if b == nil {
		return NewHandleBuilder()
	}
	return &_HandleBuilder{_Handle: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastHandle(structType any) Handle {
	if casted, ok := structType.(Handle); ok {
		return casted
	}
	if casted, ok := structType.(*Handle); ok {
		return *casted
	}
	return nil
}

func (m *_Handle) GetTypeName() string {
	return "Handle"
}

func (m *_Handle) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_Handle) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func HandleParse(ctx context.Context, theBytes []byte) (Handle, error) {
	return HandleParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func HandleParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (Handle, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (Handle, error) {
		return HandleParseWithBuffer(ctx, readBuffer)
	}
}

func HandleParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Handle, error) {
	v, err := (&_Handle{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_Handle) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__handle Handle, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Handle"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Handle")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("Handle"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Handle")
	}

	return m, nil
}

func (m *_Handle) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Handle) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Handle"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Handle")
	}

	if popErr := writeBuffer.PopContext("Handle"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Handle")
	}
	return nil
}

func (m *_Handle) IsHandle() {}

func (m *_Handle) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Handle) deepCopy() *_Handle {
	if m == nil {
		return nil
	}
	_HandleCopy := &_Handle{}
	return _HandleCopy
}

func (m *_Handle) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
