/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// GuidNodeId is the corresponding interface of GuidNodeId
type GuidNodeId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetNamespaceIndex returns NamespaceIndex (property field)
	GetNamespaceIndex() uint16
	// GetIdentifier returns Identifier (property field)
	GetIdentifier() GuidValue
	// IsGuidNodeId is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsGuidNodeId()
	// CreateBuilder creates a GuidNodeIdBuilder
	CreateGuidNodeIdBuilder() GuidNodeIdBuilder
}

// _GuidNodeId is the data-structure of this message
type _GuidNodeId struct {
	NamespaceIndex uint16
	Identifier     GuidValue
}

var _ GuidNodeId = (*_GuidNodeId)(nil)

// NewGuidNodeId factory function for _GuidNodeId
func NewGuidNodeId(namespaceIndex uint16, identifier GuidValue) *_GuidNodeId {
	if identifier == nil {
		panic("identifier of type GuidValue for GuidNodeId must not be nil")
	}
	return &_GuidNodeId{NamespaceIndex: namespaceIndex, Identifier: identifier}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// GuidNodeIdBuilder is a builder for GuidNodeId
type GuidNodeIdBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(namespaceIndex uint16, identifier GuidValue) GuidNodeIdBuilder
	// WithNamespaceIndex adds NamespaceIndex (property field)
	WithNamespaceIndex(uint16) GuidNodeIdBuilder
	// WithIdentifier adds Identifier (property field)
	WithIdentifier(GuidValue) GuidNodeIdBuilder
	// WithIdentifierBuilder adds Identifier (property field) which is build by the builder
	WithIdentifierBuilder(func(GuidValueBuilder) GuidValueBuilder) GuidNodeIdBuilder
	// Build builds the GuidNodeId or returns an error if something is wrong
	Build() (GuidNodeId, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() GuidNodeId
}

// NewGuidNodeIdBuilder() creates a GuidNodeIdBuilder
func NewGuidNodeIdBuilder() GuidNodeIdBuilder {
	return &_GuidNodeIdBuilder{_GuidNodeId: new(_GuidNodeId)}
}

type _GuidNodeIdBuilder struct {
	*_GuidNodeId

	err *utils.MultiError
}

var _ (GuidNodeIdBuilder) = (*_GuidNodeIdBuilder)(nil)

func (b *_GuidNodeIdBuilder) WithMandatoryFields(namespaceIndex uint16, identifier GuidValue) GuidNodeIdBuilder {
	return b.WithNamespaceIndex(namespaceIndex).WithIdentifier(identifier)
}

func (b *_GuidNodeIdBuilder) WithNamespaceIndex(namespaceIndex uint16) GuidNodeIdBuilder {
	b.NamespaceIndex = namespaceIndex
	return b
}

func (b *_GuidNodeIdBuilder) WithIdentifier(identifier GuidValue) GuidNodeIdBuilder {
	b.Identifier = identifier
	return b
}

func (b *_GuidNodeIdBuilder) WithIdentifierBuilder(builderSupplier func(GuidValueBuilder) GuidValueBuilder) GuidNodeIdBuilder {
	builder := builderSupplier(b.Identifier.CreateGuidValueBuilder())
	var err error
	b.Identifier, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "GuidValueBuilder failed"))
	}
	return b
}

func (b *_GuidNodeIdBuilder) Build() (GuidNodeId, error) {
	if b.Identifier == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'identifier' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._GuidNodeId.deepCopy(), nil
}

func (b *_GuidNodeIdBuilder) MustBuild() GuidNodeId {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_GuidNodeIdBuilder) DeepCopy() any {
	_copy := b.CreateGuidNodeIdBuilder().(*_GuidNodeIdBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateGuidNodeIdBuilder creates a GuidNodeIdBuilder
func (b *_GuidNodeId) CreateGuidNodeIdBuilder() GuidNodeIdBuilder {
	if b == nil {
		return NewGuidNodeIdBuilder()
	}
	return &_GuidNodeIdBuilder{_GuidNodeId: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_GuidNodeId) GetNamespaceIndex() uint16 {
	return m.NamespaceIndex
}

func (m *_GuidNodeId) GetIdentifier() GuidValue {
	return m.Identifier
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastGuidNodeId(structType any) GuidNodeId {
	if casted, ok := structType.(GuidNodeId); ok {
		return casted
	}
	if casted, ok := structType.(*GuidNodeId); ok {
		return *casted
	}
	return nil
}

func (m *_GuidNodeId) GetTypeName() string {
	return "GuidNodeId"
}

func (m *_GuidNodeId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (namespaceIndex)
	lengthInBits += 16

	// Simple field (identifier)
	lengthInBits += m.Identifier.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_GuidNodeId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func GuidNodeIdParse(ctx context.Context, theBytes []byte) (GuidNodeId, error) {
	return GuidNodeIdParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func GuidNodeIdParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (GuidNodeId, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (GuidNodeId, error) {
		return GuidNodeIdParseWithBuffer(ctx, readBuffer)
	}
}

func GuidNodeIdParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (GuidNodeId, error) {
	v, err := (&_GuidNodeId{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_GuidNodeId) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__guidNodeId GuidNodeId, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("GuidNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for GuidNodeId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	namespaceIndex, err := ReadSimpleField(ctx, "namespaceIndex", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'namespaceIndex' field"))
	}
	m.NamespaceIndex = namespaceIndex

	identifier, err := ReadSimpleField[GuidValue](ctx, "identifier", ReadComplex[GuidValue](GuidValueParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'identifier' field"))
	}
	m.Identifier = identifier

	if closeErr := readBuffer.CloseContext("GuidNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for GuidNodeId")
	}

	return m, nil
}

func (m *_GuidNodeId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_GuidNodeId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("GuidNodeId"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for GuidNodeId")
	}

	if err := WriteSimpleField[uint16](ctx, "namespaceIndex", m.GetNamespaceIndex(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'namespaceIndex' field")
	}

	if err := WriteSimpleField[GuidValue](ctx, "identifier", m.GetIdentifier(), WriteComplex[GuidValue](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'identifier' field")
	}

	if popErr := writeBuffer.PopContext("GuidNodeId"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for GuidNodeId")
	}
	return nil
}

func (m *_GuidNodeId) IsGuidNodeId() {}

func (m *_GuidNodeId) DeepCopy() any {
	return m.deepCopy()
}

func (m *_GuidNodeId) deepCopy() *_GuidNodeId {
	if m == nil {
		return nil
	}
	_GuidNodeIdCopy := &_GuidNodeId{
		m.NamespaceIndex,
		utils.DeepCopy[GuidValue](m.Identifier),
	}
	return _GuidNodeIdCopy
}

func (m *_GuidNodeId) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
