/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ExtensionObjectDefinition is the corresponding interface of ExtensionObjectDefinition
type ExtensionObjectDefinition interface {
	ExtensionObjectDefinitionContract
	ExtensionObjectDefinitionRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsExtensionObjectDefinition is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsExtensionObjectDefinition()
	// CreateBuilder creates a ExtensionObjectDefinitionBuilder
	CreateExtensionObjectDefinitionBuilder() ExtensionObjectDefinitionBuilder
}

// ExtensionObjectDefinitionContract provides a set of functions which can be overwritten by a sub struct
type ExtensionObjectDefinitionContract interface {
	// IsExtensionObjectDefinition is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsExtensionObjectDefinition()
	// CreateBuilder creates a ExtensionObjectDefinitionBuilder
	CreateExtensionObjectDefinitionBuilder() ExtensionObjectDefinitionBuilder
}

// ExtensionObjectDefinitionRequirements provides a set of functions which need to be implemented by a sub struct
type ExtensionObjectDefinitionRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetExtensionId returns ExtensionId (discriminator field)
	GetExtensionId() int32
}

// _ExtensionObjectDefinition is the data-structure of this message
type _ExtensionObjectDefinition struct {
	_SubType interface {
		ExtensionObjectDefinitionContract
		ExtensionObjectDefinitionRequirements
	}
}

var _ ExtensionObjectDefinitionContract = (*_ExtensionObjectDefinition)(nil)

// NewExtensionObjectDefinition factory function for _ExtensionObjectDefinition
func NewExtensionObjectDefinition() *_ExtensionObjectDefinition {
	return &_ExtensionObjectDefinition{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ExtensionObjectDefinitionBuilder is a builder for ExtensionObjectDefinition
type ExtensionObjectDefinitionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ExtensionObjectDefinitionBuilder
	// AsNullExtension converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNullExtension() NullExtensionBuilder
	// AsUnion converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUnion() UnionBuilder
	// AsKeyValuePair converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsKeyValuePair() KeyValuePairBuilder
	// AsAdditionalParametersType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAdditionalParametersType() AdditionalParametersTypeBuilder
	// AsEphemeralKeyType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEphemeralKeyType() EphemeralKeyTypeBuilder
	// AsEndpointType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEndpointType() EndpointTypeBuilder
	// AsBitFieldDefinition converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBitFieldDefinition() BitFieldDefinitionBuilder
	// AsRationalNumber converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRationalNumber() RationalNumberBuilder
	// AsOpcuaVector converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsOpcuaVector() OpcuaVectorBuilder
	// AsCartesianCoordinates converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCartesianCoordinates() CartesianCoordinatesBuilder
	// AsOrientation converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsOrientation() OrientationBuilder
	// AsFrame converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFrame() FrameBuilder
	// AsIdentityMappingRuleType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsIdentityMappingRuleType() IdentityMappingRuleTypeBuilder
	// AsCurrencyUnitType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCurrencyUnitType() CurrencyUnitTypeBuilder
	// AsAnnotationDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAnnotationDataType() AnnotationDataTypeBuilder
	// AsLinearConversionDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLinearConversionDataType() LinearConversionDataTypeBuilder
	// AsQuantityDimension converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQuantityDimension() QuantityDimensionBuilder
	// AsTrustListDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTrustListDataType() TrustListDataTypeBuilder
	// AsBaseConfigurationDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBaseConfigurationDataType() BaseConfigurationDataTypeBuilder
	// AsBaseConfigurationRecordDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBaseConfigurationRecordDataType() BaseConfigurationRecordDataTypeBuilder
	// AsCertificateGroupDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCertificateGroupDataType() CertificateGroupDataTypeBuilder
	// AsConfigurationUpdateTargetType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsConfigurationUpdateTargetType() ConfigurationUpdateTargetTypeBuilder
	// AsTransactionErrorType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTransactionErrorType() TransactionErrorTypeBuilder
	// AsApplicationConfigurationDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsApplicationConfigurationDataType() ApplicationConfigurationDataTypeBuilder
	// AsApplicationIdentityDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsApplicationIdentityDataType() ApplicationIdentityDataTypeBuilder
	// AsEndpointDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEndpointDataType() EndpointDataTypeBuilder
	// AsServerEndpointDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsServerEndpointDataType() ServerEndpointDataTypeBuilder
	// AsSecuritySettingsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSecuritySettingsDataType() SecuritySettingsDataTypeBuilder
	// AsUserTokenSettingsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUserTokenSettingsDataType() UserTokenSettingsDataTypeBuilder
	// AsAuthorizationServiceConfigurationDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAuthorizationServiceConfigurationDataType() AuthorizationServiceConfigurationDataTypeBuilder
	// AsDataTypeSchemaHeader converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataTypeSchemaHeader() DataTypeSchemaHeaderBuilder
	// AsDataTypeDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataTypeDescription() DataTypeDescriptionBuilder
	// AsStructureDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStructureDescription() StructureDescriptionBuilder
	// AsEnumDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEnumDescription() EnumDescriptionBuilder
	// AsSimpleTypeDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSimpleTypeDescription() SimpleTypeDescriptionBuilder
	// AsUABinaryFileDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUABinaryFileDataType() UABinaryFileDataTypeBuilder
	// AsPortableQualifiedName converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPortableQualifiedName() PortableQualifiedNameBuilder
	// AsPortableNodeId converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPortableNodeId() PortableNodeIdBuilder
	// AsUnsignedRationalNumber converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUnsignedRationalNumber() UnsignedRationalNumberBuilder
	// AsDataSetMetaDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetMetaDataType() DataSetMetaDataTypeBuilder
	// AsFieldMetaData converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFieldMetaData() FieldMetaDataBuilder
	// AsConfigurationVersionDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsConfigurationVersionDataType() ConfigurationVersionDataTypeBuilder
	// AsPublishedDataSetDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedDataSetDataType() PublishedDataSetDataTypeBuilder
	// AsPublishedDataSetSourceDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedDataSetSourceDataType() PublishedDataSetSourceDataTypeBuilder
	// AsPublishedVariableDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedVariableDataType() PublishedVariableDataTypeBuilder
	// AsPublishedDataItemsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedDataItemsDataType() PublishedDataItemsDataTypeBuilder
	// AsPublishedEventsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedEventsDataType() PublishedEventsDataTypeBuilder
	// AsPublishedDataSetCustomSourceDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedDataSetCustomSourceDataType() PublishedDataSetCustomSourceDataTypeBuilder
	// AsActionTargetDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsActionTargetDataType() ActionTargetDataTypeBuilder
	// AsPublishedActionDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedActionDataType() PublishedActionDataTypeBuilder
	// AsActionMethodDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsActionMethodDataType() ActionMethodDataTypeBuilder
	// AsPublishedActionMethodDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishedActionMethodDataType() PublishedActionMethodDataTypeBuilder
	// AsDataSetWriterDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetWriterDataType() DataSetWriterDataTypeBuilder
	// AsDataSetWriterTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetWriterTransportDataType() DataSetWriterTransportDataTypeBuilder
	// AsDataSetWriterMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetWriterMessageDataType() DataSetWriterMessageDataTypeBuilder
	// AsPubSubGroupDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubGroupDataType() PubSubGroupDataTypeBuilder
	// AsWriterGroupDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsWriterGroupDataType() WriterGroupDataTypeBuilder
	// AsWriterGroupTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsWriterGroupTransportDataType() WriterGroupTransportDataTypeBuilder
	// AsWriterGroupMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsWriterGroupMessageDataType() WriterGroupMessageDataTypeBuilder
	// AsPubSubConnectionDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubConnectionDataType() PubSubConnectionDataTypeBuilder
	// AsConnectionTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsConnectionTransportDataType() ConnectionTransportDataTypeBuilder
	// AsNetworkAddressDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNetworkAddressDataType() NetworkAddressDataTypeBuilder
	// AsNetworkAddressUrlDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNetworkAddressUrlDataType() NetworkAddressUrlDataTypeBuilder
	// AsReaderGroupDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReaderGroupDataType() ReaderGroupDataTypeBuilder
	// AsReaderGroupTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReaderGroupTransportDataType() ReaderGroupTransportDataTypeBuilder
	// AsReaderGroupMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReaderGroupMessageDataType() ReaderGroupMessageDataTypeBuilder
	// AsDataSetReaderDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetReaderDataType() DataSetReaderDataTypeBuilder
	// AsDataSetReaderTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetReaderTransportDataType() DataSetReaderTransportDataTypeBuilder
	// AsDataSetReaderMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataSetReaderMessageDataType() DataSetReaderMessageDataTypeBuilder
	// AsSubscribedDataSetDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSubscribedDataSetDataType() SubscribedDataSetDataTypeBuilder
	// AsTargetVariablesDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTargetVariablesDataType() TargetVariablesDataTypeBuilder
	// AsFieldTargetDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFieldTargetDataType() FieldTargetDataTypeBuilder
	// AsSubscribedDataSetMirrorDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSubscribedDataSetMirrorDataType() SubscribedDataSetMirrorDataTypeBuilder
	// AsPubSubConfigurationDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubConfigurationDataType() PubSubConfigurationDataTypeBuilder
	// AsStandaloneSubscribedDataSetRefDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStandaloneSubscribedDataSetRefDataType() StandaloneSubscribedDataSetRefDataTypeBuilder
	// AsStandaloneSubscribedDataSetDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStandaloneSubscribedDataSetDataType() StandaloneSubscribedDataSetDataTypeBuilder
	// AsSecurityGroupDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSecurityGroupDataType() SecurityGroupDataTypeBuilder
	// AsPubSubKeyPushTargetDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubKeyPushTargetDataType() PubSubKeyPushTargetDataTypeBuilder
	// AsPubSubConfiguration2DataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubConfiguration2DataType() PubSubConfiguration2DataTypeBuilder
	// AsUadpWriterGroupMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUadpWriterGroupMessageDataType() UadpWriterGroupMessageDataTypeBuilder
	// AsUadpDataSetWriterMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUadpDataSetWriterMessageDataType() UadpDataSetWriterMessageDataTypeBuilder
	// AsUadpDataSetReaderMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUadpDataSetReaderMessageDataType() UadpDataSetReaderMessageDataTypeBuilder
	// AsJsonWriterGroupMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonWriterGroupMessageDataType() JsonWriterGroupMessageDataTypeBuilder
	// AsJsonDataSetWriterMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonDataSetWriterMessageDataType() JsonDataSetWriterMessageDataTypeBuilder
	// AsJsonDataSetReaderMessageDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonDataSetReaderMessageDataType() JsonDataSetReaderMessageDataTypeBuilder
	// AsQosDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQosDataType() QosDataTypeBuilder
	// AsTransmitQosDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTransmitQosDataType() TransmitQosDataTypeBuilder
	// AsTransmitQosPriorityDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTransmitQosPriorityDataType() TransmitQosPriorityDataTypeBuilder
	// AsReceiveQosDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReceiveQosDataType() ReceiveQosDataTypeBuilder
	// AsReceiveQosPriorityDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReceiveQosPriorityDataType() ReceiveQosPriorityDataTypeBuilder
	// AsDatagramConnectionTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDatagramConnectionTransportDataType() DatagramConnectionTransportDataTypeBuilder
	// AsDatagramConnectionTransport2DataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDatagramConnectionTransport2DataType() DatagramConnectionTransport2DataTypeBuilder
	// AsDatagramWriterGroupTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDatagramWriterGroupTransportDataType() DatagramWriterGroupTransportDataTypeBuilder
	// AsDatagramWriterGroupTransport2DataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDatagramWriterGroupTransport2DataType() DatagramWriterGroupTransport2DataTypeBuilder
	// AsDatagramDataSetReaderTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDatagramDataSetReaderTransportDataType() DatagramDataSetReaderTransportDataTypeBuilder
	// AsDtlsPubSubConnectionDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDtlsPubSubConnectionDataType() DtlsPubSubConnectionDataTypeBuilder
	// AsBrokerConnectionTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrokerConnectionTransportDataType() BrokerConnectionTransportDataTypeBuilder
	// AsBrokerWriterGroupTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrokerWriterGroupTransportDataType() BrokerWriterGroupTransportDataTypeBuilder
	// AsBrokerDataSetWriterTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrokerDataSetWriterTransportDataType() BrokerDataSetWriterTransportDataTypeBuilder
	// AsBrokerDataSetReaderTransportDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrokerDataSetReaderTransportDataType() BrokerDataSetReaderTransportDataTypeBuilder
	// AsPubSubConfigurationRefDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubConfigurationRefDataType() PubSubConfigurationRefDataTypeBuilder
	// AsPubSubConfigurationValueDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPubSubConfigurationValueDataType() PubSubConfigurationValueDataTypeBuilder
	// AsJsonNetworkMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonNetworkMessage() JsonNetworkMessageBuilder
	// AsJsonDataSetMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonDataSetMessage() JsonDataSetMessageBuilder
	// AsJsonDataSetMetaDataMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonDataSetMetaDataMessage() JsonDataSetMetaDataMessageBuilder
	// AsJsonApplicationDescriptionMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonApplicationDescriptionMessage() JsonApplicationDescriptionMessageBuilder
	// AsJsonServerEndpointsMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonServerEndpointsMessage() JsonServerEndpointsMessageBuilder
	// AsJsonStatusMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonStatusMessage() JsonStatusMessageBuilder
	// AsJsonPubSubConnectionMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonPubSubConnectionMessage() JsonPubSubConnectionMessageBuilder
	// AsJsonActionMetaDataMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonActionMetaDataMessage() JsonActionMetaDataMessageBuilder
	// AsJsonActionResponderMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonActionResponderMessage() JsonActionResponderMessageBuilder
	// AsJsonActionNetworkMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonActionNetworkMessage() JsonActionNetworkMessageBuilder
	// AsJsonActionRequestMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonActionRequestMessage() JsonActionRequestMessageBuilder
	// AsJsonActionResponseMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsJsonActionResponseMessage() JsonActionResponseMessageBuilder
	// AsAliasNameDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAliasNameDataType() AliasNameDataTypeBuilder
	// AsUserManagementDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUserManagementDataType() UserManagementDataTypeBuilder
	// AsPriorityMappingEntryType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPriorityMappingEntryType() PriorityMappingEntryTypeBuilder
	// AsLldpManagementAddressTxPortType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLldpManagementAddressTxPortType() LldpManagementAddressTxPortTypeBuilder
	// AsLldpManagementAddressType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLldpManagementAddressType() LldpManagementAddressTypeBuilder
	// AsLldpTlvType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLldpTlvType() LldpTlvTypeBuilder
	// AsReferenceDescriptionDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReferenceDescriptionDataType() ReferenceDescriptionDataTypeBuilder
	// AsReferenceListEntryDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReferenceListEntryDataType() ReferenceListEntryDataTypeBuilder
	// AsLogRecord converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLogRecord() LogRecordBuilder
	// AsLogRecordsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLogRecordsDataType() LogRecordsDataTypeBuilder
	// AsSpanContextDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSpanContextDataType() SpanContextDataTypeBuilder
	// AsTraceContextDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTraceContextDataType() TraceContextDataTypeBuilder
	// AsNameValuePair converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNameValuePair() NameValuePairBuilder
	// AsRolePermissionType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRolePermissionType() RolePermissionTypeBuilder
	// AsDataTypeDefinition converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataTypeDefinition() DataTypeDefinitionBuilder
	// AsStructureField converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStructureField() StructureFieldBuilder
	// AsStructureDefinition converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStructureDefinition() StructureDefinitionBuilder
	// AsEnumDefinition converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEnumDefinition() EnumDefinitionBuilder
	// AsArgument converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsArgument() ArgumentBuilder
	// AsEnumValueType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEnumValueType() EnumValueTypeBuilder
	// AsEnumField converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEnumField() EnumFieldBuilder
	// AsOptionSet converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsOptionSet() OptionSetBuilder
	// AsTimeZoneDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTimeZoneDataType() TimeZoneDataTypeBuilder
	// AsApplicationDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsApplicationDescription() ApplicationDescriptionBuilder
	// AsRequestHeader converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRequestHeader() RequestHeaderBuilder
	// AsResponseHeader converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsResponseHeader() ResponseHeaderBuilder
	// AsServiceFault converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsServiceFault() ServiceFaultBuilder
	// AsSessionlessInvokeRequestType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSessionlessInvokeRequestType() SessionlessInvokeRequestTypeBuilder
	// AsSessionlessInvokeResponseType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSessionlessInvokeResponseType() SessionlessInvokeResponseTypeBuilder
	// AsFindServersRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFindServersRequest() FindServersRequestBuilder
	// AsFindServersResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFindServersResponse() FindServersResponseBuilder
	// AsServerOnNetwork converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsServerOnNetwork() ServerOnNetworkBuilder
	// AsFindServersOnNetworkRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFindServersOnNetworkRequest() FindServersOnNetworkRequestBuilder
	// AsFindServersOnNetworkResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFindServersOnNetworkResponse() FindServersOnNetworkResponseBuilder
	// AsUserTokenPolicy converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUserTokenPolicy() UserTokenPolicyBuilder
	// AsEndpointDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEndpointDescription() EndpointDescriptionBuilder
	// AsGetEndpointsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsGetEndpointsRequest() GetEndpointsRequestBuilder
	// AsGetEndpointsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsGetEndpointsResponse() GetEndpointsResponseBuilder
	// AsRegisteredServer converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisteredServer() RegisteredServerBuilder
	// AsRegisterServerRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisterServerRequest() RegisterServerRequestBuilder
	// AsRegisterServerResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisterServerResponse() RegisterServerResponseBuilder
	// AsDiscoveryConfiguration converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDiscoveryConfiguration() DiscoveryConfigurationBuilder
	// AsMdnsDiscoveryConfiguration converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMdnsDiscoveryConfiguration() MdnsDiscoveryConfigurationBuilder
	// AsRegisterServer2Request converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisterServer2Request() RegisterServer2RequestBuilder
	// AsRegisterServer2Response converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisterServer2Response() RegisterServer2ResponseBuilder
	// AsChannelSecurityToken converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsChannelSecurityToken() ChannelSecurityTokenBuilder
	// AsOpenSecureChannelRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsOpenSecureChannelRequest() OpenSecureChannelRequestBuilder
	// AsOpenSecureChannelResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsOpenSecureChannelResponse() OpenSecureChannelResponseBuilder
	// AsCloseSecureChannelRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCloseSecureChannelRequest() CloseSecureChannelRequestBuilder
	// AsCloseSecureChannelResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCloseSecureChannelResponse() CloseSecureChannelResponseBuilder
	// AsSignedSoftwareCertificate converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSignedSoftwareCertificate() SignedSoftwareCertificateBuilder
	// AsSignatureData converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSignatureData() SignatureDataBuilder
	// AsCreateSessionRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCreateSessionRequest() CreateSessionRequestBuilder
	// AsCreateSessionResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCreateSessionResponse() CreateSessionResponseBuilder
	// AsUserIdentityToken converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUserIdentityToken() UserIdentityTokenBuilder
	// AsAnonymousIdentityToken converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAnonymousIdentityToken() AnonymousIdentityTokenBuilder
	// AsUserNameIdentityToken converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUserNameIdentityToken() UserNameIdentityTokenBuilder
	// AsX509IdentityToken converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsX509IdentityToken() X509IdentityTokenBuilder
	// AsIssuedIdentityToken converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsIssuedIdentityToken() IssuedIdentityTokenBuilder
	// AsActivateSessionRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsActivateSessionRequest() ActivateSessionRequestBuilder
	// AsActivateSessionResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsActivateSessionResponse() ActivateSessionResponseBuilder
	// AsCloseSessionRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCloseSessionRequest() CloseSessionRequestBuilder
	// AsCloseSessionResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCloseSessionResponse() CloseSessionResponseBuilder
	// AsCancelRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCancelRequest() CancelRequestBuilder
	// AsCancelResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCancelResponse() CancelResponseBuilder
	// AsNodeAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNodeAttributes() NodeAttributesBuilder
	// AsObjectAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsObjectAttributes() ObjectAttributesBuilder
	// AsVariableAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsVariableAttributes() VariableAttributesBuilder
	// AsMethodAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMethodAttributes() MethodAttributesBuilder
	// AsObjectTypeAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsObjectTypeAttributes() ObjectTypeAttributesBuilder
	// AsVariableTypeAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsVariableTypeAttributes() VariableTypeAttributesBuilder
	// AsReferenceTypeAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReferenceTypeAttributes() ReferenceTypeAttributesBuilder
	// AsDataTypeAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataTypeAttributes() DataTypeAttributesBuilder
	// AsViewAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsViewAttributes() ViewAttributesBuilder
	// AsGenericAttributeValue converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsGenericAttributeValue() GenericAttributeValueBuilder
	// AsGenericAttributes converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsGenericAttributes() GenericAttributesBuilder
	// AsAddNodesItem converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddNodesItem() AddNodesItemBuilder
	// AsAddNodesResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddNodesResult() AddNodesResultBuilder
	// AsAddNodesRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddNodesRequest() AddNodesRequestBuilder
	// AsAddNodesResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddNodesResponse() AddNodesResponseBuilder
	// AsAddReferencesItem converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddReferencesItem() AddReferencesItemBuilder
	// AsAddReferencesRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddReferencesRequest() AddReferencesRequestBuilder
	// AsAddReferencesResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAddReferencesResponse() AddReferencesResponseBuilder
	// AsDeleteNodesItem converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteNodesItem() DeleteNodesItemBuilder
	// AsDeleteNodesRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteNodesRequest() DeleteNodesRequestBuilder
	// AsDeleteNodesResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteNodesResponse() DeleteNodesResponseBuilder
	// AsDeleteReferencesItem converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteReferencesItem() DeleteReferencesItemBuilder
	// AsDeleteReferencesRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteReferencesRequest() DeleteReferencesRequestBuilder
	// AsDeleteReferencesResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteReferencesResponse() DeleteReferencesResponseBuilder
	// AsViewDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsViewDescription() ViewDescriptionBuilder
	// AsBrowseDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowseDescription() BrowseDescriptionBuilder
	// AsReferenceDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReferenceDescription() ReferenceDescriptionBuilder
	// AsBrowseResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowseResult() BrowseResultBuilder
	// AsBrowseRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowseRequest() BrowseRequestBuilder
	// AsBrowseResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowseResponse() BrowseResponseBuilder
	// AsBrowseNextRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowseNextRequest() BrowseNextRequestBuilder
	// AsBrowseNextResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowseNextResponse() BrowseNextResponseBuilder
	// AsRelativePathElement converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRelativePathElement() RelativePathElementBuilder
	// AsRelativePath converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRelativePath() RelativePathBuilder
	// AsBrowsePath converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowsePath() BrowsePathBuilder
	// AsBrowsePathTarget converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowsePathTarget() BrowsePathTargetBuilder
	// AsBrowsePathResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBrowsePathResult() BrowsePathResultBuilder
	// AsTranslateBrowsePathsToNodeIdsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTranslateBrowsePathsToNodeIdsRequest() TranslateBrowsePathsToNodeIdsRequestBuilder
	// AsTranslateBrowsePathsToNodeIdsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTranslateBrowsePathsToNodeIdsResponse() TranslateBrowsePathsToNodeIdsResponseBuilder
	// AsRegisterNodesRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisterNodesRequest() RegisterNodesRequestBuilder
	// AsRegisterNodesResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRegisterNodesResponse() RegisterNodesResponseBuilder
	// AsUnregisterNodesRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUnregisterNodesRequest() UnregisterNodesRequestBuilder
	// AsUnregisterNodesResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUnregisterNodesResponse() UnregisterNodesResponseBuilder
	// AsEndpointConfiguration converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEndpointConfiguration() EndpointConfigurationBuilder
	// AsQueryDataDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQueryDataDescription() QueryDataDescriptionBuilder
	// AsNodeTypeDescription converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNodeTypeDescription() NodeTypeDescriptionBuilder
	// AsQueryDataSet converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQueryDataSet() QueryDataSetBuilder
	// AsNodeReference converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNodeReference() NodeReferenceBuilder
	// AsContentFilterElement converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsContentFilterElement() ContentFilterElementBuilder
	// AsContentFilter converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsContentFilter() ContentFilterBuilder
	// AsFilterOperand converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsFilterOperand() FilterOperandBuilder
	// AsElementOperand converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsElementOperand() ElementOperandBuilder
	// AsLiteralOperand converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsLiteralOperand() LiteralOperandBuilder
	// AsAttributeOperand converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAttributeOperand() AttributeOperandBuilder
	// AsSimpleAttributeOperand converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSimpleAttributeOperand() SimpleAttributeOperandBuilder
	// AsContentFilterElementResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsContentFilterElementResult() ContentFilterElementResultBuilder
	// AsContentFilterResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsContentFilterResult() ContentFilterResultBuilder
	// AsParsingResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsParsingResult() ParsingResultBuilder
	// AsQueryFirstRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQueryFirstRequest() QueryFirstRequestBuilder
	// AsQueryFirstResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQueryFirstResponse() QueryFirstResponseBuilder
	// AsQueryNextRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQueryNextRequest() QueryNextRequestBuilder
	// AsQueryNextResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsQueryNextResponse() QueryNextResponseBuilder
	// AsReadValueId converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadValueId() ReadValueIdBuilder
	// AsReadRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadRequest() ReadRequestBuilder
	// AsReadResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadResponse() ReadResponseBuilder
	// AsHistoryReadValueId converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryReadValueId() HistoryReadValueIdBuilder
	// AsHistoryReadResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryReadResult() HistoryReadResultBuilder
	// AsHistoryReadDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryReadDetails() HistoryReadDetailsBuilder
	// AsReadEventDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadEventDetails() ReadEventDetailsBuilder
	// AsReadEventDetails2 converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadEventDetails2() ReadEventDetails2Builder
	// AsSortRuleElement converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSortRuleElement() SortRuleElementBuilder
	// AsReadEventDetailsSorted converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadEventDetailsSorted() ReadEventDetailsSortedBuilder
	// AsReadRawModifiedDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadRawModifiedDetails() ReadRawModifiedDetailsBuilder
	// AsReadProcessedDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadProcessedDetails() ReadProcessedDetailsBuilder
	// AsReadAtTimeDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadAtTimeDetails() ReadAtTimeDetailsBuilder
	// AsReadAnnotationDataDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsReadAnnotationDataDetails() ReadAnnotationDataDetailsBuilder
	// AsHistoryData converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryData() HistoryDataBuilder
	// AsModificationInfo converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsModificationInfo() ModificationInfoBuilder
	// AsHistoryModifiedData converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryModifiedData() HistoryModifiedDataBuilder
	// AsHistoryEvent converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryEvent() HistoryEventBuilder
	// AsHistoryModifiedEvent converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryModifiedEvent() HistoryModifiedEventBuilder
	// AsHistoryReadRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryReadRequest() HistoryReadRequestBuilder
	// AsHistoryReadResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryReadResponse() HistoryReadResponseBuilder
	// AsWriteValue converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsWriteValue() WriteValueBuilder
	// AsWriteRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsWriteRequest() WriteRequestBuilder
	// AsWriteResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsWriteResponse() WriteResponseBuilder
	// AsHistoryUpdateDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryUpdateDetails() HistoryUpdateDetailsBuilder
	// AsUpdateDataDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUpdateDataDetails() UpdateDataDetailsBuilder
	// AsUpdateStructureDataDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUpdateStructureDataDetails() UpdateStructureDataDetailsBuilder
	// AsUpdateEventDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsUpdateEventDetails() UpdateEventDetailsBuilder
	// AsDeleteRawModifiedDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteRawModifiedDetails() DeleteRawModifiedDetailsBuilder
	// AsDeleteAtTimeDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteAtTimeDetails() DeleteAtTimeDetailsBuilder
	// AsDeleteEventDetails converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteEventDetails() DeleteEventDetailsBuilder
	// AsHistoryUpdateResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryUpdateResult() HistoryUpdateResultBuilder
	// AsHistoryUpdateRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryUpdateRequest() HistoryUpdateRequestBuilder
	// AsHistoryUpdateResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryUpdateResponse() HistoryUpdateResponseBuilder
	// AsCallMethodRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCallMethodRequest() CallMethodRequestBuilder
	// AsCallMethodResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCallMethodResult() CallMethodResultBuilder
	// AsCallRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCallRequest() CallRequestBuilder
	// AsCallResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCallResponse() CallResponseBuilder
	// AsMonitoringFilter converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoringFilter() MonitoringFilterBuilder
	// AsDataChangeFilter converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataChangeFilter() DataChangeFilterBuilder
	// AsEventFilter converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEventFilter() EventFilterBuilder
	// AsAggregateConfiguration converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAggregateConfiguration() AggregateConfigurationBuilder
	// AsAggregateFilter converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAggregateFilter() AggregateFilterBuilder
	// AsMonitoringFilterResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoringFilterResult() MonitoringFilterResultBuilder
	// AsEventFilterResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEventFilterResult() EventFilterResultBuilder
	// AsAggregateFilterResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAggregateFilterResult() AggregateFilterResultBuilder
	// AsMonitoringParameters converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoringParameters() MonitoringParametersBuilder
	// AsMonitoredItemCreateRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoredItemCreateRequest() MonitoredItemCreateRequestBuilder
	// AsMonitoredItemCreateResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoredItemCreateResult() MonitoredItemCreateResultBuilder
	// AsCreateMonitoredItemsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCreateMonitoredItemsRequest() CreateMonitoredItemsRequestBuilder
	// AsCreateMonitoredItemsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCreateMonitoredItemsResponse() CreateMonitoredItemsResponseBuilder
	// AsMonitoredItemModifyRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoredItemModifyRequest() MonitoredItemModifyRequestBuilder
	// AsMonitoredItemModifyResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoredItemModifyResult() MonitoredItemModifyResultBuilder
	// AsModifyMonitoredItemsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsModifyMonitoredItemsRequest() ModifyMonitoredItemsRequestBuilder
	// AsModifyMonitoredItemsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsModifyMonitoredItemsResponse() ModifyMonitoredItemsResponseBuilder
	// AsSetMonitoringModeRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSetMonitoringModeRequest() SetMonitoringModeRequestBuilder
	// AsSetMonitoringModeResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSetMonitoringModeResponse() SetMonitoringModeResponseBuilder
	// AsSetTriggeringRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSetTriggeringRequest() SetTriggeringRequestBuilder
	// AsSetTriggeringResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSetTriggeringResponse() SetTriggeringResponseBuilder
	// AsDeleteMonitoredItemsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteMonitoredItemsRequest() DeleteMonitoredItemsRequestBuilder
	// AsDeleteMonitoredItemsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteMonitoredItemsResponse() DeleteMonitoredItemsResponseBuilder
	// AsCreateSubscriptionRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCreateSubscriptionRequest() CreateSubscriptionRequestBuilder
	// AsCreateSubscriptionResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsCreateSubscriptionResponse() CreateSubscriptionResponseBuilder
	// AsModifySubscriptionRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsModifySubscriptionRequest() ModifySubscriptionRequestBuilder
	// AsModifySubscriptionResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsModifySubscriptionResponse() ModifySubscriptionResponseBuilder
	// AsSetPublishingModeRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSetPublishingModeRequest() SetPublishingModeRequestBuilder
	// AsSetPublishingModeResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSetPublishingModeResponse() SetPublishingModeResponseBuilder
	// AsNotificationMessage converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNotificationMessage() NotificationMessageBuilder
	// AsNotificationData converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNotificationData() NotificationDataBuilder
	// AsDataChangeNotification converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDataChangeNotification() DataChangeNotificationBuilder
	// AsMonitoredItemNotification converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsMonitoredItemNotification() MonitoredItemNotificationBuilder
	// AsEventNotificationList converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEventNotificationList() EventNotificationListBuilder
	// AsEventFieldList converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEventFieldList() EventFieldListBuilder
	// AsHistoryEventFieldList converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsHistoryEventFieldList() HistoryEventFieldListBuilder
	// AsStatusChangeNotification converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStatusChangeNotification() StatusChangeNotificationBuilder
	// AsSubscriptionAcknowledgement converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSubscriptionAcknowledgement() SubscriptionAcknowledgementBuilder
	// AsPublishRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishRequest() PublishRequestBuilder
	// AsPublishResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsPublishResponse() PublishResponseBuilder
	// AsRepublishRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRepublishRequest() RepublishRequestBuilder
	// AsRepublishResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRepublishResponse() RepublishResponseBuilder
	// AsTransferResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTransferResult() TransferResultBuilder
	// AsTransferSubscriptionsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTransferSubscriptionsRequest() TransferSubscriptionsRequestBuilder
	// AsTransferSubscriptionsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsTransferSubscriptionsResponse() TransferSubscriptionsResponseBuilder
	// AsDeleteSubscriptionsRequest converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteSubscriptionsRequest() DeleteSubscriptionsRequestBuilder
	// AsDeleteSubscriptionsResponse converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDeleteSubscriptionsResponse() DeleteSubscriptionsResponseBuilder
	// AsBuildInfo converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsBuildInfo() BuildInfoBuilder
	// AsRedundantServerDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRedundantServerDataType() RedundantServerDataTypeBuilder
	// AsEndpointUrlListDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEndpointUrlListDataType() EndpointUrlListDataTypeBuilder
	// AsNetworkGroupDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsNetworkGroupDataType() NetworkGroupDataTypeBuilder
	// AsSamplingIntervalDiagnosticsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSamplingIntervalDiagnosticsDataType() SamplingIntervalDiagnosticsDataTypeBuilder
	// AsServerDiagnosticsSummaryDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsServerDiagnosticsSummaryDataType() ServerDiagnosticsSummaryDataTypeBuilder
	// AsServerStatusDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsServerStatusDataType() ServerStatusDataTypeBuilder
	// AsSessionDiagnosticsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSessionDiagnosticsDataType() SessionDiagnosticsDataTypeBuilder
	// AsSessionSecurityDiagnosticsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSessionSecurityDiagnosticsDataType() SessionSecurityDiagnosticsDataTypeBuilder
	// AsServiceCounterDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsServiceCounterDataType() ServiceCounterDataTypeBuilder
	// AsStatusResult converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsStatusResult() StatusResultBuilder
	// AsSubscriptionDiagnosticsDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSubscriptionDiagnosticsDataType() SubscriptionDiagnosticsDataTypeBuilder
	// AsModelChangeStructureDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsModelChangeStructureDataType() ModelChangeStructureDataTypeBuilder
	// AsSemanticChangeStructureDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsSemanticChangeStructureDataType() SemanticChangeStructureDataTypeBuilder
	// AsRange converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsRange() RangeBuilder
	// AsEUInformation converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsEUInformation() EUInformationBuilder
	// AsComplexNumberType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsComplexNumberType() ComplexNumberTypeBuilder
	// AsDoubleComplexNumberType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsDoubleComplexNumberType() DoubleComplexNumberTypeBuilder
	// AsAxisInformation converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAxisInformation() AxisInformationBuilder
	// AsXVType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsXVType() XVTypeBuilder
	// AsProgramDiagnosticDataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsProgramDiagnosticDataType() ProgramDiagnosticDataTypeBuilder
	// AsProgramDiagnostic2DataType converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsProgramDiagnostic2DataType() ProgramDiagnostic2DataTypeBuilder
	// AsAnnotation converts this build to a subType of ExtensionObjectDefinition. It is always possible to return to current builder using Done()
	AsAnnotation() AnnotationBuilder
	// Build builds the ExtensionObjectDefinition or returns an error if something is wrong
	PartialBuild() (ExtensionObjectDefinitionContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() ExtensionObjectDefinitionContract
	// Build builds the ExtensionObjectDefinition or returns an error if something is wrong
	Build() (ExtensionObjectDefinition, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ExtensionObjectDefinition
}

// NewExtensionObjectDefinitionBuilder() creates a ExtensionObjectDefinitionBuilder
func NewExtensionObjectDefinitionBuilder() ExtensionObjectDefinitionBuilder {
	return &_ExtensionObjectDefinitionBuilder{_ExtensionObjectDefinition: new(_ExtensionObjectDefinition)}
}

type _ExtensionObjectDefinitionChildBuilder interface {
	utils.Copyable
	setParent(ExtensionObjectDefinitionContract)
	buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error)
}

type _ExtensionObjectDefinitionBuilder struct {
	*_ExtensionObjectDefinition

	childBuilder _ExtensionObjectDefinitionChildBuilder

	err *utils.MultiError
}

var _ (ExtensionObjectDefinitionBuilder) = (*_ExtensionObjectDefinitionBuilder)(nil)

func (b *_ExtensionObjectDefinitionBuilder) WithMandatoryFields() ExtensionObjectDefinitionBuilder {
	return b
}

func (b *_ExtensionObjectDefinitionBuilder) PartialBuild() (ExtensionObjectDefinitionContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ExtensionObjectDefinition.deepCopy(), nil
}

func (b *_ExtensionObjectDefinitionBuilder) PartialMustBuild() ExtensionObjectDefinitionContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ExtensionObjectDefinitionBuilder) AsNullExtension() NullExtensionBuilder {
	if cb, ok := b.childBuilder.(NullExtensionBuilder); ok {
		return cb
	}
	cb := NewNullExtensionBuilder().(*_NullExtensionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUnion() UnionBuilder {
	if cb, ok := b.childBuilder.(UnionBuilder); ok {
		return cb
	}
	cb := NewUnionBuilder().(*_UnionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsKeyValuePair() KeyValuePairBuilder {
	if cb, ok := b.childBuilder.(KeyValuePairBuilder); ok {
		return cb
	}
	cb := NewKeyValuePairBuilder().(*_KeyValuePairBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAdditionalParametersType() AdditionalParametersTypeBuilder {
	if cb, ok := b.childBuilder.(AdditionalParametersTypeBuilder); ok {
		return cb
	}
	cb := NewAdditionalParametersTypeBuilder().(*_AdditionalParametersTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEphemeralKeyType() EphemeralKeyTypeBuilder {
	if cb, ok := b.childBuilder.(EphemeralKeyTypeBuilder); ok {
		return cb
	}
	cb := NewEphemeralKeyTypeBuilder().(*_EphemeralKeyTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEndpointType() EndpointTypeBuilder {
	if cb, ok := b.childBuilder.(EndpointTypeBuilder); ok {
		return cb
	}
	cb := NewEndpointTypeBuilder().(*_EndpointTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBitFieldDefinition() BitFieldDefinitionBuilder {
	if cb, ok := b.childBuilder.(BitFieldDefinitionBuilder); ok {
		return cb
	}
	cb := NewBitFieldDefinitionBuilder().(*_BitFieldDefinitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRationalNumber() RationalNumberBuilder {
	if cb, ok := b.childBuilder.(RationalNumberBuilder); ok {
		return cb
	}
	cb := NewRationalNumberBuilder().(*_RationalNumberBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsOpcuaVector() OpcuaVectorBuilder {
	if cb, ok := b.childBuilder.(OpcuaVectorBuilder); ok {
		return cb
	}
	cb := NewOpcuaVectorBuilder().(*_OpcuaVectorBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCartesianCoordinates() CartesianCoordinatesBuilder {
	if cb, ok := b.childBuilder.(CartesianCoordinatesBuilder); ok {
		return cb
	}
	cb := NewCartesianCoordinatesBuilder().(*_CartesianCoordinatesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsOrientation() OrientationBuilder {
	if cb, ok := b.childBuilder.(OrientationBuilder); ok {
		return cb
	}
	cb := NewOrientationBuilder().(*_OrientationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFrame() FrameBuilder {
	if cb, ok := b.childBuilder.(FrameBuilder); ok {
		return cb
	}
	cb := NewFrameBuilder().(*_FrameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsIdentityMappingRuleType() IdentityMappingRuleTypeBuilder {
	if cb, ok := b.childBuilder.(IdentityMappingRuleTypeBuilder); ok {
		return cb
	}
	cb := NewIdentityMappingRuleTypeBuilder().(*_IdentityMappingRuleTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCurrencyUnitType() CurrencyUnitTypeBuilder {
	if cb, ok := b.childBuilder.(CurrencyUnitTypeBuilder); ok {
		return cb
	}
	cb := NewCurrencyUnitTypeBuilder().(*_CurrencyUnitTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAnnotationDataType() AnnotationDataTypeBuilder {
	if cb, ok := b.childBuilder.(AnnotationDataTypeBuilder); ok {
		return cb
	}
	cb := NewAnnotationDataTypeBuilder().(*_AnnotationDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLinearConversionDataType() LinearConversionDataTypeBuilder {
	if cb, ok := b.childBuilder.(LinearConversionDataTypeBuilder); ok {
		return cb
	}
	cb := NewLinearConversionDataTypeBuilder().(*_LinearConversionDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQuantityDimension() QuantityDimensionBuilder {
	if cb, ok := b.childBuilder.(QuantityDimensionBuilder); ok {
		return cb
	}
	cb := NewQuantityDimensionBuilder().(*_QuantityDimensionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTrustListDataType() TrustListDataTypeBuilder {
	if cb, ok := b.childBuilder.(TrustListDataTypeBuilder); ok {
		return cb
	}
	cb := NewTrustListDataTypeBuilder().(*_TrustListDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBaseConfigurationDataType() BaseConfigurationDataTypeBuilder {
	if cb, ok := b.childBuilder.(BaseConfigurationDataTypeBuilder); ok {
		return cb
	}
	cb := NewBaseConfigurationDataTypeBuilder().(*_BaseConfigurationDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBaseConfigurationRecordDataType() BaseConfigurationRecordDataTypeBuilder {
	if cb, ok := b.childBuilder.(BaseConfigurationRecordDataTypeBuilder); ok {
		return cb
	}
	cb := NewBaseConfigurationRecordDataTypeBuilder().(*_BaseConfigurationRecordDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCertificateGroupDataType() CertificateGroupDataTypeBuilder {
	if cb, ok := b.childBuilder.(CertificateGroupDataTypeBuilder); ok {
		return cb
	}
	cb := NewCertificateGroupDataTypeBuilder().(*_CertificateGroupDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsConfigurationUpdateTargetType() ConfigurationUpdateTargetTypeBuilder {
	if cb, ok := b.childBuilder.(ConfigurationUpdateTargetTypeBuilder); ok {
		return cb
	}
	cb := NewConfigurationUpdateTargetTypeBuilder().(*_ConfigurationUpdateTargetTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTransactionErrorType() TransactionErrorTypeBuilder {
	if cb, ok := b.childBuilder.(TransactionErrorTypeBuilder); ok {
		return cb
	}
	cb := NewTransactionErrorTypeBuilder().(*_TransactionErrorTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsApplicationConfigurationDataType() ApplicationConfigurationDataTypeBuilder {
	if cb, ok := b.childBuilder.(ApplicationConfigurationDataTypeBuilder); ok {
		return cb
	}
	cb := NewApplicationConfigurationDataTypeBuilder().(*_ApplicationConfigurationDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsApplicationIdentityDataType() ApplicationIdentityDataTypeBuilder {
	if cb, ok := b.childBuilder.(ApplicationIdentityDataTypeBuilder); ok {
		return cb
	}
	cb := NewApplicationIdentityDataTypeBuilder().(*_ApplicationIdentityDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEndpointDataType() EndpointDataTypeBuilder {
	if cb, ok := b.childBuilder.(EndpointDataTypeBuilder); ok {
		return cb
	}
	cb := NewEndpointDataTypeBuilder().(*_EndpointDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsServerEndpointDataType() ServerEndpointDataTypeBuilder {
	if cb, ok := b.childBuilder.(ServerEndpointDataTypeBuilder); ok {
		return cb
	}
	cb := NewServerEndpointDataTypeBuilder().(*_ServerEndpointDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSecuritySettingsDataType() SecuritySettingsDataTypeBuilder {
	if cb, ok := b.childBuilder.(SecuritySettingsDataTypeBuilder); ok {
		return cb
	}
	cb := NewSecuritySettingsDataTypeBuilder().(*_SecuritySettingsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUserTokenSettingsDataType() UserTokenSettingsDataTypeBuilder {
	if cb, ok := b.childBuilder.(UserTokenSettingsDataTypeBuilder); ok {
		return cb
	}
	cb := NewUserTokenSettingsDataTypeBuilder().(*_UserTokenSettingsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAuthorizationServiceConfigurationDataType() AuthorizationServiceConfigurationDataTypeBuilder {
	if cb, ok := b.childBuilder.(AuthorizationServiceConfigurationDataTypeBuilder); ok {
		return cb
	}
	cb := NewAuthorizationServiceConfigurationDataTypeBuilder().(*_AuthorizationServiceConfigurationDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataTypeSchemaHeader() DataTypeSchemaHeaderBuilder {
	if cb, ok := b.childBuilder.(DataTypeSchemaHeaderBuilder); ok {
		return cb
	}
	cb := NewDataTypeSchemaHeaderBuilder().(*_DataTypeSchemaHeaderBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataTypeDescription() DataTypeDescriptionBuilder {
	if cb, ok := b.childBuilder.(DataTypeDescriptionBuilder); ok {
		return cb
	}
	cb := NewDataTypeDescriptionBuilder().(*_DataTypeDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStructureDescription() StructureDescriptionBuilder {
	if cb, ok := b.childBuilder.(StructureDescriptionBuilder); ok {
		return cb
	}
	cb := NewStructureDescriptionBuilder().(*_StructureDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEnumDescription() EnumDescriptionBuilder {
	if cb, ok := b.childBuilder.(EnumDescriptionBuilder); ok {
		return cb
	}
	cb := NewEnumDescriptionBuilder().(*_EnumDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSimpleTypeDescription() SimpleTypeDescriptionBuilder {
	if cb, ok := b.childBuilder.(SimpleTypeDescriptionBuilder); ok {
		return cb
	}
	cb := NewSimpleTypeDescriptionBuilder().(*_SimpleTypeDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUABinaryFileDataType() UABinaryFileDataTypeBuilder {
	if cb, ok := b.childBuilder.(UABinaryFileDataTypeBuilder); ok {
		return cb
	}
	cb := NewUABinaryFileDataTypeBuilder().(*_UABinaryFileDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPortableQualifiedName() PortableQualifiedNameBuilder {
	if cb, ok := b.childBuilder.(PortableQualifiedNameBuilder); ok {
		return cb
	}
	cb := NewPortableQualifiedNameBuilder().(*_PortableQualifiedNameBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPortableNodeId() PortableNodeIdBuilder {
	if cb, ok := b.childBuilder.(PortableNodeIdBuilder); ok {
		return cb
	}
	cb := NewPortableNodeIdBuilder().(*_PortableNodeIdBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUnsignedRationalNumber() UnsignedRationalNumberBuilder {
	if cb, ok := b.childBuilder.(UnsignedRationalNumberBuilder); ok {
		return cb
	}
	cb := NewUnsignedRationalNumberBuilder().(*_UnsignedRationalNumberBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetMetaDataType() DataSetMetaDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetMetaDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetMetaDataTypeBuilder().(*_DataSetMetaDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFieldMetaData() FieldMetaDataBuilder {
	if cb, ok := b.childBuilder.(FieldMetaDataBuilder); ok {
		return cb
	}
	cb := NewFieldMetaDataBuilder().(*_FieldMetaDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsConfigurationVersionDataType() ConfigurationVersionDataTypeBuilder {
	if cb, ok := b.childBuilder.(ConfigurationVersionDataTypeBuilder); ok {
		return cb
	}
	cb := NewConfigurationVersionDataTypeBuilder().(*_ConfigurationVersionDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedDataSetDataType() PublishedDataSetDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedDataSetDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedDataSetDataTypeBuilder().(*_PublishedDataSetDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedDataSetSourceDataType() PublishedDataSetSourceDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedDataSetSourceDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedDataSetSourceDataTypeBuilder().(*_PublishedDataSetSourceDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedVariableDataType() PublishedVariableDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedVariableDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedVariableDataTypeBuilder().(*_PublishedVariableDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedDataItemsDataType() PublishedDataItemsDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedDataItemsDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedDataItemsDataTypeBuilder().(*_PublishedDataItemsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedEventsDataType() PublishedEventsDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedEventsDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedEventsDataTypeBuilder().(*_PublishedEventsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedDataSetCustomSourceDataType() PublishedDataSetCustomSourceDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedDataSetCustomSourceDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedDataSetCustomSourceDataTypeBuilder().(*_PublishedDataSetCustomSourceDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsActionTargetDataType() ActionTargetDataTypeBuilder {
	if cb, ok := b.childBuilder.(ActionTargetDataTypeBuilder); ok {
		return cb
	}
	cb := NewActionTargetDataTypeBuilder().(*_ActionTargetDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedActionDataType() PublishedActionDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedActionDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedActionDataTypeBuilder().(*_PublishedActionDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsActionMethodDataType() ActionMethodDataTypeBuilder {
	if cb, ok := b.childBuilder.(ActionMethodDataTypeBuilder); ok {
		return cb
	}
	cb := NewActionMethodDataTypeBuilder().(*_ActionMethodDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishedActionMethodDataType() PublishedActionMethodDataTypeBuilder {
	if cb, ok := b.childBuilder.(PublishedActionMethodDataTypeBuilder); ok {
		return cb
	}
	cb := NewPublishedActionMethodDataTypeBuilder().(*_PublishedActionMethodDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetWriterDataType() DataSetWriterDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetWriterDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetWriterDataTypeBuilder().(*_DataSetWriterDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetWriterTransportDataType() DataSetWriterTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetWriterTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetWriterTransportDataTypeBuilder().(*_DataSetWriterTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetWriterMessageDataType() DataSetWriterMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetWriterMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetWriterMessageDataTypeBuilder().(*_DataSetWriterMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubGroupDataType() PubSubGroupDataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubGroupDataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubGroupDataTypeBuilder().(*_PubSubGroupDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsWriterGroupDataType() WriterGroupDataTypeBuilder {
	if cb, ok := b.childBuilder.(WriterGroupDataTypeBuilder); ok {
		return cb
	}
	cb := NewWriterGroupDataTypeBuilder().(*_WriterGroupDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsWriterGroupTransportDataType() WriterGroupTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(WriterGroupTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewWriterGroupTransportDataTypeBuilder().(*_WriterGroupTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsWriterGroupMessageDataType() WriterGroupMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(WriterGroupMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewWriterGroupMessageDataTypeBuilder().(*_WriterGroupMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubConnectionDataType() PubSubConnectionDataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubConnectionDataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubConnectionDataTypeBuilder().(*_PubSubConnectionDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsConnectionTransportDataType() ConnectionTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(ConnectionTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewConnectionTransportDataTypeBuilder().(*_ConnectionTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNetworkAddressDataType() NetworkAddressDataTypeBuilder {
	if cb, ok := b.childBuilder.(NetworkAddressDataTypeBuilder); ok {
		return cb
	}
	cb := NewNetworkAddressDataTypeBuilder().(*_NetworkAddressDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNetworkAddressUrlDataType() NetworkAddressUrlDataTypeBuilder {
	if cb, ok := b.childBuilder.(NetworkAddressUrlDataTypeBuilder); ok {
		return cb
	}
	cb := NewNetworkAddressUrlDataTypeBuilder().(*_NetworkAddressUrlDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReaderGroupDataType() ReaderGroupDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReaderGroupDataTypeBuilder); ok {
		return cb
	}
	cb := NewReaderGroupDataTypeBuilder().(*_ReaderGroupDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReaderGroupTransportDataType() ReaderGroupTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReaderGroupTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewReaderGroupTransportDataTypeBuilder().(*_ReaderGroupTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReaderGroupMessageDataType() ReaderGroupMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReaderGroupMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewReaderGroupMessageDataTypeBuilder().(*_ReaderGroupMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetReaderDataType() DataSetReaderDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetReaderDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetReaderDataTypeBuilder().(*_DataSetReaderDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetReaderTransportDataType() DataSetReaderTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetReaderTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetReaderTransportDataTypeBuilder().(*_DataSetReaderTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataSetReaderMessageDataType() DataSetReaderMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(DataSetReaderMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewDataSetReaderMessageDataTypeBuilder().(*_DataSetReaderMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSubscribedDataSetDataType() SubscribedDataSetDataTypeBuilder {
	if cb, ok := b.childBuilder.(SubscribedDataSetDataTypeBuilder); ok {
		return cb
	}
	cb := NewSubscribedDataSetDataTypeBuilder().(*_SubscribedDataSetDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTargetVariablesDataType() TargetVariablesDataTypeBuilder {
	if cb, ok := b.childBuilder.(TargetVariablesDataTypeBuilder); ok {
		return cb
	}
	cb := NewTargetVariablesDataTypeBuilder().(*_TargetVariablesDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFieldTargetDataType() FieldTargetDataTypeBuilder {
	if cb, ok := b.childBuilder.(FieldTargetDataTypeBuilder); ok {
		return cb
	}
	cb := NewFieldTargetDataTypeBuilder().(*_FieldTargetDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSubscribedDataSetMirrorDataType() SubscribedDataSetMirrorDataTypeBuilder {
	if cb, ok := b.childBuilder.(SubscribedDataSetMirrorDataTypeBuilder); ok {
		return cb
	}
	cb := NewSubscribedDataSetMirrorDataTypeBuilder().(*_SubscribedDataSetMirrorDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubConfigurationDataType() PubSubConfigurationDataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubConfigurationDataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubConfigurationDataTypeBuilder().(*_PubSubConfigurationDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStandaloneSubscribedDataSetRefDataType() StandaloneSubscribedDataSetRefDataTypeBuilder {
	if cb, ok := b.childBuilder.(StandaloneSubscribedDataSetRefDataTypeBuilder); ok {
		return cb
	}
	cb := NewStandaloneSubscribedDataSetRefDataTypeBuilder().(*_StandaloneSubscribedDataSetRefDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStandaloneSubscribedDataSetDataType() StandaloneSubscribedDataSetDataTypeBuilder {
	if cb, ok := b.childBuilder.(StandaloneSubscribedDataSetDataTypeBuilder); ok {
		return cb
	}
	cb := NewStandaloneSubscribedDataSetDataTypeBuilder().(*_StandaloneSubscribedDataSetDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSecurityGroupDataType() SecurityGroupDataTypeBuilder {
	if cb, ok := b.childBuilder.(SecurityGroupDataTypeBuilder); ok {
		return cb
	}
	cb := NewSecurityGroupDataTypeBuilder().(*_SecurityGroupDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubKeyPushTargetDataType() PubSubKeyPushTargetDataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubKeyPushTargetDataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubKeyPushTargetDataTypeBuilder().(*_PubSubKeyPushTargetDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubConfiguration2DataType() PubSubConfiguration2DataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubConfiguration2DataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubConfiguration2DataTypeBuilder().(*_PubSubConfiguration2DataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUadpWriterGroupMessageDataType() UadpWriterGroupMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(UadpWriterGroupMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewUadpWriterGroupMessageDataTypeBuilder().(*_UadpWriterGroupMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUadpDataSetWriterMessageDataType() UadpDataSetWriterMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(UadpDataSetWriterMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewUadpDataSetWriterMessageDataTypeBuilder().(*_UadpDataSetWriterMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUadpDataSetReaderMessageDataType() UadpDataSetReaderMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(UadpDataSetReaderMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewUadpDataSetReaderMessageDataTypeBuilder().(*_UadpDataSetReaderMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonWriterGroupMessageDataType() JsonWriterGroupMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(JsonWriterGroupMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewJsonWriterGroupMessageDataTypeBuilder().(*_JsonWriterGroupMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonDataSetWriterMessageDataType() JsonDataSetWriterMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(JsonDataSetWriterMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewJsonDataSetWriterMessageDataTypeBuilder().(*_JsonDataSetWriterMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonDataSetReaderMessageDataType() JsonDataSetReaderMessageDataTypeBuilder {
	if cb, ok := b.childBuilder.(JsonDataSetReaderMessageDataTypeBuilder); ok {
		return cb
	}
	cb := NewJsonDataSetReaderMessageDataTypeBuilder().(*_JsonDataSetReaderMessageDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQosDataType() QosDataTypeBuilder {
	if cb, ok := b.childBuilder.(QosDataTypeBuilder); ok {
		return cb
	}
	cb := NewQosDataTypeBuilder().(*_QosDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTransmitQosDataType() TransmitQosDataTypeBuilder {
	if cb, ok := b.childBuilder.(TransmitQosDataTypeBuilder); ok {
		return cb
	}
	cb := NewTransmitQosDataTypeBuilder().(*_TransmitQosDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTransmitQosPriorityDataType() TransmitQosPriorityDataTypeBuilder {
	if cb, ok := b.childBuilder.(TransmitQosPriorityDataTypeBuilder); ok {
		return cb
	}
	cb := NewTransmitQosPriorityDataTypeBuilder().(*_TransmitQosPriorityDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReceiveQosDataType() ReceiveQosDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReceiveQosDataTypeBuilder); ok {
		return cb
	}
	cb := NewReceiveQosDataTypeBuilder().(*_ReceiveQosDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReceiveQosPriorityDataType() ReceiveQosPriorityDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReceiveQosPriorityDataTypeBuilder); ok {
		return cb
	}
	cb := NewReceiveQosPriorityDataTypeBuilder().(*_ReceiveQosPriorityDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDatagramConnectionTransportDataType() DatagramConnectionTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(DatagramConnectionTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewDatagramConnectionTransportDataTypeBuilder().(*_DatagramConnectionTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDatagramConnectionTransport2DataType() DatagramConnectionTransport2DataTypeBuilder {
	if cb, ok := b.childBuilder.(DatagramConnectionTransport2DataTypeBuilder); ok {
		return cb
	}
	cb := NewDatagramConnectionTransport2DataTypeBuilder().(*_DatagramConnectionTransport2DataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDatagramWriterGroupTransportDataType() DatagramWriterGroupTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(DatagramWriterGroupTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewDatagramWriterGroupTransportDataTypeBuilder().(*_DatagramWriterGroupTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDatagramWriterGroupTransport2DataType() DatagramWriterGroupTransport2DataTypeBuilder {
	if cb, ok := b.childBuilder.(DatagramWriterGroupTransport2DataTypeBuilder); ok {
		return cb
	}
	cb := NewDatagramWriterGroupTransport2DataTypeBuilder().(*_DatagramWriterGroupTransport2DataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDatagramDataSetReaderTransportDataType() DatagramDataSetReaderTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(DatagramDataSetReaderTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewDatagramDataSetReaderTransportDataTypeBuilder().(*_DatagramDataSetReaderTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDtlsPubSubConnectionDataType() DtlsPubSubConnectionDataTypeBuilder {
	if cb, ok := b.childBuilder.(DtlsPubSubConnectionDataTypeBuilder); ok {
		return cb
	}
	cb := NewDtlsPubSubConnectionDataTypeBuilder().(*_DtlsPubSubConnectionDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrokerConnectionTransportDataType() BrokerConnectionTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(BrokerConnectionTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewBrokerConnectionTransportDataTypeBuilder().(*_BrokerConnectionTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrokerWriterGroupTransportDataType() BrokerWriterGroupTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(BrokerWriterGroupTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewBrokerWriterGroupTransportDataTypeBuilder().(*_BrokerWriterGroupTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrokerDataSetWriterTransportDataType() BrokerDataSetWriterTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(BrokerDataSetWriterTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewBrokerDataSetWriterTransportDataTypeBuilder().(*_BrokerDataSetWriterTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrokerDataSetReaderTransportDataType() BrokerDataSetReaderTransportDataTypeBuilder {
	if cb, ok := b.childBuilder.(BrokerDataSetReaderTransportDataTypeBuilder); ok {
		return cb
	}
	cb := NewBrokerDataSetReaderTransportDataTypeBuilder().(*_BrokerDataSetReaderTransportDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubConfigurationRefDataType() PubSubConfigurationRefDataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubConfigurationRefDataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubConfigurationRefDataTypeBuilder().(*_PubSubConfigurationRefDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPubSubConfigurationValueDataType() PubSubConfigurationValueDataTypeBuilder {
	if cb, ok := b.childBuilder.(PubSubConfigurationValueDataTypeBuilder); ok {
		return cb
	}
	cb := NewPubSubConfigurationValueDataTypeBuilder().(*_PubSubConfigurationValueDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonNetworkMessage() JsonNetworkMessageBuilder {
	if cb, ok := b.childBuilder.(JsonNetworkMessageBuilder); ok {
		return cb
	}
	cb := NewJsonNetworkMessageBuilder().(*_JsonNetworkMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonDataSetMessage() JsonDataSetMessageBuilder {
	if cb, ok := b.childBuilder.(JsonDataSetMessageBuilder); ok {
		return cb
	}
	cb := NewJsonDataSetMessageBuilder().(*_JsonDataSetMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonDataSetMetaDataMessage() JsonDataSetMetaDataMessageBuilder {
	if cb, ok := b.childBuilder.(JsonDataSetMetaDataMessageBuilder); ok {
		return cb
	}
	cb := NewJsonDataSetMetaDataMessageBuilder().(*_JsonDataSetMetaDataMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonApplicationDescriptionMessage() JsonApplicationDescriptionMessageBuilder {
	if cb, ok := b.childBuilder.(JsonApplicationDescriptionMessageBuilder); ok {
		return cb
	}
	cb := NewJsonApplicationDescriptionMessageBuilder().(*_JsonApplicationDescriptionMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonServerEndpointsMessage() JsonServerEndpointsMessageBuilder {
	if cb, ok := b.childBuilder.(JsonServerEndpointsMessageBuilder); ok {
		return cb
	}
	cb := NewJsonServerEndpointsMessageBuilder().(*_JsonServerEndpointsMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonStatusMessage() JsonStatusMessageBuilder {
	if cb, ok := b.childBuilder.(JsonStatusMessageBuilder); ok {
		return cb
	}
	cb := NewJsonStatusMessageBuilder().(*_JsonStatusMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonPubSubConnectionMessage() JsonPubSubConnectionMessageBuilder {
	if cb, ok := b.childBuilder.(JsonPubSubConnectionMessageBuilder); ok {
		return cb
	}
	cb := NewJsonPubSubConnectionMessageBuilder().(*_JsonPubSubConnectionMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonActionMetaDataMessage() JsonActionMetaDataMessageBuilder {
	if cb, ok := b.childBuilder.(JsonActionMetaDataMessageBuilder); ok {
		return cb
	}
	cb := NewJsonActionMetaDataMessageBuilder().(*_JsonActionMetaDataMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonActionResponderMessage() JsonActionResponderMessageBuilder {
	if cb, ok := b.childBuilder.(JsonActionResponderMessageBuilder); ok {
		return cb
	}
	cb := NewJsonActionResponderMessageBuilder().(*_JsonActionResponderMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonActionNetworkMessage() JsonActionNetworkMessageBuilder {
	if cb, ok := b.childBuilder.(JsonActionNetworkMessageBuilder); ok {
		return cb
	}
	cb := NewJsonActionNetworkMessageBuilder().(*_JsonActionNetworkMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonActionRequestMessage() JsonActionRequestMessageBuilder {
	if cb, ok := b.childBuilder.(JsonActionRequestMessageBuilder); ok {
		return cb
	}
	cb := NewJsonActionRequestMessageBuilder().(*_JsonActionRequestMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsJsonActionResponseMessage() JsonActionResponseMessageBuilder {
	if cb, ok := b.childBuilder.(JsonActionResponseMessageBuilder); ok {
		return cb
	}
	cb := NewJsonActionResponseMessageBuilder().(*_JsonActionResponseMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAliasNameDataType() AliasNameDataTypeBuilder {
	if cb, ok := b.childBuilder.(AliasNameDataTypeBuilder); ok {
		return cb
	}
	cb := NewAliasNameDataTypeBuilder().(*_AliasNameDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUserManagementDataType() UserManagementDataTypeBuilder {
	if cb, ok := b.childBuilder.(UserManagementDataTypeBuilder); ok {
		return cb
	}
	cb := NewUserManagementDataTypeBuilder().(*_UserManagementDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPriorityMappingEntryType() PriorityMappingEntryTypeBuilder {
	if cb, ok := b.childBuilder.(PriorityMappingEntryTypeBuilder); ok {
		return cb
	}
	cb := NewPriorityMappingEntryTypeBuilder().(*_PriorityMappingEntryTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLldpManagementAddressTxPortType() LldpManagementAddressTxPortTypeBuilder {
	if cb, ok := b.childBuilder.(LldpManagementAddressTxPortTypeBuilder); ok {
		return cb
	}
	cb := NewLldpManagementAddressTxPortTypeBuilder().(*_LldpManagementAddressTxPortTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLldpManagementAddressType() LldpManagementAddressTypeBuilder {
	if cb, ok := b.childBuilder.(LldpManagementAddressTypeBuilder); ok {
		return cb
	}
	cb := NewLldpManagementAddressTypeBuilder().(*_LldpManagementAddressTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLldpTlvType() LldpTlvTypeBuilder {
	if cb, ok := b.childBuilder.(LldpTlvTypeBuilder); ok {
		return cb
	}
	cb := NewLldpTlvTypeBuilder().(*_LldpTlvTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReferenceDescriptionDataType() ReferenceDescriptionDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReferenceDescriptionDataTypeBuilder); ok {
		return cb
	}
	cb := NewReferenceDescriptionDataTypeBuilder().(*_ReferenceDescriptionDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReferenceListEntryDataType() ReferenceListEntryDataTypeBuilder {
	if cb, ok := b.childBuilder.(ReferenceListEntryDataTypeBuilder); ok {
		return cb
	}
	cb := NewReferenceListEntryDataTypeBuilder().(*_ReferenceListEntryDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLogRecord() LogRecordBuilder {
	if cb, ok := b.childBuilder.(LogRecordBuilder); ok {
		return cb
	}
	cb := NewLogRecordBuilder().(*_LogRecordBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLogRecordsDataType() LogRecordsDataTypeBuilder {
	if cb, ok := b.childBuilder.(LogRecordsDataTypeBuilder); ok {
		return cb
	}
	cb := NewLogRecordsDataTypeBuilder().(*_LogRecordsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSpanContextDataType() SpanContextDataTypeBuilder {
	if cb, ok := b.childBuilder.(SpanContextDataTypeBuilder); ok {
		return cb
	}
	cb := NewSpanContextDataTypeBuilder().(*_SpanContextDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTraceContextDataType() TraceContextDataTypeBuilder {
	if cb, ok := b.childBuilder.(TraceContextDataTypeBuilder); ok {
		return cb
	}
	cb := NewTraceContextDataTypeBuilder().(*_TraceContextDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNameValuePair() NameValuePairBuilder {
	if cb, ok := b.childBuilder.(NameValuePairBuilder); ok {
		return cb
	}
	cb := NewNameValuePairBuilder().(*_NameValuePairBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRolePermissionType() RolePermissionTypeBuilder {
	if cb, ok := b.childBuilder.(RolePermissionTypeBuilder); ok {
		return cb
	}
	cb := NewRolePermissionTypeBuilder().(*_RolePermissionTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataTypeDefinition() DataTypeDefinitionBuilder {
	if cb, ok := b.childBuilder.(DataTypeDefinitionBuilder); ok {
		return cb
	}
	cb := NewDataTypeDefinitionBuilder().(*_DataTypeDefinitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStructureField() StructureFieldBuilder {
	if cb, ok := b.childBuilder.(StructureFieldBuilder); ok {
		return cb
	}
	cb := NewStructureFieldBuilder().(*_StructureFieldBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStructureDefinition() StructureDefinitionBuilder {
	if cb, ok := b.childBuilder.(StructureDefinitionBuilder); ok {
		return cb
	}
	cb := NewStructureDefinitionBuilder().(*_StructureDefinitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEnumDefinition() EnumDefinitionBuilder {
	if cb, ok := b.childBuilder.(EnumDefinitionBuilder); ok {
		return cb
	}
	cb := NewEnumDefinitionBuilder().(*_EnumDefinitionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsArgument() ArgumentBuilder {
	if cb, ok := b.childBuilder.(ArgumentBuilder); ok {
		return cb
	}
	cb := NewArgumentBuilder().(*_ArgumentBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEnumValueType() EnumValueTypeBuilder {
	if cb, ok := b.childBuilder.(EnumValueTypeBuilder); ok {
		return cb
	}
	cb := NewEnumValueTypeBuilder().(*_EnumValueTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEnumField() EnumFieldBuilder {
	if cb, ok := b.childBuilder.(EnumFieldBuilder); ok {
		return cb
	}
	cb := NewEnumFieldBuilder().(*_EnumFieldBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsOptionSet() OptionSetBuilder {
	if cb, ok := b.childBuilder.(OptionSetBuilder); ok {
		return cb
	}
	cb := NewOptionSetBuilder().(*_OptionSetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTimeZoneDataType() TimeZoneDataTypeBuilder {
	if cb, ok := b.childBuilder.(TimeZoneDataTypeBuilder); ok {
		return cb
	}
	cb := NewTimeZoneDataTypeBuilder().(*_TimeZoneDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsApplicationDescription() ApplicationDescriptionBuilder {
	if cb, ok := b.childBuilder.(ApplicationDescriptionBuilder); ok {
		return cb
	}
	cb := NewApplicationDescriptionBuilder().(*_ApplicationDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRequestHeader() RequestHeaderBuilder {
	if cb, ok := b.childBuilder.(RequestHeaderBuilder); ok {
		return cb
	}
	cb := NewRequestHeaderBuilder().(*_RequestHeaderBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsResponseHeader() ResponseHeaderBuilder {
	if cb, ok := b.childBuilder.(ResponseHeaderBuilder); ok {
		return cb
	}
	cb := NewResponseHeaderBuilder().(*_ResponseHeaderBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsServiceFault() ServiceFaultBuilder {
	if cb, ok := b.childBuilder.(ServiceFaultBuilder); ok {
		return cb
	}
	cb := NewServiceFaultBuilder().(*_ServiceFaultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSessionlessInvokeRequestType() SessionlessInvokeRequestTypeBuilder {
	if cb, ok := b.childBuilder.(SessionlessInvokeRequestTypeBuilder); ok {
		return cb
	}
	cb := NewSessionlessInvokeRequestTypeBuilder().(*_SessionlessInvokeRequestTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSessionlessInvokeResponseType() SessionlessInvokeResponseTypeBuilder {
	if cb, ok := b.childBuilder.(SessionlessInvokeResponseTypeBuilder); ok {
		return cb
	}
	cb := NewSessionlessInvokeResponseTypeBuilder().(*_SessionlessInvokeResponseTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFindServersRequest() FindServersRequestBuilder {
	if cb, ok := b.childBuilder.(FindServersRequestBuilder); ok {
		return cb
	}
	cb := NewFindServersRequestBuilder().(*_FindServersRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFindServersResponse() FindServersResponseBuilder {
	if cb, ok := b.childBuilder.(FindServersResponseBuilder); ok {
		return cb
	}
	cb := NewFindServersResponseBuilder().(*_FindServersResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsServerOnNetwork() ServerOnNetworkBuilder {
	if cb, ok := b.childBuilder.(ServerOnNetworkBuilder); ok {
		return cb
	}
	cb := NewServerOnNetworkBuilder().(*_ServerOnNetworkBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFindServersOnNetworkRequest() FindServersOnNetworkRequestBuilder {
	if cb, ok := b.childBuilder.(FindServersOnNetworkRequestBuilder); ok {
		return cb
	}
	cb := NewFindServersOnNetworkRequestBuilder().(*_FindServersOnNetworkRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFindServersOnNetworkResponse() FindServersOnNetworkResponseBuilder {
	if cb, ok := b.childBuilder.(FindServersOnNetworkResponseBuilder); ok {
		return cb
	}
	cb := NewFindServersOnNetworkResponseBuilder().(*_FindServersOnNetworkResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUserTokenPolicy() UserTokenPolicyBuilder {
	if cb, ok := b.childBuilder.(UserTokenPolicyBuilder); ok {
		return cb
	}
	cb := NewUserTokenPolicyBuilder().(*_UserTokenPolicyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEndpointDescription() EndpointDescriptionBuilder {
	if cb, ok := b.childBuilder.(EndpointDescriptionBuilder); ok {
		return cb
	}
	cb := NewEndpointDescriptionBuilder().(*_EndpointDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsGetEndpointsRequest() GetEndpointsRequestBuilder {
	if cb, ok := b.childBuilder.(GetEndpointsRequestBuilder); ok {
		return cb
	}
	cb := NewGetEndpointsRequestBuilder().(*_GetEndpointsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsGetEndpointsResponse() GetEndpointsResponseBuilder {
	if cb, ok := b.childBuilder.(GetEndpointsResponseBuilder); ok {
		return cb
	}
	cb := NewGetEndpointsResponseBuilder().(*_GetEndpointsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisteredServer() RegisteredServerBuilder {
	if cb, ok := b.childBuilder.(RegisteredServerBuilder); ok {
		return cb
	}
	cb := NewRegisteredServerBuilder().(*_RegisteredServerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisterServerRequest() RegisterServerRequestBuilder {
	if cb, ok := b.childBuilder.(RegisterServerRequestBuilder); ok {
		return cb
	}
	cb := NewRegisterServerRequestBuilder().(*_RegisterServerRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisterServerResponse() RegisterServerResponseBuilder {
	if cb, ok := b.childBuilder.(RegisterServerResponseBuilder); ok {
		return cb
	}
	cb := NewRegisterServerResponseBuilder().(*_RegisterServerResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDiscoveryConfiguration() DiscoveryConfigurationBuilder {
	if cb, ok := b.childBuilder.(DiscoveryConfigurationBuilder); ok {
		return cb
	}
	cb := NewDiscoveryConfigurationBuilder().(*_DiscoveryConfigurationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMdnsDiscoveryConfiguration() MdnsDiscoveryConfigurationBuilder {
	if cb, ok := b.childBuilder.(MdnsDiscoveryConfigurationBuilder); ok {
		return cb
	}
	cb := NewMdnsDiscoveryConfigurationBuilder().(*_MdnsDiscoveryConfigurationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisterServer2Request() RegisterServer2RequestBuilder {
	if cb, ok := b.childBuilder.(RegisterServer2RequestBuilder); ok {
		return cb
	}
	cb := NewRegisterServer2RequestBuilder().(*_RegisterServer2RequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisterServer2Response() RegisterServer2ResponseBuilder {
	if cb, ok := b.childBuilder.(RegisterServer2ResponseBuilder); ok {
		return cb
	}
	cb := NewRegisterServer2ResponseBuilder().(*_RegisterServer2ResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsChannelSecurityToken() ChannelSecurityTokenBuilder {
	if cb, ok := b.childBuilder.(ChannelSecurityTokenBuilder); ok {
		return cb
	}
	cb := NewChannelSecurityTokenBuilder().(*_ChannelSecurityTokenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsOpenSecureChannelRequest() OpenSecureChannelRequestBuilder {
	if cb, ok := b.childBuilder.(OpenSecureChannelRequestBuilder); ok {
		return cb
	}
	cb := NewOpenSecureChannelRequestBuilder().(*_OpenSecureChannelRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsOpenSecureChannelResponse() OpenSecureChannelResponseBuilder {
	if cb, ok := b.childBuilder.(OpenSecureChannelResponseBuilder); ok {
		return cb
	}
	cb := NewOpenSecureChannelResponseBuilder().(*_OpenSecureChannelResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCloseSecureChannelRequest() CloseSecureChannelRequestBuilder {
	if cb, ok := b.childBuilder.(CloseSecureChannelRequestBuilder); ok {
		return cb
	}
	cb := NewCloseSecureChannelRequestBuilder().(*_CloseSecureChannelRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCloseSecureChannelResponse() CloseSecureChannelResponseBuilder {
	if cb, ok := b.childBuilder.(CloseSecureChannelResponseBuilder); ok {
		return cb
	}
	cb := NewCloseSecureChannelResponseBuilder().(*_CloseSecureChannelResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSignedSoftwareCertificate() SignedSoftwareCertificateBuilder {
	if cb, ok := b.childBuilder.(SignedSoftwareCertificateBuilder); ok {
		return cb
	}
	cb := NewSignedSoftwareCertificateBuilder().(*_SignedSoftwareCertificateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSignatureData() SignatureDataBuilder {
	if cb, ok := b.childBuilder.(SignatureDataBuilder); ok {
		return cb
	}
	cb := NewSignatureDataBuilder().(*_SignatureDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCreateSessionRequest() CreateSessionRequestBuilder {
	if cb, ok := b.childBuilder.(CreateSessionRequestBuilder); ok {
		return cb
	}
	cb := NewCreateSessionRequestBuilder().(*_CreateSessionRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCreateSessionResponse() CreateSessionResponseBuilder {
	if cb, ok := b.childBuilder.(CreateSessionResponseBuilder); ok {
		return cb
	}
	cb := NewCreateSessionResponseBuilder().(*_CreateSessionResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUserIdentityToken() UserIdentityTokenBuilder {
	if cb, ok := b.childBuilder.(UserIdentityTokenBuilder); ok {
		return cb
	}
	cb := NewUserIdentityTokenBuilder().(*_UserIdentityTokenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAnonymousIdentityToken() AnonymousIdentityTokenBuilder {
	if cb, ok := b.childBuilder.(AnonymousIdentityTokenBuilder); ok {
		return cb
	}
	cb := NewAnonymousIdentityTokenBuilder().(*_AnonymousIdentityTokenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUserNameIdentityToken() UserNameIdentityTokenBuilder {
	if cb, ok := b.childBuilder.(UserNameIdentityTokenBuilder); ok {
		return cb
	}
	cb := NewUserNameIdentityTokenBuilder().(*_UserNameIdentityTokenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsX509IdentityToken() X509IdentityTokenBuilder {
	if cb, ok := b.childBuilder.(X509IdentityTokenBuilder); ok {
		return cb
	}
	cb := NewX509IdentityTokenBuilder().(*_X509IdentityTokenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsIssuedIdentityToken() IssuedIdentityTokenBuilder {
	if cb, ok := b.childBuilder.(IssuedIdentityTokenBuilder); ok {
		return cb
	}
	cb := NewIssuedIdentityTokenBuilder().(*_IssuedIdentityTokenBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsActivateSessionRequest() ActivateSessionRequestBuilder {
	if cb, ok := b.childBuilder.(ActivateSessionRequestBuilder); ok {
		return cb
	}
	cb := NewActivateSessionRequestBuilder().(*_ActivateSessionRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsActivateSessionResponse() ActivateSessionResponseBuilder {
	if cb, ok := b.childBuilder.(ActivateSessionResponseBuilder); ok {
		return cb
	}
	cb := NewActivateSessionResponseBuilder().(*_ActivateSessionResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCloseSessionRequest() CloseSessionRequestBuilder {
	if cb, ok := b.childBuilder.(CloseSessionRequestBuilder); ok {
		return cb
	}
	cb := NewCloseSessionRequestBuilder().(*_CloseSessionRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCloseSessionResponse() CloseSessionResponseBuilder {
	if cb, ok := b.childBuilder.(CloseSessionResponseBuilder); ok {
		return cb
	}
	cb := NewCloseSessionResponseBuilder().(*_CloseSessionResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCancelRequest() CancelRequestBuilder {
	if cb, ok := b.childBuilder.(CancelRequestBuilder); ok {
		return cb
	}
	cb := NewCancelRequestBuilder().(*_CancelRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCancelResponse() CancelResponseBuilder {
	if cb, ok := b.childBuilder.(CancelResponseBuilder); ok {
		return cb
	}
	cb := NewCancelResponseBuilder().(*_CancelResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNodeAttributes() NodeAttributesBuilder {
	if cb, ok := b.childBuilder.(NodeAttributesBuilder); ok {
		return cb
	}
	cb := NewNodeAttributesBuilder().(*_NodeAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsObjectAttributes() ObjectAttributesBuilder {
	if cb, ok := b.childBuilder.(ObjectAttributesBuilder); ok {
		return cb
	}
	cb := NewObjectAttributesBuilder().(*_ObjectAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsVariableAttributes() VariableAttributesBuilder {
	if cb, ok := b.childBuilder.(VariableAttributesBuilder); ok {
		return cb
	}
	cb := NewVariableAttributesBuilder().(*_VariableAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMethodAttributes() MethodAttributesBuilder {
	if cb, ok := b.childBuilder.(MethodAttributesBuilder); ok {
		return cb
	}
	cb := NewMethodAttributesBuilder().(*_MethodAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsObjectTypeAttributes() ObjectTypeAttributesBuilder {
	if cb, ok := b.childBuilder.(ObjectTypeAttributesBuilder); ok {
		return cb
	}
	cb := NewObjectTypeAttributesBuilder().(*_ObjectTypeAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsVariableTypeAttributes() VariableTypeAttributesBuilder {
	if cb, ok := b.childBuilder.(VariableTypeAttributesBuilder); ok {
		return cb
	}
	cb := NewVariableTypeAttributesBuilder().(*_VariableTypeAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReferenceTypeAttributes() ReferenceTypeAttributesBuilder {
	if cb, ok := b.childBuilder.(ReferenceTypeAttributesBuilder); ok {
		return cb
	}
	cb := NewReferenceTypeAttributesBuilder().(*_ReferenceTypeAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataTypeAttributes() DataTypeAttributesBuilder {
	if cb, ok := b.childBuilder.(DataTypeAttributesBuilder); ok {
		return cb
	}
	cb := NewDataTypeAttributesBuilder().(*_DataTypeAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsViewAttributes() ViewAttributesBuilder {
	if cb, ok := b.childBuilder.(ViewAttributesBuilder); ok {
		return cb
	}
	cb := NewViewAttributesBuilder().(*_ViewAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsGenericAttributeValue() GenericAttributeValueBuilder {
	if cb, ok := b.childBuilder.(GenericAttributeValueBuilder); ok {
		return cb
	}
	cb := NewGenericAttributeValueBuilder().(*_GenericAttributeValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsGenericAttributes() GenericAttributesBuilder {
	if cb, ok := b.childBuilder.(GenericAttributesBuilder); ok {
		return cb
	}
	cb := NewGenericAttributesBuilder().(*_GenericAttributesBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddNodesItem() AddNodesItemBuilder {
	if cb, ok := b.childBuilder.(AddNodesItemBuilder); ok {
		return cb
	}
	cb := NewAddNodesItemBuilder().(*_AddNodesItemBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddNodesResult() AddNodesResultBuilder {
	if cb, ok := b.childBuilder.(AddNodesResultBuilder); ok {
		return cb
	}
	cb := NewAddNodesResultBuilder().(*_AddNodesResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddNodesRequest() AddNodesRequestBuilder {
	if cb, ok := b.childBuilder.(AddNodesRequestBuilder); ok {
		return cb
	}
	cb := NewAddNodesRequestBuilder().(*_AddNodesRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddNodesResponse() AddNodesResponseBuilder {
	if cb, ok := b.childBuilder.(AddNodesResponseBuilder); ok {
		return cb
	}
	cb := NewAddNodesResponseBuilder().(*_AddNodesResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddReferencesItem() AddReferencesItemBuilder {
	if cb, ok := b.childBuilder.(AddReferencesItemBuilder); ok {
		return cb
	}
	cb := NewAddReferencesItemBuilder().(*_AddReferencesItemBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddReferencesRequest() AddReferencesRequestBuilder {
	if cb, ok := b.childBuilder.(AddReferencesRequestBuilder); ok {
		return cb
	}
	cb := NewAddReferencesRequestBuilder().(*_AddReferencesRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAddReferencesResponse() AddReferencesResponseBuilder {
	if cb, ok := b.childBuilder.(AddReferencesResponseBuilder); ok {
		return cb
	}
	cb := NewAddReferencesResponseBuilder().(*_AddReferencesResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteNodesItem() DeleteNodesItemBuilder {
	if cb, ok := b.childBuilder.(DeleteNodesItemBuilder); ok {
		return cb
	}
	cb := NewDeleteNodesItemBuilder().(*_DeleteNodesItemBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteNodesRequest() DeleteNodesRequestBuilder {
	if cb, ok := b.childBuilder.(DeleteNodesRequestBuilder); ok {
		return cb
	}
	cb := NewDeleteNodesRequestBuilder().(*_DeleteNodesRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteNodesResponse() DeleteNodesResponseBuilder {
	if cb, ok := b.childBuilder.(DeleteNodesResponseBuilder); ok {
		return cb
	}
	cb := NewDeleteNodesResponseBuilder().(*_DeleteNodesResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteReferencesItem() DeleteReferencesItemBuilder {
	if cb, ok := b.childBuilder.(DeleteReferencesItemBuilder); ok {
		return cb
	}
	cb := NewDeleteReferencesItemBuilder().(*_DeleteReferencesItemBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteReferencesRequest() DeleteReferencesRequestBuilder {
	if cb, ok := b.childBuilder.(DeleteReferencesRequestBuilder); ok {
		return cb
	}
	cb := NewDeleteReferencesRequestBuilder().(*_DeleteReferencesRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteReferencesResponse() DeleteReferencesResponseBuilder {
	if cb, ok := b.childBuilder.(DeleteReferencesResponseBuilder); ok {
		return cb
	}
	cb := NewDeleteReferencesResponseBuilder().(*_DeleteReferencesResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsViewDescription() ViewDescriptionBuilder {
	if cb, ok := b.childBuilder.(ViewDescriptionBuilder); ok {
		return cb
	}
	cb := NewViewDescriptionBuilder().(*_ViewDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowseDescription() BrowseDescriptionBuilder {
	if cb, ok := b.childBuilder.(BrowseDescriptionBuilder); ok {
		return cb
	}
	cb := NewBrowseDescriptionBuilder().(*_BrowseDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReferenceDescription() ReferenceDescriptionBuilder {
	if cb, ok := b.childBuilder.(ReferenceDescriptionBuilder); ok {
		return cb
	}
	cb := NewReferenceDescriptionBuilder().(*_ReferenceDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowseResult() BrowseResultBuilder {
	if cb, ok := b.childBuilder.(BrowseResultBuilder); ok {
		return cb
	}
	cb := NewBrowseResultBuilder().(*_BrowseResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowseRequest() BrowseRequestBuilder {
	if cb, ok := b.childBuilder.(BrowseRequestBuilder); ok {
		return cb
	}
	cb := NewBrowseRequestBuilder().(*_BrowseRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowseResponse() BrowseResponseBuilder {
	if cb, ok := b.childBuilder.(BrowseResponseBuilder); ok {
		return cb
	}
	cb := NewBrowseResponseBuilder().(*_BrowseResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowseNextRequest() BrowseNextRequestBuilder {
	if cb, ok := b.childBuilder.(BrowseNextRequestBuilder); ok {
		return cb
	}
	cb := NewBrowseNextRequestBuilder().(*_BrowseNextRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowseNextResponse() BrowseNextResponseBuilder {
	if cb, ok := b.childBuilder.(BrowseNextResponseBuilder); ok {
		return cb
	}
	cb := NewBrowseNextResponseBuilder().(*_BrowseNextResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRelativePathElement() RelativePathElementBuilder {
	if cb, ok := b.childBuilder.(RelativePathElementBuilder); ok {
		return cb
	}
	cb := NewRelativePathElementBuilder().(*_RelativePathElementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRelativePath() RelativePathBuilder {
	if cb, ok := b.childBuilder.(RelativePathBuilder); ok {
		return cb
	}
	cb := NewRelativePathBuilder().(*_RelativePathBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowsePath() BrowsePathBuilder {
	if cb, ok := b.childBuilder.(BrowsePathBuilder); ok {
		return cb
	}
	cb := NewBrowsePathBuilder().(*_BrowsePathBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowsePathTarget() BrowsePathTargetBuilder {
	if cb, ok := b.childBuilder.(BrowsePathTargetBuilder); ok {
		return cb
	}
	cb := NewBrowsePathTargetBuilder().(*_BrowsePathTargetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBrowsePathResult() BrowsePathResultBuilder {
	if cb, ok := b.childBuilder.(BrowsePathResultBuilder); ok {
		return cb
	}
	cb := NewBrowsePathResultBuilder().(*_BrowsePathResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTranslateBrowsePathsToNodeIdsRequest() TranslateBrowsePathsToNodeIdsRequestBuilder {
	if cb, ok := b.childBuilder.(TranslateBrowsePathsToNodeIdsRequestBuilder); ok {
		return cb
	}
	cb := NewTranslateBrowsePathsToNodeIdsRequestBuilder().(*_TranslateBrowsePathsToNodeIdsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTranslateBrowsePathsToNodeIdsResponse() TranslateBrowsePathsToNodeIdsResponseBuilder {
	if cb, ok := b.childBuilder.(TranslateBrowsePathsToNodeIdsResponseBuilder); ok {
		return cb
	}
	cb := NewTranslateBrowsePathsToNodeIdsResponseBuilder().(*_TranslateBrowsePathsToNodeIdsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisterNodesRequest() RegisterNodesRequestBuilder {
	if cb, ok := b.childBuilder.(RegisterNodesRequestBuilder); ok {
		return cb
	}
	cb := NewRegisterNodesRequestBuilder().(*_RegisterNodesRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRegisterNodesResponse() RegisterNodesResponseBuilder {
	if cb, ok := b.childBuilder.(RegisterNodesResponseBuilder); ok {
		return cb
	}
	cb := NewRegisterNodesResponseBuilder().(*_RegisterNodesResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUnregisterNodesRequest() UnregisterNodesRequestBuilder {
	if cb, ok := b.childBuilder.(UnregisterNodesRequestBuilder); ok {
		return cb
	}
	cb := NewUnregisterNodesRequestBuilder().(*_UnregisterNodesRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUnregisterNodesResponse() UnregisterNodesResponseBuilder {
	if cb, ok := b.childBuilder.(UnregisterNodesResponseBuilder); ok {
		return cb
	}
	cb := NewUnregisterNodesResponseBuilder().(*_UnregisterNodesResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEndpointConfiguration() EndpointConfigurationBuilder {
	if cb, ok := b.childBuilder.(EndpointConfigurationBuilder); ok {
		return cb
	}
	cb := NewEndpointConfigurationBuilder().(*_EndpointConfigurationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQueryDataDescription() QueryDataDescriptionBuilder {
	if cb, ok := b.childBuilder.(QueryDataDescriptionBuilder); ok {
		return cb
	}
	cb := NewQueryDataDescriptionBuilder().(*_QueryDataDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNodeTypeDescription() NodeTypeDescriptionBuilder {
	if cb, ok := b.childBuilder.(NodeTypeDescriptionBuilder); ok {
		return cb
	}
	cb := NewNodeTypeDescriptionBuilder().(*_NodeTypeDescriptionBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQueryDataSet() QueryDataSetBuilder {
	if cb, ok := b.childBuilder.(QueryDataSetBuilder); ok {
		return cb
	}
	cb := NewQueryDataSetBuilder().(*_QueryDataSetBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNodeReference() NodeReferenceBuilder {
	if cb, ok := b.childBuilder.(NodeReferenceBuilder); ok {
		return cb
	}
	cb := NewNodeReferenceBuilder().(*_NodeReferenceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsContentFilterElement() ContentFilterElementBuilder {
	if cb, ok := b.childBuilder.(ContentFilterElementBuilder); ok {
		return cb
	}
	cb := NewContentFilterElementBuilder().(*_ContentFilterElementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsContentFilter() ContentFilterBuilder {
	if cb, ok := b.childBuilder.(ContentFilterBuilder); ok {
		return cb
	}
	cb := NewContentFilterBuilder().(*_ContentFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsFilterOperand() FilterOperandBuilder {
	if cb, ok := b.childBuilder.(FilterOperandBuilder); ok {
		return cb
	}
	cb := NewFilterOperandBuilder().(*_FilterOperandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsElementOperand() ElementOperandBuilder {
	if cb, ok := b.childBuilder.(ElementOperandBuilder); ok {
		return cb
	}
	cb := NewElementOperandBuilder().(*_ElementOperandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsLiteralOperand() LiteralOperandBuilder {
	if cb, ok := b.childBuilder.(LiteralOperandBuilder); ok {
		return cb
	}
	cb := NewLiteralOperandBuilder().(*_LiteralOperandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAttributeOperand() AttributeOperandBuilder {
	if cb, ok := b.childBuilder.(AttributeOperandBuilder); ok {
		return cb
	}
	cb := NewAttributeOperandBuilder().(*_AttributeOperandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSimpleAttributeOperand() SimpleAttributeOperandBuilder {
	if cb, ok := b.childBuilder.(SimpleAttributeOperandBuilder); ok {
		return cb
	}
	cb := NewSimpleAttributeOperandBuilder().(*_SimpleAttributeOperandBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsContentFilterElementResult() ContentFilterElementResultBuilder {
	if cb, ok := b.childBuilder.(ContentFilterElementResultBuilder); ok {
		return cb
	}
	cb := NewContentFilterElementResultBuilder().(*_ContentFilterElementResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsContentFilterResult() ContentFilterResultBuilder {
	if cb, ok := b.childBuilder.(ContentFilterResultBuilder); ok {
		return cb
	}
	cb := NewContentFilterResultBuilder().(*_ContentFilterResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsParsingResult() ParsingResultBuilder {
	if cb, ok := b.childBuilder.(ParsingResultBuilder); ok {
		return cb
	}
	cb := NewParsingResultBuilder().(*_ParsingResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQueryFirstRequest() QueryFirstRequestBuilder {
	if cb, ok := b.childBuilder.(QueryFirstRequestBuilder); ok {
		return cb
	}
	cb := NewQueryFirstRequestBuilder().(*_QueryFirstRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQueryFirstResponse() QueryFirstResponseBuilder {
	if cb, ok := b.childBuilder.(QueryFirstResponseBuilder); ok {
		return cb
	}
	cb := NewQueryFirstResponseBuilder().(*_QueryFirstResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQueryNextRequest() QueryNextRequestBuilder {
	if cb, ok := b.childBuilder.(QueryNextRequestBuilder); ok {
		return cb
	}
	cb := NewQueryNextRequestBuilder().(*_QueryNextRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsQueryNextResponse() QueryNextResponseBuilder {
	if cb, ok := b.childBuilder.(QueryNextResponseBuilder); ok {
		return cb
	}
	cb := NewQueryNextResponseBuilder().(*_QueryNextResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadValueId() ReadValueIdBuilder {
	if cb, ok := b.childBuilder.(ReadValueIdBuilder); ok {
		return cb
	}
	cb := NewReadValueIdBuilder().(*_ReadValueIdBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadRequest() ReadRequestBuilder {
	if cb, ok := b.childBuilder.(ReadRequestBuilder); ok {
		return cb
	}
	cb := NewReadRequestBuilder().(*_ReadRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadResponse() ReadResponseBuilder {
	if cb, ok := b.childBuilder.(ReadResponseBuilder); ok {
		return cb
	}
	cb := NewReadResponseBuilder().(*_ReadResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryReadValueId() HistoryReadValueIdBuilder {
	if cb, ok := b.childBuilder.(HistoryReadValueIdBuilder); ok {
		return cb
	}
	cb := NewHistoryReadValueIdBuilder().(*_HistoryReadValueIdBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryReadResult() HistoryReadResultBuilder {
	if cb, ok := b.childBuilder.(HistoryReadResultBuilder); ok {
		return cb
	}
	cb := NewHistoryReadResultBuilder().(*_HistoryReadResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryReadDetails() HistoryReadDetailsBuilder {
	if cb, ok := b.childBuilder.(HistoryReadDetailsBuilder); ok {
		return cb
	}
	cb := NewHistoryReadDetailsBuilder().(*_HistoryReadDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadEventDetails() ReadEventDetailsBuilder {
	if cb, ok := b.childBuilder.(ReadEventDetailsBuilder); ok {
		return cb
	}
	cb := NewReadEventDetailsBuilder().(*_ReadEventDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadEventDetails2() ReadEventDetails2Builder {
	if cb, ok := b.childBuilder.(ReadEventDetails2Builder); ok {
		return cb
	}
	cb := NewReadEventDetails2Builder().(*_ReadEventDetails2Builder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSortRuleElement() SortRuleElementBuilder {
	if cb, ok := b.childBuilder.(SortRuleElementBuilder); ok {
		return cb
	}
	cb := NewSortRuleElementBuilder().(*_SortRuleElementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadEventDetailsSorted() ReadEventDetailsSortedBuilder {
	if cb, ok := b.childBuilder.(ReadEventDetailsSortedBuilder); ok {
		return cb
	}
	cb := NewReadEventDetailsSortedBuilder().(*_ReadEventDetailsSortedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadRawModifiedDetails() ReadRawModifiedDetailsBuilder {
	if cb, ok := b.childBuilder.(ReadRawModifiedDetailsBuilder); ok {
		return cb
	}
	cb := NewReadRawModifiedDetailsBuilder().(*_ReadRawModifiedDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadProcessedDetails() ReadProcessedDetailsBuilder {
	if cb, ok := b.childBuilder.(ReadProcessedDetailsBuilder); ok {
		return cb
	}
	cb := NewReadProcessedDetailsBuilder().(*_ReadProcessedDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadAtTimeDetails() ReadAtTimeDetailsBuilder {
	if cb, ok := b.childBuilder.(ReadAtTimeDetailsBuilder); ok {
		return cb
	}
	cb := NewReadAtTimeDetailsBuilder().(*_ReadAtTimeDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsReadAnnotationDataDetails() ReadAnnotationDataDetailsBuilder {
	if cb, ok := b.childBuilder.(ReadAnnotationDataDetailsBuilder); ok {
		return cb
	}
	cb := NewReadAnnotationDataDetailsBuilder().(*_ReadAnnotationDataDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryData() HistoryDataBuilder {
	if cb, ok := b.childBuilder.(HistoryDataBuilder); ok {
		return cb
	}
	cb := NewHistoryDataBuilder().(*_HistoryDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsModificationInfo() ModificationInfoBuilder {
	if cb, ok := b.childBuilder.(ModificationInfoBuilder); ok {
		return cb
	}
	cb := NewModificationInfoBuilder().(*_ModificationInfoBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryModifiedData() HistoryModifiedDataBuilder {
	if cb, ok := b.childBuilder.(HistoryModifiedDataBuilder); ok {
		return cb
	}
	cb := NewHistoryModifiedDataBuilder().(*_HistoryModifiedDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryEvent() HistoryEventBuilder {
	if cb, ok := b.childBuilder.(HistoryEventBuilder); ok {
		return cb
	}
	cb := NewHistoryEventBuilder().(*_HistoryEventBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryModifiedEvent() HistoryModifiedEventBuilder {
	if cb, ok := b.childBuilder.(HistoryModifiedEventBuilder); ok {
		return cb
	}
	cb := NewHistoryModifiedEventBuilder().(*_HistoryModifiedEventBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryReadRequest() HistoryReadRequestBuilder {
	if cb, ok := b.childBuilder.(HistoryReadRequestBuilder); ok {
		return cb
	}
	cb := NewHistoryReadRequestBuilder().(*_HistoryReadRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryReadResponse() HistoryReadResponseBuilder {
	if cb, ok := b.childBuilder.(HistoryReadResponseBuilder); ok {
		return cb
	}
	cb := NewHistoryReadResponseBuilder().(*_HistoryReadResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsWriteValue() WriteValueBuilder {
	if cb, ok := b.childBuilder.(WriteValueBuilder); ok {
		return cb
	}
	cb := NewWriteValueBuilder().(*_WriteValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsWriteRequest() WriteRequestBuilder {
	if cb, ok := b.childBuilder.(WriteRequestBuilder); ok {
		return cb
	}
	cb := NewWriteRequestBuilder().(*_WriteRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsWriteResponse() WriteResponseBuilder {
	if cb, ok := b.childBuilder.(WriteResponseBuilder); ok {
		return cb
	}
	cb := NewWriteResponseBuilder().(*_WriteResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryUpdateDetails() HistoryUpdateDetailsBuilder {
	if cb, ok := b.childBuilder.(HistoryUpdateDetailsBuilder); ok {
		return cb
	}
	cb := NewHistoryUpdateDetailsBuilder().(*_HistoryUpdateDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUpdateDataDetails() UpdateDataDetailsBuilder {
	if cb, ok := b.childBuilder.(UpdateDataDetailsBuilder); ok {
		return cb
	}
	cb := NewUpdateDataDetailsBuilder().(*_UpdateDataDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUpdateStructureDataDetails() UpdateStructureDataDetailsBuilder {
	if cb, ok := b.childBuilder.(UpdateStructureDataDetailsBuilder); ok {
		return cb
	}
	cb := NewUpdateStructureDataDetailsBuilder().(*_UpdateStructureDataDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsUpdateEventDetails() UpdateEventDetailsBuilder {
	if cb, ok := b.childBuilder.(UpdateEventDetailsBuilder); ok {
		return cb
	}
	cb := NewUpdateEventDetailsBuilder().(*_UpdateEventDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteRawModifiedDetails() DeleteRawModifiedDetailsBuilder {
	if cb, ok := b.childBuilder.(DeleteRawModifiedDetailsBuilder); ok {
		return cb
	}
	cb := NewDeleteRawModifiedDetailsBuilder().(*_DeleteRawModifiedDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteAtTimeDetails() DeleteAtTimeDetailsBuilder {
	if cb, ok := b.childBuilder.(DeleteAtTimeDetailsBuilder); ok {
		return cb
	}
	cb := NewDeleteAtTimeDetailsBuilder().(*_DeleteAtTimeDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteEventDetails() DeleteEventDetailsBuilder {
	if cb, ok := b.childBuilder.(DeleteEventDetailsBuilder); ok {
		return cb
	}
	cb := NewDeleteEventDetailsBuilder().(*_DeleteEventDetailsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryUpdateResult() HistoryUpdateResultBuilder {
	if cb, ok := b.childBuilder.(HistoryUpdateResultBuilder); ok {
		return cb
	}
	cb := NewHistoryUpdateResultBuilder().(*_HistoryUpdateResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryUpdateRequest() HistoryUpdateRequestBuilder {
	if cb, ok := b.childBuilder.(HistoryUpdateRequestBuilder); ok {
		return cb
	}
	cb := NewHistoryUpdateRequestBuilder().(*_HistoryUpdateRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryUpdateResponse() HistoryUpdateResponseBuilder {
	if cb, ok := b.childBuilder.(HistoryUpdateResponseBuilder); ok {
		return cb
	}
	cb := NewHistoryUpdateResponseBuilder().(*_HistoryUpdateResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCallMethodRequest() CallMethodRequestBuilder {
	if cb, ok := b.childBuilder.(CallMethodRequestBuilder); ok {
		return cb
	}
	cb := NewCallMethodRequestBuilder().(*_CallMethodRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCallMethodResult() CallMethodResultBuilder {
	if cb, ok := b.childBuilder.(CallMethodResultBuilder); ok {
		return cb
	}
	cb := NewCallMethodResultBuilder().(*_CallMethodResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCallRequest() CallRequestBuilder {
	if cb, ok := b.childBuilder.(CallRequestBuilder); ok {
		return cb
	}
	cb := NewCallRequestBuilder().(*_CallRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCallResponse() CallResponseBuilder {
	if cb, ok := b.childBuilder.(CallResponseBuilder); ok {
		return cb
	}
	cb := NewCallResponseBuilder().(*_CallResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoringFilter() MonitoringFilterBuilder {
	if cb, ok := b.childBuilder.(MonitoringFilterBuilder); ok {
		return cb
	}
	cb := NewMonitoringFilterBuilder().(*_MonitoringFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataChangeFilter() DataChangeFilterBuilder {
	if cb, ok := b.childBuilder.(DataChangeFilterBuilder); ok {
		return cb
	}
	cb := NewDataChangeFilterBuilder().(*_DataChangeFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEventFilter() EventFilterBuilder {
	if cb, ok := b.childBuilder.(EventFilterBuilder); ok {
		return cb
	}
	cb := NewEventFilterBuilder().(*_EventFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAggregateConfiguration() AggregateConfigurationBuilder {
	if cb, ok := b.childBuilder.(AggregateConfigurationBuilder); ok {
		return cb
	}
	cb := NewAggregateConfigurationBuilder().(*_AggregateConfigurationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAggregateFilter() AggregateFilterBuilder {
	if cb, ok := b.childBuilder.(AggregateFilterBuilder); ok {
		return cb
	}
	cb := NewAggregateFilterBuilder().(*_AggregateFilterBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoringFilterResult() MonitoringFilterResultBuilder {
	if cb, ok := b.childBuilder.(MonitoringFilterResultBuilder); ok {
		return cb
	}
	cb := NewMonitoringFilterResultBuilder().(*_MonitoringFilterResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEventFilterResult() EventFilterResultBuilder {
	if cb, ok := b.childBuilder.(EventFilterResultBuilder); ok {
		return cb
	}
	cb := NewEventFilterResultBuilder().(*_EventFilterResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAggregateFilterResult() AggregateFilterResultBuilder {
	if cb, ok := b.childBuilder.(AggregateFilterResultBuilder); ok {
		return cb
	}
	cb := NewAggregateFilterResultBuilder().(*_AggregateFilterResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoringParameters() MonitoringParametersBuilder {
	if cb, ok := b.childBuilder.(MonitoringParametersBuilder); ok {
		return cb
	}
	cb := NewMonitoringParametersBuilder().(*_MonitoringParametersBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoredItemCreateRequest() MonitoredItemCreateRequestBuilder {
	if cb, ok := b.childBuilder.(MonitoredItemCreateRequestBuilder); ok {
		return cb
	}
	cb := NewMonitoredItemCreateRequestBuilder().(*_MonitoredItemCreateRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoredItemCreateResult() MonitoredItemCreateResultBuilder {
	if cb, ok := b.childBuilder.(MonitoredItemCreateResultBuilder); ok {
		return cb
	}
	cb := NewMonitoredItemCreateResultBuilder().(*_MonitoredItemCreateResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCreateMonitoredItemsRequest() CreateMonitoredItemsRequestBuilder {
	if cb, ok := b.childBuilder.(CreateMonitoredItemsRequestBuilder); ok {
		return cb
	}
	cb := NewCreateMonitoredItemsRequestBuilder().(*_CreateMonitoredItemsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCreateMonitoredItemsResponse() CreateMonitoredItemsResponseBuilder {
	if cb, ok := b.childBuilder.(CreateMonitoredItemsResponseBuilder); ok {
		return cb
	}
	cb := NewCreateMonitoredItemsResponseBuilder().(*_CreateMonitoredItemsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoredItemModifyRequest() MonitoredItemModifyRequestBuilder {
	if cb, ok := b.childBuilder.(MonitoredItemModifyRequestBuilder); ok {
		return cb
	}
	cb := NewMonitoredItemModifyRequestBuilder().(*_MonitoredItemModifyRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoredItemModifyResult() MonitoredItemModifyResultBuilder {
	if cb, ok := b.childBuilder.(MonitoredItemModifyResultBuilder); ok {
		return cb
	}
	cb := NewMonitoredItemModifyResultBuilder().(*_MonitoredItemModifyResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsModifyMonitoredItemsRequest() ModifyMonitoredItemsRequestBuilder {
	if cb, ok := b.childBuilder.(ModifyMonitoredItemsRequestBuilder); ok {
		return cb
	}
	cb := NewModifyMonitoredItemsRequestBuilder().(*_ModifyMonitoredItemsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsModifyMonitoredItemsResponse() ModifyMonitoredItemsResponseBuilder {
	if cb, ok := b.childBuilder.(ModifyMonitoredItemsResponseBuilder); ok {
		return cb
	}
	cb := NewModifyMonitoredItemsResponseBuilder().(*_ModifyMonitoredItemsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSetMonitoringModeRequest() SetMonitoringModeRequestBuilder {
	if cb, ok := b.childBuilder.(SetMonitoringModeRequestBuilder); ok {
		return cb
	}
	cb := NewSetMonitoringModeRequestBuilder().(*_SetMonitoringModeRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSetMonitoringModeResponse() SetMonitoringModeResponseBuilder {
	if cb, ok := b.childBuilder.(SetMonitoringModeResponseBuilder); ok {
		return cb
	}
	cb := NewSetMonitoringModeResponseBuilder().(*_SetMonitoringModeResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSetTriggeringRequest() SetTriggeringRequestBuilder {
	if cb, ok := b.childBuilder.(SetTriggeringRequestBuilder); ok {
		return cb
	}
	cb := NewSetTriggeringRequestBuilder().(*_SetTriggeringRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSetTriggeringResponse() SetTriggeringResponseBuilder {
	if cb, ok := b.childBuilder.(SetTriggeringResponseBuilder); ok {
		return cb
	}
	cb := NewSetTriggeringResponseBuilder().(*_SetTriggeringResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteMonitoredItemsRequest() DeleteMonitoredItemsRequestBuilder {
	if cb, ok := b.childBuilder.(DeleteMonitoredItemsRequestBuilder); ok {
		return cb
	}
	cb := NewDeleteMonitoredItemsRequestBuilder().(*_DeleteMonitoredItemsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteMonitoredItemsResponse() DeleteMonitoredItemsResponseBuilder {
	if cb, ok := b.childBuilder.(DeleteMonitoredItemsResponseBuilder); ok {
		return cb
	}
	cb := NewDeleteMonitoredItemsResponseBuilder().(*_DeleteMonitoredItemsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCreateSubscriptionRequest() CreateSubscriptionRequestBuilder {
	if cb, ok := b.childBuilder.(CreateSubscriptionRequestBuilder); ok {
		return cb
	}
	cb := NewCreateSubscriptionRequestBuilder().(*_CreateSubscriptionRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsCreateSubscriptionResponse() CreateSubscriptionResponseBuilder {
	if cb, ok := b.childBuilder.(CreateSubscriptionResponseBuilder); ok {
		return cb
	}
	cb := NewCreateSubscriptionResponseBuilder().(*_CreateSubscriptionResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsModifySubscriptionRequest() ModifySubscriptionRequestBuilder {
	if cb, ok := b.childBuilder.(ModifySubscriptionRequestBuilder); ok {
		return cb
	}
	cb := NewModifySubscriptionRequestBuilder().(*_ModifySubscriptionRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsModifySubscriptionResponse() ModifySubscriptionResponseBuilder {
	if cb, ok := b.childBuilder.(ModifySubscriptionResponseBuilder); ok {
		return cb
	}
	cb := NewModifySubscriptionResponseBuilder().(*_ModifySubscriptionResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSetPublishingModeRequest() SetPublishingModeRequestBuilder {
	if cb, ok := b.childBuilder.(SetPublishingModeRequestBuilder); ok {
		return cb
	}
	cb := NewSetPublishingModeRequestBuilder().(*_SetPublishingModeRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSetPublishingModeResponse() SetPublishingModeResponseBuilder {
	if cb, ok := b.childBuilder.(SetPublishingModeResponseBuilder); ok {
		return cb
	}
	cb := NewSetPublishingModeResponseBuilder().(*_SetPublishingModeResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNotificationMessage() NotificationMessageBuilder {
	if cb, ok := b.childBuilder.(NotificationMessageBuilder); ok {
		return cb
	}
	cb := NewNotificationMessageBuilder().(*_NotificationMessageBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNotificationData() NotificationDataBuilder {
	if cb, ok := b.childBuilder.(NotificationDataBuilder); ok {
		return cb
	}
	cb := NewNotificationDataBuilder().(*_NotificationDataBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDataChangeNotification() DataChangeNotificationBuilder {
	if cb, ok := b.childBuilder.(DataChangeNotificationBuilder); ok {
		return cb
	}
	cb := NewDataChangeNotificationBuilder().(*_DataChangeNotificationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsMonitoredItemNotification() MonitoredItemNotificationBuilder {
	if cb, ok := b.childBuilder.(MonitoredItemNotificationBuilder); ok {
		return cb
	}
	cb := NewMonitoredItemNotificationBuilder().(*_MonitoredItemNotificationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEventNotificationList() EventNotificationListBuilder {
	if cb, ok := b.childBuilder.(EventNotificationListBuilder); ok {
		return cb
	}
	cb := NewEventNotificationListBuilder().(*_EventNotificationListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEventFieldList() EventFieldListBuilder {
	if cb, ok := b.childBuilder.(EventFieldListBuilder); ok {
		return cb
	}
	cb := NewEventFieldListBuilder().(*_EventFieldListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsHistoryEventFieldList() HistoryEventFieldListBuilder {
	if cb, ok := b.childBuilder.(HistoryEventFieldListBuilder); ok {
		return cb
	}
	cb := NewHistoryEventFieldListBuilder().(*_HistoryEventFieldListBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStatusChangeNotification() StatusChangeNotificationBuilder {
	if cb, ok := b.childBuilder.(StatusChangeNotificationBuilder); ok {
		return cb
	}
	cb := NewStatusChangeNotificationBuilder().(*_StatusChangeNotificationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSubscriptionAcknowledgement() SubscriptionAcknowledgementBuilder {
	if cb, ok := b.childBuilder.(SubscriptionAcknowledgementBuilder); ok {
		return cb
	}
	cb := NewSubscriptionAcknowledgementBuilder().(*_SubscriptionAcknowledgementBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishRequest() PublishRequestBuilder {
	if cb, ok := b.childBuilder.(PublishRequestBuilder); ok {
		return cb
	}
	cb := NewPublishRequestBuilder().(*_PublishRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsPublishResponse() PublishResponseBuilder {
	if cb, ok := b.childBuilder.(PublishResponseBuilder); ok {
		return cb
	}
	cb := NewPublishResponseBuilder().(*_PublishResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRepublishRequest() RepublishRequestBuilder {
	if cb, ok := b.childBuilder.(RepublishRequestBuilder); ok {
		return cb
	}
	cb := NewRepublishRequestBuilder().(*_RepublishRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRepublishResponse() RepublishResponseBuilder {
	if cb, ok := b.childBuilder.(RepublishResponseBuilder); ok {
		return cb
	}
	cb := NewRepublishResponseBuilder().(*_RepublishResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTransferResult() TransferResultBuilder {
	if cb, ok := b.childBuilder.(TransferResultBuilder); ok {
		return cb
	}
	cb := NewTransferResultBuilder().(*_TransferResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTransferSubscriptionsRequest() TransferSubscriptionsRequestBuilder {
	if cb, ok := b.childBuilder.(TransferSubscriptionsRequestBuilder); ok {
		return cb
	}
	cb := NewTransferSubscriptionsRequestBuilder().(*_TransferSubscriptionsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsTransferSubscriptionsResponse() TransferSubscriptionsResponseBuilder {
	if cb, ok := b.childBuilder.(TransferSubscriptionsResponseBuilder); ok {
		return cb
	}
	cb := NewTransferSubscriptionsResponseBuilder().(*_TransferSubscriptionsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteSubscriptionsRequest() DeleteSubscriptionsRequestBuilder {
	if cb, ok := b.childBuilder.(DeleteSubscriptionsRequestBuilder); ok {
		return cb
	}
	cb := NewDeleteSubscriptionsRequestBuilder().(*_DeleteSubscriptionsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDeleteSubscriptionsResponse() DeleteSubscriptionsResponseBuilder {
	if cb, ok := b.childBuilder.(DeleteSubscriptionsResponseBuilder); ok {
		return cb
	}
	cb := NewDeleteSubscriptionsResponseBuilder().(*_DeleteSubscriptionsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsBuildInfo() BuildInfoBuilder {
	if cb, ok := b.childBuilder.(BuildInfoBuilder); ok {
		return cb
	}
	cb := NewBuildInfoBuilder().(*_BuildInfoBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRedundantServerDataType() RedundantServerDataTypeBuilder {
	if cb, ok := b.childBuilder.(RedundantServerDataTypeBuilder); ok {
		return cb
	}
	cb := NewRedundantServerDataTypeBuilder().(*_RedundantServerDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEndpointUrlListDataType() EndpointUrlListDataTypeBuilder {
	if cb, ok := b.childBuilder.(EndpointUrlListDataTypeBuilder); ok {
		return cb
	}
	cb := NewEndpointUrlListDataTypeBuilder().(*_EndpointUrlListDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsNetworkGroupDataType() NetworkGroupDataTypeBuilder {
	if cb, ok := b.childBuilder.(NetworkGroupDataTypeBuilder); ok {
		return cb
	}
	cb := NewNetworkGroupDataTypeBuilder().(*_NetworkGroupDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSamplingIntervalDiagnosticsDataType() SamplingIntervalDiagnosticsDataTypeBuilder {
	if cb, ok := b.childBuilder.(SamplingIntervalDiagnosticsDataTypeBuilder); ok {
		return cb
	}
	cb := NewSamplingIntervalDiagnosticsDataTypeBuilder().(*_SamplingIntervalDiagnosticsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsServerDiagnosticsSummaryDataType() ServerDiagnosticsSummaryDataTypeBuilder {
	if cb, ok := b.childBuilder.(ServerDiagnosticsSummaryDataTypeBuilder); ok {
		return cb
	}
	cb := NewServerDiagnosticsSummaryDataTypeBuilder().(*_ServerDiagnosticsSummaryDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsServerStatusDataType() ServerStatusDataTypeBuilder {
	if cb, ok := b.childBuilder.(ServerStatusDataTypeBuilder); ok {
		return cb
	}
	cb := NewServerStatusDataTypeBuilder().(*_ServerStatusDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSessionDiagnosticsDataType() SessionDiagnosticsDataTypeBuilder {
	if cb, ok := b.childBuilder.(SessionDiagnosticsDataTypeBuilder); ok {
		return cb
	}
	cb := NewSessionDiagnosticsDataTypeBuilder().(*_SessionDiagnosticsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSessionSecurityDiagnosticsDataType() SessionSecurityDiagnosticsDataTypeBuilder {
	if cb, ok := b.childBuilder.(SessionSecurityDiagnosticsDataTypeBuilder); ok {
		return cb
	}
	cb := NewSessionSecurityDiagnosticsDataTypeBuilder().(*_SessionSecurityDiagnosticsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsServiceCounterDataType() ServiceCounterDataTypeBuilder {
	if cb, ok := b.childBuilder.(ServiceCounterDataTypeBuilder); ok {
		return cb
	}
	cb := NewServiceCounterDataTypeBuilder().(*_ServiceCounterDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsStatusResult() StatusResultBuilder {
	if cb, ok := b.childBuilder.(StatusResultBuilder); ok {
		return cb
	}
	cb := NewStatusResultBuilder().(*_StatusResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSubscriptionDiagnosticsDataType() SubscriptionDiagnosticsDataTypeBuilder {
	if cb, ok := b.childBuilder.(SubscriptionDiagnosticsDataTypeBuilder); ok {
		return cb
	}
	cb := NewSubscriptionDiagnosticsDataTypeBuilder().(*_SubscriptionDiagnosticsDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsModelChangeStructureDataType() ModelChangeStructureDataTypeBuilder {
	if cb, ok := b.childBuilder.(ModelChangeStructureDataTypeBuilder); ok {
		return cb
	}
	cb := NewModelChangeStructureDataTypeBuilder().(*_ModelChangeStructureDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsSemanticChangeStructureDataType() SemanticChangeStructureDataTypeBuilder {
	if cb, ok := b.childBuilder.(SemanticChangeStructureDataTypeBuilder); ok {
		return cb
	}
	cb := NewSemanticChangeStructureDataTypeBuilder().(*_SemanticChangeStructureDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsRange() RangeBuilder {
	if cb, ok := b.childBuilder.(RangeBuilder); ok {
		return cb
	}
	cb := NewRangeBuilder().(*_RangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsEUInformation() EUInformationBuilder {
	if cb, ok := b.childBuilder.(EUInformationBuilder); ok {
		return cb
	}
	cb := NewEUInformationBuilder().(*_EUInformationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsComplexNumberType() ComplexNumberTypeBuilder {
	if cb, ok := b.childBuilder.(ComplexNumberTypeBuilder); ok {
		return cb
	}
	cb := NewComplexNumberTypeBuilder().(*_ComplexNumberTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsDoubleComplexNumberType() DoubleComplexNumberTypeBuilder {
	if cb, ok := b.childBuilder.(DoubleComplexNumberTypeBuilder); ok {
		return cb
	}
	cb := NewDoubleComplexNumberTypeBuilder().(*_DoubleComplexNumberTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAxisInformation() AxisInformationBuilder {
	if cb, ok := b.childBuilder.(AxisInformationBuilder); ok {
		return cb
	}
	cb := NewAxisInformationBuilder().(*_AxisInformationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsXVType() XVTypeBuilder {
	if cb, ok := b.childBuilder.(XVTypeBuilder); ok {
		return cb
	}
	cb := NewXVTypeBuilder().(*_XVTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsProgramDiagnosticDataType() ProgramDiagnosticDataTypeBuilder {
	if cb, ok := b.childBuilder.(ProgramDiagnosticDataTypeBuilder); ok {
		return cb
	}
	cb := NewProgramDiagnosticDataTypeBuilder().(*_ProgramDiagnosticDataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsProgramDiagnostic2DataType() ProgramDiagnostic2DataTypeBuilder {
	if cb, ok := b.childBuilder.(ProgramDiagnostic2DataTypeBuilder); ok {
		return cb
	}
	cb := NewProgramDiagnostic2DataTypeBuilder().(*_ProgramDiagnostic2DataTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) AsAnnotation() AnnotationBuilder {
	if cb, ok := b.childBuilder.(AnnotationBuilder); ok {
		return cb
	}
	cb := NewAnnotationBuilder().(*_AnnotationBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ExtensionObjectDefinitionBuilder) Build() (ExtensionObjectDefinition, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForExtensionObjectDefinition()
}

func (b *_ExtensionObjectDefinitionBuilder) MustBuild() ExtensionObjectDefinition {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ExtensionObjectDefinitionBuilder) DeepCopy() any {
	_copy := b.CreateExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_ExtensionObjectDefinitionChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateExtensionObjectDefinitionBuilder creates a ExtensionObjectDefinitionBuilder
func (b *_ExtensionObjectDefinition) CreateExtensionObjectDefinitionBuilder() ExtensionObjectDefinitionBuilder {
	if b == nil {
		return NewExtensionObjectDefinitionBuilder()
	}
	return &_ExtensionObjectDefinitionBuilder{_ExtensionObjectDefinition: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastExtensionObjectDefinition(structType any) ExtensionObjectDefinition {
	if casted, ok := structType.(ExtensionObjectDefinition); ok {
		return casted
	}
	if casted, ok := structType.(*ExtensionObjectDefinition); ok {
		return *casted
	}
	return nil
}

func (m *_ExtensionObjectDefinition) GetTypeName() string {
	return "ExtensionObjectDefinition"
}

func (m *_ExtensionObjectDefinition) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ExtensionObjectDefinition) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_ExtensionObjectDefinition) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func ExtensionObjectDefinitionParse[T ExtensionObjectDefinition](ctx context.Context, theBytes []byte, extensionId int32) (T, error) {
	return ExtensionObjectDefinitionParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), extensionId)
}

func ExtensionObjectDefinitionParseWithBufferProducer[T ExtensionObjectDefinition](extensionId int32) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := ExtensionObjectDefinitionParseWithBuffer[T](ctx, readBuffer, extensionId)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func ExtensionObjectDefinitionParseWithBuffer[T ExtensionObjectDefinition](ctx context.Context, readBuffer utils.ReadBuffer, extensionId int32) (T, error) {
	v, err := (&_ExtensionObjectDefinition{}).parse(ctx, readBuffer, extensionId)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_ExtensionObjectDefinition) parse(ctx context.Context, readBuffer utils.ReadBuffer, extensionId int32) (__extensionObjectDefinition ExtensionObjectDefinition, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ExtensionObjectDefinition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ExtensionObjectDefinition")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child ExtensionObjectDefinition
	switch {
	case extensionId == int32(0): // NullExtension
		if _child, err = new(_NullExtension).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NullExtension for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12758): // Union
		if _child, err = new(_Union).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type Union for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14535): // KeyValuePair
		if _child, err = new(_KeyValuePair).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type KeyValuePair for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(16315): // AdditionalParametersType
		if _child, err = new(_AdditionalParametersType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AdditionalParametersType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(17550): // EphemeralKeyType
		if _child, err = new(_EphemeralKeyType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EphemeralKeyType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15530): // EndpointType
		if _child, err = new(_EndpointType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EndpointType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32423): // BitFieldDefinition
		if _child, err = new(_BitFieldDefinition).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BitFieldDefinition for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18808): // RationalNumber
		if _child, err = new(_RationalNumber).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RationalNumber for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18809): // OpcuaVector
		if _child, err = new(_OpcuaVector).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type OpcuaVector for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18811): // CartesianCoordinates
		if _child, err = new(_CartesianCoordinates).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CartesianCoordinates for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18813): // Orientation
		if _child, err = new(_Orientation).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type Orientation for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18815): // Frame
		if _child, err = new(_Frame).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type Frame for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15636): // IdentityMappingRuleType
		if _child, err = new(_IdentityMappingRuleType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IdentityMappingRuleType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23500): // CurrencyUnitType
		if _child, err = new(_CurrencyUnitType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CurrencyUnitType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32436): // AnnotationDataType
		if _child, err = new(_AnnotationDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AnnotationDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32437): // LinearConversionDataType
		if _child, err = new(_LinearConversionDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LinearConversionDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32440): // QuantityDimension
		if _child, err = new(_QuantityDimension).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QuantityDimension for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12556): // TrustListDataType
		if _child, err = new(_TrustListDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TrustListDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15436): // BaseConfigurationDataType
		if _child, err = new(_BaseConfigurationDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BaseConfigurationDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15437): // BaseConfigurationRecordDataType
		if _child, err = new(_BaseConfigurationRecordDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BaseConfigurationRecordDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15438): // CertificateGroupDataType
		if _child, err = new(_CertificateGroupDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CertificateGroupDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15540): // ConfigurationUpdateTargetType
		if _child, err = new(_ConfigurationUpdateTargetType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ConfigurationUpdateTargetType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32287): // TransactionErrorType
		if _child, err = new(_TransactionErrorType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TransactionErrorType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15551): // ApplicationConfigurationDataType
		if _child, err = new(_ApplicationConfigurationDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ApplicationConfigurationDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15558): // ApplicationIdentityDataType
		if _child, err = new(_ApplicationIdentityDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ApplicationIdentityDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15559): // EndpointDataType
		if _child, err = new(_EndpointDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EndpointDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15560): // ServerEndpointDataType
		if _child, err = new(_ServerEndpointDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ServerEndpointDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15561): // SecuritySettingsDataType
		if _child, err = new(_SecuritySettingsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SecuritySettingsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15562): // UserTokenSettingsDataType
		if _child, err = new(_UserTokenSettingsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UserTokenSettingsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19447): // AuthorizationServiceConfigurationDataType
		if _child, err = new(_AuthorizationServiceConfigurationDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AuthorizationServiceConfigurationDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15536): // DataTypeSchemaHeader
		if _child, err = new(_DataTypeSchemaHeader).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataTypeSchemaHeader for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14527): // DataTypeDescription
		if _child, err = new(_DataTypeDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataTypeDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15489): // StructureDescription
		if _child, err = new(_StructureDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StructureDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15490): // EnumDescription
		if _child, err = new(_EnumDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EnumDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15007): // SimpleTypeDescription
		if _child, err = new(_SimpleTypeDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SimpleTypeDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15008): // UABinaryFileDataType
		if _child, err = new(_UABinaryFileDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UABinaryFileDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(24107): // PortableQualifiedName
		if _child, err = new(_PortableQualifiedName).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PortableQualifiedName for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(24108): // PortableNodeId
		if _child, err = new(_PortableNodeId).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PortableNodeId for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(24109): // UnsignedRationalNumber
		if _child, err = new(_UnsignedRationalNumber).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UnsignedRationalNumber for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14525): // DataSetMetaDataType
		if _child, err = new(_DataSetMetaDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetMetaDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14526): // FieldMetaData
		if _child, err = new(_FieldMetaData).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FieldMetaData for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14595): // ConfigurationVersionDataType
		if _child, err = new(_ConfigurationVersionDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ConfigurationVersionDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15580): // PublishedDataSetDataType
		if _child, err = new(_PublishedDataSetDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedDataSetDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15582): // PublishedDataSetSourceDataType
		if _child, err = new(_PublishedDataSetSourceDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedDataSetSourceDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14275): // PublishedVariableDataType
		if _child, err = new(_PublishedVariableDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedVariableDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15583): // PublishedDataItemsDataType
		if _child, err = new(_PublishedDataItemsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedDataItemsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15584): // PublishedEventsDataType
		if _child, err = new(_PublishedEventsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedEventsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(25271): // PublishedDataSetCustomSourceDataType
		if _child, err = new(_PublishedDataSetCustomSourceDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedDataSetCustomSourceDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18595): // ActionTargetDataType
		if _child, err = new(_ActionTargetDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ActionTargetDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18596): // PublishedActionDataType
		if _child, err = new(_PublishedActionDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedActionDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18599): // ActionMethodDataType
		if _child, err = new(_ActionMethodDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ActionMethodDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18795): // PublishedActionMethodDataType
		if _child, err = new(_PublishedActionMethodDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishedActionMethodDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15599): // DataSetWriterDataType
		if _child, err = new(_DataSetWriterDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetWriterDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15600): // DataSetWriterTransportDataType
		if _child, err = new(_DataSetWriterTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetWriterTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15607): // DataSetWriterMessageDataType
		if _child, err = new(_DataSetWriterMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetWriterMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15611): // PubSubGroupDataType
		if _child, err = new(_PubSubGroupDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubGroupDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15482): // WriterGroupDataType
		if _child, err = new(_WriterGroupDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type WriterGroupDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15613): // WriterGroupTransportDataType
		if _child, err = new(_WriterGroupTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type WriterGroupTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15618): // WriterGroupMessageDataType
		if _child, err = new(_WriterGroupMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type WriterGroupMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15619): // PubSubConnectionDataType
		if _child, err = new(_PubSubConnectionDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubConnectionDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15620): // ConnectionTransportDataType
		if _child, err = new(_ConnectionTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ConnectionTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15504): // NetworkAddressDataType
		if _child, err = new(_NetworkAddressDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NetworkAddressDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15512): // NetworkAddressUrlDataType
		if _child, err = new(_NetworkAddressUrlDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NetworkAddressUrlDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15522): // ReaderGroupDataType
		if _child, err = new(_ReaderGroupDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReaderGroupDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15623): // ReaderGroupTransportDataType
		if _child, err = new(_ReaderGroupTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReaderGroupTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15624): // ReaderGroupMessageDataType
		if _child, err = new(_ReaderGroupMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReaderGroupMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15625): // DataSetReaderDataType
		if _child, err = new(_DataSetReaderDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetReaderDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15630): // DataSetReaderTransportDataType
		if _child, err = new(_DataSetReaderTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetReaderTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15631): // DataSetReaderMessageDataType
		if _child, err = new(_DataSetReaderMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataSetReaderMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15632): // SubscribedDataSetDataType
		if _child, err = new(_SubscribedDataSetDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SubscribedDataSetDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15633): // TargetVariablesDataType
		if _child, err = new(_TargetVariablesDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TargetVariablesDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(14746): // FieldTargetDataType
		if _child, err = new(_FieldTargetDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FieldTargetDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15637): // SubscribedDataSetMirrorDataType
		if _child, err = new(_SubscribedDataSetMirrorDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SubscribedDataSetMirrorDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15532): // PubSubConfigurationDataType
		if _child, err = new(_PubSubConfigurationDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubConfigurationDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23601): // StandaloneSubscribedDataSetRefDataType
		if _child, err = new(_StandaloneSubscribedDataSetRefDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StandaloneSubscribedDataSetRefDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23602): // StandaloneSubscribedDataSetDataType
		if _child, err = new(_StandaloneSubscribedDataSetDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StandaloneSubscribedDataSetDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23603): // SecurityGroupDataType
		if _child, err = new(_SecurityGroupDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SecurityGroupDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(25272): // PubSubKeyPushTargetDataType
		if _child, err = new(_PubSubKeyPushTargetDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubKeyPushTargetDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23604): // PubSubConfiguration2DataType
		if _child, err = new(_PubSubConfiguration2DataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubConfiguration2DataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15647): // UadpWriterGroupMessageDataType
		if _child, err = new(_UadpWriterGroupMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UadpWriterGroupMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15654): // UadpDataSetWriterMessageDataType
		if _child, err = new(_UadpDataSetWriterMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UadpDataSetWriterMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15655): // UadpDataSetReaderMessageDataType
		if _child, err = new(_UadpDataSetReaderMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UadpDataSetReaderMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15659): // JsonWriterGroupMessageDataType
		if _child, err = new(_JsonWriterGroupMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonWriterGroupMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15666): // JsonDataSetWriterMessageDataType
		if _child, err = new(_JsonDataSetWriterMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonDataSetWriterMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15667): // JsonDataSetReaderMessageDataType
		if _child, err = new(_JsonDataSetReaderMessageDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonDataSetReaderMessageDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23605): // QosDataType
		if _child, err = new(_QosDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QosDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23606): // TransmitQosDataType
		if _child, err = new(_TransmitQosDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TransmitQosDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23607): // TransmitQosPriorityDataType
		if _child, err = new(_TransmitQosPriorityDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TransmitQosPriorityDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23610): // ReceiveQosDataType
		if _child, err = new(_ReceiveQosDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReceiveQosDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23611): // ReceiveQosPriorityDataType
		if _child, err = new(_ReceiveQosPriorityDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReceiveQosPriorityDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(17469): // DatagramConnectionTransportDataType
		if _child, err = new(_DatagramConnectionTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DatagramConnectionTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23614): // DatagramConnectionTransport2DataType
		if _child, err = new(_DatagramConnectionTransport2DataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DatagramConnectionTransport2DataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15534): // DatagramWriterGroupTransportDataType
		if _child, err = new(_DatagramWriterGroupTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DatagramWriterGroupTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23615): // DatagramWriterGroupTransport2DataType
		if _child, err = new(_DatagramWriterGroupTransport2DataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DatagramWriterGroupTransport2DataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23616): // DatagramDataSetReaderTransportDataType
		if _child, err = new(_DatagramDataSetReaderTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DatagramDataSetReaderTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18796): // DtlsPubSubConnectionDataType
		if _child, err = new(_DtlsPubSubConnectionDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DtlsPubSubConnectionDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15009): // BrokerConnectionTransportDataType
		if _child, err = new(_BrokerConnectionTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrokerConnectionTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15669): // BrokerWriterGroupTransportDataType
		if _child, err = new(_BrokerWriterGroupTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrokerWriterGroupTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15671): // BrokerDataSetWriterTransportDataType
		if _child, err = new(_BrokerDataSetWriterTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrokerDataSetWriterTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15672): // BrokerDataSetReaderTransportDataType
		if _child, err = new(_BrokerDataSetReaderTransportDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrokerDataSetReaderTransportDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(25521): // PubSubConfigurationRefDataType
		if _child, err = new(_PubSubConfigurationRefDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubConfigurationRefDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(25522): // PubSubConfigurationValueDataType
		if _child, err = new(_PubSubConfigurationValueDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PubSubConfigurationValueDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19313): // JsonNetworkMessage
		if _child, err = new(_JsonNetworkMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonNetworkMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19314): // JsonDataSetMessage
		if _child, err = new(_JsonDataSetMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonDataSetMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19315): // JsonDataSetMetaDataMessage
		if _child, err = new(_JsonDataSetMetaDataMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonDataSetMetaDataMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19316): // JsonApplicationDescriptionMessage
		if _child, err = new(_JsonApplicationDescriptionMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonApplicationDescriptionMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19317): // JsonServerEndpointsMessage
		if _child, err = new(_JsonServerEndpointsMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonServerEndpointsMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19318): // JsonStatusMessage
		if _child, err = new(_JsonStatusMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonStatusMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19319): // JsonPubSubConnectionMessage
		if _child, err = new(_JsonPubSubConnectionMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonPubSubConnectionMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19320): // JsonActionMetaDataMessage
		if _child, err = new(_JsonActionMetaDataMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonActionMetaDataMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19321): // JsonActionResponderMessage
		if _child, err = new(_JsonActionResponderMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonActionResponderMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19322): // JsonActionNetworkMessage
		if _child, err = new(_JsonActionNetworkMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonActionNetworkMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19323): // JsonActionRequestMessage
		if _child, err = new(_JsonActionRequestMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonActionRequestMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19324): // JsonActionResponseMessage
		if _child, err = new(_JsonActionResponseMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type JsonActionResponseMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23470): // AliasNameDataType
		if _child, err = new(_AliasNameDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AliasNameDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(24283): // UserManagementDataType
		if _child, err = new(_UserManagementDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UserManagementDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(25222): // PriorityMappingEntryType
		if _child, err = new(_PriorityMappingEntryType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PriorityMappingEntryType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18955): // LldpManagementAddressTxPortType
		if _child, err = new(_LldpManagementAddressTxPortType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LldpManagementAddressTxPortType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18956): // LldpManagementAddressType
		if _child, err = new(_LldpManagementAddressType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LldpManagementAddressType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18957): // LldpTlvType
		if _child, err = new(_LldpTlvType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LldpTlvType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32661): // ReferenceDescriptionDataType
		if _child, err = new(_ReferenceDescriptionDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReferenceDescriptionDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32662): // ReferenceListEntryDataType
		if _child, err = new(_ReferenceListEntryDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReferenceListEntryDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19363): // LogRecord
		if _child, err = new(_LogRecord).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LogRecord for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19747): // LogRecordsDataType
		if _child, err = new(_LogRecordsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LogRecordsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19748): // SpanContextDataType
		if _child, err = new(_SpanContextDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SpanContextDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19749): // TraceContextDataType
		if _child, err = new(_TraceContextDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TraceContextDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(19750): // NameValuePair
		if _child, err = new(_NameValuePair).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NameValuePair for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(98): // RolePermissionType
		if _child, err = new(_RolePermissionType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RolePermissionType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(99): // DataTypeDefinition
		if _child, err = new(_DataTypeDefinition).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataTypeDefinition for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(103): // StructureField
		if _child, err = new(_StructureField).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StructureField for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(101): // StructureDefinition
		if _child, err = new(_StructureDefinition).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StructureDefinition for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(102): // EnumDefinition
		if _child, err = new(_EnumDefinition).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EnumDefinition for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(298): // Argument
		if _child, err = new(_Argument).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type Argument for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(7596): // EnumValueType
		if _child, err = new(_EnumValueType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EnumValueType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(104): // EnumField
		if _child, err = new(_EnumField).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EnumField for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12757): // OptionSet
		if _child, err = new(_OptionSet).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type OptionSet for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(8914): // TimeZoneDataType
		if _child, err = new(_TimeZoneDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TimeZoneDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(310): // ApplicationDescription
		if _child, err = new(_ApplicationDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ApplicationDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(391): // RequestHeader
		if _child, err = new(_RequestHeader).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RequestHeader for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(394): // ResponseHeader
		if _child, err = new(_ResponseHeader).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ResponseHeader for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(397): // ServiceFault
		if _child, err = new(_ServiceFault).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ServiceFault for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(15903): // SessionlessInvokeRequestType
		if _child, err = new(_SessionlessInvokeRequestType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SessionlessInvokeRequestType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(21001): // SessionlessInvokeResponseType
		if _child, err = new(_SessionlessInvokeResponseType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SessionlessInvokeResponseType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(422): // FindServersRequest
		if _child, err = new(_FindServersRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FindServersRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(425): // FindServersResponse
		if _child, err = new(_FindServersResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FindServersResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12191): // ServerOnNetwork
		if _child, err = new(_ServerOnNetwork).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ServerOnNetwork for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12192): // FindServersOnNetworkRequest
		if _child, err = new(_FindServersOnNetworkRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FindServersOnNetworkRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12193): // FindServersOnNetworkResponse
		if _child, err = new(_FindServersOnNetworkResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FindServersOnNetworkResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(306): // UserTokenPolicy
		if _child, err = new(_UserTokenPolicy).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UserTokenPolicy for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(314): // EndpointDescription
		if _child, err = new(_EndpointDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EndpointDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(428): // GetEndpointsRequest
		if _child, err = new(_GetEndpointsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type GetEndpointsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(431): // GetEndpointsResponse
		if _child, err = new(_GetEndpointsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type GetEndpointsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(434): // RegisteredServer
		if _child, err = new(_RegisteredServer).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisteredServer for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(437): // RegisterServerRequest
		if _child, err = new(_RegisterServerRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisterServerRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(440): // RegisterServerResponse
		if _child, err = new(_RegisterServerResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisterServerResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12892): // DiscoveryConfiguration
		if _child, err = new(_DiscoveryConfiguration).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DiscoveryConfiguration for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12893): // MdnsDiscoveryConfiguration
		if _child, err = new(_MdnsDiscoveryConfiguration).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MdnsDiscoveryConfiguration for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12195): // RegisterServer2Request
		if _child, err = new(_RegisterServer2Request).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisterServer2Request for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12196): // RegisterServer2Response
		if _child, err = new(_RegisterServer2Response).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisterServer2Response for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(443): // ChannelSecurityToken
		if _child, err = new(_ChannelSecurityToken).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ChannelSecurityToken for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(446): // OpenSecureChannelRequest
		if _child, err = new(_OpenSecureChannelRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type OpenSecureChannelRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(449): // OpenSecureChannelResponse
		if _child, err = new(_OpenSecureChannelResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type OpenSecureChannelResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(452): // CloseSecureChannelRequest
		if _child, err = new(_CloseSecureChannelRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CloseSecureChannelRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(455): // CloseSecureChannelResponse
		if _child, err = new(_CloseSecureChannelResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CloseSecureChannelResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(346): // SignedSoftwareCertificate
		if _child, err = new(_SignedSoftwareCertificate).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SignedSoftwareCertificate for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(458): // SignatureData
		if _child, err = new(_SignatureData).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SignatureData for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(461): // CreateSessionRequest
		if _child, err = new(_CreateSessionRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CreateSessionRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(464): // CreateSessionResponse
		if _child, err = new(_CreateSessionResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CreateSessionResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(318): // UserIdentityToken
		if _child, err = new(_UserIdentityToken).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UserIdentityToken for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(321): // AnonymousIdentityToken
		if _child, err = new(_AnonymousIdentityToken).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AnonymousIdentityToken for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(324): // UserNameIdentityToken
		if _child, err = new(_UserNameIdentityToken).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UserNameIdentityToken for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(327): // X509IdentityToken
		if _child, err = new(_X509IdentityToken).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type X509IdentityToken for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(940): // IssuedIdentityToken
		if _child, err = new(_IssuedIdentityToken).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type IssuedIdentityToken for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(467): // ActivateSessionRequest
		if _child, err = new(_ActivateSessionRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ActivateSessionRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(470): // ActivateSessionResponse
		if _child, err = new(_ActivateSessionResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ActivateSessionResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(473): // CloseSessionRequest
		if _child, err = new(_CloseSessionRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CloseSessionRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(476): // CloseSessionResponse
		if _child, err = new(_CloseSessionResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CloseSessionResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(479): // CancelRequest
		if _child, err = new(_CancelRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CancelRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(482): // CancelResponse
		if _child, err = new(_CancelResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CancelResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(351): // NodeAttributes
		if _child, err = new(_NodeAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NodeAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(354): // ObjectAttributes
		if _child, err = new(_ObjectAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ObjectAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(357): // VariableAttributes
		if _child, err = new(_VariableAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type VariableAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(360): // MethodAttributes
		if _child, err = new(_MethodAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MethodAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(363): // ObjectTypeAttributes
		if _child, err = new(_ObjectTypeAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ObjectTypeAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(366): // VariableTypeAttributes
		if _child, err = new(_VariableTypeAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type VariableTypeAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(369): // ReferenceTypeAttributes
		if _child, err = new(_ReferenceTypeAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReferenceTypeAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(372): // DataTypeAttributes
		if _child, err = new(_DataTypeAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataTypeAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(375): // ViewAttributes
		if _child, err = new(_ViewAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ViewAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(17608): // GenericAttributeValue
		if _child, err = new(_GenericAttributeValue).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type GenericAttributeValue for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(17609): // GenericAttributes
		if _child, err = new(_GenericAttributes).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type GenericAttributes for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(378): // AddNodesItem
		if _child, err = new(_AddNodesItem).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddNodesItem for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(485): // AddNodesResult
		if _child, err = new(_AddNodesResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddNodesResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(488): // AddNodesRequest
		if _child, err = new(_AddNodesRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddNodesRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(491): // AddNodesResponse
		if _child, err = new(_AddNodesResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddNodesResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(381): // AddReferencesItem
		if _child, err = new(_AddReferencesItem).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddReferencesItem for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(494): // AddReferencesRequest
		if _child, err = new(_AddReferencesRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddReferencesRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(497): // AddReferencesResponse
		if _child, err = new(_AddReferencesResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AddReferencesResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(384): // DeleteNodesItem
		if _child, err = new(_DeleteNodesItem).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteNodesItem for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(500): // DeleteNodesRequest
		if _child, err = new(_DeleteNodesRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteNodesRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(503): // DeleteNodesResponse
		if _child, err = new(_DeleteNodesResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteNodesResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(387): // DeleteReferencesItem
		if _child, err = new(_DeleteReferencesItem).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteReferencesItem for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(506): // DeleteReferencesRequest
		if _child, err = new(_DeleteReferencesRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteReferencesRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(509): // DeleteReferencesResponse
		if _child, err = new(_DeleteReferencesResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteReferencesResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(513): // ViewDescription
		if _child, err = new(_ViewDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ViewDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(516): // BrowseDescription
		if _child, err = new(_BrowseDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowseDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(520): // ReferenceDescription
		if _child, err = new(_ReferenceDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReferenceDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(524): // BrowseResult
		if _child, err = new(_BrowseResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowseResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(527): // BrowseRequest
		if _child, err = new(_BrowseRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowseRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(530): // BrowseResponse
		if _child, err = new(_BrowseResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowseResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(533): // BrowseNextRequest
		if _child, err = new(_BrowseNextRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowseNextRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(536): // BrowseNextResponse
		if _child, err = new(_BrowseNextResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowseNextResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(539): // RelativePathElement
		if _child, err = new(_RelativePathElement).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RelativePathElement for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(542): // RelativePath
		if _child, err = new(_RelativePath).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RelativePath for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(545): // BrowsePath
		if _child, err = new(_BrowsePath).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowsePath for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(548): // BrowsePathTarget
		if _child, err = new(_BrowsePathTarget).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowsePathTarget for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(551): // BrowsePathResult
		if _child, err = new(_BrowsePathResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BrowsePathResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(554): // TranslateBrowsePathsToNodeIdsRequest
		if _child, err = new(_TranslateBrowsePathsToNodeIdsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TranslateBrowsePathsToNodeIdsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(557): // TranslateBrowsePathsToNodeIdsResponse
		if _child, err = new(_TranslateBrowsePathsToNodeIdsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TranslateBrowsePathsToNodeIdsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(560): // RegisterNodesRequest
		if _child, err = new(_RegisterNodesRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisterNodesRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(563): // RegisterNodesResponse
		if _child, err = new(_RegisterNodesResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RegisterNodesResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(566): // UnregisterNodesRequest
		if _child, err = new(_UnregisterNodesRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UnregisterNodesRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(569): // UnregisterNodesResponse
		if _child, err = new(_UnregisterNodesResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UnregisterNodesResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(333): // EndpointConfiguration
		if _child, err = new(_EndpointConfiguration).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EndpointConfiguration for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(572): // QueryDataDescription
		if _child, err = new(_QueryDataDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QueryDataDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(575): // NodeTypeDescription
		if _child, err = new(_NodeTypeDescription).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NodeTypeDescription for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(579): // QueryDataSet
		if _child, err = new(_QueryDataSet).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QueryDataSet for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(582): // NodeReference
		if _child, err = new(_NodeReference).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NodeReference for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(585): // ContentFilterElement
		if _child, err = new(_ContentFilterElement).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ContentFilterElement for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(588): // ContentFilter
		if _child, err = new(_ContentFilter).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ContentFilter for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(591): // FilterOperand
		if _child, err = new(_FilterOperand).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type FilterOperand for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(594): // ElementOperand
		if _child, err = new(_ElementOperand).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ElementOperand for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(597): // LiteralOperand
		if _child, err = new(_LiteralOperand).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type LiteralOperand for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(600): // AttributeOperand
		if _child, err = new(_AttributeOperand).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AttributeOperand for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(603): // SimpleAttributeOperand
		if _child, err = new(_SimpleAttributeOperand).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SimpleAttributeOperand for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(606): // ContentFilterElementResult
		if _child, err = new(_ContentFilterElementResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ContentFilterElementResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(609): // ContentFilterResult
		if _child, err = new(_ContentFilterResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ContentFilterResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(612): // ParsingResult
		if _child, err = new(_ParsingResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ParsingResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(615): // QueryFirstRequest
		if _child, err = new(_QueryFirstRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QueryFirstRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(618): // QueryFirstResponse
		if _child, err = new(_QueryFirstResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QueryFirstResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(621): // QueryNextRequest
		if _child, err = new(_QueryNextRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QueryNextRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(624): // QueryNextResponse
		if _child, err = new(_QueryNextResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type QueryNextResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(628): // ReadValueId
		if _child, err = new(_ReadValueId).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadValueId for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(631): // ReadRequest
		if _child, err = new(_ReadRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(634): // ReadResponse
		if _child, err = new(_ReadResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(637): // HistoryReadValueId
		if _child, err = new(_HistoryReadValueId).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryReadValueId for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(640): // HistoryReadResult
		if _child, err = new(_HistoryReadResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryReadResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(643): // HistoryReadDetails
		if _child, err = new(_HistoryReadDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryReadDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(646): // ReadEventDetails
		if _child, err = new(_ReadEventDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadEventDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32801): // ReadEventDetails2
		if _child, err = new(_ReadEventDetails2).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadEventDetails2 for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18650): // SortRuleElement
		if _child, err = new(_SortRuleElement).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SortRuleElement for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(18651): // ReadEventDetailsSorted
		if _child, err = new(_ReadEventDetailsSorted).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadEventDetailsSorted for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(649): // ReadRawModifiedDetails
		if _child, err = new(_ReadRawModifiedDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadRawModifiedDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(652): // ReadProcessedDetails
		if _child, err = new(_ReadProcessedDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadProcessedDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(655): // ReadAtTimeDetails
		if _child, err = new(_ReadAtTimeDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadAtTimeDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(23499): // ReadAnnotationDataDetails
		if _child, err = new(_ReadAnnotationDataDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ReadAnnotationDataDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(658): // HistoryData
		if _child, err = new(_HistoryData).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryData for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(11218): // ModificationInfo
		if _child, err = new(_ModificationInfo).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModificationInfo for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(11219): // HistoryModifiedData
		if _child, err = new(_HistoryModifiedData).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryModifiedData for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(661): // HistoryEvent
		if _child, err = new(_HistoryEvent).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryEvent for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(32826): // HistoryModifiedEvent
		if _child, err = new(_HistoryModifiedEvent).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryModifiedEvent for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(664): // HistoryReadRequest
		if _child, err = new(_HistoryReadRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryReadRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(667): // HistoryReadResponse
		if _child, err = new(_HistoryReadResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryReadResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(670): // WriteValue
		if _child, err = new(_WriteValue).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type WriteValue for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(673): // WriteRequest
		if _child, err = new(_WriteRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type WriteRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(676): // WriteResponse
		if _child, err = new(_WriteResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type WriteResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(679): // HistoryUpdateDetails
		if _child, err = new(_HistoryUpdateDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryUpdateDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(682): // UpdateDataDetails
		if _child, err = new(_UpdateDataDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UpdateDataDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(11297): // UpdateStructureDataDetails
		if _child, err = new(_UpdateStructureDataDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UpdateStructureDataDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(685): // UpdateEventDetails
		if _child, err = new(_UpdateEventDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type UpdateEventDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(688): // DeleteRawModifiedDetails
		if _child, err = new(_DeleteRawModifiedDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteRawModifiedDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(691): // DeleteAtTimeDetails
		if _child, err = new(_DeleteAtTimeDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteAtTimeDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(694): // DeleteEventDetails
		if _child, err = new(_DeleteEventDetails).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteEventDetails for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(697): // HistoryUpdateResult
		if _child, err = new(_HistoryUpdateResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryUpdateResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(700): // HistoryUpdateRequest
		if _child, err = new(_HistoryUpdateRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryUpdateRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(703): // HistoryUpdateResponse
		if _child, err = new(_HistoryUpdateResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryUpdateResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(706): // CallMethodRequest
		if _child, err = new(_CallMethodRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CallMethodRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(709): // CallMethodResult
		if _child, err = new(_CallMethodResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CallMethodResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(712): // CallRequest
		if _child, err = new(_CallRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CallRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(715): // CallResponse
		if _child, err = new(_CallResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CallResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(721): // MonitoringFilter
		if _child, err = new(_MonitoringFilter).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoringFilter for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(724): // DataChangeFilter
		if _child, err = new(_DataChangeFilter).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataChangeFilter for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(727): // EventFilter
		if _child, err = new(_EventFilter).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EventFilter for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(950): // AggregateConfiguration
		if _child, err = new(_AggregateConfiguration).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AggregateConfiguration for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(730): // AggregateFilter
		if _child, err = new(_AggregateFilter).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AggregateFilter for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(733): // MonitoringFilterResult
		if _child, err = new(_MonitoringFilterResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoringFilterResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(736): // EventFilterResult
		if _child, err = new(_EventFilterResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EventFilterResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(739): // AggregateFilterResult
		if _child, err = new(_AggregateFilterResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AggregateFilterResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(742): // MonitoringParameters
		if _child, err = new(_MonitoringParameters).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoringParameters for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(745): // MonitoredItemCreateRequest
		if _child, err = new(_MonitoredItemCreateRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredItemCreateRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(748): // MonitoredItemCreateResult
		if _child, err = new(_MonitoredItemCreateResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredItemCreateResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(751): // CreateMonitoredItemsRequest
		if _child, err = new(_CreateMonitoredItemsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CreateMonitoredItemsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(754): // CreateMonitoredItemsResponse
		if _child, err = new(_CreateMonitoredItemsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CreateMonitoredItemsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(757): // MonitoredItemModifyRequest
		if _child, err = new(_MonitoredItemModifyRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredItemModifyRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(760): // MonitoredItemModifyResult
		if _child, err = new(_MonitoredItemModifyResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredItemModifyResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(763): // ModifyMonitoredItemsRequest
		if _child, err = new(_ModifyMonitoredItemsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModifyMonitoredItemsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(766): // ModifyMonitoredItemsResponse
		if _child, err = new(_ModifyMonitoredItemsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModifyMonitoredItemsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(769): // SetMonitoringModeRequest
		if _child, err = new(_SetMonitoringModeRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SetMonitoringModeRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(772): // SetMonitoringModeResponse
		if _child, err = new(_SetMonitoringModeResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SetMonitoringModeResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(775): // SetTriggeringRequest
		if _child, err = new(_SetTriggeringRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SetTriggeringRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(778): // SetTriggeringResponse
		if _child, err = new(_SetTriggeringResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SetTriggeringResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(781): // DeleteMonitoredItemsRequest
		if _child, err = new(_DeleteMonitoredItemsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteMonitoredItemsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(784): // DeleteMonitoredItemsResponse
		if _child, err = new(_DeleteMonitoredItemsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteMonitoredItemsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(787): // CreateSubscriptionRequest
		if _child, err = new(_CreateSubscriptionRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CreateSubscriptionRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(790): // CreateSubscriptionResponse
		if _child, err = new(_CreateSubscriptionResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type CreateSubscriptionResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(793): // ModifySubscriptionRequest
		if _child, err = new(_ModifySubscriptionRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModifySubscriptionRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(796): // ModifySubscriptionResponse
		if _child, err = new(_ModifySubscriptionResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModifySubscriptionResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(799): // SetPublishingModeRequest
		if _child, err = new(_SetPublishingModeRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SetPublishingModeRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(802): // SetPublishingModeResponse
		if _child, err = new(_SetPublishingModeResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SetPublishingModeResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(805): // NotificationMessage
		if _child, err = new(_NotificationMessage).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NotificationMessage for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(947): // NotificationData
		if _child, err = new(_NotificationData).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NotificationData for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(811): // DataChangeNotification
		if _child, err = new(_DataChangeNotification).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DataChangeNotification for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(808): // MonitoredItemNotification
		if _child, err = new(_MonitoredItemNotification).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredItemNotification for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(916): // EventNotificationList
		if _child, err = new(_EventNotificationList).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EventNotificationList for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(919): // EventFieldList
		if _child, err = new(_EventFieldList).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EventFieldList for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(922): // HistoryEventFieldList
		if _child, err = new(_HistoryEventFieldList).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type HistoryEventFieldList for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(820): // StatusChangeNotification
		if _child, err = new(_StatusChangeNotification).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StatusChangeNotification for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(823): // SubscriptionAcknowledgement
		if _child, err = new(_SubscriptionAcknowledgement).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SubscriptionAcknowledgement for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(826): // PublishRequest
		if _child, err = new(_PublishRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(829): // PublishResponse
		if _child, err = new(_PublishResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type PublishResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(832): // RepublishRequest
		if _child, err = new(_RepublishRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RepublishRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(835): // RepublishResponse
		if _child, err = new(_RepublishResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RepublishResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(838): // TransferResult
		if _child, err = new(_TransferResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TransferResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(841): // TransferSubscriptionsRequest
		if _child, err = new(_TransferSubscriptionsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TransferSubscriptionsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(844): // TransferSubscriptionsResponse
		if _child, err = new(_TransferSubscriptionsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type TransferSubscriptionsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(847): // DeleteSubscriptionsRequest
		if _child, err = new(_DeleteSubscriptionsRequest).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteSubscriptionsRequest for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(850): // DeleteSubscriptionsResponse
		if _child, err = new(_DeleteSubscriptionsResponse).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DeleteSubscriptionsResponse for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(340): // BuildInfo
		if _child, err = new(_BuildInfo).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BuildInfo for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(855): // RedundantServerDataType
		if _child, err = new(_RedundantServerDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type RedundantServerDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(11945): // EndpointUrlListDataType
		if _child, err = new(_EndpointUrlListDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EndpointUrlListDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(11946): // NetworkGroupDataType
		if _child, err = new(_NetworkGroupDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type NetworkGroupDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(858): // SamplingIntervalDiagnosticsDataType
		if _child, err = new(_SamplingIntervalDiagnosticsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SamplingIntervalDiagnosticsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(861): // ServerDiagnosticsSummaryDataType
		if _child, err = new(_ServerDiagnosticsSummaryDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ServerDiagnosticsSummaryDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(864): // ServerStatusDataType
		if _child, err = new(_ServerStatusDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ServerStatusDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(867): // SessionDiagnosticsDataType
		if _child, err = new(_SessionDiagnosticsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SessionDiagnosticsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(870): // SessionSecurityDiagnosticsDataType
		if _child, err = new(_SessionSecurityDiagnosticsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SessionSecurityDiagnosticsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(873): // ServiceCounterDataType
		if _child, err = new(_ServiceCounterDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ServiceCounterDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(301): // StatusResult
		if _child, err = new(_StatusResult).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type StatusResult for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(876): // SubscriptionDiagnosticsDataType
		if _child, err = new(_SubscriptionDiagnosticsDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SubscriptionDiagnosticsDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(879): // ModelChangeStructureDataType
		if _child, err = new(_ModelChangeStructureDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModelChangeStructureDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(899): // SemanticChangeStructureDataType
		if _child, err = new(_SemanticChangeStructureDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type SemanticChangeStructureDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(886): // Range
		if _child, err = new(_Range).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type Range for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(889): // EUInformation
		if _child, err = new(_EUInformation).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type EUInformation for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12173): // ComplexNumberType
		if _child, err = new(_ComplexNumberType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ComplexNumberType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12174): // DoubleComplexNumberType
		if _child, err = new(_DoubleComplexNumberType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type DoubleComplexNumberType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12081): // AxisInformation
		if _child, err = new(_AxisInformation).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type AxisInformation for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(12082): // XVType
		if _child, err = new(_XVType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type XVType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(896): // ProgramDiagnosticDataType
		if _child, err = new(_ProgramDiagnosticDataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ProgramDiagnosticDataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(24035): // ProgramDiagnostic2DataType
		if _child, err = new(_ProgramDiagnostic2DataType).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ProgramDiagnostic2DataType for type-switch of ExtensionObjectDefinition")
		}
	case extensionId == int32(893): // Annotation
		if _child, err = new(_Annotation).parse(ctx, readBuffer, m, extensionId); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type Annotation for type-switch of ExtensionObjectDefinition")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [extensionId=%v]", extensionId)
	}

	if closeErr := readBuffer.CloseContext("ExtensionObjectDefinition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ExtensionObjectDefinition")
	}

	return _child, nil
}

func (pm *_ExtensionObjectDefinition) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ExtensionObjectDefinition, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ExtensionObjectDefinition"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ExtensionObjectDefinition")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("ExtensionObjectDefinition"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ExtensionObjectDefinition")
	}
	return nil
}

func (m *_ExtensionObjectDefinition) IsExtensionObjectDefinition() {}

func (m *_ExtensionObjectDefinition) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ExtensionObjectDefinition) deepCopy() *_ExtensionObjectDefinition {
	if m == nil {
		return nil
	}
	_ExtensionObjectDefinitionCopy := &_ExtensionObjectDefinition{
		nil, // will be set by child
	}
	return _ExtensionObjectDefinitionCopy
}
