/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DeleteNodesItem is the corresponding interface of DeleteNodesItem
type DeleteNodesItem interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNodeId returns NodeId (property field)
	GetNodeId() NodeId
	// GetDeleteTargetReferences returns DeleteTargetReferences (property field)
	GetDeleteTargetReferences() bool
	// IsDeleteNodesItem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDeleteNodesItem()
	// CreateBuilder creates a DeleteNodesItemBuilder
	CreateDeleteNodesItemBuilder() DeleteNodesItemBuilder
}

// _DeleteNodesItem is the data-structure of this message
type _DeleteNodesItem struct {
	ExtensionObjectDefinitionContract
	NodeId                 NodeId
	DeleteTargetReferences bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ DeleteNodesItem = (*_DeleteNodesItem)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DeleteNodesItem)(nil)

// NewDeleteNodesItem factory function for _DeleteNodesItem
func NewDeleteNodesItem(nodeId NodeId, deleteTargetReferences bool) *_DeleteNodesItem {
	if nodeId == nil {
		panic("nodeId of type NodeId for DeleteNodesItem must not be nil")
	}
	_result := &_DeleteNodesItem{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		NodeId:                            nodeId,
		DeleteTargetReferences:            deleteTargetReferences,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DeleteNodesItemBuilder is a builder for DeleteNodesItem
type DeleteNodesItemBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(nodeId NodeId, deleteTargetReferences bool) DeleteNodesItemBuilder
	// WithNodeId adds NodeId (property field)
	WithNodeId(NodeId) DeleteNodesItemBuilder
	// WithNodeIdBuilder adds NodeId (property field) which is build by the builder
	WithNodeIdBuilder(func(NodeIdBuilder) NodeIdBuilder) DeleteNodesItemBuilder
	// WithDeleteTargetReferences adds DeleteTargetReferences (property field)
	WithDeleteTargetReferences(bool) DeleteNodesItemBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DeleteNodesItem or returns an error if something is wrong
	Build() (DeleteNodesItem, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DeleteNodesItem
}

// NewDeleteNodesItemBuilder() creates a DeleteNodesItemBuilder
func NewDeleteNodesItemBuilder() DeleteNodesItemBuilder {
	return &_DeleteNodesItemBuilder{_DeleteNodesItem: new(_DeleteNodesItem)}
}

type _DeleteNodesItemBuilder struct {
	*_DeleteNodesItem

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (DeleteNodesItemBuilder) = (*_DeleteNodesItemBuilder)(nil)

func (b *_DeleteNodesItemBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DeleteNodesItem
}

func (b *_DeleteNodesItemBuilder) WithMandatoryFields(nodeId NodeId, deleteTargetReferences bool) DeleteNodesItemBuilder {
	return b.WithNodeId(nodeId).WithDeleteTargetReferences(deleteTargetReferences)
}

func (b *_DeleteNodesItemBuilder) WithNodeId(nodeId NodeId) DeleteNodesItemBuilder {
	b.NodeId = nodeId
	return b
}

func (b *_DeleteNodesItemBuilder) WithNodeIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) DeleteNodesItemBuilder {
	builder := builderSupplier(b.NodeId.CreateNodeIdBuilder())
	var err error
	b.NodeId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_DeleteNodesItemBuilder) WithDeleteTargetReferences(deleteTargetReferences bool) DeleteNodesItemBuilder {
	b.DeleteTargetReferences = deleteTargetReferences
	return b
}

func (b *_DeleteNodesItemBuilder) Build() (DeleteNodesItem, error) {
	if b.NodeId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'nodeId' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._DeleteNodesItem.deepCopy(), nil
}

func (b *_DeleteNodesItemBuilder) MustBuild() DeleteNodesItem {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DeleteNodesItemBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DeleteNodesItemBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DeleteNodesItemBuilder) DeepCopy() any {
	_copy := b.CreateDeleteNodesItemBuilder().(*_DeleteNodesItemBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateDeleteNodesItemBuilder creates a DeleteNodesItemBuilder
func (b *_DeleteNodesItem) CreateDeleteNodesItemBuilder() DeleteNodesItemBuilder {
	if b == nil {
		return NewDeleteNodesItemBuilder()
	}
	return &_DeleteNodesItemBuilder{_DeleteNodesItem: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DeleteNodesItem) GetExtensionId() int32 {
	return int32(384)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DeleteNodesItem) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DeleteNodesItem) GetNodeId() NodeId {
	return m.NodeId
}

func (m *_DeleteNodesItem) GetDeleteTargetReferences() bool {
	return m.DeleteTargetReferences
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDeleteNodesItem(structType any) DeleteNodesItem {
	if casted, ok := structType.(DeleteNodesItem); ok {
		return casted
	}
	if casted, ok := structType.(*DeleteNodesItem); ok {
		return *casted
	}
	return nil
}

func (m *_DeleteNodesItem) GetTypeName() string {
	return "DeleteNodesItem"
}

func (m *_DeleteNodesItem) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (nodeId)
	lengthInBits += m.NodeId.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (deleteTargetReferences)
	lengthInBits += 1

	return lengthInBits
}

func (m *_DeleteNodesItem) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DeleteNodesItem) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__deleteNodesItem DeleteNodesItem, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DeleteNodesItem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DeleteNodesItem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	nodeId, err := ReadSimpleField[NodeId](ctx, "nodeId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nodeId' field"))
	}
	m.NodeId = nodeId

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	deleteTargetReferences, err := ReadSimpleField(ctx, "deleteTargetReferences", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deleteTargetReferences' field"))
	}
	m.DeleteTargetReferences = deleteTargetReferences

	if closeErr := readBuffer.CloseContext("DeleteNodesItem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DeleteNodesItem")
	}

	return m, nil
}

func (m *_DeleteNodesItem) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DeleteNodesItem) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DeleteNodesItem"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DeleteNodesItem")
		}

		if err := WriteSimpleField[NodeId](ctx, "nodeId", m.GetNodeId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'nodeId' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "deleteTargetReferences", m.GetDeleteTargetReferences(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deleteTargetReferences' field")
		}

		if popErr := writeBuffer.PopContext("DeleteNodesItem"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DeleteNodesItem")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DeleteNodesItem) IsDeleteNodesItem() {}

func (m *_DeleteNodesItem) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DeleteNodesItem) deepCopy() *_DeleteNodesItem {
	if m == nil {
		return nil
	}
	_DeleteNodesItemCopy := &_DeleteNodesItem{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.NodeId),
		m.DeleteTargetReferences,
		m.reservedField0,
	}
	_DeleteNodesItemCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DeleteNodesItemCopy
}

func (m *_DeleteNodesItem) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
