/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BrokerWriterGroupTransportDataType is the corresponding interface of BrokerWriterGroupTransportDataType
type BrokerWriterGroupTransportDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetQueueName returns QueueName (property field)
	GetQueueName() PascalString
	// GetResourceUri returns ResourceUri (property field)
	GetResourceUri() PascalString
	// GetAuthenticationProfileUri returns AuthenticationProfileUri (property field)
	GetAuthenticationProfileUri() PascalString
	// GetRequestedDeliveryGuarantee returns RequestedDeliveryGuarantee (property field)
	GetRequestedDeliveryGuarantee() BrokerTransportQualityOfService
	// IsBrokerWriterGroupTransportDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBrokerWriterGroupTransportDataType()
	// CreateBuilder creates a BrokerWriterGroupTransportDataTypeBuilder
	CreateBrokerWriterGroupTransportDataTypeBuilder() BrokerWriterGroupTransportDataTypeBuilder
}

// _BrokerWriterGroupTransportDataType is the data-structure of this message
type _BrokerWriterGroupTransportDataType struct {
	ExtensionObjectDefinitionContract
	QueueName                  PascalString
	ResourceUri                PascalString
	AuthenticationProfileUri   PascalString
	RequestedDeliveryGuarantee BrokerTransportQualityOfService
}

var _ BrokerWriterGroupTransportDataType = (*_BrokerWriterGroupTransportDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_BrokerWriterGroupTransportDataType)(nil)

// NewBrokerWriterGroupTransportDataType factory function for _BrokerWriterGroupTransportDataType
func NewBrokerWriterGroupTransportDataType(queueName PascalString, resourceUri PascalString, authenticationProfileUri PascalString, requestedDeliveryGuarantee BrokerTransportQualityOfService) *_BrokerWriterGroupTransportDataType {
	if queueName == nil {
		panic("queueName of type PascalString for BrokerWriterGroupTransportDataType must not be nil")
	}
	if resourceUri == nil {
		panic("resourceUri of type PascalString for BrokerWriterGroupTransportDataType must not be nil")
	}
	if authenticationProfileUri == nil {
		panic("authenticationProfileUri of type PascalString for BrokerWriterGroupTransportDataType must not be nil")
	}
	_result := &_BrokerWriterGroupTransportDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		QueueName:                         queueName,
		ResourceUri:                       resourceUri,
		AuthenticationProfileUri:          authenticationProfileUri,
		RequestedDeliveryGuarantee:        requestedDeliveryGuarantee,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BrokerWriterGroupTransportDataTypeBuilder is a builder for BrokerWriterGroupTransportDataType
type BrokerWriterGroupTransportDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(queueName PascalString, resourceUri PascalString, authenticationProfileUri PascalString, requestedDeliveryGuarantee BrokerTransportQualityOfService) BrokerWriterGroupTransportDataTypeBuilder
	// WithQueueName adds QueueName (property field)
	WithQueueName(PascalString) BrokerWriterGroupTransportDataTypeBuilder
	// WithQueueNameBuilder adds QueueName (property field) which is build by the builder
	WithQueueNameBuilder(func(PascalStringBuilder) PascalStringBuilder) BrokerWriterGroupTransportDataTypeBuilder
	// WithResourceUri adds ResourceUri (property field)
	WithResourceUri(PascalString) BrokerWriterGroupTransportDataTypeBuilder
	// WithResourceUriBuilder adds ResourceUri (property field) which is build by the builder
	WithResourceUriBuilder(func(PascalStringBuilder) PascalStringBuilder) BrokerWriterGroupTransportDataTypeBuilder
	// WithAuthenticationProfileUri adds AuthenticationProfileUri (property field)
	WithAuthenticationProfileUri(PascalString) BrokerWriterGroupTransportDataTypeBuilder
	// WithAuthenticationProfileUriBuilder adds AuthenticationProfileUri (property field) which is build by the builder
	WithAuthenticationProfileUriBuilder(func(PascalStringBuilder) PascalStringBuilder) BrokerWriterGroupTransportDataTypeBuilder
	// WithRequestedDeliveryGuarantee adds RequestedDeliveryGuarantee (property field)
	WithRequestedDeliveryGuarantee(BrokerTransportQualityOfService) BrokerWriterGroupTransportDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the BrokerWriterGroupTransportDataType or returns an error if something is wrong
	Build() (BrokerWriterGroupTransportDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BrokerWriterGroupTransportDataType
}

// NewBrokerWriterGroupTransportDataTypeBuilder() creates a BrokerWriterGroupTransportDataTypeBuilder
func NewBrokerWriterGroupTransportDataTypeBuilder() BrokerWriterGroupTransportDataTypeBuilder {
	return &_BrokerWriterGroupTransportDataTypeBuilder{_BrokerWriterGroupTransportDataType: new(_BrokerWriterGroupTransportDataType)}
}

type _BrokerWriterGroupTransportDataTypeBuilder struct {
	*_BrokerWriterGroupTransportDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (BrokerWriterGroupTransportDataTypeBuilder) = (*_BrokerWriterGroupTransportDataTypeBuilder)(nil)

func (b *_BrokerWriterGroupTransportDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._BrokerWriterGroupTransportDataType
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithMandatoryFields(queueName PascalString, resourceUri PascalString, authenticationProfileUri PascalString, requestedDeliveryGuarantee BrokerTransportQualityOfService) BrokerWriterGroupTransportDataTypeBuilder {
	return b.WithQueueName(queueName).WithResourceUri(resourceUri).WithAuthenticationProfileUri(authenticationProfileUri).WithRequestedDeliveryGuarantee(requestedDeliveryGuarantee)
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithQueueName(queueName PascalString) BrokerWriterGroupTransportDataTypeBuilder {
	b.QueueName = queueName
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithQueueNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) BrokerWriterGroupTransportDataTypeBuilder {
	builder := builderSupplier(b.QueueName.CreatePascalStringBuilder())
	var err error
	b.QueueName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithResourceUri(resourceUri PascalString) BrokerWriterGroupTransportDataTypeBuilder {
	b.ResourceUri = resourceUri
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithResourceUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) BrokerWriterGroupTransportDataTypeBuilder {
	builder := builderSupplier(b.ResourceUri.CreatePascalStringBuilder())
	var err error
	b.ResourceUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithAuthenticationProfileUri(authenticationProfileUri PascalString) BrokerWriterGroupTransportDataTypeBuilder {
	b.AuthenticationProfileUri = authenticationProfileUri
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithAuthenticationProfileUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) BrokerWriterGroupTransportDataTypeBuilder {
	builder := builderSupplier(b.AuthenticationProfileUri.CreatePascalStringBuilder())
	var err error
	b.AuthenticationProfileUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) WithRequestedDeliveryGuarantee(requestedDeliveryGuarantee BrokerTransportQualityOfService) BrokerWriterGroupTransportDataTypeBuilder {
	b.RequestedDeliveryGuarantee = requestedDeliveryGuarantee
	return b
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) Build() (BrokerWriterGroupTransportDataType, error) {
	if b.QueueName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'queueName' not set"))
	}
	if b.ResourceUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'resourceUri' not set"))
	}
	if b.AuthenticationProfileUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'authenticationProfileUri' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BrokerWriterGroupTransportDataType.deepCopy(), nil
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) MustBuild() BrokerWriterGroupTransportDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_BrokerWriterGroupTransportDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateBrokerWriterGroupTransportDataTypeBuilder().(*_BrokerWriterGroupTransportDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBrokerWriterGroupTransportDataTypeBuilder creates a BrokerWriterGroupTransportDataTypeBuilder
func (b *_BrokerWriterGroupTransportDataType) CreateBrokerWriterGroupTransportDataTypeBuilder() BrokerWriterGroupTransportDataTypeBuilder {
	if b == nil {
		return NewBrokerWriterGroupTransportDataTypeBuilder()
	}
	return &_BrokerWriterGroupTransportDataTypeBuilder{_BrokerWriterGroupTransportDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BrokerWriterGroupTransportDataType) GetExtensionId() int32 {
	return int32(15669)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BrokerWriterGroupTransportDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BrokerWriterGroupTransportDataType) GetQueueName() PascalString {
	return m.QueueName
}

func (m *_BrokerWriterGroupTransportDataType) GetResourceUri() PascalString {
	return m.ResourceUri
}

func (m *_BrokerWriterGroupTransportDataType) GetAuthenticationProfileUri() PascalString {
	return m.AuthenticationProfileUri
}

func (m *_BrokerWriterGroupTransportDataType) GetRequestedDeliveryGuarantee() BrokerTransportQualityOfService {
	return m.RequestedDeliveryGuarantee
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBrokerWriterGroupTransportDataType(structType any) BrokerWriterGroupTransportDataType {
	if casted, ok := structType.(BrokerWriterGroupTransportDataType); ok {
		return casted
	}
	if casted, ok := structType.(*BrokerWriterGroupTransportDataType); ok {
		return *casted
	}
	return nil
}

func (m *_BrokerWriterGroupTransportDataType) GetTypeName() string {
	return "BrokerWriterGroupTransportDataType"
}

func (m *_BrokerWriterGroupTransportDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (queueName)
	lengthInBits += m.QueueName.GetLengthInBits(ctx)

	// Simple field (resourceUri)
	lengthInBits += m.ResourceUri.GetLengthInBits(ctx)

	// Simple field (authenticationProfileUri)
	lengthInBits += m.AuthenticationProfileUri.GetLengthInBits(ctx)

	// Simple field (requestedDeliveryGuarantee)
	lengthInBits += 32

	return lengthInBits
}

func (m *_BrokerWriterGroupTransportDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BrokerWriterGroupTransportDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__brokerWriterGroupTransportDataType BrokerWriterGroupTransportDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BrokerWriterGroupTransportDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BrokerWriterGroupTransportDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	queueName, err := ReadSimpleField[PascalString](ctx, "queueName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'queueName' field"))
	}
	m.QueueName = queueName

	resourceUri, err := ReadSimpleField[PascalString](ctx, "resourceUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'resourceUri' field"))
	}
	m.ResourceUri = resourceUri

	authenticationProfileUri, err := ReadSimpleField[PascalString](ctx, "authenticationProfileUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authenticationProfileUri' field"))
	}
	m.AuthenticationProfileUri = authenticationProfileUri

	requestedDeliveryGuarantee, err := ReadEnumField[BrokerTransportQualityOfService](ctx, "requestedDeliveryGuarantee", "BrokerTransportQualityOfService", ReadEnum(BrokerTransportQualityOfServiceByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestedDeliveryGuarantee' field"))
	}
	m.RequestedDeliveryGuarantee = requestedDeliveryGuarantee

	if closeErr := readBuffer.CloseContext("BrokerWriterGroupTransportDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BrokerWriterGroupTransportDataType")
	}

	return m, nil
}

func (m *_BrokerWriterGroupTransportDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BrokerWriterGroupTransportDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BrokerWriterGroupTransportDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BrokerWriterGroupTransportDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "queueName", m.GetQueueName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'queueName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "resourceUri", m.GetResourceUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'resourceUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "authenticationProfileUri", m.GetAuthenticationProfileUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'authenticationProfileUri' field")
		}

		if err := WriteSimpleEnumField[BrokerTransportQualityOfService](ctx, "requestedDeliveryGuarantee", "BrokerTransportQualityOfService", m.GetRequestedDeliveryGuarantee(), WriteEnum[BrokerTransportQualityOfService, uint32](BrokerTransportQualityOfService.GetValue, BrokerTransportQualityOfService.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'requestedDeliveryGuarantee' field")
		}

		if popErr := writeBuffer.PopContext("BrokerWriterGroupTransportDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BrokerWriterGroupTransportDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BrokerWriterGroupTransportDataType) IsBrokerWriterGroupTransportDataType() {}

func (m *_BrokerWriterGroupTransportDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BrokerWriterGroupTransportDataType) deepCopy() *_BrokerWriterGroupTransportDataType {
	if m == nil {
		return nil
	}
	_BrokerWriterGroupTransportDataTypeCopy := &_BrokerWriterGroupTransportDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.QueueName),
		utils.DeepCopy[PascalString](m.ResourceUri),
		utils.DeepCopy[PascalString](m.AuthenticationProfileUri),
		m.RequestedDeliveryGuarantee,
	}
	_BrokerWriterGroupTransportDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _BrokerWriterGroupTransportDataTypeCopy
}

func (m *_BrokerWriterGroupTransportDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
