/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AuthorizationServiceConfigurationDataType is the corresponding interface of AuthorizationServiceConfigurationDataType
type AuthorizationServiceConfigurationDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetRecordProperties returns RecordProperties (property field)
	GetRecordProperties() []KeyValuePair
	// GetServiceUri returns ServiceUri (property field)
	GetServiceUri() PascalString
	// GetServiceCertificate returns ServiceCertificate (property field)
	GetServiceCertificate() []PascalByteString
	// GetIssuerEndpointSettings returns IssuerEndpointSettings (property field)
	GetIssuerEndpointSettings() PascalString
	// IsAuthorizationServiceConfigurationDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAuthorizationServiceConfigurationDataType()
	// CreateBuilder creates a AuthorizationServiceConfigurationDataTypeBuilder
	CreateAuthorizationServiceConfigurationDataTypeBuilder() AuthorizationServiceConfigurationDataTypeBuilder
}

// _AuthorizationServiceConfigurationDataType is the data-structure of this message
type _AuthorizationServiceConfigurationDataType struct {
	ExtensionObjectDefinitionContract
	Name                   PascalString
	RecordProperties       []KeyValuePair
	ServiceUri             PascalString
	ServiceCertificate     []PascalByteString
	IssuerEndpointSettings PascalString
}

var _ AuthorizationServiceConfigurationDataType = (*_AuthorizationServiceConfigurationDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_AuthorizationServiceConfigurationDataType)(nil)

// NewAuthorizationServiceConfigurationDataType factory function for _AuthorizationServiceConfigurationDataType
func NewAuthorizationServiceConfigurationDataType(name PascalString, recordProperties []KeyValuePair, serviceUri PascalString, serviceCertificate []PascalByteString, issuerEndpointSettings PascalString) *_AuthorizationServiceConfigurationDataType {
	if name == nil {
		panic("name of type PascalString for AuthorizationServiceConfigurationDataType must not be nil")
	}
	if serviceUri == nil {
		panic("serviceUri of type PascalString for AuthorizationServiceConfigurationDataType must not be nil")
	}
	if issuerEndpointSettings == nil {
		panic("issuerEndpointSettings of type PascalString for AuthorizationServiceConfigurationDataType must not be nil")
	}
	_result := &_AuthorizationServiceConfigurationDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		RecordProperties:                  recordProperties,
		ServiceUri:                        serviceUri,
		ServiceCertificate:                serviceCertificate,
		IssuerEndpointSettings:            issuerEndpointSettings,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AuthorizationServiceConfigurationDataTypeBuilder is a builder for AuthorizationServiceConfigurationDataType
type AuthorizationServiceConfigurationDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, serviceUri PascalString, serviceCertificate []PascalByteString, issuerEndpointSettings PascalString) AuthorizationServiceConfigurationDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) AuthorizationServiceConfigurationDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) AuthorizationServiceConfigurationDataTypeBuilder
	// WithRecordProperties adds RecordProperties (property field)
	WithRecordProperties(...KeyValuePair) AuthorizationServiceConfigurationDataTypeBuilder
	// WithServiceUri adds ServiceUri (property field)
	WithServiceUri(PascalString) AuthorizationServiceConfigurationDataTypeBuilder
	// WithServiceUriBuilder adds ServiceUri (property field) which is build by the builder
	WithServiceUriBuilder(func(PascalStringBuilder) PascalStringBuilder) AuthorizationServiceConfigurationDataTypeBuilder
	// WithServiceCertificate adds ServiceCertificate (property field)
	WithServiceCertificate(...PascalByteString) AuthorizationServiceConfigurationDataTypeBuilder
	// WithIssuerEndpointSettings adds IssuerEndpointSettings (property field)
	WithIssuerEndpointSettings(PascalString) AuthorizationServiceConfigurationDataTypeBuilder
	// WithIssuerEndpointSettingsBuilder adds IssuerEndpointSettings (property field) which is build by the builder
	WithIssuerEndpointSettingsBuilder(func(PascalStringBuilder) PascalStringBuilder) AuthorizationServiceConfigurationDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the AuthorizationServiceConfigurationDataType or returns an error if something is wrong
	Build() (AuthorizationServiceConfigurationDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AuthorizationServiceConfigurationDataType
}

// NewAuthorizationServiceConfigurationDataTypeBuilder() creates a AuthorizationServiceConfigurationDataTypeBuilder
func NewAuthorizationServiceConfigurationDataTypeBuilder() AuthorizationServiceConfigurationDataTypeBuilder {
	return &_AuthorizationServiceConfigurationDataTypeBuilder{_AuthorizationServiceConfigurationDataType: new(_AuthorizationServiceConfigurationDataType)}
}

type _AuthorizationServiceConfigurationDataTypeBuilder struct {
	*_AuthorizationServiceConfigurationDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (AuthorizationServiceConfigurationDataTypeBuilder) = (*_AuthorizationServiceConfigurationDataTypeBuilder)(nil)

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._AuthorizationServiceConfigurationDataType
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, serviceUri PascalString, serviceCertificate []PascalByteString, issuerEndpointSettings PascalString) AuthorizationServiceConfigurationDataTypeBuilder {
	return b.WithName(name).WithRecordProperties(recordProperties...).WithServiceUri(serviceUri).WithServiceCertificate(serviceCertificate...).WithIssuerEndpointSettings(issuerEndpointSettings)
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithName(name PascalString) AuthorizationServiceConfigurationDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) AuthorizationServiceConfigurationDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithRecordProperties(recordProperties ...KeyValuePair) AuthorizationServiceConfigurationDataTypeBuilder {
	b.RecordProperties = recordProperties
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithServiceUri(serviceUri PascalString) AuthorizationServiceConfigurationDataTypeBuilder {
	b.ServiceUri = serviceUri
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithServiceUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) AuthorizationServiceConfigurationDataTypeBuilder {
	builder := builderSupplier(b.ServiceUri.CreatePascalStringBuilder())
	var err error
	b.ServiceUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithServiceCertificate(serviceCertificate ...PascalByteString) AuthorizationServiceConfigurationDataTypeBuilder {
	b.ServiceCertificate = serviceCertificate
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithIssuerEndpointSettings(issuerEndpointSettings PascalString) AuthorizationServiceConfigurationDataTypeBuilder {
	b.IssuerEndpointSettings = issuerEndpointSettings
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) WithIssuerEndpointSettingsBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) AuthorizationServiceConfigurationDataTypeBuilder {
	builder := builderSupplier(b.IssuerEndpointSettings.CreatePascalStringBuilder())
	var err error
	b.IssuerEndpointSettings, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) Build() (AuthorizationServiceConfigurationDataType, error) {
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.ServiceUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'serviceUri' not set"))
	}
	if b.IssuerEndpointSettings == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'issuerEndpointSettings' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AuthorizationServiceConfigurationDataType.deepCopy(), nil
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) MustBuild() AuthorizationServiceConfigurationDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_AuthorizationServiceConfigurationDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateAuthorizationServiceConfigurationDataTypeBuilder().(*_AuthorizationServiceConfigurationDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAuthorizationServiceConfigurationDataTypeBuilder creates a AuthorizationServiceConfigurationDataTypeBuilder
func (b *_AuthorizationServiceConfigurationDataType) CreateAuthorizationServiceConfigurationDataTypeBuilder() AuthorizationServiceConfigurationDataTypeBuilder {
	if b == nil {
		return NewAuthorizationServiceConfigurationDataTypeBuilder()
	}
	return &_AuthorizationServiceConfigurationDataTypeBuilder{_AuthorizationServiceConfigurationDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AuthorizationServiceConfigurationDataType) GetExtensionId() int32 {
	return int32(19447)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AuthorizationServiceConfigurationDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AuthorizationServiceConfigurationDataType) GetName() PascalString {
	return m.Name
}

func (m *_AuthorizationServiceConfigurationDataType) GetRecordProperties() []KeyValuePair {
	return m.RecordProperties
}

func (m *_AuthorizationServiceConfigurationDataType) GetServiceUri() PascalString {
	return m.ServiceUri
}

func (m *_AuthorizationServiceConfigurationDataType) GetServiceCertificate() []PascalByteString {
	return m.ServiceCertificate
}

func (m *_AuthorizationServiceConfigurationDataType) GetIssuerEndpointSettings() PascalString {
	return m.IssuerEndpointSettings
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAuthorizationServiceConfigurationDataType(structType any) AuthorizationServiceConfigurationDataType {
	if casted, ok := structType.(AuthorizationServiceConfigurationDataType); ok {
		return casted
	}
	if casted, ok := structType.(*AuthorizationServiceConfigurationDataType); ok {
		return *casted
	}
	return nil
}

func (m *_AuthorizationServiceConfigurationDataType) GetTypeName() string {
	return "AuthorizationServiceConfigurationDataType"
}

func (m *_AuthorizationServiceConfigurationDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Implicit Field (noOfRecordProperties)
	lengthInBits += 32

	// Array field
	if len(m.RecordProperties) > 0 {
		for _curItem, element := range m.RecordProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.RecordProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (serviceUri)
	lengthInBits += m.ServiceUri.GetLengthInBits(ctx)

	// Implicit Field (noOfServiceCertificate)
	lengthInBits += 32

	// Array field
	if len(m.ServiceCertificate) > 0 {
		for _curItem, element := range m.ServiceCertificate {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServiceCertificate), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (issuerEndpointSettings)
	lengthInBits += m.IssuerEndpointSettings.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AuthorizationServiceConfigurationDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AuthorizationServiceConfigurationDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__authorizationServiceConfigurationDataType AuthorizationServiceConfigurationDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AuthorizationServiceConfigurationDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AuthorizationServiceConfigurationDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	noOfRecordProperties, err := ReadImplicitField[int32](ctx, "noOfRecordProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfRecordProperties' field"))
	}
	_ = noOfRecordProperties

	recordProperties, err := ReadCountArrayField[KeyValuePair](ctx, "recordProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfRecordProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recordProperties' field"))
	}
	m.RecordProperties = recordProperties

	serviceUri, err := ReadSimpleField[PascalString](ctx, "serviceUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceUri' field"))
	}
	m.ServiceUri = serviceUri

	noOfServiceCertificate, err := ReadImplicitField[int32](ctx, "noOfServiceCertificate", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfServiceCertificate' field"))
	}
	_ = noOfServiceCertificate

	serviceCertificate, err := ReadCountArrayField[PascalByteString](ctx, "serviceCertificate", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer), uint64(noOfServiceCertificate))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceCertificate' field"))
	}
	m.ServiceCertificate = serviceCertificate

	issuerEndpointSettings, err := ReadSimpleField[PascalString](ctx, "issuerEndpointSettings", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'issuerEndpointSettings' field"))
	}
	m.IssuerEndpointSettings = issuerEndpointSettings

	if closeErr := readBuffer.CloseContext("AuthorizationServiceConfigurationDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AuthorizationServiceConfigurationDataType")
	}

	return m, nil
}

func (m *_AuthorizationServiceConfigurationDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AuthorizationServiceConfigurationDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AuthorizationServiceConfigurationDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AuthorizationServiceConfigurationDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}
		noOfRecordProperties := int32(utils.InlineIf(bool((m.GetRecordProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetRecordProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfRecordProperties", noOfRecordProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfRecordProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "recordProperties", m.GetRecordProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'recordProperties' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "serviceUri", m.GetServiceUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'serviceUri' field")
		}
		noOfServiceCertificate := int32(utils.InlineIf(bool((m.GetServiceCertificate()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetServiceCertificate()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfServiceCertificate", noOfServiceCertificate, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfServiceCertificate' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "serviceCertificate", m.GetServiceCertificate(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'serviceCertificate' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "issuerEndpointSettings", m.GetIssuerEndpointSettings(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'issuerEndpointSettings' field")
		}

		if popErr := writeBuffer.PopContext("AuthorizationServiceConfigurationDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AuthorizationServiceConfigurationDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AuthorizationServiceConfigurationDataType) IsAuthorizationServiceConfigurationDataType() {}

func (m *_AuthorizationServiceConfigurationDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AuthorizationServiceConfigurationDataType) deepCopy() *_AuthorizationServiceConfigurationDataType {
	if m == nil {
		return nil
	}
	_AuthorizationServiceConfigurationDataTypeCopy := &_AuthorizationServiceConfigurationDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.RecordProperties),
		utils.DeepCopy[PascalString](m.ServiceUri),
		utils.DeepCopySlice[PascalByteString, PascalByteString](m.ServiceCertificate),
		utils.DeepCopy[PascalString](m.IssuerEndpointSettings),
	}
	_AuthorizationServiceConfigurationDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _AuthorizationServiceConfigurationDataTypeCopy
}

func (m *_AuthorizationServiceConfigurationDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
