/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AudioDataType is the corresponding interface of AudioDataType
type AudioDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsAudioDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAudioDataType()
	// CreateBuilder creates a AudioDataTypeBuilder
	CreateAudioDataTypeBuilder() AudioDataTypeBuilder
}

// _AudioDataType is the data-structure of this message
type _AudioDataType struct {
}

var _ AudioDataType = (*_AudioDataType)(nil)

// NewAudioDataType factory function for _AudioDataType
func NewAudioDataType() *_AudioDataType {
	return &_AudioDataType{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AudioDataTypeBuilder is a builder for AudioDataType
type AudioDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() AudioDataTypeBuilder
	// Build builds the AudioDataType or returns an error if something is wrong
	Build() (AudioDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AudioDataType
}

// NewAudioDataTypeBuilder() creates a AudioDataTypeBuilder
func NewAudioDataTypeBuilder() AudioDataTypeBuilder {
	return &_AudioDataTypeBuilder{_AudioDataType: new(_AudioDataType)}
}

type _AudioDataTypeBuilder struct {
	*_AudioDataType

	err *utils.MultiError
}

var _ (AudioDataTypeBuilder) = (*_AudioDataTypeBuilder)(nil)

func (b *_AudioDataTypeBuilder) WithMandatoryFields() AudioDataTypeBuilder {
	return b
}

func (b *_AudioDataTypeBuilder) Build() (AudioDataType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AudioDataType.deepCopy(), nil
}

func (b *_AudioDataTypeBuilder) MustBuild() AudioDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AudioDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateAudioDataTypeBuilder().(*_AudioDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAudioDataTypeBuilder creates a AudioDataTypeBuilder
func (b *_AudioDataType) CreateAudioDataTypeBuilder() AudioDataTypeBuilder {
	if b == nil {
		return NewAudioDataTypeBuilder()
	}
	return &_AudioDataTypeBuilder{_AudioDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAudioDataType(structType any) AudioDataType {
	if casted, ok := structType.(AudioDataType); ok {
		return casted
	}
	if casted, ok := structType.(*AudioDataType); ok {
		return *casted
	}
	return nil
}

func (m *_AudioDataType) GetTypeName() string {
	return "AudioDataType"
}

func (m *_AudioDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_AudioDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AudioDataTypeParse(ctx context.Context, theBytes []byte) (AudioDataType, error) {
	return AudioDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AudioDataTypeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (AudioDataType, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (AudioDataType, error) {
		return AudioDataTypeParseWithBuffer(ctx, readBuffer)
	}
}

func AudioDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AudioDataType, error) {
	v, err := (&_AudioDataType{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_AudioDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__audioDataType AudioDataType, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AudioDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AudioDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("AudioDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AudioDataType")
	}

	return m, nil
}

func (m *_AudioDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AudioDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AudioDataType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AudioDataType")
	}

	if popErr := writeBuffer.PopContext("AudioDataType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AudioDataType")
	}
	return nil
}

func (m *_AudioDataType) IsAudioDataType() {}

func (m *_AudioDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AudioDataType) deepCopy() *_AudioDataType {
	if m == nil {
		return nil
	}
	_AudioDataTypeCopy := &_AudioDataType{}
	return _AudioDataTypeCopy
}

func (m *_AudioDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
