/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApplicationInstanceCertificate is the corresponding interface of ApplicationInstanceCertificate
type ApplicationInstanceCertificate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsApplicationInstanceCertificate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApplicationInstanceCertificate()
	// CreateBuilder creates a ApplicationInstanceCertificateBuilder
	CreateApplicationInstanceCertificateBuilder() ApplicationInstanceCertificateBuilder
}

// _ApplicationInstanceCertificate is the data-structure of this message
type _ApplicationInstanceCertificate struct {
}

var _ ApplicationInstanceCertificate = (*_ApplicationInstanceCertificate)(nil)

// NewApplicationInstanceCertificate factory function for _ApplicationInstanceCertificate
func NewApplicationInstanceCertificate() *_ApplicationInstanceCertificate {
	return &_ApplicationInstanceCertificate{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApplicationInstanceCertificateBuilder is a builder for ApplicationInstanceCertificate
type ApplicationInstanceCertificateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApplicationInstanceCertificateBuilder
	// Build builds the ApplicationInstanceCertificate or returns an error if something is wrong
	Build() (ApplicationInstanceCertificate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApplicationInstanceCertificate
}

// NewApplicationInstanceCertificateBuilder() creates a ApplicationInstanceCertificateBuilder
func NewApplicationInstanceCertificateBuilder() ApplicationInstanceCertificateBuilder {
	return &_ApplicationInstanceCertificateBuilder{_ApplicationInstanceCertificate: new(_ApplicationInstanceCertificate)}
}

type _ApplicationInstanceCertificateBuilder struct {
	*_ApplicationInstanceCertificate

	err *utils.MultiError
}

var _ (ApplicationInstanceCertificateBuilder) = (*_ApplicationInstanceCertificateBuilder)(nil)

func (b *_ApplicationInstanceCertificateBuilder) WithMandatoryFields() ApplicationInstanceCertificateBuilder {
	return b
}

func (b *_ApplicationInstanceCertificateBuilder) Build() (ApplicationInstanceCertificate, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApplicationInstanceCertificate.deepCopy(), nil
}

func (b *_ApplicationInstanceCertificateBuilder) MustBuild() ApplicationInstanceCertificate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApplicationInstanceCertificateBuilder) DeepCopy() any {
	_copy := b.CreateApplicationInstanceCertificateBuilder().(*_ApplicationInstanceCertificateBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApplicationInstanceCertificateBuilder creates a ApplicationInstanceCertificateBuilder
func (b *_ApplicationInstanceCertificate) CreateApplicationInstanceCertificateBuilder() ApplicationInstanceCertificateBuilder {
	if b == nil {
		return NewApplicationInstanceCertificateBuilder()
	}
	return &_ApplicationInstanceCertificateBuilder{_ApplicationInstanceCertificate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApplicationInstanceCertificate(structType any) ApplicationInstanceCertificate {
	if casted, ok := structType.(ApplicationInstanceCertificate); ok {
		return casted
	}
	if casted, ok := structType.(*ApplicationInstanceCertificate); ok {
		return *casted
	}
	return nil
}

func (m *_ApplicationInstanceCertificate) GetTypeName() string {
	return "ApplicationInstanceCertificate"
}

func (m *_ApplicationInstanceCertificate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ApplicationInstanceCertificate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ApplicationInstanceCertificateParse(ctx context.Context, theBytes []byte) (ApplicationInstanceCertificate, error) {
	return ApplicationInstanceCertificateParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ApplicationInstanceCertificateParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ApplicationInstanceCertificate, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ApplicationInstanceCertificate, error) {
		return ApplicationInstanceCertificateParseWithBuffer(ctx, readBuffer)
	}
}

func ApplicationInstanceCertificateParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ApplicationInstanceCertificate, error) {
	v, err := (&_ApplicationInstanceCertificate{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ApplicationInstanceCertificate) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__applicationInstanceCertificate ApplicationInstanceCertificate, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApplicationInstanceCertificate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApplicationInstanceCertificate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApplicationInstanceCertificate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApplicationInstanceCertificate")
	}

	return m, nil
}

func (m *_ApplicationInstanceCertificate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApplicationInstanceCertificate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ApplicationInstanceCertificate"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ApplicationInstanceCertificate")
	}

	if popErr := writeBuffer.PopContext("ApplicationInstanceCertificate"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ApplicationInstanceCertificate")
	}
	return nil
}

func (m *_ApplicationInstanceCertificate) IsApplicationInstanceCertificate() {}

func (m *_ApplicationInstanceCertificate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApplicationInstanceCertificate) deepCopy() *_ApplicationInstanceCertificate {
	if m == nil {
		return nil
	}
	_ApplicationInstanceCertificateCopy := &_ApplicationInstanceCertificate{}
	return _ApplicationInstanceCertificateCopy
}

func (m *_ApplicationInstanceCertificate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
