/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusPDUWriteSingleCoilResponse is the corresponding interface of ModbusPDUWriteSingleCoilResponse
type ModbusPDUWriteSingleCoilResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ModbusPDU
	// GetAddress returns Address (property field)
	GetAddress() uint16
	// GetValue returns Value (property field)
	GetValue() uint16
	// IsModbusPDUWriteSingleCoilResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusPDUWriteSingleCoilResponse()
	// CreateBuilder creates a ModbusPDUWriteSingleCoilResponseBuilder
	CreateModbusPDUWriteSingleCoilResponseBuilder() ModbusPDUWriteSingleCoilResponseBuilder
}

// _ModbusPDUWriteSingleCoilResponse is the data-structure of this message
type _ModbusPDUWriteSingleCoilResponse struct {
	ModbusPDUContract
	Address uint16
	Value   uint16
}

var _ ModbusPDUWriteSingleCoilResponse = (*_ModbusPDUWriteSingleCoilResponse)(nil)
var _ ModbusPDURequirements = (*_ModbusPDUWriteSingleCoilResponse)(nil)

// NewModbusPDUWriteSingleCoilResponse factory function for _ModbusPDUWriteSingleCoilResponse
func NewModbusPDUWriteSingleCoilResponse(address uint16, value uint16) *_ModbusPDUWriteSingleCoilResponse {
	_result := &_ModbusPDUWriteSingleCoilResponse{
		ModbusPDUContract: NewModbusPDU(),
		Address:           address,
		Value:             value,
	}
	_result.ModbusPDUContract.(*_ModbusPDU)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModbusPDUWriteSingleCoilResponseBuilder is a builder for ModbusPDUWriteSingleCoilResponse
type ModbusPDUWriteSingleCoilResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(address uint16, value uint16) ModbusPDUWriteSingleCoilResponseBuilder
	// WithAddress adds Address (property field)
	WithAddress(uint16) ModbusPDUWriteSingleCoilResponseBuilder
	// WithValue adds Value (property field)
	WithValue(uint16) ModbusPDUWriteSingleCoilResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ModbusPDUBuilder
	// Build builds the ModbusPDUWriteSingleCoilResponse or returns an error if something is wrong
	Build() (ModbusPDUWriteSingleCoilResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModbusPDUWriteSingleCoilResponse
}

// NewModbusPDUWriteSingleCoilResponseBuilder() creates a ModbusPDUWriteSingleCoilResponseBuilder
func NewModbusPDUWriteSingleCoilResponseBuilder() ModbusPDUWriteSingleCoilResponseBuilder {
	return &_ModbusPDUWriteSingleCoilResponseBuilder{_ModbusPDUWriteSingleCoilResponse: new(_ModbusPDUWriteSingleCoilResponse)}
}

type _ModbusPDUWriteSingleCoilResponseBuilder struct {
	*_ModbusPDUWriteSingleCoilResponse

	parentBuilder *_ModbusPDUBuilder

	err *utils.MultiError
}

var _ (ModbusPDUWriteSingleCoilResponseBuilder) = (*_ModbusPDUWriteSingleCoilResponseBuilder)(nil)

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) setParent(contract ModbusPDUContract) {
	b.ModbusPDUContract = contract
	contract.(*_ModbusPDU)._SubType = b._ModbusPDUWriteSingleCoilResponse
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) WithMandatoryFields(address uint16, value uint16) ModbusPDUWriteSingleCoilResponseBuilder {
	return b.WithAddress(address).WithValue(value)
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) WithAddress(address uint16) ModbusPDUWriteSingleCoilResponseBuilder {
	b.Address = address
	return b
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) WithValue(value uint16) ModbusPDUWriteSingleCoilResponseBuilder {
	b.Value = value
	return b
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) Build() (ModbusPDUWriteSingleCoilResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ModbusPDUWriteSingleCoilResponse.deepCopy(), nil
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) MustBuild() ModbusPDUWriteSingleCoilResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) Done() ModbusPDUBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewModbusPDUBuilder().(*_ModbusPDUBuilder)
	}
	return b.parentBuilder
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) buildForModbusPDU() (ModbusPDU, error) {
	return b.Build()
}

func (b *_ModbusPDUWriteSingleCoilResponseBuilder) DeepCopy() any {
	_copy := b.CreateModbusPDUWriteSingleCoilResponseBuilder().(*_ModbusPDUWriteSingleCoilResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateModbusPDUWriteSingleCoilResponseBuilder creates a ModbusPDUWriteSingleCoilResponseBuilder
func (b *_ModbusPDUWriteSingleCoilResponse) CreateModbusPDUWriteSingleCoilResponseBuilder() ModbusPDUWriteSingleCoilResponseBuilder {
	if b == nil {
		return NewModbusPDUWriteSingleCoilResponseBuilder()
	}
	return &_ModbusPDUWriteSingleCoilResponseBuilder{_ModbusPDUWriteSingleCoilResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModbusPDUWriteSingleCoilResponse) GetErrorFlag() bool {
	return bool(false)
}

func (m *_ModbusPDUWriteSingleCoilResponse) GetFunctionFlag() uint8 {
	return 0x05
}

func (m *_ModbusPDUWriteSingleCoilResponse) GetResponse() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModbusPDUWriteSingleCoilResponse) GetParent() ModbusPDUContract {
	return m.ModbusPDUContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModbusPDUWriteSingleCoilResponse) GetAddress() uint16 {
	return m.Address
}

func (m *_ModbusPDUWriteSingleCoilResponse) GetValue() uint16 {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModbusPDUWriteSingleCoilResponse(structType any) ModbusPDUWriteSingleCoilResponse {
	if casted, ok := structType.(ModbusPDUWriteSingleCoilResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ModbusPDUWriteSingleCoilResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ModbusPDUWriteSingleCoilResponse) GetTypeName() string {
	return "ModbusPDUWriteSingleCoilResponse"
}

func (m *_ModbusPDUWriteSingleCoilResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ModbusPDUContract.(*_ModbusPDU).getLengthInBits(ctx))

	// Simple field (address)
	lengthInBits += 16

	// Simple field (value)
	lengthInBits += 16

	return lengthInBits
}

func (m *_ModbusPDUWriteSingleCoilResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ModbusPDUWriteSingleCoilResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ModbusPDU, response bool) (__modbusPDUWriteSingleCoilResponse ModbusPDUWriteSingleCoilResponse, err error) {
	m.ModbusPDUContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModbusPDUWriteSingleCoilResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModbusPDUWriteSingleCoilResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	address, err := ReadSimpleField(ctx, "address", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	value, err := ReadSimpleField(ctx, "value", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("ModbusPDUWriteSingleCoilResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModbusPDUWriteSingleCoilResponse")
	}

	return m, nil
}

func (m *_ModbusPDUWriteSingleCoilResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModbusPDUWriteSingleCoilResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModbusPDUWriteSingleCoilResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModbusPDUWriteSingleCoilResponse")
		}

		if err := WriteSimpleField[uint16](ctx, "address", m.GetAddress(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}

		if err := WriteSimpleField[uint16](ctx, "value", m.GetValue(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("ModbusPDUWriteSingleCoilResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModbusPDUWriteSingleCoilResponse")
		}
		return nil
	}
	return m.ModbusPDUContract.(*_ModbusPDU).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModbusPDUWriteSingleCoilResponse) IsModbusPDUWriteSingleCoilResponse() {}

func (m *_ModbusPDUWriteSingleCoilResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModbusPDUWriteSingleCoilResponse) deepCopy() *_ModbusPDUWriteSingleCoilResponse {
	if m == nil {
		return nil
	}
	_ModbusPDUWriteSingleCoilResponseCopy := &_ModbusPDUWriteSingleCoilResponse{
		m.ModbusPDUContract.(*_ModbusPDU).deepCopy(),
		m.Address,
		m.Value,
	}
	_ModbusPDUWriteSingleCoilResponseCopy.ModbusPDUContract.(*_ModbusPDU)._SubType = m
	return _ModbusPDUWriteSingleCoilResponseCopy
}

func (m *_ModbusPDUWriteSingleCoilResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
