/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusPDU is the corresponding interface of ModbusPDU
type ModbusPDU interface {
	ModbusPDUContract
	ModbusPDURequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsModbusPDU is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusPDU()
	// CreateBuilder creates a ModbusPDUBuilder
	CreateModbusPDUBuilder() ModbusPDUBuilder
}

// ModbusPDUContract provides a set of functions which can be overwritten by a sub struct
type ModbusPDUContract interface {
	// IsModbusPDU is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusPDU()
	// CreateBuilder creates a ModbusPDUBuilder
	CreateModbusPDUBuilder() ModbusPDUBuilder
}

// ModbusPDURequirements provides a set of functions which need to be implemented by a sub struct
type ModbusPDURequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetErrorFlag returns ErrorFlag (discriminator field)
	GetErrorFlag() bool
	// GetFunctionFlag returns FunctionFlag (discriminator field)
	GetFunctionFlag() uint8
	// GetResponse returns Response (discriminator field)
	GetResponse() bool
}

// _ModbusPDU is the data-structure of this message
type _ModbusPDU struct {
	_SubType interface {
		ModbusPDUContract
		ModbusPDURequirements
	}
}

var _ ModbusPDUContract = (*_ModbusPDU)(nil)

// NewModbusPDU factory function for _ModbusPDU
func NewModbusPDU() *_ModbusPDU {
	return &_ModbusPDU{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModbusPDUBuilder is a builder for ModbusPDU
type ModbusPDUBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ModbusPDUBuilder
	// AsModbusPDUError converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUError() ModbusPDUErrorBuilder
	// AsModbusPDUReadDiscreteInputsRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadDiscreteInputsRequest() ModbusPDUReadDiscreteInputsRequestBuilder
	// AsModbusPDUReadDiscreteInputsResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadDiscreteInputsResponse() ModbusPDUReadDiscreteInputsResponseBuilder
	// AsModbusPDUReadCoilsRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadCoilsRequest() ModbusPDUReadCoilsRequestBuilder
	// AsModbusPDUReadCoilsResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadCoilsResponse() ModbusPDUReadCoilsResponseBuilder
	// AsModbusPDUWriteSingleCoilRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteSingleCoilRequest() ModbusPDUWriteSingleCoilRequestBuilder
	// AsModbusPDUWriteSingleCoilResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteSingleCoilResponse() ModbusPDUWriteSingleCoilResponseBuilder
	// AsModbusPDUWriteMultipleCoilsRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteMultipleCoilsRequest() ModbusPDUWriteMultipleCoilsRequestBuilder
	// AsModbusPDUWriteMultipleCoilsResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteMultipleCoilsResponse() ModbusPDUWriteMultipleCoilsResponseBuilder
	// AsModbusPDUReadInputRegistersRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadInputRegistersRequest() ModbusPDUReadInputRegistersRequestBuilder
	// AsModbusPDUReadInputRegistersResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadInputRegistersResponse() ModbusPDUReadInputRegistersResponseBuilder
	// AsModbusPDUReadHoldingRegistersRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadHoldingRegistersRequest() ModbusPDUReadHoldingRegistersRequestBuilder
	// AsModbusPDUReadHoldingRegistersResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadHoldingRegistersResponse() ModbusPDUReadHoldingRegistersResponseBuilder
	// AsModbusPDUWriteSingleRegisterRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteSingleRegisterRequest() ModbusPDUWriteSingleRegisterRequestBuilder
	// AsModbusPDUWriteSingleRegisterResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteSingleRegisterResponse() ModbusPDUWriteSingleRegisterResponseBuilder
	// AsModbusPDUWriteMultipleHoldingRegistersRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteMultipleHoldingRegistersRequest() ModbusPDUWriteMultipleHoldingRegistersRequestBuilder
	// AsModbusPDUWriteMultipleHoldingRegistersResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteMultipleHoldingRegistersResponse() ModbusPDUWriteMultipleHoldingRegistersResponseBuilder
	// AsModbusPDUReadWriteMultipleHoldingRegistersRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadWriteMultipleHoldingRegistersRequest() ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder
	// AsModbusPDUReadWriteMultipleHoldingRegistersResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadWriteMultipleHoldingRegistersResponse() ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder
	// AsModbusPDUMaskWriteHoldingRegisterRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUMaskWriteHoldingRegisterRequest() ModbusPDUMaskWriteHoldingRegisterRequestBuilder
	// AsModbusPDUMaskWriteHoldingRegisterResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUMaskWriteHoldingRegisterResponse() ModbusPDUMaskWriteHoldingRegisterResponseBuilder
	// AsModbusPDUReadFifoQueueRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadFifoQueueRequest() ModbusPDUReadFifoQueueRequestBuilder
	// AsModbusPDUReadFifoQueueResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadFifoQueueResponse() ModbusPDUReadFifoQueueResponseBuilder
	// AsModbusPDUReadFileRecordRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadFileRecordRequest() ModbusPDUReadFileRecordRequestBuilder
	// AsModbusPDUReadFileRecordResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadFileRecordResponse() ModbusPDUReadFileRecordResponseBuilder
	// AsModbusPDUWriteFileRecordRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteFileRecordRequest() ModbusPDUWriteFileRecordRequestBuilder
	// AsModbusPDUWriteFileRecordResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUWriteFileRecordResponse() ModbusPDUWriteFileRecordResponseBuilder
	// AsModbusPDUReadExceptionStatusRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadExceptionStatusRequest() ModbusPDUReadExceptionStatusRequestBuilder
	// AsModbusPDUReadExceptionStatusResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadExceptionStatusResponse() ModbusPDUReadExceptionStatusResponseBuilder
	// AsModbusPDUDiagnosticRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUDiagnosticRequest() ModbusPDUDiagnosticRequestBuilder
	// AsModbusPDUDiagnosticResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUDiagnosticResponse() ModbusPDUDiagnosticResponseBuilder
	// AsModbusPDUGetComEventCounterRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUGetComEventCounterRequest() ModbusPDUGetComEventCounterRequestBuilder
	// AsModbusPDUGetComEventCounterResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUGetComEventCounterResponse() ModbusPDUGetComEventCounterResponseBuilder
	// AsModbusPDUGetComEventLogRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUGetComEventLogRequest() ModbusPDUGetComEventLogRequestBuilder
	// AsModbusPDUGetComEventLogResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUGetComEventLogResponse() ModbusPDUGetComEventLogResponseBuilder
	// AsModbusPDUReportServerIdRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReportServerIdRequest() ModbusPDUReportServerIdRequestBuilder
	// AsModbusPDUReportServerIdResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReportServerIdResponse() ModbusPDUReportServerIdResponseBuilder
	// AsModbusPDUReadDeviceIdentificationRequest converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadDeviceIdentificationRequest() ModbusPDUReadDeviceIdentificationRequestBuilder
	// AsModbusPDUReadDeviceIdentificationResponse converts this build to a subType of ModbusPDU. It is always possible to return to current builder using Done()
	AsModbusPDUReadDeviceIdentificationResponse() ModbusPDUReadDeviceIdentificationResponseBuilder
	// Build builds the ModbusPDU or returns an error if something is wrong
	PartialBuild() (ModbusPDUContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() ModbusPDUContract
	// Build builds the ModbusPDU or returns an error if something is wrong
	Build() (ModbusPDU, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModbusPDU
}

// NewModbusPDUBuilder() creates a ModbusPDUBuilder
func NewModbusPDUBuilder() ModbusPDUBuilder {
	return &_ModbusPDUBuilder{_ModbusPDU: new(_ModbusPDU)}
}

type _ModbusPDUChildBuilder interface {
	utils.Copyable
	setParent(ModbusPDUContract)
	buildForModbusPDU() (ModbusPDU, error)
}

type _ModbusPDUBuilder struct {
	*_ModbusPDU

	childBuilder _ModbusPDUChildBuilder

	err *utils.MultiError
}

var _ (ModbusPDUBuilder) = (*_ModbusPDUBuilder)(nil)

func (b *_ModbusPDUBuilder) WithMandatoryFields() ModbusPDUBuilder {
	return b
}

func (b *_ModbusPDUBuilder) PartialBuild() (ModbusPDUContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ModbusPDU.deepCopy(), nil
}

func (b *_ModbusPDUBuilder) PartialMustBuild() ModbusPDUContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusPDUBuilder) AsModbusPDUError() ModbusPDUErrorBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUErrorBuilder); ok {
		return cb
	}
	cb := NewModbusPDUErrorBuilder().(*_ModbusPDUErrorBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadDiscreteInputsRequest() ModbusPDUReadDiscreteInputsRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadDiscreteInputsRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadDiscreteInputsRequestBuilder().(*_ModbusPDUReadDiscreteInputsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadDiscreteInputsResponse() ModbusPDUReadDiscreteInputsResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadDiscreteInputsResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadDiscreteInputsResponseBuilder().(*_ModbusPDUReadDiscreteInputsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadCoilsRequest() ModbusPDUReadCoilsRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadCoilsRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadCoilsRequestBuilder().(*_ModbusPDUReadCoilsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadCoilsResponse() ModbusPDUReadCoilsResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadCoilsResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadCoilsResponseBuilder().(*_ModbusPDUReadCoilsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteSingleCoilRequest() ModbusPDUWriteSingleCoilRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteSingleCoilRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteSingleCoilRequestBuilder().(*_ModbusPDUWriteSingleCoilRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteSingleCoilResponse() ModbusPDUWriteSingleCoilResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteSingleCoilResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteSingleCoilResponseBuilder().(*_ModbusPDUWriteSingleCoilResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteMultipleCoilsRequest() ModbusPDUWriteMultipleCoilsRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteMultipleCoilsRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteMultipleCoilsRequestBuilder().(*_ModbusPDUWriteMultipleCoilsRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteMultipleCoilsResponse() ModbusPDUWriteMultipleCoilsResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteMultipleCoilsResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteMultipleCoilsResponseBuilder().(*_ModbusPDUWriteMultipleCoilsResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadInputRegistersRequest() ModbusPDUReadInputRegistersRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadInputRegistersRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadInputRegistersRequestBuilder().(*_ModbusPDUReadInputRegistersRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadInputRegistersResponse() ModbusPDUReadInputRegistersResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadInputRegistersResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadInputRegistersResponseBuilder().(*_ModbusPDUReadInputRegistersResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadHoldingRegistersRequest() ModbusPDUReadHoldingRegistersRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadHoldingRegistersRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadHoldingRegistersRequestBuilder().(*_ModbusPDUReadHoldingRegistersRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadHoldingRegistersResponse() ModbusPDUReadHoldingRegistersResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadHoldingRegistersResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadHoldingRegistersResponseBuilder().(*_ModbusPDUReadHoldingRegistersResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteSingleRegisterRequest() ModbusPDUWriteSingleRegisterRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteSingleRegisterRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteSingleRegisterRequestBuilder().(*_ModbusPDUWriteSingleRegisterRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteSingleRegisterResponse() ModbusPDUWriteSingleRegisterResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteSingleRegisterResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteSingleRegisterResponseBuilder().(*_ModbusPDUWriteSingleRegisterResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteMultipleHoldingRegistersRequest() ModbusPDUWriteMultipleHoldingRegistersRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteMultipleHoldingRegistersRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteMultipleHoldingRegistersRequestBuilder().(*_ModbusPDUWriteMultipleHoldingRegistersRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteMultipleHoldingRegistersResponse() ModbusPDUWriteMultipleHoldingRegistersResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteMultipleHoldingRegistersResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteMultipleHoldingRegistersResponseBuilder().(*_ModbusPDUWriteMultipleHoldingRegistersResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadWriteMultipleHoldingRegistersRequest() ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder().(*_ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadWriteMultipleHoldingRegistersResponse() ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder().(*_ModbusPDUReadWriteMultipleHoldingRegistersResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUMaskWriteHoldingRegisterRequest() ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUMaskWriteHoldingRegisterRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUMaskWriteHoldingRegisterRequestBuilder().(*_ModbusPDUMaskWriteHoldingRegisterRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUMaskWriteHoldingRegisterResponse() ModbusPDUMaskWriteHoldingRegisterResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUMaskWriteHoldingRegisterResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUMaskWriteHoldingRegisterResponseBuilder().(*_ModbusPDUMaskWriteHoldingRegisterResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadFifoQueueRequest() ModbusPDUReadFifoQueueRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadFifoQueueRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadFifoQueueRequestBuilder().(*_ModbusPDUReadFifoQueueRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadFifoQueueResponse() ModbusPDUReadFifoQueueResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadFifoQueueResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadFifoQueueResponseBuilder().(*_ModbusPDUReadFifoQueueResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadFileRecordRequest() ModbusPDUReadFileRecordRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadFileRecordRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadFileRecordRequestBuilder().(*_ModbusPDUReadFileRecordRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadFileRecordResponse() ModbusPDUReadFileRecordResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadFileRecordResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadFileRecordResponseBuilder().(*_ModbusPDUReadFileRecordResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteFileRecordRequest() ModbusPDUWriteFileRecordRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteFileRecordRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteFileRecordRequestBuilder().(*_ModbusPDUWriteFileRecordRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUWriteFileRecordResponse() ModbusPDUWriteFileRecordResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUWriteFileRecordResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUWriteFileRecordResponseBuilder().(*_ModbusPDUWriteFileRecordResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadExceptionStatusRequest() ModbusPDUReadExceptionStatusRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadExceptionStatusRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadExceptionStatusRequestBuilder().(*_ModbusPDUReadExceptionStatusRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadExceptionStatusResponse() ModbusPDUReadExceptionStatusResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadExceptionStatusResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadExceptionStatusResponseBuilder().(*_ModbusPDUReadExceptionStatusResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUDiagnosticRequest() ModbusPDUDiagnosticRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUDiagnosticRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUDiagnosticRequestBuilder().(*_ModbusPDUDiagnosticRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUDiagnosticResponse() ModbusPDUDiagnosticResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUDiagnosticResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUDiagnosticResponseBuilder().(*_ModbusPDUDiagnosticResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUGetComEventCounterRequest() ModbusPDUGetComEventCounterRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUGetComEventCounterRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUGetComEventCounterRequestBuilder().(*_ModbusPDUGetComEventCounterRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUGetComEventCounterResponse() ModbusPDUGetComEventCounterResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUGetComEventCounterResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUGetComEventCounterResponseBuilder().(*_ModbusPDUGetComEventCounterResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUGetComEventLogRequest() ModbusPDUGetComEventLogRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUGetComEventLogRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUGetComEventLogRequestBuilder().(*_ModbusPDUGetComEventLogRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUGetComEventLogResponse() ModbusPDUGetComEventLogResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUGetComEventLogResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUGetComEventLogResponseBuilder().(*_ModbusPDUGetComEventLogResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReportServerIdRequest() ModbusPDUReportServerIdRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReportServerIdRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReportServerIdRequestBuilder().(*_ModbusPDUReportServerIdRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReportServerIdResponse() ModbusPDUReportServerIdResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReportServerIdResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReportServerIdResponseBuilder().(*_ModbusPDUReportServerIdResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadDeviceIdentificationRequest() ModbusPDUReadDeviceIdentificationRequestBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadDeviceIdentificationRequestBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadDeviceIdentificationRequestBuilder().(*_ModbusPDUReadDeviceIdentificationRequestBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) AsModbusPDUReadDeviceIdentificationResponse() ModbusPDUReadDeviceIdentificationResponseBuilder {
	if cb, ok := b.childBuilder.(ModbusPDUReadDeviceIdentificationResponseBuilder); ok {
		return cb
	}
	cb := NewModbusPDUReadDeviceIdentificationResponseBuilder().(*_ModbusPDUReadDeviceIdentificationResponseBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_ModbusPDUBuilder) Build() (ModbusPDU, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForModbusPDU()
}

func (b *_ModbusPDUBuilder) MustBuild() ModbusPDU {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusPDUBuilder) DeepCopy() any {
	_copy := b.CreateModbusPDUBuilder().(*_ModbusPDUBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_ModbusPDUChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateModbusPDUBuilder creates a ModbusPDUBuilder
func (b *_ModbusPDU) CreateModbusPDUBuilder() ModbusPDUBuilder {
	if b == nil {
		return NewModbusPDUBuilder()
	}
	return &_ModbusPDUBuilder{_ModbusPDU: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModbusPDU(structType any) ModbusPDU {
	if casted, ok := structType.(ModbusPDU); ok {
		return casted
	}
	if casted, ok := structType.(*ModbusPDU); ok {
		return *casted
	}
	return nil
}

func (m *_ModbusPDU) GetTypeName() string {
	return "ModbusPDU"
}

func (m *_ModbusPDU) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (errorFlag)
	lengthInBits += 1
	// Discriminator Field (functionFlag)
	lengthInBits += 7

	return lengthInBits
}

func (m *_ModbusPDU) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_ModbusPDU) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func ModbusPDUParse[T ModbusPDU](ctx context.Context, theBytes []byte, response bool) (T, error) {
	return ModbusPDUParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), response)
}

func ModbusPDUParseWithBufferProducer[T ModbusPDU](response bool) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := ModbusPDUParseWithBuffer[T](ctx, readBuffer, response)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func ModbusPDUParseWithBuffer[T ModbusPDU](ctx context.Context, readBuffer utils.ReadBuffer, response bool) (T, error) {
	v, err := (&_ModbusPDU{}).parse(ctx, readBuffer, response)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_ModbusPDU) parse(ctx context.Context, readBuffer utils.ReadBuffer, response bool) (__modbusPDU ModbusPDU, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModbusPDU"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModbusPDU")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	errorFlag, err := ReadDiscriminatorField[bool](ctx, "errorFlag", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'errorFlag' field"))
	}

	functionFlag, err := ReadDiscriminatorField[uint8](ctx, "functionFlag", ReadUnsignedByte(readBuffer, uint8(7)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'functionFlag' field"))
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child ModbusPDU
	switch {
	case errorFlag == bool(true): // ModbusPDUError
		if _child, err = new(_ModbusPDUError).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUError for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x02 && response == bool(false): // ModbusPDUReadDiscreteInputsRequest
		if _child, err = new(_ModbusPDUReadDiscreteInputsRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadDiscreteInputsRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x02 && response == bool(true): // ModbusPDUReadDiscreteInputsResponse
		if _child, err = new(_ModbusPDUReadDiscreteInputsResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadDiscreteInputsResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x01 && response == bool(false): // ModbusPDUReadCoilsRequest
		if _child, err = new(_ModbusPDUReadCoilsRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadCoilsRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x01 && response == bool(true): // ModbusPDUReadCoilsResponse
		if _child, err = new(_ModbusPDUReadCoilsResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadCoilsResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x05 && response == bool(false): // ModbusPDUWriteSingleCoilRequest
		if _child, err = new(_ModbusPDUWriteSingleCoilRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteSingleCoilRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x05 && response == bool(true): // ModbusPDUWriteSingleCoilResponse
		if _child, err = new(_ModbusPDUWriteSingleCoilResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteSingleCoilResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x0F && response == bool(false): // ModbusPDUWriteMultipleCoilsRequest
		if _child, err = new(_ModbusPDUWriteMultipleCoilsRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteMultipleCoilsRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x0F && response == bool(true): // ModbusPDUWriteMultipleCoilsResponse
		if _child, err = new(_ModbusPDUWriteMultipleCoilsResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteMultipleCoilsResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x04 && response == bool(false): // ModbusPDUReadInputRegistersRequest
		if _child, err = new(_ModbusPDUReadInputRegistersRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadInputRegistersRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x04 && response == bool(true): // ModbusPDUReadInputRegistersResponse
		if _child, err = new(_ModbusPDUReadInputRegistersResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadInputRegistersResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x03 && response == bool(false): // ModbusPDUReadHoldingRegistersRequest
		if _child, err = new(_ModbusPDUReadHoldingRegistersRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadHoldingRegistersRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x03 && response == bool(true): // ModbusPDUReadHoldingRegistersResponse
		if _child, err = new(_ModbusPDUReadHoldingRegistersResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadHoldingRegistersResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x06 && response == bool(false): // ModbusPDUWriteSingleRegisterRequest
		if _child, err = new(_ModbusPDUWriteSingleRegisterRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteSingleRegisterRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x06 && response == bool(true): // ModbusPDUWriteSingleRegisterResponse
		if _child, err = new(_ModbusPDUWriteSingleRegisterResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteSingleRegisterResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x10 && response == bool(false): // ModbusPDUWriteMultipleHoldingRegistersRequest
		if _child, err = new(_ModbusPDUWriteMultipleHoldingRegistersRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteMultipleHoldingRegistersRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x10 && response == bool(true): // ModbusPDUWriteMultipleHoldingRegistersResponse
		if _child, err = new(_ModbusPDUWriteMultipleHoldingRegistersResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteMultipleHoldingRegistersResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x17 && response == bool(false): // ModbusPDUReadWriteMultipleHoldingRegistersRequest
		if _child, err = new(_ModbusPDUReadWriteMultipleHoldingRegistersRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadWriteMultipleHoldingRegistersRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x17 && response == bool(true): // ModbusPDUReadWriteMultipleHoldingRegistersResponse
		if _child, err = new(_ModbusPDUReadWriteMultipleHoldingRegistersResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadWriteMultipleHoldingRegistersResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x16 && response == bool(false): // ModbusPDUMaskWriteHoldingRegisterRequest
		if _child, err = new(_ModbusPDUMaskWriteHoldingRegisterRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUMaskWriteHoldingRegisterRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x16 && response == bool(true): // ModbusPDUMaskWriteHoldingRegisterResponse
		if _child, err = new(_ModbusPDUMaskWriteHoldingRegisterResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUMaskWriteHoldingRegisterResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x18 && response == bool(false): // ModbusPDUReadFifoQueueRequest
		if _child, err = new(_ModbusPDUReadFifoQueueRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadFifoQueueRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x18 && response == bool(true): // ModbusPDUReadFifoQueueResponse
		if _child, err = new(_ModbusPDUReadFifoQueueResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadFifoQueueResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x14 && response == bool(false): // ModbusPDUReadFileRecordRequest
		if _child, err = new(_ModbusPDUReadFileRecordRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadFileRecordRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x14 && response == bool(true): // ModbusPDUReadFileRecordResponse
		if _child, err = new(_ModbusPDUReadFileRecordResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadFileRecordResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x15 && response == bool(false): // ModbusPDUWriteFileRecordRequest
		if _child, err = new(_ModbusPDUWriteFileRecordRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteFileRecordRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x15 && response == bool(true): // ModbusPDUWriteFileRecordResponse
		if _child, err = new(_ModbusPDUWriteFileRecordResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUWriteFileRecordResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x07 && response == bool(false): // ModbusPDUReadExceptionStatusRequest
		if _child, err = new(_ModbusPDUReadExceptionStatusRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadExceptionStatusRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x07 && response == bool(true): // ModbusPDUReadExceptionStatusResponse
		if _child, err = new(_ModbusPDUReadExceptionStatusResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadExceptionStatusResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x08 && response == bool(false): // ModbusPDUDiagnosticRequest
		if _child, err = new(_ModbusPDUDiagnosticRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUDiagnosticRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x08 && response == bool(true): // ModbusPDUDiagnosticResponse
		if _child, err = new(_ModbusPDUDiagnosticResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUDiagnosticResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x0B && response == bool(false): // ModbusPDUGetComEventCounterRequest
		if _child, err = new(_ModbusPDUGetComEventCounterRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUGetComEventCounterRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x0B && response == bool(true): // ModbusPDUGetComEventCounterResponse
		if _child, err = new(_ModbusPDUGetComEventCounterResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUGetComEventCounterResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x0C && response == bool(false): // ModbusPDUGetComEventLogRequest
		if _child, err = new(_ModbusPDUGetComEventLogRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUGetComEventLogRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x0C && response == bool(true): // ModbusPDUGetComEventLogResponse
		if _child, err = new(_ModbusPDUGetComEventLogResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUGetComEventLogResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x11 && response == bool(false): // ModbusPDUReportServerIdRequest
		if _child, err = new(_ModbusPDUReportServerIdRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReportServerIdRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x11 && response == bool(true): // ModbusPDUReportServerIdResponse
		if _child, err = new(_ModbusPDUReportServerIdResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReportServerIdResponse for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x2B && response == bool(false): // ModbusPDUReadDeviceIdentificationRequest
		if _child, err = new(_ModbusPDUReadDeviceIdentificationRequest).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadDeviceIdentificationRequest for type-switch of ModbusPDU")
		}
	case errorFlag == bool(false) && functionFlag == 0x2B && response == bool(true): // ModbusPDUReadDeviceIdentificationResponse
		if _child, err = new(_ModbusPDUReadDeviceIdentificationResponse).parse(ctx, readBuffer, m, response); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type ModbusPDUReadDeviceIdentificationResponse for type-switch of ModbusPDU")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [errorFlag=%v, functionFlag=%v, response=%v]", errorFlag, functionFlag, response)
	}

	if closeErr := readBuffer.CloseContext("ModbusPDU"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModbusPDU")
	}

	return _child, nil
}

func (pm *_ModbusPDU) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child ModbusPDU, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ModbusPDU"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ModbusPDU")
	}

	if err := WriteDiscriminatorField(ctx, "errorFlag", m.GetErrorFlag(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'errorFlag' field")
	}

	if err := WriteDiscriminatorField(ctx, "functionFlag", m.GetFunctionFlag(), WriteUnsignedByte(writeBuffer, 7)); err != nil {
		return errors.Wrap(err, "Error serializing 'functionFlag' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("ModbusPDU"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ModbusPDU")
	}
	return nil
}

func (m *_ModbusPDU) IsModbusPDU() {}

func (m *_ModbusPDU) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModbusPDU) deepCopy() *_ModbusPDU {
	if m == nil {
		return nil
	}
	_ModbusPDUCopy := &_ModbusPDU{
		nil, // will be set by child
	}
	return _ModbusPDUCopy
}
