/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// KnxManufacturer is an enum
type KnxManufacturer uint16

type IKnxManufacturer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	Number() uint16
	Name() string
}

const (
	KnxManufacturer_M_UNKNOWN                                            KnxManufacturer = 0
	KnxManufacturer_M_SIEMENS                                            KnxManufacturer = 1
	KnxManufacturer_M_ABB                                                KnxManufacturer = 2
	KnxManufacturer_M_ALBRECHT_JUNG                                      KnxManufacturer = 3
	KnxManufacturer_M_BTICINO                                            KnxManufacturer = 4
	KnxManufacturer_M_BERKER                                             KnxManufacturer = 5
	KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO                               KnxManufacturer = 6
	KnxManufacturer_M_GIRA_GIERSIEPEN                                    KnxManufacturer = 7
	KnxManufacturer_M_HAGER_ELECTRO                                      KnxManufacturer = 8
	KnxManufacturer_M_INSTA_GMBH                                         KnxManufacturer = 9
	KnxManufacturer_M_LEGRAND_APPAREILLAGE_ELECTRIQUE                    KnxManufacturer = 10
	KnxManufacturer_M_MERTEN                                             KnxManufacturer = 11
	KnxManufacturer_M_ABB_SPA_SACE_DIVISION                              KnxManufacturer = 12
	KnxManufacturer_M_SIEDLE_AND_SOEHNE                                  KnxManufacturer = 13
	KnxManufacturer_M_EBERLE                                             KnxManufacturer = 14
	KnxManufacturer_M_GEWISS                                             KnxManufacturer = 15
	KnxManufacturer_M_ALBERT_ACKERMANN                                   KnxManufacturer = 16
	KnxManufacturer_M_SCHUPA_GMBH                                        KnxManufacturer = 17
	KnxManufacturer_M_ABB_SCHWEIZ                                        KnxManufacturer = 18
	KnxManufacturer_M_FELLER                                             KnxManufacturer = 19
	KnxManufacturer_M_GLAMOX_AS                                          KnxManufacturer = 20
	KnxManufacturer_M_DEHN_AND_SOEHNE                                    KnxManufacturer = 21
	KnxManufacturer_M_CRABTREE                                           KnxManufacturer = 22
	KnxManufacturer_M_EVOKNX                                             KnxManufacturer = 23
	KnxManufacturer_M_PAUL_HOCHKOEPPER                                   KnxManufacturer = 24
	KnxManufacturer_M_ALTENBURGER_ELECTRONIC                             KnxManufacturer = 25
	KnxManufacturer_M_GRAESSLIN                                          KnxManufacturer = 26
	KnxManufacturer_M_SIMON_42                                           KnxManufacturer = 27
	KnxManufacturer_M_VIMAR                                              KnxManufacturer = 28
	KnxManufacturer_M_MOELLER_GEBAEUDEAUTOMATION_KG                      KnxManufacturer = 29
	KnxManufacturer_M_ELTAKO                                             KnxManufacturer = 30
	KnxManufacturer_M_BOSCH_SIEMENS_HAUSHALTSGERAETE                     KnxManufacturer = 31
	KnxManufacturer_M_RITTO_GMBHANDCO_KG                                 KnxManufacturer = 32
	KnxManufacturer_M_POWER_CONTROLS                                     KnxManufacturer = 33
	KnxManufacturer_M_ZUMTOBEL                                           KnxManufacturer = 34
	KnxManufacturer_M_HOLEC_SYSTEMEN                                     KnxManufacturer = 35
	KnxManufacturer_M_PHOENIX_CONTACT                                    KnxManufacturer = 36
	KnxManufacturer_M_WAGO_GMBH_AND_CO_KG                                KnxManufacturer = 37
	KnxManufacturer_M_KNXPRESSO                                          KnxManufacturer = 38
	KnxManufacturer_M_WIELAND_ELECTRIC                                   KnxManufacturer = 39
	KnxManufacturer_M_HERMANN_KLEINHUIS                                  KnxManufacturer = 40
	KnxManufacturer_M_STIEBEL_ELTRON                                     KnxManufacturer = 41
	KnxManufacturer_M_TEHALIT                                            KnxManufacturer = 42
	KnxManufacturer_M_THEBEN_AG                                          KnxManufacturer = 43
	KnxManufacturer_M_WILHELM_RUTENBECK                                  KnxManufacturer = 44
	KnxManufacturer_M_WINKHAUS                                           KnxManufacturer = 45
	KnxManufacturer_M_ROBERT_BOSCH                                       KnxManufacturer = 46
	KnxManufacturer_M_SOMFY                                              KnxManufacturer = 47
	KnxManufacturer_M_WOERTZ                                             KnxManufacturer = 48
	KnxManufacturer_M_VIESSMANN_WERKE                                    KnxManufacturer = 49
	KnxManufacturer_M_IMI_HYDRONIC_ENGINEERING                           KnxManufacturer = 50
	KnxManufacturer_M_JOH__VAILLANT                                      KnxManufacturer = 51
	KnxManufacturer_M_AMP_DEUTSCHLAND                                    KnxManufacturer = 52
	KnxManufacturer_M_BOSCH_THERMOTECHNIK_GMBH                           KnxManufacturer = 53
	KnxManufacturer_M_SEF___ECOTEC                                       KnxManufacturer = 54
	KnxManufacturer_M_DORMA_GMBH_Plus_CO__KG                             KnxManufacturer = 55
	KnxManufacturer_M_WINDOWMASTER_AS                                    KnxManufacturer = 56
	KnxManufacturer_M_WALTHER_WERKE                                      KnxManufacturer = 57
	KnxManufacturer_M_ORAS                                               KnxManufacturer = 58
	KnxManufacturer_M_DAETWYLER                                          KnxManufacturer = 59
	KnxManufacturer_M_ELECTRAK                                           KnxManufacturer = 60
	KnxManufacturer_M_TECHEM                                             KnxManufacturer = 61
	KnxManufacturer_M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS                  KnxManufacturer = 62
	KnxManufacturer_M_WHD_WILHELM_HUBER_Plus_SOEHNE                      KnxManufacturer = 63
	KnxManufacturer_M_BISCHOFF_ELEKTRONIK                                KnxManufacturer = 64
	KnxManufacturer_M_JEPAZ                                              KnxManufacturer = 65
	KnxManufacturer_M_RTS_AUTOMATION                                     KnxManufacturer = 66
	KnxManufacturer_M_EIBMARKT_GMBH                                      KnxManufacturer = 67
	KnxManufacturer_M_WAREMA_RENKHOFF_SE                                 KnxManufacturer = 68
	KnxManufacturer_M_EELECTRON                                          KnxManufacturer = 69
	KnxManufacturer_M_BELDEN_WIRE_AND_CABLE_B_V_                         KnxManufacturer = 70
	KnxManufacturer_M_BECKER_ANTRIEBE_GMBH                               KnxManufacturer = 71
	KnxManufacturer_M_J_STEHLEPlusSOEHNE_GMBH                            KnxManufacturer = 72
	KnxManufacturer_M_AGFEO                                              KnxManufacturer = 73
	KnxManufacturer_M_ZENNIO                                             KnxManufacturer = 74
	KnxManufacturer_M_TAPKO_TECHNOLOGIES                                 KnxManufacturer = 75
	KnxManufacturer_M_HDL                                                KnxManufacturer = 76
	KnxManufacturer_M_UPONOR                                             KnxManufacturer = 77
	KnxManufacturer_M_SE_LIGHTMANAGEMENT_AG                              KnxManufacturer = 78
	KnxManufacturer_M_ARCUS_EDS                                          KnxManufacturer = 79
	KnxManufacturer_M_INTESIS                                            KnxManufacturer = 80
	KnxManufacturer_M_HERHOLDT_CONTROLS_SRL                              KnxManufacturer = 81
	KnxManufacturer_M_NIKO_ZUBLIN                                        KnxManufacturer = 82
	KnxManufacturer_M_DURABLE_TECHNOLOGIES                               KnxManufacturer = 83
	KnxManufacturer_M_INNOTEAM                                           KnxManufacturer = 84
	KnxManufacturer_M_ISE_GMBH                                           KnxManufacturer = 85
	KnxManufacturer_M_TEAM_FOR_TRONICS                                   KnxManufacturer = 86
	KnxManufacturer_M_CARRIER_SAS                                        KnxManufacturer = 87
	KnxManufacturer_M_REMEHA_BV                                          KnxManufacturer = 88
	KnxManufacturer_M_ESYLUX                                             KnxManufacturer = 89
	KnxManufacturer_M_BASALTE                                            KnxManufacturer = 90
	KnxManufacturer_M_VESTAMATIC                                         KnxManufacturer = 91
	KnxManufacturer_M_MDT_TECHNOLOGIES                                   KnxManufacturer = 92
	KnxManufacturer_M_WARENDORFER_KUECHEN_GMBH                           KnxManufacturer = 93
	KnxManufacturer_M_GVS                                                KnxManufacturer = 94
	KnxManufacturer_M_SITEK                                              KnxManufacturer = 95
	KnxManufacturer_M_CONTROLTRONIC                                      KnxManufacturer = 96
	KnxManufacturer_M_FUNCTION_TECHNOLOGY                                KnxManufacturer = 97
	KnxManufacturer_M_AMX                                                KnxManufacturer = 98
	KnxManufacturer_M_ELDAT                                              KnxManufacturer = 99
	KnxManufacturer_M_PANASONIC                                          KnxManufacturer = 100
	KnxManufacturer_M_PULSE_TECHNOLOGIES                                 KnxManufacturer = 101
	KnxManufacturer_M_CRESTRON                                           KnxManufacturer = 102
	KnxManufacturer_M_STEINEL_PROFESSIONAL                               KnxManufacturer = 103
	KnxManufacturer_M_BILTON_LED_LIGHTING                                KnxManufacturer = 104
	KnxManufacturer_M_DENRO_AG                                           KnxManufacturer = 105
	KnxManufacturer_M_GEPRO                                              KnxManufacturer = 106
	KnxManufacturer_M_PREUSSEN_AUTOMATION                                KnxManufacturer = 107
	KnxManufacturer_M_ZOPPAS_INDUSTRIES                                  KnxManufacturer = 108
	KnxManufacturer_M_MACTECH                                            KnxManufacturer = 109
	KnxManufacturer_M_TECHNO_TREND                                       KnxManufacturer = 110
	KnxManufacturer_M_FS_CABLES                                          KnxManufacturer = 111
	KnxManufacturer_M_DELTA_DORE                                         KnxManufacturer = 112
	KnxManufacturer_M_EISSOUND                                           KnxManufacturer = 113
	KnxManufacturer_M_CISCO                                              KnxManufacturer = 114
	KnxManufacturer_M_DINUY                                              KnxManufacturer = 115
	KnxManufacturer_M_IKNIX                                              KnxManufacturer = 116
	KnxManufacturer_M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH                 KnxManufacturer = 117
	KnxManufacturer_M_EGI_ELECTROACUSTICA_GENERAL_IBERICA                KnxManufacturer = 118
	KnxManufacturer_M_BES___INGENIUM                                     KnxManufacturer = 119
	KnxManufacturer_M_ELABNET                                            KnxManufacturer = 120
	KnxManufacturer_M_BLUMOTIX                                           KnxManufacturer = 121
	KnxManufacturer_M_HUNTER_DOUGLAS                                     KnxManufacturer = 122
	KnxManufacturer_M_APRICUM                                            KnxManufacturer = 123
	KnxManufacturer_M_TIANSU_AUTOMATION                                  KnxManufacturer = 124
	KnxManufacturer_M_BUBENDORFF                                         KnxManufacturer = 125
	KnxManufacturer_M_MBS_GMBH                                           KnxManufacturer = 126
	KnxManufacturer_M_ENERTEX_BAYERN_GMBH                                KnxManufacturer = 127
	KnxManufacturer_M_BMS                                                KnxManufacturer = 128
	KnxManufacturer_M_SINAPSI                                            KnxManufacturer = 129
	KnxManufacturer_M_EMBEDDED_SYSTEMS_SIA                               KnxManufacturer = 130
	KnxManufacturer_M_KNX1                                               KnxManufacturer = 131
	KnxManufacturer_M_TOKKA                                              KnxManufacturer = 132
	KnxManufacturer_M_NANOSENSE                                          KnxManufacturer = 133
	KnxManufacturer_M_PEAR_AUTOMATION_GMBH                               KnxManufacturer = 134
	KnxManufacturer_M_DGA                                                KnxManufacturer = 135
	KnxManufacturer_M_LUTRON                                             KnxManufacturer = 136
	KnxManufacturer_M_AIRZONE___ALTRA                                    KnxManufacturer = 137
	KnxManufacturer_M_LITHOSS_DESIGN_SWITCHES                            KnxManufacturer = 138
	KnxManufacturer_M_THREEATEL                                          KnxManufacturer = 139
	KnxManufacturer_M_PHILIPS_CONTROLS                                   KnxManufacturer = 140
	KnxManufacturer_M_VELUX_AS                                           KnxManufacturer = 141
	KnxManufacturer_M_LOYTEC                                             KnxManufacturer = 142
	KnxManufacturer_M_EKINEX_S_P_A_                                      KnxManufacturer = 143
	KnxManufacturer_M_SIRLAN_TECHNOLOGIES                                KnxManufacturer = 144
	KnxManufacturer_M_PROKNX_SAS                                         KnxManufacturer = 145
	KnxManufacturer_M_IT_GMBH                                            KnxManufacturer = 146
	KnxManufacturer_M_RENSON                                             KnxManufacturer = 147
	KnxManufacturer_M_HEP_GROUP                                          KnxManufacturer = 148
	KnxManufacturer_M_BALMART                                            KnxManufacturer = 149
	KnxManufacturer_M_GFS_GMBH                                           KnxManufacturer = 150
	KnxManufacturer_M_SCHENKER_STOREN_AG                                 KnxManufacturer = 151
	KnxManufacturer_M_ALGODUE_ELETTRONICA_S_R_L_                         KnxManufacturer = 152
	KnxManufacturer_M_ABB_FRANCE                                         KnxManufacturer = 153
	KnxManufacturer_M_MAINTRONIC                                         KnxManufacturer = 154
	KnxManufacturer_M_VANTAGE                                            KnxManufacturer = 155
	KnxManufacturer_M_FORESIS                                            KnxManufacturer = 156
	KnxManufacturer_M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM            KnxManufacturer = 157
	KnxManufacturer_M_WEINZIERL_ENGINEERING_GMBH                         KnxManufacturer = 158
	KnxManufacturer_M_MOEHLENHOFF_WAERMETECHNIK_GMBH                     KnxManufacturer = 159
	KnxManufacturer_M_PKC_GROUP_OYJ                                      KnxManufacturer = 160
	KnxManufacturer_M_B_E_G_                                             KnxManufacturer = 161
	KnxManufacturer_M_ELSNER_ELEKTRONIK_GMBH                             KnxManufacturer = 162
	KnxManufacturer_M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_         KnxManufacturer = 163
	KnxManufacturer_M_EUTRAC                                             KnxManufacturer = 164
	KnxManufacturer_M_GUSTAV_HENSEL_GMBH_AND_CO__KG                      KnxManufacturer = 165
	KnxManufacturer_M_GARO_AB                                            KnxManufacturer = 166
	KnxManufacturer_M_WALDMANN_LICHTTECHNIK                              KnxManufacturer = 167
	KnxManufacturer_M_SCHUECO                                            KnxManufacturer = 168
	KnxManufacturer_M_EMU                                                KnxManufacturer = 169
	KnxManufacturer_M_JNET_SYSTEMS_AG                                    KnxManufacturer = 170
	KnxManufacturer_M_TOTAL_SOLUTION_GMBH                                KnxManufacturer = 171
	KnxManufacturer_M_O_Y_L__ELECTRONICS                                 KnxManufacturer = 172
	KnxManufacturer_M_GALAX_SYSTEM                                       KnxManufacturer = 173
	KnxManufacturer_M_DISCH                                              KnxManufacturer = 174
	KnxManufacturer_M_AUCOTEAM                                           KnxManufacturer = 175
	KnxManufacturer_M_LUXMATE_CONTROLS                                   KnxManufacturer = 176
	KnxManufacturer_M_DANFOSS                                            KnxManufacturer = 177
	KnxManufacturer_M_AST_GMBH                                           KnxManufacturer = 178
	KnxManufacturer_M_WILA_LEUCHTEN                                      KnxManufacturer = 179
	KnxManufacturer_M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK          KnxManufacturer = 180
	KnxManufacturer_M_LINGG_AND_JANKE                                    KnxManufacturer = 181
	KnxManufacturer_M_SAUTER                                             KnxManufacturer = 182
	KnxManufacturer_M_SIMU                                               KnxManufacturer = 183
	KnxManufacturer_M_THEBEN_HTS_AG                                      KnxManufacturer = 184
	KnxManufacturer_M_AMANN_GMBH                                         KnxManufacturer = 185
	KnxManufacturer_M_BERG_ENERGIEKONTROLLSYSTEME_GMBH                   KnxManufacturer = 186
	KnxManufacturer_M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH               KnxManufacturer = 187
	KnxManufacturer_M_OVENTROP_KG                                        KnxManufacturer = 188
	KnxManufacturer_M_GRIESSER_AG                                        KnxManufacturer = 189
	KnxManufacturer_M_IPAS_GMBH                                          KnxManufacturer = 190
	KnxManufacturer_M_ELERO_GMBH                                         KnxManufacturer = 191
	KnxManufacturer_M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_      KnxManufacturer = 192
	KnxManufacturer_M_METEC_MESSTECHNIK_GMBH                             KnxManufacturer = 193
	KnxManufacturer_M_BUERK_MOBATIME                                     KnxManufacturer = 194
	KnxManufacturer_M_ELKA_ELEKTRONIK_GMBH                               KnxManufacturer = 195
	KnxManufacturer_M_ELEKTROANLAGEN_D__NAGEL                            KnxManufacturer = 196
	KnxManufacturer_M_TRIDONIC_BAUELEMENTE_GMBH                          KnxManufacturer = 197
	KnxManufacturer_M_STENGLER_GESELLSCHAFT                              KnxManufacturer = 198
	KnxManufacturer_M_SCHNEIDER_ELECTRIC_MG                              KnxManufacturer = 199
	KnxManufacturer_M_KNX_ASSOCIATION                                    KnxManufacturer = 200
	KnxManufacturer_M_VIVO                                               KnxManufacturer = 201
	KnxManufacturer_M_HUGO_MUELLER_GMBH_AND_CO_KG                        KnxManufacturer = 202
	KnxManufacturer_M_SIEMENS_HVAC                                       KnxManufacturer = 203
	KnxManufacturer_M_APT                                                KnxManufacturer = 204
	KnxManufacturer_M_HIGHDOM                                            KnxManufacturer = 205
	KnxManufacturer_M_TOP_SERVICES                                       KnxManufacturer = 206
	KnxManufacturer_M_AMBIHOME                                           KnxManufacturer = 207
	KnxManufacturer_M_DATEC_ELECTRONIC_AG                                KnxManufacturer = 208
	KnxManufacturer_M_ABUS_SECURITY_CENTER                               KnxManufacturer = 209
	KnxManufacturer_M_LITE_PUTER                                         KnxManufacturer = 210
	KnxManufacturer_M_TANTRON_ELECTRONIC                                 KnxManufacturer = 211
	KnxManufacturer_M_INTERRA                                            KnxManufacturer = 212
	KnxManufacturer_M_DKX_TECH                                           KnxManufacturer = 213
	KnxManufacturer_M_VIATRON                                            KnxManufacturer = 214
	KnxManufacturer_M_NAUTIBUS                                           KnxManufacturer = 215
	KnxManufacturer_M_ON_SEMICONDUCTOR                                   KnxManufacturer = 216
	KnxManufacturer_M_LONGCHUANG                                         KnxManufacturer = 217
	KnxManufacturer_M_AIR_ON_AG                                          KnxManufacturer = 218
	KnxManufacturer_M_IB_COMPANY_GMBH                                    KnxManufacturer = 219
	KnxManufacturer_M_SATION_FACTORY                                     KnxManufacturer = 220
	KnxManufacturer_M_AGENTILO_GMBH                                      KnxManufacturer = 221
	KnxManufacturer_M_MAKEL_ELEKTRIK                                     KnxManufacturer = 222
	KnxManufacturer_M_HELIOS_VENTILATOREN                                KnxManufacturer = 223
	KnxManufacturer_M_OTTO_SOLUTIONS_PTE_LTD                             KnxManufacturer = 224
	KnxManufacturer_M_AIRMASTER                                          KnxManufacturer = 225
	KnxManufacturer_M_VALLOX_GMBH                                        KnxManufacturer = 226
	KnxManufacturer_M_DALITEK                                            KnxManufacturer = 227
	KnxManufacturer_M_ASIN                                               KnxManufacturer = 228
	KnxManufacturer_M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_               KnxManufacturer = 229
	KnxManufacturer_M_ARBONIA                                            KnxManufacturer = 230
	KnxManufacturer_M_KERMI                                              KnxManufacturer = 231
	KnxManufacturer_M_PROLUX                                             KnxManufacturer = 232
	KnxManufacturer_M_CLICHOME                                           KnxManufacturer = 233
	KnxManufacturer_M_COMMAX                                             KnxManufacturer = 234
	KnxManufacturer_M_EAE                                                KnxManufacturer = 235
	KnxManufacturer_M_TENSE                                              KnxManufacturer = 236
	KnxManufacturer_M_SEYOUNG_ELECTRONICS                                KnxManufacturer = 237
	KnxManufacturer_M_LIFEDOMUS                                          KnxManufacturer = 238
	KnxManufacturer_M_EUROTRONIC_TECHNOLOGY_GMBH                         KnxManufacturer = 239
	KnxManufacturer_M_TCI                                                KnxManufacturer = 240
	KnxManufacturer_M_RISHUN_ELECTRONIC                                  KnxManufacturer = 241
	KnxManufacturer_M_ZIPATO                                             KnxManufacturer = 242
	KnxManufacturer_M_CM_SECURITY_GMBH_AND_CO_KG                         KnxManufacturer = 243
	KnxManufacturer_M_QING_CABLES                                        KnxManufacturer = 244
	KnxManufacturer_M_WOLF                                               KnxManufacturer = 245
	KnxManufacturer_M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_              KnxManufacturer = 246
	KnxManufacturer_M_E_G_E                                              KnxManufacturer = 247
	KnxManufacturer_M_NETXAUTOMATION                                     KnxManufacturer = 248
	KnxManufacturer_M_TECALOR                                            KnxManufacturer = 249
	KnxManufacturer_M_URMET_ELECTRONICS_HUIZHOU_LTD_                     KnxManufacturer = 250
	KnxManufacturer_M_PEIYING_BUILDING_CONTROL                           KnxManufacturer = 251
	KnxManufacturer_M_BPT_S_P_A__A_SOCIO_UNICO                           KnxManufacturer = 252
	KnxManufacturer_M_KANONTEC___KANONBUS                                KnxManufacturer = 253
	KnxManufacturer_M_ISER_TECH                                          KnxManufacturer = 254
	KnxManufacturer_M_FINELINE                                           KnxManufacturer = 255
	KnxManufacturer_M_CP_ELECTRONICS_LTD                                 KnxManufacturer = 256
	KnxManufacturer_M_NIKO_SERVODAN_AS                                   KnxManufacturer = 257
	KnxManufacturer_M_SIMON_309                                          KnxManufacturer = 258
	KnxManufacturer_M_GM_MODULAR_PVT__LTD_                               KnxManufacturer = 259
	KnxManufacturer_M_FU_CHENG_INTELLIGENCE                              KnxManufacturer = 260
	KnxManufacturer_M_NEXKON                                             KnxManufacturer = 261
	KnxManufacturer_M_FEEL_S_R_L                                         KnxManufacturer = 262
	KnxManufacturer_M_NOT_ASSIGNED_314                                   KnxManufacturer = 263
	KnxManufacturer_M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_     KnxManufacturer = 264
	KnxManufacturer_M_JIUZHOU_GREEBLE                                    KnxManufacturer = 265
	KnxManufacturer_M_AUMUELLER_AUMATIC_GMBH                             KnxManufacturer = 266
	KnxManufacturer_M_ETMAN_ELECTRIC                                     KnxManufacturer = 267
	KnxManufacturer_M_BLACK_NOVA                                         KnxManufacturer = 268
	KnxManufacturer_M_ZIDATECH_AG                                        KnxManufacturer = 269
	KnxManufacturer_M_IDGS_BVBA                                          KnxManufacturer = 270
	KnxManufacturer_M_DAKANIMO                                           KnxManufacturer = 271
	KnxManufacturer_M_TREBOR_AUTOMATION_AB                               KnxManufacturer = 272
	KnxManufacturer_M_SATEL_SP__Z_O_O_                                   KnxManufacturer = 273
	KnxManufacturer_M_RUSSOUND__INC_                                     KnxManufacturer = 274
	KnxManufacturer_M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD     KnxManufacturer = 275
	KnxManufacturer_M_CONSORZIO_TERRANUOVA                               KnxManufacturer = 276
	KnxManufacturer_M_WOLF_HEIZTECHNIK_GMBH                              KnxManufacturer = 277
	KnxManufacturer_M_SONTEC                                             KnxManufacturer = 278
	KnxManufacturer_M_BELCOM_CABLES_LTD_                                 KnxManufacturer = 279
	KnxManufacturer_M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_ KnxManufacturer = 280
	KnxManufacturer_M_ACREL                                              KnxManufacturer = 281
	KnxManufacturer_M_KWC_AQUAROTTER_GMBH                                KnxManufacturer = 282
	KnxManufacturer_M_ORION_SYSTEMS                                      KnxManufacturer = 283
	KnxManufacturer_M_SCHRACK_TECHNIK_GMBH                               KnxManufacturer = 284
	KnxManufacturer_M_INSPRID                                            KnxManufacturer = 285
	KnxManufacturer_M_SUNRICHER                                          KnxManufacturer = 286
	KnxManufacturer_M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_          KnxManufacturer = 287
	KnxManufacturer_M_AUREX                                              KnxManufacturer = 288
	KnxManufacturer_M_JOSEF_BARTHELME_GMBH_AND_CO__KG                    KnxManufacturer = 289
	KnxManufacturer_M_ARCHITECTURE_NUMERIQUE                             KnxManufacturer = 290
	KnxManufacturer_M_UP_GROUP                                           KnxManufacturer = 291
	KnxManufacturer_M_TEKNOS_AVINNO                                      KnxManufacturer = 292
	KnxManufacturer_M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY    KnxManufacturer = 293
	KnxManufacturer_M_THERMOKON_SENSORTECHNIK_GMBH                       KnxManufacturer = 294
	KnxManufacturer_M_BELIMO_AUTOMATION_AG                               KnxManufacturer = 295
	KnxManufacturer_M_ZEHNDER_GROUP_INTERNATIONAL_AG                     KnxManufacturer = 296
	KnxManufacturer_M_SKS_KINKEL_ELEKTRONIK                              KnxManufacturer = 297
	KnxManufacturer_M_ECE_WURMITZER_GMBH                                 KnxManufacturer = 298
	KnxManufacturer_M_LARS                                               KnxManufacturer = 299
	KnxManufacturer_M_URC                                                KnxManufacturer = 300
	KnxManufacturer_M_LIGHTCONTROL                                       KnxManufacturer = 301
	KnxManufacturer_M_SHENZHEN_YM                                        KnxManufacturer = 302
	KnxManufacturer_M_MEAN_WELL_ENTERPRISES_CO__LTD_                     KnxManufacturer = 303
	KnxManufacturer_M_OSIX                                               KnxManufacturer = 304
	KnxManufacturer_M_AYPRO_TECHNOLOGY                                   KnxManufacturer = 305
	KnxManufacturer_M_HEFEI_ECOLITE_SOFTWARE                             KnxManufacturer = 306
	KnxManufacturer_M_ENNO                                               KnxManufacturer = 307
	KnxManufacturer_M_OHOSURE                                            KnxManufacturer = 308
	KnxManufacturer_M_GAREFOWL                                           KnxManufacturer = 309
	KnxManufacturer_M_GEZE                                               KnxManufacturer = 310
	KnxManufacturer_M_LG_ELECTRONICS_INC_                                KnxManufacturer = 311
	KnxManufacturer_M_SMC_INTERIORS                                      KnxManufacturer = 312
	KnxManufacturer_M_NOT_ASSIGNED_364                                   KnxManufacturer = 313
	KnxManufacturer_M_SCS_CABLE                                          KnxManufacturer = 314
	KnxManufacturer_M_HOVAL                                              KnxManufacturer = 315
	KnxManufacturer_M_CANST                                              KnxManufacturer = 316
	KnxManufacturer_M_HANGZHOU_BERLIN                                    KnxManufacturer = 317
	KnxManufacturer_M_EVN_LICHTTECHNIK                                   KnxManufacturer = 318
	KnxManufacturer_M_RUTEC                                              KnxManufacturer = 319
	KnxManufacturer_M_FINDER                                             KnxManufacturer = 320
	KnxManufacturer_M_FUJITSU_GENERAL_LIMITED                            KnxManufacturer = 321
	KnxManufacturer_M_ZF_FRIEDRICHSHAFEN_AG                              KnxManufacturer = 322
	KnxManufacturer_M_CREALED                                            KnxManufacturer = 323
	KnxManufacturer_M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED             KnxManufacturer = 324
	KnxManufacturer_M_EPlus                                              KnxManufacturer = 325
	KnxManufacturer_M_ITALCOND                                           KnxManufacturer = 326
	KnxManufacturer_M_SATION                                             KnxManufacturer = 327
	KnxManufacturer_M_NEWBEST                                            KnxManufacturer = 328
	KnxManufacturer_M_GDS_DIGITAL_SYSTEMS                                KnxManufacturer = 329
	KnxManufacturer_M_IDDERO                                             KnxManufacturer = 330
	KnxManufacturer_M_MBNLED                                             KnxManufacturer = 331
	KnxManufacturer_M_VITRUM                                             KnxManufacturer = 332
	KnxManufacturer_M_EKEY_BIOMETRIC_SYSTEMS_GMBH                        KnxManufacturer = 333
	KnxManufacturer_M_AMC                                                KnxManufacturer = 334
	KnxManufacturer_M_TRILUX_GMBH_AND_CO__KG                             KnxManufacturer = 335
	KnxManufacturer_M_WEXCEDO                                            KnxManufacturer = 336
	KnxManufacturer_M_VEMER_SPA                                          KnxManufacturer = 337
	KnxManufacturer_M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG                   KnxManufacturer = 338
	KnxManufacturer_M_CITRON                                             KnxManufacturer = 339
	KnxManufacturer_M_SHENZHEN_HEGUANG                                   KnxManufacturer = 340
	KnxManufacturer_M_NOT_ASSIGNED_392                                   KnxManufacturer = 341
	KnxManufacturer_M_TRANE_B_V_B_A                                      KnxManufacturer = 342
	KnxManufacturer_M_CAREL                                              KnxManufacturer = 343
	KnxManufacturer_M_PROLITE_CONTROLS                                   KnxManufacturer = 344
	KnxManufacturer_M_BOSMER                                             KnxManufacturer = 345
	KnxManufacturer_M_EUCHIPS                                            KnxManufacturer = 346
	KnxManufacturer_M_CONNECT_THINKA_CONNECT                             KnxManufacturer = 347
	KnxManufacturer_M_PEAKNX_A_DOGAWIST_COMPANY                          KnxManufacturer = 348
	KnxManufacturer_M_ACEMATIC                                           KnxManufacturer = 349
	KnxManufacturer_M_ELAUSYS                                            KnxManufacturer = 350
	KnxManufacturer_M_ITK_ENGINEERING_AG                                 KnxManufacturer = 351
	KnxManufacturer_M_INTEGRA_METERING_AG                                KnxManufacturer = 352
	KnxManufacturer_M_FMS_HOSPITALITY_PTE_LTD                            KnxManufacturer = 353
	KnxManufacturer_M_NUVO                                               KnxManufacturer = 354
	KnxManufacturer_M_U__LUX_GMBH                                        KnxManufacturer = 355
	KnxManufacturer_M_BRUMBERG_LEUCHTEN                                  KnxManufacturer = 356
	KnxManufacturer_M_LIME                                               KnxManufacturer = 357
	KnxManufacturer_M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_         KnxManufacturer = 358
	KnxManufacturer_M_KAVOSHPISHRO_ASIA                                  KnxManufacturer = 359
	KnxManufacturer_M_V2_SPA                                             KnxManufacturer = 360
	KnxManufacturer_M_JOHNSON_CONTROLS                                   KnxManufacturer = 361
	KnxManufacturer_M_ARKUD                                              KnxManufacturer = 362
	KnxManufacturer_M_IRIDI_LTD_                                         KnxManufacturer = 363
	KnxManufacturer_M_BSMART                                             KnxManufacturer = 364
	KnxManufacturer_M_BAB_TECHNOLOGIE_GMBH                               KnxManufacturer = 365
	KnxManufacturer_M_NICE_SPA                                           KnxManufacturer = 366
	KnxManufacturer_M_REDFISH_GROUP_PTY_LTD                              KnxManufacturer = 367
	KnxManufacturer_M_SABIANA_SPA                                        KnxManufacturer = 368
	KnxManufacturer_M_UBEE_INTERACTIVE_EUROPE                            KnxManufacturer = 369
	KnxManufacturer_M_REXEL                                              KnxManufacturer = 370
	KnxManufacturer_M_GES_TEKNIK_A_S_                                    KnxManufacturer = 371
	KnxManufacturer_M_AVE_S_P_A_                                         KnxManufacturer = 372
	KnxManufacturer_M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_                  KnxManufacturer = 373
	KnxManufacturer_M_ARCOM                                              KnxManufacturer = 374
	KnxManufacturer_M_VIA_TECHNOLOGIES__INC_                             KnxManufacturer = 375
	KnxManufacturer_M_FEELSMART_                                         KnxManufacturer = 376
	KnxManufacturer_M_SUPCON                                             KnxManufacturer = 377
	KnxManufacturer_M_MANIC                                              KnxManufacturer = 378
	KnxManufacturer_M_TDE_GMBH                                           KnxManufacturer = 379
	KnxManufacturer_M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_     KnxManufacturer = 380
	KnxManufacturer_M_EWTECH                                             KnxManufacturer = 381
	KnxManufacturer_M_KLUGER_AUTOMATION_GMBH                             KnxManufacturer = 382
	KnxManufacturer_M_JOONGANG_CONTROL                                   KnxManufacturer = 383
	KnxManufacturer_M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_                 KnxManufacturer = 384
	KnxManufacturer_M_IME_S_P_A_                                         KnxManufacturer = 385
	KnxManufacturer_M_SICHUAN_HAODING                                    KnxManufacturer = 386
	KnxManufacturer_M_MINDJAGA_LTD_                                      KnxManufacturer = 387
	KnxManufacturer_M_RUILI_SMART_CONTROL                                KnxManufacturer = 388
	KnxManufacturer_M_CODESYS_GMBH                                       KnxManufacturer = 389
	KnxManufacturer_M_MOORGEN_DEUTSCHLAND_GMBH                           KnxManufacturer = 390
	KnxManufacturer_M_CULLMANN_TECH                                      KnxManufacturer = 391
	KnxManufacturer_M_EYRISE_B_V                                         KnxManufacturer = 392
	KnxManufacturer_M_DOBNEL                                             KnxManufacturer = 393
	KnxManufacturer_M_MYGEKKO                                            KnxManufacturer = 394
	KnxManufacturer_M_ERGO3_SARL                                         KnxManufacturer = 395
	KnxManufacturer_M_STMICROELECTRONICS_INTERNATIONAL_N_V_              KnxManufacturer = 396
	KnxManufacturer_M_CJC_SYSTEMS                                        KnxManufacturer = 397
	KnxManufacturer_M_SUDOKU                                             KnxManufacturer = 398
	KnxManufacturer_M_AZ_E_LITE_PTE_LTD                                  KnxManufacturer = 399
	KnxManufacturer_M_ARLIGHT                                            KnxManufacturer = 400
	KnxManufacturer_M_GRUENBECK_WASSERAUFBEREITUNG_GMBH                  KnxManufacturer = 401
	KnxManufacturer_M_MODULE_ELECTRONIC                                  KnxManufacturer = 402
	KnxManufacturer_M_KOPLAT                                             KnxManufacturer = 403
	KnxManufacturer_M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD          KnxManufacturer = 404
	KnxManufacturer_M_ILEVIA                                             KnxManufacturer = 405
	KnxManufacturer_M_LN_SYSTEMTEQ                                       KnxManufacturer = 406
	KnxManufacturer_M_HISENSE_SMARTHOME                                  KnxManufacturer = 407
	KnxManufacturer_M_FLINK_AUTOMATION_SYSTEM                            KnxManufacturer = 408
	KnxManufacturer_M_XXTER_BV                                           KnxManufacturer = 409
	KnxManufacturer_M_LYNXUS_TECHNOLOGY                                  KnxManufacturer = 410
	KnxManufacturer_M_ROBOT_S_A_                                         KnxManufacturer = 411
	KnxManufacturer_M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_                  KnxManufacturer = 412
	KnxManufacturer_M_NOBLESSE                                           KnxManufacturer = 413
	KnxManufacturer_M_ADVANCED_DEVICES                                   KnxManufacturer = 414
	KnxManufacturer_M_ATRINA_BUILDING_AUTOMATION_CO__LTD                 KnxManufacturer = 415
	KnxManufacturer_M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_         KnxManufacturer = 416
	KnxManufacturer_M_WESTERSTRAND_URFABRIK_AB                           KnxManufacturer = 417
	KnxManufacturer_M_CONTROL4_CORPORATE                                 KnxManufacturer = 418
	KnxManufacturer_M_ONTROL                                             KnxManufacturer = 419
	KnxManufacturer_M_STARNET                                            KnxManufacturer = 420
	KnxManufacturer_M_BETA_CAVI                                          KnxManufacturer = 421
	KnxManufacturer_M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_                KnxManufacturer = 422
	KnxManufacturer_M_VIVALDI_SRL                                        KnxManufacturer = 423
	KnxManufacturer_M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI            KnxManufacturer = 424
	KnxManufacturer_M_HWISCON                                            KnxManufacturer = 425
	KnxManufacturer_M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_   KnxManufacturer = 426
	KnxManufacturer_M_KAMPMANN                                           KnxManufacturer = 427
	KnxManufacturer_M_IMPOLUX_GMBH_LEDIMAX                               KnxManufacturer = 428
	KnxManufacturer_M_EVAUX                                              KnxManufacturer = 429
	KnxManufacturer_M_WEBRO_CABLES_AND_CONNECTORS_LIMITED                KnxManufacturer = 430
	KnxManufacturer_M_SHANGHAI_E_TECH_SOLUTION                           KnxManufacturer = 431
	KnxManufacturer_M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_                   KnxManufacturer = 432
	KnxManufacturer_M_LAMMIN_HIGH_TECH_CO__LTD                           KnxManufacturer = 433
	KnxManufacturer_M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD              KnxManufacturer = 434
	KnxManufacturer_M_I_LUXUS                                            KnxManufacturer = 435
	KnxManufacturer_M_ELMOS_SEMICONDUCTOR_AG                             KnxManufacturer = 436
	KnxManufacturer_M_EMCOM_TECHNOLOGY_INC                               KnxManufacturer = 437
	KnxManufacturer_M_PROJECT_INNOVATIONS_GMBH                           KnxManufacturer = 438
	KnxManufacturer_M_ITC                                                KnxManufacturer = 439
	KnxManufacturer_M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING KnxManufacturer = 440
	KnxManufacturer_M_MAICO                                              KnxManufacturer = 441
	KnxManufacturer_M_ELAN_SRL                                           KnxManufacturer = 442
	KnxManufacturer_M_MINHHA_TECHNOLOGY_CO__LTD                          KnxManufacturer = 443
	KnxManufacturer_M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_                  KnxManufacturer = 444
	KnxManufacturer_M_IAUTOMATION_PTY_LIMITED                            KnxManufacturer = 445
	KnxManufacturer_M_EXTRON                                             KnxManufacturer = 446
	KnxManufacturer_M_FREEDOMPRO                                         KnxManufacturer = 447
	KnxManufacturer_M_ONEHOME                                            KnxManufacturer = 448
	KnxManufacturer_M_EOS_SAUNATECHNIK_GMBH                              KnxManufacturer = 449
	KnxManufacturer_M_KUSATEK_GMBH                                       KnxManufacturer = 450
	KnxManufacturer_M_ALEXANDER_MAIER_GMBH                               KnxManufacturer = 451
	KnxManufacturer_M_AUTOMATISMI_BENINCA_S_P_A_                         KnxManufacturer = 452
	KnxManufacturer_M_BLENDOM                                            KnxManufacturer = 453
	KnxManufacturer_M_MADEL_AIR_TECHNICAL_DIFFUSION                      KnxManufacturer = 454
	KnxManufacturer_M_NIKO                                               KnxManufacturer = 455
	KnxManufacturer_M_BOSCH_REXROTH_AG                                   KnxManufacturer = 456
	KnxManufacturer_M_CANDM_PRODUCTS                                     KnxManufacturer = 457
	KnxManufacturer_M_HOERMANN_KG_VERKAUFSGESELLSCHAFT                   KnxManufacturer = 458
	KnxManufacturer_M_SHANGHAI_RAJAYASA_CO__LTD                          KnxManufacturer = 459
	KnxManufacturer_M_SUZUKI                                             KnxManufacturer = 460
	KnxManufacturer_M_SILENT_GLISS_INTERNATIONAL_LTD_                    KnxManufacturer = 461
	KnxManufacturer_M_BEE_CONTROLS_ADGSC_GROUP                           KnxManufacturer = 462
	KnxManufacturer_M_XDTECGMBH                                          KnxManufacturer = 463
	KnxManufacturer_M_OSRAM                                              KnxManufacturer = 464
	KnxManufacturer_M_LEBENOR                                            KnxManufacturer = 465
	KnxManufacturer_M_AUTOMANENG                                         KnxManufacturer = 466
	KnxManufacturer_M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD   KnxManufacturer = 467
	KnxManufacturer_M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD   KnxManufacturer = 468
	KnxManufacturer_M_ETA_HEIZTECHNIK                                    KnxManufacturer = 469
	KnxManufacturer_M_DIVUS_GMBH                                         KnxManufacturer = 470
	KnxManufacturer_M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_  KnxManufacturer = 471
	KnxManufacturer_M_LUNATONE                                           KnxManufacturer = 472
	KnxManufacturer_M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT               KnxManufacturer = 473
	KnxManufacturer_M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_                   KnxManufacturer = 474
	KnxManufacturer_M_NOKE                                               KnxManufacturer = 475
	KnxManufacturer_M_LANDCOM                                            KnxManufacturer = 476
	KnxManufacturer_M_STORK_AS                                           KnxManufacturer = 477
	KnxManufacturer_M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_               KnxManufacturer = 478
	KnxManufacturer_M_COOLAUTOMATION                                     KnxManufacturer = 479
	KnxManufacturer_M_APRSTERN                                           KnxManufacturer = 480
	KnxManufacturer_M_SONNEN                                             KnxManufacturer = 481
	KnxManufacturer_M_DNAKE                                              KnxManufacturer = 482
	KnxManufacturer_M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH                  KnxManufacturer = 483
	KnxManufacturer_M_STILIGER                                           KnxManufacturer = 484
	KnxManufacturer_M_BERGHOF_AUTOMATION_GMBH                            KnxManufacturer = 485
	KnxManufacturer_M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH                 KnxManufacturer = 486
	KnxManufacturer_M_DOVIT                                              KnxManufacturer = 487
	KnxManufacturer_M_INSTALIGHTING_GMBH                                 KnxManufacturer = 488
	KnxManufacturer_M_UNI_TEC                                            KnxManufacturer = 489
	KnxManufacturer_M_CASATUNES                                          KnxManufacturer = 490
	KnxManufacturer_M_EMT                                                KnxManufacturer = 491
	KnxManufacturer_M_SENFFICIENT                                        KnxManufacturer = 492
	KnxManufacturer_M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED        KnxManufacturer = 493
	KnxManufacturer_M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_              KnxManufacturer = 494
	KnxManufacturer_M_SAMSON_ELECTRIC_WIRE                               KnxManufacturer = 495
	KnxManufacturer_M_T_TOUCHING                                         KnxManufacturer = 496
	KnxManufacturer_M_CORE_SMART_HOME                                    KnxManufacturer = 497
	KnxManufacturer_M_GREENCONNECT_SOLUTIONS_SA                          KnxManufacturer = 498
	KnxManufacturer_M_ELETTRONICA_CONDUTTORI                             KnxManufacturer = 499
	KnxManufacturer_M_MKFC                                               KnxManufacturer = 500
	KnxManufacturer_M_AUTOMATIONPlus                                     KnxManufacturer = 501
	KnxManufacturer_M_BLUE_AND_RED                                       KnxManufacturer = 502
	KnxManufacturer_M_FROGBLUE                                           KnxManufacturer = 503
	KnxManufacturer_M_LUXIO                                              KnxManufacturer = 504
	KnxManufacturer_M_APP_TECH                                           KnxManufacturer = 505
	KnxManufacturer_M_SENSORTEC_AG                                       KnxManufacturer = 506
	KnxManufacturer_M_NYSA_TECHNOLOGY_AND_SOLUTIONS                      KnxManufacturer = 507
	KnxManufacturer_M_FARADITE                                           KnxManufacturer = 508
	KnxManufacturer_M_OPTIMUS                                            KnxManufacturer = 509
	KnxManufacturer_M_KTS_S_R_L_                                         KnxManufacturer = 510
	KnxManufacturer_M_RAMCRO_SPA                                         KnxManufacturer = 511
	KnxManufacturer_M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD      KnxManufacturer = 512
	KnxManufacturer_M_BEMI_SMART_HOME_LTD                                KnxManufacturer = 513
	KnxManufacturer_M_ARDOMUS                                            KnxManufacturer = 514
	KnxManufacturer_M_CHANGXING                                          KnxManufacturer = 515
	KnxManufacturer_M_E_CONTROLS                                         KnxManufacturer = 516
	KnxManufacturer_M_AIB_TECHNOLOGY                                     KnxManufacturer = 517
	KnxManufacturer_M_NVC                                                KnxManufacturer = 518
	KnxManufacturer_M_KBOX                                               KnxManufacturer = 519
	KnxManufacturer_M_CNS                                                KnxManufacturer = 520
	KnxManufacturer_M_TYBA                                               KnxManufacturer = 521
	KnxManufacturer_M_ATREL                                              KnxManufacturer = 522
	KnxManufacturer_M_SIMON_ELECTRIC_CHINA_CO___LTD                      KnxManufacturer = 523
	KnxManufacturer_M_KORDZ_GROUP                                        KnxManufacturer = 524
	KnxManufacturer_M_ND_ELECTRIC                                        KnxManufacturer = 525
	KnxManufacturer_M_CONTROLIUM                                         KnxManufacturer = 526
	KnxManufacturer_M_FAMO_GMBH_AND_CO__KG                               KnxManufacturer = 527
	KnxManufacturer_M_CDN_SMART                                          KnxManufacturer = 528
	KnxManufacturer_M_HESTON                                             KnxManufacturer = 529
	KnxManufacturer_M_ESLA_CONEXIONES_S_L_                               KnxManufacturer = 530
	KnxManufacturer_M_WEISHAUPT                                          KnxManufacturer = 531
	KnxManufacturer_M_ASTRUM_TECHNOLOGY                                  KnxManufacturer = 532
	KnxManufacturer_M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_            KnxManufacturer = 533
	KnxManufacturer_M_NANOTECO_CORPORATION                               KnxManufacturer = 534
	KnxManufacturer_M_NIETIAN                                            KnxManufacturer = 535
	KnxManufacturer_M_SUMSIR                                             KnxManufacturer = 536
	KnxManufacturer_M_ORBIS_TECNOLOGIA_ELECTRICA_SA                      KnxManufacturer = 537
	KnxManufacturer_M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_           KnxManufacturer = 538
	KnxManufacturer_M_ANLIPS                                             KnxManufacturer = 539
	KnxManufacturer_M_GUANGDONG_PAK_CORPORATION_CO___LTD                 KnxManufacturer = 540
	KnxManufacturer_M_BVK_TECHNOLOGY                                     KnxManufacturer = 541
	KnxManufacturer_M_SOLOMIO_SRL                                        KnxManufacturer = 542
	KnxManufacturer_M_DOMOTICA_LABS                                      KnxManufacturer = 543
	KnxManufacturer_M_NVC_INTERNATIONAL                                  KnxManufacturer = 544
	KnxManufacturer_M_BA                                                 KnxManufacturer = 545
	KnxManufacturer_M_IRIS_CERAMICA_GROUP                                KnxManufacturer = 546
	KnxManufacturer_M_WIREEO                                             KnxManufacturer = 547
	KnxManufacturer_M_NVCLIGHTING                                        KnxManufacturer = 548
	KnxManufacturer_M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_     KnxManufacturer = 549
	KnxManufacturer_M_ARMITI_TRADING                                     KnxManufacturer = 550
	KnxManufacturer_M_ELEK                                               KnxManufacturer = 551
	KnxManufacturer_M_ACCORDIA_SA                                        KnxManufacturer = 552
	KnxManufacturer_M_OURICAN                                            KnxManufacturer = 553
	KnxManufacturer_M_INLIWOSE                                           KnxManufacturer = 554
	KnxManufacturer_M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_          KnxManufacturer = 555
	KnxManufacturer_M_SHK_KNX                                            KnxManufacturer = 556
	KnxManufacturer_M_AMPIO                                              KnxManufacturer = 557
	KnxManufacturer_M_MINGXING_WISDOM                                    KnxManufacturer = 558
	KnxManufacturer_M_ALTEN_SW_GMBH                                      KnxManufacturer = 559
	KnxManufacturer_M_V_Y_C_SRL                                          KnxManufacturer = 560
	KnxManufacturer_M_TERMINUS_GROUP                                     KnxManufacturer = 561
	KnxManufacturer_M_WONDERFUL_CITY_TECHNOLOGY                          KnxManufacturer = 562
	KnxManufacturer_M_QBICTECHNOLOGY                                     KnxManufacturer = 563
	KnxManufacturer_M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED     KnxManufacturer = 564
	KnxManufacturer_M_ONEWORK                                            KnxManufacturer = 565
	KnxManufacturer_M_PL_LINK                                            KnxManufacturer = 566
	KnxManufacturer_M_FASEL_GMBH_ELEKTRONIK                              KnxManufacturer = 567
	KnxManufacturer_M_GOLDENHOME_SMART                                   KnxManufacturer = 568
	KnxManufacturer_M_GOLDMEDAL                                          KnxManufacturer = 569
	KnxManufacturer_M_CannX                                              KnxManufacturer = 570
	KnxManufacturer_M_EGI___EARTH_GOODNESS                               KnxManufacturer = 571
	KnxManufacturer_M_VIEGA_GMBH_AND_CO__KG                              KnxManufacturer = 572
	KnxManufacturer_M_FREDON_DIGITAL_BUILDINGS                           KnxManufacturer = 573
	KnxManufacturer_M_HELUKABEL_THAILAND_CO__LTD_                        KnxManufacturer = 574
	KnxManufacturer_M_SICS                                               KnxManufacturer = 575
	KnxManufacturer_M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD          KnxManufacturer = 576
	KnxManufacturer_M_SUMAMO                                             KnxManufacturer = 577
	KnxManufacturer_M_SVIT                                               KnxManufacturer = 578
	KnxManufacturer_M_TECGET                                             KnxManufacturer = 579
	KnxManufacturer_M_XEROPOINT                                          KnxManufacturer = 580
	KnxManufacturer_M_HONEYWELL_BUILDING_TECHNOLOGIES                    KnxManufacturer = 581
	KnxManufacturer_M_COMFORTCLICK                                       KnxManufacturer = 582
	KnxManufacturer_M_DORBAS_ELECTRIC                                    KnxManufacturer = 583
	KnxManufacturer_M_REMKO_GMBH_AND_CO__KG                              KnxManufacturer = 584
	KnxManufacturer_M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD   KnxManufacturer = 585
	KnxManufacturer_M_ANDAS                                              KnxManufacturer = 586
	KnxManufacturer_M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD    KnxManufacturer = 587
	KnxManufacturer_M_LARFE                                              KnxManufacturer = 588
	KnxManufacturer_M_DONGGUAN_MUHCCI_ELECTRICAL                         KnxManufacturer = 589
	KnxManufacturer_M_STEC                                               KnxManufacturer = 590
	KnxManufacturer_M_ARIGO_SOFTWARE_GMBH                                KnxManufacturer = 591
	KnxManufacturer_M_FEISHELEC                                          KnxManufacturer = 592
	KnxManufacturer_M_GORDIC                                             KnxManufacturer = 593
	KnxManufacturer_M_DELTA_ELECTRONICS                                  KnxManufacturer = 594
	KnxManufacturer_M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_     KnxManufacturer = 595
	KnxManufacturer_M_KG_POWER                                           KnxManufacturer = 596
	KnxManufacturer_M_ZHEJIANG_MOORGEN_GROUP_CO__LTD                     KnxManufacturer = 597
	KnxManufacturer_M_GUANGDONG_KANWAY                                   KnxManufacturer = 598
	KnxManufacturer_M_RAMIREZ_ENGINEERING_GMBH                           KnxManufacturer = 599
	KnxManufacturer_M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD                KnxManufacturer = 600
	KnxManufacturer_M_VIHAN_ELECTRIC_PVT_LTD                             KnxManufacturer = 601
	KnxManufacturer_M_SPLENDID_MINDS_GMBH                                KnxManufacturer = 602
	KnxManufacturer_M_ESTADA                                             KnxManufacturer = 603
	KnxManufacturer_M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI            KnxManufacturer = 604
	KnxManufacturer_M_STUHL_REGELSYSTEME_GMBH                            KnxManufacturer = 605
	KnxManufacturer_M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD                 KnxManufacturer = 606
	KnxManufacturer_M_GAIMEX                                             KnxManufacturer = 607
	KnxManufacturer_M_B3_INTERNATIONAL_S_R_L                             KnxManufacturer = 608
	KnxManufacturer_M_MM_ELECTRO                                         KnxManufacturer = 609
	KnxManufacturer_M_CASCODA                                            KnxManufacturer = 610
	KnxManufacturer_M_XIAMEN_INTRETECH_INC_                              KnxManufacturer = 611
	KnxManufacturer_M_KILOELEC_TECHNOLOGY                                KnxManufacturer = 612
	KnxManufacturer_M_INYX                                               KnxManufacturer = 613
	KnxManufacturer_M_SMART_BUILDING_SERVICES_GMBH                       KnxManufacturer = 614
	KnxManufacturer_M_BSS_GMBH                                           KnxManufacturer = 615
	KnxManufacturer_M_LUMI_ELECTRONICS                                   KnxManufacturer = 616
	KnxManufacturer_M_OJEAELECTRONICS                                    KnxManufacturer = 617
	KnxManufacturer_M_SMART_NODE                                         KnxManufacturer = 618
	KnxManufacturer_M_NEXHOME                                            KnxManufacturer = 619
	KnxManufacturer_M_HUOTENG_WULIAN_JIANGSU_CO___LTD                    KnxManufacturer = 620
	KnxManufacturer_M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD                   KnxManufacturer = 621
	KnxManufacturer_M_BITS_AND_BYTES                                     KnxManufacturer = 622
	KnxManufacturer_M_KFV_SIEGENIA_GRUPPE                                KnxManufacturer = 623
	KnxManufacturer_M_SYMCON                                             KnxManufacturer = 624
	KnxManufacturer_M_I_TRUST                                            KnxManufacturer = 625
	KnxManufacturer_M_DRD_TECHNICS                                       KnxManufacturer = 626
	KnxManufacturer_M_LENGEN                                             KnxManufacturer = 627
	KnxManufacturer_M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD                KnxManufacturer = 628
	KnxManufacturer_M_VIBROXX_FZCO                                       KnxManufacturer = 629
	KnxManufacturer_M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD      KnxManufacturer = 630
	KnxManufacturer_M_PASSIV_ENERGIE_GMBH                                KnxManufacturer = 631
	KnxManufacturer_M_PAYNE_TECHNOLOGIES_LTD                             KnxManufacturer = 632
	KnxManufacturer_M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_  KnxManufacturer = 633
	KnxManufacturer_M_SEXANKA                                            KnxManufacturer = 634
	KnxManufacturer_M_SECURI_FLEX_LTD                                    KnxManufacturer = 635
	KnxManufacturer_M_BOKE                                               KnxManufacturer = 636
	KnxManufacturer_M_SBR_SYSTEM_TECHNICAL                               KnxManufacturer = 637
	KnxManufacturer_M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_             KnxManufacturer = 638
	KnxManufacturer_M_BOLATU                                             KnxManufacturer = 639
	KnxManufacturer_M_RECBER_KABLO_A_S_                                  KnxManufacturer = 640
	KnxManufacturer_M_ILITE_KNX                                          KnxManufacturer = 641
	KnxManufacturer_M_LAZZEN                                             KnxManufacturer = 642
	KnxManufacturer_M_MOX_CONTROL_IT_CHINA_LIMITED                       KnxManufacturer = 643
	KnxManufacturer_M_CLOWIRE                                            KnxManufacturer = 644
	KnxManufacturer_M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD                KnxManufacturer = 645
	KnxManufacturer_M_NS_TOUCH                                           KnxManufacturer = 646
	KnxManufacturer_M_ROOMIO                                             KnxManufacturer = 647
	KnxManufacturer_M_ATOUCH                                             KnxManufacturer = 648
	KnxManufacturer_M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD            KnxManufacturer = 649
	KnxManufacturer_M_WALLYONS                                           KnxManufacturer = 650
	KnxManufacturer_M_ZIMMEX                                             KnxManufacturer = 651
	KnxManufacturer_M_RHOMBUS_EUROPE                                     KnxManufacturer = 652
	KnxManufacturer_M_TURING_THINK                                       KnxManufacturer = 653
	KnxManufacturer_M_MICHOI                                             KnxManufacturer = 654
	KnxManufacturer_M_CAV_SMARTGUANGZHOUCO__LTD                          KnxManufacturer = 655
	KnxManufacturer_M_HELKAMA_BICA_OY                                    KnxManufacturer = 656
	KnxManufacturer_M_MODULYTE                                           KnxManufacturer = 657
	KnxManufacturer_M_CONSOLINNO_ENERGY_GMBH                             KnxManufacturer = 658
	KnxManufacturer_M_SCHIDERON_ELECTRIC_ASIA_LIMITED                    KnxManufacturer = 659
	KnxManufacturer_M_3R                                                 KnxManufacturer = 660
	KnxManufacturer_M_ARKLYFE                                            KnxManufacturer = 661
	KnxManufacturer_M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_          KnxManufacturer = 662
	KnxManufacturer_M_KNXES_COMPANY_LIMITED                              KnxManufacturer = 663
	KnxManufacturer_M_AKUVOX                                             KnxManufacturer = 664
	KnxManufacturer_M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_    KnxManufacturer = 665
	KnxManufacturer_M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD          KnxManufacturer = 666
	KnxManufacturer_M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD               KnxManufacturer = 667
	KnxManufacturer_M_MUTLUSAN_ELECTRIC                                  KnxManufacturer = 668
	KnxManufacturer_M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_             KnxManufacturer = 669
	KnxManufacturer_M_MARLEY_DEUTSCHLAND_GMBH                            KnxManufacturer = 670
	KnxManufacturer_M_CREATROL                                           KnxManufacturer = 671
	KnxManufacturer_M_EUTELSAT                                           KnxManufacturer = 672
	KnxManufacturer_M_TECNIKABEL                                         KnxManufacturer = 673
	KnxManufacturer_M_ATIOS_AG                                           KnxManufacturer = 674
	KnxManufacturer_M_SMARTLICHT                                         KnxManufacturer = 675
	KnxManufacturer_M_BEIJING_BEVONE_ELECTRIC_CO__LTD_                   KnxManufacturer = 676
	KnxManufacturer_M_ELSMART                                            KnxManufacturer = 677
	KnxManufacturer_M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC            KnxManufacturer = 678
	KnxManufacturer_M_HANGZHOU_SANYUAN_CABLE_CO___LTD                    KnxManufacturer = 679
	KnxManufacturer_M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_             KnxManufacturer = 680
	KnxManufacturer_M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_                KnxManufacturer = 681
	KnxManufacturer_M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD           KnxManufacturer = 682
	KnxManufacturer_M_VITRUM_DESIGN                                      KnxManufacturer = 683
	KnxManufacturer_M_DETRONS                                            KnxManufacturer = 684
	KnxManufacturer_M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD   KnxManufacturer = 685
	KnxManufacturer_M_VARNI_DIGITAL_PRIVATE_LIMITED                      KnxManufacturer = 686
	KnxManufacturer_M_3A_ENTREPRISE_APS                                  KnxManufacturer = 687
	KnxManufacturer_M_ITALIANA_CONDUTTORI_SRL                            KnxManufacturer = 688
	KnxManufacturer_M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_                  KnxManufacturer = 689
	KnxManufacturer_M_LEDNX                                              KnxManufacturer = 690
	KnxManufacturer_M_EBELONG                                            KnxManufacturer = 691
	KnxManufacturer_M_ASTRA_LED_AG                                       KnxManufacturer = 692
	KnxManufacturer_M_WONDERFUL_HI_TECH_CO___LTD_                        KnxManufacturer = 693
	KnxManufacturer_M_REXLITE_AI_INTEGRATIONS_CO__LTD                    KnxManufacturer = 694
	KnxManufacturer_M_ALLORADO                                           KnxManufacturer = 695
	KnxManufacturer_M_FUZHOU_MILI_TECHNOLOGY_CO___LTD                    KnxManufacturer = 696
	KnxManufacturer_M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD               KnxManufacturer = 697
	KnxManufacturer_M_HYSINE                                             KnxManufacturer = 698
	KnxManufacturer_M_SANTAN                                             KnxManufacturer = 699
	KnxManufacturer_M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD        KnxManufacturer = 700
	KnxManufacturer_M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD     KnxManufacturer = 701
	KnxManufacturer_M_POLAR_BEAR_DESIGN                                  KnxManufacturer = 702
	KnxManufacturer_M_ELESSAN_NV                                         KnxManufacturer = 703
	KnxManufacturer_M_MIR                                                KnxManufacturer = 704
	KnxManufacturer_M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD               KnxManufacturer = 705
	KnxManufacturer_M_LEAX_CONTROLS_CO___LTD_                            KnxManufacturer = 706
	KnxManufacturer_M_ALCAD                                              KnxManufacturer = 707
	KnxManufacturer_M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD         KnxManufacturer = 708
	KnxManufacturer_M_TAOS_ELECTRIC_CO___LTD                             KnxManufacturer = 709
	KnxManufacturer_M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION                 KnxManufacturer = 710
	KnxManufacturer_M_ASAY_Q                                             KnxManufacturer = 711
	KnxManufacturer_M_LAPP                                               KnxManufacturer = 712
	KnxManufacturer_M_ZEROBIT_DYNAMIC                                    KnxManufacturer = 713
	KnxManufacturer_M_HAVELLS                                            KnxManufacturer = 714
	KnxManufacturer_M_MULLER_INTUITIV                                    KnxManufacturer = 715
	KnxManufacturer_M_TASKIT_GMBH                                        KnxManufacturer = 716
	KnxManufacturer_M_COSTER_GROUP                                       KnxManufacturer = 717
	KnxManufacturer_M_NXP_SEMICONDUCTOR                                  KnxManufacturer = 718
	KnxManufacturer_M_COGCONS                                            KnxManufacturer = 719
	KnxManufacturer_M_MICRO_TEK_SRL_F_M_C_TRADE_MARK                     KnxManufacturer = 720
	KnxManufacturer_M_ORENDA_ELECTRIC                                    KnxManufacturer = 721
	KnxManufacturer_M_ERSE_KABLO                                         KnxManufacturer = 722
	KnxManufacturer_M_PRADO_EUROPE_BV                                    KnxManufacturer = 723
	KnxManufacturer_M_E2S_GBR                                            KnxManufacturer = 724
	KnxManufacturer_M_UNITLINK                                           KnxManufacturer = 725
	KnxManufacturer_M_ONNA                                               KnxManufacturer = 726
	KnxManufacturer_M_CENTERSVET_LLC                                     KnxManufacturer = 727
	KnxManufacturer_M_ADVECO_TECHNOLOGY_CO___LTD_                        KnxManufacturer = 728
	KnxManufacturer_M_FR__LUERSSEN_WERFT                                 KnxManufacturer = 729
	KnxManufacturer_M_MYLYR                                              KnxManufacturer = 730
	KnxManufacturer_M_HYUNDAI_HT                                         KnxManufacturer = 731
	KnxManufacturer_M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD            KnxManufacturer = 732
	KnxManufacturer_M_SMATEK_ELECTRONICS_LIMITED                         KnxManufacturer = 733
	KnxManufacturer_M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_          KnxManufacturer = 734
	KnxManufacturer_M_MORELINKS_SMART_HOME                               KnxManufacturer = 735
	KnxManufacturer_M_CIRTX_GMBH                                         KnxManufacturer = 736
	KnxManufacturer_M_QLITE                                              KnxManufacturer = 737
	KnxManufacturer_M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD                   KnxManufacturer = 738
	KnxManufacturer_M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_    KnxManufacturer = 739
	KnxManufacturer_M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD         KnxManufacturer = 740
	KnxManufacturer_M_CONFIO                                             KnxManufacturer = 741
	KnxManufacturer_M_SONIC_TECHNOLOGIES                                 KnxManufacturer = 742
	KnxManufacturer_M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT KnxManufacturer = 743
	KnxManufacturer_M_ABI_SICHERHEITSSYSTEME_GMBH                        KnxManufacturer = 744
	KnxManufacturer_M_RYT                                                KnxManufacturer = 745
	KnxManufacturer_M_AURIGA_SYSTEMS                                     KnxManufacturer = 746
	KnxManufacturer_M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH         KnxManufacturer = 747
	KnxManufacturer_M_GIANFRANCO_SMART_SOLUTIONS_LTD                     KnxManufacturer = 748
	KnxManufacturer_M_ROGERWELL_CONTROL_SYSTEM_LIMITED                   KnxManufacturer = 749
	KnxManufacturer_M_ABB___RESERVED                                     KnxManufacturer = 750
	KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO___RESERVED                    KnxManufacturer = 751
)

var KnxManufacturerValues []KnxManufacturer

func init() {
	_ = errors.New
	KnxManufacturerValues = []KnxManufacturer{
		KnxManufacturer_M_UNKNOWN,
		KnxManufacturer_M_SIEMENS,
		KnxManufacturer_M_ABB,
		KnxManufacturer_M_ALBRECHT_JUNG,
		KnxManufacturer_M_BTICINO,
		KnxManufacturer_M_BERKER,
		KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO,
		KnxManufacturer_M_GIRA_GIERSIEPEN,
		KnxManufacturer_M_HAGER_ELECTRO,
		KnxManufacturer_M_INSTA_GMBH,
		KnxManufacturer_M_LEGRAND_APPAREILLAGE_ELECTRIQUE,
		KnxManufacturer_M_MERTEN,
		KnxManufacturer_M_ABB_SPA_SACE_DIVISION,
		KnxManufacturer_M_SIEDLE_AND_SOEHNE,
		KnxManufacturer_M_EBERLE,
		KnxManufacturer_M_GEWISS,
		KnxManufacturer_M_ALBERT_ACKERMANN,
		KnxManufacturer_M_SCHUPA_GMBH,
		KnxManufacturer_M_ABB_SCHWEIZ,
		KnxManufacturer_M_FELLER,
		KnxManufacturer_M_GLAMOX_AS,
		KnxManufacturer_M_DEHN_AND_SOEHNE,
		KnxManufacturer_M_CRABTREE,
		KnxManufacturer_M_EVOKNX,
		KnxManufacturer_M_PAUL_HOCHKOEPPER,
		KnxManufacturer_M_ALTENBURGER_ELECTRONIC,
		KnxManufacturer_M_GRAESSLIN,
		KnxManufacturer_M_SIMON_42,
		KnxManufacturer_M_VIMAR,
		KnxManufacturer_M_MOELLER_GEBAEUDEAUTOMATION_KG,
		KnxManufacturer_M_ELTAKO,
		KnxManufacturer_M_BOSCH_SIEMENS_HAUSHALTSGERAETE,
		KnxManufacturer_M_RITTO_GMBHANDCO_KG,
		KnxManufacturer_M_POWER_CONTROLS,
		KnxManufacturer_M_ZUMTOBEL,
		KnxManufacturer_M_HOLEC_SYSTEMEN,
		KnxManufacturer_M_PHOENIX_CONTACT,
		KnxManufacturer_M_WAGO_GMBH_AND_CO_KG,
		KnxManufacturer_M_KNXPRESSO,
		KnxManufacturer_M_WIELAND_ELECTRIC,
		KnxManufacturer_M_HERMANN_KLEINHUIS,
		KnxManufacturer_M_STIEBEL_ELTRON,
		KnxManufacturer_M_TEHALIT,
		KnxManufacturer_M_THEBEN_AG,
		KnxManufacturer_M_WILHELM_RUTENBECK,
		KnxManufacturer_M_WINKHAUS,
		KnxManufacturer_M_ROBERT_BOSCH,
		KnxManufacturer_M_SOMFY,
		KnxManufacturer_M_WOERTZ,
		KnxManufacturer_M_VIESSMANN_WERKE,
		KnxManufacturer_M_IMI_HYDRONIC_ENGINEERING,
		KnxManufacturer_M_JOH__VAILLANT,
		KnxManufacturer_M_AMP_DEUTSCHLAND,
		KnxManufacturer_M_BOSCH_THERMOTECHNIK_GMBH,
		KnxManufacturer_M_SEF___ECOTEC,
		KnxManufacturer_M_DORMA_GMBH_Plus_CO__KG,
		KnxManufacturer_M_WINDOWMASTER_AS,
		KnxManufacturer_M_WALTHER_WERKE,
		KnxManufacturer_M_ORAS,
		KnxManufacturer_M_DAETWYLER,
		KnxManufacturer_M_ELECTRAK,
		KnxManufacturer_M_TECHEM,
		KnxManufacturer_M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS,
		KnxManufacturer_M_WHD_WILHELM_HUBER_Plus_SOEHNE,
		KnxManufacturer_M_BISCHOFF_ELEKTRONIK,
		KnxManufacturer_M_JEPAZ,
		KnxManufacturer_M_RTS_AUTOMATION,
		KnxManufacturer_M_EIBMARKT_GMBH,
		KnxManufacturer_M_WAREMA_RENKHOFF_SE,
		KnxManufacturer_M_EELECTRON,
		KnxManufacturer_M_BELDEN_WIRE_AND_CABLE_B_V_,
		KnxManufacturer_M_BECKER_ANTRIEBE_GMBH,
		KnxManufacturer_M_J_STEHLEPlusSOEHNE_GMBH,
		KnxManufacturer_M_AGFEO,
		KnxManufacturer_M_ZENNIO,
		KnxManufacturer_M_TAPKO_TECHNOLOGIES,
		KnxManufacturer_M_HDL,
		KnxManufacturer_M_UPONOR,
		KnxManufacturer_M_SE_LIGHTMANAGEMENT_AG,
		KnxManufacturer_M_ARCUS_EDS,
		KnxManufacturer_M_INTESIS,
		KnxManufacturer_M_HERHOLDT_CONTROLS_SRL,
		KnxManufacturer_M_NIKO_ZUBLIN,
		KnxManufacturer_M_DURABLE_TECHNOLOGIES,
		KnxManufacturer_M_INNOTEAM,
		KnxManufacturer_M_ISE_GMBH,
		KnxManufacturer_M_TEAM_FOR_TRONICS,
		KnxManufacturer_M_CARRIER_SAS,
		KnxManufacturer_M_REMEHA_BV,
		KnxManufacturer_M_ESYLUX,
		KnxManufacturer_M_BASALTE,
		KnxManufacturer_M_VESTAMATIC,
		KnxManufacturer_M_MDT_TECHNOLOGIES,
		KnxManufacturer_M_WARENDORFER_KUECHEN_GMBH,
		KnxManufacturer_M_GVS,
		KnxManufacturer_M_SITEK,
		KnxManufacturer_M_CONTROLTRONIC,
		KnxManufacturer_M_FUNCTION_TECHNOLOGY,
		KnxManufacturer_M_AMX,
		KnxManufacturer_M_ELDAT,
		KnxManufacturer_M_PANASONIC,
		KnxManufacturer_M_PULSE_TECHNOLOGIES,
		KnxManufacturer_M_CRESTRON,
		KnxManufacturer_M_STEINEL_PROFESSIONAL,
		KnxManufacturer_M_BILTON_LED_LIGHTING,
		KnxManufacturer_M_DENRO_AG,
		KnxManufacturer_M_GEPRO,
		KnxManufacturer_M_PREUSSEN_AUTOMATION,
		KnxManufacturer_M_ZOPPAS_INDUSTRIES,
		KnxManufacturer_M_MACTECH,
		KnxManufacturer_M_TECHNO_TREND,
		KnxManufacturer_M_FS_CABLES,
		KnxManufacturer_M_DELTA_DORE,
		KnxManufacturer_M_EISSOUND,
		KnxManufacturer_M_CISCO,
		KnxManufacturer_M_DINUY,
		KnxManufacturer_M_IKNIX,
		KnxManufacturer_M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH,
		KnxManufacturer_M_EGI_ELECTROACUSTICA_GENERAL_IBERICA,
		KnxManufacturer_M_BES___INGENIUM,
		KnxManufacturer_M_ELABNET,
		KnxManufacturer_M_BLUMOTIX,
		KnxManufacturer_M_HUNTER_DOUGLAS,
		KnxManufacturer_M_APRICUM,
		KnxManufacturer_M_TIANSU_AUTOMATION,
		KnxManufacturer_M_BUBENDORFF,
		KnxManufacturer_M_MBS_GMBH,
		KnxManufacturer_M_ENERTEX_BAYERN_GMBH,
		KnxManufacturer_M_BMS,
		KnxManufacturer_M_SINAPSI,
		KnxManufacturer_M_EMBEDDED_SYSTEMS_SIA,
		KnxManufacturer_M_KNX1,
		KnxManufacturer_M_TOKKA,
		KnxManufacturer_M_NANOSENSE,
		KnxManufacturer_M_PEAR_AUTOMATION_GMBH,
		KnxManufacturer_M_DGA,
		KnxManufacturer_M_LUTRON,
		KnxManufacturer_M_AIRZONE___ALTRA,
		KnxManufacturer_M_LITHOSS_DESIGN_SWITCHES,
		KnxManufacturer_M_THREEATEL,
		KnxManufacturer_M_PHILIPS_CONTROLS,
		KnxManufacturer_M_VELUX_AS,
		KnxManufacturer_M_LOYTEC,
		KnxManufacturer_M_EKINEX_S_P_A_,
		KnxManufacturer_M_SIRLAN_TECHNOLOGIES,
		KnxManufacturer_M_PROKNX_SAS,
		KnxManufacturer_M_IT_GMBH,
		KnxManufacturer_M_RENSON,
		KnxManufacturer_M_HEP_GROUP,
		KnxManufacturer_M_BALMART,
		KnxManufacturer_M_GFS_GMBH,
		KnxManufacturer_M_SCHENKER_STOREN_AG,
		KnxManufacturer_M_ALGODUE_ELETTRONICA_S_R_L_,
		KnxManufacturer_M_ABB_FRANCE,
		KnxManufacturer_M_MAINTRONIC,
		KnxManufacturer_M_VANTAGE,
		KnxManufacturer_M_FORESIS,
		KnxManufacturer_M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM,
		KnxManufacturer_M_WEINZIERL_ENGINEERING_GMBH,
		KnxManufacturer_M_MOEHLENHOFF_WAERMETECHNIK_GMBH,
		KnxManufacturer_M_PKC_GROUP_OYJ,
		KnxManufacturer_M_B_E_G_,
		KnxManufacturer_M_ELSNER_ELEKTRONIK_GMBH,
		KnxManufacturer_M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_,
		KnxManufacturer_M_EUTRAC,
		KnxManufacturer_M_GUSTAV_HENSEL_GMBH_AND_CO__KG,
		KnxManufacturer_M_GARO_AB,
		KnxManufacturer_M_WALDMANN_LICHTTECHNIK,
		KnxManufacturer_M_SCHUECO,
		KnxManufacturer_M_EMU,
		KnxManufacturer_M_JNET_SYSTEMS_AG,
		KnxManufacturer_M_TOTAL_SOLUTION_GMBH,
		KnxManufacturer_M_O_Y_L__ELECTRONICS,
		KnxManufacturer_M_GALAX_SYSTEM,
		KnxManufacturer_M_DISCH,
		KnxManufacturer_M_AUCOTEAM,
		KnxManufacturer_M_LUXMATE_CONTROLS,
		KnxManufacturer_M_DANFOSS,
		KnxManufacturer_M_AST_GMBH,
		KnxManufacturer_M_WILA_LEUCHTEN,
		KnxManufacturer_M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK,
		KnxManufacturer_M_LINGG_AND_JANKE,
		KnxManufacturer_M_SAUTER,
		KnxManufacturer_M_SIMU,
		KnxManufacturer_M_THEBEN_HTS_AG,
		KnxManufacturer_M_AMANN_GMBH,
		KnxManufacturer_M_BERG_ENERGIEKONTROLLSYSTEME_GMBH,
		KnxManufacturer_M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH,
		KnxManufacturer_M_OVENTROP_KG,
		KnxManufacturer_M_GRIESSER_AG,
		KnxManufacturer_M_IPAS_GMBH,
		KnxManufacturer_M_ELERO_GMBH,
		KnxManufacturer_M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_,
		KnxManufacturer_M_METEC_MESSTECHNIK_GMBH,
		KnxManufacturer_M_BUERK_MOBATIME,
		KnxManufacturer_M_ELKA_ELEKTRONIK_GMBH,
		KnxManufacturer_M_ELEKTROANLAGEN_D__NAGEL,
		KnxManufacturer_M_TRIDONIC_BAUELEMENTE_GMBH,
		KnxManufacturer_M_STENGLER_GESELLSCHAFT,
		KnxManufacturer_M_SCHNEIDER_ELECTRIC_MG,
		KnxManufacturer_M_KNX_ASSOCIATION,
		KnxManufacturer_M_VIVO,
		KnxManufacturer_M_HUGO_MUELLER_GMBH_AND_CO_KG,
		KnxManufacturer_M_SIEMENS_HVAC,
		KnxManufacturer_M_APT,
		KnxManufacturer_M_HIGHDOM,
		KnxManufacturer_M_TOP_SERVICES,
		KnxManufacturer_M_AMBIHOME,
		KnxManufacturer_M_DATEC_ELECTRONIC_AG,
		KnxManufacturer_M_ABUS_SECURITY_CENTER,
		KnxManufacturer_M_LITE_PUTER,
		KnxManufacturer_M_TANTRON_ELECTRONIC,
		KnxManufacturer_M_INTERRA,
		KnxManufacturer_M_DKX_TECH,
		KnxManufacturer_M_VIATRON,
		KnxManufacturer_M_NAUTIBUS,
		KnxManufacturer_M_ON_SEMICONDUCTOR,
		KnxManufacturer_M_LONGCHUANG,
		KnxManufacturer_M_AIR_ON_AG,
		KnxManufacturer_M_IB_COMPANY_GMBH,
		KnxManufacturer_M_SATION_FACTORY,
		KnxManufacturer_M_AGENTILO_GMBH,
		KnxManufacturer_M_MAKEL_ELEKTRIK,
		KnxManufacturer_M_HELIOS_VENTILATOREN,
		KnxManufacturer_M_OTTO_SOLUTIONS_PTE_LTD,
		KnxManufacturer_M_AIRMASTER,
		KnxManufacturer_M_VALLOX_GMBH,
		KnxManufacturer_M_DALITEK,
		KnxManufacturer_M_ASIN,
		KnxManufacturer_M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_,
		KnxManufacturer_M_ARBONIA,
		KnxManufacturer_M_KERMI,
		KnxManufacturer_M_PROLUX,
		KnxManufacturer_M_CLICHOME,
		KnxManufacturer_M_COMMAX,
		KnxManufacturer_M_EAE,
		KnxManufacturer_M_TENSE,
		KnxManufacturer_M_SEYOUNG_ELECTRONICS,
		KnxManufacturer_M_LIFEDOMUS,
		KnxManufacturer_M_EUROTRONIC_TECHNOLOGY_GMBH,
		KnxManufacturer_M_TCI,
		KnxManufacturer_M_RISHUN_ELECTRONIC,
		KnxManufacturer_M_ZIPATO,
		KnxManufacturer_M_CM_SECURITY_GMBH_AND_CO_KG,
		KnxManufacturer_M_QING_CABLES,
		KnxManufacturer_M_WOLF,
		KnxManufacturer_M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_,
		KnxManufacturer_M_E_G_E,
		KnxManufacturer_M_NETXAUTOMATION,
		KnxManufacturer_M_TECALOR,
		KnxManufacturer_M_URMET_ELECTRONICS_HUIZHOU_LTD_,
		KnxManufacturer_M_PEIYING_BUILDING_CONTROL,
		KnxManufacturer_M_BPT_S_P_A__A_SOCIO_UNICO,
		KnxManufacturer_M_KANONTEC___KANONBUS,
		KnxManufacturer_M_ISER_TECH,
		KnxManufacturer_M_FINELINE,
		KnxManufacturer_M_CP_ELECTRONICS_LTD,
		KnxManufacturer_M_NIKO_SERVODAN_AS,
		KnxManufacturer_M_SIMON_309,
		KnxManufacturer_M_GM_MODULAR_PVT__LTD_,
		KnxManufacturer_M_FU_CHENG_INTELLIGENCE,
		KnxManufacturer_M_NEXKON,
		KnxManufacturer_M_FEEL_S_R_L,
		KnxManufacturer_M_NOT_ASSIGNED_314,
		KnxManufacturer_M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_,
		KnxManufacturer_M_JIUZHOU_GREEBLE,
		KnxManufacturer_M_AUMUELLER_AUMATIC_GMBH,
		KnxManufacturer_M_ETMAN_ELECTRIC,
		KnxManufacturer_M_BLACK_NOVA,
		KnxManufacturer_M_ZIDATECH_AG,
		KnxManufacturer_M_IDGS_BVBA,
		KnxManufacturer_M_DAKANIMO,
		KnxManufacturer_M_TREBOR_AUTOMATION_AB,
		KnxManufacturer_M_SATEL_SP__Z_O_O_,
		KnxManufacturer_M_RUSSOUND__INC_,
		KnxManufacturer_M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD,
		KnxManufacturer_M_CONSORZIO_TERRANUOVA,
		KnxManufacturer_M_WOLF_HEIZTECHNIK_GMBH,
		KnxManufacturer_M_SONTEC,
		KnxManufacturer_M_BELCOM_CABLES_LTD_,
		KnxManufacturer_M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_,
		KnxManufacturer_M_ACREL,
		KnxManufacturer_M_KWC_AQUAROTTER_GMBH,
		KnxManufacturer_M_ORION_SYSTEMS,
		KnxManufacturer_M_SCHRACK_TECHNIK_GMBH,
		KnxManufacturer_M_INSPRID,
		KnxManufacturer_M_SUNRICHER,
		KnxManufacturer_M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_,
		KnxManufacturer_M_AUREX,
		KnxManufacturer_M_JOSEF_BARTHELME_GMBH_AND_CO__KG,
		KnxManufacturer_M_ARCHITECTURE_NUMERIQUE,
		KnxManufacturer_M_UP_GROUP,
		KnxManufacturer_M_TEKNOS_AVINNO,
		KnxManufacturer_M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY,
		KnxManufacturer_M_THERMOKON_SENSORTECHNIK_GMBH,
		KnxManufacturer_M_BELIMO_AUTOMATION_AG,
		KnxManufacturer_M_ZEHNDER_GROUP_INTERNATIONAL_AG,
		KnxManufacturer_M_SKS_KINKEL_ELEKTRONIK,
		KnxManufacturer_M_ECE_WURMITZER_GMBH,
		KnxManufacturer_M_LARS,
		KnxManufacturer_M_URC,
		KnxManufacturer_M_LIGHTCONTROL,
		KnxManufacturer_M_SHENZHEN_YM,
		KnxManufacturer_M_MEAN_WELL_ENTERPRISES_CO__LTD_,
		KnxManufacturer_M_OSIX,
		KnxManufacturer_M_AYPRO_TECHNOLOGY,
		KnxManufacturer_M_HEFEI_ECOLITE_SOFTWARE,
		KnxManufacturer_M_ENNO,
		KnxManufacturer_M_OHOSURE,
		KnxManufacturer_M_GAREFOWL,
		KnxManufacturer_M_GEZE,
		KnxManufacturer_M_LG_ELECTRONICS_INC_,
		KnxManufacturer_M_SMC_INTERIORS,
		KnxManufacturer_M_NOT_ASSIGNED_364,
		KnxManufacturer_M_SCS_CABLE,
		KnxManufacturer_M_HOVAL,
		KnxManufacturer_M_CANST,
		KnxManufacturer_M_HANGZHOU_BERLIN,
		KnxManufacturer_M_EVN_LICHTTECHNIK,
		KnxManufacturer_M_RUTEC,
		KnxManufacturer_M_FINDER,
		KnxManufacturer_M_FUJITSU_GENERAL_LIMITED,
		KnxManufacturer_M_ZF_FRIEDRICHSHAFEN_AG,
		KnxManufacturer_M_CREALED,
		KnxManufacturer_M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED,
		KnxManufacturer_M_EPlus,
		KnxManufacturer_M_ITALCOND,
		KnxManufacturer_M_SATION,
		KnxManufacturer_M_NEWBEST,
		KnxManufacturer_M_GDS_DIGITAL_SYSTEMS,
		KnxManufacturer_M_IDDERO,
		KnxManufacturer_M_MBNLED,
		KnxManufacturer_M_VITRUM,
		KnxManufacturer_M_EKEY_BIOMETRIC_SYSTEMS_GMBH,
		KnxManufacturer_M_AMC,
		KnxManufacturer_M_TRILUX_GMBH_AND_CO__KG,
		KnxManufacturer_M_WEXCEDO,
		KnxManufacturer_M_VEMER_SPA,
		KnxManufacturer_M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG,
		KnxManufacturer_M_CITRON,
		KnxManufacturer_M_SHENZHEN_HEGUANG,
		KnxManufacturer_M_NOT_ASSIGNED_392,
		KnxManufacturer_M_TRANE_B_V_B_A,
		KnxManufacturer_M_CAREL,
		KnxManufacturer_M_PROLITE_CONTROLS,
		KnxManufacturer_M_BOSMER,
		KnxManufacturer_M_EUCHIPS,
		KnxManufacturer_M_CONNECT_THINKA_CONNECT,
		KnxManufacturer_M_PEAKNX_A_DOGAWIST_COMPANY,
		KnxManufacturer_M_ACEMATIC,
		KnxManufacturer_M_ELAUSYS,
		KnxManufacturer_M_ITK_ENGINEERING_AG,
		KnxManufacturer_M_INTEGRA_METERING_AG,
		KnxManufacturer_M_FMS_HOSPITALITY_PTE_LTD,
		KnxManufacturer_M_NUVO,
		KnxManufacturer_M_U__LUX_GMBH,
		KnxManufacturer_M_BRUMBERG_LEUCHTEN,
		KnxManufacturer_M_LIME,
		KnxManufacturer_M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_,
		KnxManufacturer_M_KAVOSHPISHRO_ASIA,
		KnxManufacturer_M_V2_SPA,
		KnxManufacturer_M_JOHNSON_CONTROLS,
		KnxManufacturer_M_ARKUD,
		KnxManufacturer_M_IRIDI_LTD_,
		KnxManufacturer_M_BSMART,
		KnxManufacturer_M_BAB_TECHNOLOGIE_GMBH,
		KnxManufacturer_M_NICE_SPA,
		KnxManufacturer_M_REDFISH_GROUP_PTY_LTD,
		KnxManufacturer_M_SABIANA_SPA,
		KnxManufacturer_M_UBEE_INTERACTIVE_EUROPE,
		KnxManufacturer_M_REXEL,
		KnxManufacturer_M_GES_TEKNIK_A_S_,
		KnxManufacturer_M_AVE_S_P_A_,
		KnxManufacturer_M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_ARCOM,
		KnxManufacturer_M_VIA_TECHNOLOGIES__INC_,
		KnxManufacturer_M_FEELSMART_,
		KnxManufacturer_M_SUPCON,
		KnxManufacturer_M_MANIC,
		KnxManufacturer_M_TDE_GMBH,
		KnxManufacturer_M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_EWTECH,
		KnxManufacturer_M_KLUGER_AUTOMATION_GMBH,
		KnxManufacturer_M_JOONGANG_CONTROL,
		KnxManufacturer_M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_,
		KnxManufacturer_M_IME_S_P_A_,
		KnxManufacturer_M_SICHUAN_HAODING,
		KnxManufacturer_M_MINDJAGA_LTD_,
		KnxManufacturer_M_RUILI_SMART_CONTROL,
		KnxManufacturer_M_CODESYS_GMBH,
		KnxManufacturer_M_MOORGEN_DEUTSCHLAND_GMBH,
		KnxManufacturer_M_CULLMANN_TECH,
		KnxManufacturer_M_EYRISE_B_V,
		KnxManufacturer_M_DOBNEL,
		KnxManufacturer_M_MYGEKKO,
		KnxManufacturer_M_ERGO3_SARL,
		KnxManufacturer_M_STMICROELECTRONICS_INTERNATIONAL_N_V_,
		KnxManufacturer_M_CJC_SYSTEMS,
		KnxManufacturer_M_SUDOKU,
		KnxManufacturer_M_AZ_E_LITE_PTE_LTD,
		KnxManufacturer_M_ARLIGHT,
		KnxManufacturer_M_GRUENBECK_WASSERAUFBEREITUNG_GMBH,
		KnxManufacturer_M_MODULE_ELECTRONIC,
		KnxManufacturer_M_KOPLAT,
		KnxManufacturer_M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_ILEVIA,
		KnxManufacturer_M_LN_SYSTEMTEQ,
		KnxManufacturer_M_HISENSE_SMARTHOME,
		KnxManufacturer_M_FLINK_AUTOMATION_SYSTEM,
		KnxManufacturer_M_XXTER_BV,
		KnxManufacturer_M_LYNXUS_TECHNOLOGY,
		KnxManufacturer_M_ROBOT_S_A_,
		KnxManufacturer_M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_,
		KnxManufacturer_M_NOBLESSE,
		KnxManufacturer_M_ADVANCED_DEVICES,
		KnxManufacturer_M_ATRINA_BUILDING_AUTOMATION_CO__LTD,
		KnxManufacturer_M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_,
		KnxManufacturer_M_WESTERSTRAND_URFABRIK_AB,
		KnxManufacturer_M_CONTROL4_CORPORATE,
		KnxManufacturer_M_ONTROL,
		KnxManufacturer_M_STARNET,
		KnxManufacturer_M_BETA_CAVI,
		KnxManufacturer_M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_VIVALDI_SRL,
		KnxManufacturer_M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI,
		KnxManufacturer_M_HWISCON,
		KnxManufacturer_M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_KAMPMANN,
		KnxManufacturer_M_IMPOLUX_GMBH_LEDIMAX,
		KnxManufacturer_M_EVAUX,
		KnxManufacturer_M_WEBRO_CABLES_AND_CONNECTORS_LIMITED,
		KnxManufacturer_M_SHANGHAI_E_TECH_SOLUTION,
		KnxManufacturer_M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_,
		KnxManufacturer_M_LAMMIN_HIGH_TECH_CO__LTD,
		KnxManufacturer_M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_I_LUXUS,
		KnxManufacturer_M_ELMOS_SEMICONDUCTOR_AG,
		KnxManufacturer_M_EMCOM_TECHNOLOGY_INC,
		KnxManufacturer_M_PROJECT_INNOVATIONS_GMBH,
		KnxManufacturer_M_ITC,
		KnxManufacturer_M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING,
		KnxManufacturer_M_MAICO,
		KnxManufacturer_M_ELAN_SRL,
		KnxManufacturer_M_MINHHA_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_,
		KnxManufacturer_M_IAUTOMATION_PTY_LIMITED,
		KnxManufacturer_M_EXTRON,
		KnxManufacturer_M_FREEDOMPRO,
		KnxManufacturer_M_ONEHOME,
		KnxManufacturer_M_EOS_SAUNATECHNIK_GMBH,
		KnxManufacturer_M_KUSATEK_GMBH,
		KnxManufacturer_M_ALEXANDER_MAIER_GMBH,
		KnxManufacturer_M_AUTOMATISMI_BENINCA_S_P_A_,
		KnxManufacturer_M_BLENDOM,
		KnxManufacturer_M_MADEL_AIR_TECHNICAL_DIFFUSION,
		KnxManufacturer_M_NIKO,
		KnxManufacturer_M_BOSCH_REXROTH_AG,
		KnxManufacturer_M_CANDM_PRODUCTS,
		KnxManufacturer_M_HOERMANN_KG_VERKAUFSGESELLSCHAFT,
		KnxManufacturer_M_SHANGHAI_RAJAYASA_CO__LTD,
		KnxManufacturer_M_SUZUKI,
		KnxManufacturer_M_SILENT_GLISS_INTERNATIONAL_LTD_,
		KnxManufacturer_M_BEE_CONTROLS_ADGSC_GROUP,
		KnxManufacturer_M_XDTECGMBH,
		KnxManufacturer_M_OSRAM,
		KnxManufacturer_M_LEBENOR,
		KnxManufacturer_M_AUTOMANENG,
		KnxManufacturer_M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD,
		KnxManufacturer_M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_ETA_HEIZTECHNIK,
		KnxManufacturer_M_DIVUS_GMBH,
		KnxManufacturer_M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_LUNATONE,
		KnxManufacturer_M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT,
		KnxManufacturer_M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_NOKE,
		KnxManufacturer_M_LANDCOM,
		KnxManufacturer_M_STORK_AS,
		KnxManufacturer_M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_COOLAUTOMATION,
		KnxManufacturer_M_APRSTERN,
		KnxManufacturer_M_SONNEN,
		KnxManufacturer_M_DNAKE,
		KnxManufacturer_M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH,
		KnxManufacturer_M_STILIGER,
		KnxManufacturer_M_BERGHOF_AUTOMATION_GMBH,
		KnxManufacturer_M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH,
		KnxManufacturer_M_DOVIT,
		KnxManufacturer_M_INSTALIGHTING_GMBH,
		KnxManufacturer_M_UNI_TEC,
		KnxManufacturer_M_CASATUNES,
		KnxManufacturer_M_EMT,
		KnxManufacturer_M_SENFFICIENT,
		KnxManufacturer_M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED,
		KnxManufacturer_M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_SAMSON_ELECTRIC_WIRE,
		KnxManufacturer_M_T_TOUCHING,
		KnxManufacturer_M_CORE_SMART_HOME,
		KnxManufacturer_M_GREENCONNECT_SOLUTIONS_SA,
		KnxManufacturer_M_ELETTRONICA_CONDUTTORI,
		KnxManufacturer_M_MKFC,
		KnxManufacturer_M_AUTOMATIONPlus,
		KnxManufacturer_M_BLUE_AND_RED,
		KnxManufacturer_M_FROGBLUE,
		KnxManufacturer_M_LUXIO,
		KnxManufacturer_M_APP_TECH,
		KnxManufacturer_M_SENSORTEC_AG,
		KnxManufacturer_M_NYSA_TECHNOLOGY_AND_SOLUTIONS,
		KnxManufacturer_M_FARADITE,
		KnxManufacturer_M_OPTIMUS,
		KnxManufacturer_M_KTS_S_R_L_,
		KnxManufacturer_M_RAMCRO_SPA,
		KnxManufacturer_M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_BEMI_SMART_HOME_LTD,
		KnxManufacturer_M_ARDOMUS,
		KnxManufacturer_M_CHANGXING,
		KnxManufacturer_M_E_CONTROLS,
		KnxManufacturer_M_AIB_TECHNOLOGY,
		KnxManufacturer_M_NVC,
		KnxManufacturer_M_KBOX,
		KnxManufacturer_M_CNS,
		KnxManufacturer_M_TYBA,
		KnxManufacturer_M_ATREL,
		KnxManufacturer_M_SIMON_ELECTRIC_CHINA_CO___LTD,
		KnxManufacturer_M_KORDZ_GROUP,
		KnxManufacturer_M_ND_ELECTRIC,
		KnxManufacturer_M_CONTROLIUM,
		KnxManufacturer_M_FAMO_GMBH_AND_CO__KG,
		KnxManufacturer_M_CDN_SMART,
		KnxManufacturer_M_HESTON,
		KnxManufacturer_M_ESLA_CONEXIONES_S_L_,
		KnxManufacturer_M_WEISHAUPT,
		KnxManufacturer_M_ASTRUM_TECHNOLOGY,
		KnxManufacturer_M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_,
		KnxManufacturer_M_NANOTECO_CORPORATION,
		KnxManufacturer_M_NIETIAN,
		KnxManufacturer_M_SUMSIR,
		KnxManufacturer_M_ORBIS_TECNOLOGIA_ELECTRICA_SA,
		KnxManufacturer_M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_ANLIPS,
		KnxManufacturer_M_GUANGDONG_PAK_CORPORATION_CO___LTD,
		KnxManufacturer_M_BVK_TECHNOLOGY,
		KnxManufacturer_M_SOLOMIO_SRL,
		KnxManufacturer_M_DOMOTICA_LABS,
		KnxManufacturer_M_NVC_INTERNATIONAL,
		KnxManufacturer_M_BA,
		KnxManufacturer_M_IRIS_CERAMICA_GROUP,
		KnxManufacturer_M_WIREEO,
		KnxManufacturer_M_NVCLIGHTING,
		KnxManufacturer_M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_,
		KnxManufacturer_M_ARMITI_TRADING,
		KnxManufacturer_M_ELEK,
		KnxManufacturer_M_ACCORDIA_SA,
		KnxManufacturer_M_OURICAN,
		KnxManufacturer_M_INLIWOSE,
		KnxManufacturer_M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_,
		KnxManufacturer_M_SHK_KNX,
		KnxManufacturer_M_AMPIO,
		KnxManufacturer_M_MINGXING_WISDOM,
		KnxManufacturer_M_ALTEN_SW_GMBH,
		KnxManufacturer_M_V_Y_C_SRL,
		KnxManufacturer_M_TERMINUS_GROUP,
		KnxManufacturer_M_WONDERFUL_CITY_TECHNOLOGY,
		KnxManufacturer_M_QBICTECHNOLOGY,
		KnxManufacturer_M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED,
		KnxManufacturer_M_ONEWORK,
		KnxManufacturer_M_PL_LINK,
		KnxManufacturer_M_FASEL_GMBH_ELEKTRONIK,
		KnxManufacturer_M_GOLDENHOME_SMART,
		KnxManufacturer_M_GOLDMEDAL,
		KnxManufacturer_M_CannX,
		KnxManufacturer_M_EGI___EARTH_GOODNESS,
		KnxManufacturer_M_VIEGA_GMBH_AND_CO__KG,
		KnxManufacturer_M_FREDON_DIGITAL_BUILDINGS,
		KnxManufacturer_M_HELUKABEL_THAILAND_CO__LTD_,
		KnxManufacturer_M_SICS,
		KnxManufacturer_M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD,
		KnxManufacturer_M_SUMAMO,
		KnxManufacturer_M_SVIT,
		KnxManufacturer_M_TECGET,
		KnxManufacturer_M_XEROPOINT,
		KnxManufacturer_M_HONEYWELL_BUILDING_TECHNOLOGIES,
		KnxManufacturer_M_COMFORTCLICK,
		KnxManufacturer_M_DORBAS_ELECTRIC,
		KnxManufacturer_M_REMKO_GMBH_AND_CO__KG,
		KnxManufacturer_M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_ANDAS,
		KnxManufacturer_M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_LARFE,
		KnxManufacturer_M_DONGGUAN_MUHCCI_ELECTRICAL,
		KnxManufacturer_M_STEC,
		KnxManufacturer_M_ARIGO_SOFTWARE_GMBH,
		KnxManufacturer_M_FEISHELEC,
		KnxManufacturer_M_GORDIC,
		KnxManufacturer_M_DELTA_ELECTRONICS,
		KnxManufacturer_M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_KG_POWER,
		KnxManufacturer_M_ZHEJIANG_MOORGEN_GROUP_CO__LTD,
		KnxManufacturer_M_GUANGDONG_KANWAY,
		KnxManufacturer_M_RAMIREZ_ENGINEERING_GMBH,
		KnxManufacturer_M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD,
		KnxManufacturer_M_VIHAN_ELECTRIC_PVT_LTD,
		KnxManufacturer_M_SPLENDID_MINDS_GMBH,
		KnxManufacturer_M_ESTADA,
		KnxManufacturer_M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI,
		KnxManufacturer_M_STUHL_REGELSYSTEME_GMBH,
		KnxManufacturer_M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_GAIMEX,
		KnxManufacturer_M_B3_INTERNATIONAL_S_R_L,
		KnxManufacturer_M_MM_ELECTRO,
		KnxManufacturer_M_CASCODA,
		KnxManufacturer_M_XIAMEN_INTRETECH_INC_,
		KnxManufacturer_M_KILOELEC_TECHNOLOGY,
		KnxManufacturer_M_INYX,
		KnxManufacturer_M_SMART_BUILDING_SERVICES_GMBH,
		KnxManufacturer_M_BSS_GMBH,
		KnxManufacturer_M_LUMI_ELECTRONICS,
		KnxManufacturer_M_OJEAELECTRONICS,
		KnxManufacturer_M_SMART_NODE,
		KnxManufacturer_M_NEXHOME,
		KnxManufacturer_M_HUOTENG_WULIAN_JIANGSU_CO___LTD,
		KnxManufacturer_M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD,
		KnxManufacturer_M_BITS_AND_BYTES,
		KnxManufacturer_M_KFV_SIEGENIA_GRUPPE,
		KnxManufacturer_M_SYMCON,
		KnxManufacturer_M_I_TRUST,
		KnxManufacturer_M_DRD_TECHNICS,
		KnxManufacturer_M_LENGEN,
		KnxManufacturer_M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_VIBROXX_FZCO,
		KnxManufacturer_M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD,
		KnxManufacturer_M_PASSIV_ENERGIE_GMBH,
		KnxManufacturer_M_PAYNE_TECHNOLOGIES_LTD,
		KnxManufacturer_M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_SEXANKA,
		KnxManufacturer_M_SECURI_FLEX_LTD,
		KnxManufacturer_M_BOKE,
		KnxManufacturer_M_SBR_SYSTEM_TECHNICAL,
		KnxManufacturer_M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_BOLATU,
		KnxManufacturer_M_RECBER_KABLO_A_S_,
		KnxManufacturer_M_ILITE_KNX,
		KnxManufacturer_M_LAZZEN,
		KnxManufacturer_M_MOX_CONTROL_IT_CHINA_LIMITED,
		KnxManufacturer_M_CLOWIRE,
		KnxManufacturer_M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD,
		KnxManufacturer_M_NS_TOUCH,
		KnxManufacturer_M_ROOMIO,
		KnxManufacturer_M_ATOUCH,
		KnxManufacturer_M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD,
		KnxManufacturer_M_WALLYONS,
		KnxManufacturer_M_ZIMMEX,
		KnxManufacturer_M_RHOMBUS_EUROPE,
		KnxManufacturer_M_TURING_THINK,
		KnxManufacturer_M_MICHOI,
		KnxManufacturer_M_CAV_SMARTGUANGZHOUCO__LTD,
		KnxManufacturer_M_HELKAMA_BICA_OY,
		KnxManufacturer_M_MODULYTE,
		KnxManufacturer_M_CONSOLINNO_ENERGY_GMBH,
		KnxManufacturer_M_SCHIDERON_ELECTRIC_ASIA_LIMITED,
		KnxManufacturer_M_3R,
		KnxManufacturer_M_ARKLYFE,
		KnxManufacturer_M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_,
		KnxManufacturer_M_KNXES_COMPANY_LIMITED,
		KnxManufacturer_M_AKUVOX,
		KnxManufacturer_M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_,
		KnxManufacturer_M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD,
		KnxManufacturer_M_MUTLUSAN_ELECTRIC,
		KnxManufacturer_M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_MARLEY_DEUTSCHLAND_GMBH,
		KnxManufacturer_M_CREATROL,
		KnxManufacturer_M_EUTELSAT,
		KnxManufacturer_M_TECNIKABEL,
		KnxManufacturer_M_ATIOS_AG,
		KnxManufacturer_M_SMARTLICHT,
		KnxManufacturer_M_BEIJING_BEVONE_ELECTRIC_CO__LTD_,
		KnxManufacturer_M_ELSMART,
		KnxManufacturer_M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC,
		KnxManufacturer_M_HANGZHOU_SANYUAN_CABLE_CO___LTD,
		KnxManufacturer_M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_,
		KnxManufacturer_M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_VITRUM_DESIGN,
		KnxManufacturer_M_DETRONS,
		KnxManufacturer_M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_VARNI_DIGITAL_PRIVATE_LIMITED,
		KnxManufacturer_M_3A_ENTREPRISE_APS,
		KnxManufacturer_M_ITALIANA_CONDUTTORI_SRL,
		KnxManufacturer_M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_,
		KnxManufacturer_M_LEDNX,
		KnxManufacturer_M_EBELONG,
		KnxManufacturer_M_ASTRA_LED_AG,
		KnxManufacturer_M_WONDERFUL_HI_TECH_CO___LTD_,
		KnxManufacturer_M_REXLITE_AI_INTEGRATIONS_CO__LTD,
		KnxManufacturer_M_ALLORADO,
		KnxManufacturer_M_FUZHOU_MILI_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_HYSINE,
		KnxManufacturer_M_SANTAN,
		KnxManufacturer_M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD,
		KnxManufacturer_M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_POLAR_BEAR_DESIGN,
		KnxManufacturer_M_ELESSAN_NV,
		KnxManufacturer_M_MIR,
		KnxManufacturer_M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_LEAX_CONTROLS_CO___LTD_,
		KnxManufacturer_M_ALCAD,
		KnxManufacturer_M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_TAOS_ELECTRIC_CO___LTD,
		KnxManufacturer_M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION,
		KnxManufacturer_M_ASAY_Q,
		KnxManufacturer_M_LAPP,
		KnxManufacturer_M_ZEROBIT_DYNAMIC,
		KnxManufacturer_M_HAVELLS,
		KnxManufacturer_M_MULLER_INTUITIV,
		KnxManufacturer_M_TASKIT_GMBH,
		KnxManufacturer_M_COSTER_GROUP,
		KnxManufacturer_M_NXP_SEMICONDUCTOR,
		KnxManufacturer_M_COGCONS,
		KnxManufacturer_M_MICRO_TEK_SRL_F_M_C_TRADE_MARK,
		KnxManufacturer_M_ORENDA_ELECTRIC,
		KnxManufacturer_M_ERSE_KABLO,
		KnxManufacturer_M_PRADO_EUROPE_BV,
		KnxManufacturer_M_E2S_GBR,
		KnxManufacturer_M_UNITLINK,
		KnxManufacturer_M_ONNA,
		KnxManufacturer_M_CENTERSVET_LLC,
		KnxManufacturer_M_ADVECO_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_FR__LUERSSEN_WERFT,
		KnxManufacturer_M_MYLYR,
		KnxManufacturer_M_HYUNDAI_HT,
		KnxManufacturer_M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD,
		KnxManufacturer_M_SMATEK_ELECTRONICS_LIMITED,
		KnxManufacturer_M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_,
		KnxManufacturer_M_MORELINKS_SMART_HOME,
		KnxManufacturer_M_CIRTX_GMBH,
		KnxManufacturer_M_QLITE,
		KnxManufacturer_M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD,
		KnxManufacturer_M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_,
		KnxManufacturer_M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD,
		KnxManufacturer_M_CONFIO,
		KnxManufacturer_M_SONIC_TECHNOLOGIES,
		KnxManufacturer_M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT,
		KnxManufacturer_M_ABI_SICHERHEITSSYSTEME_GMBH,
		KnxManufacturer_M_RYT,
		KnxManufacturer_M_AURIGA_SYSTEMS,
		KnxManufacturer_M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH,
		KnxManufacturer_M_GIANFRANCO_SMART_SOLUTIONS_LTD,
		KnxManufacturer_M_ROGERWELL_CONTROL_SYSTEM_LIMITED,
		KnxManufacturer_M_ABB___RESERVED,
		KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO___RESERVED,
	}
}

func (e KnxManufacturer) Number() uint16 {
	switch e {
	case 0:
		{ /* '0' */
			return 0
		}
	case 1:
		{ /* '1' */
			return 1
		}
	case 10:
		{ /* '10' */
			return 11
		}
	case 100:
		{ /* '100' */
			return 139
		}
	case 101:
		{ /* '101' */
			return 140
		}
	case 102:
		{ /* '102' */
			return 141
		}
	case 103:
		{ /* '103' */
			return 142
		}
	case 104:
		{ /* '104' */
			return 143
		}
	case 105:
		{ /* '105' */
			return 144
		}
	case 106:
		{ /* '106' */
			return 145
		}
	case 107:
		{ /* '107' */
			return 146
		}
	case 108:
		{ /* '108' */
			return 147
		}
	case 109:
		{ /* '109' */
			return 148
		}
	case 11:
		{ /* '11' */
			return 12
		}
	case 110:
		{ /* '110' */
			return 149
		}
	case 111:
		{ /* '111' */
			return 150
		}
	case 112:
		{ /* '112' */
			return 151
		}
	case 113:
		{ /* '113' */
			return 152
		}
	case 114:
		{ /* '114' */
			return 153
		}
	case 115:
		{ /* '115' */
			return 154
		}
	case 116:
		{ /* '116' */
			return 155
		}
	case 117:
		{ /* '117' */
			return 156
		}
	case 118:
		{ /* '118' */
			return 157
		}
	case 119:
		{ /* '119' */
			return 158
		}
	case 12:
		{ /* '12' */
			return 14
		}
	case 120:
		{ /* '120' */
			return 159
		}
	case 121:
		{ /* '121' */
			return 160
		}
	case 122:
		{ /* '122' */
			return 161
		}
	case 123:
		{ /* '123' */
			return 162
		}
	case 124:
		{ /* '124' */
			return 163
		}
	case 125:
		{ /* '125' */
			return 164
		}
	case 126:
		{ /* '126' */
			return 165
		}
	case 127:
		{ /* '127' */
			return 166
		}
	case 128:
		{ /* '128' */
			return 167
		}
	case 129:
		{ /* '129' */
			return 168
		}
	case 13:
		{ /* '13' */
			return 22
		}
	case 130:
		{ /* '130' */
			return 169
		}
	case 131:
		{ /* '131' */
			return 170
		}
	case 132:
		{ /* '132' */
			return 171
		}
	case 133:
		{ /* '133' */
			return 172
		}
	case 134:
		{ /* '134' */
			return 173
		}
	case 135:
		{ /* '135' */
			return 174
		}
	case 136:
		{ /* '136' */
			return 175
		}
	case 137:
		{ /* '137' */
			return 176
		}
	case 138:
		{ /* '138' */
			return 177
		}
	case 139:
		{ /* '139' */
			return 178
		}
	case 14:
		{ /* '14' */
			return 24
		}
	case 140:
		{ /* '140' */
			return 179
		}
	case 141:
		{ /* '141' */
			return 180
		}
	case 142:
		{ /* '142' */
			return 181
		}
	case 143:
		{ /* '143' */
			return 182
		}
	case 144:
		{ /* '144' */
			return 183
		}
	case 145:
		{ /* '145' */
			return 184
		}
	case 146:
		{ /* '146' */
			return 185
		}
	case 147:
		{ /* '147' */
			return 186
		}
	case 148:
		{ /* '148' */
			return 187
		}
	case 149:
		{ /* '149' */
			return 188
		}
	case 15:
		{ /* '15' */
			return 25
		}
	case 150:
		{ /* '150' */
			return 189
		}
	case 151:
		{ /* '151' */
			return 190
		}
	case 152:
		{ /* '152' */
			return 191
		}
	case 153:
		{ /* '153' */
			return 192
		}
	case 154:
		{ /* '154' */
			return 193
		}
	case 155:
		{ /* '155' */
			return 194
		}
	case 156:
		{ /* '156' */
			return 195
		}
	case 157:
		{ /* '157' */
			return 196
		}
	case 158:
		{ /* '158' */
			return 197
		}
	case 159:
		{ /* '159' */
			return 198
		}
	case 16:
		{ /* '16' */
			return 27
		}
	case 160:
		{ /* '160' */
			return 199
		}
	case 161:
		{ /* '161' */
			return 200
		}
	case 162:
		{ /* '162' */
			return 201
		}
	case 163:
		{ /* '163' */
			return 202
		}
	case 164:
		{ /* '164' */
			return 204
		}
	case 165:
		{ /* '165' */
			return 205
		}
	case 166:
		{ /* '166' */
			return 206
		}
	case 167:
		{ /* '167' */
			return 207
		}
	case 168:
		{ /* '168' */
			return 208
		}
	case 169:
		{ /* '169' */
			return 209
		}
	case 17:
		{ /* '17' */
			return 28
		}
	case 170:
		{ /* '170' */
			return 210
		}
	case 171:
		{ /* '171' */
			return 211
		}
	case 172:
		{ /* '172' */
			return 214
		}
	case 173:
		{ /* '173' */
			return 215
		}
	case 174:
		{ /* '174' */
			return 216
		}
	case 175:
		{ /* '175' */
			return 217
		}
	case 176:
		{ /* '176' */
			return 218
		}
	case 177:
		{ /* '177' */
			return 219
		}
	case 178:
		{ /* '178' */
			return 220
		}
	case 179:
		{ /* '179' */
			return 222
		}
	case 18:
		{ /* '18' */
			return 29
		}
	case 180:
		{ /* '180' */
			return 223
		}
	case 181:
		{ /* '181' */
			return 225
		}
	case 182:
		{ /* '182' */
			return 227
		}
	case 183:
		{ /* '183' */
			return 228
		}
	case 184:
		{ /* '184' */
			return 232
		}
	case 185:
		{ /* '185' */
			return 233
		}
	case 186:
		{ /* '186' */
			return 234
		}
	case 187:
		{ /* '187' */
			return 235
		}
	case 188:
		{ /* '188' */
			return 237
		}
	case 189:
		{ /* '189' */
			return 238
		}
	case 19:
		{ /* '19' */
			return 30
		}
	case 190:
		{ /* '190' */
			return 239
		}
	case 191:
		{ /* '191' */
			return 240
		}
	case 192:
		{ /* '192' */
			return 241
		}
	case 193:
		{ /* '193' */
			return 242
		}
	case 194:
		{ /* '194' */
			return 243
		}
	case 195:
		{ /* '195' */
			return 244
		}
	case 196:
		{ /* '196' */
			return 245
		}
	case 197:
		{ /* '197' */
			return 246
		}
	case 198:
		{ /* '198' */
			return 248
		}
	case 199:
		{ /* '199' */
			return 249
		}
	case 2:
		{ /* '2' */
			return 2
		}
	case 20:
		{ /* '20' */
			return 31
		}
	case 200:
		{ /* '200' */
			return 250
		}
	case 201:
		{ /* '201' */
			return 251
		}
	case 202:
		{ /* '202' */
			return 252
		}
	case 203:
		{ /* '203' */
			return 253
		}
	case 204:
		{ /* '204' */
			return 254
		}
	case 205:
		{ /* '205' */
			return 256
		}
	case 206:
		{ /* '206' */
			return 257
		}
	case 207:
		{ /* '207' */
			return 258
		}
	case 208:
		{ /* '208' */
			return 259
		}
	case 209:
		{ /* '209' */
			return 260
		}
	case 21:
		{ /* '21' */
			return 32
		}
	case 210:
		{ /* '210' */
			return 261
		}
	case 211:
		{ /* '211' */
			return 262
		}
	case 212:
		{ /* '212' */
			return 263
		}
	case 213:
		{ /* '213' */
			return 264
		}
	case 214:
		{ /* '214' */
			return 265
		}
	case 215:
		{ /* '215' */
			return 266
		}
	case 216:
		{ /* '216' */
			return 267
		}
	case 217:
		{ /* '217' */
			return 268
		}
	case 218:
		{ /* '218' */
			return 269
		}
	case 219:
		{ /* '219' */
			return 270
		}
	case 22:
		{ /* '22' */
			return 33
		}
	case 220:
		{ /* '220' */
			return 271
		}
	case 221:
		{ /* '221' */
			return 272
		}
	case 222:
		{ /* '222' */
			return 273
		}
	case 223:
		{ /* '223' */
			return 274
		}
	case 224:
		{ /* '224' */
			return 275
		}
	case 225:
		{ /* '225' */
			return 276
		}
	case 226:
		{ /* '226' */
			return 277
		}
	case 227:
		{ /* '227' */
			return 278
		}
	case 228:
		{ /* '228' */
			return 279
		}
	case 229:
		{ /* '229' */
			return 280
		}
	case 23:
		{ /* '23' */
			return 34
		}
	case 230:
		{ /* '230' */
			return 281
		}
	case 231:
		{ /* '231' */
			return 282
		}
	case 232:
		{ /* '232' */
			return 283
		}
	case 233:
		{ /* '233' */
			return 284
		}
	case 234:
		{ /* '234' */
			return 285
		}
	case 235:
		{ /* '235' */
			return 286
		}
	case 236:
		{ /* '236' */
			return 287
		}
	case 237:
		{ /* '237' */
			return 288
		}
	case 238:
		{ /* '238' */
			return 289
		}
	case 239:
		{ /* '239' */
			return 290
		}
	case 24:
		{ /* '24' */
			return 36
		}
	case 240:
		{ /* '240' */
			return 291
		}
	case 241:
		{ /* '241' */
			return 292
		}
	case 242:
		{ /* '242' */
			return 293
		}
	case 243:
		{ /* '243' */
			return 294
		}
	case 244:
		{ /* '244' */
			return 295
		}
	case 245:
		{ /* '245' */
			return 296
		}
	case 246:
		{ /* '246' */
			return 297
		}
	case 247:
		{ /* '247' */
			return 298
		}
	case 248:
		{ /* '248' */
			return 299
		}
	case 249:
		{ /* '249' */
			return 300
		}
	case 25:
		{ /* '25' */
			return 37
		}
	case 250:
		{ /* '250' */
			return 301
		}
	case 251:
		{ /* '251' */
			return 302
		}
	case 252:
		{ /* '252' */
			return 303
		}
	case 253:
		{ /* '253' */
			return 304
		}
	case 254:
		{ /* '254' */
			return 305
		}
	case 255:
		{ /* '255' */
			return 306
		}
	case 256:
		{ /* '256' */
			return 307
		}
	case 257:
		{ /* '257' */
			return 308
		}
	case 258:
		{ /* '258' */
			return 309
		}
	case 259:
		{ /* '259' */
			return 310
		}
	case 26:
		{ /* '26' */
			return 41
		}
	case 260:
		{ /* '260' */
			return 311
		}
	case 261:
		{ /* '261' */
			return 312
		}
	case 262:
		{ /* '262' */
			return 313
		}
	case 263:
		{ /* '263' */
			return 314
		}
	case 264:
		{ /* '264' */
			return 315
		}
	case 265:
		{ /* '265' */
			return 316
		}
	case 266:
		{ /* '266' */
			return 317
		}
	case 267:
		{ /* '267' */
			return 318
		}
	case 268:
		{ /* '268' */
			return 319
		}
	case 269:
		{ /* '269' */
			return 320
		}
	case 27:
		{ /* '27' */
			return 42
		}
	case 270:
		{ /* '270' */
			return 321
		}
	case 271:
		{ /* '271' */
			return 322
		}
	case 272:
		{ /* '272' */
			return 323
		}
	case 273:
		{ /* '273' */
			return 324
		}
	case 274:
		{ /* '274' */
			return 325
		}
	case 275:
		{ /* '275' */
			return 326
		}
	case 276:
		{ /* '276' */
			return 327
		}
	case 277:
		{ /* '277' */
			return 328
		}
	case 278:
		{ /* '278' */
			return 329
		}
	case 279:
		{ /* '279' */
			return 330
		}
	case 28:
		{ /* '28' */
			return 44
		}
	case 280:
		{ /* '280' */
			return 331
		}
	case 281:
		{ /* '281' */
			return 332
		}
	case 282:
		{ /* '282' */
			return 333
		}
	case 283:
		{ /* '283' */
			return 334
		}
	case 284:
		{ /* '284' */
			return 335
		}
	case 285:
		{ /* '285' */
			return 336
		}
	case 286:
		{ /* '286' */
			return 337
		}
	case 287:
		{ /* '287' */
			return 338
		}
	case 288:
		{ /* '288' */
			return 339
		}
	case 289:
		{ /* '289' */
			return 340
		}
	case 29:
		{ /* '29' */
			return 45
		}
	case 290:
		{ /* '290' */
			return 341
		}
	case 291:
		{ /* '291' */
			return 342
		}
	case 292:
		{ /* '292' */
			return 343
		}
	case 293:
		{ /* '293' */
			return 344
		}
	case 294:
		{ /* '294' */
			return 345
		}
	case 295:
		{ /* '295' */
			return 346
		}
	case 296:
		{ /* '296' */
			return 347
		}
	case 297:
		{ /* '297' */
			return 348
		}
	case 298:
		{ /* '298' */
			return 349
		}
	case 299:
		{ /* '299' */
			return 350
		}
	case 3:
		{ /* '3' */
			return 4
		}
	case 30:
		{ /* '30' */
			return 46
		}
	case 300:
		{ /* '300' */
			return 351
		}
	case 301:
		{ /* '301' */
			return 352
		}
	case 302:
		{ /* '302' */
			return 353
		}
	case 303:
		{ /* '303' */
			return 354
		}
	case 304:
		{ /* '304' */
			return 355
		}
	case 305:
		{ /* '305' */
			return 356
		}
	case 306:
		{ /* '306' */
			return 357
		}
	case 307:
		{ /* '307' */
			return 358
		}
	case 308:
		{ /* '308' */
			return 359
		}
	case 309:
		{ /* '309' */
			return 360
		}
	case 31:
		{ /* '31' */
			return 49
		}
	case 310:
		{ /* '310' */
			return 361
		}
	case 311:
		{ /* '311' */
			return 362
		}
	case 312:
		{ /* '312' */
			return 363
		}
	case 313:
		{ /* '313' */
			return 364
		}
	case 314:
		{ /* '314' */
			return 365
		}
	case 315:
		{ /* '315' */
			return 366
		}
	case 316:
		{ /* '316' */
			return 367
		}
	case 317:
		{ /* '317' */
			return 368
		}
	case 318:
		{ /* '318' */
			return 369
		}
	case 319:
		{ /* '319' */
			return 370
		}
	case 32:
		{ /* '32' */
			return 52
		}
	case 320:
		{ /* '320' */
			return 371
		}
	case 321:
		{ /* '321' */
			return 372
		}
	case 322:
		{ /* '322' */
			return 373
		}
	case 323:
		{ /* '323' */
			return 374
		}
	case 324:
		{ /* '324' */
			return 375
		}
	case 325:
		{ /* '325' */
			return 376
		}
	case 326:
		{ /* '326' */
			return 377
		}
	case 327:
		{ /* '327' */
			return 378
		}
	case 328:
		{ /* '328' */
			return 379
		}
	case 329:
		{ /* '329' */
			return 380
		}
	case 33:
		{ /* '33' */
			return 53
		}
	case 330:
		{ /* '330' */
			return 381
		}
	case 331:
		{ /* '331' */
			return 382
		}
	case 332:
		{ /* '332' */
			return 383
		}
	case 333:
		{ /* '333' */
			return 384
		}
	case 334:
		{ /* '334' */
			return 385
		}
	case 335:
		{ /* '335' */
			return 386
		}
	case 336:
		{ /* '336' */
			return 387
		}
	case 337:
		{ /* '337' */
			return 388
		}
	case 338:
		{ /* '338' */
			return 389
		}
	case 339:
		{ /* '339' */
			return 390
		}
	case 34:
		{ /* '34' */
			return 55
		}
	case 340:
		{ /* '340' */
			return 391
		}
	case 341:
		{ /* '341' */
			return 392
		}
	case 342:
		{ /* '342' */
			return 393
		}
	case 343:
		{ /* '343' */
			return 394
		}
	case 344:
		{ /* '344' */
			return 395
		}
	case 345:
		{ /* '345' */
			return 396
		}
	case 346:
		{ /* '346' */
			return 397
		}
	case 347:
		{ /* '347' */
			return 398
		}
	case 348:
		{ /* '348' */
			return 399
		}
	case 349:
		{ /* '349' */
			return 400
		}
	case 35:
		{ /* '35' */
			return 56
		}
	case 350:
		{ /* '350' */
			return 401
		}
	case 351:
		{ /* '351' */
			return 402
		}
	case 352:
		{ /* '352' */
			return 403
		}
	case 353:
		{ /* '353' */
			return 404
		}
	case 354:
		{ /* '354' */
			return 405
		}
	case 355:
		{ /* '355' */
			return 406
		}
	case 356:
		{ /* '356' */
			return 407
		}
	case 357:
		{ /* '357' */
			return 408
		}
	case 358:
		{ /* '358' */
			return 409
		}
	case 359:
		{ /* '359' */
			return 410
		}
	case 36:
		{ /* '36' */
			return 57
		}
	case 360:
		{ /* '360' */
			return 411
		}
	case 361:
		{ /* '361' */
			return 412
		}
	case 362:
		{ /* '362' */
			return 413
		}
	case 363:
		{ /* '363' */
			return 414
		}
	case 364:
		{ /* '364' */
			return 415
		}
	case 365:
		{ /* '365' */
			return 416
		}
	case 366:
		{ /* '366' */
			return 417
		}
	case 367:
		{ /* '367' */
			return 418
		}
	case 368:
		{ /* '368' */
			return 419
		}
	case 369:
		{ /* '369' */
			return 420
		}
	case 37:
		{ /* '37' */
			return 61
		}
	case 370:
		{ /* '370' */
			return 421
		}
	case 371:
		{ /* '371' */
			return 422
		}
	case 372:
		{ /* '372' */
			return 423
		}
	case 373:
		{ /* '373' */
			return 424
		}
	case 374:
		{ /* '374' */
			return 425
		}
	case 375:
		{ /* '375' */
			return 426
		}
	case 376:
		{ /* '376' */
			return 427
		}
	case 377:
		{ /* '377' */
			return 428
		}
	case 378:
		{ /* '378' */
			return 429
		}
	case 379:
		{ /* '379' */
			return 430
		}
	case 38:
		{ /* '38' */
			return 62
		}
	case 380:
		{ /* '380' */
			return 431
		}
	case 381:
		{ /* '381' */
			return 432
		}
	case 382:
		{ /* '382' */
			return 433
		}
	case 383:
		{ /* '383' */
			return 434
		}
	case 384:
		{ /* '384' */
			return 435
		}
	case 385:
		{ /* '385' */
			return 436
		}
	case 386:
		{ /* '386' */
			return 437
		}
	case 387:
		{ /* '387' */
			return 438
		}
	case 388:
		{ /* '388' */
			return 439
		}
	case 389:
		{ /* '389' */
			return 440
		}
	case 39:
		{ /* '39' */
			return 66
		}
	case 390:
		{ /* '390' */
			return 441
		}
	case 391:
		{ /* '391' */
			return 442
		}
	case 392:
		{ /* '392' */
			return 443
		}
	case 393:
		{ /* '393' */
			return 444
		}
	case 394:
		{ /* '394' */
			return 445
		}
	case 395:
		{ /* '395' */
			return 446
		}
	case 396:
		{ /* '396' */
			return 447
		}
	case 397:
		{ /* '397' */
			return 448
		}
	case 398:
		{ /* '398' */
			return 449
		}
	case 399:
		{ /* '399' */
			return 451
		}
	case 4:
		{ /* '4' */
			return 5
		}
	case 40:
		{ /* '40' */
			return 67
		}
	case 400:
		{ /* '400' */
			return 452
		}
	case 401:
		{ /* '401' */
			return 453
		}
	case 402:
		{ /* '402' */
			return 454
		}
	case 403:
		{ /* '403' */
			return 455
		}
	case 404:
		{ /* '404' */
			return 456
		}
	case 405:
		{ /* '405' */
			return 457
		}
	case 406:
		{ /* '406' */
			return 458
		}
	case 407:
		{ /* '407' */
			return 459
		}
	case 408:
		{ /* '408' */
			return 460
		}
	case 409:
		{ /* '409' */
			return 461
		}
	case 41:
		{ /* '41' */
			return 69
		}
	case 410:
		{ /* '410' */
			return 462
		}
	case 411:
		{ /* '411' */
			return 463
		}
	case 412:
		{ /* '412' */
			return 464
		}
	case 413:
		{ /* '413' */
			return 465
		}
	case 414:
		{ /* '414' */
			return 466
		}
	case 415:
		{ /* '415' */
			return 467
		}
	case 416:
		{ /* '416' */
			return 468
		}
	case 417:
		{ /* '417' */
			return 469
		}
	case 418:
		{ /* '418' */
			return 470
		}
	case 419:
		{ /* '419' */
			return 471
		}
	case 42:
		{ /* '42' */
			return 71
		}
	case 420:
		{ /* '420' */
			return 472
		}
	case 421:
		{ /* '421' */
			return 473
		}
	case 422:
		{ /* '422' */
			return 474
		}
	case 423:
		{ /* '423' */
			return 475
		}
	case 424:
		{ /* '424' */
			return 476
		}
	case 425:
		{ /* '425' */
			return 477
		}
	case 426:
		{ /* '426' */
			return 478
		}
	case 427:
		{ /* '427' */
			return 479
		}
	case 428:
		{ /* '428' */
			return 480
		}
	case 429:
		{ /* '429' */
			return 481
		}
	case 43:
		{ /* '43' */
			return 72
		}
	case 430:
		{ /* '430' */
			return 482
		}
	case 431:
		{ /* '431' */
			return 483
		}
	case 432:
		{ /* '432' */
			return 484
		}
	case 433:
		{ /* '433' */
			return 485
		}
	case 434:
		{ /* '434' */
			return 486
		}
	case 435:
		{ /* '435' */
			return 487
		}
	case 436:
		{ /* '436' */
			return 488
		}
	case 437:
		{ /* '437' */
			return 489
		}
	case 438:
		{ /* '438' */
			return 490
		}
	case 439:
		{ /* '439' */
			return 491
		}
	case 44:
		{ /* '44' */
			return 73
		}
	case 440:
		{ /* '440' */
			return 492
		}
	case 441:
		{ /* '441' */
			return 493
		}
	case 442:
		{ /* '442' */
			return 495
		}
	case 443:
		{ /* '443' */
			return 496
		}
	case 444:
		{ /* '444' */
			return 497
		}
	case 445:
		{ /* '445' */
			return 498
		}
	case 446:
		{ /* '446' */
			return 499
		}
	case 447:
		{ /* '447' */
			return 500
		}
	case 448:
		{ /* '448' */
			return 501
		}
	case 449:
		{ /* '449' */
			return 502
		}
	case 45:
		{ /* '45' */
			return 75
		}
	case 450:
		{ /* '450' */
			return 503
		}
	case 451:
		{ /* '451' */
			return 504
		}
	case 452:
		{ /* '452' */
			return 505
		}
	case 453:
		{ /* '453' */
			return 506
		}
	case 454:
		{ /* '454' */
			return 507
		}
	case 455:
		{ /* '455' */
			return 508
		}
	case 456:
		{ /* '456' */
			return 509
		}
	case 457:
		{ /* '457' */
			return 512
		}
	case 458:
		{ /* '458' */
			return 513
		}
	case 459:
		{ /* '459' */
			return 514
		}
	case 46:
		{ /* '46' */
			return 76
		}
	case 460:
		{ /* '460' */
			return 515
		}
	case 461:
		{ /* '461' */
			return 516
		}
	case 462:
		{ /* '462' */
			return 517
		}
	case 463:
		{ /* '463' */
			return 518
		}
	case 464:
		{ /* '464' */
			return 519
		}
	case 465:
		{ /* '465' */
			return 520
		}
	case 466:
		{ /* '466' */
			return 521
		}
	case 467:
		{ /* '467' */
			return 522
		}
	case 468:
		{ /* '468' */
			return 523
		}
	case 469:
		{ /* '469' */
			return 524
		}
	case 47:
		{ /* '47' */
			return 78
		}
	case 470:
		{ /* '470' */
			return 525
		}
	case 471:
		{ /* '471' */
			return 526
		}
	case 472:
		{ /* '472' */
			return 527
		}
	case 473:
		{ /* '473' */
			return 528
		}
	case 474:
		{ /* '474' */
			return 529
		}
	case 475:
		{ /* '475' */
			return 530
		}
	case 476:
		{ /* '476' */
			return 531
		}
	case 477:
		{ /* '477' */
			return 532
		}
	case 478:
		{ /* '478' */
			return 533
		}
	case 479:
		{ /* '479' */
			return 534
		}
	case 48:
		{ /* '48' */
			return 80
		}
	case 480:
		{ /* '480' */
			return 535
		}
	case 481:
		{ /* '481' */
			return 536
		}
	case 482:
		{ /* '482' */
			return 537
		}
	case 483:
		{ /* '483' */
			return 538
		}
	case 484:
		{ /* '484' */
			return 539
		}
	case 485:
		{ /* '485' */
			return 540
		}
	case 486:
		{ /* '486' */
			return 541
		}
	case 487:
		{ /* '487' */
			return 542
		}
	case 488:
		{ /* '488' */
			return 543
		}
	case 489:
		{ /* '489' */
			return 544
		}
	case 49:
		{ /* '49' */
			return 81
		}
	case 490:
		{ /* '490' */
			return 545
		}
	case 491:
		{ /* '491' */
			return 546
		}
	case 492:
		{ /* '492' */
			return 547
		}
	case 493:
		{ /* '493' */
			return 548
		}
	case 494:
		{ /* '494' */
			return 549
		}
	case 495:
		{ /* '495' */
			return 550
		}
	case 496:
		{ /* '496' */
			return 551
		}
	case 497:
		{ /* '497' */
			return 552
		}
	case 498:
		{ /* '498' */
			return 553
		}
	case 499:
		{ /* '499' */
			return 554
		}
	case 5:
		{ /* '5' */
			return 6
		}
	case 50:
		{ /* '50' */
			return 82
		}
	case 500:
		{ /* '500' */
			return 555
		}
	case 501:
		{ /* '501' */
			return 556
		}
	case 502:
		{ /* '502' */
			return 557
		}
	case 503:
		{ /* '503' */
			return 558
		}
	case 504:
		{ /* '504' */
			return 559
		}
	case 505:
		{ /* '505' */
			return 560
		}
	case 506:
		{ /* '506' */
			return 561
		}
	case 507:
		{ /* '507' */
			return 562
		}
	case 508:
		{ /* '508' */
			return 563
		}
	case 509:
		{ /* '509' */
			return 564
		}
	case 51:
		{ /* '51' */
			return 83
		}
	case 510:
		{ /* '510' */
			return 565
		}
	case 511:
		{ /* '511' */
			return 566
		}
	case 512:
		{ /* '512' */
			return 567
		}
	case 513:
		{ /* '513' */
			return 568
		}
	case 514:
		{ /* '514' */
			return 569
		}
	case 515:
		{ /* '515' */
			return 570
		}
	case 516:
		{ /* '516' */
			return 571
		}
	case 517:
		{ /* '517' */
			return 572
		}
	case 518:
		{ /* '518' */
			return 573
		}
	case 519:
		{ /* '519' */
			return 574
		}
	case 52:
		{ /* '52' */
			return 85
		}
	case 520:
		{ /* '520' */
			return 575
		}
	case 521:
		{ /* '521' */
			return 576
		}
	case 522:
		{ /* '522' */
			return 577
		}
	case 523:
		{ /* '523' */
			return 578
		}
	case 524:
		{ /* '524' */
			return 579
		}
	case 525:
		{ /* '525' */
			return 580
		}
	case 526:
		{ /* '526' */
			return 581
		}
	case 527:
		{ /* '527' */
			return 582
		}
	case 528:
		{ /* '528' */
			return 583
		}
	case 529:
		{ /* '529' */
			return 584
		}
	case 53:
		{ /* '53' */
			return 89
		}
	case 530:
		{ /* '530' */
			return 585
		}
	case 531:
		{ /* '531' */
			return 586
		}
	case 532:
		{ /* '532' */
			return 587
		}
	case 533:
		{ /* '533' */
			return 588
		}
	case 534:
		{ /* '534' */
			return 589
		}
	case 535:
		{ /* '535' */
			return 590
		}
	case 536:
		{ /* '536' */
			return 591
		}
	case 537:
		{ /* '537' */
			return 592
		}
	case 538:
		{ /* '538' */
			return 593
		}
	case 539:
		{ /* '539' */
			return 594
		}
	case 54:
		{ /* '54' */
			return 90
		}
	case 540:
		{ /* '540' */
			return 595
		}
	case 541:
		{ /* '541' */
			return 596
		}
	case 542:
		{ /* '542' */
			return 597
		}
	case 543:
		{ /* '543' */
			return 598
		}
	case 544:
		{ /* '544' */
			return 599
		}
	case 545:
		{ /* '545' */
			return 600
		}
	case 546:
		{ /* '546' */
			return 601
		}
	case 547:
		{ /* '547' */
			return 602
		}
	case 548:
		{ /* '548' */
			return 603
		}
	case 549:
		{ /* '549' */
			return 604
		}
	case 55:
		{ /* '55' */
			return 92
		}
	case 550:
		{ /* '550' */
			return 605
		}
	case 551:
		{ /* '551' */
			return 606
		}
	case 552:
		{ /* '552' */
			return 607
		}
	case 553:
		{ /* '553' */
			return 608
		}
	case 554:
		{ /* '554' */
			return 609
		}
	case 555:
		{ /* '555' */
			return 610
		}
	case 556:
		{ /* '556' */
			return 611
		}
	case 557:
		{ /* '557' */
			return 612
		}
	case 558:
		{ /* '558' */
			return 613
		}
	case 559:
		{ /* '559' */
			return 614
		}
	case 56:
		{ /* '56' */
			return 93
		}
	case 560:
		{ /* '560' */
			return 615
		}
	case 561:
		{ /* '561' */
			return 616
		}
	case 562:
		{ /* '562' */
			return 617
		}
	case 563:
		{ /* '563' */
			return 618
		}
	case 564:
		{ /* '564' */
			return 619
		}
	case 565:
		{ /* '565' */
			return 620
		}
	case 566:
		{ /* '566' */
			return 621
		}
	case 567:
		{ /* '567' */
			return 622
		}
	case 568:
		{ /* '568' */
			return 623
		}
	case 569:
		{ /* '569' */
			return 624
		}
	case 57:
		{ /* '57' */
			return 94
		}
	case 570:
		{ /* '570' */
			return 625
		}
	case 571:
		{ /* '571' */
			return 627
		}
	case 572:
		{ /* '572' */
			return 628
		}
	case 573:
		{ /* '573' */
			return 629
		}
	case 574:
		{ /* '574' */
			return 630
		}
	case 575:
		{ /* '575' */
			return 631
		}
	case 576:
		{ /* '576' */
			return 632
		}
	case 577:
		{ /* '577' */
			return 633
		}
	case 578:
		{ /* '578' */
			return 634
		}
	case 579:
		{ /* '579' */
			return 635
		}
	case 58:
		{ /* '58' */
			return 95
		}
	case 580:
		{ /* '580' */
			return 636
		}
	case 581:
		{ /* '581' */
			return 637
		}
	case 582:
		{ /* '582' */
			return 638
		}
	case 583:
		{ /* '583' */
			return 639
		}
	case 584:
		{ /* '584' */
			return 640
		}
	case 585:
		{ /* '585' */
			return 641
		}
	case 586:
		{ /* '586' */
			return 642
		}
	case 587:
		{ /* '587' */
			return 643
		}
	case 588:
		{ /* '588' */
			return 644
		}
	case 589:
		{ /* '589' */
			return 645
		}
	case 59:
		{ /* '59' */
			return 97
		}
	case 590:
		{ /* '590' */
			return 646
		}
	case 591:
		{ /* '591' */
			return 647
		}
	case 592:
		{ /* '592' */
			return 648
		}
	case 593:
		{ /* '593' */
			return 649
		}
	case 594:
		{ /* '594' */
			return 650
		}
	case 595:
		{ /* '595' */
			return 651
		}
	case 596:
		{ /* '596' */
			return 652
		}
	case 597:
		{ /* '597' */
			return 653
		}
	case 598:
		{ /* '598' */
			return 654
		}
	case 599:
		{ /* '599' */
			return 656
		}
	case 6:
		{ /* '6' */
			return 7
		}
	case 60:
		{ /* '60' */
			return 98
		}
	case 600:
		{ /* '600' */
			return 657
		}
	case 601:
		{ /* '601' */
			return 658
		}
	case 602:
		{ /* '602' */
			return 659
		}
	case 603:
		{ /* '603' */
			return 660
		}
	case 604:
		{ /* '604' */
			return 661
		}
	case 605:
		{ /* '605' */
			return 662
		}
	case 606:
		{ /* '606' */
			return 663
		}
	case 607:
		{ /* '607' */
			return 664
		}
	case 608:
		{ /* '608' */
			return 665
		}
	case 609:
		{ /* '609' */
			return 666
		}
	case 61:
		{ /* '61' */
			return 99
		}
	case 610:
		{ /* '610' */
			return 667
		}
	case 611:
		{ /* '611' */
			return 668
		}
	case 612:
		{ /* '612' */
			return 669
		}
	case 613:
		{ /* '613' */
			return 670
		}
	case 614:
		{ /* '614' */
			return 671
		}
	case 615:
		{ /* '615' */
			return 672
		}
	case 616:
		{ /* '616' */
			return 673
		}
	case 617:
		{ /* '617' */
			return 674
		}
	case 618:
		{ /* '618' */
			return 675
		}
	case 619:
		{ /* '619' */
			return 676
		}
	case 62:
		{ /* '62' */
			return 100
		}
	case 620:
		{ /* '620' */
			return 677
		}
	case 621:
		{ /* '621' */
			return 678
		}
	case 622:
		{ /* '622' */
			return 679
		}
	case 623:
		{ /* '623' */
			return 680
		}
	case 624:
		{ /* '624' */
			return 681
		}
	case 625:
		{ /* '625' */
			return 682
		}
	case 626:
		{ /* '626' */
			return 683
		}
	case 627:
		{ /* '627' */
			return 684
		}
	case 628:
		{ /* '628' */
			return 685
		}
	case 629:
		{ /* '629' */
			return 686
		}
	case 63:
		{ /* '63' */
			return 101
		}
	case 630:
		{ /* '630' */
			return 687
		}
	case 631:
		{ /* '631' */
			return 688
		}
	case 632:
		{ /* '632' */
			return 689
		}
	case 633:
		{ /* '633' */
			return 690
		}
	case 634:
		{ /* '634' */
			return 691
		}
	case 635:
		{ /* '635' */
			return 692
		}
	case 636:
		{ /* '636' */
			return 693
		}
	case 637:
		{ /* '637' */
			return 695
		}
	case 638:
		{ /* '638' */
			return 696
		}
	case 639:
		{ /* '639' */
			return 697
		}
	case 64:
		{ /* '64' */
			return 102
		}
	case 640:
		{ /* '640' */
			return 698
		}
	case 641:
		{ /* '641' */
			return 699
		}
	case 642:
		{ /* '642' */
			return 700
		}
	case 643:
		{ /* '643' */
			return 701
		}
	case 644:
		{ /* '644' */
			return 702
		}
	case 645:
		{ /* '645' */
			return 703
		}
	case 646:
		{ /* '646' */
			return 704
		}
	case 647:
		{ /* '647' */
			return 705
		}
	case 648:
		{ /* '648' */
			return 706
		}
	case 649:
		{ /* '649' */
			return 707
		}
	case 65:
		{ /* '65' */
			return 104
		}
	case 650:
		{ /* '650' */
			return 708
		}
	case 651:
		{ /* '651' */
			return 709
		}
	case 652:
		{ /* '652' */
			return 710
		}
	case 653:
		{ /* '653' */
			return 711
		}
	case 654:
		{ /* '654' */
			return 712
		}
	case 655:
		{ /* '655' */
			return 713
		}
	case 656:
		{ /* '656' */
			return 714
		}
	case 657:
		{ /* '657' */
			return 715
		}
	case 658:
		{ /* '658' */
			return 716
		}
	case 659:
		{ /* '659' */
			return 717
		}
	case 66:
		{ /* '66' */
			return 105
		}
	case 660:
		{ /* '660' */
			return 718
		}
	case 661:
		{ /* '661' */
			return 719
		}
	case 662:
		{ /* '662' */
			return 720
		}
	case 663:
		{ /* '663' */
			return 721
		}
	case 664:
		{ /* '664' */
			return 722
		}
	case 665:
		{ /* '665' */
			return 723
		}
	case 666:
		{ /* '666' */
			return 724
		}
	case 667:
		{ /* '667' */
			return 725
		}
	case 668:
		{ /* '668' */
			return 726
		}
	case 669:
		{ /* '669' */
			return 727
		}
	case 67:
		{ /* '67' */
			return 106
		}
	case 670:
		{ /* '670' */
			return 728
		}
	case 671:
		{ /* '671' */
			return 729
		}
	case 672:
		{ /* '672' */
			return 730
		}
	case 673:
		{ /* '673' */
			return 731
		}
	case 674:
		{ /* '674' */
			return 732
		}
	case 675:
		{ /* '675' */
			return 733
		}
	case 676:
		{ /* '676' */
			return 734
		}
	case 677:
		{ /* '677' */
			return 735
		}
	case 678:
		{ /* '678' */
			return 736
		}
	case 679:
		{ /* '679' */
			return 737
		}
	case 68:
		{ /* '68' */
			return 107
		}
	case 680:
		{ /* '680' */
			return 738
		}
	case 681:
		{ /* '681' */
			return 739
		}
	case 682:
		{ /* '682' */
			return 740
		}
	case 683:
		{ /* '683' */
			return 741
		}
	case 684:
		{ /* '684' */
			return 742
		}
	case 685:
		{ /* '685' */
			return 743
		}
	case 686:
		{ /* '686' */
			return 744
		}
	case 687:
		{ /* '687' */
			return 745
		}
	case 688:
		{ /* '688' */
			return 746
		}
	case 689:
		{ /* '689' */
			return 747
		}
	case 69:
		{ /* '69' */
			return 108
		}
	case 690:
		{ /* '690' */
			return 748
		}
	case 691:
		{ /* '691' */
			return 749
		}
	case 692:
		{ /* '692' */
			return 750
		}
	case 693:
		{ /* '693' */
			return 751
		}
	case 694:
		{ /* '694' */
			return 752
		}
	case 695:
		{ /* '695' */
			return 753
		}
	case 696:
		{ /* '696' */
			return 754
		}
	case 697:
		{ /* '697' */
			return 755
		}
	case 698:
		{ /* '698' */
			return 756
		}
	case 699:
		{ /* '699' */
			return 757
		}
	case 7:
		{ /* '7' */
			return 8
		}
	case 70:
		{ /* '70' */
			return 109
		}
	case 700:
		{ /* '700' */
			return 758
		}
	case 701:
		{ /* '701' */
			return 759
		}
	case 702:
		{ /* '702' */
			return 760
		}
	case 703:
		{ /* '703' */
			return 761
		}
	case 704:
		{ /* '704' */
			return 762
		}
	case 705:
		{ /* '705' */
			return 763
		}
	case 706:
		{ /* '706' */
			return 764
		}
	case 707:
		{ /* '707' */
			return 765
		}
	case 708:
		{ /* '708' */
			return 766
		}
	case 709:
		{ /* '709' */
			return 769
		}
	case 71:
		{ /* '71' */
			return 110
		}
	case 710:
		{ /* '710' */
			return 771
		}
	case 711:
		{ /* '711' */
			return 772
		}
	case 712:
		{ /* '712' */
			return 773
		}
	case 713:
		{ /* '713' */
			return 774
		}
	case 714:
		{ /* '714' */
			return 775
		}
	case 715:
		{ /* '715' */
			return 776
		}
	case 716:
		{ /* '716' */
			return 777
		}
	case 717:
		{ /* '717' */
			return 778
		}
	case 718:
		{ /* '718' */
			return 779
		}
	case 719:
		{ /* '719' */
			return 780
		}
	case 72:
		{ /* '72' */
			return 111
		}
	case 720:
		{ /* '720' */
			return 781
		}
	case 721:
		{ /* '721' */
			return 782
		}
	case 722:
		{ /* '722' */
			return 783
		}
	case 723:
		{ /* '723' */
			return 784
		}
	case 724:
		{ /* '724' */
			return 785
		}
	case 725:
		{ /* '725' */
			return 786
		}
	case 726:
		{ /* '726' */
			return 787
		}
	case 727:
		{ /* '727' */
			return 788
		}
	case 728:
		{ /* '728' */
			return 789
		}
	case 729:
		{ /* '729' */
			return 790
		}
	case 73:
		{ /* '73' */
			return 112
		}
	case 730:
		{ /* '730' */
			return 791
		}
	case 731:
		{ /* '731' */
			return 792
		}
	case 732:
		{ /* '732' */
			return 793
		}
	case 733:
		{ /* '733' */
			return 794
		}
	case 734:
		{ /* '734' */
			return 795
		}
	case 735:
		{ /* '735' */
			return 796
		}
	case 736:
		{ /* '736' */
			return 797
		}
	case 737:
		{ /* '737' */
			return 798
		}
	case 738:
		{ /* '738' */
			return 799
		}
	case 739:
		{ /* '739' */
			return 800
		}
	case 74:
		{ /* '74' */
			return 113
		}
	case 740:
		{ /* '740' */
			return 801
		}
	case 741:
		{ /* '741' */
			return 802
		}
	case 742:
		{ /* '742' */
			return 803
		}
	case 743:
		{ /* '743' */
			return 804
		}
	case 744:
		{ /* '744' */
			return 805
		}
	case 745:
		{ /* '745' */
			return 806
		}
	case 746:
		{ /* '746' */
			return 807
		}
	case 747:
		{ /* '747' */
			return 808
		}
	case 748:
		{ /* '748' */
			return 809
		}
	case 749:
		{ /* '749' */
			return 810
		}
	case 75:
		{ /* '75' */
			return 114
		}
	case 750:
		{ /* '750' */
			return 43954
		}
	case 751:
		{ /* '751' */
			return 43959
		}
	case 76:
		{ /* '76' */
			return 115
		}
	case 77:
		{ /* '77' */
			return 116
		}
	case 78:
		{ /* '78' */
			return 117
		}
	case 79:
		{ /* '79' */
			return 118
		}
	case 8:
		{ /* '8' */
			return 9
		}
	case 80:
		{ /* '80' */
			return 119
		}
	case 81:
		{ /* '81' */
			return 120
		}
	case 82:
		{ /* '82' */
			return 121
		}
	case 83:
		{ /* '83' */
			return 122
		}
	case 84:
		{ /* '84' */
			return 123
		}
	case 85:
		{ /* '85' */
			return 124
		}
	case 86:
		{ /* '86' */
			return 125
		}
	case 87:
		{ /* '87' */
			return 126
		}
	case 88:
		{ /* '88' */
			return 127
		}
	case 89:
		{ /* '89' */
			return 128
		}
	case 9:
		{ /* '9' */
			return 10
		}
	case 90:
		{ /* '90' */
			return 129
		}
	case 91:
		{ /* '91' */
			return 130
		}
	case 92:
		{ /* '92' */
			return 131
		}
	case 93:
		{ /* '93' */
			return 132
		}
	case 94:
		{ /* '94' */
			return 133
		}
	case 95:
		{ /* '95' */
			return 134
		}
	case 96:
		{ /* '96' */
			return 135
		}
	case 97:
		{ /* '97' */
			return 136
		}
	case 98:
		{ /* '98' */
			return 137
		}
	case 99:
		{ /* '99' */
			return 138
		}
	default:
		{
			return 0
		}
	}
}

func KnxManufacturerFirstEnumForFieldNumber(value uint16) (enum KnxManufacturer, ok bool) {
	for _, sizeValue := range KnxManufacturerValues {
		if sizeValue.Number() == value {
			return sizeValue, true
		}
	}
	return 0, false
}

func (e KnxManufacturer) Name() string {
	switch e {
	case 0:
		{ /* '0' */
			return "Unknown Manufacturer"
		}
	case 1:
		{ /* '1' */
			return "Siemens"
		}
	case 10:
		{ /* '10' */
			return "LEGRAND Appareillage électrique"
		}
	case 100:
		{ /* '100' */
			return "Panasonic"
		}
	case 101:
		{ /* '101' */
			return "Pulse Technologies"
		}
	case 102:
		{ /* '102' */
			return "Crestron"
		}
	case 103:
		{ /* '103' */
			return "STEINEL professional"
		}
	case 104:
		{ /* '104' */
			return "BILTON LED Lighting"
		}
	case 105:
		{ /* '105' */
			return "denro AG"
		}
	case 106:
		{ /* '106' */
			return "GePro"
		}
	case 107:
		{ /* '107' */
			return "preussen automation"
		}
	case 108:
		{ /* '108' */
			return "Zoppas Industries"
		}
	case 109:
		{ /* '109' */
			return "MACTECH"
		}
	case 11:
		{ /* '11' */
			return "Merten"
		}
	case 110:
		{ /* '110' */
			return "TECHNO-TREND"
		}
	case 111:
		{ /* '111' */
			return "FS Cables"
		}
	case 112:
		{ /* '112' */
			return "Delta Dore"
		}
	case 113:
		{ /* '113' */
			return "Eissound"
		}
	case 114:
		{ /* '114' */
			return "Cisco"
		}
	case 115:
		{ /* '115' */
			return "Dinuy"
		}
	case 116:
		{ /* '116' */
			return "iKNiX"
		}
	case 117:
		{ /* '117' */
			return "Rademacher Geräte-Elektronik GmbH"
		}
	case 118:
		{ /* '118' */
			return "EGi Electroacustica General Iberica"
		}
	case 119:
		{ /* '119' */
			return "Bes – Ingenium"
		}
	case 12:
		{ /* '12' */
			return "ABB SpA-SACE Division"
		}
	case 120:
		{ /* '120' */
			return "ElabNET"
		}
	case 121:
		{ /* '121' */
			return "Blumotix"
		}
	case 122:
		{ /* '122' */
			return "Hunter Douglas"
		}
	case 123:
		{ /* '123' */
			return "APRICUM"
		}
	case 124:
		{ /* '124' */
			return "TIANSU Automation"
		}
	case 125:
		{ /* '125' */
			return "Bubendorff"
		}
	case 126:
		{ /* '126' */
			return "MBS GmbH"
		}
	case 127:
		{ /* '127' */
			return "Enertex Bayern GmbH"
		}
	case 128:
		{ /* '128' */
			return "BMS"
		}
	case 129:
		{ /* '129' */
			return "Sinapsi"
		}
	case 13:
		{ /* '13' */
			return "Siedle & Söhne"
		}
	case 130:
		{ /* '130' */
			return "Embedded Systems SIA"
		}
	case 131:
		{ /* '131' */
			return "KNX1"
		}
	case 132:
		{ /* '132' */
			return "Tokka"
		}
	case 133:
		{ /* '133' */
			return "NanoSense"
		}
	case 134:
		{ /* '134' */
			return "PEAR Automation GmbH"
		}
	case 135:
		{ /* '135' */
			return "DGA"
		}
	case 136:
		{ /* '136' */
			return "Lutron"
		}
	case 137:
		{ /* '137' */
			return "AIRZONE – ALTRA"
		}
	case 138:
		{ /* '138' */
			return "Lithoss Design Switches"
		}
	case 139:
		{ /* '139' */
			return "3ATEL"
		}
	case 14:
		{ /* '14' */
			return "Eberle"
		}
	case 140:
		{ /* '140' */
			return "Philips Controls"
		}
	case 141:
		{ /* '141' */
			return "VELUX A/S"
		}
	case 142:
		{ /* '142' */
			return "LOYTEC"
		}
	case 143:
		{ /* '143' */
			return "Ekinex S.p.A."
		}
	case 144:
		{ /* '144' */
			return "SIRLAN Technologies"
		}
	case 145:
		{ /* '145' */
			return "ProKNX SAS"
		}
	case 146:
		{ /* '146' */
			return "IT GmbH"
		}
	case 147:
		{ /* '147' */
			return "RENSON"
		}
	case 148:
		{ /* '148' */
			return "HEP Group"
		}
	case 149:
		{ /* '149' */
			return "Balmart"
		}
	case 15:
		{ /* '15' */
			return "GEWISS"
		}
	case 150:
		{ /* '150' */
			return "GFS GmbH"
		}
	case 151:
		{ /* '151' */
			return "Schenker Storen AG"
		}
	case 152:
		{ /* '152' */
			return "Algodue Elettronica S.r.L."
		}
	case 153:
		{ /* '153' */
			return "ABB France"
		}
	case 154:
		{ /* '154' */
			return "maintronic"
		}
	case 155:
		{ /* '155' */
			return "Vantage"
		}
	case 156:
		{ /* '156' */
			return "Foresis"
		}
	case 157:
		{ /* '157' */
			return "Research & Production Association SEM"
		}
	case 158:
		{ /* '158' */
			return "Weinzierl Engineering GmbH"
		}
	case 159:
		{ /* '159' */
			return "Möhlenhoff Wärmetechnik GmbH"
		}
	case 16:
		{ /* '16' */
			return "Albert Ackermann"
		}
	case 160:
		{ /* '160' */
			return "PKC-GROUP Oyj"
		}
	case 161:
		{ /* '161' */
			return "B.E.G."
		}
	case 162:
		{ /* '162' */
			return "Elsner Elektronik GmbH"
		}
	case 163:
		{ /* '163' */
			return "Siemens Building Technologies (HK/China) Ltd."
		}
	case 164:
		{ /* '164' */
			return "Eutrac"
		}
	case 165:
		{ /* '165' */
			return "Gustav Hensel GmbH & Co. KG"
		}
	case 166:
		{ /* '166' */
			return "GARO AB"
		}
	case 167:
		{ /* '167' */
			return "Waldmann Lichttechnik"
		}
	case 168:
		{ /* '168' */
			return "SCHÜCO"
		}
	case 169:
		{ /* '169' */
			return "EMU"
		}
	case 17:
		{ /* '17' */
			return "Schupa GmbH"
		}
	case 170:
		{ /* '170' */
			return "JNet Systems AG"
		}
	case 171:
		{ /* '171' */
			return "Total Solution GmbH"
		}
	case 172:
		{ /* '172' */
			return "O.Y.L. Electronics"
		}
	case 173:
		{ /* '173' */
			return "Galax System"
		}
	case 174:
		{ /* '174' */
			return "Disch"
		}
	case 175:
		{ /* '175' */
			return "Aucoteam"
		}
	case 176:
		{ /* '176' */
			return "Luxmate Controls"
		}
	case 177:
		{ /* '177' */
			return "Danfoss"
		}
	case 178:
		{ /* '178' */
			return "AST GmbH"
		}
	case 179:
		{ /* '179' */
			return "WILA Leuchten"
		}
	case 18:
		{ /* '18' */
			return "ABB SCHWEIZ"
		}
	case 180:
		{ /* '180' */
			return "b+b Automations- und Steuerungstechnik"
		}
	case 181:
		{ /* '181' */
			return "Lingg & Janke"
		}
	case 182:
		{ /* '182' */
			return "Sauter"
		}
	case 183:
		{ /* '183' */
			return "SIMU"
		}
	case 184:
		{ /* '184' */
			return "Theben HTS AG"
		}
	case 185:
		{ /* '185' */
			return "Amann GmbH"
		}
	case 186:
		{ /* '186' */
			return "BERG Energiekontrollsysteme GmbH"
		}
	case 187:
		{ /* '187' */
			return "Hüppe Form Sonnenschutzsysteme GmbH"
		}
	case 188:
		{ /* '188' */
			return "Oventrop KG"
		}
	case 189:
		{ /* '189' */
			return "Griesser AG"
		}
	case 19:
		{ /* '19' */
			return "Feller"
		}
	case 190:
		{ /* '190' */
			return "IPAS GmbH"
		}
	case 191:
		{ /* '191' */
			return "elero GmbH"
		}
	case 192:
		{ /* '192' */
			return "Ardan Production and Industrial Controls Ltd."
		}
	case 193:
		{ /* '193' */
			return "Metec Meßtechnik GmbH"
		}
	case 194:
		{ /* '194' */
			return "BÜRK MOBATIME"
		}
	case 195:
		{ /* '195' */
			return "ELKA-Elektronik GmbH"
		}
	case 196:
		{ /* '196' */
			return "ELEKTROANLAGEN D. NAGEL"
		}
	case 197:
		{ /* '197' */
			return "Tridonic Bauelemente GmbH"
		}
	case 198:
		{ /* '198' */
			return "Stengler Gesellschaft"
		}
	case 199:
		{ /* '199' */
			return "Schneider Electric (MG)"
		}
	case 2:
		{ /* '2' */
			return "ABB"
		}
	case 20:
		{ /* '20' */
			return "Glamox AS"
		}
	case 200:
		{ /* '200' */
			return "KNX Association"
		}
	case 201:
		{ /* '201' */
			return "VIVO"
		}
	case 202:
		{ /* '202' */
			return "Hugo Müller GmbH & Co KG"
		}
	case 203:
		{ /* '203' */
			return "Siemens HVAC"
		}
	case 204:
		{ /* '204' */
			return "APT"
		}
	case 205:
		{ /* '205' */
			return "HighDom"
		}
	case 206:
		{ /* '206' */
			return "Top Services"
		}
	case 207:
		{ /* '207' */
			return "ambiHome"
		}
	case 208:
		{ /* '208' */
			return "DATEC electronic AG"
		}
	case 209:
		{ /* '209' */
			return "ABUS Security-Center"
		}
	case 21:
		{ /* '21' */
			return "DEHN & SÖHNE"
		}
	case 210:
		{ /* '210' */
			return "Lite-Puter"
		}
	case 211:
		{ /* '211' */
			return "Tantron Electronic"
		}
	case 212:
		{ /* '212' */
			return "Interra"
		}
	case 213:
		{ /* '213' */
			return "DKX Tech"
		}
	case 214:
		{ /* '214' */
			return "Viatron"
		}
	case 215:
		{ /* '215' */
			return "Nautibus"
		}
	case 216:
		{ /* '216' */
			return "ON Semiconductor"
		}
	case 217:
		{ /* '217' */
			return "Longchuang"
		}
	case 218:
		{ /* '218' */
			return "Air-On AG"
		}
	case 219:
		{ /* '219' */
			return "ib-company GmbH"
		}
	case 22:
		{ /* '22' */
			return "CRABTREE"
		}
	case 220:
		{ /* '220' */
			return "Sation Factory"
		}
	case 221:
		{ /* '221' */
			return "Agentilo GmbH"
		}
	case 222:
		{ /* '222' */
			return "Makel Elektrik"
		}
	case 223:
		{ /* '223' */
			return "Helios Ventilatoren"
		}
	case 224:
		{ /* '224' */
			return "Otto Solutions Pte Ltd"
		}
	case 225:
		{ /* '225' */
			return "Airmaster"
		}
	case 226:
		{ /* '226' */
			return "Vallox GmbH"
		}
	case 227:
		{ /* '227' */
			return "Dalitek"
		}
	case 228:
		{ /* '228' */
			return "ASIN"
		}
	case 229:
		{ /* '229' */
			return "Bridges Intelligence Technology Inc."
		}
	case 23:
		{ /* '23' */
			return "eVoKNX"
		}
	case 230:
		{ /* '230' */
			return "ARBONIA"
		}
	case 231:
		{ /* '231' */
			return "KERMI"
		}
	case 232:
		{ /* '232' */
			return "PROLUX"
		}
	case 233:
		{ /* '233' */
			return "ClicHome"
		}
	case 234:
		{ /* '234' */
			return "COMMAX"
		}
	case 235:
		{ /* '235' */
			return "EAE"
		}
	case 236:
		{ /* '236' */
			return "Tense"
		}
	case 237:
		{ /* '237' */
			return "Seyoung Electronics"
		}
	case 238:
		{ /* '238' */
			return "Lifedomus"
		}
	case 239:
		{ /* '239' */
			return "EUROtronic Technology GmbH"
		}
	case 24:
		{ /* '24' */
			return "Paul Hochköpper"
		}
	case 240:
		{ /* '240' */
			return "tci"
		}
	case 241:
		{ /* '241' */
			return "Rishun Electronic"
		}
	case 242:
		{ /* '242' */
			return "Zipato"
		}
	case 243:
		{ /* '243' */
			return "cm-security GmbH & Co KG"
		}
	case 244:
		{ /* '244' */
			return "Qing Cables"
		}
	case 245:
		{ /* '245' */
			return "WOLF"
		}
	case 246:
		{ /* '246' */
			return "Coster Tecnologie Elettroniche S.p.A."
		}
	case 247:
		{ /* '247' */
			return "E.G.E"
		}
	case 248:
		{ /* '248' */
			return "NETxAutomation"
		}
	case 249:
		{ /* '249' */
			return "tecalor"
		}
	case 25:
		{ /* '25' */
			return "Altenburger Electronic"
		}
	case 250:
		{ /* '250' */
			return "Urmet Electronics (Huizhou) Ltd."
		}
	case 251:
		{ /* '251' */
			return "Peiying Building Control"
		}
	case 252:
		{ /* '252' */
			return "BPT S.p.A. a Socio Unico"
		}
	case 253:
		{ /* '253' */
			return "Kanontec - KanonBUS"
		}
	case 254:
		{ /* '254' */
			return "ISER Tech"
		}
	case 255:
		{ /* '255' */
			return "Fineline"
		}
	case 256:
		{ /* '256' */
			return "CP Electronics Ltd"
		}
	case 257:
		{ /* '257' */
			return "Niko-Servodan A/S"
		}
	case 258:
		{ /* '258' */
			return "Simon"
		}
	case 259:
		{ /* '259' */
			return "GM modular pvt. Ltd."
		}
	case 26:
		{ /* '26' */
			return "Grässlin"
		}
	case 260:
		{ /* '260' */
			return "FU CHENG Intelligence"
		}
	case 261:
		{ /* '261' */
			return "NexKon"
		}
	case 262:
		{ /* '262' */
			return "FEEL s.r.l"
		}
	case 263:
		{ /* '263' */
			return "Not Assigned"
		}
	case 264:
		{ /* '264' */
			return "Shenzhen Fanhai Sanjiang Electronics Co., Ltd."
		}
	case 265:
		{ /* '265' */
			return "Jiuzhou Greeble"
		}
	case 266:
		{ /* '266' */
			return "Aumüller Aumatic GmbH"
		}
	case 267:
		{ /* '267' */
			return "Etman Electric"
		}
	case 268:
		{ /* '268' */
			return "Black Nova"
		}
	case 269:
		{ /* '269' */
			return "ZidaTech AG"
		}
	case 27:
		{ /* '27' */
			return "Simon"
		}
	case 270:
		{ /* '270' */
			return "IDGS bvba"
		}
	case 271:
		{ /* '271' */
			return "dakanimo"
		}
	case 272:
		{ /* '272' */
			return "Trebor Automation AB"
		}
	case 273:
		{ /* '273' */
			return "Satel sp. z o.o."
		}
	case 274:
		{ /* '274' */
			return "Russound, Inc."
		}
	case 275:
		{ /* '275' */
			return "Midea Heating & Ventilating Equipment CO LTD"
		}
	case 276:
		{ /* '276' */
			return "Consorzio Terranuova"
		}
	case 277:
		{ /* '277' */
			return "Wolf Heiztechnik GmbH"
		}
	case 278:
		{ /* '278' */
			return "SONTEC"
		}
	case 279:
		{ /* '279' */
			return "Belcom Cables Ltd."
		}
	case 28:
		{ /* '28' */
			return "VIMAR"
		}
	case 280:
		{ /* '280' */
			return "Guangzhou SeaWin Electrical Technologies Co., Ltd."
		}
	case 281:
		{ /* '281' */
			return "Acrel"
		}
	case 282:
		{ /* '282' */
			return "KWC Aquarotter GmbH"
		}
	case 283:
		{ /* '283' */
			return "Orion Systems"
		}
	case 284:
		{ /* '284' */
			return "Schrack Technik GmbH"
		}
	case 285:
		{ /* '285' */
			return "INSPRID"
		}
	case 286:
		{ /* '286' */
			return "Sunricher"
		}
	case 287:
		{ /* '287' */
			return "Menred automation system(shanghai) Co.,Ltd."
		}
	case 288:
		{ /* '288' */
			return "Aurex"
		}
	case 289:
		{ /* '289' */
			return "Josef Barthelme GmbH & Co. KG"
		}
	case 29:
		{ /* '29' */
			return "Moeller Gebäudeautomation KG"
		}
	case 290:
		{ /* '290' */
			return "Architecture Numerique"
		}
	case 291:
		{ /* '291' */
			return "UP GROUP"
		}
	case 292:
		{ /* '292' */
			return "Teknos-Avinno"
		}
	case 293:
		{ /* '293' */
			return "Ningbo Dooya Mechanic & Electronic Technology"
		}
	case 294:
		{ /* '294' */
			return "Thermokon Sensortechnik GmbH"
		}
	case 295:
		{ /* '295' */
			return "BELIMO Automation AG"
		}
	case 296:
		{ /* '296' */
			return "Zehnder Group International AG"
		}
	case 297:
		{ /* '297' */
			return "sks Kinkel Elektronik"
		}
	case 298:
		{ /* '298' */
			return "ECE Wurmitzer GmbH"
		}
	case 299:
		{ /* '299' */
			return "LARS"
		}
	case 3:
		{ /* '3' */
			return "Albrecht Jung"
		}
	case 30:
		{ /* '30' */
			return "Eltako"
		}
	case 300:
		{ /* '300' */
			return "URC"
		}
	case 301:
		{ /* '301' */
			return "LightControl"
		}
	case 302:
		{ /* '302' */
			return "ShenZhen YM"
		}
	case 303:
		{ /* '303' */
			return "MEAN WELL Enterprises Co. Ltd."
		}
	case 304:
		{ /* '304' */
			return "OSix"
		}
	case 305:
		{ /* '305' */
			return "AYPRO Technology"
		}
	case 306:
		{ /* '306' */
			return "Hefei Ecolite Software"
		}
	case 307:
		{ /* '307' */
			return "Enno"
		}
	case 308:
		{ /* '308' */
			return "OHOSURE"
		}
	case 309:
		{ /* '309' */
			return "Garefowl"
		}
	case 31:
		{ /* '31' */
			return "Bosch-Siemens Haushaltsgeräte"
		}
	case 310:
		{ /* '310' */
			return "GEZE"
		}
	case 311:
		{ /* '311' */
			return "LG Electronics Inc."
		}
	case 312:
		{ /* '312' */
			return "SMC interiors"
		}
	case 313:
		{ /* '313' */
			return "Not Assigned"
		}
	case 314:
		{ /* '314' */
			return "SCS Cable"
		}
	case 315:
		{ /* '315' */
			return "Hoval"
		}
	case 316:
		{ /* '316' */
			return "CANST"
		}
	case 317:
		{ /* '317' */
			return "HangZhou Berlin"
		}
	case 318:
		{ /* '318' */
			return "EVN-Lichttechnik"
		}
	case 319:
		{ /* '319' */
			return "rutec"
		}
	case 32:
		{ /* '32' */
			return "RITTO GmbH&Co.KG"
		}
	case 320:
		{ /* '320' */
			return "Finder"
		}
	case 321:
		{ /* '321' */
			return "Fujitsu General Limited"
		}
	case 322:
		{ /* '322' */
			return "ZF Friedrichshafen AG"
		}
	case 323:
		{ /* '323' */
			return "Crealed"
		}
	case 324:
		{ /* '324' */
			return "Miles Magic Automation Private Limited"
		}
	case 325:
		{ /* '325' */
			return "E+"
		}
	case 326:
		{ /* '326' */
			return "Italcond"
		}
	case 327:
		{ /* '327' */
			return "SATION"
		}
	case 328:
		{ /* '328' */
			return "NewBest"
		}
	case 329:
		{ /* '329' */
			return "GDS DIGITAL SYSTEMS"
		}
	case 33:
		{ /* '33' */
			return "Power Controls"
		}
	case 330:
		{ /* '330' */
			return "Iddero"
		}
	case 331:
		{ /* '331' */
			return "MBNLED"
		}
	case 332:
		{ /* '332' */
			return "VITRUM"
		}
	case 333:
		{ /* '333' */
			return "ekey biometric systems GmbH"
		}
	case 334:
		{ /* '334' */
			return "AMC"
		}
	case 335:
		{ /* '335' */
			return "TRILUX GmbH & Co. KG"
		}
	case 336:
		{ /* '336' */
			return "WExcedo"
		}
	case 337:
		{ /* '337' */
			return "VEMER SPA"
		}
	case 338:
		{ /* '338' */
			return "Alexander Bürkle GmbH & Co KG"
		}
	case 339:
		{ /* '339' */
			return "Citron"
		}
	case 34:
		{ /* '34' */
			return "ZUMTOBEL"
		}
	case 340:
		{ /* '340' */
			return "Shenzhen HeGuang"
		}
	case 341:
		{ /* '341' */
			return "Not Assigned"
		}
	case 342:
		{ /* '342' */
			return "TRANE B.V.B.A"
		}
	case 343:
		{ /* '343' */
			return "CAREL"
		}
	case 344:
		{ /* '344' */
			return "Prolite Controls"
		}
	case 345:
		{ /* '345' */
			return "BOSMER"
		}
	case 346:
		{ /* '346' */
			return "EUCHIPS"
		}
	case 347:
		{ /* '347' */
			return "connect (Thinka connect)"
		}
	case 348:
		{ /* '348' */
			return "PEAKnx a DOGAWIST company"
		}
	case 349:
		{ /* '349' */
			return "ACEMATIC"
		}
	case 35:
		{ /* '35' */
			return "HOLEC Systemen"
		}
	case 350:
		{ /* '350' */
			return "ELAUSYS"
		}
	case 351:
		{ /* '351' */
			return "ITK Engineering AG"
		}
	case 352:
		{ /* '352' */
			return "INTEGRA METERING AG"
		}
	case 353:
		{ /* '353' */
			return "FMS Hospitality Pte Ltd"
		}
	case 354:
		{ /* '354' */
			return "Nuvo"
		}
	case 355:
		{ /* '355' */
			return "u::Lux GmbH"
		}
	case 356:
		{ /* '356' */
			return "Brumberg Leuchten"
		}
	case 357:
		{ /* '357' */
			return "Lime"
		}
	case 358:
		{ /* '358' */
			return "Great Empire International Group Co., Ltd."
		}
	case 359:
		{ /* '359' */
			return "Kavoshpishro Asia"
		}
	case 36:
		{ /* '36' */
			return "Phoenix Contact"
		}
	case 360:
		{ /* '360' */
			return "V2 SpA"
		}
	case 361:
		{ /* '361' */
			return "Johnson Controls"
		}
	case 362:
		{ /* '362' */
			return "Arkud"
		}
	case 363:
		{ /* '363' */
			return "iRidi Ltd."
		}
	case 364:
		{ /* '364' */
			return "bsmart"
		}
	case 365:
		{ /* '365' */
			return "BAB TECHNOLOGIE GmbH"
		}
	case 366:
		{ /* '366' */
			return "NICE Spa"
		}
	case 367:
		{ /* '367' */
			return "Redfish Group Pty Ltd"
		}
	case 368:
		{ /* '368' */
			return "SABIANA spa"
		}
	case 369:
		{ /* '369' */
			return "Ubee Interactive Europe"
		}
	case 37:
		{ /* '37' */
			return "WAGO GmbH & Co.KG"
		}
	case 370:
		{ /* '370' */
			return "Rexel"
		}
	case 371:
		{ /* '371' */
			return "Ges Teknik A.S."
		}
	case 372:
		{ /* '372' */
			return "Ave S.p.A."
		}
	case 373:
		{ /* '373' */
			return "Zhuhai Ltech Technology Co., Ltd."
		}
	case 374:
		{ /* '374' */
			return "ARCOM"
		}
	case 375:
		{ /* '375' */
			return "VIA Technologies, Inc."
		}
	case 376:
		{ /* '376' */
			return "FEELSMART."
		}
	case 377:
		{ /* '377' */
			return "SUPCON"
		}
	case 378:
		{ /* '378' */
			return "MANIC"
		}
	case 379:
		{ /* '379' */
			return "TDE GmbH"
		}
	case 38:
		{ /* '38' */
			return "knXpresso"
		}
	case 380:
		{ /* '380' */
			return "Nanjing Shufan Information technology Co.,Ltd."
		}
	case 381:
		{ /* '381' */
			return "EWTech"
		}
	case 382:
		{ /* '382' */
			return "Kluger Automation GmbH"
		}
	case 383:
		{ /* '383' */
			return "JoongAng Control"
		}
	case 384:
		{ /* '384' */
			return "GreenControls Technology Sdn. Bhd."
		}
	case 385:
		{ /* '385' */
			return "IME S.p.a."
		}
	case 386:
		{ /* '386' */
			return "SiChuan HaoDing"
		}
	case 387:
		{ /* '387' */
			return "Mindjaga Ltd."
		}
	case 388:
		{ /* '388' */
			return "RuiLi Smart Control"
		}
	case 389:
		{ /* '389' */
			return "CODESYS GmbH"
		}
	case 39:
		{ /* '39' */
			return "Wieland Electric"
		}
	case 390:
		{ /* '390' */
			return "Moorgen Deutschland GmbH"
		}
	case 391:
		{ /* '391' */
			return "CULLMANN TECH"
		}
	case 392:
		{ /* '392' */
			return "eyrise B.V"
		}
	case 393:
		{ /* '393' */
			return "Dobnel"
		}
	case 394:
		{ /* '394' */
			return "myGEKKO"
		}
	case 395:
		{ /* '395' */
			return "Ergo3 Sarl"
		}
	case 396:
		{ /* '396' */
			return "STmicroelectronics International N.V."
		}
	case 397:
		{ /* '397' */
			return "cjc systems"
		}
	case 398:
		{ /* '398' */
			return "Sudoku"
		}
	case 399:
		{ /* '399' */
			return "AZ e-lite Pte Ltd"
		}
	case 4:
		{ /* '4' */
			return "Bticino"
		}
	case 40:
		{ /* '40' */
			return "Hermann Kleinhuis"
		}
	case 400:
		{ /* '400' */
			return "Arlight"
		}
	case 401:
		{ /* '401' */
			return "Grünbeck Wasseraufbereitung GmbH"
		}
	case 402:
		{ /* '402' */
			return "Module Electronic"
		}
	case 403:
		{ /* '403' */
			return "KOPLAT"
		}
	case 404:
		{ /* '404' */
			return "Guangzhou Letour Life Technology Co., Ltd"
		}
	case 405:
		{ /* '405' */
			return "ILEVIA"
		}
	case 406:
		{ /* '406' */
			return "LN SYSTEMTEQ"
		}
	case 407:
		{ /* '407' */
			return "Hisense SmartHome"
		}
	case 408:
		{ /* '408' */
			return "Flink Automation System"
		}
	case 409:
		{ /* '409' */
			return "xxter bv"
		}
	case 41:
		{ /* '41' */
			return "Stiebel Eltron"
		}
	case 410:
		{ /* '410' */
			return "lynxus technology"
		}
	case 411:
		{ /* '411' */
			return "ROBOT S.A."
		}
	case 412:
		{ /* '412' */
			return "Shenzhen Atte Smart Life Co.,Ltd."
		}
	case 413:
		{ /* '413' */
			return "Noblesse"
		}
	case 414:
		{ /* '414' */
			return "Advanced Devices"
		}
	case 415:
		{ /* '415' */
			return "Atrina Building Automation Co. Ltd"
		}
	case 416:
		{ /* '416' */
			return "Guangdong Daming Laffey electric Co., Ltd."
		}
	case 417:
		{ /* '417' */
			return "Westerstrand Urfabrik AB"
		}
	case 418:
		{ /* '418' */
			return "Control4 Corporate"
		}
	case 419:
		{ /* '419' */
			return "Ontrol"
		}
	case 42:
		{ /* '42' */
			return "Tehalit"
		}
	case 420:
		{ /* '420' */
			return "Starnet"
		}
	case 421:
		{ /* '421' */
			return "BETA CAVI"
		}
	case 422:
		{ /* '422' */
			return "Hangzhou YiYue Technology Co., Ltd."
		}
	case 423:
		{ /* '423' */
			return "Vivaldi srl"
		}
	case 424:
		{ /* '424' */
			return "Gree Electric Appliances,Inc. of Zhuhai"
		}
	case 425:
		{ /* '425' */
			return "HWISCON"
		}
	case 426:
		{ /* '426' */
			return "Shanghai ELECON Intelligent Technology Co., Ltd."
		}
	case 427:
		{ /* '427' */
			return "Kampmann"
		}
	case 428:
		{ /* '428' */
			return "Impolux GmbH / LEDIMAX"
		}
	case 429:
		{ /* '429' */
			return "Evaux"
		}
	case 43:
		{ /* '43' */
			return "Theben AG"
		}
	case 430:
		{ /* '430' */
			return "Webro Cables & Connectors Limited"
		}
	case 431:
		{ /* '431' */
			return "Shanghai E-tech Solution"
		}
	case 432:
		{ /* '432' */
			return "Guangzhou HOKO Electric Co.,Ltd."
		}
	case 433:
		{ /* '433' */
			return "LAMMIN HIGH TECH CO.,LTD"
		}
	case 434:
		{ /* '434' */
			return "Shenzhen Merrytek Technology Co., Ltd"
		}
	case 435:
		{ /* '435' */
			return "I-Luxus"
		}
	case 436:
		{ /* '436' */
			return "Elmos Semiconductor AG"
		}
	case 437:
		{ /* '437' */
			return "EmCom Technology Inc"
		}
	case 438:
		{ /* '438' */
			return "project innovations GmbH"
		}
	case 439:
		{ /* '439' */
			return "Itc"
		}
	case 44:
		{ /* '44' */
			return "Wilhelm Rutenbeck"
		}
	case 440:
		{ /* '440' */
			return "ABB LV Installation Materials Company Ltd, Beijing"
		}
	case 441:
		{ /* '441' */
			return "Maico"
		}
	case 442:
		{ /* '442' */
			return "ELAN SRL"
		}
	case 443:
		{ /* '443' */
			return "MinhHa Technology co.,Ltd"
		}
	case 444:
		{ /* '444' */
			return "Zhejiang Tianjie Industrial CORP."
		}
	case 445:
		{ /* '445' */
			return "iAutomation Pty Limited"
		}
	case 446:
		{ /* '446' */
			return "Extron"
		}
	case 447:
		{ /* '447' */
			return "Freedompro"
		}
	case 448:
		{ /* '448' */
			return "1Home"
		}
	case 449:
		{ /* '449' */
			return "EOS Saunatechnik GmbH"
		}
	case 45:
		{ /* '45' */
			return "Winkhaus"
		}
	case 450:
		{ /* '450' */
			return "KUSATEK GmbH"
		}
	case 451:
		{ /* '451' */
			return "Alexander Maier GmbH"
		}
	case 452:
		{ /* '452' */
			return "AUTOMATISMI BENINCA S.P.A."
		}
	case 453:
		{ /* '453' */
			return "Blendom"
		}
	case 454:
		{ /* '454' */
			return "Madel Air Technical diffusion"
		}
	case 455:
		{ /* '455' */
			return "NIKO"
		}
	case 456:
		{ /* '456' */
			return "Bosch Rexroth AG"
		}
	case 457:
		{ /* '457' */
			return "C&M Products"
		}
	case 458:
		{ /* '458' */
			return "Hörmann KG Verkaufsgesellschaft"
		}
	case 459:
		{ /* '459' */
			return "Shanghai Rajayasa co.,LTD"
		}
	case 46:
		{ /* '46' */
			return "Robert Bosch"
		}
	case 460:
		{ /* '460' */
			return "SUZUKI"
		}
	case 461:
		{ /* '461' */
			return "Silent Gliss International Ltd."
		}
	case 462:
		{ /* '462' */
			return "BEE Controls (ADGSC Group)"
		}
	case 463:
		{ /* '463' */
			return "xDTecGmbH"
		}
	case 464:
		{ /* '464' */
			return "OSRAM"
		}
	case 465:
		{ /* '465' */
			return "Lebenor"
		}
	case 466:
		{ /* '466' */
			return "automaneng"
		}
	case 467:
		{ /* '467' */
			return "Honeywell Automation Control Solutions(China)CoLtd"
		}
	case 468:
		{ /* '468' */
			return "Hangzhou binthen Intelligence Technology Co.,Ltd"
		}
	case 469:
		{ /* '469' */
			return "ETA Heiztechnik"
		}
	case 47:
		{ /* '47' */
			return "Somfy"
		}
	case 470:
		{ /* '470' */
			return "DIVUS GmbH"
		}
	case 471:
		{ /* '471' */
			return "Nanjing Taijiesai Intelligent Technology Co. Ltd."
		}
	case 472:
		{ /* '472' */
			return "Lunatone"
		}
	case 473:
		{ /* '473' */
			return "ZHEJIANG SCTECH BUILDING INTELLIGENT"
		}
	case 474:
		{ /* '474' */
			return "Foshan Qite Technology Co., Ltd."
		}
	case 475:
		{ /* '475' */
			return "NOKE"
		}
	case 476:
		{ /* '476' */
			return "LANDCOM"
		}
	case 477:
		{ /* '477' */
			return "Stork AS"
		}
	case 478:
		{ /* '478' */
			return "Hangzhou Shendu Technology Co., Ltd."
		}
	case 479:
		{ /* '479' */
			return "CoolAutomation"
		}
	case 48:
		{ /* '48' */
			return "Woertz"
		}
	case 480:
		{ /* '480' */
			return "Aprstern"
		}
	case 481:
		{ /* '481' */
			return "sonnen"
		}
	case 482:
		{ /* '482' */
			return "DNAKE"
		}
	case 483:
		{ /* '483' */
			return "Neuberger Gebäudeautomation GmbH"
		}
	case 484:
		{ /* '484' */
			return "Stiliger"
		}
	case 485:
		{ /* '485' */
			return "Berghof Automation GmbH"
		}
	case 486:
		{ /* '486' */
			return "Total Automation and controls GmbH"
		}
	case 487:
		{ /* '487' */
			return "DOVIT"
		}
	case 488:
		{ /* '488' */
			return "Instalighting GmbH"
		}
	case 489:
		{ /* '489' */
			return "UNI-TEC"
		}
	case 49:
		{ /* '49' */
			return "Viessmann Werke"
		}
	case 490:
		{ /* '490' */
			return "CasaTunes"
		}
	case 491:
		{ /* '491' */
			return "EMT"
		}
	case 492:
		{ /* '492' */
			return "Senfficient"
		}
	case 493:
		{ /* '493' */
			return "Aurolite electrical panyu guangzhou limited"
		}
	case 494:
		{ /* '494' */
			return "ABB Xiamen Smart Technology Co., Ltd."
		}
	case 495:
		{ /* '495' */
			return "Samson Electric Wire"
		}
	case 496:
		{ /* '496' */
			return "T-Touching"
		}
	case 497:
		{ /* '497' */
			return "Core Smart Home"
		}
	case 498:
		{ /* '498' */
			return "GreenConnect Solutions SA"
		}
	case 499:
		{ /* '499' */
			return "ELETTRONICA CONDUTTORI"
		}
	case 5:
		{ /* '5' */
			return "Berker"
		}
	case 50:
		{ /* '50' */
			return "IMI Hydronic Engineering"
		}
	case 500:
		{ /* '500' */
			return "MKFC"
		}
	case 501:
		{ /* '501' */
			return "Automation+"
		}
	case 502:
		{ /* '502' */
			return "blue and red"
		}
	case 503:
		{ /* '503' */
			return "frogblue"
		}
	case 504:
		{ /* '504' */
			return "LUXIO"
		}
	case 505:
		{ /* '505' */
			return "App Tech"
		}
	case 506:
		{ /* '506' */
			return "sensortec AG"
		}
	case 507:
		{ /* '507' */
			return "nysa technology & solutions"
		}
	case 508:
		{ /* '508' */
			return "FARADITE"
		}
	case 509:
		{ /* '509' */
			return "Optimus"
		}
	case 51:
		{ /* '51' */
			return "Joh. Vaillant"
		}
	case 510:
		{ /* '510' */
			return "KTS s.r.l."
		}
	case 511:
		{ /* '511' */
			return "Ramcro SPA"
		}
	case 512:
		{ /* '512' */
			return "Wuhan WiseCreate Universe Technology Co., Ltd"
		}
	case 513:
		{ /* '513' */
			return "BEMI Smart Home Ltd"
		}
	case 514:
		{ /* '514' */
			return "Ardomus"
		}
	case 515:
		{ /* '515' */
			return "ChangXing"
		}
	case 516:
		{ /* '516' */
			return "E-Controls"
		}
	case 517:
		{ /* '517' */
			return "AIB Technology"
		}
	case 518:
		{ /* '518' */
			return "NVC"
		}
	case 519:
		{ /* '519' */
			return "Kbox"
		}
	case 52:
		{ /* '52' */
			return "AMP Deutschland"
		}
	case 520:
		{ /* '520' */
			return "CNS"
		}
	case 521:
		{ /* '521' */
			return "Tyba"
		}
	case 522:
		{ /* '522' */
			return "Atrel"
		}
	case 523:
		{ /* '523' */
			return "Simon Electric (China) Co., LTD"
		}
	case 524:
		{ /* '524' */
			return "Kordz Group"
		}
	case 525:
		{ /* '525' */
			return "ND Electric"
		}
	case 526:
		{ /* '526' */
			return "Controlium"
		}
	case 527:
		{ /* '527' */
			return "FAMO GmbH & Co. KG"
		}
	case 528:
		{ /* '528' */
			return "CDN Smart"
		}
	case 529:
		{ /* '529' */
			return "Heston"
		}
	case 53:
		{ /* '53' */
			return "Bosch Thermotechnik GmbH"
		}
	case 530:
		{ /* '530' */
			return "ESLA CONEXIONES S.L."
		}
	case 531:
		{ /* '531' */
			return "Weishaupt"
		}
	case 532:
		{ /* '532' */
			return "ASTRUM TECHNOLOGY"
		}
	case 533:
		{ /* '533' */
			return "WUERTH ELEKTRONIK STELVIO KONTEK S.p.A."
		}
	case 534:
		{ /* '534' */
			return "NANOTECO corporation"
		}
	case 535:
		{ /* '535' */
			return "Nietian"
		}
	case 536:
		{ /* '536' */
			return "Sumsir"
		}
	case 537:
		{ /* '537' */
			return "ORBIS TECNOLOGIA ELECTRICA SA"
		}
	case 538:
		{ /* '538' */
			return "Nanjing Zhongyi IoT Technology Co., Ltd."
		}
	case 539:
		{ /* '539' */
			return "Anlips"
		}
	case 54:
		{ /* '54' */
			return "SEF - ECOTEC"
		}
	case 540:
		{ /* '540' */
			return "GUANGDONG PAK CORPORATION CO., LTD"
		}
	case 541:
		{ /* '541' */
			return "BVK Technology"
		}
	case 542:
		{ /* '542' */
			return "Solomio srl"
		}
	case 543:
		{ /* '543' */
			return "Domotica Labs"
		}
	case 544:
		{ /* '544' */
			return "NVC International"
		}
	case 545:
		{ /* '545' */
			return "BA"
		}
	case 546:
		{ /* '546' */
			return "Iris Ceramica Group"
		}
	case 547:
		{ /* '547' */
			return "Wireeo"
		}
	case 548:
		{ /* '548' */
			return "nvclighting"
		}
	case 549:
		{ /* '549' */
			return "Jinan Tian Da Sheng Information Technology Co."
		}
	case 55:
		{ /* '55' */
			return "DORMA GmbH + Co. KG"
		}
	case 550:
		{ /* '550' */
			return "Armiti trading"
		}
	case 551:
		{ /* '551' */
			return "ELEK"
		}
	case 552:
		{ /* '552' */
			return "Accordia sa"
		}
	case 553:
		{ /* '553' */
			return "OURICAN"
		}
	case 554:
		{ /* '554' */
			return "INLIWOSE"
		}
	case 555:
		{ /* '555' */
			return "Bosch (Shanghai) Smart Life Technology Ltd."
		}
	case 556:
		{ /* '556' */
			return "SHK KNX"
		}
	case 557:
		{ /* '557' */
			return "Ampio"
		}
	case 558:
		{ /* '558' */
			return "Mingxing Wisdom"
		}
	case 559:
		{ /* '559' */
			return "ALTEN SW GmbH"
		}
	case 56:
		{ /* '56' */
			return "WindowMaster A/S"
		}
	case 560:
		{ /* '560' */
			return "V.Y.C.srl"
		}
	case 561:
		{ /* '561' */
			return "TERMINUS GROUP"
		}
	case 562:
		{ /* '562' */
			return "Wonderful City Technology"
		}
	case 563:
		{ /* '563' */
			return "QbicTechnology"
		}
	case 564:
		{ /* '564' */
			return "Embedded Automation Equipment (Shanghai) Limited"
		}
	case 565:
		{ /* '565' */
			return "onework"
		}
	case 566:
		{ /* '566' */
			return "PL LINK"
		}
	case 567:
		{ /* '567' */
			return "Fasel GmbH Elektronik"
		}
	case 568:
		{ /* '568' */
			return "GoldenHome Smart"
		}
	case 569:
		{ /* '569' */
			return "Goldmedal"
		}
	case 57:
		{ /* '57' */
			return "Walther Werke"
		}
	case 570:
		{ /* '570' */
			return "Can'nX"
		}
	case 571:
		{ /* '571' */
			return "EGI - Earth Goodness"
		}
	case 572:
		{ /* '572' */
			return "Viega GmbH & Co. KG"
		}
	case 573:
		{ /* '573' */
			return "Fredon Digital Buildings"
		}
	case 574:
		{ /* '574' */
			return "Helukabel (Thailand) Co.,Ltd."
		}
	case 575:
		{ /* '575' */
			return "SICS"
		}
	case 576:
		{ /* '576' */
			return "MEX Electric Technology (Shanghai) Co., Ltd"
		}
	case 577:
		{ /* '577' */
			return "SUMAMO"
		}
	case 578:
		{ /* '578' */
			return "SVIT"
		}
	case 579:
		{ /* '579' */
			return "tecget"
		}
	case 58:
		{ /* '58' */
			return "ORAS"
		}
	case 580:
		{ /* '580' */
			return "Xeropoint"
		}
	case 581:
		{ /* '581' */
			return "Honeywell Building Technologies"
		}
	case 582:
		{ /* '582' */
			return "ComfortClick"
		}
	case 583:
		{ /* '583' */
			return "DORBAS ELECTRIC"
		}
	case 584:
		{ /* '584' */
			return "REMKO GmbH & Co. KG"
		}
	case 585:
		{ /* '585' */
			return "Shenzhen Congxun Intelligent Technology Co., LTD"
		}
	case 586:
		{ /* '586' */
			return "ANDAS"
		}
	case 587:
		{ /* '587' */
			return "Hefei Chuang Yue Intelligent Technology Co.,LTD"
		}
	case 588:
		{ /* '588' */
			return "Larfe"
		}
	case 589:
		{ /* '589' */
			return "Dongguan Muhcci Electrical"
		}
	case 59:
		{ /* '59' */
			return "Dätwyler"
		}
	case 590:
		{ /* '590' */
			return "STEC"
		}
	case 591:
		{ /* '591' */
			return "ARIGO Software GmbH"
		}
	case 592:
		{ /* '592' */
			return "Feishelec"
		}
	case 593:
		{ /* '593' */
			return "GORDIC"
		}
	case 594:
		{ /* '594' */
			return "Delta Electronics"
		}
	case 595:
		{ /* '595' */
			return "Shanghai Lewin Intelligent Technology Co.,Ltd."
		}
	case 596:
		{ /* '596' */
			return "KG-POWER"
		}
	case 597:
		{ /* '597' */
			return "Zhejiang Moorgen Group Co.,Ltd"
		}
	case 598:
		{ /* '598' */
			return "Guangdong Kanway"
		}
	case 599:
		{ /* '599' */
			return "RAMIREZ Engineering GmbH"
		}
	case 6:
		{ /* '6' */
			return "Busch-Jaeger Elektro"
		}
	case 60:
		{ /* '60' */
			return "Electrak"
		}
	case 600:
		{ /* '600' */
			return "Zhongshan Taiyang IMP&EXP. CO LTD"
		}
	case 601:
		{ /* '601' */
			return "Vihan electric pvt ltd"
		}
	case 602:
		{ /* '602' */
			return "Splendid Minds GmbH"
		}
	case 603:
		{ /* '603' */
			return "Estada"
		}
	case 604:
		{ /* '604' */
			return "zhongyunxinzhikonggujituanyouxiangongsi"
		}
	case 605:
		{ /* '605' */
			return "Stuhl Regelsysteme GmbH"
		}
	case 606:
		{ /* '606' */
			return "Shenzhen Gluck Technology Co., LTD"
		}
	case 607:
		{ /* '607' */
			return "Gaimex"
		}
	case 608:
		{ /* '608' */
			return "B3 International S.R.L"
		}
	case 609:
		{ /* '609' */
			return "MM Electro"
		}
	case 61:
		{ /* '61' */
			return "Techem"
		}
	case 610:
		{ /* '610' */
			return "CASCODA"
		}
	case 611:
		{ /* '611' */
			return "Xiamen Intretech Inc."
		}
	case 612:
		{ /* '612' */
			return "KiloElec Technology"
		}
	case 613:
		{ /* '613' */
			return "Inyx"
		}
	case 614:
		{ /* '614' */
			return "Smart Building Services GmbH"
		}
	case 615:
		{ /* '615' */
			return "BSS GmbH"
		}
	case 616:
		{ /* '616' */
			return "Lumi Electronics"
		}
	case 617:
		{ /* '617' */
			return "OjeaElectronics"
		}
	case 618:
		{ /* '618' */
			return "Smart Node"
		}
	case 619:
		{ /* '619' */
			return "NEXhome"
		}
	case 62:
		{ /* '62' */
			return "Schneider Electric Industries SAS"
		}
	case 620:
		{ /* '620' */
			return "Huoteng Wulian (Jiangsu) Co., Ltd"
		}
	case 621:
		{ /* '621' */
			return "Raylogic Control Systems Pvt Ltd"
		}
	case 622:
		{ /* '622' */
			return "Bits & Bytes"
		}
	case 623:
		{ /* '623' */
			return "KFV (SIEGENIA GRUPPE)"
		}
	case 624:
		{ /* '624' */
			return "Symcon"
		}
	case 625:
		{ /* '625' */
			return "I.Trust"
		}
	case 626:
		{ /* '626' */
			return "DRD-Technics"
		}
	case 627:
		{ /* '627' */
			return "LENGEN"
		}
	case 628:
		{ /* '628' */
			return "Shenzhen EXC-LED Technology Co.,LTD"
		}
	case 629:
		{ /* '629' */
			return "Vibroxx-FZCO"
		}
	case 63:
		{ /* '63' */
			return "WHD Wilhelm Huber + Söhne"
		}
	case 630:
		{ /* '630' */
			return "Suzhou Hongyun Intelligent TechnologyCo., Ltd"
		}
	case 631:
		{ /* '631' */
			return "Passiv Energie GmbH"
		}
	case 632:
		{ /* '632' */
			return "Payne Technologies Ltd"
		}
	case 633:
		{ /* '633' */
			return "Guangdong Yozewit Intelligent Technology Co.,Ltd."
		}
	case 634:
		{ /* '634' */
			return "SEXANKA"
		}
	case 635:
		{ /* '635' */
			return "Securi-Flex Ltd"
		}
	case 636:
		{ /* '636' */
			return "BOKE"
		}
	case 637:
		{ /* '637' */
			return "SBR System Technical"
		}
	case 638:
		{ /* '638' */
			return "Shenzhen EastKame Technology Co., Ltd."
		}
	case 639:
		{ /* '639' */
			return "BOLATU"
		}
	case 64:
		{ /* '64' */
			return "Bischoff Elektronik"
		}
	case 640:
		{ /* '640' */
			return "RECBER KABLO A.S."
		}
	case 641:
		{ /* '641' */
			return "ILite-Knx"
		}
	case 642:
		{ /* '642' */
			return "LAZZEN"
		}
	case 643:
		{ /* '643' */
			return "MOX CONTROL IT (CHINA) LIMITED"
		}
	case 644:
		{ /* '644' */
			return "CLOWIRE"
		}
	case 645:
		{ /* '645' */
			return "NINGBO QIYUAN LIGHTING TECH CO.,LTD"
		}
	case 646:
		{ /* '646' */
			return "NS Touch"
		}
	case 647:
		{ /* '647' */
			return "ROOMIO"
		}
	case 648:
		{ /* '648' */
			return "Atouch"
		}
	case 649:
		{ /* '649' */
			return "Panasonic Life Solutions India Pvt. Ltd"
		}
	case 65:
		{ /* '65' */
			return "JEPAZ"
		}
	case 650:
		{ /* '650' */
			return "WallYons"
		}
	case 651:
		{ /* '651' */
			return "Zimmex"
		}
	case 652:
		{ /* '652' */
			return "Rhombus Europe"
		}
	case 653:
		{ /* '653' */
			return "Turing-Think"
		}
	case 654:
		{ /* '654' */
			return "Michoi"
		}
	case 655:
		{ /* '655' */
			return "CAV SMART(GUANGZHOU)CO.,LTD"
		}
	case 656:
		{ /* '656' */
			return "Helkama Bica Oy"
		}
	case 657:
		{ /* '657' */
			return "ModuLyte"
		}
	case 658:
		{ /* '658' */
			return "Consolinno Energy GmbH"
		}
	case 659:
		{ /* '659' */
			return "SCHIDERON ELECTRIC (ASIA) LIMITED"
		}
	case 66:
		{ /* '66' */
			return "RTS Automation"
		}
	case 660:
		{ /* '660' */
			return "3R"
		}
	case 661:
		{ /* '661' */
			return "Arklyfe"
		}
	case 662:
		{ /* '662' */
			return "Foshan Haydn Technology Lighting Co.,Ltd."
		}
	case 663:
		{ /* '663' */
			return "KNXES COMPANY LIMITED"
		}
	case 664:
		{ /* '664' */
			return "Akuvox"
		}
	case 665:
		{ /* '665' */
			return "NingBo Yinzhou ShengRuiJie Electronics Co. Ltd."
		}
	case 666:
		{ /* '666' */
			return "Shenzhen Haizhichuang Technology Co., Ltd"
		}
	case 667:
		{ /* '667' */
			return "Shenzhen easydetek technology Co.Ltd"
		}
	case 668:
		{ /* '668' */
			return "Mutlusan Electric"
		}
	case 669:
		{ /* '669' */
			return "Hangzhou BroadLink Technology Co.,Ltd."
		}
	case 67:
		{ /* '67' */
			return "EIBMARKT GmbH"
		}
	case 670:
		{ /* '670' */
			return "Marley Deutschland GmbH"
		}
	case 671:
		{ /* '671' */
			return "Creatrol"
		}
	case 672:
		{ /* '672' */
			return "EUTELSAT"
		}
	case 673:
		{ /* '673' */
			return "TECNIKABEL"
		}
	case 674:
		{ /* '674' */
			return "Atios AG"
		}
	case 675:
		{ /* '675' */
			return "SmartLicht"
		}
	case 676:
		{ /* '676' */
			return "Beijing Bevone Electric Co. Ltd."
		}
	case 677:
		{ /* '677' */
			return "ELSMART"
		}
	case 678:
		{ /* '678' */
			return "Middle East Specialized Cables Co. (MESC)"
		}
	case 679:
		{ /* '679' */
			return "HANGZHOU SANYUAN CABLE CO., LTD"
		}
	case 68:
		{ /* '68' */
			return "WAREMA Renkhoff SE"
		}
	case 680:
		{ /* '680' */
			return "Beijing HaiLin Control Technology Inc."
		}
	case 681:
		{ /* '681' */
			return "HangZhou Snowyi Technology Co.,LTD."
		}
	case 682:
		{ /* '682' */
			return "Xiamen E-Top Controls Technology Co.,Ltd"
		}
	case 683:
		{ /* '683' */
			return "Vitrum Design"
		}
	case 684:
		{ /* '684' */
			return "DETRONS"
		}
	case 685:
		{ /* '685' */
			return "Zhejiang FORICK, Intelligent Technology Co., LTD"
		}
	case 686:
		{ /* '686' */
			return "Varni Digital Private Limited"
		}
	case 687:
		{ /* '687' */
			return "3a entreprise aps"
		}
	case 688:
		{ /* '688' */
			return "Italiana Conduttori srl"
		}
	case 689:
		{ /* '689' */
			return "Xiamen Leelen Technology Co.,Ltd."
		}
	case 69:
		{ /* '69' */
			return "Eelectron"
		}
	case 690:
		{ /* '690' */
			return "LedNX"
		}
	case 691:
		{ /* '691' */
			return "ebelong"
		}
	case 692:
		{ /* '692' */
			return "Astra-LED AG"
		}
	case 693:
		{ /* '693' */
			return "Wonderful Hi-Tech Co., Ltd."
		}
	case 694:
		{ /* '694' */
			return "REXLiTE Ai Integrations CO.,LTD"
		}
	case 695:
		{ /* '695' */
			return "Allorado"
		}
	case 696:
		{ /* '696' */
			return "FUZHOU MILI TECHNOLOGY CO., LTD"
		}
	case 697:
		{ /* '697' */
			return "Maxtreen building technology co.,ltd"
		}
	case 698:
		{ /* '698' */
			return "Hysine"
		}
	case 699:
		{ /* '699' */
			return "SANTAN"
		}
	case 7:
		{ /* '7' */
			return "GIRA Giersiepen"
		}
	case 70:
		{ /* '70' */
			return "Belden Wire & Cable B.V."
		}
	case 700:
		{ /* '700' */
			return "Huixiangju IoT Technology (Shanghai) Co., Ltd"
		}
	case 701:
		{ /* '701' */
			return "Shanghai Benkong Electronic Technology Co.,Ltd"
		}
	case 702:
		{ /* '702' */
			return "Polar Bear Design"
		}
	case 703:
		{ /* '703' */
			return "Elessan NV"
		}
	case 704:
		{ /* '704' */
			return "MIR"
		}
	case 705:
		{ /* '705' */
			return "Zhejiang Misilin Technology Co., Ltd"
		}
	case 706:
		{ /* '706' */
			return "LEAX CONTROLS CO., LTD."
		}
	case 707:
		{ /* '707' */
			return "alcad"
		}
	case 708:
		{ /* '708' */
			return "GUANG DONG REMAC SMART TECHNOLOGY CO., LTD"
		}
	case 709:
		{ /* '709' */
			return "Taos Electric Co., Ltd"
		}
	case 71:
		{ /* '71' */
			return "Becker-Antriebe GmbH"
		}
	case 710:
		{ /* '710' */
			return "Konstantin Bobic Systemintegration"
		}
	case 711:
		{ /* '711' */
			return "Asay Q"
		}
	case 712:
		{ /* '712' */
			return "LAPP"
		}
	case 713:
		{ /* '713' */
			return "ZEROBIT DYNAMIC"
		}
	case 714:
		{ /* '714' */
			return "havells"
		}
	case 715:
		{ /* '715' */
			return "Muller Intuitiv"
		}
	case 716:
		{ /* '716' */
			return "taskit GmbH"
		}
	case 717:
		{ /* '717' */
			return "Coster Group"
		}
	case 718:
		{ /* '718' */
			return "NXP Semiconductor"
		}
	case 719:
		{ /* '719' */
			return "CogCons"
		}
	case 72:
		{ /* '72' */
			return "J.Stehle+Söhne GmbH"
		}
	case 720:
		{ /* '720' */
			return "Micro Tek Srl (F.M.C trade mark)"
		}
	case 721:
		{ /* '721' */
			return "Orenda Electric"
		}
	case 722:
		{ /* '722' */
			return "ERSE KABLO"
		}
	case 723:
		{ /* '723' */
			return "prado europe bv"
		}
	case 724:
		{ /* '724' */
			return "e2s GbR"
		}
	case 725:
		{ /* '725' */
			return "UnitLink"
		}
	case 726:
		{ /* '726' */
			return "ONNA"
		}
	case 727:
		{ /* '727' */
			return "CENTERSVET LLC"
		}
	case 728:
		{ /* '728' */
			return "Adveco Technology Co., Ltd."
		}
	case 729:
		{ /* '729' */
			return "Fr. Lürssen Werft"
		}
	case 73:
		{ /* '73' */
			return "AGFEO"
		}
	case 730:
		{ /* '730' */
			return "mylyr"
		}
	case 731:
		{ /* '731' */
			return "HYUNDAI HT"
		}
	case 732:
		{ /* '732' */
			return "Guangdong Yuejingrun Technology Co.,Ltd"
		}
	case 733:
		{ /* '733' */
			return "SMATEK ELECTRONICS LIMITED"
		}
	case 734:
		{ /* '734' */
			return "Anytek Electronic Technology (SZ) Co., Ltd."
		}
	case 735:
		{ /* '735' */
			return "Morelinks Smart Home"
		}
	case 736:
		{ /* '736' */
			return "Cirtx GmbH"
		}
	case 737:
		{ /* '737' */
			return "QLITE"
		}
	case 738:
		{ /* '738' */
			return "Zhongshan Illus LIghting Co.,Ltd"
		}
	case 739:
		{ /* '739' */
			return "Hangzhou Konke Information Technology Co., Ltd."
		}
	case 74:
		{ /* '74' */
			return "Zennio"
		}
	case 740:
		{ /* '740' */
			return "Shanghai Fante Digital Technology Co., Ltd"
		}
	case 741:
		{ /* '741' */
			return "CONFIO"
		}
	case 742:
		{ /* '742' */
			return "Sonic Technologies"
		}
	case 743:
		{ /* '743' */
			return "Shanghai Innovatech Information Technology Co., Lt"
		}
	case 744:
		{ /* '744' */
			return "ABI Sicherheitssysteme GmbH"
		}
	case 745:
		{ /* '745' */
			return "RYT"
		}
	case 746:
		{ /* '746' */
			return "Auriga Systems"
		}
	case 747:
		{ /* '747' */
			return "Alzinger&Vogel Softwareentwicklungs GmbH"
		}
	case 748:
		{ /* '748' */
			return "Gianfranco Smart Solutions Ltd"
		}
	case 749:
		{ /* '749' */
			return "Rogerwell Control System Limited"
		}
	case 75:
		{ /* '75' */
			return "TAPKO Technologies"
		}
	case 750:
		{ /* '750' */
			return "ABB - reserved"
		}
	case 751:
		{ /* '751' */
			return "Busch-Jaeger Elektro - reserved"
		}
	case 76:
		{ /* '76' */
			return "HDL"
		}
	case 77:
		{ /* '77' */
			return "Uponor"
		}
	case 78:
		{ /* '78' */
			return "se Lightmanagement AG"
		}
	case 79:
		{ /* '79' */
			return "Arcus-eds"
		}
	case 8:
		{ /* '8' */
			return "Hager Electro"
		}
	case 80:
		{ /* '80' */
			return "Intesis"
		}
	case 81:
		{ /* '81' */
			return "Herholdt Controls srl"
		}
	case 82:
		{ /* '82' */
			return "Niko-Zublin"
		}
	case 83:
		{ /* '83' */
			return "Durable Technologies"
		}
	case 84:
		{ /* '84' */
			return "Innoteam"
		}
	case 85:
		{ /* '85' */
			return "ise GmbH"
		}
	case 86:
		{ /* '86' */
			return "TEAM FOR TRONICS"
		}
	case 87:
		{ /* '87' */
			return "CARRIER SAS"
		}
	case 88:
		{ /* '88' */
			return "Remeha BV"
		}
	case 89:
		{ /* '89' */
			return "ESYLUX"
		}
	case 9:
		{ /* '9' */
			return "Insta GmbH"
		}
	case 90:
		{ /* '90' */
			return "BASALTE"
		}
	case 91:
		{ /* '91' */
			return "Vestamatic"
		}
	case 92:
		{ /* '92' */
			return "MDT technologies"
		}
	case 93:
		{ /* '93' */
			return "Warendorfer Küchen GmbH"
		}
	case 94:
		{ /* '94' */
			return "GVS"
		}
	case 95:
		{ /* '95' */
			return "Sitek"
		}
	case 96:
		{ /* '96' */
			return "CONTROLtronic"
		}
	case 97:
		{ /* '97' */
			return "function Technology"
		}
	case 98:
		{ /* '98' */
			return "AMX"
		}
	case 99:
		{ /* '99' */
			return "ELDAT"
		}
	default:
		{
			return ""
		}
	}
}

func KnxManufacturerFirstEnumForFieldName(value string) (enum KnxManufacturer, ok bool) {
	for _, sizeValue := range KnxManufacturerValues {
		if sizeValue.Name() == value {
			return sizeValue, true
		}
	}
	return 0, false
}
func KnxManufacturerByValue(value uint16) (enum KnxManufacturer, ok bool) {
	switch value {
	case 0:
		return KnxManufacturer_M_UNKNOWN, true
	case 1:
		return KnxManufacturer_M_SIEMENS, true
	case 10:
		return KnxManufacturer_M_LEGRAND_APPAREILLAGE_ELECTRIQUE, true
	case 100:
		return KnxManufacturer_M_PANASONIC, true
	case 101:
		return KnxManufacturer_M_PULSE_TECHNOLOGIES, true
	case 102:
		return KnxManufacturer_M_CRESTRON, true
	case 103:
		return KnxManufacturer_M_STEINEL_PROFESSIONAL, true
	case 104:
		return KnxManufacturer_M_BILTON_LED_LIGHTING, true
	case 105:
		return KnxManufacturer_M_DENRO_AG, true
	case 106:
		return KnxManufacturer_M_GEPRO, true
	case 107:
		return KnxManufacturer_M_PREUSSEN_AUTOMATION, true
	case 108:
		return KnxManufacturer_M_ZOPPAS_INDUSTRIES, true
	case 109:
		return KnxManufacturer_M_MACTECH, true
	case 11:
		return KnxManufacturer_M_MERTEN, true
	case 110:
		return KnxManufacturer_M_TECHNO_TREND, true
	case 111:
		return KnxManufacturer_M_FS_CABLES, true
	case 112:
		return KnxManufacturer_M_DELTA_DORE, true
	case 113:
		return KnxManufacturer_M_EISSOUND, true
	case 114:
		return KnxManufacturer_M_CISCO, true
	case 115:
		return KnxManufacturer_M_DINUY, true
	case 116:
		return KnxManufacturer_M_IKNIX, true
	case 117:
		return KnxManufacturer_M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH, true
	case 118:
		return KnxManufacturer_M_EGI_ELECTROACUSTICA_GENERAL_IBERICA, true
	case 119:
		return KnxManufacturer_M_BES___INGENIUM, true
	case 12:
		return KnxManufacturer_M_ABB_SPA_SACE_DIVISION, true
	case 120:
		return KnxManufacturer_M_ELABNET, true
	case 121:
		return KnxManufacturer_M_BLUMOTIX, true
	case 122:
		return KnxManufacturer_M_HUNTER_DOUGLAS, true
	case 123:
		return KnxManufacturer_M_APRICUM, true
	case 124:
		return KnxManufacturer_M_TIANSU_AUTOMATION, true
	case 125:
		return KnxManufacturer_M_BUBENDORFF, true
	case 126:
		return KnxManufacturer_M_MBS_GMBH, true
	case 127:
		return KnxManufacturer_M_ENERTEX_BAYERN_GMBH, true
	case 128:
		return KnxManufacturer_M_BMS, true
	case 129:
		return KnxManufacturer_M_SINAPSI, true
	case 13:
		return KnxManufacturer_M_SIEDLE_AND_SOEHNE, true
	case 130:
		return KnxManufacturer_M_EMBEDDED_SYSTEMS_SIA, true
	case 131:
		return KnxManufacturer_M_KNX1, true
	case 132:
		return KnxManufacturer_M_TOKKA, true
	case 133:
		return KnxManufacturer_M_NANOSENSE, true
	case 134:
		return KnxManufacturer_M_PEAR_AUTOMATION_GMBH, true
	case 135:
		return KnxManufacturer_M_DGA, true
	case 136:
		return KnxManufacturer_M_LUTRON, true
	case 137:
		return KnxManufacturer_M_AIRZONE___ALTRA, true
	case 138:
		return KnxManufacturer_M_LITHOSS_DESIGN_SWITCHES, true
	case 139:
		return KnxManufacturer_M_THREEATEL, true
	case 14:
		return KnxManufacturer_M_EBERLE, true
	case 140:
		return KnxManufacturer_M_PHILIPS_CONTROLS, true
	case 141:
		return KnxManufacturer_M_VELUX_AS, true
	case 142:
		return KnxManufacturer_M_LOYTEC, true
	case 143:
		return KnxManufacturer_M_EKINEX_S_P_A_, true
	case 144:
		return KnxManufacturer_M_SIRLAN_TECHNOLOGIES, true
	case 145:
		return KnxManufacturer_M_PROKNX_SAS, true
	case 146:
		return KnxManufacturer_M_IT_GMBH, true
	case 147:
		return KnxManufacturer_M_RENSON, true
	case 148:
		return KnxManufacturer_M_HEP_GROUP, true
	case 149:
		return KnxManufacturer_M_BALMART, true
	case 15:
		return KnxManufacturer_M_GEWISS, true
	case 150:
		return KnxManufacturer_M_GFS_GMBH, true
	case 151:
		return KnxManufacturer_M_SCHENKER_STOREN_AG, true
	case 152:
		return KnxManufacturer_M_ALGODUE_ELETTRONICA_S_R_L_, true
	case 153:
		return KnxManufacturer_M_ABB_FRANCE, true
	case 154:
		return KnxManufacturer_M_MAINTRONIC, true
	case 155:
		return KnxManufacturer_M_VANTAGE, true
	case 156:
		return KnxManufacturer_M_FORESIS, true
	case 157:
		return KnxManufacturer_M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM, true
	case 158:
		return KnxManufacturer_M_WEINZIERL_ENGINEERING_GMBH, true
	case 159:
		return KnxManufacturer_M_MOEHLENHOFF_WAERMETECHNIK_GMBH, true
	case 16:
		return KnxManufacturer_M_ALBERT_ACKERMANN, true
	case 160:
		return KnxManufacturer_M_PKC_GROUP_OYJ, true
	case 161:
		return KnxManufacturer_M_B_E_G_, true
	case 162:
		return KnxManufacturer_M_ELSNER_ELEKTRONIK_GMBH, true
	case 163:
		return KnxManufacturer_M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_, true
	case 164:
		return KnxManufacturer_M_EUTRAC, true
	case 165:
		return KnxManufacturer_M_GUSTAV_HENSEL_GMBH_AND_CO__KG, true
	case 166:
		return KnxManufacturer_M_GARO_AB, true
	case 167:
		return KnxManufacturer_M_WALDMANN_LICHTTECHNIK, true
	case 168:
		return KnxManufacturer_M_SCHUECO, true
	case 169:
		return KnxManufacturer_M_EMU, true
	case 17:
		return KnxManufacturer_M_SCHUPA_GMBH, true
	case 170:
		return KnxManufacturer_M_JNET_SYSTEMS_AG, true
	case 171:
		return KnxManufacturer_M_TOTAL_SOLUTION_GMBH, true
	case 172:
		return KnxManufacturer_M_O_Y_L__ELECTRONICS, true
	case 173:
		return KnxManufacturer_M_GALAX_SYSTEM, true
	case 174:
		return KnxManufacturer_M_DISCH, true
	case 175:
		return KnxManufacturer_M_AUCOTEAM, true
	case 176:
		return KnxManufacturer_M_LUXMATE_CONTROLS, true
	case 177:
		return KnxManufacturer_M_DANFOSS, true
	case 178:
		return KnxManufacturer_M_AST_GMBH, true
	case 179:
		return KnxManufacturer_M_WILA_LEUCHTEN, true
	case 18:
		return KnxManufacturer_M_ABB_SCHWEIZ, true
	case 180:
		return KnxManufacturer_M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK, true
	case 181:
		return KnxManufacturer_M_LINGG_AND_JANKE, true
	case 182:
		return KnxManufacturer_M_SAUTER, true
	case 183:
		return KnxManufacturer_M_SIMU, true
	case 184:
		return KnxManufacturer_M_THEBEN_HTS_AG, true
	case 185:
		return KnxManufacturer_M_AMANN_GMBH, true
	case 186:
		return KnxManufacturer_M_BERG_ENERGIEKONTROLLSYSTEME_GMBH, true
	case 187:
		return KnxManufacturer_M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH, true
	case 188:
		return KnxManufacturer_M_OVENTROP_KG, true
	case 189:
		return KnxManufacturer_M_GRIESSER_AG, true
	case 19:
		return KnxManufacturer_M_FELLER, true
	case 190:
		return KnxManufacturer_M_IPAS_GMBH, true
	case 191:
		return KnxManufacturer_M_ELERO_GMBH, true
	case 192:
		return KnxManufacturer_M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_, true
	case 193:
		return KnxManufacturer_M_METEC_MESSTECHNIK_GMBH, true
	case 194:
		return KnxManufacturer_M_BUERK_MOBATIME, true
	case 195:
		return KnxManufacturer_M_ELKA_ELEKTRONIK_GMBH, true
	case 196:
		return KnxManufacturer_M_ELEKTROANLAGEN_D__NAGEL, true
	case 197:
		return KnxManufacturer_M_TRIDONIC_BAUELEMENTE_GMBH, true
	case 198:
		return KnxManufacturer_M_STENGLER_GESELLSCHAFT, true
	case 199:
		return KnxManufacturer_M_SCHNEIDER_ELECTRIC_MG, true
	case 2:
		return KnxManufacturer_M_ABB, true
	case 20:
		return KnxManufacturer_M_GLAMOX_AS, true
	case 200:
		return KnxManufacturer_M_KNX_ASSOCIATION, true
	case 201:
		return KnxManufacturer_M_VIVO, true
	case 202:
		return KnxManufacturer_M_HUGO_MUELLER_GMBH_AND_CO_KG, true
	case 203:
		return KnxManufacturer_M_SIEMENS_HVAC, true
	case 204:
		return KnxManufacturer_M_APT, true
	case 205:
		return KnxManufacturer_M_HIGHDOM, true
	case 206:
		return KnxManufacturer_M_TOP_SERVICES, true
	case 207:
		return KnxManufacturer_M_AMBIHOME, true
	case 208:
		return KnxManufacturer_M_DATEC_ELECTRONIC_AG, true
	case 209:
		return KnxManufacturer_M_ABUS_SECURITY_CENTER, true
	case 21:
		return KnxManufacturer_M_DEHN_AND_SOEHNE, true
	case 210:
		return KnxManufacturer_M_LITE_PUTER, true
	case 211:
		return KnxManufacturer_M_TANTRON_ELECTRONIC, true
	case 212:
		return KnxManufacturer_M_INTERRA, true
	case 213:
		return KnxManufacturer_M_DKX_TECH, true
	case 214:
		return KnxManufacturer_M_VIATRON, true
	case 215:
		return KnxManufacturer_M_NAUTIBUS, true
	case 216:
		return KnxManufacturer_M_ON_SEMICONDUCTOR, true
	case 217:
		return KnxManufacturer_M_LONGCHUANG, true
	case 218:
		return KnxManufacturer_M_AIR_ON_AG, true
	case 219:
		return KnxManufacturer_M_IB_COMPANY_GMBH, true
	case 22:
		return KnxManufacturer_M_CRABTREE, true
	case 220:
		return KnxManufacturer_M_SATION_FACTORY, true
	case 221:
		return KnxManufacturer_M_AGENTILO_GMBH, true
	case 222:
		return KnxManufacturer_M_MAKEL_ELEKTRIK, true
	case 223:
		return KnxManufacturer_M_HELIOS_VENTILATOREN, true
	case 224:
		return KnxManufacturer_M_OTTO_SOLUTIONS_PTE_LTD, true
	case 225:
		return KnxManufacturer_M_AIRMASTER, true
	case 226:
		return KnxManufacturer_M_VALLOX_GMBH, true
	case 227:
		return KnxManufacturer_M_DALITEK, true
	case 228:
		return KnxManufacturer_M_ASIN, true
	case 229:
		return KnxManufacturer_M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_, true
	case 23:
		return KnxManufacturer_M_EVOKNX, true
	case 230:
		return KnxManufacturer_M_ARBONIA, true
	case 231:
		return KnxManufacturer_M_KERMI, true
	case 232:
		return KnxManufacturer_M_PROLUX, true
	case 233:
		return KnxManufacturer_M_CLICHOME, true
	case 234:
		return KnxManufacturer_M_COMMAX, true
	case 235:
		return KnxManufacturer_M_EAE, true
	case 236:
		return KnxManufacturer_M_TENSE, true
	case 237:
		return KnxManufacturer_M_SEYOUNG_ELECTRONICS, true
	case 238:
		return KnxManufacturer_M_LIFEDOMUS, true
	case 239:
		return KnxManufacturer_M_EUROTRONIC_TECHNOLOGY_GMBH, true
	case 24:
		return KnxManufacturer_M_PAUL_HOCHKOEPPER, true
	case 240:
		return KnxManufacturer_M_TCI, true
	case 241:
		return KnxManufacturer_M_RISHUN_ELECTRONIC, true
	case 242:
		return KnxManufacturer_M_ZIPATO, true
	case 243:
		return KnxManufacturer_M_CM_SECURITY_GMBH_AND_CO_KG, true
	case 244:
		return KnxManufacturer_M_QING_CABLES, true
	case 245:
		return KnxManufacturer_M_WOLF, true
	case 246:
		return KnxManufacturer_M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_, true
	case 247:
		return KnxManufacturer_M_E_G_E, true
	case 248:
		return KnxManufacturer_M_NETXAUTOMATION, true
	case 249:
		return KnxManufacturer_M_TECALOR, true
	case 25:
		return KnxManufacturer_M_ALTENBURGER_ELECTRONIC, true
	case 250:
		return KnxManufacturer_M_URMET_ELECTRONICS_HUIZHOU_LTD_, true
	case 251:
		return KnxManufacturer_M_PEIYING_BUILDING_CONTROL, true
	case 252:
		return KnxManufacturer_M_BPT_S_P_A__A_SOCIO_UNICO, true
	case 253:
		return KnxManufacturer_M_KANONTEC___KANONBUS, true
	case 254:
		return KnxManufacturer_M_ISER_TECH, true
	case 255:
		return KnxManufacturer_M_FINELINE, true
	case 256:
		return KnxManufacturer_M_CP_ELECTRONICS_LTD, true
	case 257:
		return KnxManufacturer_M_NIKO_SERVODAN_AS, true
	case 258:
		return KnxManufacturer_M_SIMON_309, true
	case 259:
		return KnxManufacturer_M_GM_MODULAR_PVT__LTD_, true
	case 26:
		return KnxManufacturer_M_GRAESSLIN, true
	case 260:
		return KnxManufacturer_M_FU_CHENG_INTELLIGENCE, true
	case 261:
		return KnxManufacturer_M_NEXKON, true
	case 262:
		return KnxManufacturer_M_FEEL_S_R_L, true
	case 263:
		return KnxManufacturer_M_NOT_ASSIGNED_314, true
	case 264:
		return KnxManufacturer_M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_, true
	case 265:
		return KnxManufacturer_M_JIUZHOU_GREEBLE, true
	case 266:
		return KnxManufacturer_M_AUMUELLER_AUMATIC_GMBH, true
	case 267:
		return KnxManufacturer_M_ETMAN_ELECTRIC, true
	case 268:
		return KnxManufacturer_M_BLACK_NOVA, true
	case 269:
		return KnxManufacturer_M_ZIDATECH_AG, true
	case 27:
		return KnxManufacturer_M_SIMON_42, true
	case 270:
		return KnxManufacturer_M_IDGS_BVBA, true
	case 271:
		return KnxManufacturer_M_DAKANIMO, true
	case 272:
		return KnxManufacturer_M_TREBOR_AUTOMATION_AB, true
	case 273:
		return KnxManufacturer_M_SATEL_SP__Z_O_O_, true
	case 274:
		return KnxManufacturer_M_RUSSOUND__INC_, true
	case 275:
		return KnxManufacturer_M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD, true
	case 276:
		return KnxManufacturer_M_CONSORZIO_TERRANUOVA, true
	case 277:
		return KnxManufacturer_M_WOLF_HEIZTECHNIK_GMBH, true
	case 278:
		return KnxManufacturer_M_SONTEC, true
	case 279:
		return KnxManufacturer_M_BELCOM_CABLES_LTD_, true
	case 28:
		return KnxManufacturer_M_VIMAR, true
	case 280:
		return KnxManufacturer_M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_, true
	case 281:
		return KnxManufacturer_M_ACREL, true
	case 282:
		return KnxManufacturer_M_KWC_AQUAROTTER_GMBH, true
	case 283:
		return KnxManufacturer_M_ORION_SYSTEMS, true
	case 284:
		return KnxManufacturer_M_SCHRACK_TECHNIK_GMBH, true
	case 285:
		return KnxManufacturer_M_INSPRID, true
	case 286:
		return KnxManufacturer_M_SUNRICHER, true
	case 287:
		return KnxManufacturer_M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_, true
	case 288:
		return KnxManufacturer_M_AUREX, true
	case 289:
		return KnxManufacturer_M_JOSEF_BARTHELME_GMBH_AND_CO__KG, true
	case 29:
		return KnxManufacturer_M_MOELLER_GEBAEUDEAUTOMATION_KG, true
	case 290:
		return KnxManufacturer_M_ARCHITECTURE_NUMERIQUE, true
	case 291:
		return KnxManufacturer_M_UP_GROUP, true
	case 292:
		return KnxManufacturer_M_TEKNOS_AVINNO, true
	case 293:
		return KnxManufacturer_M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY, true
	case 294:
		return KnxManufacturer_M_THERMOKON_SENSORTECHNIK_GMBH, true
	case 295:
		return KnxManufacturer_M_BELIMO_AUTOMATION_AG, true
	case 296:
		return KnxManufacturer_M_ZEHNDER_GROUP_INTERNATIONAL_AG, true
	case 297:
		return KnxManufacturer_M_SKS_KINKEL_ELEKTRONIK, true
	case 298:
		return KnxManufacturer_M_ECE_WURMITZER_GMBH, true
	case 299:
		return KnxManufacturer_M_LARS, true
	case 3:
		return KnxManufacturer_M_ALBRECHT_JUNG, true
	case 30:
		return KnxManufacturer_M_ELTAKO, true
	case 300:
		return KnxManufacturer_M_URC, true
	case 301:
		return KnxManufacturer_M_LIGHTCONTROL, true
	case 302:
		return KnxManufacturer_M_SHENZHEN_YM, true
	case 303:
		return KnxManufacturer_M_MEAN_WELL_ENTERPRISES_CO__LTD_, true
	case 304:
		return KnxManufacturer_M_OSIX, true
	case 305:
		return KnxManufacturer_M_AYPRO_TECHNOLOGY, true
	case 306:
		return KnxManufacturer_M_HEFEI_ECOLITE_SOFTWARE, true
	case 307:
		return KnxManufacturer_M_ENNO, true
	case 308:
		return KnxManufacturer_M_OHOSURE, true
	case 309:
		return KnxManufacturer_M_GAREFOWL, true
	case 31:
		return KnxManufacturer_M_BOSCH_SIEMENS_HAUSHALTSGERAETE, true
	case 310:
		return KnxManufacturer_M_GEZE, true
	case 311:
		return KnxManufacturer_M_LG_ELECTRONICS_INC_, true
	case 312:
		return KnxManufacturer_M_SMC_INTERIORS, true
	case 313:
		return KnxManufacturer_M_NOT_ASSIGNED_364, true
	case 314:
		return KnxManufacturer_M_SCS_CABLE, true
	case 315:
		return KnxManufacturer_M_HOVAL, true
	case 316:
		return KnxManufacturer_M_CANST, true
	case 317:
		return KnxManufacturer_M_HANGZHOU_BERLIN, true
	case 318:
		return KnxManufacturer_M_EVN_LICHTTECHNIK, true
	case 319:
		return KnxManufacturer_M_RUTEC, true
	case 32:
		return KnxManufacturer_M_RITTO_GMBHANDCO_KG, true
	case 320:
		return KnxManufacturer_M_FINDER, true
	case 321:
		return KnxManufacturer_M_FUJITSU_GENERAL_LIMITED, true
	case 322:
		return KnxManufacturer_M_ZF_FRIEDRICHSHAFEN_AG, true
	case 323:
		return KnxManufacturer_M_CREALED, true
	case 324:
		return KnxManufacturer_M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED, true
	case 325:
		return KnxManufacturer_M_EPlus, true
	case 326:
		return KnxManufacturer_M_ITALCOND, true
	case 327:
		return KnxManufacturer_M_SATION, true
	case 328:
		return KnxManufacturer_M_NEWBEST, true
	case 329:
		return KnxManufacturer_M_GDS_DIGITAL_SYSTEMS, true
	case 33:
		return KnxManufacturer_M_POWER_CONTROLS, true
	case 330:
		return KnxManufacturer_M_IDDERO, true
	case 331:
		return KnxManufacturer_M_MBNLED, true
	case 332:
		return KnxManufacturer_M_VITRUM, true
	case 333:
		return KnxManufacturer_M_EKEY_BIOMETRIC_SYSTEMS_GMBH, true
	case 334:
		return KnxManufacturer_M_AMC, true
	case 335:
		return KnxManufacturer_M_TRILUX_GMBH_AND_CO__KG, true
	case 336:
		return KnxManufacturer_M_WEXCEDO, true
	case 337:
		return KnxManufacturer_M_VEMER_SPA, true
	case 338:
		return KnxManufacturer_M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG, true
	case 339:
		return KnxManufacturer_M_CITRON, true
	case 34:
		return KnxManufacturer_M_ZUMTOBEL, true
	case 340:
		return KnxManufacturer_M_SHENZHEN_HEGUANG, true
	case 341:
		return KnxManufacturer_M_NOT_ASSIGNED_392, true
	case 342:
		return KnxManufacturer_M_TRANE_B_V_B_A, true
	case 343:
		return KnxManufacturer_M_CAREL, true
	case 344:
		return KnxManufacturer_M_PROLITE_CONTROLS, true
	case 345:
		return KnxManufacturer_M_BOSMER, true
	case 346:
		return KnxManufacturer_M_EUCHIPS, true
	case 347:
		return KnxManufacturer_M_CONNECT_THINKA_CONNECT, true
	case 348:
		return KnxManufacturer_M_PEAKNX_A_DOGAWIST_COMPANY, true
	case 349:
		return KnxManufacturer_M_ACEMATIC, true
	case 35:
		return KnxManufacturer_M_HOLEC_SYSTEMEN, true
	case 350:
		return KnxManufacturer_M_ELAUSYS, true
	case 351:
		return KnxManufacturer_M_ITK_ENGINEERING_AG, true
	case 352:
		return KnxManufacturer_M_INTEGRA_METERING_AG, true
	case 353:
		return KnxManufacturer_M_FMS_HOSPITALITY_PTE_LTD, true
	case 354:
		return KnxManufacturer_M_NUVO, true
	case 355:
		return KnxManufacturer_M_U__LUX_GMBH, true
	case 356:
		return KnxManufacturer_M_BRUMBERG_LEUCHTEN, true
	case 357:
		return KnxManufacturer_M_LIME, true
	case 358:
		return KnxManufacturer_M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_, true
	case 359:
		return KnxManufacturer_M_KAVOSHPISHRO_ASIA, true
	case 36:
		return KnxManufacturer_M_PHOENIX_CONTACT, true
	case 360:
		return KnxManufacturer_M_V2_SPA, true
	case 361:
		return KnxManufacturer_M_JOHNSON_CONTROLS, true
	case 362:
		return KnxManufacturer_M_ARKUD, true
	case 363:
		return KnxManufacturer_M_IRIDI_LTD_, true
	case 364:
		return KnxManufacturer_M_BSMART, true
	case 365:
		return KnxManufacturer_M_BAB_TECHNOLOGIE_GMBH, true
	case 366:
		return KnxManufacturer_M_NICE_SPA, true
	case 367:
		return KnxManufacturer_M_REDFISH_GROUP_PTY_LTD, true
	case 368:
		return KnxManufacturer_M_SABIANA_SPA, true
	case 369:
		return KnxManufacturer_M_UBEE_INTERACTIVE_EUROPE, true
	case 37:
		return KnxManufacturer_M_WAGO_GMBH_AND_CO_KG, true
	case 370:
		return KnxManufacturer_M_REXEL, true
	case 371:
		return KnxManufacturer_M_GES_TEKNIK_A_S_, true
	case 372:
		return KnxManufacturer_M_AVE_S_P_A_, true
	case 373:
		return KnxManufacturer_M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_, true
	case 374:
		return KnxManufacturer_M_ARCOM, true
	case 375:
		return KnxManufacturer_M_VIA_TECHNOLOGIES__INC_, true
	case 376:
		return KnxManufacturer_M_FEELSMART_, true
	case 377:
		return KnxManufacturer_M_SUPCON, true
	case 378:
		return KnxManufacturer_M_MANIC, true
	case 379:
		return KnxManufacturer_M_TDE_GMBH, true
	case 38:
		return KnxManufacturer_M_KNXPRESSO, true
	case 380:
		return KnxManufacturer_M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_, true
	case 381:
		return KnxManufacturer_M_EWTECH, true
	case 382:
		return KnxManufacturer_M_KLUGER_AUTOMATION_GMBH, true
	case 383:
		return KnxManufacturer_M_JOONGANG_CONTROL, true
	case 384:
		return KnxManufacturer_M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_, true
	case 385:
		return KnxManufacturer_M_IME_S_P_A_, true
	case 386:
		return KnxManufacturer_M_SICHUAN_HAODING, true
	case 387:
		return KnxManufacturer_M_MINDJAGA_LTD_, true
	case 388:
		return KnxManufacturer_M_RUILI_SMART_CONTROL, true
	case 389:
		return KnxManufacturer_M_CODESYS_GMBH, true
	case 39:
		return KnxManufacturer_M_WIELAND_ELECTRIC, true
	case 390:
		return KnxManufacturer_M_MOORGEN_DEUTSCHLAND_GMBH, true
	case 391:
		return KnxManufacturer_M_CULLMANN_TECH, true
	case 392:
		return KnxManufacturer_M_EYRISE_B_V, true
	case 393:
		return KnxManufacturer_M_DOBNEL, true
	case 394:
		return KnxManufacturer_M_MYGEKKO, true
	case 395:
		return KnxManufacturer_M_ERGO3_SARL, true
	case 396:
		return KnxManufacturer_M_STMICROELECTRONICS_INTERNATIONAL_N_V_, true
	case 397:
		return KnxManufacturer_M_CJC_SYSTEMS, true
	case 398:
		return KnxManufacturer_M_SUDOKU, true
	case 399:
		return KnxManufacturer_M_AZ_E_LITE_PTE_LTD, true
	case 4:
		return KnxManufacturer_M_BTICINO, true
	case 40:
		return KnxManufacturer_M_HERMANN_KLEINHUIS, true
	case 400:
		return KnxManufacturer_M_ARLIGHT, true
	case 401:
		return KnxManufacturer_M_GRUENBECK_WASSERAUFBEREITUNG_GMBH, true
	case 402:
		return KnxManufacturer_M_MODULE_ELECTRONIC, true
	case 403:
		return KnxManufacturer_M_KOPLAT, true
	case 404:
		return KnxManufacturer_M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD, true
	case 405:
		return KnxManufacturer_M_ILEVIA, true
	case 406:
		return KnxManufacturer_M_LN_SYSTEMTEQ, true
	case 407:
		return KnxManufacturer_M_HISENSE_SMARTHOME, true
	case 408:
		return KnxManufacturer_M_FLINK_AUTOMATION_SYSTEM, true
	case 409:
		return KnxManufacturer_M_XXTER_BV, true
	case 41:
		return KnxManufacturer_M_STIEBEL_ELTRON, true
	case 410:
		return KnxManufacturer_M_LYNXUS_TECHNOLOGY, true
	case 411:
		return KnxManufacturer_M_ROBOT_S_A_, true
	case 412:
		return KnxManufacturer_M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_, true
	case 413:
		return KnxManufacturer_M_NOBLESSE, true
	case 414:
		return KnxManufacturer_M_ADVANCED_DEVICES, true
	case 415:
		return KnxManufacturer_M_ATRINA_BUILDING_AUTOMATION_CO__LTD, true
	case 416:
		return KnxManufacturer_M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_, true
	case 417:
		return KnxManufacturer_M_WESTERSTRAND_URFABRIK_AB, true
	case 418:
		return KnxManufacturer_M_CONTROL4_CORPORATE, true
	case 419:
		return KnxManufacturer_M_ONTROL, true
	case 42:
		return KnxManufacturer_M_TEHALIT, true
	case 420:
		return KnxManufacturer_M_STARNET, true
	case 421:
		return KnxManufacturer_M_BETA_CAVI, true
	case 422:
		return KnxManufacturer_M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_, true
	case 423:
		return KnxManufacturer_M_VIVALDI_SRL, true
	case 424:
		return KnxManufacturer_M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI, true
	case 425:
		return KnxManufacturer_M_HWISCON, true
	case 426:
		return KnxManufacturer_M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_, true
	case 427:
		return KnxManufacturer_M_KAMPMANN, true
	case 428:
		return KnxManufacturer_M_IMPOLUX_GMBH_LEDIMAX, true
	case 429:
		return KnxManufacturer_M_EVAUX, true
	case 43:
		return KnxManufacturer_M_THEBEN_AG, true
	case 430:
		return KnxManufacturer_M_WEBRO_CABLES_AND_CONNECTORS_LIMITED, true
	case 431:
		return KnxManufacturer_M_SHANGHAI_E_TECH_SOLUTION, true
	case 432:
		return KnxManufacturer_M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_, true
	case 433:
		return KnxManufacturer_M_LAMMIN_HIGH_TECH_CO__LTD, true
	case 434:
		return KnxManufacturer_M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD, true
	case 435:
		return KnxManufacturer_M_I_LUXUS, true
	case 436:
		return KnxManufacturer_M_ELMOS_SEMICONDUCTOR_AG, true
	case 437:
		return KnxManufacturer_M_EMCOM_TECHNOLOGY_INC, true
	case 438:
		return KnxManufacturer_M_PROJECT_INNOVATIONS_GMBH, true
	case 439:
		return KnxManufacturer_M_ITC, true
	case 44:
		return KnxManufacturer_M_WILHELM_RUTENBECK, true
	case 440:
		return KnxManufacturer_M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING, true
	case 441:
		return KnxManufacturer_M_MAICO, true
	case 442:
		return KnxManufacturer_M_ELAN_SRL, true
	case 443:
		return KnxManufacturer_M_MINHHA_TECHNOLOGY_CO__LTD, true
	case 444:
		return KnxManufacturer_M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_, true
	case 445:
		return KnxManufacturer_M_IAUTOMATION_PTY_LIMITED, true
	case 446:
		return KnxManufacturer_M_EXTRON, true
	case 447:
		return KnxManufacturer_M_FREEDOMPRO, true
	case 448:
		return KnxManufacturer_M_ONEHOME, true
	case 449:
		return KnxManufacturer_M_EOS_SAUNATECHNIK_GMBH, true
	case 45:
		return KnxManufacturer_M_WINKHAUS, true
	case 450:
		return KnxManufacturer_M_KUSATEK_GMBH, true
	case 451:
		return KnxManufacturer_M_ALEXANDER_MAIER_GMBH, true
	case 452:
		return KnxManufacturer_M_AUTOMATISMI_BENINCA_S_P_A_, true
	case 453:
		return KnxManufacturer_M_BLENDOM, true
	case 454:
		return KnxManufacturer_M_MADEL_AIR_TECHNICAL_DIFFUSION, true
	case 455:
		return KnxManufacturer_M_NIKO, true
	case 456:
		return KnxManufacturer_M_BOSCH_REXROTH_AG, true
	case 457:
		return KnxManufacturer_M_CANDM_PRODUCTS, true
	case 458:
		return KnxManufacturer_M_HOERMANN_KG_VERKAUFSGESELLSCHAFT, true
	case 459:
		return KnxManufacturer_M_SHANGHAI_RAJAYASA_CO__LTD, true
	case 46:
		return KnxManufacturer_M_ROBERT_BOSCH, true
	case 460:
		return KnxManufacturer_M_SUZUKI, true
	case 461:
		return KnxManufacturer_M_SILENT_GLISS_INTERNATIONAL_LTD_, true
	case 462:
		return KnxManufacturer_M_BEE_CONTROLS_ADGSC_GROUP, true
	case 463:
		return KnxManufacturer_M_XDTECGMBH, true
	case 464:
		return KnxManufacturer_M_OSRAM, true
	case 465:
		return KnxManufacturer_M_LEBENOR, true
	case 466:
		return KnxManufacturer_M_AUTOMANENG, true
	case 467:
		return KnxManufacturer_M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD, true
	case 468:
		return KnxManufacturer_M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD, true
	case 469:
		return KnxManufacturer_M_ETA_HEIZTECHNIK, true
	case 47:
		return KnxManufacturer_M_SOMFY, true
	case 470:
		return KnxManufacturer_M_DIVUS_GMBH, true
	case 471:
		return KnxManufacturer_M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_, true
	case 472:
		return KnxManufacturer_M_LUNATONE, true
	case 473:
		return KnxManufacturer_M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT, true
	case 474:
		return KnxManufacturer_M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_, true
	case 475:
		return KnxManufacturer_M_NOKE, true
	case 476:
		return KnxManufacturer_M_LANDCOM, true
	case 477:
		return KnxManufacturer_M_STORK_AS, true
	case 478:
		return KnxManufacturer_M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_, true
	case 479:
		return KnxManufacturer_M_COOLAUTOMATION, true
	case 48:
		return KnxManufacturer_M_WOERTZ, true
	case 480:
		return KnxManufacturer_M_APRSTERN, true
	case 481:
		return KnxManufacturer_M_SONNEN, true
	case 482:
		return KnxManufacturer_M_DNAKE, true
	case 483:
		return KnxManufacturer_M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH, true
	case 484:
		return KnxManufacturer_M_STILIGER, true
	case 485:
		return KnxManufacturer_M_BERGHOF_AUTOMATION_GMBH, true
	case 486:
		return KnxManufacturer_M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH, true
	case 487:
		return KnxManufacturer_M_DOVIT, true
	case 488:
		return KnxManufacturer_M_INSTALIGHTING_GMBH, true
	case 489:
		return KnxManufacturer_M_UNI_TEC, true
	case 49:
		return KnxManufacturer_M_VIESSMANN_WERKE, true
	case 490:
		return KnxManufacturer_M_CASATUNES, true
	case 491:
		return KnxManufacturer_M_EMT, true
	case 492:
		return KnxManufacturer_M_SENFFICIENT, true
	case 493:
		return KnxManufacturer_M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED, true
	case 494:
		return KnxManufacturer_M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_, true
	case 495:
		return KnxManufacturer_M_SAMSON_ELECTRIC_WIRE, true
	case 496:
		return KnxManufacturer_M_T_TOUCHING, true
	case 497:
		return KnxManufacturer_M_CORE_SMART_HOME, true
	case 498:
		return KnxManufacturer_M_GREENCONNECT_SOLUTIONS_SA, true
	case 499:
		return KnxManufacturer_M_ELETTRONICA_CONDUTTORI, true
	case 5:
		return KnxManufacturer_M_BERKER, true
	case 50:
		return KnxManufacturer_M_IMI_HYDRONIC_ENGINEERING, true
	case 500:
		return KnxManufacturer_M_MKFC, true
	case 501:
		return KnxManufacturer_M_AUTOMATIONPlus, true
	case 502:
		return KnxManufacturer_M_BLUE_AND_RED, true
	case 503:
		return KnxManufacturer_M_FROGBLUE, true
	case 504:
		return KnxManufacturer_M_LUXIO, true
	case 505:
		return KnxManufacturer_M_APP_TECH, true
	case 506:
		return KnxManufacturer_M_SENSORTEC_AG, true
	case 507:
		return KnxManufacturer_M_NYSA_TECHNOLOGY_AND_SOLUTIONS, true
	case 508:
		return KnxManufacturer_M_FARADITE, true
	case 509:
		return KnxManufacturer_M_OPTIMUS, true
	case 51:
		return KnxManufacturer_M_JOH__VAILLANT, true
	case 510:
		return KnxManufacturer_M_KTS_S_R_L_, true
	case 511:
		return KnxManufacturer_M_RAMCRO_SPA, true
	case 512:
		return KnxManufacturer_M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD, true
	case 513:
		return KnxManufacturer_M_BEMI_SMART_HOME_LTD, true
	case 514:
		return KnxManufacturer_M_ARDOMUS, true
	case 515:
		return KnxManufacturer_M_CHANGXING, true
	case 516:
		return KnxManufacturer_M_E_CONTROLS, true
	case 517:
		return KnxManufacturer_M_AIB_TECHNOLOGY, true
	case 518:
		return KnxManufacturer_M_NVC, true
	case 519:
		return KnxManufacturer_M_KBOX, true
	case 52:
		return KnxManufacturer_M_AMP_DEUTSCHLAND, true
	case 520:
		return KnxManufacturer_M_CNS, true
	case 521:
		return KnxManufacturer_M_TYBA, true
	case 522:
		return KnxManufacturer_M_ATREL, true
	case 523:
		return KnxManufacturer_M_SIMON_ELECTRIC_CHINA_CO___LTD, true
	case 524:
		return KnxManufacturer_M_KORDZ_GROUP, true
	case 525:
		return KnxManufacturer_M_ND_ELECTRIC, true
	case 526:
		return KnxManufacturer_M_CONTROLIUM, true
	case 527:
		return KnxManufacturer_M_FAMO_GMBH_AND_CO__KG, true
	case 528:
		return KnxManufacturer_M_CDN_SMART, true
	case 529:
		return KnxManufacturer_M_HESTON, true
	case 53:
		return KnxManufacturer_M_BOSCH_THERMOTECHNIK_GMBH, true
	case 530:
		return KnxManufacturer_M_ESLA_CONEXIONES_S_L_, true
	case 531:
		return KnxManufacturer_M_WEISHAUPT, true
	case 532:
		return KnxManufacturer_M_ASTRUM_TECHNOLOGY, true
	case 533:
		return KnxManufacturer_M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_, true
	case 534:
		return KnxManufacturer_M_NANOTECO_CORPORATION, true
	case 535:
		return KnxManufacturer_M_NIETIAN, true
	case 536:
		return KnxManufacturer_M_SUMSIR, true
	case 537:
		return KnxManufacturer_M_ORBIS_TECNOLOGIA_ELECTRICA_SA, true
	case 538:
		return KnxManufacturer_M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_, true
	case 539:
		return KnxManufacturer_M_ANLIPS, true
	case 54:
		return KnxManufacturer_M_SEF___ECOTEC, true
	case 540:
		return KnxManufacturer_M_GUANGDONG_PAK_CORPORATION_CO___LTD, true
	case 541:
		return KnxManufacturer_M_BVK_TECHNOLOGY, true
	case 542:
		return KnxManufacturer_M_SOLOMIO_SRL, true
	case 543:
		return KnxManufacturer_M_DOMOTICA_LABS, true
	case 544:
		return KnxManufacturer_M_NVC_INTERNATIONAL, true
	case 545:
		return KnxManufacturer_M_BA, true
	case 546:
		return KnxManufacturer_M_IRIS_CERAMICA_GROUP, true
	case 547:
		return KnxManufacturer_M_WIREEO, true
	case 548:
		return KnxManufacturer_M_NVCLIGHTING, true
	case 549:
		return KnxManufacturer_M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_, true
	case 55:
		return KnxManufacturer_M_DORMA_GMBH_Plus_CO__KG, true
	case 550:
		return KnxManufacturer_M_ARMITI_TRADING, true
	case 551:
		return KnxManufacturer_M_ELEK, true
	case 552:
		return KnxManufacturer_M_ACCORDIA_SA, true
	case 553:
		return KnxManufacturer_M_OURICAN, true
	case 554:
		return KnxManufacturer_M_INLIWOSE, true
	case 555:
		return KnxManufacturer_M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_, true
	case 556:
		return KnxManufacturer_M_SHK_KNX, true
	case 557:
		return KnxManufacturer_M_AMPIO, true
	case 558:
		return KnxManufacturer_M_MINGXING_WISDOM, true
	case 559:
		return KnxManufacturer_M_ALTEN_SW_GMBH, true
	case 56:
		return KnxManufacturer_M_WINDOWMASTER_AS, true
	case 560:
		return KnxManufacturer_M_V_Y_C_SRL, true
	case 561:
		return KnxManufacturer_M_TERMINUS_GROUP, true
	case 562:
		return KnxManufacturer_M_WONDERFUL_CITY_TECHNOLOGY, true
	case 563:
		return KnxManufacturer_M_QBICTECHNOLOGY, true
	case 564:
		return KnxManufacturer_M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED, true
	case 565:
		return KnxManufacturer_M_ONEWORK, true
	case 566:
		return KnxManufacturer_M_PL_LINK, true
	case 567:
		return KnxManufacturer_M_FASEL_GMBH_ELEKTRONIK, true
	case 568:
		return KnxManufacturer_M_GOLDENHOME_SMART, true
	case 569:
		return KnxManufacturer_M_GOLDMEDAL, true
	case 57:
		return KnxManufacturer_M_WALTHER_WERKE, true
	case 570:
		return KnxManufacturer_M_CannX, true
	case 571:
		return KnxManufacturer_M_EGI___EARTH_GOODNESS, true
	case 572:
		return KnxManufacturer_M_VIEGA_GMBH_AND_CO__KG, true
	case 573:
		return KnxManufacturer_M_FREDON_DIGITAL_BUILDINGS, true
	case 574:
		return KnxManufacturer_M_HELUKABEL_THAILAND_CO__LTD_, true
	case 575:
		return KnxManufacturer_M_SICS, true
	case 576:
		return KnxManufacturer_M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD, true
	case 577:
		return KnxManufacturer_M_SUMAMO, true
	case 578:
		return KnxManufacturer_M_SVIT, true
	case 579:
		return KnxManufacturer_M_TECGET, true
	case 58:
		return KnxManufacturer_M_ORAS, true
	case 580:
		return KnxManufacturer_M_XEROPOINT, true
	case 581:
		return KnxManufacturer_M_HONEYWELL_BUILDING_TECHNOLOGIES, true
	case 582:
		return KnxManufacturer_M_COMFORTCLICK, true
	case 583:
		return KnxManufacturer_M_DORBAS_ELECTRIC, true
	case 584:
		return KnxManufacturer_M_REMKO_GMBH_AND_CO__KG, true
	case 585:
		return KnxManufacturer_M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD, true
	case 586:
		return KnxManufacturer_M_ANDAS, true
	case 587:
		return KnxManufacturer_M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD, true
	case 588:
		return KnxManufacturer_M_LARFE, true
	case 589:
		return KnxManufacturer_M_DONGGUAN_MUHCCI_ELECTRICAL, true
	case 59:
		return KnxManufacturer_M_DAETWYLER, true
	case 590:
		return KnxManufacturer_M_STEC, true
	case 591:
		return KnxManufacturer_M_ARIGO_SOFTWARE_GMBH, true
	case 592:
		return KnxManufacturer_M_FEISHELEC, true
	case 593:
		return KnxManufacturer_M_GORDIC, true
	case 594:
		return KnxManufacturer_M_DELTA_ELECTRONICS, true
	case 595:
		return KnxManufacturer_M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_, true
	case 596:
		return KnxManufacturer_M_KG_POWER, true
	case 597:
		return KnxManufacturer_M_ZHEJIANG_MOORGEN_GROUP_CO__LTD, true
	case 598:
		return KnxManufacturer_M_GUANGDONG_KANWAY, true
	case 599:
		return KnxManufacturer_M_RAMIREZ_ENGINEERING_GMBH, true
	case 6:
		return KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO, true
	case 60:
		return KnxManufacturer_M_ELECTRAK, true
	case 600:
		return KnxManufacturer_M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD, true
	case 601:
		return KnxManufacturer_M_VIHAN_ELECTRIC_PVT_LTD, true
	case 602:
		return KnxManufacturer_M_SPLENDID_MINDS_GMBH, true
	case 603:
		return KnxManufacturer_M_ESTADA, true
	case 604:
		return KnxManufacturer_M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI, true
	case 605:
		return KnxManufacturer_M_STUHL_REGELSYSTEME_GMBH, true
	case 606:
		return KnxManufacturer_M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD, true
	case 607:
		return KnxManufacturer_M_GAIMEX, true
	case 608:
		return KnxManufacturer_M_B3_INTERNATIONAL_S_R_L, true
	case 609:
		return KnxManufacturer_M_MM_ELECTRO, true
	case 61:
		return KnxManufacturer_M_TECHEM, true
	case 610:
		return KnxManufacturer_M_CASCODA, true
	case 611:
		return KnxManufacturer_M_XIAMEN_INTRETECH_INC_, true
	case 612:
		return KnxManufacturer_M_KILOELEC_TECHNOLOGY, true
	case 613:
		return KnxManufacturer_M_INYX, true
	case 614:
		return KnxManufacturer_M_SMART_BUILDING_SERVICES_GMBH, true
	case 615:
		return KnxManufacturer_M_BSS_GMBH, true
	case 616:
		return KnxManufacturer_M_LUMI_ELECTRONICS, true
	case 617:
		return KnxManufacturer_M_OJEAELECTRONICS, true
	case 618:
		return KnxManufacturer_M_SMART_NODE, true
	case 619:
		return KnxManufacturer_M_NEXHOME, true
	case 62:
		return KnxManufacturer_M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS, true
	case 620:
		return KnxManufacturer_M_HUOTENG_WULIAN_JIANGSU_CO___LTD, true
	case 621:
		return KnxManufacturer_M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD, true
	case 622:
		return KnxManufacturer_M_BITS_AND_BYTES, true
	case 623:
		return KnxManufacturer_M_KFV_SIEGENIA_GRUPPE, true
	case 624:
		return KnxManufacturer_M_SYMCON, true
	case 625:
		return KnxManufacturer_M_I_TRUST, true
	case 626:
		return KnxManufacturer_M_DRD_TECHNICS, true
	case 627:
		return KnxManufacturer_M_LENGEN, true
	case 628:
		return KnxManufacturer_M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD, true
	case 629:
		return KnxManufacturer_M_VIBROXX_FZCO, true
	case 63:
		return KnxManufacturer_M_WHD_WILHELM_HUBER_Plus_SOEHNE, true
	case 630:
		return KnxManufacturer_M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD, true
	case 631:
		return KnxManufacturer_M_PASSIV_ENERGIE_GMBH, true
	case 632:
		return KnxManufacturer_M_PAYNE_TECHNOLOGIES_LTD, true
	case 633:
		return KnxManufacturer_M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_, true
	case 634:
		return KnxManufacturer_M_SEXANKA, true
	case 635:
		return KnxManufacturer_M_SECURI_FLEX_LTD, true
	case 636:
		return KnxManufacturer_M_BOKE, true
	case 637:
		return KnxManufacturer_M_SBR_SYSTEM_TECHNICAL, true
	case 638:
		return KnxManufacturer_M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_, true
	case 639:
		return KnxManufacturer_M_BOLATU, true
	case 64:
		return KnxManufacturer_M_BISCHOFF_ELEKTRONIK, true
	case 640:
		return KnxManufacturer_M_RECBER_KABLO_A_S_, true
	case 641:
		return KnxManufacturer_M_ILITE_KNX, true
	case 642:
		return KnxManufacturer_M_LAZZEN, true
	case 643:
		return KnxManufacturer_M_MOX_CONTROL_IT_CHINA_LIMITED, true
	case 644:
		return KnxManufacturer_M_CLOWIRE, true
	case 645:
		return KnxManufacturer_M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD, true
	case 646:
		return KnxManufacturer_M_NS_TOUCH, true
	case 647:
		return KnxManufacturer_M_ROOMIO, true
	case 648:
		return KnxManufacturer_M_ATOUCH, true
	case 649:
		return KnxManufacturer_M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD, true
	case 65:
		return KnxManufacturer_M_JEPAZ, true
	case 650:
		return KnxManufacturer_M_WALLYONS, true
	case 651:
		return KnxManufacturer_M_ZIMMEX, true
	case 652:
		return KnxManufacturer_M_RHOMBUS_EUROPE, true
	case 653:
		return KnxManufacturer_M_TURING_THINK, true
	case 654:
		return KnxManufacturer_M_MICHOI, true
	case 655:
		return KnxManufacturer_M_CAV_SMARTGUANGZHOUCO__LTD, true
	case 656:
		return KnxManufacturer_M_HELKAMA_BICA_OY, true
	case 657:
		return KnxManufacturer_M_MODULYTE, true
	case 658:
		return KnxManufacturer_M_CONSOLINNO_ENERGY_GMBH, true
	case 659:
		return KnxManufacturer_M_SCHIDERON_ELECTRIC_ASIA_LIMITED, true
	case 66:
		return KnxManufacturer_M_RTS_AUTOMATION, true
	case 660:
		return KnxManufacturer_M_3R, true
	case 661:
		return KnxManufacturer_M_ARKLYFE, true
	case 662:
		return KnxManufacturer_M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_, true
	case 663:
		return KnxManufacturer_M_KNXES_COMPANY_LIMITED, true
	case 664:
		return KnxManufacturer_M_AKUVOX, true
	case 665:
		return KnxManufacturer_M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_, true
	case 666:
		return KnxManufacturer_M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD, true
	case 667:
		return KnxManufacturer_M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD, true
	case 668:
		return KnxManufacturer_M_MUTLUSAN_ELECTRIC, true
	case 669:
		return KnxManufacturer_M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_, true
	case 67:
		return KnxManufacturer_M_EIBMARKT_GMBH, true
	case 670:
		return KnxManufacturer_M_MARLEY_DEUTSCHLAND_GMBH, true
	case 671:
		return KnxManufacturer_M_CREATROL, true
	case 672:
		return KnxManufacturer_M_EUTELSAT, true
	case 673:
		return KnxManufacturer_M_TECNIKABEL, true
	case 674:
		return KnxManufacturer_M_ATIOS_AG, true
	case 675:
		return KnxManufacturer_M_SMARTLICHT, true
	case 676:
		return KnxManufacturer_M_BEIJING_BEVONE_ELECTRIC_CO__LTD_, true
	case 677:
		return KnxManufacturer_M_ELSMART, true
	case 678:
		return KnxManufacturer_M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC, true
	case 679:
		return KnxManufacturer_M_HANGZHOU_SANYUAN_CABLE_CO___LTD, true
	case 68:
		return KnxManufacturer_M_WAREMA_RENKHOFF_SE, true
	case 680:
		return KnxManufacturer_M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_, true
	case 681:
		return KnxManufacturer_M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_, true
	case 682:
		return KnxManufacturer_M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD, true
	case 683:
		return KnxManufacturer_M_VITRUM_DESIGN, true
	case 684:
		return KnxManufacturer_M_DETRONS, true
	case 685:
		return KnxManufacturer_M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD, true
	case 686:
		return KnxManufacturer_M_VARNI_DIGITAL_PRIVATE_LIMITED, true
	case 687:
		return KnxManufacturer_M_3A_ENTREPRISE_APS, true
	case 688:
		return KnxManufacturer_M_ITALIANA_CONDUTTORI_SRL, true
	case 689:
		return KnxManufacturer_M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_, true
	case 69:
		return KnxManufacturer_M_EELECTRON, true
	case 690:
		return KnxManufacturer_M_LEDNX, true
	case 691:
		return KnxManufacturer_M_EBELONG, true
	case 692:
		return KnxManufacturer_M_ASTRA_LED_AG, true
	case 693:
		return KnxManufacturer_M_WONDERFUL_HI_TECH_CO___LTD_, true
	case 694:
		return KnxManufacturer_M_REXLITE_AI_INTEGRATIONS_CO__LTD, true
	case 695:
		return KnxManufacturer_M_ALLORADO, true
	case 696:
		return KnxManufacturer_M_FUZHOU_MILI_TECHNOLOGY_CO___LTD, true
	case 697:
		return KnxManufacturer_M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD, true
	case 698:
		return KnxManufacturer_M_HYSINE, true
	case 699:
		return KnxManufacturer_M_SANTAN, true
	case 7:
		return KnxManufacturer_M_GIRA_GIERSIEPEN, true
	case 70:
		return KnxManufacturer_M_BELDEN_WIRE_AND_CABLE_B_V_, true
	case 700:
		return KnxManufacturer_M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD, true
	case 701:
		return KnxManufacturer_M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD, true
	case 702:
		return KnxManufacturer_M_POLAR_BEAR_DESIGN, true
	case 703:
		return KnxManufacturer_M_ELESSAN_NV, true
	case 704:
		return KnxManufacturer_M_MIR, true
	case 705:
		return KnxManufacturer_M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD, true
	case 706:
		return KnxManufacturer_M_LEAX_CONTROLS_CO___LTD_, true
	case 707:
		return KnxManufacturer_M_ALCAD, true
	case 708:
		return KnxManufacturer_M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD, true
	case 709:
		return KnxManufacturer_M_TAOS_ELECTRIC_CO___LTD, true
	case 71:
		return KnxManufacturer_M_BECKER_ANTRIEBE_GMBH, true
	case 710:
		return KnxManufacturer_M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION, true
	case 711:
		return KnxManufacturer_M_ASAY_Q, true
	case 712:
		return KnxManufacturer_M_LAPP, true
	case 713:
		return KnxManufacturer_M_ZEROBIT_DYNAMIC, true
	case 714:
		return KnxManufacturer_M_HAVELLS, true
	case 715:
		return KnxManufacturer_M_MULLER_INTUITIV, true
	case 716:
		return KnxManufacturer_M_TASKIT_GMBH, true
	case 717:
		return KnxManufacturer_M_COSTER_GROUP, true
	case 718:
		return KnxManufacturer_M_NXP_SEMICONDUCTOR, true
	case 719:
		return KnxManufacturer_M_COGCONS, true
	case 72:
		return KnxManufacturer_M_J_STEHLEPlusSOEHNE_GMBH, true
	case 720:
		return KnxManufacturer_M_MICRO_TEK_SRL_F_M_C_TRADE_MARK, true
	case 721:
		return KnxManufacturer_M_ORENDA_ELECTRIC, true
	case 722:
		return KnxManufacturer_M_ERSE_KABLO, true
	case 723:
		return KnxManufacturer_M_PRADO_EUROPE_BV, true
	case 724:
		return KnxManufacturer_M_E2S_GBR, true
	case 725:
		return KnxManufacturer_M_UNITLINK, true
	case 726:
		return KnxManufacturer_M_ONNA, true
	case 727:
		return KnxManufacturer_M_CENTERSVET_LLC, true
	case 728:
		return KnxManufacturer_M_ADVECO_TECHNOLOGY_CO___LTD_, true
	case 729:
		return KnxManufacturer_M_FR__LUERSSEN_WERFT, true
	case 73:
		return KnxManufacturer_M_AGFEO, true
	case 730:
		return KnxManufacturer_M_MYLYR, true
	case 731:
		return KnxManufacturer_M_HYUNDAI_HT, true
	case 732:
		return KnxManufacturer_M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD, true
	case 733:
		return KnxManufacturer_M_SMATEK_ELECTRONICS_LIMITED, true
	case 734:
		return KnxManufacturer_M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_, true
	case 735:
		return KnxManufacturer_M_MORELINKS_SMART_HOME, true
	case 736:
		return KnxManufacturer_M_CIRTX_GMBH, true
	case 737:
		return KnxManufacturer_M_QLITE, true
	case 738:
		return KnxManufacturer_M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD, true
	case 739:
		return KnxManufacturer_M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_, true
	case 74:
		return KnxManufacturer_M_ZENNIO, true
	case 740:
		return KnxManufacturer_M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD, true
	case 741:
		return KnxManufacturer_M_CONFIO, true
	case 742:
		return KnxManufacturer_M_SONIC_TECHNOLOGIES, true
	case 743:
		return KnxManufacturer_M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT, true
	case 744:
		return KnxManufacturer_M_ABI_SICHERHEITSSYSTEME_GMBH, true
	case 745:
		return KnxManufacturer_M_RYT, true
	case 746:
		return KnxManufacturer_M_AURIGA_SYSTEMS, true
	case 747:
		return KnxManufacturer_M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH, true
	case 748:
		return KnxManufacturer_M_GIANFRANCO_SMART_SOLUTIONS_LTD, true
	case 749:
		return KnxManufacturer_M_ROGERWELL_CONTROL_SYSTEM_LIMITED, true
	case 75:
		return KnxManufacturer_M_TAPKO_TECHNOLOGIES, true
	case 750:
		return KnxManufacturer_M_ABB___RESERVED, true
	case 751:
		return KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO___RESERVED, true
	case 76:
		return KnxManufacturer_M_HDL, true
	case 77:
		return KnxManufacturer_M_UPONOR, true
	case 78:
		return KnxManufacturer_M_SE_LIGHTMANAGEMENT_AG, true
	case 79:
		return KnxManufacturer_M_ARCUS_EDS, true
	case 8:
		return KnxManufacturer_M_HAGER_ELECTRO, true
	case 80:
		return KnxManufacturer_M_INTESIS, true
	case 81:
		return KnxManufacturer_M_HERHOLDT_CONTROLS_SRL, true
	case 82:
		return KnxManufacturer_M_NIKO_ZUBLIN, true
	case 83:
		return KnxManufacturer_M_DURABLE_TECHNOLOGIES, true
	case 84:
		return KnxManufacturer_M_INNOTEAM, true
	case 85:
		return KnxManufacturer_M_ISE_GMBH, true
	case 86:
		return KnxManufacturer_M_TEAM_FOR_TRONICS, true
	case 87:
		return KnxManufacturer_M_CARRIER_SAS, true
	case 88:
		return KnxManufacturer_M_REMEHA_BV, true
	case 89:
		return KnxManufacturer_M_ESYLUX, true
	case 9:
		return KnxManufacturer_M_INSTA_GMBH, true
	case 90:
		return KnxManufacturer_M_BASALTE, true
	case 91:
		return KnxManufacturer_M_VESTAMATIC, true
	case 92:
		return KnxManufacturer_M_MDT_TECHNOLOGIES, true
	case 93:
		return KnxManufacturer_M_WARENDORFER_KUECHEN_GMBH, true
	case 94:
		return KnxManufacturer_M_GVS, true
	case 95:
		return KnxManufacturer_M_SITEK, true
	case 96:
		return KnxManufacturer_M_CONTROLTRONIC, true
	case 97:
		return KnxManufacturer_M_FUNCTION_TECHNOLOGY, true
	case 98:
		return KnxManufacturer_M_AMX, true
	case 99:
		return KnxManufacturer_M_ELDAT, true
	}
	return 0, false
}

func KnxManufacturerByName(value string) (enum KnxManufacturer, ok bool) {
	switch value {
	case "M_UNKNOWN":
		return KnxManufacturer_M_UNKNOWN, true
	case "M_SIEMENS":
		return KnxManufacturer_M_SIEMENS, true
	case "M_LEGRAND_APPAREILLAGE_ELECTRIQUE":
		return KnxManufacturer_M_LEGRAND_APPAREILLAGE_ELECTRIQUE, true
	case "M_PANASONIC":
		return KnxManufacturer_M_PANASONIC, true
	case "M_PULSE_TECHNOLOGIES":
		return KnxManufacturer_M_PULSE_TECHNOLOGIES, true
	case "M_CRESTRON":
		return KnxManufacturer_M_CRESTRON, true
	case "M_STEINEL_PROFESSIONAL":
		return KnxManufacturer_M_STEINEL_PROFESSIONAL, true
	case "M_BILTON_LED_LIGHTING":
		return KnxManufacturer_M_BILTON_LED_LIGHTING, true
	case "M_DENRO_AG":
		return KnxManufacturer_M_DENRO_AG, true
	case "M_GEPRO":
		return KnxManufacturer_M_GEPRO, true
	case "M_PREUSSEN_AUTOMATION":
		return KnxManufacturer_M_PREUSSEN_AUTOMATION, true
	case "M_ZOPPAS_INDUSTRIES":
		return KnxManufacturer_M_ZOPPAS_INDUSTRIES, true
	case "M_MACTECH":
		return KnxManufacturer_M_MACTECH, true
	case "M_MERTEN":
		return KnxManufacturer_M_MERTEN, true
	case "M_TECHNO_TREND":
		return KnxManufacturer_M_TECHNO_TREND, true
	case "M_FS_CABLES":
		return KnxManufacturer_M_FS_CABLES, true
	case "M_DELTA_DORE":
		return KnxManufacturer_M_DELTA_DORE, true
	case "M_EISSOUND":
		return KnxManufacturer_M_EISSOUND, true
	case "M_CISCO":
		return KnxManufacturer_M_CISCO, true
	case "M_DINUY":
		return KnxManufacturer_M_DINUY, true
	case "M_IKNIX":
		return KnxManufacturer_M_IKNIX, true
	case "M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH":
		return KnxManufacturer_M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH, true
	case "M_EGI_ELECTROACUSTICA_GENERAL_IBERICA":
		return KnxManufacturer_M_EGI_ELECTROACUSTICA_GENERAL_IBERICA, true
	case "M_BES___INGENIUM":
		return KnxManufacturer_M_BES___INGENIUM, true
	case "M_ABB_SPA_SACE_DIVISION":
		return KnxManufacturer_M_ABB_SPA_SACE_DIVISION, true
	case "M_ELABNET":
		return KnxManufacturer_M_ELABNET, true
	case "M_BLUMOTIX":
		return KnxManufacturer_M_BLUMOTIX, true
	case "M_HUNTER_DOUGLAS":
		return KnxManufacturer_M_HUNTER_DOUGLAS, true
	case "M_APRICUM":
		return KnxManufacturer_M_APRICUM, true
	case "M_TIANSU_AUTOMATION":
		return KnxManufacturer_M_TIANSU_AUTOMATION, true
	case "M_BUBENDORFF":
		return KnxManufacturer_M_BUBENDORFF, true
	case "M_MBS_GMBH":
		return KnxManufacturer_M_MBS_GMBH, true
	case "M_ENERTEX_BAYERN_GMBH":
		return KnxManufacturer_M_ENERTEX_BAYERN_GMBH, true
	case "M_BMS":
		return KnxManufacturer_M_BMS, true
	case "M_SINAPSI":
		return KnxManufacturer_M_SINAPSI, true
	case "M_SIEDLE_AND_SOEHNE":
		return KnxManufacturer_M_SIEDLE_AND_SOEHNE, true
	case "M_EMBEDDED_SYSTEMS_SIA":
		return KnxManufacturer_M_EMBEDDED_SYSTEMS_SIA, true
	case "M_KNX1":
		return KnxManufacturer_M_KNX1, true
	case "M_TOKKA":
		return KnxManufacturer_M_TOKKA, true
	case "M_NANOSENSE":
		return KnxManufacturer_M_NANOSENSE, true
	case "M_PEAR_AUTOMATION_GMBH":
		return KnxManufacturer_M_PEAR_AUTOMATION_GMBH, true
	case "M_DGA":
		return KnxManufacturer_M_DGA, true
	case "M_LUTRON":
		return KnxManufacturer_M_LUTRON, true
	case "M_AIRZONE___ALTRA":
		return KnxManufacturer_M_AIRZONE___ALTRA, true
	case "M_LITHOSS_DESIGN_SWITCHES":
		return KnxManufacturer_M_LITHOSS_DESIGN_SWITCHES, true
	case "M_THREEATEL":
		return KnxManufacturer_M_THREEATEL, true
	case "M_EBERLE":
		return KnxManufacturer_M_EBERLE, true
	case "M_PHILIPS_CONTROLS":
		return KnxManufacturer_M_PHILIPS_CONTROLS, true
	case "M_VELUX_AS":
		return KnxManufacturer_M_VELUX_AS, true
	case "M_LOYTEC":
		return KnxManufacturer_M_LOYTEC, true
	case "M_EKINEX_S_P_A_":
		return KnxManufacturer_M_EKINEX_S_P_A_, true
	case "M_SIRLAN_TECHNOLOGIES":
		return KnxManufacturer_M_SIRLAN_TECHNOLOGIES, true
	case "M_PROKNX_SAS":
		return KnxManufacturer_M_PROKNX_SAS, true
	case "M_IT_GMBH":
		return KnxManufacturer_M_IT_GMBH, true
	case "M_RENSON":
		return KnxManufacturer_M_RENSON, true
	case "M_HEP_GROUP":
		return KnxManufacturer_M_HEP_GROUP, true
	case "M_BALMART":
		return KnxManufacturer_M_BALMART, true
	case "M_GEWISS":
		return KnxManufacturer_M_GEWISS, true
	case "M_GFS_GMBH":
		return KnxManufacturer_M_GFS_GMBH, true
	case "M_SCHENKER_STOREN_AG":
		return KnxManufacturer_M_SCHENKER_STOREN_AG, true
	case "M_ALGODUE_ELETTRONICA_S_R_L_":
		return KnxManufacturer_M_ALGODUE_ELETTRONICA_S_R_L_, true
	case "M_ABB_FRANCE":
		return KnxManufacturer_M_ABB_FRANCE, true
	case "M_MAINTRONIC":
		return KnxManufacturer_M_MAINTRONIC, true
	case "M_VANTAGE":
		return KnxManufacturer_M_VANTAGE, true
	case "M_FORESIS":
		return KnxManufacturer_M_FORESIS, true
	case "M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM":
		return KnxManufacturer_M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM, true
	case "M_WEINZIERL_ENGINEERING_GMBH":
		return KnxManufacturer_M_WEINZIERL_ENGINEERING_GMBH, true
	case "M_MOEHLENHOFF_WAERMETECHNIK_GMBH":
		return KnxManufacturer_M_MOEHLENHOFF_WAERMETECHNIK_GMBH, true
	case "M_ALBERT_ACKERMANN":
		return KnxManufacturer_M_ALBERT_ACKERMANN, true
	case "M_PKC_GROUP_OYJ":
		return KnxManufacturer_M_PKC_GROUP_OYJ, true
	case "M_B_E_G_":
		return KnxManufacturer_M_B_E_G_, true
	case "M_ELSNER_ELEKTRONIK_GMBH":
		return KnxManufacturer_M_ELSNER_ELEKTRONIK_GMBH, true
	case "M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_":
		return KnxManufacturer_M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_, true
	case "M_EUTRAC":
		return KnxManufacturer_M_EUTRAC, true
	case "M_GUSTAV_HENSEL_GMBH_AND_CO__KG":
		return KnxManufacturer_M_GUSTAV_HENSEL_GMBH_AND_CO__KG, true
	case "M_GARO_AB":
		return KnxManufacturer_M_GARO_AB, true
	case "M_WALDMANN_LICHTTECHNIK":
		return KnxManufacturer_M_WALDMANN_LICHTTECHNIK, true
	case "M_SCHUECO":
		return KnxManufacturer_M_SCHUECO, true
	case "M_EMU":
		return KnxManufacturer_M_EMU, true
	case "M_SCHUPA_GMBH":
		return KnxManufacturer_M_SCHUPA_GMBH, true
	case "M_JNET_SYSTEMS_AG":
		return KnxManufacturer_M_JNET_SYSTEMS_AG, true
	case "M_TOTAL_SOLUTION_GMBH":
		return KnxManufacturer_M_TOTAL_SOLUTION_GMBH, true
	case "M_O_Y_L__ELECTRONICS":
		return KnxManufacturer_M_O_Y_L__ELECTRONICS, true
	case "M_GALAX_SYSTEM":
		return KnxManufacturer_M_GALAX_SYSTEM, true
	case "M_DISCH":
		return KnxManufacturer_M_DISCH, true
	case "M_AUCOTEAM":
		return KnxManufacturer_M_AUCOTEAM, true
	case "M_LUXMATE_CONTROLS":
		return KnxManufacturer_M_LUXMATE_CONTROLS, true
	case "M_DANFOSS":
		return KnxManufacturer_M_DANFOSS, true
	case "M_AST_GMBH":
		return KnxManufacturer_M_AST_GMBH, true
	case "M_WILA_LEUCHTEN":
		return KnxManufacturer_M_WILA_LEUCHTEN, true
	case "M_ABB_SCHWEIZ":
		return KnxManufacturer_M_ABB_SCHWEIZ, true
	case "M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK":
		return KnxManufacturer_M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK, true
	case "M_LINGG_AND_JANKE":
		return KnxManufacturer_M_LINGG_AND_JANKE, true
	case "M_SAUTER":
		return KnxManufacturer_M_SAUTER, true
	case "M_SIMU":
		return KnxManufacturer_M_SIMU, true
	case "M_THEBEN_HTS_AG":
		return KnxManufacturer_M_THEBEN_HTS_AG, true
	case "M_AMANN_GMBH":
		return KnxManufacturer_M_AMANN_GMBH, true
	case "M_BERG_ENERGIEKONTROLLSYSTEME_GMBH":
		return KnxManufacturer_M_BERG_ENERGIEKONTROLLSYSTEME_GMBH, true
	case "M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH":
		return KnxManufacturer_M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH, true
	case "M_OVENTROP_KG":
		return KnxManufacturer_M_OVENTROP_KG, true
	case "M_GRIESSER_AG":
		return KnxManufacturer_M_GRIESSER_AG, true
	case "M_FELLER":
		return KnxManufacturer_M_FELLER, true
	case "M_IPAS_GMBH":
		return KnxManufacturer_M_IPAS_GMBH, true
	case "M_ELERO_GMBH":
		return KnxManufacturer_M_ELERO_GMBH, true
	case "M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_":
		return KnxManufacturer_M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_, true
	case "M_METEC_MESSTECHNIK_GMBH":
		return KnxManufacturer_M_METEC_MESSTECHNIK_GMBH, true
	case "M_BUERK_MOBATIME":
		return KnxManufacturer_M_BUERK_MOBATIME, true
	case "M_ELKA_ELEKTRONIK_GMBH":
		return KnxManufacturer_M_ELKA_ELEKTRONIK_GMBH, true
	case "M_ELEKTROANLAGEN_D__NAGEL":
		return KnxManufacturer_M_ELEKTROANLAGEN_D__NAGEL, true
	case "M_TRIDONIC_BAUELEMENTE_GMBH":
		return KnxManufacturer_M_TRIDONIC_BAUELEMENTE_GMBH, true
	case "M_STENGLER_GESELLSCHAFT":
		return KnxManufacturer_M_STENGLER_GESELLSCHAFT, true
	case "M_SCHNEIDER_ELECTRIC_MG":
		return KnxManufacturer_M_SCHNEIDER_ELECTRIC_MG, true
	case "M_ABB":
		return KnxManufacturer_M_ABB, true
	case "M_GLAMOX_AS":
		return KnxManufacturer_M_GLAMOX_AS, true
	case "M_KNX_ASSOCIATION":
		return KnxManufacturer_M_KNX_ASSOCIATION, true
	case "M_VIVO":
		return KnxManufacturer_M_VIVO, true
	case "M_HUGO_MUELLER_GMBH_AND_CO_KG":
		return KnxManufacturer_M_HUGO_MUELLER_GMBH_AND_CO_KG, true
	case "M_SIEMENS_HVAC":
		return KnxManufacturer_M_SIEMENS_HVAC, true
	case "M_APT":
		return KnxManufacturer_M_APT, true
	case "M_HIGHDOM":
		return KnxManufacturer_M_HIGHDOM, true
	case "M_TOP_SERVICES":
		return KnxManufacturer_M_TOP_SERVICES, true
	case "M_AMBIHOME":
		return KnxManufacturer_M_AMBIHOME, true
	case "M_DATEC_ELECTRONIC_AG":
		return KnxManufacturer_M_DATEC_ELECTRONIC_AG, true
	case "M_ABUS_SECURITY_CENTER":
		return KnxManufacturer_M_ABUS_SECURITY_CENTER, true
	case "M_DEHN_AND_SOEHNE":
		return KnxManufacturer_M_DEHN_AND_SOEHNE, true
	case "M_LITE_PUTER":
		return KnxManufacturer_M_LITE_PUTER, true
	case "M_TANTRON_ELECTRONIC":
		return KnxManufacturer_M_TANTRON_ELECTRONIC, true
	case "M_INTERRA":
		return KnxManufacturer_M_INTERRA, true
	case "M_DKX_TECH":
		return KnxManufacturer_M_DKX_TECH, true
	case "M_VIATRON":
		return KnxManufacturer_M_VIATRON, true
	case "M_NAUTIBUS":
		return KnxManufacturer_M_NAUTIBUS, true
	case "M_ON_SEMICONDUCTOR":
		return KnxManufacturer_M_ON_SEMICONDUCTOR, true
	case "M_LONGCHUANG":
		return KnxManufacturer_M_LONGCHUANG, true
	case "M_AIR_ON_AG":
		return KnxManufacturer_M_AIR_ON_AG, true
	case "M_IB_COMPANY_GMBH":
		return KnxManufacturer_M_IB_COMPANY_GMBH, true
	case "M_CRABTREE":
		return KnxManufacturer_M_CRABTREE, true
	case "M_SATION_FACTORY":
		return KnxManufacturer_M_SATION_FACTORY, true
	case "M_AGENTILO_GMBH":
		return KnxManufacturer_M_AGENTILO_GMBH, true
	case "M_MAKEL_ELEKTRIK":
		return KnxManufacturer_M_MAKEL_ELEKTRIK, true
	case "M_HELIOS_VENTILATOREN":
		return KnxManufacturer_M_HELIOS_VENTILATOREN, true
	case "M_OTTO_SOLUTIONS_PTE_LTD":
		return KnxManufacturer_M_OTTO_SOLUTIONS_PTE_LTD, true
	case "M_AIRMASTER":
		return KnxManufacturer_M_AIRMASTER, true
	case "M_VALLOX_GMBH":
		return KnxManufacturer_M_VALLOX_GMBH, true
	case "M_DALITEK":
		return KnxManufacturer_M_DALITEK, true
	case "M_ASIN":
		return KnxManufacturer_M_ASIN, true
	case "M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_":
		return KnxManufacturer_M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_, true
	case "M_EVOKNX":
		return KnxManufacturer_M_EVOKNX, true
	case "M_ARBONIA":
		return KnxManufacturer_M_ARBONIA, true
	case "M_KERMI":
		return KnxManufacturer_M_KERMI, true
	case "M_PROLUX":
		return KnxManufacturer_M_PROLUX, true
	case "M_CLICHOME":
		return KnxManufacturer_M_CLICHOME, true
	case "M_COMMAX":
		return KnxManufacturer_M_COMMAX, true
	case "M_EAE":
		return KnxManufacturer_M_EAE, true
	case "M_TENSE":
		return KnxManufacturer_M_TENSE, true
	case "M_SEYOUNG_ELECTRONICS":
		return KnxManufacturer_M_SEYOUNG_ELECTRONICS, true
	case "M_LIFEDOMUS":
		return KnxManufacturer_M_LIFEDOMUS, true
	case "M_EUROTRONIC_TECHNOLOGY_GMBH":
		return KnxManufacturer_M_EUROTRONIC_TECHNOLOGY_GMBH, true
	case "M_PAUL_HOCHKOEPPER":
		return KnxManufacturer_M_PAUL_HOCHKOEPPER, true
	case "M_TCI":
		return KnxManufacturer_M_TCI, true
	case "M_RISHUN_ELECTRONIC":
		return KnxManufacturer_M_RISHUN_ELECTRONIC, true
	case "M_ZIPATO":
		return KnxManufacturer_M_ZIPATO, true
	case "M_CM_SECURITY_GMBH_AND_CO_KG":
		return KnxManufacturer_M_CM_SECURITY_GMBH_AND_CO_KG, true
	case "M_QING_CABLES":
		return KnxManufacturer_M_QING_CABLES, true
	case "M_WOLF":
		return KnxManufacturer_M_WOLF, true
	case "M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_":
		return KnxManufacturer_M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_, true
	case "M_E_G_E":
		return KnxManufacturer_M_E_G_E, true
	case "M_NETXAUTOMATION":
		return KnxManufacturer_M_NETXAUTOMATION, true
	case "M_TECALOR":
		return KnxManufacturer_M_TECALOR, true
	case "M_ALTENBURGER_ELECTRONIC":
		return KnxManufacturer_M_ALTENBURGER_ELECTRONIC, true
	case "M_URMET_ELECTRONICS_HUIZHOU_LTD_":
		return KnxManufacturer_M_URMET_ELECTRONICS_HUIZHOU_LTD_, true
	case "M_PEIYING_BUILDING_CONTROL":
		return KnxManufacturer_M_PEIYING_BUILDING_CONTROL, true
	case "M_BPT_S_P_A__A_SOCIO_UNICO":
		return KnxManufacturer_M_BPT_S_P_A__A_SOCIO_UNICO, true
	case "M_KANONTEC___KANONBUS":
		return KnxManufacturer_M_KANONTEC___KANONBUS, true
	case "M_ISER_TECH":
		return KnxManufacturer_M_ISER_TECH, true
	case "M_FINELINE":
		return KnxManufacturer_M_FINELINE, true
	case "M_CP_ELECTRONICS_LTD":
		return KnxManufacturer_M_CP_ELECTRONICS_LTD, true
	case "M_NIKO_SERVODAN_AS":
		return KnxManufacturer_M_NIKO_SERVODAN_AS, true
	case "M_SIMON_309":
		return KnxManufacturer_M_SIMON_309, true
	case "M_GM_MODULAR_PVT__LTD_":
		return KnxManufacturer_M_GM_MODULAR_PVT__LTD_, true
	case "M_GRAESSLIN":
		return KnxManufacturer_M_GRAESSLIN, true
	case "M_FU_CHENG_INTELLIGENCE":
		return KnxManufacturer_M_FU_CHENG_INTELLIGENCE, true
	case "M_NEXKON":
		return KnxManufacturer_M_NEXKON, true
	case "M_FEEL_S_R_L":
		return KnxManufacturer_M_FEEL_S_R_L, true
	case "M_NOT_ASSIGNED_314":
		return KnxManufacturer_M_NOT_ASSIGNED_314, true
	case "M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_":
		return KnxManufacturer_M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_, true
	case "M_JIUZHOU_GREEBLE":
		return KnxManufacturer_M_JIUZHOU_GREEBLE, true
	case "M_AUMUELLER_AUMATIC_GMBH":
		return KnxManufacturer_M_AUMUELLER_AUMATIC_GMBH, true
	case "M_ETMAN_ELECTRIC":
		return KnxManufacturer_M_ETMAN_ELECTRIC, true
	case "M_BLACK_NOVA":
		return KnxManufacturer_M_BLACK_NOVA, true
	case "M_ZIDATECH_AG":
		return KnxManufacturer_M_ZIDATECH_AG, true
	case "M_SIMON_42":
		return KnxManufacturer_M_SIMON_42, true
	case "M_IDGS_BVBA":
		return KnxManufacturer_M_IDGS_BVBA, true
	case "M_DAKANIMO":
		return KnxManufacturer_M_DAKANIMO, true
	case "M_TREBOR_AUTOMATION_AB":
		return KnxManufacturer_M_TREBOR_AUTOMATION_AB, true
	case "M_SATEL_SP__Z_O_O_":
		return KnxManufacturer_M_SATEL_SP__Z_O_O_, true
	case "M_RUSSOUND__INC_":
		return KnxManufacturer_M_RUSSOUND__INC_, true
	case "M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD":
		return KnxManufacturer_M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD, true
	case "M_CONSORZIO_TERRANUOVA":
		return KnxManufacturer_M_CONSORZIO_TERRANUOVA, true
	case "M_WOLF_HEIZTECHNIK_GMBH":
		return KnxManufacturer_M_WOLF_HEIZTECHNIK_GMBH, true
	case "M_SONTEC":
		return KnxManufacturer_M_SONTEC, true
	case "M_BELCOM_CABLES_LTD_":
		return KnxManufacturer_M_BELCOM_CABLES_LTD_, true
	case "M_VIMAR":
		return KnxManufacturer_M_VIMAR, true
	case "M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_":
		return KnxManufacturer_M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_, true
	case "M_ACREL":
		return KnxManufacturer_M_ACREL, true
	case "M_KWC_AQUAROTTER_GMBH":
		return KnxManufacturer_M_KWC_AQUAROTTER_GMBH, true
	case "M_ORION_SYSTEMS":
		return KnxManufacturer_M_ORION_SYSTEMS, true
	case "M_SCHRACK_TECHNIK_GMBH":
		return KnxManufacturer_M_SCHRACK_TECHNIK_GMBH, true
	case "M_INSPRID":
		return KnxManufacturer_M_INSPRID, true
	case "M_SUNRICHER":
		return KnxManufacturer_M_SUNRICHER, true
	case "M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_":
		return KnxManufacturer_M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_, true
	case "M_AUREX":
		return KnxManufacturer_M_AUREX, true
	case "M_JOSEF_BARTHELME_GMBH_AND_CO__KG":
		return KnxManufacturer_M_JOSEF_BARTHELME_GMBH_AND_CO__KG, true
	case "M_MOELLER_GEBAEUDEAUTOMATION_KG":
		return KnxManufacturer_M_MOELLER_GEBAEUDEAUTOMATION_KG, true
	case "M_ARCHITECTURE_NUMERIQUE":
		return KnxManufacturer_M_ARCHITECTURE_NUMERIQUE, true
	case "M_UP_GROUP":
		return KnxManufacturer_M_UP_GROUP, true
	case "M_TEKNOS_AVINNO":
		return KnxManufacturer_M_TEKNOS_AVINNO, true
	case "M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY":
		return KnxManufacturer_M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY, true
	case "M_THERMOKON_SENSORTECHNIK_GMBH":
		return KnxManufacturer_M_THERMOKON_SENSORTECHNIK_GMBH, true
	case "M_BELIMO_AUTOMATION_AG":
		return KnxManufacturer_M_BELIMO_AUTOMATION_AG, true
	case "M_ZEHNDER_GROUP_INTERNATIONAL_AG":
		return KnxManufacturer_M_ZEHNDER_GROUP_INTERNATIONAL_AG, true
	case "M_SKS_KINKEL_ELEKTRONIK":
		return KnxManufacturer_M_SKS_KINKEL_ELEKTRONIK, true
	case "M_ECE_WURMITZER_GMBH":
		return KnxManufacturer_M_ECE_WURMITZER_GMBH, true
	case "M_LARS":
		return KnxManufacturer_M_LARS, true
	case "M_ALBRECHT_JUNG":
		return KnxManufacturer_M_ALBRECHT_JUNG, true
	case "M_ELTAKO":
		return KnxManufacturer_M_ELTAKO, true
	case "M_URC":
		return KnxManufacturer_M_URC, true
	case "M_LIGHTCONTROL":
		return KnxManufacturer_M_LIGHTCONTROL, true
	case "M_SHENZHEN_YM":
		return KnxManufacturer_M_SHENZHEN_YM, true
	case "M_MEAN_WELL_ENTERPRISES_CO__LTD_":
		return KnxManufacturer_M_MEAN_WELL_ENTERPRISES_CO__LTD_, true
	case "M_OSIX":
		return KnxManufacturer_M_OSIX, true
	case "M_AYPRO_TECHNOLOGY":
		return KnxManufacturer_M_AYPRO_TECHNOLOGY, true
	case "M_HEFEI_ECOLITE_SOFTWARE":
		return KnxManufacturer_M_HEFEI_ECOLITE_SOFTWARE, true
	case "M_ENNO":
		return KnxManufacturer_M_ENNO, true
	case "M_OHOSURE":
		return KnxManufacturer_M_OHOSURE, true
	case "M_GAREFOWL":
		return KnxManufacturer_M_GAREFOWL, true
	case "M_BOSCH_SIEMENS_HAUSHALTSGERAETE":
		return KnxManufacturer_M_BOSCH_SIEMENS_HAUSHALTSGERAETE, true
	case "M_GEZE":
		return KnxManufacturer_M_GEZE, true
	case "M_LG_ELECTRONICS_INC_":
		return KnxManufacturer_M_LG_ELECTRONICS_INC_, true
	case "M_SMC_INTERIORS":
		return KnxManufacturer_M_SMC_INTERIORS, true
	case "M_NOT_ASSIGNED_364":
		return KnxManufacturer_M_NOT_ASSIGNED_364, true
	case "M_SCS_CABLE":
		return KnxManufacturer_M_SCS_CABLE, true
	case "M_HOVAL":
		return KnxManufacturer_M_HOVAL, true
	case "M_CANST":
		return KnxManufacturer_M_CANST, true
	case "M_HANGZHOU_BERLIN":
		return KnxManufacturer_M_HANGZHOU_BERLIN, true
	case "M_EVN_LICHTTECHNIK":
		return KnxManufacturer_M_EVN_LICHTTECHNIK, true
	case "M_RUTEC":
		return KnxManufacturer_M_RUTEC, true
	case "M_RITTO_GMBHANDCO_KG":
		return KnxManufacturer_M_RITTO_GMBHANDCO_KG, true
	case "M_FINDER":
		return KnxManufacturer_M_FINDER, true
	case "M_FUJITSU_GENERAL_LIMITED":
		return KnxManufacturer_M_FUJITSU_GENERAL_LIMITED, true
	case "M_ZF_FRIEDRICHSHAFEN_AG":
		return KnxManufacturer_M_ZF_FRIEDRICHSHAFEN_AG, true
	case "M_CREALED":
		return KnxManufacturer_M_CREALED, true
	case "M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED":
		return KnxManufacturer_M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED, true
	case "M_EPlus":
		return KnxManufacturer_M_EPlus, true
	case "M_ITALCOND":
		return KnxManufacturer_M_ITALCOND, true
	case "M_SATION":
		return KnxManufacturer_M_SATION, true
	case "M_NEWBEST":
		return KnxManufacturer_M_NEWBEST, true
	case "M_GDS_DIGITAL_SYSTEMS":
		return KnxManufacturer_M_GDS_DIGITAL_SYSTEMS, true
	case "M_POWER_CONTROLS":
		return KnxManufacturer_M_POWER_CONTROLS, true
	case "M_IDDERO":
		return KnxManufacturer_M_IDDERO, true
	case "M_MBNLED":
		return KnxManufacturer_M_MBNLED, true
	case "M_VITRUM":
		return KnxManufacturer_M_VITRUM, true
	case "M_EKEY_BIOMETRIC_SYSTEMS_GMBH":
		return KnxManufacturer_M_EKEY_BIOMETRIC_SYSTEMS_GMBH, true
	case "M_AMC":
		return KnxManufacturer_M_AMC, true
	case "M_TRILUX_GMBH_AND_CO__KG":
		return KnxManufacturer_M_TRILUX_GMBH_AND_CO__KG, true
	case "M_WEXCEDO":
		return KnxManufacturer_M_WEXCEDO, true
	case "M_VEMER_SPA":
		return KnxManufacturer_M_VEMER_SPA, true
	case "M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG":
		return KnxManufacturer_M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG, true
	case "M_CITRON":
		return KnxManufacturer_M_CITRON, true
	case "M_ZUMTOBEL":
		return KnxManufacturer_M_ZUMTOBEL, true
	case "M_SHENZHEN_HEGUANG":
		return KnxManufacturer_M_SHENZHEN_HEGUANG, true
	case "M_NOT_ASSIGNED_392":
		return KnxManufacturer_M_NOT_ASSIGNED_392, true
	case "M_TRANE_B_V_B_A":
		return KnxManufacturer_M_TRANE_B_V_B_A, true
	case "M_CAREL":
		return KnxManufacturer_M_CAREL, true
	case "M_PROLITE_CONTROLS":
		return KnxManufacturer_M_PROLITE_CONTROLS, true
	case "M_BOSMER":
		return KnxManufacturer_M_BOSMER, true
	case "M_EUCHIPS":
		return KnxManufacturer_M_EUCHIPS, true
	case "M_CONNECT_THINKA_CONNECT":
		return KnxManufacturer_M_CONNECT_THINKA_CONNECT, true
	case "M_PEAKNX_A_DOGAWIST_COMPANY":
		return KnxManufacturer_M_PEAKNX_A_DOGAWIST_COMPANY, true
	case "M_ACEMATIC":
		return KnxManufacturer_M_ACEMATIC, true
	case "M_HOLEC_SYSTEMEN":
		return KnxManufacturer_M_HOLEC_SYSTEMEN, true
	case "M_ELAUSYS":
		return KnxManufacturer_M_ELAUSYS, true
	case "M_ITK_ENGINEERING_AG":
		return KnxManufacturer_M_ITK_ENGINEERING_AG, true
	case "M_INTEGRA_METERING_AG":
		return KnxManufacturer_M_INTEGRA_METERING_AG, true
	case "M_FMS_HOSPITALITY_PTE_LTD":
		return KnxManufacturer_M_FMS_HOSPITALITY_PTE_LTD, true
	case "M_NUVO":
		return KnxManufacturer_M_NUVO, true
	case "M_U__LUX_GMBH":
		return KnxManufacturer_M_U__LUX_GMBH, true
	case "M_BRUMBERG_LEUCHTEN":
		return KnxManufacturer_M_BRUMBERG_LEUCHTEN, true
	case "M_LIME":
		return KnxManufacturer_M_LIME, true
	case "M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_":
		return KnxManufacturer_M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_, true
	case "M_KAVOSHPISHRO_ASIA":
		return KnxManufacturer_M_KAVOSHPISHRO_ASIA, true
	case "M_PHOENIX_CONTACT":
		return KnxManufacturer_M_PHOENIX_CONTACT, true
	case "M_V2_SPA":
		return KnxManufacturer_M_V2_SPA, true
	case "M_JOHNSON_CONTROLS":
		return KnxManufacturer_M_JOHNSON_CONTROLS, true
	case "M_ARKUD":
		return KnxManufacturer_M_ARKUD, true
	case "M_IRIDI_LTD_":
		return KnxManufacturer_M_IRIDI_LTD_, true
	case "M_BSMART":
		return KnxManufacturer_M_BSMART, true
	case "M_BAB_TECHNOLOGIE_GMBH":
		return KnxManufacturer_M_BAB_TECHNOLOGIE_GMBH, true
	case "M_NICE_SPA":
		return KnxManufacturer_M_NICE_SPA, true
	case "M_REDFISH_GROUP_PTY_LTD":
		return KnxManufacturer_M_REDFISH_GROUP_PTY_LTD, true
	case "M_SABIANA_SPA":
		return KnxManufacturer_M_SABIANA_SPA, true
	case "M_UBEE_INTERACTIVE_EUROPE":
		return KnxManufacturer_M_UBEE_INTERACTIVE_EUROPE, true
	case "M_WAGO_GMBH_AND_CO_KG":
		return KnxManufacturer_M_WAGO_GMBH_AND_CO_KG, true
	case "M_REXEL":
		return KnxManufacturer_M_REXEL, true
	case "M_GES_TEKNIK_A_S_":
		return KnxManufacturer_M_GES_TEKNIK_A_S_, true
	case "M_AVE_S_P_A_":
		return KnxManufacturer_M_AVE_S_P_A_, true
	case "M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_, true
	case "M_ARCOM":
		return KnxManufacturer_M_ARCOM, true
	case "M_VIA_TECHNOLOGIES__INC_":
		return KnxManufacturer_M_VIA_TECHNOLOGIES__INC_, true
	case "M_FEELSMART_":
		return KnxManufacturer_M_FEELSMART_, true
	case "M_SUPCON":
		return KnxManufacturer_M_SUPCON, true
	case "M_MANIC":
		return KnxManufacturer_M_MANIC, true
	case "M_TDE_GMBH":
		return KnxManufacturer_M_TDE_GMBH, true
	case "M_KNXPRESSO":
		return KnxManufacturer_M_KNXPRESSO, true
	case "M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_, true
	case "M_EWTECH":
		return KnxManufacturer_M_EWTECH, true
	case "M_KLUGER_AUTOMATION_GMBH":
		return KnxManufacturer_M_KLUGER_AUTOMATION_GMBH, true
	case "M_JOONGANG_CONTROL":
		return KnxManufacturer_M_JOONGANG_CONTROL, true
	case "M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_":
		return KnxManufacturer_M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_, true
	case "M_IME_S_P_A_":
		return KnxManufacturer_M_IME_S_P_A_, true
	case "M_SICHUAN_HAODING":
		return KnxManufacturer_M_SICHUAN_HAODING, true
	case "M_MINDJAGA_LTD_":
		return KnxManufacturer_M_MINDJAGA_LTD_, true
	case "M_RUILI_SMART_CONTROL":
		return KnxManufacturer_M_RUILI_SMART_CONTROL, true
	case "M_CODESYS_GMBH":
		return KnxManufacturer_M_CODESYS_GMBH, true
	case "M_WIELAND_ELECTRIC":
		return KnxManufacturer_M_WIELAND_ELECTRIC, true
	case "M_MOORGEN_DEUTSCHLAND_GMBH":
		return KnxManufacturer_M_MOORGEN_DEUTSCHLAND_GMBH, true
	case "M_CULLMANN_TECH":
		return KnxManufacturer_M_CULLMANN_TECH, true
	case "M_EYRISE_B_V":
		return KnxManufacturer_M_EYRISE_B_V, true
	case "M_DOBNEL":
		return KnxManufacturer_M_DOBNEL, true
	case "M_MYGEKKO":
		return KnxManufacturer_M_MYGEKKO, true
	case "M_ERGO3_SARL":
		return KnxManufacturer_M_ERGO3_SARL, true
	case "M_STMICROELECTRONICS_INTERNATIONAL_N_V_":
		return KnxManufacturer_M_STMICROELECTRONICS_INTERNATIONAL_N_V_, true
	case "M_CJC_SYSTEMS":
		return KnxManufacturer_M_CJC_SYSTEMS, true
	case "M_SUDOKU":
		return KnxManufacturer_M_SUDOKU, true
	case "M_AZ_E_LITE_PTE_LTD":
		return KnxManufacturer_M_AZ_E_LITE_PTE_LTD, true
	case "M_BTICINO":
		return KnxManufacturer_M_BTICINO, true
	case "M_HERMANN_KLEINHUIS":
		return KnxManufacturer_M_HERMANN_KLEINHUIS, true
	case "M_ARLIGHT":
		return KnxManufacturer_M_ARLIGHT, true
	case "M_GRUENBECK_WASSERAUFBEREITUNG_GMBH":
		return KnxManufacturer_M_GRUENBECK_WASSERAUFBEREITUNG_GMBH, true
	case "M_MODULE_ELECTRONIC":
		return KnxManufacturer_M_MODULE_ELECTRONIC, true
	case "M_KOPLAT":
		return KnxManufacturer_M_KOPLAT, true
	case "M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD, true
	case "M_ILEVIA":
		return KnxManufacturer_M_ILEVIA, true
	case "M_LN_SYSTEMTEQ":
		return KnxManufacturer_M_LN_SYSTEMTEQ, true
	case "M_HISENSE_SMARTHOME":
		return KnxManufacturer_M_HISENSE_SMARTHOME, true
	case "M_FLINK_AUTOMATION_SYSTEM":
		return KnxManufacturer_M_FLINK_AUTOMATION_SYSTEM, true
	case "M_XXTER_BV":
		return KnxManufacturer_M_XXTER_BV, true
	case "M_STIEBEL_ELTRON":
		return KnxManufacturer_M_STIEBEL_ELTRON, true
	case "M_LYNXUS_TECHNOLOGY":
		return KnxManufacturer_M_LYNXUS_TECHNOLOGY, true
	case "M_ROBOT_S_A_":
		return KnxManufacturer_M_ROBOT_S_A_, true
	case "M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_":
		return KnxManufacturer_M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_, true
	case "M_NOBLESSE":
		return KnxManufacturer_M_NOBLESSE, true
	case "M_ADVANCED_DEVICES":
		return KnxManufacturer_M_ADVANCED_DEVICES, true
	case "M_ATRINA_BUILDING_AUTOMATION_CO__LTD":
		return KnxManufacturer_M_ATRINA_BUILDING_AUTOMATION_CO__LTD, true
	case "M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_":
		return KnxManufacturer_M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_, true
	case "M_WESTERSTRAND_URFABRIK_AB":
		return KnxManufacturer_M_WESTERSTRAND_URFABRIK_AB, true
	case "M_CONTROL4_CORPORATE":
		return KnxManufacturer_M_CONTROL4_CORPORATE, true
	case "M_ONTROL":
		return KnxManufacturer_M_ONTROL, true
	case "M_TEHALIT":
		return KnxManufacturer_M_TEHALIT, true
	case "M_STARNET":
		return KnxManufacturer_M_STARNET, true
	case "M_BETA_CAVI":
		return KnxManufacturer_M_BETA_CAVI, true
	case "M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_, true
	case "M_VIVALDI_SRL":
		return KnxManufacturer_M_VIVALDI_SRL, true
	case "M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI":
		return KnxManufacturer_M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI, true
	case "M_HWISCON":
		return KnxManufacturer_M_HWISCON, true
	case "M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_, true
	case "M_KAMPMANN":
		return KnxManufacturer_M_KAMPMANN, true
	case "M_IMPOLUX_GMBH_LEDIMAX":
		return KnxManufacturer_M_IMPOLUX_GMBH_LEDIMAX, true
	case "M_EVAUX":
		return KnxManufacturer_M_EVAUX, true
	case "M_THEBEN_AG":
		return KnxManufacturer_M_THEBEN_AG, true
	case "M_WEBRO_CABLES_AND_CONNECTORS_LIMITED":
		return KnxManufacturer_M_WEBRO_CABLES_AND_CONNECTORS_LIMITED, true
	case "M_SHANGHAI_E_TECH_SOLUTION":
		return KnxManufacturer_M_SHANGHAI_E_TECH_SOLUTION, true
	case "M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_":
		return KnxManufacturer_M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_, true
	case "M_LAMMIN_HIGH_TECH_CO__LTD":
		return KnxManufacturer_M_LAMMIN_HIGH_TECH_CO__LTD, true
	case "M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD, true
	case "M_I_LUXUS":
		return KnxManufacturer_M_I_LUXUS, true
	case "M_ELMOS_SEMICONDUCTOR_AG":
		return KnxManufacturer_M_ELMOS_SEMICONDUCTOR_AG, true
	case "M_EMCOM_TECHNOLOGY_INC":
		return KnxManufacturer_M_EMCOM_TECHNOLOGY_INC, true
	case "M_PROJECT_INNOVATIONS_GMBH":
		return KnxManufacturer_M_PROJECT_INNOVATIONS_GMBH, true
	case "M_ITC":
		return KnxManufacturer_M_ITC, true
	case "M_WILHELM_RUTENBECK":
		return KnxManufacturer_M_WILHELM_RUTENBECK, true
	case "M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING":
		return KnxManufacturer_M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING, true
	case "M_MAICO":
		return KnxManufacturer_M_MAICO, true
	case "M_ELAN_SRL":
		return KnxManufacturer_M_ELAN_SRL, true
	case "M_MINHHA_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_MINHHA_TECHNOLOGY_CO__LTD, true
	case "M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_":
		return KnxManufacturer_M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_, true
	case "M_IAUTOMATION_PTY_LIMITED":
		return KnxManufacturer_M_IAUTOMATION_PTY_LIMITED, true
	case "M_EXTRON":
		return KnxManufacturer_M_EXTRON, true
	case "M_FREEDOMPRO":
		return KnxManufacturer_M_FREEDOMPRO, true
	case "M_ONEHOME":
		return KnxManufacturer_M_ONEHOME, true
	case "M_EOS_SAUNATECHNIK_GMBH":
		return KnxManufacturer_M_EOS_SAUNATECHNIK_GMBH, true
	case "M_WINKHAUS":
		return KnxManufacturer_M_WINKHAUS, true
	case "M_KUSATEK_GMBH":
		return KnxManufacturer_M_KUSATEK_GMBH, true
	case "M_ALEXANDER_MAIER_GMBH":
		return KnxManufacturer_M_ALEXANDER_MAIER_GMBH, true
	case "M_AUTOMATISMI_BENINCA_S_P_A_":
		return KnxManufacturer_M_AUTOMATISMI_BENINCA_S_P_A_, true
	case "M_BLENDOM":
		return KnxManufacturer_M_BLENDOM, true
	case "M_MADEL_AIR_TECHNICAL_DIFFUSION":
		return KnxManufacturer_M_MADEL_AIR_TECHNICAL_DIFFUSION, true
	case "M_NIKO":
		return KnxManufacturer_M_NIKO, true
	case "M_BOSCH_REXROTH_AG":
		return KnxManufacturer_M_BOSCH_REXROTH_AG, true
	case "M_CANDM_PRODUCTS":
		return KnxManufacturer_M_CANDM_PRODUCTS, true
	case "M_HOERMANN_KG_VERKAUFSGESELLSCHAFT":
		return KnxManufacturer_M_HOERMANN_KG_VERKAUFSGESELLSCHAFT, true
	case "M_SHANGHAI_RAJAYASA_CO__LTD":
		return KnxManufacturer_M_SHANGHAI_RAJAYASA_CO__LTD, true
	case "M_ROBERT_BOSCH":
		return KnxManufacturer_M_ROBERT_BOSCH, true
	case "M_SUZUKI":
		return KnxManufacturer_M_SUZUKI, true
	case "M_SILENT_GLISS_INTERNATIONAL_LTD_":
		return KnxManufacturer_M_SILENT_GLISS_INTERNATIONAL_LTD_, true
	case "M_BEE_CONTROLS_ADGSC_GROUP":
		return KnxManufacturer_M_BEE_CONTROLS_ADGSC_GROUP, true
	case "M_XDTECGMBH":
		return KnxManufacturer_M_XDTECGMBH, true
	case "M_OSRAM":
		return KnxManufacturer_M_OSRAM, true
	case "M_LEBENOR":
		return KnxManufacturer_M_LEBENOR, true
	case "M_AUTOMANENG":
		return KnxManufacturer_M_AUTOMANENG, true
	case "M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD":
		return KnxManufacturer_M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD, true
	case "M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD, true
	case "M_ETA_HEIZTECHNIK":
		return KnxManufacturer_M_ETA_HEIZTECHNIK, true
	case "M_SOMFY":
		return KnxManufacturer_M_SOMFY, true
	case "M_DIVUS_GMBH":
		return KnxManufacturer_M_DIVUS_GMBH, true
	case "M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_, true
	case "M_LUNATONE":
		return KnxManufacturer_M_LUNATONE, true
	case "M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT":
		return KnxManufacturer_M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT, true
	case "M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_, true
	case "M_NOKE":
		return KnxManufacturer_M_NOKE, true
	case "M_LANDCOM":
		return KnxManufacturer_M_LANDCOM, true
	case "M_STORK_AS":
		return KnxManufacturer_M_STORK_AS, true
	case "M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_, true
	case "M_COOLAUTOMATION":
		return KnxManufacturer_M_COOLAUTOMATION, true
	case "M_WOERTZ":
		return KnxManufacturer_M_WOERTZ, true
	case "M_APRSTERN":
		return KnxManufacturer_M_APRSTERN, true
	case "M_SONNEN":
		return KnxManufacturer_M_SONNEN, true
	case "M_DNAKE":
		return KnxManufacturer_M_DNAKE, true
	case "M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH":
		return KnxManufacturer_M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH, true
	case "M_STILIGER":
		return KnxManufacturer_M_STILIGER, true
	case "M_BERGHOF_AUTOMATION_GMBH":
		return KnxManufacturer_M_BERGHOF_AUTOMATION_GMBH, true
	case "M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH":
		return KnxManufacturer_M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH, true
	case "M_DOVIT":
		return KnxManufacturer_M_DOVIT, true
	case "M_INSTALIGHTING_GMBH":
		return KnxManufacturer_M_INSTALIGHTING_GMBH, true
	case "M_UNI_TEC":
		return KnxManufacturer_M_UNI_TEC, true
	case "M_VIESSMANN_WERKE":
		return KnxManufacturer_M_VIESSMANN_WERKE, true
	case "M_CASATUNES":
		return KnxManufacturer_M_CASATUNES, true
	case "M_EMT":
		return KnxManufacturer_M_EMT, true
	case "M_SENFFICIENT":
		return KnxManufacturer_M_SENFFICIENT, true
	case "M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED":
		return KnxManufacturer_M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED, true
	case "M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_, true
	case "M_SAMSON_ELECTRIC_WIRE":
		return KnxManufacturer_M_SAMSON_ELECTRIC_WIRE, true
	case "M_T_TOUCHING":
		return KnxManufacturer_M_T_TOUCHING, true
	case "M_CORE_SMART_HOME":
		return KnxManufacturer_M_CORE_SMART_HOME, true
	case "M_GREENCONNECT_SOLUTIONS_SA":
		return KnxManufacturer_M_GREENCONNECT_SOLUTIONS_SA, true
	case "M_ELETTRONICA_CONDUTTORI":
		return KnxManufacturer_M_ELETTRONICA_CONDUTTORI, true
	case "M_BERKER":
		return KnxManufacturer_M_BERKER, true
	case "M_IMI_HYDRONIC_ENGINEERING":
		return KnxManufacturer_M_IMI_HYDRONIC_ENGINEERING, true
	case "M_MKFC":
		return KnxManufacturer_M_MKFC, true
	case "M_AUTOMATIONPlus":
		return KnxManufacturer_M_AUTOMATIONPlus, true
	case "M_BLUE_AND_RED":
		return KnxManufacturer_M_BLUE_AND_RED, true
	case "M_FROGBLUE":
		return KnxManufacturer_M_FROGBLUE, true
	case "M_LUXIO":
		return KnxManufacturer_M_LUXIO, true
	case "M_APP_TECH":
		return KnxManufacturer_M_APP_TECH, true
	case "M_SENSORTEC_AG":
		return KnxManufacturer_M_SENSORTEC_AG, true
	case "M_NYSA_TECHNOLOGY_AND_SOLUTIONS":
		return KnxManufacturer_M_NYSA_TECHNOLOGY_AND_SOLUTIONS, true
	case "M_FARADITE":
		return KnxManufacturer_M_FARADITE, true
	case "M_OPTIMUS":
		return KnxManufacturer_M_OPTIMUS, true
	case "M_JOH__VAILLANT":
		return KnxManufacturer_M_JOH__VAILLANT, true
	case "M_KTS_S_R_L_":
		return KnxManufacturer_M_KTS_S_R_L_, true
	case "M_RAMCRO_SPA":
		return KnxManufacturer_M_RAMCRO_SPA, true
	case "M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD, true
	case "M_BEMI_SMART_HOME_LTD":
		return KnxManufacturer_M_BEMI_SMART_HOME_LTD, true
	case "M_ARDOMUS":
		return KnxManufacturer_M_ARDOMUS, true
	case "M_CHANGXING":
		return KnxManufacturer_M_CHANGXING, true
	case "M_E_CONTROLS":
		return KnxManufacturer_M_E_CONTROLS, true
	case "M_AIB_TECHNOLOGY":
		return KnxManufacturer_M_AIB_TECHNOLOGY, true
	case "M_NVC":
		return KnxManufacturer_M_NVC, true
	case "M_KBOX":
		return KnxManufacturer_M_KBOX, true
	case "M_AMP_DEUTSCHLAND":
		return KnxManufacturer_M_AMP_DEUTSCHLAND, true
	case "M_CNS":
		return KnxManufacturer_M_CNS, true
	case "M_TYBA":
		return KnxManufacturer_M_TYBA, true
	case "M_ATREL":
		return KnxManufacturer_M_ATREL, true
	case "M_SIMON_ELECTRIC_CHINA_CO___LTD":
		return KnxManufacturer_M_SIMON_ELECTRIC_CHINA_CO___LTD, true
	case "M_KORDZ_GROUP":
		return KnxManufacturer_M_KORDZ_GROUP, true
	case "M_ND_ELECTRIC":
		return KnxManufacturer_M_ND_ELECTRIC, true
	case "M_CONTROLIUM":
		return KnxManufacturer_M_CONTROLIUM, true
	case "M_FAMO_GMBH_AND_CO__KG":
		return KnxManufacturer_M_FAMO_GMBH_AND_CO__KG, true
	case "M_CDN_SMART":
		return KnxManufacturer_M_CDN_SMART, true
	case "M_HESTON":
		return KnxManufacturer_M_HESTON, true
	case "M_BOSCH_THERMOTECHNIK_GMBH":
		return KnxManufacturer_M_BOSCH_THERMOTECHNIK_GMBH, true
	case "M_ESLA_CONEXIONES_S_L_":
		return KnxManufacturer_M_ESLA_CONEXIONES_S_L_, true
	case "M_WEISHAUPT":
		return KnxManufacturer_M_WEISHAUPT, true
	case "M_ASTRUM_TECHNOLOGY":
		return KnxManufacturer_M_ASTRUM_TECHNOLOGY, true
	case "M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_":
		return KnxManufacturer_M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_, true
	case "M_NANOTECO_CORPORATION":
		return KnxManufacturer_M_NANOTECO_CORPORATION, true
	case "M_NIETIAN":
		return KnxManufacturer_M_NIETIAN, true
	case "M_SUMSIR":
		return KnxManufacturer_M_SUMSIR, true
	case "M_ORBIS_TECNOLOGIA_ELECTRICA_SA":
		return KnxManufacturer_M_ORBIS_TECNOLOGIA_ELECTRICA_SA, true
	case "M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_, true
	case "M_ANLIPS":
		return KnxManufacturer_M_ANLIPS, true
	case "M_SEF___ECOTEC":
		return KnxManufacturer_M_SEF___ECOTEC, true
	case "M_GUANGDONG_PAK_CORPORATION_CO___LTD":
		return KnxManufacturer_M_GUANGDONG_PAK_CORPORATION_CO___LTD, true
	case "M_BVK_TECHNOLOGY":
		return KnxManufacturer_M_BVK_TECHNOLOGY, true
	case "M_SOLOMIO_SRL":
		return KnxManufacturer_M_SOLOMIO_SRL, true
	case "M_DOMOTICA_LABS":
		return KnxManufacturer_M_DOMOTICA_LABS, true
	case "M_NVC_INTERNATIONAL":
		return KnxManufacturer_M_NVC_INTERNATIONAL, true
	case "M_BA":
		return KnxManufacturer_M_BA, true
	case "M_IRIS_CERAMICA_GROUP":
		return KnxManufacturer_M_IRIS_CERAMICA_GROUP, true
	case "M_WIREEO":
		return KnxManufacturer_M_WIREEO, true
	case "M_NVCLIGHTING":
		return KnxManufacturer_M_NVCLIGHTING, true
	case "M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_":
		return KnxManufacturer_M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_, true
	case "M_DORMA_GMBH_Plus_CO__KG":
		return KnxManufacturer_M_DORMA_GMBH_Plus_CO__KG, true
	case "M_ARMITI_TRADING":
		return KnxManufacturer_M_ARMITI_TRADING, true
	case "M_ELEK":
		return KnxManufacturer_M_ELEK, true
	case "M_ACCORDIA_SA":
		return KnxManufacturer_M_ACCORDIA_SA, true
	case "M_OURICAN":
		return KnxManufacturer_M_OURICAN, true
	case "M_INLIWOSE":
		return KnxManufacturer_M_INLIWOSE, true
	case "M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_":
		return KnxManufacturer_M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_, true
	case "M_SHK_KNX":
		return KnxManufacturer_M_SHK_KNX, true
	case "M_AMPIO":
		return KnxManufacturer_M_AMPIO, true
	case "M_MINGXING_WISDOM":
		return KnxManufacturer_M_MINGXING_WISDOM, true
	case "M_ALTEN_SW_GMBH":
		return KnxManufacturer_M_ALTEN_SW_GMBH, true
	case "M_WINDOWMASTER_AS":
		return KnxManufacturer_M_WINDOWMASTER_AS, true
	case "M_V_Y_C_SRL":
		return KnxManufacturer_M_V_Y_C_SRL, true
	case "M_TERMINUS_GROUP":
		return KnxManufacturer_M_TERMINUS_GROUP, true
	case "M_WONDERFUL_CITY_TECHNOLOGY":
		return KnxManufacturer_M_WONDERFUL_CITY_TECHNOLOGY, true
	case "M_QBICTECHNOLOGY":
		return KnxManufacturer_M_QBICTECHNOLOGY, true
	case "M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED":
		return KnxManufacturer_M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED, true
	case "M_ONEWORK":
		return KnxManufacturer_M_ONEWORK, true
	case "M_PL_LINK":
		return KnxManufacturer_M_PL_LINK, true
	case "M_FASEL_GMBH_ELEKTRONIK":
		return KnxManufacturer_M_FASEL_GMBH_ELEKTRONIK, true
	case "M_GOLDENHOME_SMART":
		return KnxManufacturer_M_GOLDENHOME_SMART, true
	case "M_GOLDMEDAL":
		return KnxManufacturer_M_GOLDMEDAL, true
	case "M_WALTHER_WERKE":
		return KnxManufacturer_M_WALTHER_WERKE, true
	case "M_CannX":
		return KnxManufacturer_M_CannX, true
	case "M_EGI___EARTH_GOODNESS":
		return KnxManufacturer_M_EGI___EARTH_GOODNESS, true
	case "M_VIEGA_GMBH_AND_CO__KG":
		return KnxManufacturer_M_VIEGA_GMBH_AND_CO__KG, true
	case "M_FREDON_DIGITAL_BUILDINGS":
		return KnxManufacturer_M_FREDON_DIGITAL_BUILDINGS, true
	case "M_HELUKABEL_THAILAND_CO__LTD_":
		return KnxManufacturer_M_HELUKABEL_THAILAND_CO__LTD_, true
	case "M_SICS":
		return KnxManufacturer_M_SICS, true
	case "M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD":
		return KnxManufacturer_M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD, true
	case "M_SUMAMO":
		return KnxManufacturer_M_SUMAMO, true
	case "M_SVIT":
		return KnxManufacturer_M_SVIT, true
	case "M_TECGET":
		return KnxManufacturer_M_TECGET, true
	case "M_ORAS":
		return KnxManufacturer_M_ORAS, true
	case "M_XEROPOINT":
		return KnxManufacturer_M_XEROPOINT, true
	case "M_HONEYWELL_BUILDING_TECHNOLOGIES":
		return KnxManufacturer_M_HONEYWELL_BUILDING_TECHNOLOGIES, true
	case "M_COMFORTCLICK":
		return KnxManufacturer_M_COMFORTCLICK, true
	case "M_DORBAS_ELECTRIC":
		return KnxManufacturer_M_DORBAS_ELECTRIC, true
	case "M_REMKO_GMBH_AND_CO__KG":
		return KnxManufacturer_M_REMKO_GMBH_AND_CO__KG, true
	case "M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD, true
	case "M_ANDAS":
		return KnxManufacturer_M_ANDAS, true
	case "M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD, true
	case "M_LARFE":
		return KnxManufacturer_M_LARFE, true
	case "M_DONGGUAN_MUHCCI_ELECTRICAL":
		return KnxManufacturer_M_DONGGUAN_MUHCCI_ELECTRICAL, true
	case "M_DAETWYLER":
		return KnxManufacturer_M_DAETWYLER, true
	case "M_STEC":
		return KnxManufacturer_M_STEC, true
	case "M_ARIGO_SOFTWARE_GMBH":
		return KnxManufacturer_M_ARIGO_SOFTWARE_GMBH, true
	case "M_FEISHELEC":
		return KnxManufacturer_M_FEISHELEC, true
	case "M_GORDIC":
		return KnxManufacturer_M_GORDIC, true
	case "M_DELTA_ELECTRONICS":
		return KnxManufacturer_M_DELTA_ELECTRONICS, true
	case "M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_, true
	case "M_KG_POWER":
		return KnxManufacturer_M_KG_POWER, true
	case "M_ZHEJIANG_MOORGEN_GROUP_CO__LTD":
		return KnxManufacturer_M_ZHEJIANG_MOORGEN_GROUP_CO__LTD, true
	case "M_GUANGDONG_KANWAY":
		return KnxManufacturer_M_GUANGDONG_KANWAY, true
	case "M_RAMIREZ_ENGINEERING_GMBH":
		return KnxManufacturer_M_RAMIREZ_ENGINEERING_GMBH, true
	case "M_BUSCH_JAEGER_ELEKTRO":
		return KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO, true
	case "M_ELECTRAK":
		return KnxManufacturer_M_ELECTRAK, true
	case "M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD":
		return KnxManufacturer_M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD, true
	case "M_VIHAN_ELECTRIC_PVT_LTD":
		return KnxManufacturer_M_VIHAN_ELECTRIC_PVT_LTD, true
	case "M_SPLENDID_MINDS_GMBH":
		return KnxManufacturer_M_SPLENDID_MINDS_GMBH, true
	case "M_ESTADA":
		return KnxManufacturer_M_ESTADA, true
	case "M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI":
		return KnxManufacturer_M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI, true
	case "M_STUHL_REGELSYSTEME_GMBH":
		return KnxManufacturer_M_STUHL_REGELSYSTEME_GMBH, true
	case "M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD, true
	case "M_GAIMEX":
		return KnxManufacturer_M_GAIMEX, true
	case "M_B3_INTERNATIONAL_S_R_L":
		return KnxManufacturer_M_B3_INTERNATIONAL_S_R_L, true
	case "M_MM_ELECTRO":
		return KnxManufacturer_M_MM_ELECTRO, true
	case "M_TECHEM":
		return KnxManufacturer_M_TECHEM, true
	case "M_CASCODA":
		return KnxManufacturer_M_CASCODA, true
	case "M_XIAMEN_INTRETECH_INC_":
		return KnxManufacturer_M_XIAMEN_INTRETECH_INC_, true
	case "M_KILOELEC_TECHNOLOGY":
		return KnxManufacturer_M_KILOELEC_TECHNOLOGY, true
	case "M_INYX":
		return KnxManufacturer_M_INYX, true
	case "M_SMART_BUILDING_SERVICES_GMBH":
		return KnxManufacturer_M_SMART_BUILDING_SERVICES_GMBH, true
	case "M_BSS_GMBH":
		return KnxManufacturer_M_BSS_GMBH, true
	case "M_LUMI_ELECTRONICS":
		return KnxManufacturer_M_LUMI_ELECTRONICS, true
	case "M_OJEAELECTRONICS":
		return KnxManufacturer_M_OJEAELECTRONICS, true
	case "M_SMART_NODE":
		return KnxManufacturer_M_SMART_NODE, true
	case "M_NEXHOME":
		return KnxManufacturer_M_NEXHOME, true
	case "M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS":
		return KnxManufacturer_M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS, true
	case "M_HUOTENG_WULIAN_JIANGSU_CO___LTD":
		return KnxManufacturer_M_HUOTENG_WULIAN_JIANGSU_CO___LTD, true
	case "M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD":
		return KnxManufacturer_M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD, true
	case "M_BITS_AND_BYTES":
		return KnxManufacturer_M_BITS_AND_BYTES, true
	case "M_KFV_SIEGENIA_GRUPPE":
		return KnxManufacturer_M_KFV_SIEGENIA_GRUPPE, true
	case "M_SYMCON":
		return KnxManufacturer_M_SYMCON, true
	case "M_I_TRUST":
		return KnxManufacturer_M_I_TRUST, true
	case "M_DRD_TECHNICS":
		return KnxManufacturer_M_DRD_TECHNICS, true
	case "M_LENGEN":
		return KnxManufacturer_M_LENGEN, true
	case "M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD, true
	case "M_VIBROXX_FZCO":
		return KnxManufacturer_M_VIBROXX_FZCO, true
	case "M_WHD_WILHELM_HUBER_Plus_SOEHNE":
		return KnxManufacturer_M_WHD_WILHELM_HUBER_Plus_SOEHNE, true
	case "M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD":
		return KnxManufacturer_M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD, true
	case "M_PASSIV_ENERGIE_GMBH":
		return KnxManufacturer_M_PASSIV_ENERGIE_GMBH, true
	case "M_PAYNE_TECHNOLOGIES_LTD":
		return KnxManufacturer_M_PAYNE_TECHNOLOGIES_LTD, true
	case "M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_, true
	case "M_SEXANKA":
		return KnxManufacturer_M_SEXANKA, true
	case "M_SECURI_FLEX_LTD":
		return KnxManufacturer_M_SECURI_FLEX_LTD, true
	case "M_BOKE":
		return KnxManufacturer_M_BOKE, true
	case "M_SBR_SYSTEM_TECHNICAL":
		return KnxManufacturer_M_SBR_SYSTEM_TECHNICAL, true
	case "M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_, true
	case "M_BOLATU":
		return KnxManufacturer_M_BOLATU, true
	case "M_BISCHOFF_ELEKTRONIK":
		return KnxManufacturer_M_BISCHOFF_ELEKTRONIK, true
	case "M_RECBER_KABLO_A_S_":
		return KnxManufacturer_M_RECBER_KABLO_A_S_, true
	case "M_ILITE_KNX":
		return KnxManufacturer_M_ILITE_KNX, true
	case "M_LAZZEN":
		return KnxManufacturer_M_LAZZEN, true
	case "M_MOX_CONTROL_IT_CHINA_LIMITED":
		return KnxManufacturer_M_MOX_CONTROL_IT_CHINA_LIMITED, true
	case "M_CLOWIRE":
		return KnxManufacturer_M_CLOWIRE, true
	case "M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD":
		return KnxManufacturer_M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD, true
	case "M_NS_TOUCH":
		return KnxManufacturer_M_NS_TOUCH, true
	case "M_ROOMIO":
		return KnxManufacturer_M_ROOMIO, true
	case "M_ATOUCH":
		return KnxManufacturer_M_ATOUCH, true
	case "M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD":
		return KnxManufacturer_M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD, true
	case "M_JEPAZ":
		return KnxManufacturer_M_JEPAZ, true
	case "M_WALLYONS":
		return KnxManufacturer_M_WALLYONS, true
	case "M_ZIMMEX":
		return KnxManufacturer_M_ZIMMEX, true
	case "M_RHOMBUS_EUROPE":
		return KnxManufacturer_M_RHOMBUS_EUROPE, true
	case "M_TURING_THINK":
		return KnxManufacturer_M_TURING_THINK, true
	case "M_MICHOI":
		return KnxManufacturer_M_MICHOI, true
	case "M_CAV_SMARTGUANGZHOUCO__LTD":
		return KnxManufacturer_M_CAV_SMARTGUANGZHOUCO__LTD, true
	case "M_HELKAMA_BICA_OY":
		return KnxManufacturer_M_HELKAMA_BICA_OY, true
	case "M_MODULYTE":
		return KnxManufacturer_M_MODULYTE, true
	case "M_CONSOLINNO_ENERGY_GMBH":
		return KnxManufacturer_M_CONSOLINNO_ENERGY_GMBH, true
	case "M_SCHIDERON_ELECTRIC_ASIA_LIMITED":
		return KnxManufacturer_M_SCHIDERON_ELECTRIC_ASIA_LIMITED, true
	case "M_RTS_AUTOMATION":
		return KnxManufacturer_M_RTS_AUTOMATION, true
	case "M_3R":
		return KnxManufacturer_M_3R, true
	case "M_ARKLYFE":
		return KnxManufacturer_M_ARKLYFE, true
	case "M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_":
		return KnxManufacturer_M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_, true
	case "M_KNXES_COMPANY_LIMITED":
		return KnxManufacturer_M_KNXES_COMPANY_LIMITED, true
	case "M_AKUVOX":
		return KnxManufacturer_M_AKUVOX, true
	case "M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_":
		return KnxManufacturer_M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_, true
	case "M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD, true
	case "M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD":
		return KnxManufacturer_M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD, true
	case "M_MUTLUSAN_ELECTRIC":
		return KnxManufacturer_M_MUTLUSAN_ELECTRIC, true
	case "M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_, true
	case "M_EIBMARKT_GMBH":
		return KnxManufacturer_M_EIBMARKT_GMBH, true
	case "M_MARLEY_DEUTSCHLAND_GMBH":
		return KnxManufacturer_M_MARLEY_DEUTSCHLAND_GMBH, true
	case "M_CREATROL":
		return KnxManufacturer_M_CREATROL, true
	case "M_EUTELSAT":
		return KnxManufacturer_M_EUTELSAT, true
	case "M_TECNIKABEL":
		return KnxManufacturer_M_TECNIKABEL, true
	case "M_ATIOS_AG":
		return KnxManufacturer_M_ATIOS_AG, true
	case "M_SMARTLICHT":
		return KnxManufacturer_M_SMARTLICHT, true
	case "M_BEIJING_BEVONE_ELECTRIC_CO__LTD_":
		return KnxManufacturer_M_BEIJING_BEVONE_ELECTRIC_CO__LTD_, true
	case "M_ELSMART":
		return KnxManufacturer_M_ELSMART, true
	case "M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC":
		return KnxManufacturer_M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC, true
	case "M_HANGZHOU_SANYUAN_CABLE_CO___LTD":
		return KnxManufacturer_M_HANGZHOU_SANYUAN_CABLE_CO___LTD, true
	case "M_WAREMA_RENKHOFF_SE":
		return KnxManufacturer_M_WAREMA_RENKHOFF_SE, true
	case "M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_":
		return KnxManufacturer_M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_, true
	case "M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_, true
	case "M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD, true
	case "M_VITRUM_DESIGN":
		return KnxManufacturer_M_VITRUM_DESIGN, true
	case "M_DETRONS":
		return KnxManufacturer_M_DETRONS, true
	case "M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD, true
	case "M_VARNI_DIGITAL_PRIVATE_LIMITED":
		return KnxManufacturer_M_VARNI_DIGITAL_PRIVATE_LIMITED, true
	case "M_3A_ENTREPRISE_APS":
		return KnxManufacturer_M_3A_ENTREPRISE_APS, true
	case "M_ITALIANA_CONDUTTORI_SRL":
		return KnxManufacturer_M_ITALIANA_CONDUTTORI_SRL, true
	case "M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_":
		return KnxManufacturer_M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_, true
	case "M_EELECTRON":
		return KnxManufacturer_M_EELECTRON, true
	case "M_LEDNX":
		return KnxManufacturer_M_LEDNX, true
	case "M_EBELONG":
		return KnxManufacturer_M_EBELONG, true
	case "M_ASTRA_LED_AG":
		return KnxManufacturer_M_ASTRA_LED_AG, true
	case "M_WONDERFUL_HI_TECH_CO___LTD_":
		return KnxManufacturer_M_WONDERFUL_HI_TECH_CO___LTD_, true
	case "M_REXLITE_AI_INTEGRATIONS_CO__LTD":
		return KnxManufacturer_M_REXLITE_AI_INTEGRATIONS_CO__LTD, true
	case "M_ALLORADO":
		return KnxManufacturer_M_ALLORADO, true
	case "M_FUZHOU_MILI_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_FUZHOU_MILI_TECHNOLOGY_CO___LTD, true
	case "M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD, true
	case "M_HYSINE":
		return KnxManufacturer_M_HYSINE, true
	case "M_SANTAN":
		return KnxManufacturer_M_SANTAN, true
	case "M_GIRA_GIERSIEPEN":
		return KnxManufacturer_M_GIRA_GIERSIEPEN, true
	case "M_BELDEN_WIRE_AND_CABLE_B_V_":
		return KnxManufacturer_M_BELDEN_WIRE_AND_CABLE_B_V_, true
	case "M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD":
		return KnxManufacturer_M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD, true
	case "M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD, true
	case "M_POLAR_BEAR_DESIGN":
		return KnxManufacturer_M_POLAR_BEAR_DESIGN, true
	case "M_ELESSAN_NV":
		return KnxManufacturer_M_ELESSAN_NV, true
	case "M_MIR":
		return KnxManufacturer_M_MIR, true
	case "M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD, true
	case "M_LEAX_CONTROLS_CO___LTD_":
		return KnxManufacturer_M_LEAX_CONTROLS_CO___LTD_, true
	case "M_ALCAD":
		return KnxManufacturer_M_ALCAD, true
	case "M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD, true
	case "M_TAOS_ELECTRIC_CO___LTD":
		return KnxManufacturer_M_TAOS_ELECTRIC_CO___LTD, true
	case "M_BECKER_ANTRIEBE_GMBH":
		return KnxManufacturer_M_BECKER_ANTRIEBE_GMBH, true
	case "M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION":
		return KnxManufacturer_M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION, true
	case "M_ASAY_Q":
		return KnxManufacturer_M_ASAY_Q, true
	case "M_LAPP":
		return KnxManufacturer_M_LAPP, true
	case "M_ZEROBIT_DYNAMIC":
		return KnxManufacturer_M_ZEROBIT_DYNAMIC, true
	case "M_HAVELLS":
		return KnxManufacturer_M_HAVELLS, true
	case "M_MULLER_INTUITIV":
		return KnxManufacturer_M_MULLER_INTUITIV, true
	case "M_TASKIT_GMBH":
		return KnxManufacturer_M_TASKIT_GMBH, true
	case "M_COSTER_GROUP":
		return KnxManufacturer_M_COSTER_GROUP, true
	case "M_NXP_SEMICONDUCTOR":
		return KnxManufacturer_M_NXP_SEMICONDUCTOR, true
	case "M_COGCONS":
		return KnxManufacturer_M_COGCONS, true
	case "M_J_STEHLEPlusSOEHNE_GMBH":
		return KnxManufacturer_M_J_STEHLEPlusSOEHNE_GMBH, true
	case "M_MICRO_TEK_SRL_F_M_C_TRADE_MARK":
		return KnxManufacturer_M_MICRO_TEK_SRL_F_M_C_TRADE_MARK, true
	case "M_ORENDA_ELECTRIC":
		return KnxManufacturer_M_ORENDA_ELECTRIC, true
	case "M_ERSE_KABLO":
		return KnxManufacturer_M_ERSE_KABLO, true
	case "M_PRADO_EUROPE_BV":
		return KnxManufacturer_M_PRADO_EUROPE_BV, true
	case "M_E2S_GBR":
		return KnxManufacturer_M_E2S_GBR, true
	case "M_UNITLINK":
		return KnxManufacturer_M_UNITLINK, true
	case "M_ONNA":
		return KnxManufacturer_M_ONNA, true
	case "M_CENTERSVET_LLC":
		return KnxManufacturer_M_CENTERSVET_LLC, true
	case "M_ADVECO_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_ADVECO_TECHNOLOGY_CO___LTD_, true
	case "M_FR__LUERSSEN_WERFT":
		return KnxManufacturer_M_FR__LUERSSEN_WERFT, true
	case "M_AGFEO":
		return KnxManufacturer_M_AGFEO, true
	case "M_MYLYR":
		return KnxManufacturer_M_MYLYR, true
	case "M_HYUNDAI_HT":
		return KnxManufacturer_M_HYUNDAI_HT, true
	case "M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD":
		return KnxManufacturer_M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD, true
	case "M_SMATEK_ELECTRONICS_LIMITED":
		return KnxManufacturer_M_SMATEK_ELECTRONICS_LIMITED, true
	case "M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_":
		return KnxManufacturer_M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_, true
	case "M_MORELINKS_SMART_HOME":
		return KnxManufacturer_M_MORELINKS_SMART_HOME, true
	case "M_CIRTX_GMBH":
		return KnxManufacturer_M_CIRTX_GMBH, true
	case "M_QLITE":
		return KnxManufacturer_M_QLITE, true
	case "M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD":
		return KnxManufacturer_M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD, true
	case "M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_":
		return KnxManufacturer_M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_, true
	case "M_ZENNIO":
		return KnxManufacturer_M_ZENNIO, true
	case "M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD":
		return KnxManufacturer_M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD, true
	case "M_CONFIO":
		return KnxManufacturer_M_CONFIO, true
	case "M_SONIC_TECHNOLOGIES":
		return KnxManufacturer_M_SONIC_TECHNOLOGIES, true
	case "M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT":
		return KnxManufacturer_M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT, true
	case "M_ABI_SICHERHEITSSYSTEME_GMBH":
		return KnxManufacturer_M_ABI_SICHERHEITSSYSTEME_GMBH, true
	case "M_RYT":
		return KnxManufacturer_M_RYT, true
	case "M_AURIGA_SYSTEMS":
		return KnxManufacturer_M_AURIGA_SYSTEMS, true
	case "M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH":
		return KnxManufacturer_M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH, true
	case "M_GIANFRANCO_SMART_SOLUTIONS_LTD":
		return KnxManufacturer_M_GIANFRANCO_SMART_SOLUTIONS_LTD, true
	case "M_ROGERWELL_CONTROL_SYSTEM_LIMITED":
		return KnxManufacturer_M_ROGERWELL_CONTROL_SYSTEM_LIMITED, true
	case "M_TAPKO_TECHNOLOGIES":
		return KnxManufacturer_M_TAPKO_TECHNOLOGIES, true
	case "M_ABB___RESERVED":
		return KnxManufacturer_M_ABB___RESERVED, true
	case "M_BUSCH_JAEGER_ELEKTRO___RESERVED":
		return KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO___RESERVED, true
	case "M_HDL":
		return KnxManufacturer_M_HDL, true
	case "M_UPONOR":
		return KnxManufacturer_M_UPONOR, true
	case "M_SE_LIGHTMANAGEMENT_AG":
		return KnxManufacturer_M_SE_LIGHTMANAGEMENT_AG, true
	case "M_ARCUS_EDS":
		return KnxManufacturer_M_ARCUS_EDS, true
	case "M_HAGER_ELECTRO":
		return KnxManufacturer_M_HAGER_ELECTRO, true
	case "M_INTESIS":
		return KnxManufacturer_M_INTESIS, true
	case "M_HERHOLDT_CONTROLS_SRL":
		return KnxManufacturer_M_HERHOLDT_CONTROLS_SRL, true
	case "M_NIKO_ZUBLIN":
		return KnxManufacturer_M_NIKO_ZUBLIN, true
	case "M_DURABLE_TECHNOLOGIES":
		return KnxManufacturer_M_DURABLE_TECHNOLOGIES, true
	case "M_INNOTEAM":
		return KnxManufacturer_M_INNOTEAM, true
	case "M_ISE_GMBH":
		return KnxManufacturer_M_ISE_GMBH, true
	case "M_TEAM_FOR_TRONICS":
		return KnxManufacturer_M_TEAM_FOR_TRONICS, true
	case "M_CARRIER_SAS":
		return KnxManufacturer_M_CARRIER_SAS, true
	case "M_REMEHA_BV":
		return KnxManufacturer_M_REMEHA_BV, true
	case "M_ESYLUX":
		return KnxManufacturer_M_ESYLUX, true
	case "M_INSTA_GMBH":
		return KnxManufacturer_M_INSTA_GMBH, true
	case "M_BASALTE":
		return KnxManufacturer_M_BASALTE, true
	case "M_VESTAMATIC":
		return KnxManufacturer_M_VESTAMATIC, true
	case "M_MDT_TECHNOLOGIES":
		return KnxManufacturer_M_MDT_TECHNOLOGIES, true
	case "M_WARENDORFER_KUECHEN_GMBH":
		return KnxManufacturer_M_WARENDORFER_KUECHEN_GMBH, true
	case "M_GVS":
		return KnxManufacturer_M_GVS, true
	case "M_SITEK":
		return KnxManufacturer_M_SITEK, true
	case "M_CONTROLTRONIC":
		return KnxManufacturer_M_CONTROLTRONIC, true
	case "M_FUNCTION_TECHNOLOGY":
		return KnxManufacturer_M_FUNCTION_TECHNOLOGY, true
	case "M_AMX":
		return KnxManufacturer_M_AMX, true
	case "M_ELDAT":
		return KnxManufacturer_M_ELDAT, true
	}
	return 0, false
}

func KnxManufacturerKnows(value uint16) bool {
	for _, typeValue := range KnxManufacturerValues {
		if uint16(typeValue) == value {
			return true
		}
	}
	return false
}

func CastKnxManufacturer(structType any) KnxManufacturer {
	castFunc := func(typ any) KnxManufacturer {
		if sKnxManufacturer, ok := typ.(KnxManufacturer); ok {
			return sKnxManufacturer
		}
		return 0
	}
	return castFunc(structType)
}

func (m KnxManufacturer) GetLengthInBits(ctx context.Context) uint16 {
	return 16
}

func (m KnxManufacturer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func KnxManufacturerParse(ctx context.Context, theBytes []byte) (KnxManufacturer, error) {
	return KnxManufacturerParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func KnxManufacturerParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (KnxManufacturer, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("KnxManufacturer", 16)
	if err != nil {
		return 0, errors.Wrap(err, "error reading KnxManufacturer")
	}
	if enum, ok := KnxManufacturerByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for KnxManufacturer")
		return KnxManufacturer(val), nil
	} else {
		return enum, nil
	}
}

func (e KnxManufacturer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e KnxManufacturer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint16("KnxManufacturer", 16, uint16(uint16(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e KnxManufacturer) GetValue() uint16 {
	return uint16(e)
}

func (e KnxManufacturer) GetNumber() uint16 {
	return e.Number()
}
func (e KnxManufacturer) GetName() string {
	return e.Name()
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e KnxManufacturer) PLC4XEnumName() string {
	switch e {
	case KnxManufacturer_M_UNKNOWN:
		return "M_UNKNOWN"
	case KnxManufacturer_M_SIEMENS:
		return "M_SIEMENS"
	case KnxManufacturer_M_LEGRAND_APPAREILLAGE_ELECTRIQUE:
		return "M_LEGRAND_APPAREILLAGE_ELECTRIQUE"
	case KnxManufacturer_M_PANASONIC:
		return "M_PANASONIC"
	case KnxManufacturer_M_PULSE_TECHNOLOGIES:
		return "M_PULSE_TECHNOLOGIES"
	case KnxManufacturer_M_CRESTRON:
		return "M_CRESTRON"
	case KnxManufacturer_M_STEINEL_PROFESSIONAL:
		return "M_STEINEL_PROFESSIONAL"
	case KnxManufacturer_M_BILTON_LED_LIGHTING:
		return "M_BILTON_LED_LIGHTING"
	case KnxManufacturer_M_DENRO_AG:
		return "M_DENRO_AG"
	case KnxManufacturer_M_GEPRO:
		return "M_GEPRO"
	case KnxManufacturer_M_PREUSSEN_AUTOMATION:
		return "M_PREUSSEN_AUTOMATION"
	case KnxManufacturer_M_ZOPPAS_INDUSTRIES:
		return "M_ZOPPAS_INDUSTRIES"
	case KnxManufacturer_M_MACTECH:
		return "M_MACTECH"
	case KnxManufacturer_M_MERTEN:
		return "M_MERTEN"
	case KnxManufacturer_M_TECHNO_TREND:
		return "M_TECHNO_TREND"
	case KnxManufacturer_M_FS_CABLES:
		return "M_FS_CABLES"
	case KnxManufacturer_M_DELTA_DORE:
		return "M_DELTA_DORE"
	case KnxManufacturer_M_EISSOUND:
		return "M_EISSOUND"
	case KnxManufacturer_M_CISCO:
		return "M_CISCO"
	case KnxManufacturer_M_DINUY:
		return "M_DINUY"
	case KnxManufacturer_M_IKNIX:
		return "M_IKNIX"
	case KnxManufacturer_M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH:
		return "M_RADEMACHER_GERAETE_ELEKTRONIK_GMBH"
	case KnxManufacturer_M_EGI_ELECTROACUSTICA_GENERAL_IBERICA:
		return "M_EGI_ELECTROACUSTICA_GENERAL_IBERICA"
	case KnxManufacturer_M_BES___INGENIUM:
		return "M_BES___INGENIUM"
	case KnxManufacturer_M_ABB_SPA_SACE_DIVISION:
		return "M_ABB_SPA_SACE_DIVISION"
	case KnxManufacturer_M_ELABNET:
		return "M_ELABNET"
	case KnxManufacturer_M_BLUMOTIX:
		return "M_BLUMOTIX"
	case KnxManufacturer_M_HUNTER_DOUGLAS:
		return "M_HUNTER_DOUGLAS"
	case KnxManufacturer_M_APRICUM:
		return "M_APRICUM"
	case KnxManufacturer_M_TIANSU_AUTOMATION:
		return "M_TIANSU_AUTOMATION"
	case KnxManufacturer_M_BUBENDORFF:
		return "M_BUBENDORFF"
	case KnxManufacturer_M_MBS_GMBH:
		return "M_MBS_GMBH"
	case KnxManufacturer_M_ENERTEX_BAYERN_GMBH:
		return "M_ENERTEX_BAYERN_GMBH"
	case KnxManufacturer_M_BMS:
		return "M_BMS"
	case KnxManufacturer_M_SINAPSI:
		return "M_SINAPSI"
	case KnxManufacturer_M_SIEDLE_AND_SOEHNE:
		return "M_SIEDLE_AND_SOEHNE"
	case KnxManufacturer_M_EMBEDDED_SYSTEMS_SIA:
		return "M_EMBEDDED_SYSTEMS_SIA"
	case KnxManufacturer_M_KNX1:
		return "M_KNX1"
	case KnxManufacturer_M_TOKKA:
		return "M_TOKKA"
	case KnxManufacturer_M_NANOSENSE:
		return "M_NANOSENSE"
	case KnxManufacturer_M_PEAR_AUTOMATION_GMBH:
		return "M_PEAR_AUTOMATION_GMBH"
	case KnxManufacturer_M_DGA:
		return "M_DGA"
	case KnxManufacturer_M_LUTRON:
		return "M_LUTRON"
	case KnxManufacturer_M_AIRZONE___ALTRA:
		return "M_AIRZONE___ALTRA"
	case KnxManufacturer_M_LITHOSS_DESIGN_SWITCHES:
		return "M_LITHOSS_DESIGN_SWITCHES"
	case KnxManufacturer_M_THREEATEL:
		return "M_THREEATEL"
	case KnxManufacturer_M_EBERLE:
		return "M_EBERLE"
	case KnxManufacturer_M_PHILIPS_CONTROLS:
		return "M_PHILIPS_CONTROLS"
	case KnxManufacturer_M_VELUX_AS:
		return "M_VELUX_AS"
	case KnxManufacturer_M_LOYTEC:
		return "M_LOYTEC"
	case KnxManufacturer_M_EKINEX_S_P_A_:
		return "M_EKINEX_S_P_A_"
	case KnxManufacturer_M_SIRLAN_TECHNOLOGIES:
		return "M_SIRLAN_TECHNOLOGIES"
	case KnxManufacturer_M_PROKNX_SAS:
		return "M_PROKNX_SAS"
	case KnxManufacturer_M_IT_GMBH:
		return "M_IT_GMBH"
	case KnxManufacturer_M_RENSON:
		return "M_RENSON"
	case KnxManufacturer_M_HEP_GROUP:
		return "M_HEP_GROUP"
	case KnxManufacturer_M_BALMART:
		return "M_BALMART"
	case KnxManufacturer_M_GEWISS:
		return "M_GEWISS"
	case KnxManufacturer_M_GFS_GMBH:
		return "M_GFS_GMBH"
	case KnxManufacturer_M_SCHENKER_STOREN_AG:
		return "M_SCHENKER_STOREN_AG"
	case KnxManufacturer_M_ALGODUE_ELETTRONICA_S_R_L_:
		return "M_ALGODUE_ELETTRONICA_S_R_L_"
	case KnxManufacturer_M_ABB_FRANCE:
		return "M_ABB_FRANCE"
	case KnxManufacturer_M_MAINTRONIC:
		return "M_MAINTRONIC"
	case KnxManufacturer_M_VANTAGE:
		return "M_VANTAGE"
	case KnxManufacturer_M_FORESIS:
		return "M_FORESIS"
	case KnxManufacturer_M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM:
		return "M_RESEARCH_AND_PRODUCTION_ASSOCIATION_SEM"
	case KnxManufacturer_M_WEINZIERL_ENGINEERING_GMBH:
		return "M_WEINZIERL_ENGINEERING_GMBH"
	case KnxManufacturer_M_MOEHLENHOFF_WAERMETECHNIK_GMBH:
		return "M_MOEHLENHOFF_WAERMETECHNIK_GMBH"
	case KnxManufacturer_M_ALBERT_ACKERMANN:
		return "M_ALBERT_ACKERMANN"
	case KnxManufacturer_M_PKC_GROUP_OYJ:
		return "M_PKC_GROUP_OYJ"
	case KnxManufacturer_M_B_E_G_:
		return "M_B_E_G_"
	case KnxManufacturer_M_ELSNER_ELEKTRONIK_GMBH:
		return "M_ELSNER_ELEKTRONIK_GMBH"
	case KnxManufacturer_M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_:
		return "M_SIEMENS_BUILDING_TECHNOLOGIES_HKCHINA_LTD_"
	case KnxManufacturer_M_EUTRAC:
		return "M_EUTRAC"
	case KnxManufacturer_M_GUSTAV_HENSEL_GMBH_AND_CO__KG:
		return "M_GUSTAV_HENSEL_GMBH_AND_CO__KG"
	case KnxManufacturer_M_GARO_AB:
		return "M_GARO_AB"
	case KnxManufacturer_M_WALDMANN_LICHTTECHNIK:
		return "M_WALDMANN_LICHTTECHNIK"
	case KnxManufacturer_M_SCHUECO:
		return "M_SCHUECO"
	case KnxManufacturer_M_EMU:
		return "M_EMU"
	case KnxManufacturer_M_SCHUPA_GMBH:
		return "M_SCHUPA_GMBH"
	case KnxManufacturer_M_JNET_SYSTEMS_AG:
		return "M_JNET_SYSTEMS_AG"
	case KnxManufacturer_M_TOTAL_SOLUTION_GMBH:
		return "M_TOTAL_SOLUTION_GMBH"
	case KnxManufacturer_M_O_Y_L__ELECTRONICS:
		return "M_O_Y_L__ELECTRONICS"
	case KnxManufacturer_M_GALAX_SYSTEM:
		return "M_GALAX_SYSTEM"
	case KnxManufacturer_M_DISCH:
		return "M_DISCH"
	case KnxManufacturer_M_AUCOTEAM:
		return "M_AUCOTEAM"
	case KnxManufacturer_M_LUXMATE_CONTROLS:
		return "M_LUXMATE_CONTROLS"
	case KnxManufacturer_M_DANFOSS:
		return "M_DANFOSS"
	case KnxManufacturer_M_AST_GMBH:
		return "M_AST_GMBH"
	case KnxManufacturer_M_WILA_LEUCHTEN:
		return "M_WILA_LEUCHTEN"
	case KnxManufacturer_M_ABB_SCHWEIZ:
		return "M_ABB_SCHWEIZ"
	case KnxManufacturer_M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK:
		return "M_BPlusB_AUTOMATIONS__UND_STEUERUNGSTECHNIK"
	case KnxManufacturer_M_LINGG_AND_JANKE:
		return "M_LINGG_AND_JANKE"
	case KnxManufacturer_M_SAUTER:
		return "M_SAUTER"
	case KnxManufacturer_M_SIMU:
		return "M_SIMU"
	case KnxManufacturer_M_THEBEN_HTS_AG:
		return "M_THEBEN_HTS_AG"
	case KnxManufacturer_M_AMANN_GMBH:
		return "M_AMANN_GMBH"
	case KnxManufacturer_M_BERG_ENERGIEKONTROLLSYSTEME_GMBH:
		return "M_BERG_ENERGIEKONTROLLSYSTEME_GMBH"
	case KnxManufacturer_M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH:
		return "M_HUEPPE_FORM_SONNENSCHUTZSYSTEME_GMBH"
	case KnxManufacturer_M_OVENTROP_KG:
		return "M_OVENTROP_KG"
	case KnxManufacturer_M_GRIESSER_AG:
		return "M_GRIESSER_AG"
	case KnxManufacturer_M_FELLER:
		return "M_FELLER"
	case KnxManufacturer_M_IPAS_GMBH:
		return "M_IPAS_GMBH"
	case KnxManufacturer_M_ELERO_GMBH:
		return "M_ELERO_GMBH"
	case KnxManufacturer_M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_:
		return "M_ARDAN_PRODUCTION_AND_INDUSTRIAL_CONTROLS_LTD_"
	case KnxManufacturer_M_METEC_MESSTECHNIK_GMBH:
		return "M_METEC_MESSTECHNIK_GMBH"
	case KnxManufacturer_M_BUERK_MOBATIME:
		return "M_BUERK_MOBATIME"
	case KnxManufacturer_M_ELKA_ELEKTRONIK_GMBH:
		return "M_ELKA_ELEKTRONIK_GMBH"
	case KnxManufacturer_M_ELEKTROANLAGEN_D__NAGEL:
		return "M_ELEKTROANLAGEN_D__NAGEL"
	case KnxManufacturer_M_TRIDONIC_BAUELEMENTE_GMBH:
		return "M_TRIDONIC_BAUELEMENTE_GMBH"
	case KnxManufacturer_M_STENGLER_GESELLSCHAFT:
		return "M_STENGLER_GESELLSCHAFT"
	case KnxManufacturer_M_SCHNEIDER_ELECTRIC_MG:
		return "M_SCHNEIDER_ELECTRIC_MG"
	case KnxManufacturer_M_ABB:
		return "M_ABB"
	case KnxManufacturer_M_GLAMOX_AS:
		return "M_GLAMOX_AS"
	case KnxManufacturer_M_KNX_ASSOCIATION:
		return "M_KNX_ASSOCIATION"
	case KnxManufacturer_M_VIVO:
		return "M_VIVO"
	case KnxManufacturer_M_HUGO_MUELLER_GMBH_AND_CO_KG:
		return "M_HUGO_MUELLER_GMBH_AND_CO_KG"
	case KnxManufacturer_M_SIEMENS_HVAC:
		return "M_SIEMENS_HVAC"
	case KnxManufacturer_M_APT:
		return "M_APT"
	case KnxManufacturer_M_HIGHDOM:
		return "M_HIGHDOM"
	case KnxManufacturer_M_TOP_SERVICES:
		return "M_TOP_SERVICES"
	case KnxManufacturer_M_AMBIHOME:
		return "M_AMBIHOME"
	case KnxManufacturer_M_DATEC_ELECTRONIC_AG:
		return "M_DATEC_ELECTRONIC_AG"
	case KnxManufacturer_M_ABUS_SECURITY_CENTER:
		return "M_ABUS_SECURITY_CENTER"
	case KnxManufacturer_M_DEHN_AND_SOEHNE:
		return "M_DEHN_AND_SOEHNE"
	case KnxManufacturer_M_LITE_PUTER:
		return "M_LITE_PUTER"
	case KnxManufacturer_M_TANTRON_ELECTRONIC:
		return "M_TANTRON_ELECTRONIC"
	case KnxManufacturer_M_INTERRA:
		return "M_INTERRA"
	case KnxManufacturer_M_DKX_TECH:
		return "M_DKX_TECH"
	case KnxManufacturer_M_VIATRON:
		return "M_VIATRON"
	case KnxManufacturer_M_NAUTIBUS:
		return "M_NAUTIBUS"
	case KnxManufacturer_M_ON_SEMICONDUCTOR:
		return "M_ON_SEMICONDUCTOR"
	case KnxManufacturer_M_LONGCHUANG:
		return "M_LONGCHUANG"
	case KnxManufacturer_M_AIR_ON_AG:
		return "M_AIR_ON_AG"
	case KnxManufacturer_M_IB_COMPANY_GMBH:
		return "M_IB_COMPANY_GMBH"
	case KnxManufacturer_M_CRABTREE:
		return "M_CRABTREE"
	case KnxManufacturer_M_SATION_FACTORY:
		return "M_SATION_FACTORY"
	case KnxManufacturer_M_AGENTILO_GMBH:
		return "M_AGENTILO_GMBH"
	case KnxManufacturer_M_MAKEL_ELEKTRIK:
		return "M_MAKEL_ELEKTRIK"
	case KnxManufacturer_M_HELIOS_VENTILATOREN:
		return "M_HELIOS_VENTILATOREN"
	case KnxManufacturer_M_OTTO_SOLUTIONS_PTE_LTD:
		return "M_OTTO_SOLUTIONS_PTE_LTD"
	case KnxManufacturer_M_AIRMASTER:
		return "M_AIRMASTER"
	case KnxManufacturer_M_VALLOX_GMBH:
		return "M_VALLOX_GMBH"
	case KnxManufacturer_M_DALITEK:
		return "M_DALITEK"
	case KnxManufacturer_M_ASIN:
		return "M_ASIN"
	case KnxManufacturer_M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_:
		return "M_BRIDGES_INTELLIGENCE_TECHNOLOGY_INC_"
	case KnxManufacturer_M_EVOKNX:
		return "M_EVOKNX"
	case KnxManufacturer_M_ARBONIA:
		return "M_ARBONIA"
	case KnxManufacturer_M_KERMI:
		return "M_KERMI"
	case KnxManufacturer_M_PROLUX:
		return "M_PROLUX"
	case KnxManufacturer_M_CLICHOME:
		return "M_CLICHOME"
	case KnxManufacturer_M_COMMAX:
		return "M_COMMAX"
	case KnxManufacturer_M_EAE:
		return "M_EAE"
	case KnxManufacturer_M_TENSE:
		return "M_TENSE"
	case KnxManufacturer_M_SEYOUNG_ELECTRONICS:
		return "M_SEYOUNG_ELECTRONICS"
	case KnxManufacturer_M_LIFEDOMUS:
		return "M_LIFEDOMUS"
	case KnxManufacturer_M_EUROTRONIC_TECHNOLOGY_GMBH:
		return "M_EUROTRONIC_TECHNOLOGY_GMBH"
	case KnxManufacturer_M_PAUL_HOCHKOEPPER:
		return "M_PAUL_HOCHKOEPPER"
	case KnxManufacturer_M_TCI:
		return "M_TCI"
	case KnxManufacturer_M_RISHUN_ELECTRONIC:
		return "M_RISHUN_ELECTRONIC"
	case KnxManufacturer_M_ZIPATO:
		return "M_ZIPATO"
	case KnxManufacturer_M_CM_SECURITY_GMBH_AND_CO_KG:
		return "M_CM_SECURITY_GMBH_AND_CO_KG"
	case KnxManufacturer_M_QING_CABLES:
		return "M_QING_CABLES"
	case KnxManufacturer_M_WOLF:
		return "M_WOLF"
	case KnxManufacturer_M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_:
		return "M_COSTER_TECNOLOGIE_ELETTRONICHE_S_P_A_"
	case KnxManufacturer_M_E_G_E:
		return "M_E_G_E"
	case KnxManufacturer_M_NETXAUTOMATION:
		return "M_NETXAUTOMATION"
	case KnxManufacturer_M_TECALOR:
		return "M_TECALOR"
	case KnxManufacturer_M_ALTENBURGER_ELECTRONIC:
		return "M_ALTENBURGER_ELECTRONIC"
	case KnxManufacturer_M_URMET_ELECTRONICS_HUIZHOU_LTD_:
		return "M_URMET_ELECTRONICS_HUIZHOU_LTD_"
	case KnxManufacturer_M_PEIYING_BUILDING_CONTROL:
		return "M_PEIYING_BUILDING_CONTROL"
	case KnxManufacturer_M_BPT_S_P_A__A_SOCIO_UNICO:
		return "M_BPT_S_P_A__A_SOCIO_UNICO"
	case KnxManufacturer_M_KANONTEC___KANONBUS:
		return "M_KANONTEC___KANONBUS"
	case KnxManufacturer_M_ISER_TECH:
		return "M_ISER_TECH"
	case KnxManufacturer_M_FINELINE:
		return "M_FINELINE"
	case KnxManufacturer_M_CP_ELECTRONICS_LTD:
		return "M_CP_ELECTRONICS_LTD"
	case KnxManufacturer_M_NIKO_SERVODAN_AS:
		return "M_NIKO_SERVODAN_AS"
	case KnxManufacturer_M_SIMON_309:
		return "M_SIMON_309"
	case KnxManufacturer_M_GM_MODULAR_PVT__LTD_:
		return "M_GM_MODULAR_PVT__LTD_"
	case KnxManufacturer_M_GRAESSLIN:
		return "M_GRAESSLIN"
	case KnxManufacturer_M_FU_CHENG_INTELLIGENCE:
		return "M_FU_CHENG_INTELLIGENCE"
	case KnxManufacturer_M_NEXKON:
		return "M_NEXKON"
	case KnxManufacturer_M_FEEL_S_R_L:
		return "M_FEEL_S_R_L"
	case KnxManufacturer_M_NOT_ASSIGNED_314:
		return "M_NOT_ASSIGNED_314"
	case KnxManufacturer_M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_:
		return "M_SHENZHEN_FANHAI_SANJIANG_ELECTRONICS_CO___LTD_"
	case KnxManufacturer_M_JIUZHOU_GREEBLE:
		return "M_JIUZHOU_GREEBLE"
	case KnxManufacturer_M_AUMUELLER_AUMATIC_GMBH:
		return "M_AUMUELLER_AUMATIC_GMBH"
	case KnxManufacturer_M_ETMAN_ELECTRIC:
		return "M_ETMAN_ELECTRIC"
	case KnxManufacturer_M_BLACK_NOVA:
		return "M_BLACK_NOVA"
	case KnxManufacturer_M_ZIDATECH_AG:
		return "M_ZIDATECH_AG"
	case KnxManufacturer_M_SIMON_42:
		return "M_SIMON_42"
	case KnxManufacturer_M_IDGS_BVBA:
		return "M_IDGS_BVBA"
	case KnxManufacturer_M_DAKANIMO:
		return "M_DAKANIMO"
	case KnxManufacturer_M_TREBOR_AUTOMATION_AB:
		return "M_TREBOR_AUTOMATION_AB"
	case KnxManufacturer_M_SATEL_SP__Z_O_O_:
		return "M_SATEL_SP__Z_O_O_"
	case KnxManufacturer_M_RUSSOUND__INC_:
		return "M_RUSSOUND__INC_"
	case KnxManufacturer_M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD:
		return "M_MIDEA_HEATING_AND_VENTILATING_EQUIPMENT_CO_LTD"
	case KnxManufacturer_M_CONSORZIO_TERRANUOVA:
		return "M_CONSORZIO_TERRANUOVA"
	case KnxManufacturer_M_WOLF_HEIZTECHNIK_GMBH:
		return "M_WOLF_HEIZTECHNIK_GMBH"
	case KnxManufacturer_M_SONTEC:
		return "M_SONTEC"
	case KnxManufacturer_M_BELCOM_CABLES_LTD_:
		return "M_BELCOM_CABLES_LTD_"
	case KnxManufacturer_M_VIMAR:
		return "M_VIMAR"
	case KnxManufacturer_M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_:
		return "M_GUANGZHOU_SEAWIN_ELECTRICAL_TECHNOLOGIES_CO___LTD_"
	case KnxManufacturer_M_ACREL:
		return "M_ACREL"
	case KnxManufacturer_M_KWC_AQUAROTTER_GMBH:
		return "M_KWC_AQUAROTTER_GMBH"
	case KnxManufacturer_M_ORION_SYSTEMS:
		return "M_ORION_SYSTEMS"
	case KnxManufacturer_M_SCHRACK_TECHNIK_GMBH:
		return "M_SCHRACK_TECHNIK_GMBH"
	case KnxManufacturer_M_INSPRID:
		return "M_INSPRID"
	case KnxManufacturer_M_SUNRICHER:
		return "M_SUNRICHER"
	case KnxManufacturer_M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_:
		return "M_MENRED_AUTOMATION_SYSTEMSHANGHAI_CO__LTD_"
	case KnxManufacturer_M_AUREX:
		return "M_AUREX"
	case KnxManufacturer_M_JOSEF_BARTHELME_GMBH_AND_CO__KG:
		return "M_JOSEF_BARTHELME_GMBH_AND_CO__KG"
	case KnxManufacturer_M_MOELLER_GEBAEUDEAUTOMATION_KG:
		return "M_MOELLER_GEBAEUDEAUTOMATION_KG"
	case KnxManufacturer_M_ARCHITECTURE_NUMERIQUE:
		return "M_ARCHITECTURE_NUMERIQUE"
	case KnxManufacturer_M_UP_GROUP:
		return "M_UP_GROUP"
	case KnxManufacturer_M_TEKNOS_AVINNO:
		return "M_TEKNOS_AVINNO"
	case KnxManufacturer_M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY:
		return "M_NINGBO_DOOYA_MECHANIC_AND_ELECTRONIC_TECHNOLOGY"
	case KnxManufacturer_M_THERMOKON_SENSORTECHNIK_GMBH:
		return "M_THERMOKON_SENSORTECHNIK_GMBH"
	case KnxManufacturer_M_BELIMO_AUTOMATION_AG:
		return "M_BELIMO_AUTOMATION_AG"
	case KnxManufacturer_M_ZEHNDER_GROUP_INTERNATIONAL_AG:
		return "M_ZEHNDER_GROUP_INTERNATIONAL_AG"
	case KnxManufacturer_M_SKS_KINKEL_ELEKTRONIK:
		return "M_SKS_KINKEL_ELEKTRONIK"
	case KnxManufacturer_M_ECE_WURMITZER_GMBH:
		return "M_ECE_WURMITZER_GMBH"
	case KnxManufacturer_M_LARS:
		return "M_LARS"
	case KnxManufacturer_M_ALBRECHT_JUNG:
		return "M_ALBRECHT_JUNG"
	case KnxManufacturer_M_ELTAKO:
		return "M_ELTAKO"
	case KnxManufacturer_M_URC:
		return "M_URC"
	case KnxManufacturer_M_LIGHTCONTROL:
		return "M_LIGHTCONTROL"
	case KnxManufacturer_M_SHENZHEN_YM:
		return "M_SHENZHEN_YM"
	case KnxManufacturer_M_MEAN_WELL_ENTERPRISES_CO__LTD_:
		return "M_MEAN_WELL_ENTERPRISES_CO__LTD_"
	case KnxManufacturer_M_OSIX:
		return "M_OSIX"
	case KnxManufacturer_M_AYPRO_TECHNOLOGY:
		return "M_AYPRO_TECHNOLOGY"
	case KnxManufacturer_M_HEFEI_ECOLITE_SOFTWARE:
		return "M_HEFEI_ECOLITE_SOFTWARE"
	case KnxManufacturer_M_ENNO:
		return "M_ENNO"
	case KnxManufacturer_M_OHOSURE:
		return "M_OHOSURE"
	case KnxManufacturer_M_GAREFOWL:
		return "M_GAREFOWL"
	case KnxManufacturer_M_BOSCH_SIEMENS_HAUSHALTSGERAETE:
		return "M_BOSCH_SIEMENS_HAUSHALTSGERAETE"
	case KnxManufacturer_M_GEZE:
		return "M_GEZE"
	case KnxManufacturer_M_LG_ELECTRONICS_INC_:
		return "M_LG_ELECTRONICS_INC_"
	case KnxManufacturer_M_SMC_INTERIORS:
		return "M_SMC_INTERIORS"
	case KnxManufacturer_M_NOT_ASSIGNED_364:
		return "M_NOT_ASSIGNED_364"
	case KnxManufacturer_M_SCS_CABLE:
		return "M_SCS_CABLE"
	case KnxManufacturer_M_HOVAL:
		return "M_HOVAL"
	case KnxManufacturer_M_CANST:
		return "M_CANST"
	case KnxManufacturer_M_HANGZHOU_BERLIN:
		return "M_HANGZHOU_BERLIN"
	case KnxManufacturer_M_EVN_LICHTTECHNIK:
		return "M_EVN_LICHTTECHNIK"
	case KnxManufacturer_M_RUTEC:
		return "M_RUTEC"
	case KnxManufacturer_M_RITTO_GMBHANDCO_KG:
		return "M_RITTO_GMBHANDCO_KG"
	case KnxManufacturer_M_FINDER:
		return "M_FINDER"
	case KnxManufacturer_M_FUJITSU_GENERAL_LIMITED:
		return "M_FUJITSU_GENERAL_LIMITED"
	case KnxManufacturer_M_ZF_FRIEDRICHSHAFEN_AG:
		return "M_ZF_FRIEDRICHSHAFEN_AG"
	case KnxManufacturer_M_CREALED:
		return "M_CREALED"
	case KnxManufacturer_M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED:
		return "M_MILES_MAGIC_AUTOMATION_PRIVATE_LIMITED"
	case KnxManufacturer_M_EPlus:
		return "M_EPlus"
	case KnxManufacturer_M_ITALCOND:
		return "M_ITALCOND"
	case KnxManufacturer_M_SATION:
		return "M_SATION"
	case KnxManufacturer_M_NEWBEST:
		return "M_NEWBEST"
	case KnxManufacturer_M_GDS_DIGITAL_SYSTEMS:
		return "M_GDS_DIGITAL_SYSTEMS"
	case KnxManufacturer_M_POWER_CONTROLS:
		return "M_POWER_CONTROLS"
	case KnxManufacturer_M_IDDERO:
		return "M_IDDERO"
	case KnxManufacturer_M_MBNLED:
		return "M_MBNLED"
	case KnxManufacturer_M_VITRUM:
		return "M_VITRUM"
	case KnxManufacturer_M_EKEY_BIOMETRIC_SYSTEMS_GMBH:
		return "M_EKEY_BIOMETRIC_SYSTEMS_GMBH"
	case KnxManufacturer_M_AMC:
		return "M_AMC"
	case KnxManufacturer_M_TRILUX_GMBH_AND_CO__KG:
		return "M_TRILUX_GMBH_AND_CO__KG"
	case KnxManufacturer_M_WEXCEDO:
		return "M_WEXCEDO"
	case KnxManufacturer_M_VEMER_SPA:
		return "M_VEMER_SPA"
	case KnxManufacturer_M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG:
		return "M_ALEXANDER_BUERKLE_GMBH_AND_CO_KG"
	case KnxManufacturer_M_CITRON:
		return "M_CITRON"
	case KnxManufacturer_M_ZUMTOBEL:
		return "M_ZUMTOBEL"
	case KnxManufacturer_M_SHENZHEN_HEGUANG:
		return "M_SHENZHEN_HEGUANG"
	case KnxManufacturer_M_NOT_ASSIGNED_392:
		return "M_NOT_ASSIGNED_392"
	case KnxManufacturer_M_TRANE_B_V_B_A:
		return "M_TRANE_B_V_B_A"
	case KnxManufacturer_M_CAREL:
		return "M_CAREL"
	case KnxManufacturer_M_PROLITE_CONTROLS:
		return "M_PROLITE_CONTROLS"
	case KnxManufacturer_M_BOSMER:
		return "M_BOSMER"
	case KnxManufacturer_M_EUCHIPS:
		return "M_EUCHIPS"
	case KnxManufacturer_M_CONNECT_THINKA_CONNECT:
		return "M_CONNECT_THINKA_CONNECT"
	case KnxManufacturer_M_PEAKNX_A_DOGAWIST_COMPANY:
		return "M_PEAKNX_A_DOGAWIST_COMPANY"
	case KnxManufacturer_M_ACEMATIC:
		return "M_ACEMATIC"
	case KnxManufacturer_M_HOLEC_SYSTEMEN:
		return "M_HOLEC_SYSTEMEN"
	case KnxManufacturer_M_ELAUSYS:
		return "M_ELAUSYS"
	case KnxManufacturer_M_ITK_ENGINEERING_AG:
		return "M_ITK_ENGINEERING_AG"
	case KnxManufacturer_M_INTEGRA_METERING_AG:
		return "M_INTEGRA_METERING_AG"
	case KnxManufacturer_M_FMS_HOSPITALITY_PTE_LTD:
		return "M_FMS_HOSPITALITY_PTE_LTD"
	case KnxManufacturer_M_NUVO:
		return "M_NUVO"
	case KnxManufacturer_M_U__LUX_GMBH:
		return "M_U__LUX_GMBH"
	case KnxManufacturer_M_BRUMBERG_LEUCHTEN:
		return "M_BRUMBERG_LEUCHTEN"
	case KnxManufacturer_M_LIME:
		return "M_LIME"
	case KnxManufacturer_M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_:
		return "M_GREAT_EMPIRE_INTERNATIONAL_GROUP_CO___LTD_"
	case KnxManufacturer_M_KAVOSHPISHRO_ASIA:
		return "M_KAVOSHPISHRO_ASIA"
	case KnxManufacturer_M_PHOENIX_CONTACT:
		return "M_PHOENIX_CONTACT"
	case KnxManufacturer_M_V2_SPA:
		return "M_V2_SPA"
	case KnxManufacturer_M_JOHNSON_CONTROLS:
		return "M_JOHNSON_CONTROLS"
	case KnxManufacturer_M_ARKUD:
		return "M_ARKUD"
	case KnxManufacturer_M_IRIDI_LTD_:
		return "M_IRIDI_LTD_"
	case KnxManufacturer_M_BSMART:
		return "M_BSMART"
	case KnxManufacturer_M_BAB_TECHNOLOGIE_GMBH:
		return "M_BAB_TECHNOLOGIE_GMBH"
	case KnxManufacturer_M_NICE_SPA:
		return "M_NICE_SPA"
	case KnxManufacturer_M_REDFISH_GROUP_PTY_LTD:
		return "M_REDFISH_GROUP_PTY_LTD"
	case KnxManufacturer_M_SABIANA_SPA:
		return "M_SABIANA_SPA"
	case KnxManufacturer_M_UBEE_INTERACTIVE_EUROPE:
		return "M_UBEE_INTERACTIVE_EUROPE"
	case KnxManufacturer_M_WAGO_GMBH_AND_CO_KG:
		return "M_WAGO_GMBH_AND_CO_KG"
	case KnxManufacturer_M_REXEL:
		return "M_REXEL"
	case KnxManufacturer_M_GES_TEKNIK_A_S_:
		return "M_GES_TEKNIK_A_S_"
	case KnxManufacturer_M_AVE_S_P_A_:
		return "M_AVE_S_P_A_"
	case KnxManufacturer_M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_:
		return "M_ZHUHAI_LTECH_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_ARCOM:
		return "M_ARCOM"
	case KnxManufacturer_M_VIA_TECHNOLOGIES__INC_:
		return "M_VIA_TECHNOLOGIES__INC_"
	case KnxManufacturer_M_FEELSMART_:
		return "M_FEELSMART_"
	case KnxManufacturer_M_SUPCON:
		return "M_SUPCON"
	case KnxManufacturer_M_MANIC:
		return "M_MANIC"
	case KnxManufacturer_M_TDE_GMBH:
		return "M_TDE_GMBH"
	case KnxManufacturer_M_KNXPRESSO:
		return "M_KNXPRESSO"
	case KnxManufacturer_M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_:
		return "M_NANJING_SHUFAN_INFORMATION_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_EWTECH:
		return "M_EWTECH"
	case KnxManufacturer_M_KLUGER_AUTOMATION_GMBH:
		return "M_KLUGER_AUTOMATION_GMBH"
	case KnxManufacturer_M_JOONGANG_CONTROL:
		return "M_JOONGANG_CONTROL"
	case KnxManufacturer_M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_:
		return "M_GREENCONTROLS_TECHNOLOGY_SDN__BHD_"
	case KnxManufacturer_M_IME_S_P_A_:
		return "M_IME_S_P_A_"
	case KnxManufacturer_M_SICHUAN_HAODING:
		return "M_SICHUAN_HAODING"
	case KnxManufacturer_M_MINDJAGA_LTD_:
		return "M_MINDJAGA_LTD_"
	case KnxManufacturer_M_RUILI_SMART_CONTROL:
		return "M_RUILI_SMART_CONTROL"
	case KnxManufacturer_M_CODESYS_GMBH:
		return "M_CODESYS_GMBH"
	case KnxManufacturer_M_WIELAND_ELECTRIC:
		return "M_WIELAND_ELECTRIC"
	case KnxManufacturer_M_MOORGEN_DEUTSCHLAND_GMBH:
		return "M_MOORGEN_DEUTSCHLAND_GMBH"
	case KnxManufacturer_M_CULLMANN_TECH:
		return "M_CULLMANN_TECH"
	case KnxManufacturer_M_EYRISE_B_V:
		return "M_EYRISE_B_V"
	case KnxManufacturer_M_DOBNEL:
		return "M_DOBNEL"
	case KnxManufacturer_M_MYGEKKO:
		return "M_MYGEKKO"
	case KnxManufacturer_M_ERGO3_SARL:
		return "M_ERGO3_SARL"
	case KnxManufacturer_M_STMICROELECTRONICS_INTERNATIONAL_N_V_:
		return "M_STMICROELECTRONICS_INTERNATIONAL_N_V_"
	case KnxManufacturer_M_CJC_SYSTEMS:
		return "M_CJC_SYSTEMS"
	case KnxManufacturer_M_SUDOKU:
		return "M_SUDOKU"
	case KnxManufacturer_M_AZ_E_LITE_PTE_LTD:
		return "M_AZ_E_LITE_PTE_LTD"
	case KnxManufacturer_M_BTICINO:
		return "M_BTICINO"
	case KnxManufacturer_M_HERMANN_KLEINHUIS:
		return "M_HERMANN_KLEINHUIS"
	case KnxManufacturer_M_ARLIGHT:
		return "M_ARLIGHT"
	case KnxManufacturer_M_GRUENBECK_WASSERAUFBEREITUNG_GMBH:
		return "M_GRUENBECK_WASSERAUFBEREITUNG_GMBH"
	case KnxManufacturer_M_MODULE_ELECTRONIC:
		return "M_MODULE_ELECTRONIC"
	case KnxManufacturer_M_KOPLAT:
		return "M_KOPLAT"
	case KnxManufacturer_M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD:
		return "M_GUANGZHOU_LETOUR_LIFE_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_ILEVIA:
		return "M_ILEVIA"
	case KnxManufacturer_M_LN_SYSTEMTEQ:
		return "M_LN_SYSTEMTEQ"
	case KnxManufacturer_M_HISENSE_SMARTHOME:
		return "M_HISENSE_SMARTHOME"
	case KnxManufacturer_M_FLINK_AUTOMATION_SYSTEM:
		return "M_FLINK_AUTOMATION_SYSTEM"
	case KnxManufacturer_M_XXTER_BV:
		return "M_XXTER_BV"
	case KnxManufacturer_M_STIEBEL_ELTRON:
		return "M_STIEBEL_ELTRON"
	case KnxManufacturer_M_LYNXUS_TECHNOLOGY:
		return "M_LYNXUS_TECHNOLOGY"
	case KnxManufacturer_M_ROBOT_S_A_:
		return "M_ROBOT_S_A_"
	case KnxManufacturer_M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_:
		return "M_SHENZHEN_ATTE_SMART_LIFE_CO__LTD_"
	case KnxManufacturer_M_NOBLESSE:
		return "M_NOBLESSE"
	case KnxManufacturer_M_ADVANCED_DEVICES:
		return "M_ADVANCED_DEVICES"
	case KnxManufacturer_M_ATRINA_BUILDING_AUTOMATION_CO__LTD:
		return "M_ATRINA_BUILDING_AUTOMATION_CO__LTD"
	case KnxManufacturer_M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_:
		return "M_GUANGDONG_DAMING_LAFFEY_ELECTRIC_CO___LTD_"
	case KnxManufacturer_M_WESTERSTRAND_URFABRIK_AB:
		return "M_WESTERSTRAND_URFABRIK_AB"
	case KnxManufacturer_M_CONTROL4_CORPORATE:
		return "M_CONTROL4_CORPORATE"
	case KnxManufacturer_M_ONTROL:
		return "M_ONTROL"
	case KnxManufacturer_M_TEHALIT:
		return "M_TEHALIT"
	case KnxManufacturer_M_STARNET:
		return "M_STARNET"
	case KnxManufacturer_M_BETA_CAVI:
		return "M_BETA_CAVI"
	case KnxManufacturer_M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_:
		return "M_HANGZHOU_YIYUE_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_VIVALDI_SRL:
		return "M_VIVALDI_SRL"
	case KnxManufacturer_M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI:
		return "M_GREE_ELECTRIC_APPLIANCES_INC__OF_ZHUHAI"
	case KnxManufacturer_M_HWISCON:
		return "M_HWISCON"
	case KnxManufacturer_M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_:
		return "M_SHANGHAI_ELECON_INTELLIGENT_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_KAMPMANN:
		return "M_KAMPMANN"
	case KnxManufacturer_M_IMPOLUX_GMBH_LEDIMAX:
		return "M_IMPOLUX_GMBH_LEDIMAX"
	case KnxManufacturer_M_EVAUX:
		return "M_EVAUX"
	case KnxManufacturer_M_THEBEN_AG:
		return "M_THEBEN_AG"
	case KnxManufacturer_M_WEBRO_CABLES_AND_CONNECTORS_LIMITED:
		return "M_WEBRO_CABLES_AND_CONNECTORS_LIMITED"
	case KnxManufacturer_M_SHANGHAI_E_TECH_SOLUTION:
		return "M_SHANGHAI_E_TECH_SOLUTION"
	case KnxManufacturer_M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_:
		return "M_GUANGZHOU_HOKO_ELECTRIC_CO__LTD_"
	case KnxManufacturer_M_LAMMIN_HIGH_TECH_CO__LTD:
		return "M_LAMMIN_HIGH_TECH_CO__LTD"
	case KnxManufacturer_M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD:
		return "M_SHENZHEN_MERRYTEK_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_I_LUXUS:
		return "M_I_LUXUS"
	case KnxManufacturer_M_ELMOS_SEMICONDUCTOR_AG:
		return "M_ELMOS_SEMICONDUCTOR_AG"
	case KnxManufacturer_M_EMCOM_TECHNOLOGY_INC:
		return "M_EMCOM_TECHNOLOGY_INC"
	case KnxManufacturer_M_PROJECT_INNOVATIONS_GMBH:
		return "M_PROJECT_INNOVATIONS_GMBH"
	case KnxManufacturer_M_ITC:
		return "M_ITC"
	case KnxManufacturer_M_WILHELM_RUTENBECK:
		return "M_WILHELM_RUTENBECK"
	case KnxManufacturer_M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING:
		return "M_ABB_LV_INSTALLATION_MATERIALS_COMPANY_LTD__BEIJING"
	case KnxManufacturer_M_MAICO:
		return "M_MAICO"
	case KnxManufacturer_M_ELAN_SRL:
		return "M_ELAN_SRL"
	case KnxManufacturer_M_MINHHA_TECHNOLOGY_CO__LTD:
		return "M_MINHHA_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_:
		return "M_ZHEJIANG_TIANJIE_INDUSTRIAL_CORP_"
	case KnxManufacturer_M_IAUTOMATION_PTY_LIMITED:
		return "M_IAUTOMATION_PTY_LIMITED"
	case KnxManufacturer_M_EXTRON:
		return "M_EXTRON"
	case KnxManufacturer_M_FREEDOMPRO:
		return "M_FREEDOMPRO"
	case KnxManufacturer_M_ONEHOME:
		return "M_ONEHOME"
	case KnxManufacturer_M_EOS_SAUNATECHNIK_GMBH:
		return "M_EOS_SAUNATECHNIK_GMBH"
	case KnxManufacturer_M_WINKHAUS:
		return "M_WINKHAUS"
	case KnxManufacturer_M_KUSATEK_GMBH:
		return "M_KUSATEK_GMBH"
	case KnxManufacturer_M_ALEXANDER_MAIER_GMBH:
		return "M_ALEXANDER_MAIER_GMBH"
	case KnxManufacturer_M_AUTOMATISMI_BENINCA_S_P_A_:
		return "M_AUTOMATISMI_BENINCA_S_P_A_"
	case KnxManufacturer_M_BLENDOM:
		return "M_BLENDOM"
	case KnxManufacturer_M_MADEL_AIR_TECHNICAL_DIFFUSION:
		return "M_MADEL_AIR_TECHNICAL_DIFFUSION"
	case KnxManufacturer_M_NIKO:
		return "M_NIKO"
	case KnxManufacturer_M_BOSCH_REXROTH_AG:
		return "M_BOSCH_REXROTH_AG"
	case KnxManufacturer_M_CANDM_PRODUCTS:
		return "M_CANDM_PRODUCTS"
	case KnxManufacturer_M_HOERMANN_KG_VERKAUFSGESELLSCHAFT:
		return "M_HOERMANN_KG_VERKAUFSGESELLSCHAFT"
	case KnxManufacturer_M_SHANGHAI_RAJAYASA_CO__LTD:
		return "M_SHANGHAI_RAJAYASA_CO__LTD"
	case KnxManufacturer_M_ROBERT_BOSCH:
		return "M_ROBERT_BOSCH"
	case KnxManufacturer_M_SUZUKI:
		return "M_SUZUKI"
	case KnxManufacturer_M_SILENT_GLISS_INTERNATIONAL_LTD_:
		return "M_SILENT_GLISS_INTERNATIONAL_LTD_"
	case KnxManufacturer_M_BEE_CONTROLS_ADGSC_GROUP:
		return "M_BEE_CONTROLS_ADGSC_GROUP"
	case KnxManufacturer_M_XDTECGMBH:
		return "M_XDTECGMBH"
	case KnxManufacturer_M_OSRAM:
		return "M_OSRAM"
	case KnxManufacturer_M_LEBENOR:
		return "M_LEBENOR"
	case KnxManufacturer_M_AUTOMANENG:
		return "M_AUTOMANENG"
	case KnxManufacturer_M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD:
		return "M_HONEYWELL_AUTOMATION_CONTROL_SOLUTIONSCHINACOLTD"
	case KnxManufacturer_M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD:
		return "M_HANGZHOU_BINTHEN_INTELLIGENCE_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_ETA_HEIZTECHNIK:
		return "M_ETA_HEIZTECHNIK"
	case KnxManufacturer_M_SOMFY:
		return "M_SOMFY"
	case KnxManufacturer_M_DIVUS_GMBH:
		return "M_DIVUS_GMBH"
	case KnxManufacturer_M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_:
		return "M_NANJING_TAIJIESAI_INTELLIGENT_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_LUNATONE:
		return "M_LUNATONE"
	case KnxManufacturer_M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT:
		return "M_ZHEJIANG_SCTECH_BUILDING_INTELLIGENT"
	case KnxManufacturer_M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_:
		return "M_FOSHAN_QITE_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_NOKE:
		return "M_NOKE"
	case KnxManufacturer_M_LANDCOM:
		return "M_LANDCOM"
	case KnxManufacturer_M_STORK_AS:
		return "M_STORK_AS"
	case KnxManufacturer_M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_:
		return "M_HANGZHOU_SHENDU_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_COOLAUTOMATION:
		return "M_COOLAUTOMATION"
	case KnxManufacturer_M_WOERTZ:
		return "M_WOERTZ"
	case KnxManufacturer_M_APRSTERN:
		return "M_APRSTERN"
	case KnxManufacturer_M_SONNEN:
		return "M_SONNEN"
	case KnxManufacturer_M_DNAKE:
		return "M_DNAKE"
	case KnxManufacturer_M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH:
		return "M_NEUBERGER_GEBAEUDEAUTOMATION_GMBH"
	case KnxManufacturer_M_STILIGER:
		return "M_STILIGER"
	case KnxManufacturer_M_BERGHOF_AUTOMATION_GMBH:
		return "M_BERGHOF_AUTOMATION_GMBH"
	case KnxManufacturer_M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH:
		return "M_TOTAL_AUTOMATION_AND_CONTROLS_GMBH"
	case KnxManufacturer_M_DOVIT:
		return "M_DOVIT"
	case KnxManufacturer_M_INSTALIGHTING_GMBH:
		return "M_INSTALIGHTING_GMBH"
	case KnxManufacturer_M_UNI_TEC:
		return "M_UNI_TEC"
	case KnxManufacturer_M_VIESSMANN_WERKE:
		return "M_VIESSMANN_WERKE"
	case KnxManufacturer_M_CASATUNES:
		return "M_CASATUNES"
	case KnxManufacturer_M_EMT:
		return "M_EMT"
	case KnxManufacturer_M_SENFFICIENT:
		return "M_SENFFICIENT"
	case KnxManufacturer_M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED:
		return "M_AUROLITE_ELECTRICAL_PANYU_GUANGZHOU_LIMITED"
	case KnxManufacturer_M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_:
		return "M_ABB_XIAMEN_SMART_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_SAMSON_ELECTRIC_WIRE:
		return "M_SAMSON_ELECTRIC_WIRE"
	case KnxManufacturer_M_T_TOUCHING:
		return "M_T_TOUCHING"
	case KnxManufacturer_M_CORE_SMART_HOME:
		return "M_CORE_SMART_HOME"
	case KnxManufacturer_M_GREENCONNECT_SOLUTIONS_SA:
		return "M_GREENCONNECT_SOLUTIONS_SA"
	case KnxManufacturer_M_ELETTRONICA_CONDUTTORI:
		return "M_ELETTRONICA_CONDUTTORI"
	case KnxManufacturer_M_BERKER:
		return "M_BERKER"
	case KnxManufacturer_M_IMI_HYDRONIC_ENGINEERING:
		return "M_IMI_HYDRONIC_ENGINEERING"
	case KnxManufacturer_M_MKFC:
		return "M_MKFC"
	case KnxManufacturer_M_AUTOMATIONPlus:
		return "M_AUTOMATIONPlus"
	case KnxManufacturer_M_BLUE_AND_RED:
		return "M_BLUE_AND_RED"
	case KnxManufacturer_M_FROGBLUE:
		return "M_FROGBLUE"
	case KnxManufacturer_M_LUXIO:
		return "M_LUXIO"
	case KnxManufacturer_M_APP_TECH:
		return "M_APP_TECH"
	case KnxManufacturer_M_SENSORTEC_AG:
		return "M_SENSORTEC_AG"
	case KnxManufacturer_M_NYSA_TECHNOLOGY_AND_SOLUTIONS:
		return "M_NYSA_TECHNOLOGY_AND_SOLUTIONS"
	case KnxManufacturer_M_FARADITE:
		return "M_FARADITE"
	case KnxManufacturer_M_OPTIMUS:
		return "M_OPTIMUS"
	case KnxManufacturer_M_JOH__VAILLANT:
		return "M_JOH__VAILLANT"
	case KnxManufacturer_M_KTS_S_R_L_:
		return "M_KTS_S_R_L_"
	case KnxManufacturer_M_RAMCRO_SPA:
		return "M_RAMCRO_SPA"
	case KnxManufacturer_M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD:
		return "M_WUHAN_WISECREATE_UNIVERSE_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_BEMI_SMART_HOME_LTD:
		return "M_BEMI_SMART_HOME_LTD"
	case KnxManufacturer_M_ARDOMUS:
		return "M_ARDOMUS"
	case KnxManufacturer_M_CHANGXING:
		return "M_CHANGXING"
	case KnxManufacturer_M_E_CONTROLS:
		return "M_E_CONTROLS"
	case KnxManufacturer_M_AIB_TECHNOLOGY:
		return "M_AIB_TECHNOLOGY"
	case KnxManufacturer_M_NVC:
		return "M_NVC"
	case KnxManufacturer_M_KBOX:
		return "M_KBOX"
	case KnxManufacturer_M_AMP_DEUTSCHLAND:
		return "M_AMP_DEUTSCHLAND"
	case KnxManufacturer_M_CNS:
		return "M_CNS"
	case KnxManufacturer_M_TYBA:
		return "M_TYBA"
	case KnxManufacturer_M_ATREL:
		return "M_ATREL"
	case KnxManufacturer_M_SIMON_ELECTRIC_CHINA_CO___LTD:
		return "M_SIMON_ELECTRIC_CHINA_CO___LTD"
	case KnxManufacturer_M_KORDZ_GROUP:
		return "M_KORDZ_GROUP"
	case KnxManufacturer_M_ND_ELECTRIC:
		return "M_ND_ELECTRIC"
	case KnxManufacturer_M_CONTROLIUM:
		return "M_CONTROLIUM"
	case KnxManufacturer_M_FAMO_GMBH_AND_CO__KG:
		return "M_FAMO_GMBH_AND_CO__KG"
	case KnxManufacturer_M_CDN_SMART:
		return "M_CDN_SMART"
	case KnxManufacturer_M_HESTON:
		return "M_HESTON"
	case KnxManufacturer_M_BOSCH_THERMOTECHNIK_GMBH:
		return "M_BOSCH_THERMOTECHNIK_GMBH"
	case KnxManufacturer_M_ESLA_CONEXIONES_S_L_:
		return "M_ESLA_CONEXIONES_S_L_"
	case KnxManufacturer_M_WEISHAUPT:
		return "M_WEISHAUPT"
	case KnxManufacturer_M_ASTRUM_TECHNOLOGY:
		return "M_ASTRUM_TECHNOLOGY"
	case KnxManufacturer_M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_:
		return "M_WUERTH_ELEKTRONIK_STELVIO_KONTEK_S_P_A_"
	case KnxManufacturer_M_NANOTECO_CORPORATION:
		return "M_NANOTECO_CORPORATION"
	case KnxManufacturer_M_NIETIAN:
		return "M_NIETIAN"
	case KnxManufacturer_M_SUMSIR:
		return "M_SUMSIR"
	case KnxManufacturer_M_ORBIS_TECNOLOGIA_ELECTRICA_SA:
		return "M_ORBIS_TECNOLOGIA_ELECTRICA_SA"
	case KnxManufacturer_M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_:
		return "M_NANJING_ZHONGYI_IOT_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_ANLIPS:
		return "M_ANLIPS"
	case KnxManufacturer_M_SEF___ECOTEC:
		return "M_SEF___ECOTEC"
	case KnxManufacturer_M_GUANGDONG_PAK_CORPORATION_CO___LTD:
		return "M_GUANGDONG_PAK_CORPORATION_CO___LTD"
	case KnxManufacturer_M_BVK_TECHNOLOGY:
		return "M_BVK_TECHNOLOGY"
	case KnxManufacturer_M_SOLOMIO_SRL:
		return "M_SOLOMIO_SRL"
	case KnxManufacturer_M_DOMOTICA_LABS:
		return "M_DOMOTICA_LABS"
	case KnxManufacturer_M_NVC_INTERNATIONAL:
		return "M_NVC_INTERNATIONAL"
	case KnxManufacturer_M_BA:
		return "M_BA"
	case KnxManufacturer_M_IRIS_CERAMICA_GROUP:
		return "M_IRIS_CERAMICA_GROUP"
	case KnxManufacturer_M_WIREEO:
		return "M_WIREEO"
	case KnxManufacturer_M_NVCLIGHTING:
		return "M_NVCLIGHTING"
	case KnxManufacturer_M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_:
		return "M_JINAN_TIAN_DA_SHENG_INFORMATION_TECHNOLOGY_CO_"
	case KnxManufacturer_M_DORMA_GMBH_Plus_CO__KG:
		return "M_DORMA_GMBH_Plus_CO__KG"
	case KnxManufacturer_M_ARMITI_TRADING:
		return "M_ARMITI_TRADING"
	case KnxManufacturer_M_ELEK:
		return "M_ELEK"
	case KnxManufacturer_M_ACCORDIA_SA:
		return "M_ACCORDIA_SA"
	case KnxManufacturer_M_OURICAN:
		return "M_OURICAN"
	case KnxManufacturer_M_INLIWOSE:
		return "M_INLIWOSE"
	case KnxManufacturer_M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_:
		return "M_BOSCH_SHANGHAI_SMART_LIFE_TECHNOLOGY_LTD_"
	case KnxManufacturer_M_SHK_KNX:
		return "M_SHK_KNX"
	case KnxManufacturer_M_AMPIO:
		return "M_AMPIO"
	case KnxManufacturer_M_MINGXING_WISDOM:
		return "M_MINGXING_WISDOM"
	case KnxManufacturer_M_ALTEN_SW_GMBH:
		return "M_ALTEN_SW_GMBH"
	case KnxManufacturer_M_WINDOWMASTER_AS:
		return "M_WINDOWMASTER_AS"
	case KnxManufacturer_M_V_Y_C_SRL:
		return "M_V_Y_C_SRL"
	case KnxManufacturer_M_TERMINUS_GROUP:
		return "M_TERMINUS_GROUP"
	case KnxManufacturer_M_WONDERFUL_CITY_TECHNOLOGY:
		return "M_WONDERFUL_CITY_TECHNOLOGY"
	case KnxManufacturer_M_QBICTECHNOLOGY:
		return "M_QBICTECHNOLOGY"
	case KnxManufacturer_M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED:
		return "M_EMBEDDED_AUTOMATION_EQUIPMENT_SHANGHAI_LIMITED"
	case KnxManufacturer_M_ONEWORK:
		return "M_ONEWORK"
	case KnxManufacturer_M_PL_LINK:
		return "M_PL_LINK"
	case KnxManufacturer_M_FASEL_GMBH_ELEKTRONIK:
		return "M_FASEL_GMBH_ELEKTRONIK"
	case KnxManufacturer_M_GOLDENHOME_SMART:
		return "M_GOLDENHOME_SMART"
	case KnxManufacturer_M_GOLDMEDAL:
		return "M_GOLDMEDAL"
	case KnxManufacturer_M_WALTHER_WERKE:
		return "M_WALTHER_WERKE"
	case KnxManufacturer_M_CannX:
		return "M_CannX"
	case KnxManufacturer_M_EGI___EARTH_GOODNESS:
		return "M_EGI___EARTH_GOODNESS"
	case KnxManufacturer_M_VIEGA_GMBH_AND_CO__KG:
		return "M_VIEGA_GMBH_AND_CO__KG"
	case KnxManufacturer_M_FREDON_DIGITAL_BUILDINGS:
		return "M_FREDON_DIGITAL_BUILDINGS"
	case KnxManufacturer_M_HELUKABEL_THAILAND_CO__LTD_:
		return "M_HELUKABEL_THAILAND_CO__LTD_"
	case KnxManufacturer_M_SICS:
		return "M_SICS"
	case KnxManufacturer_M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD:
		return "M_MEX_ELECTRIC_TECHNOLOGY_SHANGHAI_CO___LTD"
	case KnxManufacturer_M_SUMAMO:
		return "M_SUMAMO"
	case KnxManufacturer_M_SVIT:
		return "M_SVIT"
	case KnxManufacturer_M_TECGET:
		return "M_TECGET"
	case KnxManufacturer_M_ORAS:
		return "M_ORAS"
	case KnxManufacturer_M_XEROPOINT:
		return "M_XEROPOINT"
	case KnxManufacturer_M_HONEYWELL_BUILDING_TECHNOLOGIES:
		return "M_HONEYWELL_BUILDING_TECHNOLOGIES"
	case KnxManufacturer_M_COMFORTCLICK:
		return "M_COMFORTCLICK"
	case KnxManufacturer_M_DORBAS_ELECTRIC:
		return "M_DORBAS_ELECTRIC"
	case KnxManufacturer_M_REMKO_GMBH_AND_CO__KG:
		return "M_REMKO_GMBH_AND_CO__KG"
	case KnxManufacturer_M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD:
		return "M_SHENZHEN_CONGXUN_INTELLIGENT_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_ANDAS:
		return "M_ANDAS"
	case KnxManufacturer_M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD:
		return "M_HEFEI_CHUANG_YUE_INTELLIGENT_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_LARFE:
		return "M_LARFE"
	case KnxManufacturer_M_DONGGUAN_MUHCCI_ELECTRICAL:
		return "M_DONGGUAN_MUHCCI_ELECTRICAL"
	case KnxManufacturer_M_DAETWYLER:
		return "M_DAETWYLER"
	case KnxManufacturer_M_STEC:
		return "M_STEC"
	case KnxManufacturer_M_ARIGO_SOFTWARE_GMBH:
		return "M_ARIGO_SOFTWARE_GMBH"
	case KnxManufacturer_M_FEISHELEC:
		return "M_FEISHELEC"
	case KnxManufacturer_M_GORDIC:
		return "M_GORDIC"
	case KnxManufacturer_M_DELTA_ELECTRONICS:
		return "M_DELTA_ELECTRONICS"
	case KnxManufacturer_M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_:
		return "M_SHANGHAI_LEWIN_INTELLIGENT_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_KG_POWER:
		return "M_KG_POWER"
	case KnxManufacturer_M_ZHEJIANG_MOORGEN_GROUP_CO__LTD:
		return "M_ZHEJIANG_MOORGEN_GROUP_CO__LTD"
	case KnxManufacturer_M_GUANGDONG_KANWAY:
		return "M_GUANGDONG_KANWAY"
	case KnxManufacturer_M_RAMIREZ_ENGINEERING_GMBH:
		return "M_RAMIREZ_ENGINEERING_GMBH"
	case KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO:
		return "M_BUSCH_JAEGER_ELEKTRO"
	case KnxManufacturer_M_ELECTRAK:
		return "M_ELECTRAK"
	case KnxManufacturer_M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD:
		return "M_ZHONGSHAN_TAIYANG_IMPANDEXP__CO_LTD"
	case KnxManufacturer_M_VIHAN_ELECTRIC_PVT_LTD:
		return "M_VIHAN_ELECTRIC_PVT_LTD"
	case KnxManufacturer_M_SPLENDID_MINDS_GMBH:
		return "M_SPLENDID_MINDS_GMBH"
	case KnxManufacturer_M_ESTADA:
		return "M_ESTADA"
	case KnxManufacturer_M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI:
		return "M_ZHONGYUNXINZHIKONGGUJITUANYOUXIANGONGSI"
	case KnxManufacturer_M_STUHL_REGELSYSTEME_GMBH:
		return "M_STUHL_REGELSYSTEME_GMBH"
	case KnxManufacturer_M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD:
		return "M_SHENZHEN_GLUCK_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_GAIMEX:
		return "M_GAIMEX"
	case KnxManufacturer_M_B3_INTERNATIONAL_S_R_L:
		return "M_B3_INTERNATIONAL_S_R_L"
	case KnxManufacturer_M_MM_ELECTRO:
		return "M_MM_ELECTRO"
	case KnxManufacturer_M_TECHEM:
		return "M_TECHEM"
	case KnxManufacturer_M_CASCODA:
		return "M_CASCODA"
	case KnxManufacturer_M_XIAMEN_INTRETECH_INC_:
		return "M_XIAMEN_INTRETECH_INC_"
	case KnxManufacturer_M_KILOELEC_TECHNOLOGY:
		return "M_KILOELEC_TECHNOLOGY"
	case KnxManufacturer_M_INYX:
		return "M_INYX"
	case KnxManufacturer_M_SMART_BUILDING_SERVICES_GMBH:
		return "M_SMART_BUILDING_SERVICES_GMBH"
	case KnxManufacturer_M_BSS_GMBH:
		return "M_BSS_GMBH"
	case KnxManufacturer_M_LUMI_ELECTRONICS:
		return "M_LUMI_ELECTRONICS"
	case KnxManufacturer_M_OJEAELECTRONICS:
		return "M_OJEAELECTRONICS"
	case KnxManufacturer_M_SMART_NODE:
		return "M_SMART_NODE"
	case KnxManufacturer_M_NEXHOME:
		return "M_NEXHOME"
	case KnxManufacturer_M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS:
		return "M_SCHNEIDER_ELECTRIC_INDUSTRIES_SAS"
	case KnxManufacturer_M_HUOTENG_WULIAN_JIANGSU_CO___LTD:
		return "M_HUOTENG_WULIAN_JIANGSU_CO___LTD"
	case KnxManufacturer_M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD:
		return "M_RAYLOGIC_CONTROL_SYSTEMS_PVT_LTD"
	case KnxManufacturer_M_BITS_AND_BYTES:
		return "M_BITS_AND_BYTES"
	case KnxManufacturer_M_KFV_SIEGENIA_GRUPPE:
		return "M_KFV_SIEGENIA_GRUPPE"
	case KnxManufacturer_M_SYMCON:
		return "M_SYMCON"
	case KnxManufacturer_M_I_TRUST:
		return "M_I_TRUST"
	case KnxManufacturer_M_DRD_TECHNICS:
		return "M_DRD_TECHNICS"
	case KnxManufacturer_M_LENGEN:
		return "M_LENGEN"
	case KnxManufacturer_M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD:
		return "M_SHENZHEN_EXC_LED_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_VIBROXX_FZCO:
		return "M_VIBROXX_FZCO"
	case KnxManufacturer_M_WHD_WILHELM_HUBER_Plus_SOEHNE:
		return "M_WHD_WILHELM_HUBER_Plus_SOEHNE"
	case KnxManufacturer_M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD:
		return "M_SUZHOU_HONGYUN_INTELLIGENT_TECHNOLOGYCO___LTD"
	case KnxManufacturer_M_PASSIV_ENERGIE_GMBH:
		return "M_PASSIV_ENERGIE_GMBH"
	case KnxManufacturer_M_PAYNE_TECHNOLOGIES_LTD:
		return "M_PAYNE_TECHNOLOGIES_LTD"
	case KnxManufacturer_M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_:
		return "M_GUANGDONG_YOZEWIT_INTELLIGENT_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_SEXANKA:
		return "M_SEXANKA"
	case KnxManufacturer_M_SECURI_FLEX_LTD:
		return "M_SECURI_FLEX_LTD"
	case KnxManufacturer_M_BOKE:
		return "M_BOKE"
	case KnxManufacturer_M_SBR_SYSTEM_TECHNICAL:
		return "M_SBR_SYSTEM_TECHNICAL"
	case KnxManufacturer_M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_:
		return "M_SHENZHEN_EASTKAME_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_BOLATU:
		return "M_BOLATU"
	case KnxManufacturer_M_BISCHOFF_ELEKTRONIK:
		return "M_BISCHOFF_ELEKTRONIK"
	case KnxManufacturer_M_RECBER_KABLO_A_S_:
		return "M_RECBER_KABLO_A_S_"
	case KnxManufacturer_M_ILITE_KNX:
		return "M_ILITE_KNX"
	case KnxManufacturer_M_LAZZEN:
		return "M_LAZZEN"
	case KnxManufacturer_M_MOX_CONTROL_IT_CHINA_LIMITED:
		return "M_MOX_CONTROL_IT_CHINA_LIMITED"
	case KnxManufacturer_M_CLOWIRE:
		return "M_CLOWIRE"
	case KnxManufacturer_M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD:
		return "M_NINGBO_QIYUAN_LIGHTING_TECH_CO__LTD"
	case KnxManufacturer_M_NS_TOUCH:
		return "M_NS_TOUCH"
	case KnxManufacturer_M_ROOMIO:
		return "M_ROOMIO"
	case KnxManufacturer_M_ATOUCH:
		return "M_ATOUCH"
	case KnxManufacturer_M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD:
		return "M_PANASONIC_LIFE_SOLUTIONS_INDIA_PVT__LTD"
	case KnxManufacturer_M_JEPAZ:
		return "M_JEPAZ"
	case KnxManufacturer_M_WALLYONS:
		return "M_WALLYONS"
	case KnxManufacturer_M_ZIMMEX:
		return "M_ZIMMEX"
	case KnxManufacturer_M_RHOMBUS_EUROPE:
		return "M_RHOMBUS_EUROPE"
	case KnxManufacturer_M_TURING_THINK:
		return "M_TURING_THINK"
	case KnxManufacturer_M_MICHOI:
		return "M_MICHOI"
	case KnxManufacturer_M_CAV_SMARTGUANGZHOUCO__LTD:
		return "M_CAV_SMARTGUANGZHOUCO__LTD"
	case KnxManufacturer_M_HELKAMA_BICA_OY:
		return "M_HELKAMA_BICA_OY"
	case KnxManufacturer_M_MODULYTE:
		return "M_MODULYTE"
	case KnxManufacturer_M_CONSOLINNO_ENERGY_GMBH:
		return "M_CONSOLINNO_ENERGY_GMBH"
	case KnxManufacturer_M_SCHIDERON_ELECTRIC_ASIA_LIMITED:
		return "M_SCHIDERON_ELECTRIC_ASIA_LIMITED"
	case KnxManufacturer_M_RTS_AUTOMATION:
		return "M_RTS_AUTOMATION"
	case KnxManufacturer_M_3R:
		return "M_3R"
	case KnxManufacturer_M_ARKLYFE:
		return "M_ARKLYFE"
	case KnxManufacturer_M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_:
		return "M_FOSHAN_HAYDN_TECHNOLOGY_LIGHTING_CO__LTD_"
	case KnxManufacturer_M_KNXES_COMPANY_LIMITED:
		return "M_KNXES_COMPANY_LIMITED"
	case KnxManufacturer_M_AKUVOX:
		return "M_AKUVOX"
	case KnxManufacturer_M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_:
		return "M_NINGBO_YINZHOU_SHENGRUIJIE_ELECTRONICS_CO__LTD_"
	case KnxManufacturer_M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD:
		return "M_SHENZHEN_HAIZHICHUANG_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD:
		return "M_SHENZHEN_EASYDETEK_TECHNOLOGY_CO_LTD"
	case KnxManufacturer_M_MUTLUSAN_ELECTRIC:
		return "M_MUTLUSAN_ELECTRIC"
	case KnxManufacturer_M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_:
		return "M_HANGZHOU_BROADLINK_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_EIBMARKT_GMBH:
		return "M_EIBMARKT_GMBH"
	case KnxManufacturer_M_MARLEY_DEUTSCHLAND_GMBH:
		return "M_MARLEY_DEUTSCHLAND_GMBH"
	case KnxManufacturer_M_CREATROL:
		return "M_CREATROL"
	case KnxManufacturer_M_EUTELSAT:
		return "M_EUTELSAT"
	case KnxManufacturer_M_TECNIKABEL:
		return "M_TECNIKABEL"
	case KnxManufacturer_M_ATIOS_AG:
		return "M_ATIOS_AG"
	case KnxManufacturer_M_SMARTLICHT:
		return "M_SMARTLICHT"
	case KnxManufacturer_M_BEIJING_BEVONE_ELECTRIC_CO__LTD_:
		return "M_BEIJING_BEVONE_ELECTRIC_CO__LTD_"
	case KnxManufacturer_M_ELSMART:
		return "M_ELSMART"
	case KnxManufacturer_M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC:
		return "M_MIDDLE_EAST_SPECIALIZED_CABLES_CO__MESC"
	case KnxManufacturer_M_HANGZHOU_SANYUAN_CABLE_CO___LTD:
		return "M_HANGZHOU_SANYUAN_CABLE_CO___LTD"
	case KnxManufacturer_M_WAREMA_RENKHOFF_SE:
		return "M_WAREMA_RENKHOFF_SE"
	case KnxManufacturer_M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_:
		return "M_BEIJING_HAILIN_CONTROL_TECHNOLOGY_INC_"
	case KnxManufacturer_M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_:
		return "M_HANGZHOU_SNOWYI_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD:
		return "M_XIAMEN_E_TOP_CONTROLS_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_VITRUM_DESIGN:
		return "M_VITRUM_DESIGN"
	case KnxManufacturer_M_DETRONS:
		return "M_DETRONS"
	case KnxManufacturer_M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD:
		return "M_ZHEJIANG_FORICK__INTELLIGENT_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_VARNI_DIGITAL_PRIVATE_LIMITED:
		return "M_VARNI_DIGITAL_PRIVATE_LIMITED"
	case KnxManufacturer_M_3A_ENTREPRISE_APS:
		return "M_3A_ENTREPRISE_APS"
	case KnxManufacturer_M_ITALIANA_CONDUTTORI_SRL:
		return "M_ITALIANA_CONDUTTORI_SRL"
	case KnxManufacturer_M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_:
		return "M_XIAMEN_LEELEN_TECHNOLOGY_CO__LTD_"
	case KnxManufacturer_M_EELECTRON:
		return "M_EELECTRON"
	case KnxManufacturer_M_LEDNX:
		return "M_LEDNX"
	case KnxManufacturer_M_EBELONG:
		return "M_EBELONG"
	case KnxManufacturer_M_ASTRA_LED_AG:
		return "M_ASTRA_LED_AG"
	case KnxManufacturer_M_WONDERFUL_HI_TECH_CO___LTD_:
		return "M_WONDERFUL_HI_TECH_CO___LTD_"
	case KnxManufacturer_M_REXLITE_AI_INTEGRATIONS_CO__LTD:
		return "M_REXLITE_AI_INTEGRATIONS_CO__LTD"
	case KnxManufacturer_M_ALLORADO:
		return "M_ALLORADO"
	case KnxManufacturer_M_FUZHOU_MILI_TECHNOLOGY_CO___LTD:
		return "M_FUZHOU_MILI_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD:
		return "M_MAXTREEN_BUILDING_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_HYSINE:
		return "M_HYSINE"
	case KnxManufacturer_M_SANTAN:
		return "M_SANTAN"
	case KnxManufacturer_M_GIRA_GIERSIEPEN:
		return "M_GIRA_GIERSIEPEN"
	case KnxManufacturer_M_BELDEN_WIRE_AND_CABLE_B_V_:
		return "M_BELDEN_WIRE_AND_CABLE_B_V_"
	case KnxManufacturer_M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD:
		return "M_HUIXIANGJU_IOT_TECHNOLOGY_SHANGHAI_CO___LTD"
	case KnxManufacturer_M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD:
		return "M_SHANGHAI_BENKONG_ELECTRONIC_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_POLAR_BEAR_DESIGN:
		return "M_POLAR_BEAR_DESIGN"
	case KnxManufacturer_M_ELESSAN_NV:
		return "M_ELESSAN_NV"
	case KnxManufacturer_M_MIR:
		return "M_MIR"
	case KnxManufacturer_M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD:
		return "M_ZHEJIANG_MISILIN_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_LEAX_CONTROLS_CO___LTD_:
		return "M_LEAX_CONTROLS_CO___LTD_"
	case KnxManufacturer_M_ALCAD:
		return "M_ALCAD"
	case KnxManufacturer_M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD:
		return "M_GUANG_DONG_REMAC_SMART_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_TAOS_ELECTRIC_CO___LTD:
		return "M_TAOS_ELECTRIC_CO___LTD"
	case KnxManufacturer_M_BECKER_ANTRIEBE_GMBH:
		return "M_BECKER_ANTRIEBE_GMBH"
	case KnxManufacturer_M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION:
		return "M_KONSTANTIN_BOBIC_SYSTEMINTEGRATION"
	case KnxManufacturer_M_ASAY_Q:
		return "M_ASAY_Q"
	case KnxManufacturer_M_LAPP:
		return "M_LAPP"
	case KnxManufacturer_M_ZEROBIT_DYNAMIC:
		return "M_ZEROBIT_DYNAMIC"
	case KnxManufacturer_M_HAVELLS:
		return "M_HAVELLS"
	case KnxManufacturer_M_MULLER_INTUITIV:
		return "M_MULLER_INTUITIV"
	case KnxManufacturer_M_TASKIT_GMBH:
		return "M_TASKIT_GMBH"
	case KnxManufacturer_M_COSTER_GROUP:
		return "M_COSTER_GROUP"
	case KnxManufacturer_M_NXP_SEMICONDUCTOR:
		return "M_NXP_SEMICONDUCTOR"
	case KnxManufacturer_M_COGCONS:
		return "M_COGCONS"
	case KnxManufacturer_M_J_STEHLEPlusSOEHNE_GMBH:
		return "M_J_STEHLEPlusSOEHNE_GMBH"
	case KnxManufacturer_M_MICRO_TEK_SRL_F_M_C_TRADE_MARK:
		return "M_MICRO_TEK_SRL_F_M_C_TRADE_MARK"
	case KnxManufacturer_M_ORENDA_ELECTRIC:
		return "M_ORENDA_ELECTRIC"
	case KnxManufacturer_M_ERSE_KABLO:
		return "M_ERSE_KABLO"
	case KnxManufacturer_M_PRADO_EUROPE_BV:
		return "M_PRADO_EUROPE_BV"
	case KnxManufacturer_M_E2S_GBR:
		return "M_E2S_GBR"
	case KnxManufacturer_M_UNITLINK:
		return "M_UNITLINK"
	case KnxManufacturer_M_ONNA:
		return "M_ONNA"
	case KnxManufacturer_M_CENTERSVET_LLC:
		return "M_CENTERSVET_LLC"
	case KnxManufacturer_M_ADVECO_TECHNOLOGY_CO___LTD_:
		return "M_ADVECO_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_FR__LUERSSEN_WERFT:
		return "M_FR__LUERSSEN_WERFT"
	case KnxManufacturer_M_AGFEO:
		return "M_AGFEO"
	case KnxManufacturer_M_MYLYR:
		return "M_MYLYR"
	case KnxManufacturer_M_HYUNDAI_HT:
		return "M_HYUNDAI_HT"
	case KnxManufacturer_M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD:
		return "M_GUANGDONG_YUEJINGRUN_TECHNOLOGY_CO__LTD"
	case KnxManufacturer_M_SMATEK_ELECTRONICS_LIMITED:
		return "M_SMATEK_ELECTRONICS_LIMITED"
	case KnxManufacturer_M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_:
		return "M_ANYTEK_ELECTRONIC_TECHNOLOGY_SZ_CO___LTD_"
	case KnxManufacturer_M_MORELINKS_SMART_HOME:
		return "M_MORELINKS_SMART_HOME"
	case KnxManufacturer_M_CIRTX_GMBH:
		return "M_CIRTX_GMBH"
	case KnxManufacturer_M_QLITE:
		return "M_QLITE"
	case KnxManufacturer_M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD:
		return "M_ZHONGSHAN_ILLUS_LIGHTING_CO__LTD"
	case KnxManufacturer_M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_:
		return "M_HANGZHOU_KONKE_INFORMATION_TECHNOLOGY_CO___LTD_"
	case KnxManufacturer_M_ZENNIO:
		return "M_ZENNIO"
	case KnxManufacturer_M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD:
		return "M_SHANGHAI_FANTE_DIGITAL_TECHNOLOGY_CO___LTD"
	case KnxManufacturer_M_CONFIO:
		return "M_CONFIO"
	case KnxManufacturer_M_SONIC_TECHNOLOGIES:
		return "M_SONIC_TECHNOLOGIES"
	case KnxManufacturer_M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT:
		return "M_SHANGHAI_INNOVATECH_INFORMATION_TECHNOLOGY_CO___LT"
	case KnxManufacturer_M_ABI_SICHERHEITSSYSTEME_GMBH:
		return "M_ABI_SICHERHEITSSYSTEME_GMBH"
	case KnxManufacturer_M_RYT:
		return "M_RYT"
	case KnxManufacturer_M_AURIGA_SYSTEMS:
		return "M_AURIGA_SYSTEMS"
	case KnxManufacturer_M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH:
		return "M_ALZINGERANDVOGEL_SOFTWAREENTWICKLUNGS_GMBH"
	case KnxManufacturer_M_GIANFRANCO_SMART_SOLUTIONS_LTD:
		return "M_GIANFRANCO_SMART_SOLUTIONS_LTD"
	case KnxManufacturer_M_ROGERWELL_CONTROL_SYSTEM_LIMITED:
		return "M_ROGERWELL_CONTROL_SYSTEM_LIMITED"
	case KnxManufacturer_M_TAPKO_TECHNOLOGIES:
		return "M_TAPKO_TECHNOLOGIES"
	case KnxManufacturer_M_ABB___RESERVED:
		return "M_ABB___RESERVED"
	case KnxManufacturer_M_BUSCH_JAEGER_ELEKTRO___RESERVED:
		return "M_BUSCH_JAEGER_ELEKTRO___RESERVED"
	case KnxManufacturer_M_HDL:
		return "M_HDL"
	case KnxManufacturer_M_UPONOR:
		return "M_UPONOR"
	case KnxManufacturer_M_SE_LIGHTMANAGEMENT_AG:
		return "M_SE_LIGHTMANAGEMENT_AG"
	case KnxManufacturer_M_ARCUS_EDS:
		return "M_ARCUS_EDS"
	case KnxManufacturer_M_HAGER_ELECTRO:
		return "M_HAGER_ELECTRO"
	case KnxManufacturer_M_INTESIS:
		return "M_INTESIS"
	case KnxManufacturer_M_HERHOLDT_CONTROLS_SRL:
		return "M_HERHOLDT_CONTROLS_SRL"
	case KnxManufacturer_M_NIKO_ZUBLIN:
		return "M_NIKO_ZUBLIN"
	case KnxManufacturer_M_DURABLE_TECHNOLOGIES:
		return "M_DURABLE_TECHNOLOGIES"
	case KnxManufacturer_M_INNOTEAM:
		return "M_INNOTEAM"
	case KnxManufacturer_M_ISE_GMBH:
		return "M_ISE_GMBH"
	case KnxManufacturer_M_TEAM_FOR_TRONICS:
		return "M_TEAM_FOR_TRONICS"
	case KnxManufacturer_M_CARRIER_SAS:
		return "M_CARRIER_SAS"
	case KnxManufacturer_M_REMEHA_BV:
		return "M_REMEHA_BV"
	case KnxManufacturer_M_ESYLUX:
		return "M_ESYLUX"
	case KnxManufacturer_M_INSTA_GMBH:
		return "M_INSTA_GMBH"
	case KnxManufacturer_M_BASALTE:
		return "M_BASALTE"
	case KnxManufacturer_M_VESTAMATIC:
		return "M_VESTAMATIC"
	case KnxManufacturer_M_MDT_TECHNOLOGIES:
		return "M_MDT_TECHNOLOGIES"
	case KnxManufacturer_M_WARENDORFER_KUECHEN_GMBH:
		return "M_WARENDORFER_KUECHEN_GMBH"
	case KnxManufacturer_M_GVS:
		return "M_GVS"
	case KnxManufacturer_M_SITEK:
		return "M_SITEK"
	case KnxManufacturer_M_CONTROLTRONIC:
		return "M_CONTROLTRONIC"
	case KnxManufacturer_M_FUNCTION_TECHNOLOGY:
		return "M_FUNCTION_TECHNOLOGY"
	case KnxManufacturer_M_AMX:
		return "M_AMX"
	case KnxManufacturer_M_ELDAT:
		return "M_ELDAT"
	}
	return fmt.Sprintf("Unknown(%v)", uint16(e))
}

func (e KnxManufacturer) String() string {
	return e.PLC4XEnumName()
}
