/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// KnxGroupAddress3Level is the corresponding interface of KnxGroupAddress3Level
type KnxGroupAddress3Level interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	KnxGroupAddress
	// GetMainGroup returns MainGroup (property field)
	GetMainGroup() uint8
	// GetMiddleGroup returns MiddleGroup (property field)
	GetMiddleGroup() uint8
	// GetSubGroup returns SubGroup (property field)
	GetSubGroup() uint8
	// IsKnxGroupAddress3Level is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsKnxGroupAddress3Level()
	// CreateBuilder creates a KnxGroupAddress3LevelBuilder
	CreateKnxGroupAddress3LevelBuilder() KnxGroupAddress3LevelBuilder
}

// _KnxGroupAddress3Level is the data-structure of this message
type _KnxGroupAddress3Level struct {
	KnxGroupAddressContract
	MainGroup   uint8
	MiddleGroup uint8
	SubGroup    uint8
}

var _ KnxGroupAddress3Level = (*_KnxGroupAddress3Level)(nil)
var _ KnxGroupAddressRequirements = (*_KnxGroupAddress3Level)(nil)

// NewKnxGroupAddress3Level factory function for _KnxGroupAddress3Level
func NewKnxGroupAddress3Level(mainGroup uint8, middleGroup uint8, subGroup uint8) *_KnxGroupAddress3Level {
	_result := &_KnxGroupAddress3Level{
		KnxGroupAddressContract: NewKnxGroupAddress(),
		MainGroup:               mainGroup,
		MiddleGroup:             middleGroup,
		SubGroup:                subGroup,
	}
	_result.KnxGroupAddressContract.(*_KnxGroupAddress)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// KnxGroupAddress3LevelBuilder is a builder for KnxGroupAddress3Level
type KnxGroupAddress3LevelBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(mainGroup uint8, middleGroup uint8, subGroup uint8) KnxGroupAddress3LevelBuilder
	// WithMainGroup adds MainGroup (property field)
	WithMainGroup(uint8) KnxGroupAddress3LevelBuilder
	// WithMiddleGroup adds MiddleGroup (property field)
	WithMiddleGroup(uint8) KnxGroupAddress3LevelBuilder
	// WithSubGroup adds SubGroup (property field)
	WithSubGroup(uint8) KnxGroupAddress3LevelBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() KnxGroupAddressBuilder
	// Build builds the KnxGroupAddress3Level or returns an error if something is wrong
	Build() (KnxGroupAddress3Level, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() KnxGroupAddress3Level
}

// NewKnxGroupAddress3LevelBuilder() creates a KnxGroupAddress3LevelBuilder
func NewKnxGroupAddress3LevelBuilder() KnxGroupAddress3LevelBuilder {
	return &_KnxGroupAddress3LevelBuilder{_KnxGroupAddress3Level: new(_KnxGroupAddress3Level)}
}

type _KnxGroupAddress3LevelBuilder struct {
	*_KnxGroupAddress3Level

	parentBuilder *_KnxGroupAddressBuilder

	err *utils.MultiError
}

var _ (KnxGroupAddress3LevelBuilder) = (*_KnxGroupAddress3LevelBuilder)(nil)

func (b *_KnxGroupAddress3LevelBuilder) setParent(contract KnxGroupAddressContract) {
	b.KnxGroupAddressContract = contract
	contract.(*_KnxGroupAddress)._SubType = b._KnxGroupAddress3Level
}

func (b *_KnxGroupAddress3LevelBuilder) WithMandatoryFields(mainGroup uint8, middleGroup uint8, subGroup uint8) KnxGroupAddress3LevelBuilder {
	return b.WithMainGroup(mainGroup).WithMiddleGroup(middleGroup).WithSubGroup(subGroup)
}

func (b *_KnxGroupAddress3LevelBuilder) WithMainGroup(mainGroup uint8) KnxGroupAddress3LevelBuilder {
	b.MainGroup = mainGroup
	return b
}

func (b *_KnxGroupAddress3LevelBuilder) WithMiddleGroup(middleGroup uint8) KnxGroupAddress3LevelBuilder {
	b.MiddleGroup = middleGroup
	return b
}

func (b *_KnxGroupAddress3LevelBuilder) WithSubGroup(subGroup uint8) KnxGroupAddress3LevelBuilder {
	b.SubGroup = subGroup
	return b
}

func (b *_KnxGroupAddress3LevelBuilder) Build() (KnxGroupAddress3Level, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._KnxGroupAddress3Level.deepCopy(), nil
}

func (b *_KnxGroupAddress3LevelBuilder) MustBuild() KnxGroupAddress3Level {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_KnxGroupAddress3LevelBuilder) Done() KnxGroupAddressBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewKnxGroupAddressBuilder().(*_KnxGroupAddressBuilder)
	}
	return b.parentBuilder
}

func (b *_KnxGroupAddress3LevelBuilder) buildForKnxGroupAddress() (KnxGroupAddress, error) {
	return b.Build()
}

func (b *_KnxGroupAddress3LevelBuilder) DeepCopy() any {
	_copy := b.CreateKnxGroupAddress3LevelBuilder().(*_KnxGroupAddress3LevelBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateKnxGroupAddress3LevelBuilder creates a KnxGroupAddress3LevelBuilder
func (b *_KnxGroupAddress3Level) CreateKnxGroupAddress3LevelBuilder() KnxGroupAddress3LevelBuilder {
	if b == nil {
		return NewKnxGroupAddress3LevelBuilder()
	}
	return &_KnxGroupAddress3LevelBuilder{_KnxGroupAddress3Level: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_KnxGroupAddress3Level) GetNumLevels() uint8 {
	return uint8(3)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_KnxGroupAddress3Level) GetParent() KnxGroupAddressContract {
	return m.KnxGroupAddressContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_KnxGroupAddress3Level) GetMainGroup() uint8 {
	return m.MainGroup
}

func (m *_KnxGroupAddress3Level) GetMiddleGroup() uint8 {
	return m.MiddleGroup
}

func (m *_KnxGroupAddress3Level) GetSubGroup() uint8 {
	return m.SubGroup
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastKnxGroupAddress3Level(structType any) KnxGroupAddress3Level {
	if casted, ok := structType.(KnxGroupAddress3Level); ok {
		return casted
	}
	if casted, ok := structType.(*KnxGroupAddress3Level); ok {
		return *casted
	}
	return nil
}

func (m *_KnxGroupAddress3Level) GetTypeName() string {
	return "KnxGroupAddress3Level"
}

func (m *_KnxGroupAddress3Level) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.KnxGroupAddressContract.(*_KnxGroupAddress).getLengthInBits(ctx))

	// Simple field (mainGroup)
	lengthInBits += 5

	// Simple field (middleGroup)
	lengthInBits += 3

	// Simple field (subGroup)
	lengthInBits += 8

	return lengthInBits
}

func (m *_KnxGroupAddress3Level) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_KnxGroupAddress3Level) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_KnxGroupAddress, numLevels uint8) (__knxGroupAddress3Level KnxGroupAddress3Level, err error) {
	m.KnxGroupAddressContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("KnxGroupAddress3Level"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for KnxGroupAddress3Level")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	mainGroup, err := ReadSimpleField(ctx, "mainGroup", ReadUnsignedByte(readBuffer, uint8(5)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'mainGroup' field"))
	}
	m.MainGroup = mainGroup

	middleGroup, err := ReadSimpleField(ctx, "middleGroup", ReadUnsignedByte(readBuffer, uint8(3)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'middleGroup' field"))
	}
	m.MiddleGroup = middleGroup

	subGroup, err := ReadSimpleField(ctx, "subGroup", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subGroup' field"))
	}
	m.SubGroup = subGroup

	if closeErr := readBuffer.CloseContext("KnxGroupAddress3Level"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for KnxGroupAddress3Level")
	}

	return m, nil
}

func (m *_KnxGroupAddress3Level) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_KnxGroupAddress3Level) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("KnxGroupAddress3Level"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for KnxGroupAddress3Level")
		}

		if err := WriteSimpleField[uint8](ctx, "mainGroup", m.GetMainGroup(), WriteUnsignedByte(writeBuffer, 5)); err != nil {
			return errors.Wrap(err, "Error serializing 'mainGroup' field")
		}

		if err := WriteSimpleField[uint8](ctx, "middleGroup", m.GetMiddleGroup(), WriteUnsignedByte(writeBuffer, 3)); err != nil {
			return errors.Wrap(err, "Error serializing 'middleGroup' field")
		}

		if err := WriteSimpleField[uint8](ctx, "subGroup", m.GetSubGroup(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'subGroup' field")
		}

		if popErr := writeBuffer.PopContext("KnxGroupAddress3Level"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for KnxGroupAddress3Level")
		}
		return nil
	}
	return m.KnxGroupAddressContract.(*_KnxGroupAddress).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_KnxGroupAddress3Level) IsKnxGroupAddress3Level() {}

func (m *_KnxGroupAddress3Level) DeepCopy() any {
	return m.deepCopy()
}

func (m *_KnxGroupAddress3Level) deepCopy() *_KnxGroupAddress3Level {
	if m == nil {
		return nil
	}
	_KnxGroupAddress3LevelCopy := &_KnxGroupAddress3Level{
		m.KnxGroupAddressContract.(*_KnxGroupAddress).deepCopy(),
		m.MainGroup,
		m.MiddleGroup,
		m.SubGroup,
	}
	_KnxGroupAddress3LevelCopy.KnxGroupAddressContract.(*_KnxGroupAddress)._SubType = m
	return _KnxGroupAddress3LevelCopy
}

func (m *_KnxGroupAddress3Level) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
