/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DeviceStatus is the corresponding interface of DeviceStatus
type DeviceStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetProgramMode returns ProgramMode (property field)
	GetProgramMode() bool
	// IsDeviceStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDeviceStatus()
	// CreateBuilder creates a DeviceStatusBuilder
	CreateDeviceStatusBuilder() DeviceStatusBuilder
}

// _DeviceStatus is the data-structure of this message
type _DeviceStatus struct {
	ProgramMode bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ DeviceStatus = (*_DeviceStatus)(nil)

// NewDeviceStatus factory function for _DeviceStatus
func NewDeviceStatus(programMode bool) *_DeviceStatus {
	return &_DeviceStatus{ProgramMode: programMode}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DeviceStatusBuilder is a builder for DeviceStatus
type DeviceStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(programMode bool) DeviceStatusBuilder
	// WithProgramMode adds ProgramMode (property field)
	WithProgramMode(bool) DeviceStatusBuilder
	// Build builds the DeviceStatus or returns an error if something is wrong
	Build() (DeviceStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DeviceStatus
}

// NewDeviceStatusBuilder() creates a DeviceStatusBuilder
func NewDeviceStatusBuilder() DeviceStatusBuilder {
	return &_DeviceStatusBuilder{_DeviceStatus: new(_DeviceStatus)}
}

type _DeviceStatusBuilder struct {
	*_DeviceStatus

	err *utils.MultiError
}

var _ (DeviceStatusBuilder) = (*_DeviceStatusBuilder)(nil)

func (b *_DeviceStatusBuilder) WithMandatoryFields(programMode bool) DeviceStatusBuilder {
	return b.WithProgramMode(programMode)
}

func (b *_DeviceStatusBuilder) WithProgramMode(programMode bool) DeviceStatusBuilder {
	b.ProgramMode = programMode
	return b
}

func (b *_DeviceStatusBuilder) Build() (DeviceStatus, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._DeviceStatus.deepCopy(), nil
}

func (b *_DeviceStatusBuilder) MustBuild() DeviceStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DeviceStatusBuilder) DeepCopy() any {
	_copy := b.CreateDeviceStatusBuilder().(*_DeviceStatusBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateDeviceStatusBuilder creates a DeviceStatusBuilder
func (b *_DeviceStatus) CreateDeviceStatusBuilder() DeviceStatusBuilder {
	if b == nil {
		return NewDeviceStatusBuilder()
	}
	return &_DeviceStatusBuilder{_DeviceStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DeviceStatus) GetProgramMode() bool {
	return m.ProgramMode
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDeviceStatus(structType any) DeviceStatus {
	if casted, ok := structType.(DeviceStatus); ok {
		return casted
	}
	if casted, ok := structType.(*DeviceStatus); ok {
		return *casted
	}
	return nil
}

func (m *_DeviceStatus) GetTypeName() string {
	return "DeviceStatus"
}

func (m *_DeviceStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (programMode)
	lengthInBits += 1

	return lengthInBits
}

func (m *_DeviceStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DeviceStatusParse(ctx context.Context, theBytes []byte) (DeviceStatus, error) {
	return DeviceStatusParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func DeviceStatusParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (DeviceStatus, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (DeviceStatus, error) {
		return DeviceStatusParseWithBuffer(ctx, readBuffer)
	}
}

func DeviceStatusParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (DeviceStatus, error) {
	v, err := (&_DeviceStatus{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_DeviceStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__deviceStatus DeviceStatus, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DeviceStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DeviceStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	programMode, err := ReadSimpleField(ctx, "programMode", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'programMode' field"))
	}
	m.ProgramMode = programMode

	if closeErr := readBuffer.CloseContext("DeviceStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DeviceStatus")
	}

	return m, nil
}

func (m *_DeviceStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DeviceStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("DeviceStatus"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for DeviceStatus")
	}

	if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "programMode", m.GetProgramMode(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'programMode' field")
	}

	if popErr := writeBuffer.PopContext("DeviceStatus"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for DeviceStatus")
	}
	return nil
}

func (m *_DeviceStatus) IsDeviceStatus() {}

func (m *_DeviceStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DeviceStatus) deepCopy() *_DeviceStatus {
	if m == nil {
		return nil
	}
	_DeviceStatusCopy := &_DeviceStatus{
		m.ProgramMode,
		m.reservedField0,
	}
	return _DeviceStatusCopy
}

func (m *_DeviceStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
