/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataOther is the corresponding interface of ApduDataOther
type ApduDataOther interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduData
	// GetExtendedApdu returns ExtendedApdu (property field)
	GetExtendedApdu() ApduDataExt
	// IsApduDataOther is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataOther()
	// CreateBuilder creates a ApduDataOtherBuilder
	CreateApduDataOtherBuilder() ApduDataOtherBuilder
}

// _ApduDataOther is the data-structure of this message
type _ApduDataOther struct {
	ApduDataContract
	ExtendedApdu ApduDataExt
}

var _ ApduDataOther = (*_ApduDataOther)(nil)
var _ ApduDataRequirements = (*_ApduDataOther)(nil)

// NewApduDataOther factory function for _ApduDataOther
func NewApduDataOther(extendedApdu ApduDataExt, dataLength uint8) *_ApduDataOther {
	if extendedApdu == nil {
		panic("extendedApdu of type ApduDataExt for ApduDataOther must not be nil")
	}
	_result := &_ApduDataOther{
		ApduDataContract: NewApduData(dataLength),
		ExtendedApdu:     extendedApdu,
	}
	_result.ApduDataContract.(*_ApduData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataOtherBuilder is a builder for ApduDataOther
type ApduDataOtherBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(extendedApdu ApduDataExt) ApduDataOtherBuilder
	// WithExtendedApdu adds ExtendedApdu (property field)
	WithExtendedApdu(ApduDataExt) ApduDataOtherBuilder
	// WithExtendedApduBuilder adds ExtendedApdu (property field) which is build by the builder
	WithExtendedApduBuilder(func(ApduDataExtBuilder) ApduDataExtBuilder) ApduDataOtherBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataBuilder
	// Build builds the ApduDataOther or returns an error if something is wrong
	Build() (ApduDataOther, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataOther
}

// NewApduDataOtherBuilder() creates a ApduDataOtherBuilder
func NewApduDataOtherBuilder() ApduDataOtherBuilder {
	return &_ApduDataOtherBuilder{_ApduDataOther: new(_ApduDataOther)}
}

type _ApduDataOtherBuilder struct {
	*_ApduDataOther

	parentBuilder *_ApduDataBuilder

	err *utils.MultiError
}

var _ (ApduDataOtherBuilder) = (*_ApduDataOtherBuilder)(nil)

func (b *_ApduDataOtherBuilder) setParent(contract ApduDataContract) {
	b.ApduDataContract = contract
	contract.(*_ApduData)._SubType = b._ApduDataOther
}

func (b *_ApduDataOtherBuilder) WithMandatoryFields(extendedApdu ApduDataExt) ApduDataOtherBuilder {
	return b.WithExtendedApdu(extendedApdu)
}

func (b *_ApduDataOtherBuilder) WithExtendedApdu(extendedApdu ApduDataExt) ApduDataOtherBuilder {
	b.ExtendedApdu = extendedApdu
	return b
}

func (b *_ApduDataOtherBuilder) WithExtendedApduBuilder(builderSupplier func(ApduDataExtBuilder) ApduDataExtBuilder) ApduDataOtherBuilder {
	builder := builderSupplier(b.ExtendedApdu.CreateApduDataExtBuilder())
	var err error
	b.ExtendedApdu, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ApduDataExtBuilder failed"))
	}
	return b
}

func (b *_ApduDataOtherBuilder) Build() (ApduDataOther, error) {
	if b.ExtendedApdu == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'extendedApdu' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataOther.deepCopy(), nil
}

func (b *_ApduDataOtherBuilder) MustBuild() ApduDataOther {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataOtherBuilder) Done() ApduDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataBuilder().(*_ApduDataBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataOtherBuilder) buildForApduData() (ApduData, error) {
	return b.Build()
}

func (b *_ApduDataOtherBuilder) DeepCopy() any {
	_copy := b.CreateApduDataOtherBuilder().(*_ApduDataOtherBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataOtherBuilder creates a ApduDataOtherBuilder
func (b *_ApduDataOther) CreateApduDataOtherBuilder() ApduDataOtherBuilder {
	if b == nil {
		return NewApduDataOtherBuilder()
	}
	return &_ApduDataOtherBuilder{_ApduDataOther: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataOther) GetApciType() uint8 {
	return 0xF
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataOther) GetParent() ApduDataContract {
	return m.ApduDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApduDataOther) GetExtendedApdu() ApduDataExt {
	return m.ExtendedApdu
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApduDataOther(structType any) ApduDataOther {
	if casted, ok := structType.(ApduDataOther); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataOther); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataOther) GetTypeName() string {
	return "ApduDataOther"
}

func (m *_ApduDataOther) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataContract.(*_ApduData).getLengthInBits(ctx))

	// Simple field (extendedApdu)
	lengthInBits += m.ExtendedApdu.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ApduDataOther) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataOther) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduData, dataLength uint8) (__apduDataOther ApduDataOther, err error) {
	m.ApduDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataOther"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataOther")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	extendedApdu, err := ReadSimpleField[ApduDataExt](ctx, "extendedApdu", ReadComplex[ApduDataExt](ApduDataExtParseWithBufferProducer[ApduDataExt]((uint8)(dataLength)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'extendedApdu' field"))
	}
	m.ExtendedApdu = extendedApdu

	if closeErr := readBuffer.CloseContext("ApduDataOther"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataOther")
	}

	return m, nil
}

func (m *_ApduDataOther) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataOther) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataOther"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataOther")
		}

		if err := WriteSimpleField[ApduDataExt](ctx, "extendedApdu", m.GetExtendedApdu(), WriteComplex[ApduDataExt](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'extendedApdu' field")
		}

		if popErr := writeBuffer.PopContext("ApduDataOther"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataOther")
		}
		return nil
	}
	return m.ApduDataContract.(*_ApduData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataOther) IsApduDataOther() {}

func (m *_ApduDataOther) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataOther) deepCopy() *_ApduDataOther {
	if m == nil {
		return nil
	}
	_ApduDataOtherCopy := &_ApduDataOther{
		m.ApduDataContract.(*_ApduData).deepCopy(),
		utils.DeepCopy[ApduDataExt](m.ExtendedApdu),
	}
	_ApduDataOtherCopy.ApduDataContract.(*_ApduData)._SubType = m
	return _ApduDataOtherCopy
}

func (m *_ApduDataOther) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
