/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataGroupValueResponse is the corresponding interface of ApduDataGroupValueResponse
type ApduDataGroupValueResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduData
	// GetDataFirstByte returns DataFirstByte (property field)
	GetDataFirstByte() int8
	// GetData returns Data (property field)
	GetData() []byte
	// IsApduDataGroupValueResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataGroupValueResponse()
	// CreateBuilder creates a ApduDataGroupValueResponseBuilder
	CreateApduDataGroupValueResponseBuilder() ApduDataGroupValueResponseBuilder
}

// _ApduDataGroupValueResponse is the data-structure of this message
type _ApduDataGroupValueResponse struct {
	ApduDataContract
	DataFirstByte int8
	Data          []byte
}

var _ ApduDataGroupValueResponse = (*_ApduDataGroupValueResponse)(nil)
var _ ApduDataRequirements = (*_ApduDataGroupValueResponse)(nil)

// NewApduDataGroupValueResponse factory function for _ApduDataGroupValueResponse
func NewApduDataGroupValueResponse(dataFirstByte int8, data []byte, dataLength uint8) *_ApduDataGroupValueResponse {
	_result := &_ApduDataGroupValueResponse{
		ApduDataContract: NewApduData(dataLength),
		DataFirstByte:    dataFirstByte,
		Data:             data,
	}
	_result.ApduDataContract.(*_ApduData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataGroupValueResponseBuilder is a builder for ApduDataGroupValueResponse
type ApduDataGroupValueResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataFirstByte int8, data []byte) ApduDataGroupValueResponseBuilder
	// WithDataFirstByte adds DataFirstByte (property field)
	WithDataFirstByte(int8) ApduDataGroupValueResponseBuilder
	// WithData adds Data (property field)
	WithData(...byte) ApduDataGroupValueResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataBuilder
	// Build builds the ApduDataGroupValueResponse or returns an error if something is wrong
	Build() (ApduDataGroupValueResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataGroupValueResponse
}

// NewApduDataGroupValueResponseBuilder() creates a ApduDataGroupValueResponseBuilder
func NewApduDataGroupValueResponseBuilder() ApduDataGroupValueResponseBuilder {
	return &_ApduDataGroupValueResponseBuilder{_ApduDataGroupValueResponse: new(_ApduDataGroupValueResponse)}
}

type _ApduDataGroupValueResponseBuilder struct {
	*_ApduDataGroupValueResponse

	parentBuilder *_ApduDataBuilder

	err *utils.MultiError
}

var _ (ApduDataGroupValueResponseBuilder) = (*_ApduDataGroupValueResponseBuilder)(nil)

func (b *_ApduDataGroupValueResponseBuilder) setParent(contract ApduDataContract) {
	b.ApduDataContract = contract
	contract.(*_ApduData)._SubType = b._ApduDataGroupValueResponse
}

func (b *_ApduDataGroupValueResponseBuilder) WithMandatoryFields(dataFirstByte int8, data []byte) ApduDataGroupValueResponseBuilder {
	return b.WithDataFirstByte(dataFirstByte).WithData(data...)
}

func (b *_ApduDataGroupValueResponseBuilder) WithDataFirstByte(dataFirstByte int8) ApduDataGroupValueResponseBuilder {
	b.DataFirstByte = dataFirstByte
	return b
}

func (b *_ApduDataGroupValueResponseBuilder) WithData(data ...byte) ApduDataGroupValueResponseBuilder {
	b.Data = data
	return b
}

func (b *_ApduDataGroupValueResponseBuilder) Build() (ApduDataGroupValueResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataGroupValueResponse.deepCopy(), nil
}

func (b *_ApduDataGroupValueResponseBuilder) MustBuild() ApduDataGroupValueResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataGroupValueResponseBuilder) Done() ApduDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataBuilder().(*_ApduDataBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataGroupValueResponseBuilder) buildForApduData() (ApduData, error) {
	return b.Build()
}

func (b *_ApduDataGroupValueResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataGroupValueResponseBuilder().(*_ApduDataGroupValueResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataGroupValueResponseBuilder creates a ApduDataGroupValueResponseBuilder
func (b *_ApduDataGroupValueResponse) CreateApduDataGroupValueResponseBuilder() ApduDataGroupValueResponseBuilder {
	if b == nil {
		return NewApduDataGroupValueResponseBuilder()
	}
	return &_ApduDataGroupValueResponseBuilder{_ApduDataGroupValueResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataGroupValueResponse) GetApciType() uint8 {
	return 0x1
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataGroupValueResponse) GetParent() ApduDataContract {
	return m.ApduDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApduDataGroupValueResponse) GetDataFirstByte() int8 {
	return m.DataFirstByte
}

func (m *_ApduDataGroupValueResponse) GetData() []byte {
	return m.Data
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApduDataGroupValueResponse(structType any) ApduDataGroupValueResponse {
	if casted, ok := structType.(ApduDataGroupValueResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataGroupValueResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataGroupValueResponse) GetTypeName() string {
	return "ApduDataGroupValueResponse"
}

func (m *_ApduDataGroupValueResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataContract.(*_ApduData).getLengthInBits(ctx))

	// Simple field (dataFirstByte)
	lengthInBits += 6

	// Array field
	if len(m.Data) > 0 {
		lengthInBits += 8 * uint16(len(m.Data))
	}

	return lengthInBits
}

func (m *_ApduDataGroupValueResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataGroupValueResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduData, dataLength uint8) (__apduDataGroupValueResponse ApduDataGroupValueResponse, err error) {
	m.ApduDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataGroupValueResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataGroupValueResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataFirstByte, err := ReadSimpleField(ctx, "dataFirstByte", ReadSignedByte(readBuffer, uint8(6)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataFirstByte' field"))
	}
	m.DataFirstByte = dataFirstByte

	data, err := readBuffer.ReadByteArray("data", int(utils.InlineIf((bool((dataLength) < (1))), func() any { return int32(int32(0)) }, func() any { return int32(int32(dataLength) - int32(int32(1))) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'data' field"))
	}
	m.Data = data

	if closeErr := readBuffer.CloseContext("ApduDataGroupValueResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataGroupValueResponse")
	}

	return m, nil
}

func (m *_ApduDataGroupValueResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataGroupValueResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataGroupValueResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataGroupValueResponse")
		}

		if err := WriteSimpleField[int8](ctx, "dataFirstByte", m.GetDataFirstByte(), WriteSignedByte(writeBuffer, 6)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataFirstByte' field")
		}

		if err := WriteByteArrayField(ctx, "data", m.GetData(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'data' field")
		}

		if popErr := writeBuffer.PopContext("ApduDataGroupValueResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataGroupValueResponse")
		}
		return nil
	}
	return m.ApduDataContract.(*_ApduData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataGroupValueResponse) IsApduDataGroupValueResponse() {}

func (m *_ApduDataGroupValueResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataGroupValueResponse) deepCopy() *_ApduDataGroupValueResponse {
	if m == nil {
		return nil
	}
	_ApduDataGroupValueResponseCopy := &_ApduDataGroupValueResponse{
		m.ApduDataContract.(*_ApduData).deepCopy(),
		m.DataFirstByte,
		utils.DeepCopySlice[byte, byte](m.Data),
	}
	_ApduDataGroupValueResponseCopy.ApduDataContract.(*_ApduData)._SubType = m
	return _ApduDataGroupValueResponseCopy
}

func (m *_ApduDataGroupValueResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
