/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtReadRouterStatusRequest is the corresponding interface of ApduDataExtReadRouterStatusRequest
type ApduDataExtReadRouterStatusRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtReadRouterStatusRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtReadRouterStatusRequest()
	// CreateBuilder creates a ApduDataExtReadRouterStatusRequestBuilder
	CreateApduDataExtReadRouterStatusRequestBuilder() ApduDataExtReadRouterStatusRequestBuilder
}

// _ApduDataExtReadRouterStatusRequest is the data-structure of this message
type _ApduDataExtReadRouterStatusRequest struct {
	ApduDataExtContract
}

var _ ApduDataExtReadRouterStatusRequest = (*_ApduDataExtReadRouterStatusRequest)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtReadRouterStatusRequest)(nil)

// NewApduDataExtReadRouterStatusRequest factory function for _ApduDataExtReadRouterStatusRequest
func NewApduDataExtReadRouterStatusRequest(length uint8) *_ApduDataExtReadRouterStatusRequest {
	_result := &_ApduDataExtReadRouterStatusRequest{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtReadRouterStatusRequestBuilder is a builder for ApduDataExtReadRouterStatusRequest
type ApduDataExtReadRouterStatusRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtReadRouterStatusRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtReadRouterStatusRequest or returns an error if something is wrong
	Build() (ApduDataExtReadRouterStatusRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtReadRouterStatusRequest
}

// NewApduDataExtReadRouterStatusRequestBuilder() creates a ApduDataExtReadRouterStatusRequestBuilder
func NewApduDataExtReadRouterStatusRequestBuilder() ApduDataExtReadRouterStatusRequestBuilder {
	return &_ApduDataExtReadRouterStatusRequestBuilder{_ApduDataExtReadRouterStatusRequest: new(_ApduDataExtReadRouterStatusRequest)}
}

type _ApduDataExtReadRouterStatusRequestBuilder struct {
	*_ApduDataExtReadRouterStatusRequest

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtReadRouterStatusRequestBuilder) = (*_ApduDataExtReadRouterStatusRequestBuilder)(nil)

func (b *_ApduDataExtReadRouterStatusRequestBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtReadRouterStatusRequest
}

func (b *_ApduDataExtReadRouterStatusRequestBuilder) WithMandatoryFields() ApduDataExtReadRouterStatusRequestBuilder {
	return b
}

func (b *_ApduDataExtReadRouterStatusRequestBuilder) Build() (ApduDataExtReadRouterStatusRequest, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtReadRouterStatusRequest.deepCopy(), nil
}

func (b *_ApduDataExtReadRouterStatusRequestBuilder) MustBuild() ApduDataExtReadRouterStatusRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtReadRouterStatusRequestBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtReadRouterStatusRequestBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtReadRouterStatusRequestBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtReadRouterStatusRequestBuilder().(*_ApduDataExtReadRouterStatusRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtReadRouterStatusRequestBuilder creates a ApduDataExtReadRouterStatusRequestBuilder
func (b *_ApduDataExtReadRouterStatusRequest) CreateApduDataExtReadRouterStatusRequestBuilder() ApduDataExtReadRouterStatusRequestBuilder {
	if b == nil {
		return NewApduDataExtReadRouterStatusRequestBuilder()
	}
	return &_ApduDataExtReadRouterStatusRequestBuilder{_ApduDataExtReadRouterStatusRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtReadRouterStatusRequest) GetExtApciType() uint8 {
	return 0x0D
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtReadRouterStatusRequest) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtReadRouterStatusRequest(structType any) ApduDataExtReadRouterStatusRequest {
	if casted, ok := structType.(ApduDataExtReadRouterStatusRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtReadRouterStatusRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtReadRouterStatusRequest) GetTypeName() string {
	return "ApduDataExtReadRouterStatusRequest"
}

func (m *_ApduDataExtReadRouterStatusRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtReadRouterStatusRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtReadRouterStatusRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtReadRouterStatusRequest ApduDataExtReadRouterStatusRequest, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtReadRouterStatusRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtReadRouterStatusRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtReadRouterStatusRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtReadRouterStatusRequest")
	}

	return m, nil
}

func (m *_ApduDataExtReadRouterStatusRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtReadRouterStatusRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtReadRouterStatusRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtReadRouterStatusRequest")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtReadRouterStatusRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtReadRouterStatusRequest")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtReadRouterStatusRequest) IsApduDataExtReadRouterStatusRequest() {}

func (m *_ApduDataExtReadRouterStatusRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtReadRouterStatusRequest) deepCopy() *_ApduDataExtReadRouterStatusRequest {
	if m == nil {
		return nil
	}
	_ApduDataExtReadRouterStatusRequestCopy := &_ApduDataExtReadRouterStatusRequest{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtReadRouterStatusRequestCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtReadRouterStatusRequestCopy
}

func (m *_ApduDataExtReadRouterStatusRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
