/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataAdcResponse is the corresponding interface of ApduDataAdcResponse
type ApduDataAdcResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduData
	// IsApduDataAdcResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataAdcResponse()
	// CreateBuilder creates a ApduDataAdcResponseBuilder
	CreateApduDataAdcResponseBuilder() ApduDataAdcResponseBuilder
}

// _ApduDataAdcResponse is the data-structure of this message
type _ApduDataAdcResponse struct {
	ApduDataContract
}

var _ ApduDataAdcResponse = (*_ApduDataAdcResponse)(nil)
var _ ApduDataRequirements = (*_ApduDataAdcResponse)(nil)

// NewApduDataAdcResponse factory function for _ApduDataAdcResponse
func NewApduDataAdcResponse(dataLength uint8) *_ApduDataAdcResponse {
	_result := &_ApduDataAdcResponse{
		ApduDataContract: NewApduData(dataLength),
	}
	_result.ApduDataContract.(*_ApduData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataAdcResponseBuilder is a builder for ApduDataAdcResponse
type ApduDataAdcResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataAdcResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataBuilder
	// Build builds the ApduDataAdcResponse or returns an error if something is wrong
	Build() (ApduDataAdcResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataAdcResponse
}

// NewApduDataAdcResponseBuilder() creates a ApduDataAdcResponseBuilder
func NewApduDataAdcResponseBuilder() ApduDataAdcResponseBuilder {
	return &_ApduDataAdcResponseBuilder{_ApduDataAdcResponse: new(_ApduDataAdcResponse)}
}

type _ApduDataAdcResponseBuilder struct {
	*_ApduDataAdcResponse

	parentBuilder *_ApduDataBuilder

	err *utils.MultiError
}

var _ (ApduDataAdcResponseBuilder) = (*_ApduDataAdcResponseBuilder)(nil)

func (b *_ApduDataAdcResponseBuilder) setParent(contract ApduDataContract) {
	b.ApduDataContract = contract
	contract.(*_ApduData)._SubType = b._ApduDataAdcResponse
}

func (b *_ApduDataAdcResponseBuilder) WithMandatoryFields() ApduDataAdcResponseBuilder {
	return b
}

func (b *_ApduDataAdcResponseBuilder) Build() (ApduDataAdcResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataAdcResponse.deepCopy(), nil
}

func (b *_ApduDataAdcResponseBuilder) MustBuild() ApduDataAdcResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataAdcResponseBuilder) Done() ApduDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataBuilder().(*_ApduDataBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataAdcResponseBuilder) buildForApduData() (ApduData, error) {
	return b.Build()
}

func (b *_ApduDataAdcResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataAdcResponseBuilder().(*_ApduDataAdcResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataAdcResponseBuilder creates a ApduDataAdcResponseBuilder
func (b *_ApduDataAdcResponse) CreateApduDataAdcResponseBuilder() ApduDataAdcResponseBuilder {
	if b == nil {
		return NewApduDataAdcResponseBuilder()
	}
	return &_ApduDataAdcResponseBuilder{_ApduDataAdcResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataAdcResponse) GetApciType() uint8 {
	return 0x7
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataAdcResponse) GetParent() ApduDataContract {
	return m.ApduDataContract
}

// Deprecated: use the interface for direct cast
func CastApduDataAdcResponse(structType any) ApduDataAdcResponse {
	if casted, ok := structType.(ApduDataAdcResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataAdcResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataAdcResponse) GetTypeName() string {
	return "ApduDataAdcResponse"
}

func (m *_ApduDataAdcResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataContract.(*_ApduData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataAdcResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataAdcResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduData, dataLength uint8) (__apduDataAdcResponse ApduDataAdcResponse, err error) {
	m.ApduDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataAdcResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataAdcResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataAdcResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataAdcResponse")
	}

	return m, nil
}

func (m *_ApduDataAdcResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataAdcResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataAdcResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataAdcResponse")
		}

		if popErr := writeBuffer.PopContext("ApduDataAdcResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataAdcResponse")
		}
		return nil
	}
	return m.ApduDataContract.(*_ApduData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataAdcResponse) IsApduDataAdcResponse() {}

func (m *_ApduDataAdcResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataAdcResponse) deepCopy() *_ApduDataAdcResponse {
	if m == nil {
		return nil
	}
	_ApduDataAdcResponseCopy := &_ApduDataAdcResponse{
		m.ApduDataContract.(*_ApduData).deepCopy(),
	}
	_ApduDataAdcResponseCopy.ApduDataContract.(*_ApduData)._SubType = m
	return _ApduDataAdcResponseCopy
}

func (m *_ApduDataAdcResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
