/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SysexCommandStringData is the corresponding interface of SysexCommandStringData
type SysexCommandStringData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SysexCommand
	// IsSysexCommandStringData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSysexCommandStringData()
	// CreateBuilder creates a SysexCommandStringDataBuilder
	CreateSysexCommandStringDataBuilder() SysexCommandStringDataBuilder
}

// _SysexCommandStringData is the data-structure of this message
type _SysexCommandStringData struct {
	SysexCommandContract
}

var _ SysexCommandStringData = (*_SysexCommandStringData)(nil)
var _ SysexCommandRequirements = (*_SysexCommandStringData)(nil)

// NewSysexCommandStringData factory function for _SysexCommandStringData
func NewSysexCommandStringData() *_SysexCommandStringData {
	_result := &_SysexCommandStringData{
		SysexCommandContract: NewSysexCommand(),
	}
	_result.SysexCommandContract.(*_SysexCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SysexCommandStringDataBuilder is a builder for SysexCommandStringData
type SysexCommandStringDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SysexCommandStringDataBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SysexCommandBuilder
	// Build builds the SysexCommandStringData or returns an error if something is wrong
	Build() (SysexCommandStringData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SysexCommandStringData
}

// NewSysexCommandStringDataBuilder() creates a SysexCommandStringDataBuilder
func NewSysexCommandStringDataBuilder() SysexCommandStringDataBuilder {
	return &_SysexCommandStringDataBuilder{_SysexCommandStringData: new(_SysexCommandStringData)}
}

type _SysexCommandStringDataBuilder struct {
	*_SysexCommandStringData

	parentBuilder *_SysexCommandBuilder

	err *utils.MultiError
}

var _ (SysexCommandStringDataBuilder) = (*_SysexCommandStringDataBuilder)(nil)

func (b *_SysexCommandStringDataBuilder) setParent(contract SysexCommandContract) {
	b.SysexCommandContract = contract
	contract.(*_SysexCommand)._SubType = b._SysexCommandStringData
}

func (b *_SysexCommandStringDataBuilder) WithMandatoryFields() SysexCommandStringDataBuilder {
	return b
}

func (b *_SysexCommandStringDataBuilder) Build() (SysexCommandStringData, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SysexCommandStringData.deepCopy(), nil
}

func (b *_SysexCommandStringDataBuilder) MustBuild() SysexCommandStringData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SysexCommandStringDataBuilder) Done() SysexCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSysexCommandBuilder().(*_SysexCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_SysexCommandStringDataBuilder) buildForSysexCommand() (SysexCommand, error) {
	return b.Build()
}

func (b *_SysexCommandStringDataBuilder) DeepCopy() any {
	_copy := b.CreateSysexCommandStringDataBuilder().(*_SysexCommandStringDataBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSysexCommandStringDataBuilder creates a SysexCommandStringDataBuilder
func (b *_SysexCommandStringData) CreateSysexCommandStringDataBuilder() SysexCommandStringDataBuilder {
	if b == nil {
		return NewSysexCommandStringDataBuilder()
	}
	return &_SysexCommandStringDataBuilder{_SysexCommandStringData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SysexCommandStringData) GetCommandType() uint8 {
	return 0x71
}

func (m *_SysexCommandStringData) GetResponse() bool {
	return false
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SysexCommandStringData) GetParent() SysexCommandContract {
	return m.SysexCommandContract
}

// Deprecated: use the interface for direct cast
func CastSysexCommandStringData(structType any) SysexCommandStringData {
	if casted, ok := structType.(SysexCommandStringData); ok {
		return casted
	}
	if casted, ok := structType.(*SysexCommandStringData); ok {
		return *casted
	}
	return nil
}

func (m *_SysexCommandStringData) GetTypeName() string {
	return "SysexCommandStringData"
}

func (m *_SysexCommandStringData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SysexCommandContract.(*_SysexCommand).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SysexCommandStringData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SysexCommandStringData) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SysexCommand, response bool) (__sysexCommandStringData SysexCommandStringData, err error) {
	m.SysexCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SysexCommandStringData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SysexCommandStringData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SysexCommandStringData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SysexCommandStringData")
	}

	return m, nil
}

func (m *_SysexCommandStringData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SysexCommandStringData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SysexCommandStringData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SysexCommandStringData")
		}

		if popErr := writeBuffer.PopContext("SysexCommandStringData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SysexCommandStringData")
		}
		return nil
	}
	return m.SysexCommandContract.(*_SysexCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SysexCommandStringData) IsSysexCommandStringData() {}

func (m *_SysexCommandStringData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SysexCommandStringData) deepCopy() *_SysexCommandStringData {
	if m == nil {
		return nil
	}
	_SysexCommandStringDataCopy := &_SysexCommandStringData{
		m.SysexCommandContract.(*_SysexCommand).deepCopy(),
	}
	_SysexCommandStringDataCopy.SysexCommandContract.(*_SysexCommand)._SubType = m
	return _SysexCommandStringDataCopy
}

func (m *_SysexCommandStringData) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
