/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// FirmataMessageSubscribeDigitalPinValue is the corresponding interface of FirmataMessageSubscribeDigitalPinValue
type FirmataMessageSubscribeDigitalPinValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	FirmataMessage
	// GetPin returns Pin (property field)
	GetPin() uint8
	// GetEnable returns Enable (property field)
	GetEnable() bool
	// IsFirmataMessageSubscribeDigitalPinValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsFirmataMessageSubscribeDigitalPinValue()
	// CreateBuilder creates a FirmataMessageSubscribeDigitalPinValueBuilder
	CreateFirmataMessageSubscribeDigitalPinValueBuilder() FirmataMessageSubscribeDigitalPinValueBuilder
}

// _FirmataMessageSubscribeDigitalPinValue is the data-structure of this message
type _FirmataMessageSubscribeDigitalPinValue struct {
	FirmataMessageContract
	Pin    uint8
	Enable bool
	// Reserved Fields
	reservedField0 *uint8
}

var _ FirmataMessageSubscribeDigitalPinValue = (*_FirmataMessageSubscribeDigitalPinValue)(nil)
var _ FirmataMessageRequirements = (*_FirmataMessageSubscribeDigitalPinValue)(nil)

// NewFirmataMessageSubscribeDigitalPinValue factory function for _FirmataMessageSubscribeDigitalPinValue
func NewFirmataMessageSubscribeDigitalPinValue(pin uint8, enable bool, response bool) *_FirmataMessageSubscribeDigitalPinValue {
	_result := &_FirmataMessageSubscribeDigitalPinValue{
		FirmataMessageContract: NewFirmataMessage(response),
		Pin:                    pin,
		Enable:                 enable,
	}
	_result.FirmataMessageContract.(*_FirmataMessage)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// FirmataMessageSubscribeDigitalPinValueBuilder is a builder for FirmataMessageSubscribeDigitalPinValue
type FirmataMessageSubscribeDigitalPinValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(pin uint8, enable bool) FirmataMessageSubscribeDigitalPinValueBuilder
	// WithPin adds Pin (property field)
	WithPin(uint8) FirmataMessageSubscribeDigitalPinValueBuilder
	// WithEnable adds Enable (property field)
	WithEnable(bool) FirmataMessageSubscribeDigitalPinValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() FirmataMessageBuilder
	// Build builds the FirmataMessageSubscribeDigitalPinValue or returns an error if something is wrong
	Build() (FirmataMessageSubscribeDigitalPinValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() FirmataMessageSubscribeDigitalPinValue
}

// NewFirmataMessageSubscribeDigitalPinValueBuilder() creates a FirmataMessageSubscribeDigitalPinValueBuilder
func NewFirmataMessageSubscribeDigitalPinValueBuilder() FirmataMessageSubscribeDigitalPinValueBuilder {
	return &_FirmataMessageSubscribeDigitalPinValueBuilder{_FirmataMessageSubscribeDigitalPinValue: new(_FirmataMessageSubscribeDigitalPinValue)}
}

type _FirmataMessageSubscribeDigitalPinValueBuilder struct {
	*_FirmataMessageSubscribeDigitalPinValue

	parentBuilder *_FirmataMessageBuilder

	err *utils.MultiError
}

var _ (FirmataMessageSubscribeDigitalPinValueBuilder) = (*_FirmataMessageSubscribeDigitalPinValueBuilder)(nil)

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) setParent(contract FirmataMessageContract) {
	b.FirmataMessageContract = contract
	contract.(*_FirmataMessage)._SubType = b._FirmataMessageSubscribeDigitalPinValue
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) WithMandatoryFields(pin uint8, enable bool) FirmataMessageSubscribeDigitalPinValueBuilder {
	return b.WithPin(pin).WithEnable(enable)
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) WithPin(pin uint8) FirmataMessageSubscribeDigitalPinValueBuilder {
	b.Pin = pin
	return b
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) WithEnable(enable bool) FirmataMessageSubscribeDigitalPinValueBuilder {
	b.Enable = enable
	return b
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) Build() (FirmataMessageSubscribeDigitalPinValue, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._FirmataMessageSubscribeDigitalPinValue.deepCopy(), nil
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) MustBuild() FirmataMessageSubscribeDigitalPinValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) Done() FirmataMessageBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewFirmataMessageBuilder().(*_FirmataMessageBuilder)
	}
	return b.parentBuilder
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) buildForFirmataMessage() (FirmataMessage, error) {
	return b.Build()
}

func (b *_FirmataMessageSubscribeDigitalPinValueBuilder) DeepCopy() any {
	_copy := b.CreateFirmataMessageSubscribeDigitalPinValueBuilder().(*_FirmataMessageSubscribeDigitalPinValueBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateFirmataMessageSubscribeDigitalPinValueBuilder creates a FirmataMessageSubscribeDigitalPinValueBuilder
func (b *_FirmataMessageSubscribeDigitalPinValue) CreateFirmataMessageSubscribeDigitalPinValueBuilder() FirmataMessageSubscribeDigitalPinValueBuilder {
	if b == nil {
		return NewFirmataMessageSubscribeDigitalPinValueBuilder()
	}
	return &_FirmataMessageSubscribeDigitalPinValueBuilder{_FirmataMessageSubscribeDigitalPinValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_FirmataMessageSubscribeDigitalPinValue) GetMessageType() uint8 {
	return 0xD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_FirmataMessageSubscribeDigitalPinValue) GetParent() FirmataMessageContract {
	return m.FirmataMessageContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_FirmataMessageSubscribeDigitalPinValue) GetPin() uint8 {
	return m.Pin
}

func (m *_FirmataMessageSubscribeDigitalPinValue) GetEnable() bool {
	return m.Enable
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastFirmataMessageSubscribeDigitalPinValue(structType any) FirmataMessageSubscribeDigitalPinValue {
	if casted, ok := structType.(FirmataMessageSubscribeDigitalPinValue); ok {
		return casted
	}
	if casted, ok := structType.(*FirmataMessageSubscribeDigitalPinValue); ok {
		return *casted
	}
	return nil
}

func (m *_FirmataMessageSubscribeDigitalPinValue) GetTypeName() string {
	return "FirmataMessageSubscribeDigitalPinValue"
}

func (m *_FirmataMessageSubscribeDigitalPinValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.FirmataMessageContract.(*_FirmataMessage).getLengthInBits(ctx))

	// Simple field (pin)
	lengthInBits += 4

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (enable)
	lengthInBits += 1

	return lengthInBits
}

func (m *_FirmataMessageSubscribeDigitalPinValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_FirmataMessageSubscribeDigitalPinValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_FirmataMessage, response bool) (__firmataMessageSubscribeDigitalPinValue FirmataMessageSubscribeDigitalPinValue, err error) {
	m.FirmataMessageContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("FirmataMessageSubscribeDigitalPinValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for FirmataMessageSubscribeDigitalPinValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	pin, err := ReadSimpleField(ctx, "pin", ReadUnsignedByte(readBuffer, uint8(4)), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pin' field"))
	}
	m.Pin = pin

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	enable, err := ReadSimpleField(ctx, "enable", ReadBoolean(readBuffer), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enable' field"))
	}
	m.Enable = enable

	if closeErr := readBuffer.CloseContext("FirmataMessageSubscribeDigitalPinValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for FirmataMessageSubscribeDigitalPinValue")
	}

	return m, nil
}

func (m *_FirmataMessageSubscribeDigitalPinValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_FirmataMessageSubscribeDigitalPinValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("FirmataMessageSubscribeDigitalPinValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for FirmataMessageSubscribeDigitalPinValue")
		}

		if err := WriteSimpleField[uint8](ctx, "pin", m.GetPin(), WriteUnsignedByte(writeBuffer, 4), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'pin' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "enable", m.GetEnable(), WriteBoolean(writeBuffer), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'enable' field")
		}

		if popErr := writeBuffer.PopContext("FirmataMessageSubscribeDigitalPinValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for FirmataMessageSubscribeDigitalPinValue")
		}
		return nil
	}
	return m.FirmataMessageContract.(*_FirmataMessage).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_FirmataMessageSubscribeDigitalPinValue) IsFirmataMessageSubscribeDigitalPinValue() {}

func (m *_FirmataMessageSubscribeDigitalPinValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_FirmataMessageSubscribeDigitalPinValue) deepCopy() *_FirmataMessageSubscribeDigitalPinValue {
	if m == nil {
		return nil
	}
	_FirmataMessageSubscribeDigitalPinValueCopy := &_FirmataMessageSubscribeDigitalPinValue{
		m.FirmataMessageContract.(*_FirmataMessage).deepCopy(),
		m.Pin,
		m.Enable,
		m.reservedField0,
	}
	_FirmataMessageSubscribeDigitalPinValueCopy.FirmataMessageContract.(*_FirmataMessage)._SubType = m
	return _FirmataMessageSubscribeDigitalPinValueCopy
}

func (m *_FirmataMessageSubscribeDigitalPinValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
