/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// EipListIdentityResponse is the corresponding interface of EipListIdentityResponse
type EipListIdentityResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	EipPacket
	// GetItems returns Items (property field)
	GetItems() []CommandSpecificDataItem
	// IsEipListIdentityResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsEipListIdentityResponse()
	// CreateBuilder creates a EipListIdentityResponseBuilder
	CreateEipListIdentityResponseBuilder() EipListIdentityResponseBuilder
}

// _EipListIdentityResponse is the data-structure of this message
type _EipListIdentityResponse struct {
	EipPacketContract
	Items []CommandSpecificDataItem
}

var _ EipListIdentityResponse = (*_EipListIdentityResponse)(nil)
var _ EipPacketRequirements = (*_EipListIdentityResponse)(nil)

// NewEipListIdentityResponse factory function for _EipListIdentityResponse
func NewEipListIdentityResponse(sessionHandle uint32, status uint32, senderContext []byte, options uint32, items []CommandSpecificDataItem) *_EipListIdentityResponse {
	_result := &_EipListIdentityResponse{
		EipPacketContract: NewEipPacket(sessionHandle, status, senderContext, options),
		Items:             items,
	}
	_result.EipPacketContract.(*_EipPacket)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// EipListIdentityResponseBuilder is a builder for EipListIdentityResponse
type EipListIdentityResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(items []CommandSpecificDataItem) EipListIdentityResponseBuilder
	// WithItems adds Items (property field)
	WithItems(...CommandSpecificDataItem) EipListIdentityResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() EipPacketBuilder
	// Build builds the EipListIdentityResponse or returns an error if something is wrong
	Build() (EipListIdentityResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() EipListIdentityResponse
}

// NewEipListIdentityResponseBuilder() creates a EipListIdentityResponseBuilder
func NewEipListIdentityResponseBuilder() EipListIdentityResponseBuilder {
	return &_EipListIdentityResponseBuilder{_EipListIdentityResponse: new(_EipListIdentityResponse)}
}

type _EipListIdentityResponseBuilder struct {
	*_EipListIdentityResponse

	parentBuilder *_EipPacketBuilder

	err *utils.MultiError
}

var _ (EipListIdentityResponseBuilder) = (*_EipListIdentityResponseBuilder)(nil)

func (b *_EipListIdentityResponseBuilder) setParent(contract EipPacketContract) {
	b.EipPacketContract = contract
	contract.(*_EipPacket)._SubType = b._EipListIdentityResponse
}

func (b *_EipListIdentityResponseBuilder) WithMandatoryFields(items []CommandSpecificDataItem) EipListIdentityResponseBuilder {
	return b.WithItems(items...)
}

func (b *_EipListIdentityResponseBuilder) WithItems(items ...CommandSpecificDataItem) EipListIdentityResponseBuilder {
	b.Items = items
	return b
}

func (b *_EipListIdentityResponseBuilder) Build() (EipListIdentityResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._EipListIdentityResponse.deepCopy(), nil
}

func (b *_EipListIdentityResponseBuilder) MustBuild() EipListIdentityResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_EipListIdentityResponseBuilder) Done() EipPacketBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewEipPacketBuilder().(*_EipPacketBuilder)
	}
	return b.parentBuilder
}

func (b *_EipListIdentityResponseBuilder) buildForEipPacket() (EipPacket, error) {
	return b.Build()
}

func (b *_EipListIdentityResponseBuilder) DeepCopy() any {
	_copy := b.CreateEipListIdentityResponseBuilder().(*_EipListIdentityResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateEipListIdentityResponseBuilder creates a EipListIdentityResponseBuilder
func (b *_EipListIdentityResponse) CreateEipListIdentityResponseBuilder() EipListIdentityResponseBuilder {
	if b == nil {
		return NewEipListIdentityResponseBuilder()
	}
	return &_EipListIdentityResponseBuilder{_EipListIdentityResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_EipListIdentityResponse) GetCommand() uint16 {
	return 0x0063
}

func (m *_EipListIdentityResponse) GetResponse() bool {
	return bool(true)
}

func (m *_EipListIdentityResponse) GetPacketLength() uint16 {
	return 0
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_EipListIdentityResponse) GetParent() EipPacketContract {
	return m.EipPacketContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_EipListIdentityResponse) GetItems() []CommandSpecificDataItem {
	return m.Items
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastEipListIdentityResponse(structType any) EipListIdentityResponse {
	if casted, ok := structType.(EipListIdentityResponse); ok {
		return casted
	}
	if casted, ok := structType.(*EipListIdentityResponse); ok {
		return *casted
	}
	return nil
}

func (m *_EipListIdentityResponse) GetTypeName() string {
	return "EipListIdentityResponse"
}

func (m *_EipListIdentityResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.EipPacketContract.(*_EipPacket).getLengthInBits(ctx))

	// Implicit Field (itemCount)
	lengthInBits += 16

	// Array field
	if len(m.Items) > 0 {
		for _curItem, element := range m.Items {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Items), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_EipListIdentityResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_EipListIdentityResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_EipPacket, response bool) (__eipListIdentityResponse EipListIdentityResponse, err error) {
	m.EipPacketContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("EipListIdentityResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for EipListIdentityResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	itemCount, err := ReadImplicitField[uint16](ctx, "itemCount", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'itemCount' field"))
	}
	_ = itemCount

	items, err := ReadCountArrayField[CommandSpecificDataItem](ctx, "items", ReadComplex[CommandSpecificDataItem](CommandSpecificDataItemParseWithBuffer, readBuffer), uint64(itemCount))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'items' field"))
	}
	m.Items = items

	if closeErr := readBuffer.CloseContext("EipListIdentityResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for EipListIdentityResponse")
	}

	return m, nil
}

func (m *_EipListIdentityResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_EipListIdentityResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("EipListIdentityResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for EipListIdentityResponse")
		}
		itemCount := uint16(uint16(len(m.GetItems())))
		if err := WriteImplicitField(ctx, "itemCount", itemCount, WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'itemCount' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "items", m.GetItems(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'items' field")
		}

		if popErr := writeBuffer.PopContext("EipListIdentityResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for EipListIdentityResponse")
		}
		return nil
	}
	return m.EipPacketContract.(*_EipPacket).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_EipListIdentityResponse) IsEipListIdentityResponse() {}

func (m *_EipListIdentityResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_EipListIdentityResponse) deepCopy() *_EipListIdentityResponse {
	if m == nil {
		return nil
	}
	_EipListIdentityResponseCopy := &_EipListIdentityResponse{
		m.EipPacketContract.(*_EipPacket).deepCopy(),
		utils.DeepCopySlice[CommandSpecificDataItem, CommandSpecificDataItem](m.Items),
	}
	_EipListIdentityResponseCopy.EipPacketContract.(*_EipPacket)._SubType = m
	return _EipListIdentityResponseCopy
}

func (m *_EipListIdentityResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
