/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CipRRData is the corresponding interface of CipRRData
type CipRRData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	EipPacket
	// GetInterfaceHandle returns InterfaceHandle (property field)
	GetInterfaceHandle() uint32
	// GetTimeout returns Timeout (property field)
	GetTimeout() uint16
	// GetTypeIds returns TypeIds (property field)
	GetTypeIds() []TypeId
	// IsCipRRData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCipRRData()
	// CreateBuilder creates a CipRRDataBuilder
	CreateCipRRDataBuilder() CipRRDataBuilder
}

// _CipRRData is the data-structure of this message
type _CipRRData struct {
	EipPacketContract
	InterfaceHandle uint32
	Timeout         uint16
	TypeIds         []TypeId
}

var _ CipRRData = (*_CipRRData)(nil)
var _ EipPacketRequirements = (*_CipRRData)(nil)

// NewCipRRData factory function for _CipRRData
func NewCipRRData(sessionHandle uint32, status uint32, senderContext []byte, options uint32, interfaceHandle uint32, timeout uint16, typeIds []TypeId) *_CipRRData {
	_result := &_CipRRData{
		EipPacketContract: NewEipPacket(sessionHandle, status, senderContext, options),
		InterfaceHandle:   interfaceHandle,
		Timeout:           timeout,
		TypeIds:           typeIds,
	}
	_result.EipPacketContract.(*_EipPacket)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CipRRDataBuilder is a builder for CipRRData
type CipRRDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(interfaceHandle uint32, timeout uint16, typeIds []TypeId) CipRRDataBuilder
	// WithInterfaceHandle adds InterfaceHandle (property field)
	WithInterfaceHandle(uint32) CipRRDataBuilder
	// WithTimeout adds Timeout (property field)
	WithTimeout(uint16) CipRRDataBuilder
	// WithTypeIds adds TypeIds (property field)
	WithTypeIds(...TypeId) CipRRDataBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() EipPacketBuilder
	// Build builds the CipRRData or returns an error if something is wrong
	Build() (CipRRData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CipRRData
}

// NewCipRRDataBuilder() creates a CipRRDataBuilder
func NewCipRRDataBuilder() CipRRDataBuilder {
	return &_CipRRDataBuilder{_CipRRData: new(_CipRRData)}
}

type _CipRRDataBuilder struct {
	*_CipRRData

	parentBuilder *_EipPacketBuilder

	err *utils.MultiError
}

var _ (CipRRDataBuilder) = (*_CipRRDataBuilder)(nil)

func (b *_CipRRDataBuilder) setParent(contract EipPacketContract) {
	b.EipPacketContract = contract
	contract.(*_EipPacket)._SubType = b._CipRRData
}

func (b *_CipRRDataBuilder) WithMandatoryFields(interfaceHandle uint32, timeout uint16, typeIds []TypeId) CipRRDataBuilder {
	return b.WithInterfaceHandle(interfaceHandle).WithTimeout(timeout).WithTypeIds(typeIds...)
}

func (b *_CipRRDataBuilder) WithInterfaceHandle(interfaceHandle uint32) CipRRDataBuilder {
	b.InterfaceHandle = interfaceHandle
	return b
}

func (b *_CipRRDataBuilder) WithTimeout(timeout uint16) CipRRDataBuilder {
	b.Timeout = timeout
	return b
}

func (b *_CipRRDataBuilder) WithTypeIds(typeIds ...TypeId) CipRRDataBuilder {
	b.TypeIds = typeIds
	return b
}

func (b *_CipRRDataBuilder) Build() (CipRRData, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._CipRRData.deepCopy(), nil
}

func (b *_CipRRDataBuilder) MustBuild() CipRRData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CipRRDataBuilder) Done() EipPacketBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewEipPacketBuilder().(*_EipPacketBuilder)
	}
	return b.parentBuilder
}

func (b *_CipRRDataBuilder) buildForEipPacket() (EipPacket, error) {
	return b.Build()
}

func (b *_CipRRDataBuilder) DeepCopy() any {
	_copy := b.CreateCipRRDataBuilder().(*_CipRRDataBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateCipRRDataBuilder creates a CipRRDataBuilder
func (b *_CipRRData) CreateCipRRDataBuilder() CipRRDataBuilder {
	if b == nil {
		return NewCipRRDataBuilder()
	}
	return &_CipRRDataBuilder{_CipRRData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CipRRData) GetCommand() uint16 {
	return 0x006F
}

func (m *_CipRRData) GetResponse() bool {
	return false
}

func (m *_CipRRData) GetPacketLength() uint16 {
	return 0
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CipRRData) GetParent() EipPacketContract {
	return m.EipPacketContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CipRRData) GetInterfaceHandle() uint32 {
	return m.InterfaceHandle
}

func (m *_CipRRData) GetTimeout() uint16 {
	return m.Timeout
}

func (m *_CipRRData) GetTypeIds() []TypeId {
	return m.TypeIds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCipRRData(structType any) CipRRData {
	if casted, ok := structType.(CipRRData); ok {
		return casted
	}
	if casted, ok := structType.(*CipRRData); ok {
		return *casted
	}
	return nil
}

func (m *_CipRRData) GetTypeName() string {
	return "CipRRData"
}

func (m *_CipRRData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.EipPacketContract.(*_EipPacket).getLengthInBits(ctx))

	// Simple field (interfaceHandle)
	lengthInBits += 32

	// Simple field (timeout)
	lengthInBits += 16

	// Implicit Field (typeIdCount)
	lengthInBits += 16

	// Array field
	if len(m.TypeIds) > 0 {
		for _curItem, element := range m.TypeIds {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.TypeIds), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_CipRRData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CipRRData) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_EipPacket, response bool) (__cipRRData CipRRData, err error) {
	m.EipPacketContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CipRRData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CipRRData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	interfaceHandle, err := ReadSimpleField(ctx, "interfaceHandle", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'interfaceHandle' field"))
	}
	m.InterfaceHandle = interfaceHandle

	timeout, err := ReadSimpleField(ctx, "timeout", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeout' field"))
	}
	m.Timeout = timeout

	typeIdCount, err := ReadImplicitField[uint16](ctx, "typeIdCount", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'typeIdCount' field"))
	}
	_ = typeIdCount

	typeIds, err := ReadCountArrayField[TypeId](ctx, "typeIds", ReadComplex[TypeId](TypeIdParseWithBuffer, readBuffer), uint64(typeIdCount))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'typeIds' field"))
	}
	m.TypeIds = typeIds

	if closeErr := readBuffer.CloseContext("CipRRData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CipRRData")
	}

	return m, nil
}

func (m *_CipRRData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CipRRData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CipRRData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CipRRData")
		}

		if err := WriteSimpleField[uint32](ctx, "interfaceHandle", m.GetInterfaceHandle(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'interfaceHandle' field")
		}

		if err := WriteSimpleField[uint16](ctx, "timeout", m.GetTimeout(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'timeout' field")
		}
		typeIdCount := uint16(uint16(len(m.GetTypeIds())))
		if err := WriteImplicitField(ctx, "typeIdCount", typeIdCount, WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'typeIdCount' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "typeIds", m.GetTypeIds(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'typeIds' field")
		}

		if popErr := writeBuffer.PopContext("CipRRData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CipRRData")
		}
		return nil
	}
	return m.EipPacketContract.(*_EipPacket).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CipRRData) IsCipRRData() {}

func (m *_CipRRData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CipRRData) deepCopy() *_CipRRData {
	if m == nil {
		return nil
	}
	_CipRRDataCopy := &_CipRRData{
		m.EipPacketContract.(*_EipPacket).deepCopy(),
		m.InterfaceHandle,
		m.Timeout,
		utils.DeepCopySlice[TypeId, TypeId](m.TypeIds),
	}
	_CipRRDataCopy.EipPacketContract.(*_EipPacket)._SubType = m
	return _CipRRDataCopy
}

func (m *_CipRRData) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
