/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ZoneStatus is the corresponding interface of ZoneStatus
type ZoneStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetValue returns Value (property field)
	GetValue() ZoneStatusTemp
	// IsZoneStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsZoneStatus()
	// CreateBuilder creates a ZoneStatusBuilder
	CreateZoneStatusBuilder() ZoneStatusBuilder
}

// _ZoneStatus is the data-structure of this message
type _ZoneStatus struct {
	Value ZoneStatusTemp
}

var _ ZoneStatus = (*_ZoneStatus)(nil)

// NewZoneStatus factory function for _ZoneStatus
func NewZoneStatus(value ZoneStatusTemp) *_ZoneStatus {
	return &_ZoneStatus{Value: value}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ZoneStatusBuilder is a builder for ZoneStatus
type ZoneStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value ZoneStatusTemp) ZoneStatusBuilder
	// WithValue adds Value (property field)
	WithValue(ZoneStatusTemp) ZoneStatusBuilder
	// Build builds the ZoneStatus or returns an error if something is wrong
	Build() (ZoneStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ZoneStatus
}

// NewZoneStatusBuilder() creates a ZoneStatusBuilder
func NewZoneStatusBuilder() ZoneStatusBuilder {
	return &_ZoneStatusBuilder{_ZoneStatus: new(_ZoneStatus)}
}

type _ZoneStatusBuilder struct {
	*_ZoneStatus

	err *utils.MultiError
}

var _ (ZoneStatusBuilder) = (*_ZoneStatusBuilder)(nil)

func (b *_ZoneStatusBuilder) WithMandatoryFields(value ZoneStatusTemp) ZoneStatusBuilder {
	return b.WithValue(value)
}

func (b *_ZoneStatusBuilder) WithValue(value ZoneStatusTemp) ZoneStatusBuilder {
	b.Value = value
	return b
}

func (b *_ZoneStatusBuilder) Build() (ZoneStatus, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ZoneStatus.deepCopy(), nil
}

func (b *_ZoneStatusBuilder) MustBuild() ZoneStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ZoneStatusBuilder) DeepCopy() any {
	_copy := b.CreateZoneStatusBuilder().(*_ZoneStatusBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateZoneStatusBuilder creates a ZoneStatusBuilder
func (b *_ZoneStatus) CreateZoneStatusBuilder() ZoneStatusBuilder {
	if b == nil {
		return NewZoneStatusBuilder()
	}
	return &_ZoneStatusBuilder{_ZoneStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ZoneStatus) GetValue() ZoneStatusTemp {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastZoneStatus(structType any) ZoneStatus {
	if casted, ok := structType.(ZoneStatus); ok {
		return casted
	}
	if casted, ok := structType.(*ZoneStatus); ok {
		return *casted
	}
	return nil
}

func (m *_ZoneStatus) GetTypeName() string {
	return "ZoneStatus"
}

func (m *_ZoneStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (value)
	lengthInBits += 2

	return lengthInBits
}

func (m *_ZoneStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ZoneStatusParse(ctx context.Context, theBytes []byte) (ZoneStatus, error) {
	return ZoneStatusParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ZoneStatusParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ZoneStatus, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ZoneStatus, error) {
		return ZoneStatusParseWithBuffer(ctx, readBuffer)
	}
}

func ZoneStatusParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ZoneStatus, error) {
	v, err := (&_ZoneStatus{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ZoneStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__zoneStatus ZoneStatus, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ZoneStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ZoneStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	value, err := ReadEnumField[ZoneStatusTemp](ctx, "value", "ZoneStatusTemp", ReadEnum(ZoneStatusTempByValue, ReadUnsignedByte(readBuffer, uint8(2))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("ZoneStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ZoneStatus")
	}

	return m, nil
}

func (m *_ZoneStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ZoneStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ZoneStatus"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ZoneStatus")
	}

	if err := WriteSimpleEnumField[ZoneStatusTemp](ctx, "value", "ZoneStatusTemp", m.GetValue(), WriteEnum[ZoneStatusTemp, uint8](ZoneStatusTemp.GetValue, ZoneStatusTemp.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 2))); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("ZoneStatus"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ZoneStatus")
	}
	return nil
}

func (m *_ZoneStatus) IsZoneStatus() {}

func (m *_ZoneStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ZoneStatus) deepCopy() *_ZoneStatus {
	if m == nil {
		return nil
	}
	_ZoneStatusCopy := &_ZoneStatus{
		m.Value,
	}
	return _ZoneStatusCopy
}

func (m *_ZoneStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
