/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TriggerControlDataTriggerMin is the corresponding interface of TriggerControlDataTriggerMin
type TriggerControlDataTriggerMin interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	TriggerControlData
	// IsTriggerControlDataTriggerMin is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTriggerControlDataTriggerMin()
	// CreateBuilder creates a TriggerControlDataTriggerMinBuilder
	CreateTriggerControlDataTriggerMinBuilder() TriggerControlDataTriggerMinBuilder
}

// _TriggerControlDataTriggerMin is the data-structure of this message
type _TriggerControlDataTriggerMin struct {
	TriggerControlDataContract
}

var _ TriggerControlDataTriggerMin = (*_TriggerControlDataTriggerMin)(nil)
var _ TriggerControlDataRequirements = (*_TriggerControlDataTriggerMin)(nil)

// NewTriggerControlDataTriggerMin factory function for _TriggerControlDataTriggerMin
func NewTriggerControlDataTriggerMin(commandTypeContainer TriggerControlCommandTypeContainer, triggerGroup byte) *_TriggerControlDataTriggerMin {
	_result := &_TriggerControlDataTriggerMin{
		TriggerControlDataContract: NewTriggerControlData(commandTypeContainer, triggerGroup),
	}
	_result.TriggerControlDataContract.(*_TriggerControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TriggerControlDataTriggerMinBuilder is a builder for TriggerControlDataTriggerMin
type TriggerControlDataTriggerMinBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() TriggerControlDataTriggerMinBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() TriggerControlDataBuilder
	// Build builds the TriggerControlDataTriggerMin or returns an error if something is wrong
	Build() (TriggerControlDataTriggerMin, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TriggerControlDataTriggerMin
}

// NewTriggerControlDataTriggerMinBuilder() creates a TriggerControlDataTriggerMinBuilder
func NewTriggerControlDataTriggerMinBuilder() TriggerControlDataTriggerMinBuilder {
	return &_TriggerControlDataTriggerMinBuilder{_TriggerControlDataTriggerMin: new(_TriggerControlDataTriggerMin)}
}

type _TriggerControlDataTriggerMinBuilder struct {
	*_TriggerControlDataTriggerMin

	parentBuilder *_TriggerControlDataBuilder

	err *utils.MultiError
}

var _ (TriggerControlDataTriggerMinBuilder) = (*_TriggerControlDataTriggerMinBuilder)(nil)

func (b *_TriggerControlDataTriggerMinBuilder) setParent(contract TriggerControlDataContract) {
	b.TriggerControlDataContract = contract
	contract.(*_TriggerControlData)._SubType = b._TriggerControlDataTriggerMin
}

func (b *_TriggerControlDataTriggerMinBuilder) WithMandatoryFields() TriggerControlDataTriggerMinBuilder {
	return b
}

func (b *_TriggerControlDataTriggerMinBuilder) Build() (TriggerControlDataTriggerMin, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._TriggerControlDataTriggerMin.deepCopy(), nil
}

func (b *_TriggerControlDataTriggerMinBuilder) MustBuild() TriggerControlDataTriggerMin {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TriggerControlDataTriggerMinBuilder) Done() TriggerControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewTriggerControlDataBuilder().(*_TriggerControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_TriggerControlDataTriggerMinBuilder) buildForTriggerControlData() (TriggerControlData, error) {
	return b.Build()
}

func (b *_TriggerControlDataTriggerMinBuilder) DeepCopy() any {
	_copy := b.CreateTriggerControlDataTriggerMinBuilder().(*_TriggerControlDataTriggerMinBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateTriggerControlDataTriggerMinBuilder creates a TriggerControlDataTriggerMinBuilder
func (b *_TriggerControlDataTriggerMin) CreateTriggerControlDataTriggerMinBuilder() TriggerControlDataTriggerMinBuilder {
	if b == nil {
		return NewTriggerControlDataTriggerMinBuilder()
	}
	return &_TriggerControlDataTriggerMinBuilder{_TriggerControlDataTriggerMin: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TriggerControlDataTriggerMin) GetParent() TriggerControlDataContract {
	return m.TriggerControlDataContract
}

// Deprecated: use the interface for direct cast
func CastTriggerControlDataTriggerMin(structType any) TriggerControlDataTriggerMin {
	if casted, ok := structType.(TriggerControlDataTriggerMin); ok {
		return casted
	}
	if casted, ok := structType.(*TriggerControlDataTriggerMin); ok {
		return *casted
	}
	return nil
}

func (m *_TriggerControlDataTriggerMin) GetTypeName() string {
	return "TriggerControlDataTriggerMin"
}

func (m *_TriggerControlDataTriggerMin) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.TriggerControlDataContract.(*_TriggerControlData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_TriggerControlDataTriggerMin) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TriggerControlDataTriggerMin) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_TriggerControlData) (__triggerControlDataTriggerMin TriggerControlDataTriggerMin, err error) {
	m.TriggerControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TriggerControlDataTriggerMin"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TriggerControlDataTriggerMin")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TriggerControlDataTriggerMin"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TriggerControlDataTriggerMin")
	}

	return m, nil
}

func (m *_TriggerControlDataTriggerMin) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TriggerControlDataTriggerMin) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TriggerControlDataTriggerMin"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TriggerControlDataTriggerMin")
		}

		if popErr := writeBuffer.PopContext("TriggerControlDataTriggerMin"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TriggerControlDataTriggerMin")
		}
		return nil
	}
	return m.TriggerControlDataContract.(*_TriggerControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TriggerControlDataTriggerMin) IsTriggerControlDataTriggerMin() {}

func (m *_TriggerControlDataTriggerMin) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TriggerControlDataTriggerMin) deepCopy() *_TriggerControlDataTriggerMin {
	if m == nil {
		return nil
	}
	_TriggerControlDataTriggerMinCopy := &_TriggerControlDataTriggerMin{
		m.TriggerControlDataContract.(*_TriggerControlData).deepCopy(),
	}
	_TriggerControlDataTriggerMinCopy.TriggerControlDataContract.(*_TriggerControlData)._SubType = m
	return _TriggerControlDataTriggerMinCopy
}

func (m *_TriggerControlDataTriggerMin) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
