/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataZoneOpen is the corresponding interface of SecurityDataZoneOpen
type SecurityDataZoneOpen interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// GetZoneNumber returns ZoneNumber (property field)
	GetZoneNumber() uint8
	// IsSecurityDataZoneOpen is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataZoneOpen()
	// CreateBuilder creates a SecurityDataZoneOpenBuilder
	CreateSecurityDataZoneOpenBuilder() SecurityDataZoneOpenBuilder
}

// _SecurityDataZoneOpen is the data-structure of this message
type _SecurityDataZoneOpen struct {
	SecurityDataContract
	ZoneNumber uint8
}

var _ SecurityDataZoneOpen = (*_SecurityDataZoneOpen)(nil)
var _ SecurityDataRequirements = (*_SecurityDataZoneOpen)(nil)

// NewSecurityDataZoneOpen factory function for _SecurityDataZoneOpen
func NewSecurityDataZoneOpen(commandTypeContainer SecurityCommandTypeContainer, argument byte, zoneNumber uint8) *_SecurityDataZoneOpen {
	_result := &_SecurityDataZoneOpen{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
		ZoneNumber:           zoneNumber,
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataZoneOpenBuilder is a builder for SecurityDataZoneOpen
type SecurityDataZoneOpenBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneNumber uint8) SecurityDataZoneOpenBuilder
	// WithZoneNumber adds ZoneNumber (property field)
	WithZoneNumber(uint8) SecurityDataZoneOpenBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataZoneOpen or returns an error if something is wrong
	Build() (SecurityDataZoneOpen, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataZoneOpen
}

// NewSecurityDataZoneOpenBuilder() creates a SecurityDataZoneOpenBuilder
func NewSecurityDataZoneOpenBuilder() SecurityDataZoneOpenBuilder {
	return &_SecurityDataZoneOpenBuilder{_SecurityDataZoneOpen: new(_SecurityDataZoneOpen)}
}

type _SecurityDataZoneOpenBuilder struct {
	*_SecurityDataZoneOpen

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataZoneOpenBuilder) = (*_SecurityDataZoneOpenBuilder)(nil)

func (b *_SecurityDataZoneOpenBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataZoneOpen
}

func (b *_SecurityDataZoneOpenBuilder) WithMandatoryFields(zoneNumber uint8) SecurityDataZoneOpenBuilder {
	return b.WithZoneNumber(zoneNumber)
}

func (b *_SecurityDataZoneOpenBuilder) WithZoneNumber(zoneNumber uint8) SecurityDataZoneOpenBuilder {
	b.ZoneNumber = zoneNumber
	return b
}

func (b *_SecurityDataZoneOpenBuilder) Build() (SecurityDataZoneOpen, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataZoneOpen.deepCopy(), nil
}

func (b *_SecurityDataZoneOpenBuilder) MustBuild() SecurityDataZoneOpen {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataZoneOpenBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataZoneOpenBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataZoneOpenBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataZoneOpenBuilder().(*_SecurityDataZoneOpenBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataZoneOpenBuilder creates a SecurityDataZoneOpenBuilder
func (b *_SecurityDataZoneOpen) CreateSecurityDataZoneOpenBuilder() SecurityDataZoneOpenBuilder {
	if b == nil {
		return NewSecurityDataZoneOpenBuilder()
	}
	return &_SecurityDataZoneOpenBuilder{_SecurityDataZoneOpen: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataZoneOpen) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SecurityDataZoneOpen) GetZoneNumber() uint8 {
	return m.ZoneNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSecurityDataZoneOpen(structType any) SecurityDataZoneOpen {
	if casted, ok := structType.(SecurityDataZoneOpen); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataZoneOpen); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataZoneOpen) GetTypeName() string {
	return "SecurityDataZoneOpen"
}

func (m *_SecurityDataZoneOpen) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	// Simple field (zoneNumber)
	lengthInBits += 8

	return lengthInBits
}

func (m *_SecurityDataZoneOpen) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataZoneOpen) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataZoneOpen SecurityDataZoneOpen, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataZoneOpen"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataZoneOpen")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneNumber, err := ReadSimpleField(ctx, "zoneNumber", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneNumber' field"))
	}
	m.ZoneNumber = zoneNumber

	if closeErr := readBuffer.CloseContext("SecurityDataZoneOpen"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataZoneOpen")
	}

	return m, nil
}

func (m *_SecurityDataZoneOpen) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataZoneOpen) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataZoneOpen"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataZoneOpen")
		}

		if err := WriteSimpleField[uint8](ctx, "zoneNumber", m.GetZoneNumber(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneNumber' field")
		}

		if popErr := writeBuffer.PopContext("SecurityDataZoneOpen"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataZoneOpen")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataZoneOpen) IsSecurityDataZoneOpen() {}

func (m *_SecurityDataZoneOpen) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataZoneOpen) deepCopy() *_SecurityDataZoneOpen {
	if m == nil {
		return nil
	}
	_SecurityDataZoneOpenCopy := &_SecurityDataZoneOpen{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
		m.ZoneNumber,
	}
	_SecurityDataZoneOpenCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataZoneOpenCopy
}

func (m *_SecurityDataZoneOpen) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
