/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataStatusReport2 is the corresponding interface of SecurityDataStatusReport2
type SecurityDataStatusReport2 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// GetZoneStatus returns ZoneStatus (property field)
	GetZoneStatus() []ZoneStatus
	// IsSecurityDataStatusReport2 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataStatusReport2()
	// CreateBuilder creates a SecurityDataStatusReport2Builder
	CreateSecurityDataStatusReport2Builder() SecurityDataStatusReport2Builder
}

// _SecurityDataStatusReport2 is the data-structure of this message
type _SecurityDataStatusReport2 struct {
	SecurityDataContract
	ZoneStatus []ZoneStatus
}

var _ SecurityDataStatusReport2 = (*_SecurityDataStatusReport2)(nil)
var _ SecurityDataRequirements = (*_SecurityDataStatusReport2)(nil)

// NewSecurityDataStatusReport2 factory function for _SecurityDataStatusReport2
func NewSecurityDataStatusReport2(commandTypeContainer SecurityCommandTypeContainer, argument byte, zoneStatus []ZoneStatus) *_SecurityDataStatusReport2 {
	_result := &_SecurityDataStatusReport2{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
		ZoneStatus:           zoneStatus,
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataStatusReport2Builder is a builder for SecurityDataStatusReport2
type SecurityDataStatusReport2Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneStatus []ZoneStatus) SecurityDataStatusReport2Builder
	// WithZoneStatus adds ZoneStatus (property field)
	WithZoneStatus(...ZoneStatus) SecurityDataStatusReport2Builder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataStatusReport2 or returns an error if something is wrong
	Build() (SecurityDataStatusReport2, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataStatusReport2
}

// NewSecurityDataStatusReport2Builder() creates a SecurityDataStatusReport2Builder
func NewSecurityDataStatusReport2Builder() SecurityDataStatusReport2Builder {
	return &_SecurityDataStatusReport2Builder{_SecurityDataStatusReport2: new(_SecurityDataStatusReport2)}
}

type _SecurityDataStatusReport2Builder struct {
	*_SecurityDataStatusReport2

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataStatusReport2Builder) = (*_SecurityDataStatusReport2Builder)(nil)

func (b *_SecurityDataStatusReport2Builder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataStatusReport2
}

func (b *_SecurityDataStatusReport2Builder) WithMandatoryFields(zoneStatus []ZoneStatus) SecurityDataStatusReport2Builder {
	return b.WithZoneStatus(zoneStatus...)
}

func (b *_SecurityDataStatusReport2Builder) WithZoneStatus(zoneStatus ...ZoneStatus) SecurityDataStatusReport2Builder {
	b.ZoneStatus = zoneStatus
	return b
}

func (b *_SecurityDataStatusReport2Builder) Build() (SecurityDataStatusReport2, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataStatusReport2.deepCopy(), nil
}

func (b *_SecurityDataStatusReport2Builder) MustBuild() SecurityDataStatusReport2 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataStatusReport2Builder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataStatusReport2Builder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataStatusReport2Builder) DeepCopy() any {
	_copy := b.CreateSecurityDataStatusReport2Builder().(*_SecurityDataStatusReport2Builder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataStatusReport2Builder creates a SecurityDataStatusReport2Builder
func (b *_SecurityDataStatusReport2) CreateSecurityDataStatusReport2Builder() SecurityDataStatusReport2Builder {
	if b == nil {
		return NewSecurityDataStatusReport2Builder()
	}
	return &_SecurityDataStatusReport2Builder{_SecurityDataStatusReport2: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataStatusReport2) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SecurityDataStatusReport2) GetZoneStatus() []ZoneStatus {
	return m.ZoneStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSecurityDataStatusReport2(structType any) SecurityDataStatusReport2 {
	if casted, ok := structType.(SecurityDataStatusReport2); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataStatusReport2); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataStatusReport2) GetTypeName() string {
	return "SecurityDataStatusReport2"
}

func (m *_SecurityDataStatusReport2) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	// Array field
	if len(m.ZoneStatus) > 0 {
		for _curItem, element := range m.ZoneStatus {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ZoneStatus), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_SecurityDataStatusReport2) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataStatusReport2) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataStatusReport2 SecurityDataStatusReport2, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataStatusReport2"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataStatusReport2")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneStatus, err := ReadCountArrayField[ZoneStatus](ctx, "zoneStatus", ReadComplex[ZoneStatus](ZoneStatusParseWithBuffer, readBuffer), uint64(int32(48)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneStatus' field"))
	}
	m.ZoneStatus = zoneStatus

	if closeErr := readBuffer.CloseContext("SecurityDataStatusReport2"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataStatusReport2")
	}

	return m, nil
}

func (m *_SecurityDataStatusReport2) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataStatusReport2) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataStatusReport2"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataStatusReport2")
		}

		if err := WriteComplexTypeArrayField(ctx, "zoneStatus", m.GetZoneStatus(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneStatus' field")
		}

		if popErr := writeBuffer.PopContext("SecurityDataStatusReport2"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataStatusReport2")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataStatusReport2) IsSecurityDataStatusReport2() {}

func (m *_SecurityDataStatusReport2) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataStatusReport2) deepCopy() *_SecurityDataStatusReport2 {
	if m == nil {
		return nil
	}
	_SecurityDataStatusReport2Copy := &_SecurityDataStatusReport2{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
		utils.DeepCopySlice[ZoneStatus, ZoneStatus](m.ZoneStatus),
	}
	_SecurityDataStatusReport2Copy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataStatusReport2Copy
}

func (m *_SecurityDataStatusReport2) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
