/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataDropTamper is the corresponding interface of SecurityDataDropTamper
type SecurityDataDropTamper interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataDropTamper is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataDropTamper()
	// CreateBuilder creates a SecurityDataDropTamperBuilder
	CreateSecurityDataDropTamperBuilder() SecurityDataDropTamperBuilder
}

// _SecurityDataDropTamper is the data-structure of this message
type _SecurityDataDropTamper struct {
	SecurityDataContract
}

var _ SecurityDataDropTamper = (*_SecurityDataDropTamper)(nil)
var _ SecurityDataRequirements = (*_SecurityDataDropTamper)(nil)

// NewSecurityDataDropTamper factory function for _SecurityDataDropTamper
func NewSecurityDataDropTamper(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataDropTamper {
	_result := &_SecurityDataDropTamper{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataDropTamperBuilder is a builder for SecurityDataDropTamper
type SecurityDataDropTamperBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataDropTamperBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataDropTamper or returns an error if something is wrong
	Build() (SecurityDataDropTamper, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataDropTamper
}

// NewSecurityDataDropTamperBuilder() creates a SecurityDataDropTamperBuilder
func NewSecurityDataDropTamperBuilder() SecurityDataDropTamperBuilder {
	return &_SecurityDataDropTamperBuilder{_SecurityDataDropTamper: new(_SecurityDataDropTamper)}
}

type _SecurityDataDropTamperBuilder struct {
	*_SecurityDataDropTamper

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataDropTamperBuilder) = (*_SecurityDataDropTamperBuilder)(nil)

func (b *_SecurityDataDropTamperBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataDropTamper
}

func (b *_SecurityDataDropTamperBuilder) WithMandatoryFields() SecurityDataDropTamperBuilder {
	return b
}

func (b *_SecurityDataDropTamperBuilder) Build() (SecurityDataDropTamper, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataDropTamper.deepCopy(), nil
}

func (b *_SecurityDataDropTamperBuilder) MustBuild() SecurityDataDropTamper {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataDropTamperBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataDropTamperBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataDropTamperBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataDropTamperBuilder().(*_SecurityDataDropTamperBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataDropTamperBuilder creates a SecurityDataDropTamperBuilder
func (b *_SecurityDataDropTamper) CreateSecurityDataDropTamperBuilder() SecurityDataDropTamperBuilder {
	if b == nil {
		return NewSecurityDataDropTamperBuilder()
	}
	return &_SecurityDataDropTamperBuilder{_SecurityDataDropTamper: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataDropTamper) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataDropTamper(structType any) SecurityDataDropTamper {
	if casted, ok := structType.(SecurityDataDropTamper); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataDropTamper); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataDropTamper) GetTypeName() string {
	return "SecurityDataDropTamper"
}

func (m *_SecurityDataDropTamper) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataDropTamper) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataDropTamper) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataDropTamper SecurityDataDropTamper, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataDropTamper"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataDropTamper")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataDropTamper"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataDropTamper")
	}

	return m, nil
}

func (m *_SecurityDataDropTamper) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataDropTamper) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataDropTamper"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataDropTamper")
		}

		if popErr := writeBuffer.PopContext("SecurityDataDropTamper"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataDropTamper")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataDropTamper) IsSecurityDataDropTamper() {}

func (m *_SecurityDataDropTamper) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataDropTamper) deepCopy() *_SecurityDataDropTamper {
	if m == nil {
		return nil
	}
	_SecurityDataDropTamperCopy := &_SecurityDataDropTamper{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataDropTamperCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataDropTamperCopy
}

func (m *_SecurityDataDropTamper) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
