/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataArmFailedRaised is the corresponding interface of SecurityDataArmFailedRaised
type SecurityDataArmFailedRaised interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataArmFailedRaised is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataArmFailedRaised()
	// CreateBuilder creates a SecurityDataArmFailedRaisedBuilder
	CreateSecurityDataArmFailedRaisedBuilder() SecurityDataArmFailedRaisedBuilder
}

// _SecurityDataArmFailedRaised is the data-structure of this message
type _SecurityDataArmFailedRaised struct {
	SecurityDataContract
}

var _ SecurityDataArmFailedRaised = (*_SecurityDataArmFailedRaised)(nil)
var _ SecurityDataRequirements = (*_SecurityDataArmFailedRaised)(nil)

// NewSecurityDataArmFailedRaised factory function for _SecurityDataArmFailedRaised
func NewSecurityDataArmFailedRaised(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataArmFailedRaised {
	_result := &_SecurityDataArmFailedRaised{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataArmFailedRaisedBuilder is a builder for SecurityDataArmFailedRaised
type SecurityDataArmFailedRaisedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataArmFailedRaisedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataArmFailedRaised or returns an error if something is wrong
	Build() (SecurityDataArmFailedRaised, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataArmFailedRaised
}

// NewSecurityDataArmFailedRaisedBuilder() creates a SecurityDataArmFailedRaisedBuilder
func NewSecurityDataArmFailedRaisedBuilder() SecurityDataArmFailedRaisedBuilder {
	return &_SecurityDataArmFailedRaisedBuilder{_SecurityDataArmFailedRaised: new(_SecurityDataArmFailedRaised)}
}

type _SecurityDataArmFailedRaisedBuilder struct {
	*_SecurityDataArmFailedRaised

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataArmFailedRaisedBuilder) = (*_SecurityDataArmFailedRaisedBuilder)(nil)

func (b *_SecurityDataArmFailedRaisedBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataArmFailedRaised
}

func (b *_SecurityDataArmFailedRaisedBuilder) WithMandatoryFields() SecurityDataArmFailedRaisedBuilder {
	return b
}

func (b *_SecurityDataArmFailedRaisedBuilder) Build() (SecurityDataArmFailedRaised, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataArmFailedRaised.deepCopy(), nil
}

func (b *_SecurityDataArmFailedRaisedBuilder) MustBuild() SecurityDataArmFailedRaised {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataArmFailedRaisedBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataArmFailedRaisedBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataArmFailedRaisedBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataArmFailedRaisedBuilder().(*_SecurityDataArmFailedRaisedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataArmFailedRaisedBuilder creates a SecurityDataArmFailedRaisedBuilder
func (b *_SecurityDataArmFailedRaised) CreateSecurityDataArmFailedRaisedBuilder() SecurityDataArmFailedRaisedBuilder {
	if b == nil {
		return NewSecurityDataArmFailedRaisedBuilder()
	}
	return &_SecurityDataArmFailedRaisedBuilder{_SecurityDataArmFailedRaised: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataArmFailedRaised) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataArmFailedRaised(structType any) SecurityDataArmFailedRaised {
	if casted, ok := structType.(SecurityDataArmFailedRaised); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataArmFailedRaised); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataArmFailedRaised) GetTypeName() string {
	return "SecurityDataArmFailedRaised"
}

func (m *_SecurityDataArmFailedRaised) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataArmFailedRaised) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataArmFailedRaised) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataArmFailedRaised SecurityDataArmFailedRaised, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataArmFailedRaised"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataArmFailedRaised")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataArmFailedRaised"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataArmFailedRaised")
	}

	return m, nil
}

func (m *_SecurityDataArmFailedRaised) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataArmFailedRaised) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataArmFailedRaised"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataArmFailedRaised")
		}

		if popErr := writeBuffer.PopContext("SecurityDataArmFailedRaised"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataArmFailedRaised")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataArmFailedRaised) IsSecurityDataArmFailedRaised() {}

func (m *_SecurityDataArmFailedRaised) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataArmFailedRaised) deepCopy() *_SecurityDataArmFailedRaised {
	if m == nil {
		return nil
	}
	_SecurityDataArmFailedRaisedCopy := &_SecurityDataArmFailedRaised{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataArmFailedRaisedCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataArmFailedRaisedCopy
}

func (m *_SecurityDataArmFailedRaised) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
