/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataArmFailedCleared is the corresponding interface of SecurityDataArmFailedCleared
type SecurityDataArmFailedCleared interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataArmFailedCleared is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataArmFailedCleared()
	// CreateBuilder creates a SecurityDataArmFailedClearedBuilder
	CreateSecurityDataArmFailedClearedBuilder() SecurityDataArmFailedClearedBuilder
}

// _SecurityDataArmFailedCleared is the data-structure of this message
type _SecurityDataArmFailedCleared struct {
	SecurityDataContract
}

var _ SecurityDataArmFailedCleared = (*_SecurityDataArmFailedCleared)(nil)
var _ SecurityDataRequirements = (*_SecurityDataArmFailedCleared)(nil)

// NewSecurityDataArmFailedCleared factory function for _SecurityDataArmFailedCleared
func NewSecurityDataArmFailedCleared(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataArmFailedCleared {
	_result := &_SecurityDataArmFailedCleared{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataArmFailedClearedBuilder is a builder for SecurityDataArmFailedCleared
type SecurityDataArmFailedClearedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataArmFailedClearedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataArmFailedCleared or returns an error if something is wrong
	Build() (SecurityDataArmFailedCleared, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataArmFailedCleared
}

// NewSecurityDataArmFailedClearedBuilder() creates a SecurityDataArmFailedClearedBuilder
func NewSecurityDataArmFailedClearedBuilder() SecurityDataArmFailedClearedBuilder {
	return &_SecurityDataArmFailedClearedBuilder{_SecurityDataArmFailedCleared: new(_SecurityDataArmFailedCleared)}
}

type _SecurityDataArmFailedClearedBuilder struct {
	*_SecurityDataArmFailedCleared

	parentBuilder *_SecurityDataBuilder

	err *utils.MultiError
}

var _ (SecurityDataArmFailedClearedBuilder) = (*_SecurityDataArmFailedClearedBuilder)(nil)

func (b *_SecurityDataArmFailedClearedBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataArmFailedCleared
}

func (b *_SecurityDataArmFailedClearedBuilder) WithMandatoryFields() SecurityDataArmFailedClearedBuilder {
	return b
}

func (b *_SecurityDataArmFailedClearedBuilder) Build() (SecurityDataArmFailedCleared, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SecurityDataArmFailedCleared.deepCopy(), nil
}

func (b *_SecurityDataArmFailedClearedBuilder) MustBuild() SecurityDataArmFailedCleared {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataArmFailedClearedBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataArmFailedClearedBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataArmFailedClearedBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataArmFailedClearedBuilder().(*_SecurityDataArmFailedClearedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSecurityDataArmFailedClearedBuilder creates a SecurityDataArmFailedClearedBuilder
func (b *_SecurityDataArmFailedCleared) CreateSecurityDataArmFailedClearedBuilder() SecurityDataArmFailedClearedBuilder {
	if b == nil {
		return NewSecurityDataArmFailedClearedBuilder()
	}
	return &_SecurityDataArmFailedClearedBuilder{_SecurityDataArmFailedCleared: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataArmFailedCleared) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataArmFailedCleared(structType any) SecurityDataArmFailedCleared {
	if casted, ok := structType.(SecurityDataArmFailedCleared); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataArmFailedCleared); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataArmFailedCleared) GetTypeName() string {
	return "SecurityDataArmFailedCleared"
}

func (m *_SecurityDataArmFailedCleared) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataArmFailedCleared) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataArmFailedCleared) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataArmFailedCleared SecurityDataArmFailedCleared, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataArmFailedCleared"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataArmFailedCleared")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataArmFailedCleared"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataArmFailedCleared")
	}

	return m, nil
}

func (m *_SecurityDataArmFailedCleared) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataArmFailedCleared) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataArmFailedCleared"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataArmFailedCleared")
		}

		if popErr := writeBuffer.PopContext("SecurityDataArmFailedCleared"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataArmFailedCleared")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataArmFailedCleared) IsSecurityDataArmFailedCleared() {}

func (m *_SecurityDataArmFailedCleared) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataArmFailedCleared) deepCopy() *_SecurityDataArmFailedCleared {
	if m == nil {
		return nil
	}
	_SecurityDataArmFailedClearedCopy := &_SecurityDataArmFailedCleared{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataArmFailedClearedCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataArmFailedClearedCopy
}

func (m *_SecurityDataArmFailedCleared) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
