/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ParameterValueCustomManufacturer is the corresponding interface of ParameterValueCustomManufacturer
type ParameterValueCustomManufacturer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ParameterValue
	// GetValue returns Value (property field)
	GetValue() CustomManufacturer
	// IsParameterValueCustomManufacturer is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsParameterValueCustomManufacturer()
	// CreateBuilder creates a ParameterValueCustomManufacturerBuilder
	CreateParameterValueCustomManufacturerBuilder() ParameterValueCustomManufacturerBuilder
}

// _ParameterValueCustomManufacturer is the data-structure of this message
type _ParameterValueCustomManufacturer struct {
	ParameterValueContract
	Value CustomManufacturer
}

var _ ParameterValueCustomManufacturer = (*_ParameterValueCustomManufacturer)(nil)
var _ ParameterValueRequirements = (*_ParameterValueCustomManufacturer)(nil)

// NewParameterValueCustomManufacturer factory function for _ParameterValueCustomManufacturer
func NewParameterValueCustomManufacturer(value CustomManufacturer, numBytes uint8) *_ParameterValueCustomManufacturer {
	if value == nil {
		panic("value of type CustomManufacturer for ParameterValueCustomManufacturer must not be nil")
	}
	_result := &_ParameterValueCustomManufacturer{
		ParameterValueContract: NewParameterValue(numBytes),
		Value:                  value,
	}
	_result.ParameterValueContract.(*_ParameterValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ParameterValueCustomManufacturerBuilder is a builder for ParameterValueCustomManufacturer
type ParameterValueCustomManufacturerBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value CustomManufacturer) ParameterValueCustomManufacturerBuilder
	// WithValue adds Value (property field)
	WithValue(CustomManufacturer) ParameterValueCustomManufacturerBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(CustomManufacturerBuilder) CustomManufacturerBuilder) ParameterValueCustomManufacturerBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ParameterValueBuilder
	// Build builds the ParameterValueCustomManufacturer or returns an error if something is wrong
	Build() (ParameterValueCustomManufacturer, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ParameterValueCustomManufacturer
}

// NewParameterValueCustomManufacturerBuilder() creates a ParameterValueCustomManufacturerBuilder
func NewParameterValueCustomManufacturerBuilder() ParameterValueCustomManufacturerBuilder {
	return &_ParameterValueCustomManufacturerBuilder{_ParameterValueCustomManufacturer: new(_ParameterValueCustomManufacturer)}
}

type _ParameterValueCustomManufacturerBuilder struct {
	*_ParameterValueCustomManufacturer

	parentBuilder *_ParameterValueBuilder

	err *utils.MultiError
}

var _ (ParameterValueCustomManufacturerBuilder) = (*_ParameterValueCustomManufacturerBuilder)(nil)

func (b *_ParameterValueCustomManufacturerBuilder) setParent(contract ParameterValueContract) {
	b.ParameterValueContract = contract
	contract.(*_ParameterValue)._SubType = b._ParameterValueCustomManufacturer
}

func (b *_ParameterValueCustomManufacturerBuilder) WithMandatoryFields(value CustomManufacturer) ParameterValueCustomManufacturerBuilder {
	return b.WithValue(value)
}

func (b *_ParameterValueCustomManufacturerBuilder) WithValue(value CustomManufacturer) ParameterValueCustomManufacturerBuilder {
	b.Value = value
	return b
}

func (b *_ParameterValueCustomManufacturerBuilder) WithValueBuilder(builderSupplier func(CustomManufacturerBuilder) CustomManufacturerBuilder) ParameterValueCustomManufacturerBuilder {
	builder := builderSupplier(b.Value.CreateCustomManufacturerBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "CustomManufacturerBuilder failed"))
	}
	return b
}

func (b *_ParameterValueCustomManufacturerBuilder) Build() (ParameterValueCustomManufacturer, error) {
	if b.Value == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'value' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ParameterValueCustomManufacturer.deepCopy(), nil
}

func (b *_ParameterValueCustomManufacturerBuilder) MustBuild() ParameterValueCustomManufacturer {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ParameterValueCustomManufacturerBuilder) Done() ParameterValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewParameterValueBuilder().(*_ParameterValueBuilder)
	}
	return b.parentBuilder
}

func (b *_ParameterValueCustomManufacturerBuilder) buildForParameterValue() (ParameterValue, error) {
	return b.Build()
}

func (b *_ParameterValueCustomManufacturerBuilder) DeepCopy() any {
	_copy := b.CreateParameterValueCustomManufacturerBuilder().(*_ParameterValueCustomManufacturerBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateParameterValueCustomManufacturerBuilder creates a ParameterValueCustomManufacturerBuilder
func (b *_ParameterValueCustomManufacturer) CreateParameterValueCustomManufacturerBuilder() ParameterValueCustomManufacturerBuilder {
	if b == nil {
		return NewParameterValueCustomManufacturerBuilder()
	}
	return &_ParameterValueCustomManufacturerBuilder{_ParameterValueCustomManufacturer: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ParameterValueCustomManufacturer) GetParameterType() ParameterType {
	return ParameterType_CUSTOM_MANUFACTURER
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ParameterValueCustomManufacturer) GetParent() ParameterValueContract {
	return m.ParameterValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ParameterValueCustomManufacturer) GetValue() CustomManufacturer {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastParameterValueCustomManufacturer(structType any) ParameterValueCustomManufacturer {
	if casted, ok := structType.(ParameterValueCustomManufacturer); ok {
		return casted
	}
	if casted, ok := structType.(*ParameterValueCustomManufacturer); ok {
		return *casted
	}
	return nil
}

func (m *_ParameterValueCustomManufacturer) GetTypeName() string {
	return "ParameterValueCustomManufacturer"
}

func (m *_ParameterValueCustomManufacturer) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ParameterValueContract.(*_ParameterValue).getLengthInBits(ctx))

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ParameterValueCustomManufacturer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ParameterValueCustomManufacturer) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ParameterValue, parameterType ParameterType, numBytes uint8) (__parameterValueCustomManufacturer ParameterValueCustomManufacturer, err error) {
	m.ParameterValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ParameterValueCustomManufacturer"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ParameterValueCustomManufacturer")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	value, err := ReadSimpleField[CustomManufacturer](ctx, "value", ReadComplex[CustomManufacturer](CustomManufacturerParseWithBufferProducer((uint8)(numBytes)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("ParameterValueCustomManufacturer"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ParameterValueCustomManufacturer")
	}

	return m, nil
}

func (m *_ParameterValueCustomManufacturer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ParameterValueCustomManufacturer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ParameterValueCustomManufacturer"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ParameterValueCustomManufacturer")
		}

		if err := WriteSimpleField[CustomManufacturer](ctx, "value", m.GetValue(), WriteComplex[CustomManufacturer](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("ParameterValueCustomManufacturer"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ParameterValueCustomManufacturer")
		}
		return nil
	}
	return m.ParameterValueContract.(*_ParameterValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ParameterValueCustomManufacturer) IsParameterValueCustomManufacturer() {}

func (m *_ParameterValueCustomManufacturer) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ParameterValueCustomManufacturer) deepCopy() *_ParameterValueCustomManufacturer {
	if m == nil {
		return nil
	}
	_ParameterValueCustomManufacturerCopy := &_ParameterValueCustomManufacturer{
		m.ParameterValueContract.(*_ParameterValue).deepCopy(),
		utils.DeepCopy[CustomManufacturer](m.Value),
	}
	_ParameterValueCustomManufacturerCopy.ParameterValueContract.(*_ParameterValue)._SubType = m
	return _ParameterValueCustomManufacturerCopy
}

func (m *_ParameterValueCustomManufacturer) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
