/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NetworkProtocolControlInformation is the corresponding interface of NetworkProtocolControlInformation
type NetworkProtocolControlInformation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetStackCounter returns StackCounter (property field)
	GetStackCounter() uint8
	// GetStackDepth returns StackDepth (property field)
	GetStackDepth() uint8
	// IsNetworkProtocolControlInformation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNetworkProtocolControlInformation()
	// CreateBuilder creates a NetworkProtocolControlInformationBuilder
	CreateNetworkProtocolControlInformationBuilder() NetworkProtocolControlInformationBuilder
}

// _NetworkProtocolControlInformation is the data-structure of this message
type _NetworkProtocolControlInformation struct {
	StackCounter uint8
	StackDepth   uint8
	// Reserved Fields
	reservedField0 *uint8
}

var _ NetworkProtocolControlInformation = (*_NetworkProtocolControlInformation)(nil)

// NewNetworkProtocolControlInformation factory function for _NetworkProtocolControlInformation
func NewNetworkProtocolControlInformation(stackCounter uint8, stackDepth uint8) *_NetworkProtocolControlInformation {
	return &_NetworkProtocolControlInformation{StackCounter: stackCounter, StackDepth: stackDepth}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NetworkProtocolControlInformationBuilder is a builder for NetworkProtocolControlInformation
type NetworkProtocolControlInformationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(stackCounter uint8, stackDepth uint8) NetworkProtocolControlInformationBuilder
	// WithStackCounter adds StackCounter (property field)
	WithStackCounter(uint8) NetworkProtocolControlInformationBuilder
	// WithStackDepth adds StackDepth (property field)
	WithStackDepth(uint8) NetworkProtocolControlInformationBuilder
	// Build builds the NetworkProtocolControlInformation or returns an error if something is wrong
	Build() (NetworkProtocolControlInformation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NetworkProtocolControlInformation
}

// NewNetworkProtocolControlInformationBuilder() creates a NetworkProtocolControlInformationBuilder
func NewNetworkProtocolControlInformationBuilder() NetworkProtocolControlInformationBuilder {
	return &_NetworkProtocolControlInformationBuilder{_NetworkProtocolControlInformation: new(_NetworkProtocolControlInformation)}
}

type _NetworkProtocolControlInformationBuilder struct {
	*_NetworkProtocolControlInformation

	err *utils.MultiError
}

var _ (NetworkProtocolControlInformationBuilder) = (*_NetworkProtocolControlInformationBuilder)(nil)

func (b *_NetworkProtocolControlInformationBuilder) WithMandatoryFields(stackCounter uint8, stackDepth uint8) NetworkProtocolControlInformationBuilder {
	return b.WithStackCounter(stackCounter).WithStackDepth(stackDepth)
}

func (b *_NetworkProtocolControlInformationBuilder) WithStackCounter(stackCounter uint8) NetworkProtocolControlInformationBuilder {
	b.StackCounter = stackCounter
	return b
}

func (b *_NetworkProtocolControlInformationBuilder) WithStackDepth(stackDepth uint8) NetworkProtocolControlInformationBuilder {
	b.StackDepth = stackDepth
	return b
}

func (b *_NetworkProtocolControlInformationBuilder) Build() (NetworkProtocolControlInformation, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NetworkProtocolControlInformation.deepCopy(), nil
}

func (b *_NetworkProtocolControlInformationBuilder) MustBuild() NetworkProtocolControlInformation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NetworkProtocolControlInformationBuilder) DeepCopy() any {
	_copy := b.CreateNetworkProtocolControlInformationBuilder().(*_NetworkProtocolControlInformationBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNetworkProtocolControlInformationBuilder creates a NetworkProtocolControlInformationBuilder
func (b *_NetworkProtocolControlInformation) CreateNetworkProtocolControlInformationBuilder() NetworkProtocolControlInformationBuilder {
	if b == nil {
		return NewNetworkProtocolControlInformationBuilder()
	}
	return &_NetworkProtocolControlInformationBuilder{_NetworkProtocolControlInformation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NetworkProtocolControlInformation) GetStackCounter() uint8 {
	return m.StackCounter
}

func (m *_NetworkProtocolControlInformation) GetStackDepth() uint8 {
	return m.StackDepth
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNetworkProtocolControlInformation(structType any) NetworkProtocolControlInformation {
	if casted, ok := structType.(NetworkProtocolControlInformation); ok {
		return casted
	}
	if casted, ok := structType.(*NetworkProtocolControlInformation); ok {
		return *casted
	}
	return nil
}

func (m *_NetworkProtocolControlInformation) GetTypeName() string {
	return "NetworkProtocolControlInformation"
}

func (m *_NetworkProtocolControlInformation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 2

	// Simple field (stackCounter)
	lengthInBits += 3

	// Simple field (stackDepth)
	lengthInBits += 3

	return lengthInBits
}

func (m *_NetworkProtocolControlInformation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NetworkProtocolControlInformationParse(ctx context.Context, theBytes []byte) (NetworkProtocolControlInformation, error) {
	return NetworkProtocolControlInformationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func NetworkProtocolControlInformationParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (NetworkProtocolControlInformation, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (NetworkProtocolControlInformation, error) {
		return NetworkProtocolControlInformationParseWithBuffer(ctx, readBuffer)
	}
}

func NetworkProtocolControlInformationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (NetworkProtocolControlInformation, error) {
	v, err := (&_NetworkProtocolControlInformation{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_NetworkProtocolControlInformation) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__networkProtocolControlInformation NetworkProtocolControlInformation, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NetworkProtocolControlInformation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NetworkProtocolControlInformation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(2)), uint8(0x0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	stackCounter, err := ReadSimpleField(ctx, "stackCounter", ReadUnsignedByte(readBuffer, uint8(3)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'stackCounter' field"))
	}
	m.StackCounter = stackCounter

	stackDepth, err := ReadSimpleField(ctx, "stackDepth", ReadUnsignedByte(readBuffer, uint8(3)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'stackDepth' field"))
	}
	m.StackDepth = stackDepth

	if closeErr := readBuffer.CloseContext("NetworkProtocolControlInformation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NetworkProtocolControlInformation")
	}

	return m, nil
}

func (m *_NetworkProtocolControlInformation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NetworkProtocolControlInformation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("NetworkProtocolControlInformation"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for NetworkProtocolControlInformation")
	}

	if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x0), WriteUnsignedByte(writeBuffer, 2)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[uint8](ctx, "stackCounter", m.GetStackCounter(), WriteUnsignedByte(writeBuffer, 3)); err != nil {
		return errors.Wrap(err, "Error serializing 'stackCounter' field")
	}

	if err := WriteSimpleField[uint8](ctx, "stackDepth", m.GetStackDepth(), WriteUnsignedByte(writeBuffer, 3)); err != nil {
		return errors.Wrap(err, "Error serializing 'stackDepth' field")
	}

	if popErr := writeBuffer.PopContext("NetworkProtocolControlInformation"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for NetworkProtocolControlInformation")
	}
	return nil
}

func (m *_NetworkProtocolControlInformation) IsNetworkProtocolControlInformation() {}

func (m *_NetworkProtocolControlInformation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NetworkProtocolControlInformation) deepCopy() *_NetworkProtocolControlInformation {
	if m == nil {
		return nil
	}
	_NetworkProtocolControlInformationCopy := &_NetworkProtocolControlInformation{
		m.StackCounter,
		m.StackDepth,
		m.reservedField0,
	}
	return _NetworkProtocolControlInformationCopy
}

func (m *_NetworkProtocolControlInformation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
