/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MonitoredSAL is the corresponding interface of MonitoredSAL
type MonitoredSAL interface {
	MonitoredSALContract
	MonitoredSALRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsMonitoredSAL is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMonitoredSAL()
	// CreateBuilder creates a MonitoredSALBuilder
	CreateMonitoredSALBuilder() MonitoredSALBuilder
}

// MonitoredSALContract provides a set of functions which can be overwritten by a sub struct
type MonitoredSALContract interface {
	// GetSalType returns SalType (property field)
	GetSalType() byte
	// GetCBusOptions() returns a parser argument
	GetCBusOptions() CBusOptions
	// IsMonitoredSAL is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMonitoredSAL()
	// CreateBuilder creates a MonitoredSALBuilder
	CreateMonitoredSALBuilder() MonitoredSALBuilder
}

// MonitoredSALRequirements provides a set of functions which need to be implemented by a sub struct
type MonitoredSALRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetSalType returns SalType (discriminator field)
	GetSalType() byte
}

// _MonitoredSAL is the data-structure of this message
type _MonitoredSAL struct {
	_SubType interface {
		MonitoredSALContract
		MonitoredSALRequirements
	}
	SalType byte

	// Arguments.
	CBusOptions CBusOptions
}

var _ MonitoredSALContract = (*_MonitoredSAL)(nil)

// NewMonitoredSAL factory function for _MonitoredSAL
func NewMonitoredSAL(salType byte, cBusOptions CBusOptions) *_MonitoredSAL {
	return &_MonitoredSAL{SalType: salType, CBusOptions: cBusOptions}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MonitoredSALBuilder is a builder for MonitoredSAL
type MonitoredSALBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(salType byte) MonitoredSALBuilder
	// WithSalType adds SalType (property field)
	WithSalType(byte) MonitoredSALBuilder
	// WithArgCBusOptions sets a parser argument
	WithArgCBusOptions(CBusOptions) MonitoredSALBuilder
	// AsMonitoredSALLongFormSmartMode converts this build to a subType of MonitoredSAL. It is always possible to return to current builder using Done()
	AsMonitoredSALLongFormSmartMode() MonitoredSALLongFormSmartModeBuilder
	// AsMonitoredSALShortFormBasicMode converts this build to a subType of MonitoredSAL. It is always possible to return to current builder using Done()
	AsMonitoredSALShortFormBasicMode() MonitoredSALShortFormBasicModeBuilder
	// Build builds the MonitoredSAL or returns an error if something is wrong
	PartialBuild() (MonitoredSALContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() MonitoredSALContract
	// Build builds the MonitoredSAL or returns an error if something is wrong
	Build() (MonitoredSAL, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MonitoredSAL
}

// NewMonitoredSALBuilder() creates a MonitoredSALBuilder
func NewMonitoredSALBuilder() MonitoredSALBuilder {
	return &_MonitoredSALBuilder{_MonitoredSAL: new(_MonitoredSAL)}
}

type _MonitoredSALChildBuilder interface {
	utils.Copyable
	setParent(MonitoredSALContract)
	buildForMonitoredSAL() (MonitoredSAL, error)
}

type _MonitoredSALBuilder struct {
	*_MonitoredSAL

	childBuilder _MonitoredSALChildBuilder

	err *utils.MultiError
}

var _ (MonitoredSALBuilder) = (*_MonitoredSALBuilder)(nil)

func (b *_MonitoredSALBuilder) WithMandatoryFields(salType byte) MonitoredSALBuilder {
	return b.WithSalType(salType)
}

func (b *_MonitoredSALBuilder) WithSalType(salType byte) MonitoredSALBuilder {
	b.SalType = salType
	return b
}

func (b *_MonitoredSALBuilder) WithArgCBusOptions(cBusOptions CBusOptions) MonitoredSALBuilder {
	b.CBusOptions = cBusOptions
	return b
}

func (b *_MonitoredSALBuilder) PartialBuild() (MonitoredSALContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._MonitoredSAL.deepCopy(), nil
}

func (b *_MonitoredSALBuilder) PartialMustBuild() MonitoredSALContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MonitoredSALBuilder) AsMonitoredSALLongFormSmartMode() MonitoredSALLongFormSmartModeBuilder {
	if cb, ok := b.childBuilder.(MonitoredSALLongFormSmartModeBuilder); ok {
		return cb
	}
	cb := NewMonitoredSALLongFormSmartModeBuilder().(*_MonitoredSALLongFormSmartModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MonitoredSALBuilder) AsMonitoredSALShortFormBasicMode() MonitoredSALShortFormBasicModeBuilder {
	if cb, ok := b.childBuilder.(MonitoredSALShortFormBasicModeBuilder); ok {
		return cb
	}
	cb := NewMonitoredSALShortFormBasicModeBuilder().(*_MonitoredSALShortFormBasicModeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_MonitoredSALBuilder) Build() (MonitoredSAL, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForMonitoredSAL()
}

func (b *_MonitoredSALBuilder) MustBuild() MonitoredSAL {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MonitoredSALBuilder) DeepCopy() any {
	_copy := b.CreateMonitoredSALBuilder().(*_MonitoredSALBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_MonitoredSALChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateMonitoredSALBuilder creates a MonitoredSALBuilder
func (b *_MonitoredSAL) CreateMonitoredSALBuilder() MonitoredSALBuilder {
	if b == nil {
		return NewMonitoredSALBuilder()
	}
	return &_MonitoredSALBuilder{_MonitoredSAL: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MonitoredSAL) GetSalType() byte {
	return m.SalType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMonitoredSAL(structType any) MonitoredSAL {
	if casted, ok := structType.(MonitoredSAL); ok {
		return casted
	}
	if casted, ok := structType.(*MonitoredSAL); ok {
		return *casted
	}
	return nil
}

func (m *_MonitoredSAL) GetTypeName() string {
	return "MonitoredSAL"
}

func (m *_MonitoredSAL) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_MonitoredSAL) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_MonitoredSAL) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func MonitoredSALParse[T MonitoredSAL](ctx context.Context, theBytes []byte, cBusOptions CBusOptions) (T, error) {
	return MonitoredSALParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), cBusOptions)
}

func MonitoredSALParseWithBufferProducer[T MonitoredSAL](cBusOptions CBusOptions) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := MonitoredSALParseWithBuffer[T](ctx, readBuffer, cBusOptions)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func MonitoredSALParseWithBuffer[T MonitoredSAL](ctx context.Context, readBuffer utils.ReadBuffer, cBusOptions CBusOptions) (T, error) {
	v, err := (&_MonitoredSAL{CBusOptions: cBusOptions}).parse(ctx, readBuffer, cBusOptions)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_MonitoredSAL) parse(ctx context.Context, readBuffer utils.ReadBuffer, cBusOptions CBusOptions) (__monitoredSAL MonitoredSAL, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MonitoredSAL"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MonitoredSAL")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	salType, err := ReadPeekField[byte](ctx, "salType", ReadByte(readBuffer, 8), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'salType' field"))
	}
	m.SalType = salType

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child MonitoredSAL
	switch {
	case salType == 0x05: // MonitoredSALLongFormSmartMode
		if _child, err = new(_MonitoredSALLongFormSmartMode).parse(ctx, readBuffer, m, cBusOptions); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredSALLongFormSmartMode for type-switch of MonitoredSAL")
		}
	case 0 == 0: // MonitoredSALShortFormBasicMode
		if _child, err = new(_MonitoredSALShortFormBasicMode).parse(ctx, readBuffer, m, cBusOptions); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type MonitoredSALShortFormBasicMode for type-switch of MonitoredSAL")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [salType=%v]", salType)
	}

	if closeErr := readBuffer.CloseContext("MonitoredSAL"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MonitoredSAL")
	}

	return _child, nil
}

func (pm *_MonitoredSAL) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child MonitoredSAL, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("MonitoredSAL"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for MonitoredSAL")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("MonitoredSAL"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for MonitoredSAL")
	}
	return nil
}

////
// Arguments Getter

func (m *_MonitoredSAL) GetCBusOptions() CBusOptions {
	return m.CBusOptions
}

//
////

func (m *_MonitoredSAL) IsMonitoredSAL() {}

func (m *_MonitoredSAL) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MonitoredSAL) deepCopy() *_MonitoredSAL {
	if m == nil {
		return nil
	}
	_MonitoredSALCopy := &_MonitoredSAL{
		nil, // will be set by child
		m.SalType,
		m.CBusOptions,
	}
	return _MonitoredSALCopy
}
